

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/cvEntitySearchInsertCloudStorageAccounts.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/cvEntitySearchInsertCloudStorageAccounts.sp,v $ $Id: cvEntitySearchInsertCloudStorageAccounts.sp,v 1.1.2.2 2019/11/15 05:48:09 surajbharech Exp $";
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='cvEntitySearchInsertCloudStorageAccounts')
BEGIN
	print '>>> Drop Stored Procedure: cvEntitySearchInsertCloudStorageAccounts <<<'
	drop procedure cvEntitySearchInsertCloudStorageAccounts
END
IF EXISTS (select * from GxQscripts where name='cvEntitySearchInsertCloudStorageAccounts')
	delete from GxQscripts where name = 'cvEntitySearchInsertCloudStorageAccounts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='cvEntitySearchInsertCloudStorageAccounts')
	delete from GXDBVersions where aliasname = 'cvEntitySearchInsertCloudStorageAccounts'
GO
print '... Creating Procedure: cvEntitySearchInsertCloudStorageAccounts'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure cvEntitySearchInsertCloudStorageAccounts
  @userId INT,
  @searchType INT,
  @entityId INT = 0
AS
	SET NOCOUNT ON;
	DECLARE @cloudStorageAccountsReq XML = '<Api_CloudStorageAccountsReq><processinginstructioninfo> <user userId="'+CAST(@userId AS NVARCHAR(255))+'"/></processinginstructioninfo></Api_CloudStorageAccountsReq>'
	DECLARE @cloudStorageAccountsResp XML
	IF OBJECT_ID('tempdb.dbo.#cloudStorageAccountsOut') IS NOT NULL DROP TABLE #cloudStorageAccountsOut
		   CREATE TABLE #cloudStorageAccountsOut(cloudStorageAccountsInfo XML)
	EXEC  [dbo].[AppGetCloudObjStorageAccounts]  @cloudStorageAccountsReq
	SELECT @cloudStorageAccountsResp = cloudStorageAccountsInfo FROM #cloudStorageAccountsOut
	INSERT INTO #CVEntitySearchTempTable
		(
		[name],
		[search_id]
	)
	SELECT
		CSA.N.value('@instanceName', 'NVARCHAR(255)') as name,
		CSA.N.value('@instanceId', 'NVARCHAR(255)') as search_id
		FROM @cloudStorageAccountsResp.nodes('/Api_CloudStorageAccountsResp/account/instance') as CSA(N)
	DROP TABLE #cloudStorageAccountsOut
GO

IF EXISTS (select * from GxQscripts where name = 'cvEntitySearchInsertCloudStorageAccounts')
	delete from GxQscripts where name = 'cvEntitySearchInsertCloudStorageAccounts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='cvEntitySearchInsertCloudStorageAccounts')
	delete from GXDBVersions where aliasname = 'cvEntitySearchInsertCloudStorageAccounts'
GO

insert into GXDBVersions values(2, 'cvEntitySearchInsertCloudStorageAccounts',  '00010001000200020000', 'cvEntitySearchInsertCloudStorageAccounts', '00010001000200020000')
GO

