

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/cvEntitySearchGetUserCommcell.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/cvEntitySearchGetUserCommcell.sp,v $ $Id: cvEntitySearchGetUserCommcell.sp,v 1.1.2.1 2020/03/23 22:59:35 cnaik Exp $";
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='cvEntitySearchGetUserCommcell')
BEGIN
	print '>>> Drop Stored Procedure: cvEntitySearchGetUserCommcell <<<'
	drop procedure cvEntitySearchGetUserCommcell
END
IF EXISTS (select * from GxQscripts where name='cvEntitySearchGetUserCommcell')
	delete from GxQscripts where name = 'cvEntitySearchGetUserCommcell'
GO

IF EXISTS (select * from GXDBVersions where aliasname='cvEntitySearchGetUserCommcell')
	delete from GXDBVersions where aliasname = 'cvEntitySearchGetUserCommcell'
GO
print '... Creating Procedure: cvEntitySearchGetUserCommcell'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure cvEntitySearchGetUserCommcell
  @userId INT,
  @xmlOutput XML OUTPUT
AS
-- SET NOCOUNT ON added to prevent extra result sets from
-- interfering with SELECT statements.
SET NOCOUNT ON;
DECLARE @resp XML
CREATE TABLE #temp(xmlRes xml)
INSERT #temp (xmlRes)
EXEC MCC_GetServiceCommcellListForUserXML @userId
set @resp = ( select xmlRes from #temp)
create table #temptable(commcellId int, csGUID NVARCHAR(400), csWebURL NVARCHAR(2048))
insert into #temptable(commcellId, csGUID,csWebURL)
SELECT
		Node.N.value('commcell[1]/@commCellId', 'int') as 'commcellId',
		Node.N.value('commcell[1]/@csGUID', 'NVARCHAR(400)') as 'csGUID',
		Node.N.value('@webUrl', 'NVARCHAR(2048)') as 'csWebURL'
FROM
		@resp.nodes('/CometIDPCommcellInfo/serviceCommcell') as Node(N)
	IF @userId = 1
	BEGIN
		declare @adminGuid nvarchar(400)
		set @adminGuid = (select userGuid from UMUsers where id =1)
		set @xmlOutput = (
		select
		'Administrator' AS [user/userName],
		'Administrator' AS [user/userEmail],
		@adminGuid AS [user/userGUID],
		APP_CommCell.id AS [commcell/commCellId],
		APP_CommCell.aliasName AS [commcell/name], #temptable.csGUID AS [commcell/csGUID], #temptable.csWebURL AS [commcell/commCellName]
		from
		APP_CommCell
		join #temptable  on APP_CommCell.id = #temptable.commCellId
		FOR XML PATH('commCellInfo'), ROOT('App_GlobalEntitySearchGetMultiCommCellUserDetails')
		)
	END
	ELSE
	BEGIN
		set @xmlOutput = (
		select
		UMUsersServiceCommcell.name AS [user/userName],
		UMUsersServiceCommcell.email AS [user/userEmail],
		UMUsersServiceCommcell.userGuid AS [user/userGUID],
		APP_CommCell.id AS [commcell/commCellId],
		APP_CommCell.aliasName AS [commcell/name], #temptable.csGUID AS [commcell/csGUID], #temptable.csWebURL AS [commcell/commCellName]
		from
		UMUsersServiceCommcell
		join UMUsers on UMUsers.userGuid = UMUsersServiceCommcell.userGuid
		join APP_CommCell on APP_CommCell.id = UMUsersServiceCommcell.origCCId
		join #temptable   on APP_CommCell.id = #temptable.commCellId
		where UMUsersServiceCommcell.origCCId in (select commcellId from #temptable)
		and UMUsers.id = @userId
		FOR XML PATH('commCellInfo'), ROOT('App_GlobalEntitySearchGetMultiCommCellUserDetails')
		)
	END
drop table #temptable
drop table #temp
GO

IF EXISTS (select * from GxQscripts where name = 'cvEntitySearchGetUserCommcell')
	delete from GxQscripts where name = 'cvEntitySearchGetUserCommcell'
GO

IF EXISTS (select * from GXDBVersions where aliasname='cvEntitySearchGetUserCommcell')
	delete from GXDBVersions where aliasname = 'cvEntitySearchGetUserCommcell'
GO

insert into GXDBVersions values(2, 'cvEntitySearchGetUserCommcell',  '00010001000200010000', 'cvEntitySearchGetUserCommcell', '00010001000200010000')
GO

