

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/cloneSchedulePolicy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/cloneSchedulePolicy.sp,v $ $Id: cloneSchedulePolicy.sp,v 1.13.294.2 2018/03/20 00:44:48 jiechen Exp $";
--
--  +========================================================================+
--  | Stored Precedure: cloneSchedulePolicy()
--  |
--  |   Revisions  Author     Description
--  |   ---------  -------    ---------------------------------------------
--  |   1.0        Muath Ali  Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: cloneSchedulePolicy <<<'

IF EXISTS (select * from sysobjects where name='cloneSchedulePolicy')
	drop procedure cloneSchedulePolicy
IF EXISTS (select * from GxQscripts where name='cloneSchedulePolicy')
	delete from GxQscripts where name = 'cloneSchedulePolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='cloneSchedulePolicy')
	delete from GXDBVersions where aliasname = 'cloneSchedulePolicy'
GO
print '... Creating Procedure: cloneSchedulePolicy'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure cloneSchedulePolicy
  @i_srcTempId INTEGER,
  @i_name char(128)
AS
  DECLARE @errCode INTEGER;
  DECLARE @errorString VARCHAR(1024);
DECLARE @templateId         INTEGER
DECLARE @templateInstanceId INTEGER
DECLARE @srcTempId          INTEGER
DECLARE @srcScheduleId      INTEGER
DECLARE @srcTaskId          INTEGER
DECLARE @srcInstId          INTEGER
DECLARE @scheduleId         INTEGER
DECLARE @taskId             INTEGER
DECLARE @tempType           INTEGER
DECLARE @retVal             INTEGER
DECLARE @srcActScheduleId   INTEGER
DECLARE @srcActTaskId       INTEGER
DECLARE @srcActInstId       INTEGER
-- This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SET @errCode = 0
BEGIN TRANSACTION
-- Declare cursor to copy template schedules
DECLARE CloneTemplateSchedules CURSOR LOCAL FORWARD_ONLY FOR
SELECT id, taskId, schedTemplateInstanceId
FROM   schedule
WHERE  taskType = 8
AND    schedTemplateInstanceId
IN     ( SELECT id FROM schedTemplateInstance WHERE schedTemplateId = @i_srcTempId)
--  Insert new template record, the template should be disabled
INSERT schedTemplate
SELECT 8, appType, @i_name, description, type , 0
FROM   schedTemplate
WHERE  id = @i_srcTempId
IF @@ERROR <> 0
   BEGIN
      SET @retVal = @@ERROR
      SET @errorString = 'Failed to insert into table schedTemplate.'
      GOTO CX_ERROR_EXIT
   END
SET @templateId = @@IDENTITY
SELECT @tempType = type
FROM   schedTemplate
WHERE  id = @templateId
OPEN CloneTemplateSchedules
FETCH FROM CloneTemplateSchedules INTO @srcScheduleId, @srcTaskId, @srcInstId
WHILE @@FETCH_STATUS = 0
BEGIN
   INSERT INTO schedTemplateInstance VALUES (@templateId)
   IF @@ERROR <> 0
   BEGIN
      SET @retVal = @@ERROR
      SET @errorString = 'Failed to insert into table schedTemplateInstance.'
      GOTO CX_ERROR_EXIT
   END
   SET @templateInstanceId = @@IDENTITY
   -- for this template schedule loop for all actual schedules and copy them
   DECLARE CloneActualSchedules CURSOR LOCAL FORWARD_ONLY FOR
   SELECT id, taskId, schedTemplateInstanceId
   FROM   schedule
   WHERE  taskType <> 8 /* execlude template schedules */
   AND    schedTemplateInstanceId
   IN     ( SELECT id FROM schedTemplateInstance WHERE schedTemplateId = @i_srcTempId)
   OPEN CloneActualSchedules
   FETCH FROM CloneActualSchedules INTO @srcActScheduleId, @srcActTaskId, @srcActInstId
   WHILE @@FETCH_STATUS = 0
   BEGIN
   IF @srcInstId = @srcActInstId /* if this schedule belong to our instance */
      BEGIN
        INSERT INTO schedule
        SELECT taskId, taskType, type, counter, errors, fireIfMissed, canBeDeleted, inProcess, canBeEdited, isReported,
            isSingleton, sCount, mask, monthDay, occurence, dayNumber, atTime, [interval], endValue, startTime, flags | 256, ds_flags, tz_offset,
            tz_name, taskDescription, nextEvent, firstEvent, lastEvent, lastAttempt, @templateInstanceId, endOfDay, skipOccurence, skipDayNumber, calendarId
        FROM schedule
        WHERE id = @srcActScheduleId
        IF @@ERROR <> 0
        BEGIN
            SET @retVal = @@ERROR
            SET @errorString = 'Failed to insert into table schedule.'
            GOTO CX_ERROR_EXIT
        END
        SET @scheduleId = @@IDENTITY
        /* backup policy, SRM Collection */
IF ((@tempType & 2) = 2 OR (@tempType & 32) = 32)
        BEGIN
            INSERT INTO SchedBackupTask
            SELECT      @scheduleId, dataSourceId, userId, sequenceNumber_h, sequenceNumber_l, type, clientId,
                        appTypeId, instance, backupSet, subClient, description, flags, alertId, jobDescription
            FROM        SchedBackupTask
            WHERE       id = @srcActTaskId
            IF @@ERROR <> 0
            BEGIN
                SET @retVal = @@ERROR
                SET @errorString = 'Failed to insert into table SchedBackupTask.'
                GOTO CX_ERROR_EXIT
            END
            SET @taskId = @@IDENTITY
            UPDATE      schedule
            SET         taskid = @taskId
            WHERE       id = @scheduleId
            IF @@ERROR <> 0
            BEGIN
                SET @retVal = @@ERROR
                SET @errorString = 'Failed to update schedule table.'
                GOTO CX_ERROR_EXIT
            END
            INSERT INTO SchedBackupTaskOptions
            SELECT      @taskId, name, [value]
            FROM        SchedBackupTaskOptions
            WHERE       backuptaskId = @srcActTaskId
            IF @@ERROR <> 0
            BEGIN
                SET @retVal = @@ERROR
                SET @errorString = 'Failed to insert into SchedBackupTaskOptions table.'
                GOTO CX_ERROR_EXIT
            END
        END
        /* auxcopy policy, SRM report & SNAP copy to tape */
IF ((@tempType & 4) = 4 OR (@tempType & 16) = 16 OR (@tempType & 64) = 64)
        BEGIN
            INSERT INTO SchedAdminTask
            SELECT      @scheduleId, userId, sequenceNumber_h, sequenceNumber_l, type, flags, alertId, jobDescription
            FROM        SchedAdminTask
            WHERE       id = @srcActTaskId
            IF @@ERROR <> 0
            BEGIN
                SET @retVal = @@ERROR
                SET @errorString = 'Failed to insert into SchedAdminTask  table.'
                GOTO CX_ERROR_EXIT
            END
            SET @taskId = @@IDENTITY
            UPDATE schedule
            SET    taskid = @taskId
            WHERE  id = @scheduleId
            IF @@ERROR <> 0
            BEGIN
                SET @retVal = @@ERROR
                SET @errorString = 'Failed to update schedule table.'
                GOTO CX_ERROR_EXIT
            END
            INSERT INTO SchedAdminParam
            SELECT      @taskId, dataType, dataSize, type, data
            FROM        SchedAdminParam
            WHERE       adminTaskId = @srcActTaskId
            IF @@ERROR <> 0
            BEGIN
                SET @retVal = @@ERROR
                SET @errorString = 'Failed to insert into SchedAdminParam table.'
                GOTO CX_ERROR_EXIT
            END
        END
      END   /* copy the actual schedules and tasks*/
   FETCH NEXT FROM CloneActualSchedules INTO @srcActScheduleId, @srcActTaskId, @srcActInstId
   END
   CLOSE CloneActualSchedules
   DEALLOCATE CloneActualSchedules
   -- end loop for actual schedules
   INSERT INTO schedule
   SELECT taskId, taskType, type, counter, errors, fireIfMissed, canBeDeleted, inProcess, canBeEdited, isReported,
      isSingleton, sCount, mask, monthDay, occurence, dayNumber, atTime, [interval], endValue, startTime, flags | 256, ds_flags, tz_offset,
      tz_name, taskDescription, nextEvent, firstEvent, lastEvent, lastAttempt, @templateInstanceId, endOfDay, skipOccurence, skipDayNumber, calendarId
   FROM schedule
   WHERE id = @srcScheduleId
   IF @@ERROR <> 0
   BEGIN
      SET @retVal = @@ERROR
      SET @errorString = 'Failed to insert into table schedule.'
      GOTO CX_ERROR_EXIT
   END
   SET @scheduleId = @@IDENTITY
   /* backup policy, SRM Collection*/
IF ((@tempType & 2) = 2 OR (@tempType & 32) = 32)
   BEGIN
      INSERT INTO SchedBackupTask
      SELECT      @scheduleId, dataSourceId, userId, sequenceNumber_h, sequenceNumber_l, type, clientId,
                  appTypeId, instance, backupSet, subClient, description, flags, alertId, jobDescription
      FROM        SchedBackupTask
      WHERE       id = @srcTaskId
      IF @@ERROR <> 0
      BEGIN
         SET @retVal = @@ERROR
         SET @errorString = 'Failed to insert into table SchedBackupTask.'
         GOTO CX_ERROR_EXIT
      END
      SET @taskId = @@IDENTITY
      UPDATE      schedule
      SET         taskid = @taskId
      WHERE       id = @scheduleId
      IF @@ERROR <> 0
      BEGIN
         SET @retVal = @@ERROR
         SET @errorString = 'Failed to update schedule table.'
         GOTO CX_ERROR_EXIT
      END
      INSERT INTO SchedBackupTaskOptions
      SELECT      @taskId, name, [value]
      FROM        SchedBackupTaskOptions
      WHERE       backuptaskId = @srcTaskId
      IF @@ERROR <> 0
      BEGIN
         SET @retVal = @@ERROR
         SET @errorString = 'Failed to insert into SchedBackupTaskOptions table.'
         GOTO CX_ERROR_EXIT
      END
   END
   /* auxcopy policy */
IF ((@tempType & 4) = 4 OR (@tempType & 16) = 16 OR (@tempType & 64) = 64)
   BEGIN
      INSERT INTO SchedAdminTask
      SELECT      @scheduleId, userId, sequenceNumber_h, sequenceNumber_l, type, flags, alertId, jobDescription
      FROM        SchedAdminTask
      WHERE       id = @srcTaskId
      IF @@ERROR <> 0
      BEGIN
         SET @retVal = @@ERROR
         SET @errorString = 'Failed to insert into SchedAdminTask  table.'
         GOTO CX_ERROR_EXIT
      END
      SET @taskId = @@IDENTITY
      UPDATE schedule
      SET    taskid = @taskId
      WHERE  id = @scheduleId
      IF @@ERROR <> 0
      BEGIN
         SET @retVal = @@ERROR
         SET @errorString = 'Failed to update schedule table.'
         GOTO CX_ERROR_EXIT
      END
      INSERT INTO SchedAdminParam
      SELECT      @taskId, dataType, dataSize, type, data
      FROM        SchedAdminParam
      WHERE       adminTaskId = @srcTaskId
      IF @@ERROR <> 0
      BEGIN
         SET @retVal = @@ERROR
         SET @errorString = 'Failed to insert into SchedAdminParam table.'
         GOTO CX_ERROR_EXIT
      END
   END
   FETCH NEXT FROM CloneTemplateSchedules INTO @srcScheduleId, @srcTaskId, @srcInstId
END
/****************************************************************************************/
    SET @retVal = 0
    SET @errorString = 'Schedule Policy were cloned successfully!'
CX_ERROR_EXIT:
     CLOSE CloneTemplateSchedules
     DEALLOCATE CloneTemplateSchedules
    IF @retVal = 0
        COMMIT TRANSACTION
    IF @retVal <> 0
        ROLLBACK TRANSACTION
    SELECT @retVal, @errorString
    RETURN ;
GO

IF EXISTS (select * from GxQscripts where name = 'cloneSchedulePolicy')
	delete from GxQscripts where name = 'cloneSchedulePolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='cloneSchedulePolicy')
	delete from GXDBVersions where aliasname = 'cloneSchedulePolicy'
GO

insert into GXDBVersions values(2, 'cloneSchedulePolicy',  '00010013029400020000', 'cloneSchedulePolicy', '00010013029400020000')
GO

