

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/cleanPrunedMagneticChunks.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/cleanprunedmagneticchunks.sp,v $ $Id: cleanprunedmagneticchunks.sp,v 1.26.188.7 2018/12/28 21:24:44 vikashkumar Exp $";
--
--  +========================================================================+
--  | Stored Precedure: cleanPrunedMagneticChunks()
--  |
--  | Description:  Clean-up table entries for aged magnetic chunks.
--  |
--  |       Input:  bogus
--  |
--  |      Return:  error code
--  |
--  |   Revisions   Author   Description
--  |   ---------   -------  ---------------------------------------------
--  |   1.0         Jun Lu   Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='cleanPrunedMagneticChunks')
BEGIN
	print '>>> Drop Stored Procedure: cleanPrunedMagneticChunks <<<'
	drop procedure cleanPrunedMagneticChunks
END
IF EXISTS (select * from GxQscripts where name='cleanPrunedMagneticChunks')
	delete from GxQscripts where name = 'cleanPrunedMagneticChunks'
GO

IF EXISTS (select * from GXDBVersions where aliasname='cleanPrunedMagneticChunks')
	delete from GXDBVersions where aliasname = 'cleanPrunedMagneticChunks'
GO
print '... Creating Procedure: cleanPrunedMagneticChunks'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure cleanPrunedMagneticChunks
  @bogus integer
AS
  DECLARE @retVal integer;
SET NOCOUNT ON
CREATE TABLE #ToBeAgedAFC
(
	archFileId INT,
	commCellId INT,
	archCopyId INT,
	PRIMARY KEY (archFileId, commCellId, archCopyId)
)
CREATE TABLE #JobCopy
(
	jobId 			INT,
	commCellId 	INT,
	archCopyId 	INT,
	fileType 		INT,
	primary key(jobId, commcellId, archCopyId, fileType)
)
DECLARE @retErr		integer
DECLARE @l_now		integer
DECLARE @l_dateTime	datetime
DECLARE	@magneticBytes	bigint
DECLARE @pruneArchiveFilesOnTape	INT = 0
DECLARE @removableMediaPruning		INT = 0
SELECT	@pruneArchiveFilesOnTape = value
FROM	MMConfigs WITH (NOLOCK)
WHERE	name = 'DA_PRUNE_ARCHIVE_FILES_ON_TAPE_WHEN_AGED'
SELECT @removableMediaPruning = value
FROM MMConfigs WITH (NOLOCK)
WHERE name = 'MMS2_CONFIG_ENABLE_REMOVABLE_MEDIA_PRUNING'
SET	@l_dateTime = GetUTCDate()
SET @l_now = dbo.GetUnixTime(@l_dateTime)
SET @retVal = 0
DECLARE @retry INT = 0
SELECT	@retry = ISNULL(value, 2)
FROM	MMConfigs WITH (NOLOCK)
WHERE	name = 'DA_CONFIG_NUMBER_OF_RETRY_ON_LOCK'
SET @retry = @retry + 1 --Total number of attempts would be retry + 1
WHILE(1=1)
BEGIN
	BEGIN TRY
		--Querying ArchFileCopy without NOLOCK hint as we don't want to pick those that are marked aged in an uncommitted transaction
        --Get aged archive files
		INSERT	INTO #ToBeAgedAFC
		SELECT	AFC.archFileId, AFC.commCellId, AFC.archCopyId
		FROM	archFileCopy AFC
WHERE	AFC.flags & 256 <> 0
AND 	(AFC.flags & 2 <> 0 OR AFC.physicalSize = 0 OR @pruneArchiveFilesOnTape = 1)
		DELETE T
		FROM #ToBeAgedAFC T INNER JOIN ArchFile AF WITH(NOLOCK) ON T.archFileId = AF.id AND T.commcellId = AF.commcellId
		WHERE
AF.flags & 2 > 0
		IF (@removableMediaPruning > 0) AND (@pruneArchiveFilesOnTape = 0)
		BEGIN
			-- Find media which is eligible to be pruned due to it loaded in v11 SP11+ MA
			IF OBJECT_ID('tempdb..#removableMedia') IS NOT NULL DROP TABLE #removableMedia
			CREATE TABLE #removableMedia(
											MediaId INT,
											PRIMARY KEY (MediaId)
										)
			INSERT INTO #removableMedia
			SELECT DISTINCT M.MediaId
			FROM MMMedia M WITH (READUNCOMMITTED)
				INNER JOIN MMDrive D WITH (READUNCOMMITTED) ON M.MediaId = D.MediaId
				INNER JOIN MMDriveController DC WITH (READUNCOMMITTED) ON D.DriveId = DC.DriveId
				LEFT OUTER JOIN APP_VMToPMMap MAP WITH (READUNCOMMITTED) ON MAP.VMClientId = DC.ClientId
				INNER JOIN SimInstalledPackages PKG WITH (READUNCOMMITTED) ON PKG.ClientId = ISNULL(MAP.PMClientId, DC.ClientId)
				INNER JOIN APP_Client CLIENT WITH (READUNCOMMITTED) ON CLIENT.id = ISNULL(MAP.PMClientId, DC.ClientId)
WHERE M.MediaTypeId >= 11001 AND M.MediaTypeId <= 11999
AND ((CLIENT.releaseId > 16) OR ((CLIENT.releaseId = 16)  AND (PKG.HighestSP >= 11)))
			INSERT	INTO #ToBeAgedAFC
			SELECT	DISTINCT AFC.archFileId, AFC.commCellId, AFC.archCopyId
			FROM	archFileCopy AFC, archFile AF WITH (NOLOCK), archChunkMapping ACM WITH (NOLOCK),
				archChunk AC WITH (NOLOCK), MMVolume V WITH (NOLOCK), #removableMedia M
			WHERE	AFC.archFileId = AF.id
			AND	AFC.commCellId = AF.commCellId
AND	AFC.flags & 256 <> 0
			AND	AFC.physicalSize > 0
			AND 	AFC.archFileId = ACM.archFileId
			AND	AFC.commCellId = ACM.commCellId
			AND	AFC.archCopyId = ACM.archCopyId
			AND	ACM.archChunkId = AC.id
			AND	ACM.chunkCommCellId = AC.commCellId
			AND	AC.VolumeId = V.VolumeId
			AND	V.MediaId = M.MediaId
			DROP TABLE #removableMedia
		END
		IF NOT EXISTS(SELECT 1 FROM #ToBeAgedAFC)
			GOTO CX_EXIT
		BREAK --Success. Break the loop
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		IF(ERROR_NUMBER() = 1205 /*Deadlock*/ OR ERROR_NUMBER() = 1222 /*Lock timeout*/ ) --
			SET @retry = @retry - 1
		ELSE
			SET @retry = 0 --No more attempts
		IF(@retry <= 0) --Break the loop
		BEGIN
			SET	@retVal = ERROR_NUMBER()
			GOTO CX_EXIT
		END
		ELSE --Sleep 5 seconds and retry
		BEGIN
			PRINT OBJECT_NAME(@@PROCID)+': '+'Sleep for 5 seconds and retry.'
			WAITFOR DELAY '00:00:05'
		END
	END CATCH
END
-- Mark jobs as Deleted From Media if no more archFileCopy entry left
INSERT	INTO #JobCopy
SELECT	AF.jobId, AF.commCellId, AFC.archCopyId, AF.fileType
FROM	#ToBeAgedAFC AFC, archFile AF WITH (NOLOCK)
WHERE	AF.id = AFC.archFileId AND AF.commCellId = AFC.commCellId
GROUP BY AF.jobId, AF.commCellId, AFC.archCopyId, AF.fileType
SELECT	@retVal = @@ERROR
IF	@retVal <> 0 GOTO CX_EXIT
BEGIN	TRANSACTION
BEGIN	TRY
		EXEC @retErr = archFileDeleteViaTable 0, @magneticBytes	OUTPUT
		IF	@retErr <> 0
		BEGIN
			SET	@retVal = @retErr
			ROLLBACK TRANSACTION
			GOTO CX_EXIT
		END
		-- Don not touch jobs which still have archFileCopy entries
		DELETE	#JobCopy
		FROM	#JobCopy T, archFile AF WITH (NOLOCK), archFileCopy AFC WITH (NOLOCK)
		WHERE	AF.jobId = T.jobId AND AF.commCellId = T.commCellId AND AF.fileType = T.fileType
			AND AFC.archFileId = AF.id AND AFC.commCellId = AF.commCellId AND AFC.archCopyId = T.archCopyId
		UPDATE	JMJobDataStats
		SET		status = 1000, mediaDeletedTime = @l_now, modifiedTime = @l_now
		FROM	JMJobDataStats A, #JobCopy B
		WHERE	A.jobId = B.jobId AND A.dataType = B.fileType
			AND A.archGrpCopyId = B.archCopyId AND A.commCellId = B.commCellId
			AND A.status <> 1000
AND (A.disabled & 256) <> 0
		-- Set dataStatus = 2 when a job has been deleted from media from all copies
		DELETE	#JobCopy
		FROM	JMJobDataStats A WITH (NOLOCK), #JobCopy B
		WHERE	A.jobId = B.jobId AND A.commCellId = B.commCellId
 			AND A.status NOT IN (101, 1000)
		UPDATE	JMBkpStats
		SET		dataStatus = 2, agedTime = (case when agedTime > 0 then agedTime else @l_now end),
				mediaDeletedTime = @l_now, modifiedTime = @l_now
		FROM	JMBkpStats J, (SELECT DISTINCT jobId, commCellId FROM #JobCopy) T
		WHERE	J.JobId = T.jobId AND J.CommCellID = T.commCellId
 			AND J.dataStatus <> 2
		UPDATE	JMAdminJobStatsTable
		SET		dataStatus = 2
		FROM	JMAdminJobStatsTable J, (SELECT DISTINCT jobId, commCellId FROM #JobCopy) T
		WHERE	J.JobId = T.jobId AND J.CommCellID = T.commCellId
 			AND J.dataStatus <> 2
END		TRY
BEGIN	CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SET	@retVal = (SELECT ERROR_NUMBER())
		ROLLBACK TRANSACTION
		GOTO CX_EXIT
END		CATCH
COMMIT TRANSACTION
CX_EXIT:
DROP TABLE	#ToBeAgedAFC
DROP TABLE	#JobCopy
IF OBJECT_ID('tempdb..#retValTemp') IS NOT NULL
BEGIN
	INSERT INTO #retValTemp
	SELECT @retVal
END
ELSE
SELECT @retVal
RETURN @retVal
GO

IF EXISTS (select * from GxQscripts where name = 'cleanPrunedMagneticChunks')
	delete from GxQscripts where name = 'cleanPrunedMagneticChunks'
GO

IF EXISTS (select * from GXDBVersions where aliasname='cleanPrunedMagneticChunks')
	delete from GXDBVersions where aliasname = 'cleanPrunedMagneticChunks'
GO

insert into GXDBVersions values(2, 'cleanPrunedMagneticChunks',  '00010026018800070000', 'cleanPrunedMagneticChunks', '00010026018800070000')
GO

