

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/cleanJobhistoryWithoutArchfile.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/cleanJobhistoryWithoutArchfile.sp,v $ $Id: cleanJobhistoryWithoutArchfile.sp,v 1.6.274.5 2018/09/26 17:11:31 hkapadia Exp $";
--
--  +========================================================================+
--  | Stored Precedure: cleanJobhistoryWithoutArchfile()
--  |
--  | Description:  clean up JMJobDataStats table.
--  |				The goal is to identify jobs that have no archive files for its jobId and dataType but has status = 100 on copy.
--	|				Remove such records by (jobId, datatype).
--	|
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: cleanJobhistoryWithoutArchfile <<<'

IF EXISTS (select * from sysobjects where name='cleanJobhistoryWithoutArchfile')
	drop procedure cleanJobhistoryWithoutArchfile
IF EXISTS (select * from GxQscripts where name='cleanJobhistoryWithoutArchfile')
	delete from GxQscripts where name = 'cleanJobhistoryWithoutArchfile'
GO

IF EXISTS (select * from GXDBVersions where aliasname='cleanJobhistoryWithoutArchfile')
	delete from GXDBVersions where aliasname = 'cleanJobhistoryWithoutArchfile'
GO
print '... Creating Procedure: cleanJobhistoryWithoutArchfile'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure cleanJobhistoryWithoutArchfile
  @in_dummy INTEGER
AS
  DECLARE @retVal integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	BEGIN TRANSACTION
	DECLARE @currentTime	INTEGER
	SET 		@currentTime	= dbo.GetUnixTime(GETUTCDATE())
	DECLARE @asOfTime	INTEGER
	SET 		@asOfTime	= @currentTime - 24 * 3600
	SET		@retVal = 0
	CREATE TABLE #tempJobCopy(
		jobId int,
		archGrpCopyId int,
		dataType int,
		commCellId int)
	SELECT	@retVal = @@ERROR
	IF		@retVal != 0
			GOTO CX_ERROR_EXIT
	CREATE INDEX #tempJobCopy_index1
		ON #tempJobCopy(jobId, archGrpCopyId, dataType, commCellId)
	SELECT	@retVal = @@ERROR
	IF		@retVal != 0
			GOTO CX_ERROR_EXIT
	INSERT	INTO #tempJobCopy
	SELECT	DISTINCT JM.jobId, JM.archGrpCopyId, JM.dataType, JM.commCellId
	FROM	JMJobDataStats JM WITH (READUNCOMMITTED)
	WHERE	JM.status = 100
AND		JM.disabled & 256 = 0
	AND		JM.modifiedTime < @asOfTime
	AND		NOT EXISTS(
			SELECT	TOP 1 AFC.*
			FROM	archFile AF WITH (READUNCOMMITTED), archFileCopy AFC WITH (READUNCOMMITTED)
			WHERE	AF.commCellId = JM.commCellId
			AND		AF.JobId = JM.jobId
			AND		AF.fileType	= JM.dataType
			AND		AFC.archFileId = AF.id
			AND		AFC.commCellId = AF.commCellId
			AND		AFC.archCopyId = JM.archGrpCopyId)
	UNION
	SELECT	DISTINCT JM.jobId, JM.archGrpCopyId, JM.dataType, JM.commCellId
	FROM	JMJobDataStats JM WITH (READUNCOMMITTED) LEFT OUTER JOIN archFile AF WITH (READUNCOMMITTED)
	ON 		JM.jobId = AF.JobId
	AND 	JM.commCellId = AF.commCellId
	AND		JM.dataType = AF.fileType
	WHERE	JM.status != 1000
AND		JM.disabled & 256 = 0
	AND		JM.modifiedTime < @asOfTime
	AND		AF.id IS NULL
	SELECT	@retVal = @@ERROR
	IF			@retVal != 0 GOTO CX_ERROR_EXIT
	--Apply safety check due to SQL bug on left outer join
	DELETE #tempJobCopy
	FROM #tempJobCopy T, archFile AF WITH (READUNCOMMITTED), archFileCopy AFC WITH (READUNCOMMITTED)
	WHERE 	T.jobId = AF.jobId
	AND			T.commcellId = AF.commcellId
	AND			T.dataType = AF.fileType
	AND			AF.id = AFC.archFileId
	AND			AF.commCellId = AFC.commCellId
	AND			T.archGrpCopyId = AFC.archCopyId
	SELECT	@retVal = @@ERROR
	IF			@retVal != 0 GOTO CX_ERROR_EXIT
	--DO NOT PRUNE FOREIGN COMMCELL JOBS
	DELETE #tempJobCopy
	WHERE commCellId IN (SELECT id FROM APP_CommCell WITH (READUNCOMMITTED) WHERE type > 1)
	SELECT	@retVal = @@ERROR
	IF			@retVal != 0 GOTO CX_ERROR_EXIT
	-- Update the entries in JMJobDataStats with 1000 status (deleted from media) if no archFileCopy entries found.
	UPDATE	JMJobDataStats
SET 		status = 1000, disabled = (JM.disabled | 256), agedBy = (JM.agedBy | 2097152),
					agedTime = @currentTime, mediaDeletedTime = @currentTime, modifiedTime = @currentTime
	FROM		JMJobDataStats JM, #tempJobCopy JC
	WHERE		JM.jobId = JC.jobId
	AND			JM.commcellId = JC.commcellId
	AND			JM.archGrpCopyId = JC.archGrpCopyId
	AND			JM.dataType = JC.dataType
	SELECT	@retVal = @@ERROR
	IF			@retVal != 0 GOTO CX_ERROR_EXIT
	DROP TABLE #tempJobCopy
	COMMIT TRANSACTION
	SELECT @retVal
	RETURN
CX_ERROR_EXIT:
	DROP TABLE #tempJobCopy
	ROLLBACK TRANSACTION
	SELECT @retVal
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'cleanJobhistoryWithoutArchfile')
	delete from GxQscripts where name = 'cleanJobhistoryWithoutArchfile'
GO

IF EXISTS (select * from GXDBVersions where aliasname='cleanJobhistoryWithoutArchfile')
	delete from GXDBVersions where aliasname = 'cleanJobhistoryWithoutArchfile'
GO

insert into GXDBVersions values(2, 'cleanJobhistoryWithoutArchfile',  '00010006027400050000', 'cleanJobhistoryWithoutArchfile', '00010006027400050000')
GO

