

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/br_ntformatEntities.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/br_ntformatEntities.sp,v $ $Id: br_ntformatEntities.sp,v 1.11.88.2 2018/03/27 07:58:29 jiechen Exp $";
--
--  +========================================================================+
--  |   Procedure:  br_ntformatEntities()
--  |
--  | Description:  Intended to be called by Cursor "NTgetNotificationsToSend'
--	|				and others.  Fetches rows & formats Subject & Message Body
--	|				fields by token substitution.
--  |
--  |       Input:  messageType
--	|
--  |      Output:  xxx
--  |      Return:  xxx
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  +========================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: br_ntformatEntities <<<'

IF EXISTS (select * from sysobjects where name='br_ntformatEntities')
	drop procedure br_ntformatEntities
IF EXISTS (select * from GxQscripts where name='br_ntformatEntities')
	delete from GxQscripts where name = 'br_ntformatEntities'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_ntformatEntities')
	delete from GXDBVersions where aliasname = 'br_ntformatEntities'
GO
print '... Creating Procedure: br_ntformatEntities'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure br_ntformatEntities
  @msgId integer,
  @localeId integer,
  @msgTokenId BIGINT,
  @isHtmlEncoding integer
AS
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--   PARAMETERS   &   OUTPUTS
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
DECLARE @TokenLen		integer
DECLARE @TokenString	nvarchar(256)
DECLARE @TokenOffset    integer
DECLARE @PTRVAL			varbinary(16)
declare @fullEntityName	nvarchar(1024)
declare @entityCount	integer
declare @entityMaxCount	integer
declare @tokSep	      nvarchar(25)
DECLARE @Offset    integer
	set @tokSep = N''
	set @TokenString	= dbo.getHtmlEscapedString(dbo.fn_EvFormatEventMsgText(0,@localeId, @msgTokenId, 0 ,2),@isHtmlEncoding)
	set @tokenLen		= LEN(@tokenString)
	set @tokenOffset	= (SELECT PATINDEX('%'+@TokenString+'%', formatMsg)
							FROM #ntnotifmsg
							)
   	if (@tokenOffset > 0)
	BEGIN
		SET @tokenOffset = @tokenOffset -1
		set @offset = @tokenOffset
		SELECT @PTRVAL = TEXTPTR(formatMsg)
			FROM #ntnotifmsg
		UPDATETEXT #ntnotifmsg.formatMsg @PTRVAL @tokenOffset @tokenLen ''
--		+-------------------------------------------------------------------+
--		| NOW THAT WE HAVE A LIST OF ENTITIES, FORMAT THEM INTO THE MESSAGE |
--		+-------------------------------------------------------------------+
		set @entityCount = (select Count(*) from ##entityList where msgIndex = @msgId and tokenId = @msgTokenId)
		IF @entityCount > 0
		BEGIN
			DECLARE entities_cursor CURSOR FOR
			SELECT  tokenVal FROM ##entityList where msgIndex = @msgId and tokenId = @msgTokenId
	        IF @entityCount = 1										-- MR 92045 Make long lists easier to read!
			  SET @tokSep =CHAR(13)+CHAR(10)+char(09)
			 ELSE
			  SET @tokSep =N','+CHAR(13)+CHAR(10)+char(09)
--	          set @tokSep = N' , '
			OPEN  entities_cursor
			FETCH NEXT FROM entities_cursor
				INTO @fullEntityName
			WHILE @@FETCH_STATUS = 0
			BEGIN
				set @fullEntityName= @tokSep + @fullEntityName
				if @isHtmlEncoding=1
				begin
					set @fullEntityName = dbo.getHtmlEscapedString(@fullEntityName,@isHtmlEncoding)
				end
				UPDATETEXT #ntnotifmsg.formatMsg @PTRVAL @offset 0 @fullEntityName
				set @offset = @offset + LEN(@fullEntityName)
				FETCH NEXT FROM entities_cursor
					INTO @fullEntityName
			END
			CLOSE		entities_cursor
			DEALLOCATE	entities_cursor
			-- Remove the last sep
			IF @entityCount > 1
			  UPDATETEXT #ntnotifmsg.formatMsg @PTRVAL @tokenOffset 2 ''
		END
		ELSE
		BEGIN
set @fullEntityName= dbo.fn_EvFormatEventMsgText(0,@localeId, (165 | (CAST(POWER(2, 24) AS BIGINT) * 74)), 0 ,2)
			if @isHtmlEncoding=1
			begin
				set @fullEntityName = dbo.getHtmlEscapedString(@fullEntityName,@isHtmlEncoding)
			end
			UPDATETEXT #ntnotifmsg.formatMsg @PTRVAL @tokenOffset 0 @fullEntityName
		END
	END
GO

IF EXISTS (select * from GxQscripts where name = 'br_ntformatEntities')
	delete from GxQscripts where name = 'br_ntformatEntities'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_ntformatEntities')
	delete from GXDBVersions where aliasname = 'br_ntformatEntities'
GO

insert into GXDBVersions values(2, 'br_ntformatEntities',  '00010011008800020000', 'br_ntformatEntities', '00010011008800020000')
GO

