

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/br_ntformatCopyNtext.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/br_ntformatCopyNtext.sp,v $ $Id: br_ntformatCopyNtext.sp,v 1.5.304.1 2018/03/27 08:08:54 jiechen Exp $";
--
--  +========================================================================+
--  |   Procedure:  br_ntformatEntities()
--  |
--  | Description:  Intended to be called by Cursor "NTgetNotificationsToSend'
--	|				and others.  Fetches rows & formats Subject & Message Body
--	|				fields by token substitution.
--  |
--  |       Input:  messageType
--	|
--  |      Output:  xxx
--  |      Return:  xxx
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  +========================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: br_ntformatCopyNtext <<<'

IF EXISTS (select * from sysobjects where name='br_ntformatCopyNtext')
	drop procedure br_ntformatCopyNtext
IF EXISTS (select * from GxQscripts where name='br_ntformatCopyNtext')
	delete from GxQscripts where name = 'br_ntformatCopyNtext'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_ntformatCopyNtext')
	delete from GXDBVersions where aliasname = 'br_ntformatCopyNtext'
GO
print '... Creating Procedure: br_ntformatCopyNtext'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure br_ntformatCopyNtext
  @notifId integer ,
  @messType integer ,
  @escLevel integer  
AS
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--   PARAMETERS   &   OUTPUTS
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
DECLARE @i int, @j int, @blocks int, @c int,  @buffer nvarchar(4000)
DECLARE	@PTRVAL				varbinary(16)
SELECT @PTRVAL = TEXTPTR(formattedMessage)
			FROM NTmessageFormat
			WHERE NTnotificationId = @notifId
			  AND  messageType=@messType
			  AND  escalationLevel = @escLevel
--get length of data to copy
SELECT @c = DATALENGTH(formatMsg)/2
FROM #ntnotifmsg
set @j=0
create table #t ( t ntext )
SET @i=@c
--read 1000 bytes at a time
WHILE @i>100
	BEGIN
	insert into #t
	exec br_ntgetREADTEXT 'formatMsg','#ntnotifmsg','',@j,100
	set @buffer=(select convert(nvarchar(2000),t) from #t)
	UPDATETEXT NTmessageFormat.formattedMessage @PTRVAL Null 0 @buffer
	delete #t
	SET @i=@i-100
	SET @j=@j+100
	END
--read remaining bytes
if @i>0
	BEGIN
	insert into #t
	exec br_ntgetREADTEXT 'formatMsg','#ntnotifmsg','',@j,@i
	set @buffer=(select convert(nvarchar(2000),t) from #t)
	UPDATETEXT NTmessageFormat.formattedMessage @PTRVAL Null 0 @buffer
	delete #t
	END
drop table #t
GO

IF EXISTS (select * from GxQscripts where name = 'br_ntformatCopyNtext')
	delete from GxQscripts where name = 'br_ntformatCopyNtext'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_ntformatCopyNtext')
	delete from GXDBVersions where aliasname = 'br_ntformatCopyNtext'
GO

insert into GXDBVersions values(2, 'br_ntformatCopyNtext',  '00010005030400010000', 'br_ntformatCopyNtext', '00010005030400010000')
GO

