

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/br_ntSetNextNotification.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/br_ntSetNextNotification.sp,v $ $Id: br_ntSetNextNotification.sp,v 1.2 2004/08/12 17:37:16 skatz Exp $";
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +========================================================================+
--  |   Procedure:  BR_NTsetNextNotification()
--  |
--  | Description:  Sets the next email to be sent for a specific cursur
--	|				that can see a chosen Qnet object.
--  |
--  |       Input:
--	|
--	|
--  |      Output:  NTmessageTracking Table updated
--  |      Return:  xxx
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: br_ntSetNextNotification <<<'

IF EXISTS (select * from sysobjects where name='br_ntSetNextNotification')
	drop procedure br_ntSetNextNotification
IF EXISTS (select * from GxQscripts where name='br_ntSetNextNotification')
	delete from GxQscripts where name = 'br_ntSetNextNotification'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_ntSetNextNotification')
	delete from GXDBVersions where aliasname = 'br_ntSetNextNotification'
GO
print '... Creating Procedure: br_ntSetNextNotification'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure br_ntSetNextNotification
--	+-------------------------------+
--	| PARAMETERS   &   OUTPUTS		|
--	+-------------------------------+
  @notifId integer,
  @messType integer,
  @escLevel integer,
  @lastSent char(128)
AS
DECLARE @messTypeBit 	integer
SET @messTypeBit = @messType
------------------------------------------------
-- UPDATE THE TRACKING TABLE ACCORDINGLY      ==
------------------------------------------------
UPDATE NTmessageTracking
SET lastMessageSent   = @lastSent
WHERE NTnotificationId=@notifId
AND messageType = @messType
AND escalationLevel = @escLevel
------------------------------------------------
-- UPDATE THE HISTORY TABLE ACCORDINGLY       ==
------------------------------------------------
UPDATE NTmessageHistory
  SET sentStatus = sentStatus | @messTypeBit
    WHERE NTnotificationId=@notifId
 		AND escalationLevel = @escLevel
		AND triggerTime = @lastSent
select @lastSent
GO

IF EXISTS (select * from GxQscripts where name = 'br_ntSetNextNotification')
	delete from GxQscripts where name = 'br_ntSetNextNotification'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_ntSetNextNotification')
	delete from GXDBVersions where aliasname = 'br_ntSetNextNotification'
GO

insert into GXDBVersions values(2, 'br_ntSetNextNotification',  '00010002000000000000', 'br_ntSetNextNotification', '00010002000000000000')
GO

