

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/br_ntRetrieveCustomQueryInputForAlert.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/br_ntRetrieveCustomQueryInputForAlert.sp,v $ $Id: br_ntRetrieveCustomQueryInputForAlert.sp,v 1.4.48.5 2020/12/15 02:57:07 snandhini Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   br_ntProcessMetricsResults
--					 - Fetch the name value pair of result set in either html or text format
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='br_ntRetrieveCustomQueryInputForAlert')
BEGIN
	print '>>> Drop Stored Procedure: br_ntRetrieveCustomQueryInputForAlert <<<'
	drop procedure br_ntRetrieveCustomQueryInputForAlert
END
IF EXISTS (select * from GxQscripts where name='br_ntRetrieveCustomQueryInputForAlert')
	delete from GxQscripts where name = 'br_ntRetrieveCustomQueryInputForAlert'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_ntRetrieveCustomQueryInputForAlert')
	delete from GXDBVersions where aliasname = 'br_ntRetrieveCustomQueryInputForAlert'
GO
print '... Creating Procedure: br_ntRetrieveCustomQueryInputForAlert'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure br_ntRetrieveCustomQueryInputForAlert
  @localeId int,
  @isHtmlFormat int,
  @ntRuleId int
AS
  DECLARE @resultSet nvarchar(max)
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @newTemplate INT = ISNULL((SELECT value FROM GXGlobalParam WHERE name='UseNewAlertTemplate'),0)
declare @queryId int = 0
DECLARE @columnsList TABLE (id INT IDENTITY, columnName NVARCHAR(256),shldBePartOfOutput int)
DECLARE @columnName NVARCHAR(256)
DECLARE @shldBePartOfOutput int
DECLARE @numberOfRows INT
Declare @xmlInfo	  XML
select @queryId = queryId,
	@xmlInfo = convert(xml,NTNotificationQueryMapping.xmlInfo) from NTNotificationQueryMapping
where NTNotificationId=@ntRuleId
declare @ntRuleInputColValue table
(
	paramName nvarchar(maX),
	value nvarchar(maX)
)
Insert into @ntRuleInputColValue
select T2.Col.value('@paramName','nvarchar(max)'),
	   T2.Col.value('@value','nvarchar(max)')
from @xmlInfo.nodes('CVGui_QueryAdditionalInfo/queryParameters/queryParameters') as T2(Col)
--queryInputColList
declare @InputColListForQuery table
(
	paramName nvarchar(maX),
	displayName nvarchar(maX),
	javaDataType nvarchar(maX),
	sqlDataType nvarchar(maX),
	listType int,
	selectedValue nvarchar(maX),
	isAllEntitiesSelected int
)
insert into @InputColListForQuery(javadataType,paramName,displayName,listType,sqlDataType,selectedValue,isAllEntitiesSelected)
select CONVERT(xml,xmlInfo).value('(App_XMLSchema/@inputType)[1]','nvarchar(max)'),
columnName,
IsNull(CONVERT(xml,xmlInfo).value('(App_XMLSchema/@displayName)[1]','nvarchar(max)'),columnName),
CONVERT(xml,xmlInfo).value('(App_XMLSchema/@listType)[1]','int'),
'',
'',
0
 from NTQueryColumnList
where columnType=1
and queryId=@queryId
update @InputColListForQuery
set displayName = paramName
where displayName is null or len(displayName)=0
update @InputColListForQuery
set sqlDataType = dbo.NTGetListDataType(javaDataType)
declare @textReportResult nvarchar(max)
set @textReportResult = ''
delete from @InputColListForQuery
where sqlDataType like '%xml%'
update InputColList
set isAllEntitiesSelected = dbo.NTGetIsAllEntitiesSelectedForParam(RuleInputs.value,RuleInputs.paramName)
from @InputColListForQuery InputColList
inner join @ntRuleInputColValue RuleInputs on
InputColList.paramName=RuleInputs.paramName
and InputColList.listType>0
and sqlDataType='CVListEntity'
update InputColList
set selectedValue = dbo.NTGetValueForParamModified(RuleInputs.value,RuleInputs.paramName,javaDataType,listType,2)
from @InputColListForQuery InputColList
inner join @ntRuleInputColValue RuleInputs on
InputColList.paramName=RuleInputs.paramName
and InputColList.isAllEntitiesSelected=0
update InputColList
set selectedValue = dbo.fn_EvFormatEventMsgText(0,@localeId, (1188 | (CAST(POWER(2, 24) AS BIGINT) * 74)), 0,2)
from @InputColListForQuery InputColList
where InputColList.isAllEntitiesSelected=1
IF @newTemplate = 0
	select @textReportResult = @textReportResult + IsNull(InputColList.displayName + ' : ' + InputColList.selectedValue,'')
	+' MsgNewLine_MsgTab_ '
	from @InputColListForQuery InputColList
ELSE
	select @textReportResult = @textReportResult + IsNull(InputColList.displayName+ 'TABLEDATASEP' + InputColList.selectedValue,'')
		+' MsgNewLine_MsgTab_ '
	from @InputColListForQuery InputColList
set @textReportResult = rtrim(ltrim(@textReportResult))
if (patindex('%MsgNewLine_MsgTab_',@textReportResult)>0)
begin
	set @textReportResult = substring(@textReportResult,1,len(@textReportResult)-len('MsgNewLine_MsgTab_'))
end
if (@isHtmlFormat=0)
begin
	IF @newTemplate = 0
		select replace(replace(@textReportResult,'MsgTab_ ',''),'MsgNewLine_',' , ')
	ELSE
		select replace(replace(replace(@textReportResult,'MsgTab_ ',''),'MsgNewLine_',' , '),'TABLEDATASEP',' : ')
	return
end
set @textReportResult = dbo.getHtmlEscapedString(@textReportResult,1)
set @textReportResult = replace(@textReportResult,'MsgTab_ ','')
IF @newTemplate = 0
BEGIN
	set @textReportResult = replace(@textReportResult,'MsgNewLine_','</li><li style="margin-top: 4px; margin-bottom: 4px">')
	set @textReportResult = @textReportResult + '</li>'
	set @textReportResult = '<li style="margin-top: 4px; margin-bottom: 4px">' + @textReportResult
END
ELSE
BEGIN
	set @textReportResult = replace(@textReportResult,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>')
	set @textReportResult = replace(@textReportResult,'TABLEDATASEP','</b></font></td><td colspan="2">')
	set @textReportResult = @textReportResult + '</td></tr>'
	set @textReportResult = '<tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>' + @textReportResult
END
select @textReportResult
return
SET NOCOUNT OFF
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  END
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
GO

IF EXISTS (select * from GxQscripts where name = 'br_ntRetrieveCustomQueryInputForAlert')
	delete from GxQscripts where name = 'br_ntRetrieveCustomQueryInputForAlert'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_ntRetrieveCustomQueryInputForAlert')
	delete from GXDBVersions where aliasname = 'br_ntRetrieveCustomQueryInputForAlert'
GO

insert into GXDBVersions values(2, 'br_ntRetrieveCustomQueryInputForAlert',  '00010004004800050000', 'br_ntRetrieveCustomQueryInputForAlert', '00010004004800050000')
GO

