

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/br_ntRetrieveBasicVMInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems,  Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems,  Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/br_ntRetrieveBasicVMInfo.sp,v $ $Id: br_ntRetrieveBasicVMInfo.sp,v 1.1.2.2 2019/02/13 17:33:08 mnatarajan Exp $";
-- 	+---------------------------------------------------+
--	| PROCEDURE : "br_ntRetrieveBasicVMInfo"		|
-- 	+---------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='br_ntRetrieveBasicVMInfo')
BEGIN
	print '>>> Drop Stored Procedure: br_ntRetrieveBasicVMInfo <<<'
	drop procedure br_ntRetrieveBasicVMInfo
END
IF EXISTS (select * from GxQscripts where name='br_ntRetrieveBasicVMInfo')
	delete from GxQscripts where name = 'br_ntRetrieveBasicVMInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_ntRetrieveBasicVMInfo')
	delete from GXDBVersions where aliasname = 'br_ntRetrieveBasicVMInfo'
GO
print '... Creating Procedure: br_ntRetrieveBasicVMInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure br_ntRetrieveBasicVMInfo
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @eventId int
AS
  DECLARE @vmStatus INT;
  DECLARE @vmName nvarchar(510);
  DECLARE @vmFailureReason nvarchar(2048);
  DECLARE @vmHostName nvarchar(2048);
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @jobID INT
DECLARE @vmClientID INT
SELECT @jobID = jobId_l, @vmClientID = clientID
FROM NTDDpdr (NOLOCK)
WHERE eventId = @eventId
-- Get parent jobId from child jobID
SELECT @jobId = parentJobId
FROM JMJobDataLink (NOLOCK)
WHERE childJobID = @jobId
IF object_id('tempdb.dbo.#NTVMPropsList') IS NOT NULL
	DROP TABLE #NTVMPropsList
CREATE TABLE #NTVMPropsList
(
	attrName				nvarchar(max),
	attrVal					nvarchar(max)
)
Insert into #NTVMPropsList
select attrName,attrVal
from App_vmprop with (nolock)
where jobId = @jobId
AND	commcellId = 2
AND VMclientId = @vmClientId
AND attrname in ('vmStatus', 'vmFailureReason' , 'vmHost')
-- If the job is failed or killed, mark VMs as failed.
IF EXISTS(SELECT 1 FROM NTDetectedAlerts where eventId = @eventId and
(criteria = 3 or status=3001 OR Status = 3006 ))
BEGIN
	UPDATE #NTVMPropsList
	SET attrval = '1'
	WHERE attrname = 'vmStatus'
END
SELECT
	ISNULL((SELECT attrVal FROM #NTVMPropsList WHERE attrName = 'vmStatus'),0),
	ISNULL((SELECT displayName FROM app_Client WHERE ID = @vmClientID),''),
	ISNULL((SELECT attrVal FROM #NTVMPropsList WHERE attrName = 'vmFailureReason'),''),
	ISNULL((SELECT attrVal FROM #NTVMPropsList WHERE attrName = 'vmHost') ,'')
IF object_id('tempdb.dbo.#NTVMPropsList') IS NOT NULL
	DROP TABLE #NTVMPropsList
GO

IF EXISTS (select * from GxQscripts where name = 'br_ntRetrieveBasicVMInfo')
	delete from GxQscripts where name = 'br_ntRetrieveBasicVMInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_ntRetrieveBasicVMInfo')
	delete from GXDBVersions where aliasname = 'br_ntRetrieveBasicVMInfo'
GO

insert into GXDBVersions values(2, 'br_ntRetrieveBasicVMInfo',  '00010001000200020000', 'br_ntRetrieveBasicVMInfo', '00010001000200020000')
GO

