

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/br_ntRetrieveAdditionalVMInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems,  Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems,  Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/br_ntRetrieveAdditionalVMInfo.sp,v $ $Id: br_ntRetrieveAdditionalVMInfo.sp,v 1.2.2.4 2020/05/02 07:21:32 gstoops Exp $";
-- 	+---------------------------------------------------+
--	| PROCEDURE : "br_ntRetrieveAdditionalVMInfo"		|
-- 	+---------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='br_ntRetrieveAdditionalVMInfo')
BEGIN
	print '>>> Drop Stored Procedure: br_ntRetrieveAdditionalVMInfo <<<'
	drop procedure br_ntRetrieveAdditionalVMInfo
END
IF EXISTS (select * from GxQscripts where name='br_ntRetrieveAdditionalVMInfo')
	delete from GxQscripts where name = 'br_ntRetrieveAdditionalVMInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_ntRetrieveAdditionalVMInfo')
	delete from GXDBVersions where aliasname = 'br_ntRetrieveAdditionalVMInfo'
GO
print '... Creating Procedure: br_ntRetrieveAdditionalVMInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure br_ntRetrieveAdditionalVMInfo
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @eventId int,
  @vmClientId int,
  @jobId int,
  @localeId int
AS
  DECLARE @vmData nvarchar(max);
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
IF object_id('tempdb.dbo.#NTVMPropsList') IS NOT NULL
	DROP TABLE #NTVMPropsList
CREATE TABLE #NTVMPropsList
(
	attrName				nvarchar(max),
	attrVal					nvarchar(max)
)
Insert into #NTVMPropsList
select attrName,attrVal
from App_vmprop with (nolock)
where jobId = @jobId
AND	commcellId = 2
AND VMclientId = @vmClientId
declare @csTimeZone nvarchar(max)
set @csTimeZone = dbo.getclientTimezone(2)
if @csTimeZone is null or len(@csTimeZone)=0
begin
	set @csTimeZone = 'UTC'
end
-- Delete already processed properties
delete from #NTVMPropsList
where attrname in ('vmStatus', 'vmFailureReason' , 'vmHost')
-- Delete properties which the user isnt interested in for additional VM info
delete from #NTVMPropsList
where 'NotificationVMProp'+attrname not in
(
	select name from GxGlobalparam
	where modified=0
)
declare @vmPropMessageIdMap table
(
	attrname nvarchar(max),
	messageId int
)
Insert into @vmPropMessageIdMap
select 'vmBackupEndTime', (1171 | (CAST(POWER(2, 24) AS BIGINT) * 74))
union
select 'vmGuestSize', (1172 | (CAST(POWER(2, 24) AS BIGINT) * 74))
union
select 'vmUsedSpace', (1173 | (CAST(POWER(2, 24) AS BIGINT) * 74))
union
select 'vmIsPoweredOffByCurrJob', (1174 | (CAST(POWER(2, 24) AS BIGINT) * 74))
union
select 'vmIsGuestSizeValid', (1175 | (CAST(POWER(2, 24) AS BIGINT) * 74))
union
select 'vmAgent', (1176 | (CAST(POWER(2, 24) AS BIGINT) * 74))
union
select 'vmSize' , (1177 | (CAST(POWER(2, 24) AS BIGINT) * 74))
union
select 'vmOperatingSystem', (1178 | (CAST(POWER(2, 24) AS BIGINT) * 74))
union
select 'vmCBTStatus', (1179 | (CAST(POWER(2, 24) AS BIGINT) * 74))
union
select 'vmBackupStartTime',(1180 | (CAST(POWER(2, 24) AS BIGINT) * 74))
union
select 'vmBackupType', (1182 | (CAST(POWER(2, 24) AS BIGINT) * 74))
union
select 'vmTransportMode', (1183 | (CAST(POWER(2, 24) AS BIGINT) * 74))
union
select 'vmHardwareVersion',(1181 | (CAST(POWER(2, 24) AS BIGINT) * 74))
DECLARE     @tblJob TABLE(jobid INT, commcellId INT, appId INT, servStartDate INT)
INSERT INTO @tblJob
SELECT jobid, commCellId, appid, servStartDate FROM JMBkpStats with (nolock) WHERE jobId = @jobId AND commcellId = 2
UNION
SELECT B.jobId, B.commcellId, B.applicationId, J.jobStartTime FROM JMBkpJobInfo B with (nolock)
inner join JMJobInfo J with (nolock)
ON J.jobId = B.jobId AND J.commCellId = B.commcellId AND B.jobId = @jobId AND B.commcellId = 2
DECLARE @backupLevelView INT
SET @backupLevelView = (SELECT  TOP 1 CAST(attrVal AS INT)
                        FROM    APP_SubClientProp S inner join @tblJob J
						ON J.jobId = @jobId AND J.commCellId = 2 AND S.componentNameId = J.appId
                        WHERE   S.attrName = 'Virtual Server Backup Level View'
                            AND S.created <= J.servStartDate
                            AND (S.modified = 0 OR S.modified > J.servStartDate))
if @backupLevelView is null
begin
	set @backupLevelView = 0
end
/*
UPDATE  #NTVMPropsList
SET     vmSize = (CASE WHEN @backupLevelView IN (1, 2) THEN -1 ELSE vmSize END)
        , vmUsedSpace = (CASE WHEN @backupLevelView = 1 THEN -1 ELSE vmUsedSpace END)
        , vmCBTStatus = (CASE WHEN @backupLevelView IN (1, 2) THEN 'N/A' ELSE vmCBTStatus  END)
*/
UPDATE  #NTVMPropsList
set attrval =  (CASE WHEN @backupLevelView IN (1, 2) THEN '-1' ELSE attrval END)
where attrname='vmSize'
UPDATE  #NTVMPropsList
set attrval =  (CASE WHEN @backupLevelView = 1 THEN '-1'  ELSE attrval END)
where attrname='vmUsedSpace'
UPDATE  #NTVMPropsList
set attrval =  (CASE WHEN @backupLevelView IN (1, 2) THEN 'N/A' ELSE attrval END)
where attrname='vmCBTStatus'
-- Update vmHArdwareVersion and vmOperatingSystem value from Client Prop
update #NTVMPropsList
set attrVal =(SELECT TOP 1 attrVal FROM App_Clientprop WHERE componentNameid = @vmClientId AND attrName = 'Virtual Machine Hardware Version' AND modified = 0)
where attrname ='vmHardwareVersion'
update #NTVMPropsList
set attrVal =(SELECT TOP 1 attrVal FROM App_Clientprop WHERE componentNameid = @vmClientId AND attrName = 'Operating System Name' AND modified = 0)
where attrname ='vmOperatingSystem'
DELETE #NTVMPropsList
where attrname in ('vmBackupEndTime', 'vmBackupStartTime')
and attrval='0'
-- Convert start time and end time to human readable strings.
update #NTVMPropsList
set attrVal = dbo.UTCToLocalDateTimeConversionManaged(DATEADD(second, convert(bigint,attrVal), '01/01/1970'), @csTimeZone)
where attrname in ('vmBackupEndTime', 'vmBackupStartTime')
and isnumeric(attrVal)=1
-- Convert space to proper format
update #NTVMPropsList
set attrVal = dbo.GetSizeString(convert(bigint,attrVal))
where attrname in ('vmGuestSize', 'vmUsedSpace', 'vmSize')
and isnumeric(attrVal)=1
update #NTVMPropsList
set attrVal = CASE WHEN attrval = '1' then 'YES' ELSE 'NO' END
where attrname in ('vmIsPoweredOffByCurrJob', 'vmIsGuestSizeValid')
and isnumeric(attrVal)=1
update #NTVMPropsList
set attrVal = CASE WHEN attrval = '0' Then 'N/A'
	when attrval = '1' Then 'VCBMounter'
	when attrval = '2' Then 'VADP'
	end
where attrname = 'vmBackupType'
and isnumeric(attrVal)=1
declare @additionalVMInfoData nvarchar(max)
set @additionalVMInfoData = ''
select @additionalVMInfoData = COALESCE(@additionalVMInfoData + 'MsgNewLine_MsgTab_', '') +  dbo.fn_EvFormatEventMsgText(0,@localeId,vmPropMessageIdMap.messageId, 0,2) + ' : ' + NTVMPropsList.attrval
from #NTVMPropsList NTVMPropsList
inner join @vmPropMessageIdMap vmPropMessageIdMap on
vmPropMessageIdMap.attrname = NTVMPropsList.attrname
if @additionalVMInfoData is not NULL and len(@additionalVMInfoData)>0
begin
set @additionalVMInfoData = dbo.fn_EvFormatEventMsgText(0,@localeId,(1184 | (CAST(POWER(2, 24) AS BIGINT) * 74)), 0,2) + @additionalVMInfoData
end
select @additionalVMInfoData
GO

IF EXISTS (select * from GxQscripts where name = 'br_ntRetrieveAdditionalVMInfo')
	delete from GxQscripts where name = 'br_ntRetrieveAdditionalVMInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_ntRetrieveAdditionalVMInfo')
	delete from GXDBVersions where aliasname = 'br_ntRetrieveAdditionalVMInfo'
GO

insert into GXDBVersions values(2, 'br_ntRetrieveAdditionalVMInfo',  '00010002000200040000', 'br_ntRetrieveAdditionalVMInfo', '00010002000200040000')
GO

