

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/br_ntProcessSpoolQueue.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/CTE/Modules/Source/DbLib/sp/br_ntProcessSpoolQueue.sp,v $ $Id: br_ntProcessSpoolQueue.sp,v 1.6.32.1 2017/02/10 20:53:27 sjohnson Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   br_ntProcessSpoolQueue   - Check if any new entries were added to the spoolQueue
--								and Add them to messageHistory/message tracking queues
--								as indicated.
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: br_ntProcessSpoolQueue <<<'

IF EXISTS (select * from sysobjects where name='br_ntProcessSpoolQueue')
	drop procedure br_ntProcessSpoolQueue
IF EXISTS (select * from GxQscripts where name='br_ntProcessSpoolQueue')
	delete from GxQscripts where name = 'br_ntProcessSpoolQueue'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_ntProcessSpoolQueue')
	delete from GXDBVersions where aliasname = 'br_ntProcessSpoolQueue'
GO
print '... Creating Procedure: br_ntProcessSpoolQueue'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure br_ntProcessSpoolQueue
--	+-------------------------------------------------------------------------------+
--  | PARAMETERS   &   OUTPUTS														|
--	+-------------------------------------------------------------------------------+
  @QNetID int
AS
--  'MAGIC' Numbers used here, as defined in "CNAlertDefines.h"
--	----------------------------------------------------------
--#define NT_NOTIF_STATE_DETECTED				1	-- Condition has been detected
--#define NT_NOTIF_STATE_CONTENTCHANGED			2	-- Condition has been detected
--#define NT_NOTIF_STATE_CLEARED				0	-- Condition has cleared
--	+-------------------------------+
--	| LOCAL VARIABLE DECLARATION	|
--	+-------------------------------+
declare @timePeriod				integer
declare @triggerBitMap			integer
declare @triggerEvalCriteria	integer
declare @triggerValue			integer
declare @triggerValue2			integer
declare @triggerTime			datetime
declare @notificationId			integer             -- PK referenced by everybody!
declare @escalationLevel		integer
declare @notifState				integer
declare @errVal					integer
declare @errString				nvarchar(1024)
declare @processCount			integer
declare @spReturnCode_E1		integer
declare @spReturnCode_E2		integer
declare @oldEscalatedState		integer
declare @newSpoolQueueStatus	integer
--	+-------------------------------+
--	| LOCAL VARIABLE INITIALIZATION	|
--	+-------------------------------+
set @processCount = 0
set @errVal       = @processCount
--	+--------------------------------------------+
--	| LOOP FOR ALL THE "NEW" SPOOL QUEUE ENTRIES |
--	+--------------------------------------------+
DECLARE	NTspoolQueue_Cursor CURSOR FOR
	SELECT  NTnotificationID, triggerTime, escalationLevel, notifState
		FROM	NTSpoolQueue
		WHERE	status = 0
		ORDER BY	triggerTime, NTnotificationID
OPEN NTspoolQueue_Cursor
FETCH NEXT FROM NTspoolQueue_Cursor INTO @notificationId, @triggerTime, @escalationLevel, @notifState
--	+---------------------------------------------------------------------------------------+
--	| ASSUMPTIONS:																			|
--	|	o IF AN ESCALATION LEVEL 2 'SET' IS REC'D, IMPLIES A LEVEL 1 IS ALSO SET			|
--	|	o IF AN ESCALATION LEVEL 1 IS CLEARED, AND AN ESCALATION 2 WAS PREVIOUSLY SET, 		|
--	|	   THE LEVEL 2 IS ALSO CLEARED														|
--	|   0 IF A LEVEL 1 IS SET AND a LEVEL 2 WAS PREVIOUSLY SET, THE LEVEL 2 IS NOW CLEAR	|
--	+---------------------------------------------------------------------------------------+
WHILE @@FETCH_STATUS = 0
BEGIN
		if exists(select 1 from NTNotificationRule where id = @notificationId and revision = 0 and status=2)
		begin
			-- In case alert is already deleted, then we dont process these entries and push it into Message history unnecessarily
			update NTspoolQueue set status = 99 where triggerTime = @triggerTime AND NTnotificationID = @notificationID
			FETCH NEXT FROM NTspoolQueue_Cursor INTO @notificationId, @triggerTime, @escalationLevel, @notifState
			continue
		end
		update NTspoolQueue set status = 1 where triggerTime = @triggerTime AND NTnotificationID = @notificationID
		set @processCount = @processCount +1
		set @oldEscalatedState	= (SELECT NTmessageState FROM NTmessages WHERE NTnotificationID = @notificationId AND escalationLevel = 2)
IF (@notifState & 1) <> 0 OR (@notifState & 2) <> 0
		BEGIN
			EXEC br_ntCheckAndAddHistory	@notificationId, @triggerTime, @escalationLevel, @notifState, @spReturnCode_E2 OUTPUT
		END
IF ( @NotifState = 0)					-- 'NT_NOTIF_STATE_CLEARED'
		BEGIN
			EXEC br_ntCheckAndAddHistory	@notificationId, @triggerTime, @escalationLevel, @notifState, @spReturnCode_E2 OUTPUT
			if @escalationLevel=2
			begin
				-- If certain entities are cleared in escalated state, we should send clear for regular state also
				EXEC br_ntCheckAndAddHistory	@notificationId, @triggerTime, 1, @notifState, @spReturnCode_E1 OUTPUT
			end
		END
--		+---------------------------------------------------------------------------+
--		| NOW THAT WE'VE CHECKED THE SPOOL QUEUE, SEE IF WE NEED TO SET UP MESSAGES	|
--		| We are smudging the SpoolQueue Status to indicate:						|
--		|		99: Entry did not result in Notifications being sent				|
--		|		 2: Entry causes notifications to be sent							|
--		+---------------------------------------------------------------------------+
		SET @newSpoolQueueStatus = 99
		IF (@spReturnCode_E1 = @notificationId OR @spReturnCode_E2 = @notificationId)
		BEGIN
			set @newSpoolQueueStatus = 2
		END
--		EVENTUALLY WE WILL  DELETE THE ROW HERE, BUT FOR NOW IT WILL BE USEFUL TO KEEP AROUND IN CASE WE NEED TO DO A PM
--		----------------------------------------------------------------------------------------------------------------
		update NTspoolQueue set status = @newSpoolQueueStatus
		where triggerTime = @triggerTime AND NTnotificationID = @notificationID and escalationLevel=@escalationLevel
		FETCH NEXT FROM NTspoolQueue_Cursor INTO @notificationId, @triggerTime, @escalationLevel, @notifState
END
	set @errVal       = @processCount
	GOTO  PROCESS_SPOOLQUEUE_EXIT
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  END
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
PROCESS_SPOOLQUEUE_EXIT:
CLOSE 		NTspoolQueue_Cursor
DEALLOCATE	NTspoolQueue_Cursor
select @errVal, @errString
GO

IF EXISTS (select * from GxQscripts where name = 'br_ntProcessSpoolQueue')
	delete from GxQscripts where name = 'br_ntProcessSpoolQueue'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_ntProcessSpoolQueue')
	delete from GXDBVersions where aliasname = 'br_ntProcessSpoolQueue'
GO

insert into GXDBVersions values(2, 'br_ntProcessSpoolQueue',  '00010006003200010000', 'br_ntProcessSpoolQueue', '00010006003200010000')
GO

