

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/br_ntProcessMetricsResults.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/br_ntProcessMetricsResults.sp,v $ $Id: br_ntProcessMetricsResults.sp,v 1.6.48.1 2017/02/10 21:21:45 sjohnson Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   br_ntProcessMetricsResults
--					 - Fetch the name value pair of result set in either html or text format
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: br_ntProcessMetricsResults <<<'

IF EXISTS (select * from sysobjects where name='br_ntProcessMetricsResults')
	drop procedure br_ntProcessMetricsResults
IF EXISTS (select * from GxQscripts where name='br_ntProcessMetricsResults')
	delete from GxQscripts where name = 'br_ntProcessMetricsResults'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_ntProcessMetricsResults')
	delete from GXDBVersions where aliasname = 'br_ntProcessMetricsResults'
GO
print '... Creating Procedure: br_ntProcessMetricsResults'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure br_ntProcessMetricsResults
  @localeId int,
  @isHtmlFormat int,
  @ntRuleId int,
  @alarmId int,
  @resultXml xml
AS
  DECLARE @resultSet nvarchar(max)
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
if @isHtmlFormat=1
begin
	select * from dbo.getHTMLTableForAlerts(@resultXml)
	return;
end
DECLARE @columnsList TABLE (id INT IDENTITY, columnName NVARCHAR(256),shldBePartOfOutput int)
DECLARE @columnName NVARCHAR(256)
DECLARE @shldBePartOfOutput int
DECLARE @numberOfRows INT
SELECT @numberOfRows = @resultXml.value('count(App_ExternalQueryResults/resultSet)', 'int')
INSERT INTO @columnsList(columnName,shldBePartOfOutput)
SELECT	T.cc.value('@val', 'nvarchar(1024)'),1
FROM	@resultXml.nodes('App_ExternalQueryResults/colList/columnName') T(cc)
Update @columnsList
set shldBePartOfOutput = 0
WHERE	columnName IN ('CommServ UniqueId', 'CommServer IP', 'CommServer GUID', 'Running Time in Seconds', 'CommCell ID')
OR	columnName LIKE '%<HIDDEN>%'
-- For text format, only one row will be present at a time.
declare @resultSetTbl table
(
	colIndex int ,
	colValue nvarchar(max)
)
INSERT INTO @resultSetTbl(colIndex,colValue)
SELECT	T.cc.value('for $i in . return count(../*[local-name(.)=''colValues'' and . << $i])', 'int')+1,
		T.cc.value('@val', 'nvarchar(1024)')
FROM	@resultXml.nodes('App_ExternalQueryResults/resultSet/colValues') T(cc)
declare @customAlarmProps xml
select @customAlarmProps = extendedProps from CustomAlarmProps
where AlarmId=@alarmId
declare @snmpDescription nvarchar(max)
set @snmpDescription = ''
select @snmpDescription = T.cc.value('@SNMPDescription', 'nvarchar(max)')
FROM	@customAlarmProps.nodes('/alarmProps') T(cc)
if @snmpDescription is null
begin
	set @snmpDescription = ''
end
declare @textReportResult nvarchar(max)
set @textReportResult = ''
if len(@snmpDescription)=0
begin
	select @textReportResult = @textReportResult +' , ' + IsNull(C.columnName + ' : ' + Result.colValue,'')
	from @resultSetTbl Result inner join @columnsList C on
	Result.colIndex = C.id
	set @textReportResult = rtrim(ltrim(@textReportResult))
	if (charindex(',',@textReportResult)>0)
	begin
		set @textReportResult = substring(@textReportResult,2,len(@textReportResult)-1)
	end
end
else
begin
	-- replace ## in @snmpDescription with &.. this is done from webconsole side to send html tags in snmp description properly.
	set @snmpDescription = replace(@snmpDescription,'##','&')
	set @textReportResult = @snmpDescription
	declare @reportCriteria nvarchar(max)
	declare @reportDisplayName nvarchar(max)
	declare @commcellName nvarchar(max)
	set @commcellName = ''
	select @reportCriteria = IsNull(T.cc.value('@description', 'nvarchar(max)'),''),
		@reportDisplayName = IsNull(T.cc.value('@alarmName', 'nvarchar(max)'),'')
	FROM	@customAlarmProps.nodes('/alarmProps') T(cc)
	select @commcellName = aliasName from App_Commcell
	where id=2
	-- Also replace other tokens like <ALERT NAME>,<REPORT NAME>,<REPORT CRITERIA>. These tokens will be html escaped.
	select @textReportResult = replace(@textReportResult,'$'+ltrim(rtrim(C.columnName))+'$',Result.colValue)
	from @resultSetTbl Result inner join @columnsList C on
	Result.colIndex = C.id
	-- ALERT_TOKEN_METRICS_REPORT_NAME : <REPORT NAME> reportName
	-- ALERT_TOKEN_PARAM_NAME : <REPORT PARAM NAME>   paramName
	-- ALERT_TOKEN_REPORT_CRITERIA_NAME : <REPORT CRITERIA> AlarmProps -> description
	-- ALERT_TOKEN_METRICS_REPORT_DISPLAY_NAME : <REPORT DISPLAY NAME> Alarm name
	-- ALERT_TOKEN_COMMCELL_NAME - Commcell Name of the commcell which sent alert and not related to commcell on which alert is created.
	-- This token is mostly not needed but pushed in case some customer asks for it.
	select @textReportResult = replace(@textReportResult,
dbo.getHtmlEscapedString(dbo.fn_EvFormatEventMsgText(0,@localeId,(1111 | (CAST(POWER(2, 24) AS BIGINT) * 74)), 0,2),1),
		dbo.fn_WeedOutHtmlTags(A.reportName))
	from CustomAlarmProps A
	where AlarmId = @alarmId
	set @textReportResult = replace(@textReportResult,
dbo.getHtmlEscapedString(dbo.fn_EvFormatEventMsgText(0,@localeId,(1109 | (CAST(POWER(2, 24) AS BIGINT) * 74)), 0,2),1),
		dbo.fn_WeedOutHtmlTags(@reportDisplayName))
	set @textReportResult = replace(@textReportResult,
dbo.getHtmlEscapedString(dbo.fn_EvFormatEventMsgText(0,@localeId,(1112 | (CAST(POWER(2, 24) AS BIGINT) * 74)), 0,2),1),
		dbo.fn_WeedOutHtmlTags(@reportCriteria))
	set @textReportResult = replace(@textReportResult,
dbo.getHtmlEscapedString(dbo.fn_EvFormatEventMsgText(0,@localeId,(4 | (CAST(POWER(2, 24) AS BIGINT) * 74)), 0,2),1),
		dbo.fn_WeedOutHtmlTags(@commcellName))
end
select @textReportResult
return
SET NOCOUNT OFF
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  END
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
GO

IF EXISTS (select * from GxQscripts where name = 'br_ntProcessMetricsResults')
	delete from GxQscripts where name = 'br_ntProcessMetricsResults'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_ntProcessMetricsResults')
	delete from GXDBVersions where aliasname = 'br_ntProcessMetricsResults'
GO

insert into GXDBVersions values(2, 'br_ntProcessMetricsResults',  '00010006004800010000', 'br_ntProcessMetricsResults', '00010006004800010000')
GO

