

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/br_ntProcessDiscoveredVMs.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems,  Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems,  Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/br_ntProcessDiscoveredVMs.sp,v $ $Id: br_ntProcessDiscoveredVMs.sp,v 1.4.12.6 2020/09/03 14:44:50 snandhini Exp $";
-- 	+---------------------------------------------------+
--	| 			PROCEDURE : "rptGetBackupVMs"			|
-- 	+---------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='br_ntProcessDiscoveredVMs')
BEGIN
	print '>>> Drop Stored Procedure: br_ntProcessDiscoveredVMs <<<'
	drop procedure br_ntProcessDiscoveredVMs
END
IF EXISTS (select * from GxQscripts where name='br_ntProcessDiscoveredVMs')
	delete from GxQscripts where name = 'br_ntProcessDiscoveredVMs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_ntProcessDiscoveredVMs')
	delete from GXDBVersions where aliasname = 'br_ntProcessDiscoveredVMs'
GO
print '... Creating Procedure: br_ntProcessDiscoveredVMs'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure br_ntProcessDiscoveredVMs
AS
  DECLARE @o_retCode INTEGER;
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
declare @i_eventId int
declare @i_alertType int
DECLARE @nowTime        INT = dbo.GetUnixTime (GetUTCdate())
DECLARE @nowTimeNonUnixCS DATETIME = GETDATE()
IF OBJECT_ID('tempDb..#DetectedAlertsVSAV2') IS NOT NULL
	DROP TABLE #DetectedAlertsVSAV2
CREATE TABLE #DetectedAlertsVSAV2 (
	eventId INT,  --
	parentEntity NVARCHAR(1024), -- parent entity for child entities. Its null if synthfull runs on parent entity
	PRIMARY KEY(eventId)
)
INSERT INTO #DetectedAlertsVSAV2(eventId, parentEntity)
SELECT NTDetectedAlerts.eventId, CAST(T.EntityXml AS NVARCHAR(1024))
FROM NTDetectedAlerts (NOLOCK)
INNER JOIN NTDDpDr (NOLOCK) ON NTDetectedAlerts.eventId = NTdDpDr.eventId
AND processStat = 128 and alertType = 3 ---  eAlertStatusVSASubclient = 0x80
AND occurtime < @nowTimeNonUnixCS
INNER JOIN App_ClientProp (NOLOCK) ON App_ClientProp.componentNameID = NTDDpDr.clientId
AND App_ClientProp.attrname = 'Indexingv2_Vsa'
AND App_ClientProp.modified = 0
AND App_ClientProp.attrVal  = '1'
-- For regular synthetic full schedules pick up parent entity from jobdata link
-- for automatic synthetic full schedule, job data link wont be there since parent wont be there.
INNER JOIN JMJobDataLink (NOLOCK) ON JMJobDataLink.childJobID = NTdDpDr.jobId_l
AND JMJobDataLink.LinkType = 7 -- LINK_TYPE_FOR_VSA_V2_PARENT_CHILD
INNER JOIN App_Application (NOLOCK) ON App_application.id = JMJobDataLink.parentAppId
OUTER APPLY
(
	SELECT App_application.clientId '@clientId', App_application.appTypeId '@applicationId',App_application.instance '@instanceId',
         App_application.backupset '@backupsetId',App_application.Id '@subclientId'
	FOR XML PATH('CvEntities_GenericEntity')
) T (EntityXml)
UNION
SELECT eventId,CAST(
	(
		SELECT clientId '@clientId', appTypeId '@applicationId',instance '@instanceId',
			 backupset '@backupsetId',subclientId '@subclientId'
		FOR XML PATH('CvEntities_GenericEntity'),TYPE
	) AS NVARCHAR(1024))
FROM
(
	SELECT NTDetectedAlerts.eventId, App_application.clientId , App_application.appTypeId ,App_application.instance,
         App_application.backupset,App_application.Id subclientId,
		 ROW_NUMBER() OVER (PARTITION BY NTDetectedAlerts.eventId ORDER BY Parents.parentjobId DESC) AS RowNumber
	FROM NTDetectedAlerts (NOLOCK)
	INNER JOIN NTDDpDr (NOLOCK) ON NTDetectedAlerts.eventId = NTdDpDr.eventId
	AND processStat = 128 and alertType = 3 ---  eAlertStatusVSASubclient = 0x80
	AND occurtime < @nowTimeNonUnixCS
	INNER JOIN App_ClientProp (NOLOCK) ON App_ClientProp.componentNameID = NTDDpDr.clientId
	AND App_ClientProp.attrname = 'Indexingv2_Vsa'
	AND App_ClientProp.modified = 0
	AND App_ClientProp.attrVal  = '1'
	-- For automatic synthetic full schedule, job data link wont be there since parent wont be there.
	LEFT JOIN JMJobDataLink (NOLOCK) ON JMJobDataLink.childJobID = NTdDpDr.jobId_l
	AND JMJobDataLink.LinkType = 7 -- LINK_TYPE_FOR_VSA_V2_PARENT_CHILD
	INNER JOIN JMJobDataLink (NOLOCK) Parents ON Parents.childAppid = NTdDpDr.subClientId
	AND Parents.LinkType = 7 -- LINK_TYPE_FOR_VSA_V2_PARENT_CHILD
	INNER JOIN App_Application (NOLOCK) ON App_application.id = Parents.parentAppId
	WHERE JMJobDataLink.childJobID IS NULL
) T
WHERE RowNumber = 1
BEGIN TRY
	BEGIN TRAN
	-- Process VSA v2 alerts (they are for synthfull jobs) and set parent entity if needed
	Insert into NTDParams(eventId,type,value,created) -- enumVSAParentEntity : 274
	SELECT eventId,274, parentEntity, @nowTime
	FROM #DetectedAlertsVSAV2
	WHERE ParentEntity IS NOT NULL
	Commit tran
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	if @@tranCount>0
	BEGIN
		rollback tran
	END
	SELECT 0
	-- In case of error return.
	RETURN
END CATCH
IF ( CURSOR_STATUS('global', 'DetectedAlertsCursor') >= 0   OR CURSOR_STATUS('local', 'DetectedAlertsCursor') >= 0 )  -- CLOSE CURSOR IF OPEN
	CLOSE DetectedAlertsCursor
IF ( CURSOR_STATUS('global','DetectedAlertsCursor') = -1     OR CURSOR_STATUS('local','DetectedAlertsCursor') = -1 )
	DEALLOCATE DetectedAlertsCursor
DECLARE DetectedAlertsCursor CURSOR FOR
select NTDetectedAlerts.eventId, NTDetectedAlerts.alertType from NTDetectedAlerts
INNER JOIN NTDDpDr (NOLOCK) ON NTDetectedAlerts.eventId = NTdDpDr.eventId
AND processStat = 128 and alertType in (3, 4) ---  eAlertStatusVSASubclient = 0x80
	AND occurtime < @nowTimeNonUnixCS
	LEFT JOIN App_ClientProp (NOLOCK) ON App_ClientProp.componentNameID = NTDDpDr.clientId
	AND App_ClientProp.attrname = 'Indexingv2_Vsa'
	AND App_ClientProp.modified = 0
	AND App_ClientProp.attrVal  = '1'
where App_ClientProp.attrVal IS NULL OR alertType = 4 --restore jobs still follow v1 model
OPEN DetectedAlertsCursor
FETCH NEXT FROM DetectedAlertsCursor INTO @i_eventId, @i_alertType
WHILE @@FETCH_STATUS = 0
BEGIN
	declare @i_bkpJobId int = 0
	set @i_bkpJobId = 0
	select @i_bkpJobId = jobid_l from NTDDpdr
	where eventId = @i_eventId
-- Now put everything below under a tran
begin try
	begin tran
	-- In case jobId is 0, then we go to end of sp
	if (@i_bkpJobId<=0)
	begin
		GOTO END_OF_SP
	end
	declare @i_commcellId int = 2
	DECLARE @tblClients			TABLE (t_clId INT)
	DECLARE @proxyClientId		INTEGER
	select @proxyClientId = clientId from NTDDpdr where eventId=@i_eventId
	DECLARE     @tblJob TABLE(jobid INT, commcellId INT, appId INT, servStartDate INT)
IF @i_alertType = 3
	BEGIN
		INSERT INTO @tblJob
		SELECT jobid, commCellId, appid, servStartDate FROM JMBkpStats WHERE jobId = @i_bkpJobId AND commcellId = @i_commcellId
		UNION
		SELECT B.jobId, B.commcellId, B.applicationId, J.jobStartTime FROM JMBkpJobInfo B, JMJobInfo J WHERE J.jobId = B.jobId AND J.commCellId = B.commcellId AND B.jobId = @i_bkpJobId AND B.commcellId = @i_commcellId
	END
	ELSE
	BEGIN
		INSERT INTO @tblJob
		SELECT jobid, commCellId, 0, servStartTime FROM JMRestoreStats WHERE jobId = @i_bkpJobId AND commcellId = @i_commcellId
		UNION
		SELECT B.jobId, B.commcellId, 0, J.jobStartTime FROM JMRstJobInfo B, JMJobInfo J WHERE J.jobId = B.jobId AND J.commCellId = B.commcellId AND B.jobId = @i_bkpJobId AND B.commcellId = @i_commcellId
	END
	IF object_id('tempdb.dbo.#NTVMList') IS NOT NULL
		DROP TABLE #NTVMList
	DECLARE @releaseId INT
	DECLARE @servStartDate INT
	DECLARE @subclientId INT
	SELECT @servStartDate = servStartDate FROM @tblJob
	SELECT @subclientId = appId FROM @tblJob
	SELECT @releaseId = ISNULL(MAX(ReleaseId), 15) FROM LicUsageHistory WHERE CId = @proxyClientId AND OpTimeUTC <= dbo.GetDateTime(@servStartDate)  AND AppType = 106
	if @subclientId is NULL
	begin
		GOTO END_OF_SP
	end
	IF object_id('tempdb.dbo.#NTVMList') IS NOT NULL
		DROP TABLE #NTVMList
	CREATE TABLE #NTVMList
	(
		vmClientId				INT,
		vmName					NVARCHAR(510),
		vmStatus				INTEGER,
		failureReason			NVARCHAR(MAX),
		vmHost					NVARCHAR(MAX),
		criteria				int,
		rowOrder				int
	)
	Delete from #NTVMList
	IF @releaseId < 14
	BEGIN
		GOTO END_OF_SP
	END
	INSERT	INTO #NTVMList
	SELECT	distinct C.Id, C.name, 0, N'', N'',0,0
	FROM	App_vmprop Q
	inner join App_client C on Q.vmClientId=c.Id
	WHERE	Q.jobId = @i_bkpJobId
	AND	Q.commcellId = @i_commcellId
	--- Update rowOrder
	UPDATE	NTVMList
	set rowOrder = T.RowOrder
	from #NTVMList NTVMList,
	(
		select vmClientId,row_number() over (order by vmClientId) as RowOrder
		from #NTVMList
	) T
	where T.vmClientID = NTVMList.vmClientID
	UPDATE	#NTVMList
	SET		vmStatus			= ISNULL(A.attrVal, 0)
	FROM	#NTVMList V
	left join App_vmprop A
	on @i_bkpJobId = A.jobId AND @i_commcellId = A.commCellId AND V.vmClientId = A.VMclientId
	and A.attrName = 'vmStatus'
	UPDATE	#NTVMList
	SET		failureReason = ISNULL(A.attrVal, N'')
	FROM	#NTVMList V
	left join App_vmprop A
	on @i_bkpJobId = A.jobId AND @i_commcellId = A.commCellId AND V.vmClientId = A.VMclientId
	and A.attrName = 'vmFailureReason'
	UPDATE	#NTVMList
	SET		vmHost = ISNULL(A.attrVal, N'')
	FROM	#NTVMList V
	left join App_vmprop A
	on @i_bkpJobId = A.jobId AND @i_commcellId = A.commCellId AND V.vmClientId = A.VMclientId
	and A.attrName = 'vmHost'
	-- If the job is failed or killed, mark all VMs failed.
	if exists(select 1 from NTDetectedAlerts where eventId = @i_eventId and
		(criteria = 3 or status=3001))
	begin
		-- Set the status to job failed.
		UPDATE	#NTVMList
		set criteria=3,
		vmStatus=1
	end
	else
	begin
		UPDATE	#NTVMList
		set criteria=3 --Failed
		where vmStatus=1 --VMClientBkupStatus_failed
		UPDATE	#NTVMList
		set criteria=1 --Suceeded
		where vmStatus=0 --VMClientBkupStatus_COMPLETED
		UPDATE	#NTVMList
		set criteria=57 --NT_SUCCESS_WITH_ERRORS
		where vmStatus=3 --VMClientBkupStatus_PARTIAL_SUCCESS
	end
	IF object_id('tempdb.dbo.#NewEntriesTable') IS NOT NULL
		DROP TABLE #NewEntriesTable
	CREATE TABLE #NewEntriesTable
	(
		eventId int,
		rowOrder int identity (1,1)
	)
	delete from #NewEntriesTable
	-- For each discovered VM client, insert an entry into NTDetectedAlerts.
	-- Then insert values for Params for each eventId
	Insert into NTDetectedAlerts(criteria,alertType,category,status,processStat,occurTime,processTime)
	OUTPUT INSERTED.[eventId]
	INTO #NewEntriesTable ([eventId])
	select criteria,@i_alertType,1,0,1|0x100,getdate(),getdate()
	from #NTVMList
	-- Insert same details as VSA backup job for these entries
	Insert into NtDDpdr
	select  NewEntriesTable.EventId,jobId_h,jobId_l,startTime,endTime,schedTime,clientId,appTypeId,instanceId,backupSetId,subClientId,protectedCount,failedCount,skippedCount,mediaRequired,libraryId,backupLevel,
	container,exportLoc,mediaLabel,taskId,schedPolicyId,isVSS,isRDJob
	from NTDDpdr,#NewEntriesTable NewEntriesTable
	where NTDDpdr.eventId=@i_eventId
	/*
	enumVMName = 246,
   enumVMHostName = 247,
   enumVMFailureReason = 248,
   enumVMStatus = 249,
   enumVMOrigEventId = 250,
   enumVMClientId = 251
   */
	Insert into NTDParams(eventId,type,value,created)
	select NewEntriesTable.eventId,	246,NTVMList.vmName,@nowTime	--enumVMName
	from #NewEntriesTable NewEntriesTable,#NTVMList NTVMList
	where NewEntriesTable.rowOrder = NTVMList.rowOrder
	union
	select NewEntriesTable.eventId,	247,NTVMList.vmHost,@nowTime --enumVMHostName
	from #NewEntriesTable NewEntriesTable,#NTVMList NTVMList
	where NewEntriesTable.rowOrder = NTVMList.rowOrder
	union
	select NewEntriesTable.eventId,	248,substring(NTVMList.failureReason,1,1023),@nowTime --enumVMFailureReason
	from #NewEntriesTable NewEntriesTable,#NTVMList NTVMList
	where NewEntriesTable.rowOrder = NTVMList.rowOrder
	union
	select NewEntriesTable.eventId,	249,convert(nvarchar(max),NTVMList.vmStatus),@nowTime --enumVMStatus
	from #NewEntriesTable NewEntriesTable,#NTVMList NTVMList
	where NewEntriesTable.rowOrder = NTVMList.rowOrder
	union
	select NewEntriesTable.eventId,	250,convert(nvarchar(max),@i_eventId),@nowTime --enumVMOrigEventId
	from #NewEntriesTable NewEntriesTable
	union
	select NewEntriesTable.eventId,	251,convert(nvarchar(max),NTVMList.vmClientId),@nowTime --enumVMClientId
	from #NewEntriesTable NewEntriesTable,#NTVMList NTVMList
	where NewEntriesTable.rowOrder = NTVMList.rowOrder
	END_OF_SP:
	IF object_id('tempdb.dbo.#NTVMList') IS NOT NULL
		DROP TABLE #NTVMList
	Commit tran
end try
begin catch
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	if @@tranCount>0
	begin
		rollback tran
	end
end catch
	FETCH NEXT FROM DetectedAlertsCursor INTO @i_eventId, @i_alertType
END
IF OBJECT_ID('tempDb..#DetectedAlertsVSAV2') IS NOT NULL
	DROP TABLE #DetectedAlertsVSAV2
Update NTdetectedAlerts
SET processStat = 1
FROM NTdetectedAlerts
WHERE processStat = 128 and alertType in (3, 4) ---  eAlertStatusVSASubclient = 0x80
AND occurtime < @nowTimeNonUnixCS
select 0
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'br_ntProcessDiscoveredVMs')
	delete from GxQscripts where name = 'br_ntProcessDiscoveredVMs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_ntProcessDiscoveredVMs')
	delete from GXDBVersions where aliasname = 'br_ntProcessDiscoveredVMs'
GO

insert into GXDBVersions values(2, 'br_ntProcessDiscoveredVMs',  '00010004001200060000', 'br_ntProcessDiscoveredVMs', '00010004001200060000')
GO

