

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/br_ntProcessCustomResults.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/br_ntProcessCustomResults.sp,v $ $Id: br_ntProcessCustomResults.sp,v 1.3.48.11 2019/04/18 11:31:05 snandhini Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   br_ntProcessMetricsResults
--					 - Fetch the name value pair of result set in either html or text format
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='br_ntProcessCustomResults')
BEGIN
	print '>>> Drop Stored Procedure: br_ntProcessCustomResults <<<'
	drop procedure br_ntProcessCustomResults
END
IF EXISTS (select * from GxQscripts where name='br_ntProcessCustomResults')
	delete from GxQscripts where name = 'br_ntProcessCustomResults'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_ntProcessCustomResults')
	delete from GXDBVersions where aliasname = 'br_ntProcessCustomResults'
GO
print '... Creating Procedure: br_ntProcessCustomResults'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure br_ntProcessCustomResults
  @resultXml xml,
  @queryId int,
  @notifRuleId int
AS
  DECLARE @resultSet nvarchar(max)
  DECLARE @resultSetXml nvarchar(max)
  DECLARE @recipientList nvarchar(2048)
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @columnsList TABLE (id INT IDENTITY, columnName NVARCHAR(256),shldBePartOfOutput int, alertrecipient int)
DECLARE @columnName NVARCHAR(256)
DECLARE @shldBePartOfOutput int
DECLARE @numberOfRows INT
DECLARE @generatexmlOuput int = 0
DECLARE @CustomAlertType INT = 0
DECLARE @newTemplate INT = ISNULL((SELECT value FROM GXGlobalParam WHERE name='UseNewAlertTemplate'),0)
set @resultSetXml = ''
-- For workflow notification type alone, we compute result set in XML format.
-- Check whether the rule has workflow notif type selected.
-- For workflow notification type alone, we compute result set in XML format. this we do for custom rules only and not for metrics and lm rules
    -- Check whether the rule has workflow notif type selected.
IF EXISTS (SELECT * FROM NTnotificationRule WHERE Id = @notifRuleId AND revision > 0 AND ((notifType & 65536) <> 0))
    BEGIN
        SET @generatexmlOuput = 1
	END
SELECT @CustomAlertType = ISNULL(convert(xml,NTQueryList.xmlInfo).value('(App_AdditionalQueryDetails/externalQueryEntity/@queryType)[1]','int'),1)
FROM NTQueryList where queryId=@queryId
IF @CustomAlertType = 0 /*might have been the defaulted to 0 in the xml*/
	SET @CustomAlertType = 1 -- CUSTOM_QUERY
IF @CustomAlertType = 1 -- CUSTOM_QUERY
BEGIN
	INSERT INTO @columnsList(columnName,shldBePartOfOutput,alertRecipient)
	SELECT	columnFriendlyName,
	ISNULL(CONVERT(xml,convert(varchar(max),NTQueryColumnList.xmlInfo)).value('(App_AdditionalOutputColumnDetails/@includeInAlertOutput)[1]','bit'),1),
	ISNULL(CONVERT(xml,convert(varchar(max),NTQueryColumnList.xmlInfo)).value('(App_AdditionalOutputColumnDetails/@isAlertRecipient)[1]','bit'),0)
	FROM	NTQueryColumnList (NOLOCK)
	WHERE queryId = @queryId
	AND columnType=0
	AND xmlInfo is not null
	AND convert(xml,convert(varchar(max),NTQueryColumnList.xmlInfo)).exist('/App_AdditionalOutputColumnDetails')=1
	ORDER BY columnIndex
END
ELSE IF EXISTS (SELECT * FROM NTnotificationRule WHERE Id = @notifRuleId AND revision > 0 AND ((status & 16384) = 0))
BEGIN
	INSERT INTO @columnsList(columnName,shldBePartOfOutput,alertRecipient)
	SELECT	T.cc.value('@val', 'nvarchar(1024)'),
		1,
		0
		FROM @resultXml.nodes('App_CustomRuleResults/colList/columnName') T(cc)
END
ELSE -- ITs a trend alert. Fix the column list here.
BEGIN
	INSERT INTO @columnsList(columnName,shldBePartOfOutput,alertRecipient)
	SELECT	'File',1,0
	UNION ALL
	SELECT	'Current Trend',1,0
	UNION ALL
	SELECT	'Previous Trend',1,0
	UNION ALL
	SELECT	'Rate of change',1,0
END
-- In case column list is emtpy and its LM alert, then fix it
IF @CustomAlertType = 3 -- LM_SEARCH
AND NOT EXISTS(SELECT 1 FROM @columnsList)
BEGIN
	INSERT INTO @columnsList(columnName,shldBePartOfOutput,alertRecipient)
	SELECT	'ContentId',0,0
	UNION ALL
	SELECT	'BucketId',0,0
	UNION ALL
	SELECT	'Client',1,0
	UNION ALL
	SELECT	'File Name',1,0
	UNION ALL
	SELECT	'LogLine',1,0
END
SELECT @numberOfRows = @resultXml.value('count(App_CustomRuleResults/resultSet)', 'int')
IF @generatexmlOuput=1
BEGIN
	DECLARE @columnListXml xml
	SET @columnListXml = ( 	select columnName '@val', shldBePartOfOutput '@shldBePartOfOutput' from @columnsList
		order by id
		for xml path('columnName'),root('colList')
	)
	SET @resultSetXml = (select @columnListXml.query('.'),
		@resultXml.query('App_CustomRuleResults/resultSet')
		for xml path(''),root('App_CustomRuleResults'))
	SET @resultSetXml = dbo.GenerateXMLForWorkflowNotifType(@resultSetXml)
END
-- If the number of results is more than 1, then we generate table.
-- Else we generate name value pair.
if (@numberOfRows>1)
begin
	declare @colList xml
	set @colList = (select columnName '@val',
			shldBePartOfOutput '@shldBePartOfOutput',
			alertRecipient '@alertRecipient'
		from @columnsList
		order by id
		for xml path('columnName'),root('colList'))
	set @resultXml = (select @colList.query('.'),
		@resultXml.query('App_CustomRuleResults/resultSet')
		for xml path('App_CustomRuleResults'))
	select '<br>'+tblStr+'<br>',@resultSetXml,recipientList from dbo.getHTMLTableForCustomAlert(@resultXml)
end
else
begin
	declare @reportResult nvarchar(max)
	set @reportResult = ''
	-- Generate name value pair and return.
	-- For text format, only one row will be present at a time.
	declare @resultSetTbl table
	(
		colIndex int ,
		colValue nvarchar(max)
	)
	INSERT INTO @resultSetTbl(colIndex,colValue)
	SELECT	T.cc.value('for $i in . return count(../*[local-name(.)=''colValues'' and . << $i])', 'int')+1,
		dbo.DecodeInvalidXmlChar(T.cc.value('@val', 'nvarchar(1024)'))
	FROM	@resultXml.nodes('App_CustomRuleResults/resultSet/colValues') T(cc)
	select @reportResult =
	(CASE @newTemplate
	      WHEN 0 THEN @reportResult +'<li style="margin-top: 4px; margin-bottom: 4px">' + dbo.getHtmlEscapedString( IsNull(C.columnName + ' : ' + Result.colValue,'') , 1)+'</li>'
ELSE @reportResult + '<tr><td style="padding:7px 0px 7px 20px;"><font face="sans-serif" size="3" color="#444444"><b>'+dbo.getHtmlEscapedString( IsNull(C.columnName ,'') , 1)+'</b></font></td><td colspan="2"><font face="sans-serif" color="#444444" size="3">'+dbo.getHtmlEscapedString( IsNull(Result.colValue,'') , 1)+'</font></td></tr>'
	  END)
	from @resultSetTbl Result inner join @columnsList C on
	Result.colIndex = C.id
	where C.shldBePartOfOutput=1
	set @recipientList = ''
	select @recipientList += IsNull(Result.colValue,'') + ','
	from @resultSetTbl Result inner join @columnsList C on
	Result.colIndex = C.id
	where C.alertRecipient=1
	IF LEN(@recipientList)>0
		SET @recipientList = SUBSTRING(@recipientList,1,LEN(@recipientList)-1)
	set @reportResult = rtrim(ltrim(@reportResult))
	select @reportResult,@resultSetXml,@recipientList
end
return;
SET NOCOUNT OFF
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  END
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
GO

IF EXISTS (select * from GxQscripts where name = 'br_ntProcessCustomResults')
	delete from GxQscripts where name = 'br_ntProcessCustomResults'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_ntProcessCustomResults')
	delete from GXDBVersions where aliasname = 'br_ntProcessCustomResults'
GO

insert into GXDBVersions values(2, 'br_ntProcessCustomResults',  '00010003004800110000', 'br_ntProcessCustomResults', '00010003004800110000')
GO

