

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/br_ntPopulateLapTopAlerts.sp] ---------- 

-- ALLOW_COMMENTS_BELOW_HERE:
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: br_ntPopulateLapTopAlerts <<<'

IF EXISTS (select * from sysobjects where name='br_ntPopulateLapTopAlerts')
	drop procedure br_ntPopulateLapTopAlerts
IF EXISTS (select * from GxQscripts where name='br_ntPopulateLapTopAlerts')
	delete from GxQscripts where name = 'br_ntPopulateLapTopAlerts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_ntPopulateLapTopAlerts')
	delete from GXDBVersions where aliasname = 'br_ntPopulateLapTopAlerts'
GO
print '... Creating Procedure: br_ntPopulateLapTopAlerts'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure br_ntPopulateLapTopAlerts
--	+-------------------------------+
--	| PARAMETERS   &   OUTPUTS		|
--	+-------------------------------+
  @errorCode integer         OUTPUT,
  @errorString varchar(1024)   OUTPUT
AS
-- First check whether the minibrandid is either 'VMWare Protection' or 'Image archiving'
-- We dont want these laptop protection subscriber based alerts for those minibrands.
if exists(
	select * from GxGlobalParam where name='MiniBrandId' and modified = 0
	and value in ('106','107')
)
begin
    -- dont create the below default alerts.
	return
end
if exists(select 1 from GxGlobalParam
	   where name='PopulateLaptopAlerts')
begin
	print 'Default laptop alerts have already been created. So not creating'
	SELECT @errorCode, @errorString
	return
end
Insert into GxGlobalParam
select 'PopulateLaptopAlerts','1',0,0
DECLARE @nowTime			as integer	= dbo.GetUnixTime (GetUTCdate())
DECLARE @xmlEntities		AS nvarchar(MAX)= '<?xml version="1.0" encoding="UTF-16" standalone="no" ?><CVGui_CommCellTreeNode>  <associations _type_="2" /></CVGui_CommCellTreeNode>'
DECLARE	@emptyDateTime		AS datetime	= '1900-01-01 00:00:00.000'
DECLARE @dloClientGroup INT = ISNULL((SELECT MAX(id) FROM APP_ClientGroup WHERE flag&4096=4096 AND name = 'Laptop Clients'), 0)
if (@dloClientGroup>0)
begin
	set @xmlEntities = '<CVGui_CommCellTreeNode><associations _type_="28" clientGroupId="'+convert(nvarchar(max),@dloClientGroup)+'" clientGroupName="Laptop Clients" /></CVGui_CommCellTreeNode>'
end
DECLARE @localeId			AS integer		= 1
-- We need only 1 alert per message since client owners are being addressed. We cant send emails to owners of multiple clients.
DECLARE @status				AS integer		= 128 + 16		-- 'NNT_STATUS_LAPTOP_ALERT
DECLARE	@ruleState			AS integer		= 0
DECLARE	@reportOptions		AS integer		= 1		-- 'NT_REPORT_IMMEDIATE'
DECLARE @persistTimeSeconds AS integer		= 0
DECLARE	@categoryId			as integer 		= 1				-- 'NT_CATEGORY_JOB_MANAGEMENT'
DECLARE @adminID			as integer		= ISNULL((Select top 1 ID from UMUSERS where (flags & 67) = 67 AND Name <> 'ROMS'), 1)
DECLARE @SelCriteriaId		integer
DECLARE @htmldefaultTemplateForBackup nvarchar(max)
DECLARE @textdefaultTemplateForBackup nvarchar(max)
DECLARE @htmldefaultTemplateForRestore nvarchar(max)
DECLARE @textdefaultTemplateForRestore nvarchar(max)
set @htmldefaultTemplateForBackup = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><style type="text/css"><!--body { background-image: url(cid:bgc.png) }hr { height: 1px; color: black }.content2 { background-color: WHITE; font-family: Calibri, Tahoma, Arial; width: 800px; padding-right: 50px; border-spacing: 0; padding-left: 50px; padding-bottom: 25px; padding-top: 25px; color: #666666 }.content1 { width: 800px; border-spacing: 0; padding-top: 20px }--></style><div align="center"><table class="content1"><tr><td colspan="2"><img alt="Cloud image" src="cid:AlertCloud_header.PNG" border="0"></td></tr><tr><td width="10%">&#160;&#160;</td><td><p><font color="#666666" face="Calibri,sans-serif"><span>Your Computer: [<b>&lt;CLIENT NAME&gt;</b>] has not backed up in over: <b>&lt;NO SUCCESSFUL JOB SINCE&gt;</b> </span></font></p><p><font color="#666666" face="Calibri,sans-serif"><span>The last recorded backup was on: [<b>&lt;DATE OF LAST SUCCESSFUL JOB&gt;</b>] at: [<b>&lt;TIME OF LAST SUCCESSFUL JOB&gt;</b>] </span></font></p><p><b><font color="#ff0033" face="Calibri,sans-serif"><span>It is suggested that you perform a backup as soon as possible so as to not lose any data.</span></font></b><font color="#666666" face="Calibri,sans-serif"><span> </span></font></p><p><font color="#666666" face="Calibri,sans-serif"><span>You can do this by clicking the &quot;Backup Now&quot; button on the CommVault Edge Monitor control in the Taskbar Notification area. </span></font></p></td></tr></table></div>'
set @htmldefaultTemplateForRestore = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><style type="text/css"><!--hr { height: 1px; color: black }body { background-image: url(cid:bgc.png) }.content2 { background-color: WHITE; font-family: Calibri, Tahoma, Arial; width: 800px; padding-right: 50px; border-spacing: 0; padding-left: 50px; padding-bottom: 25px; padding-top: 25px; color: #666666 }.content1 { width: 800px; border-spacing: 0; padding-top: 20px }--></style><div align="center"><table class="content1"><tr><td colspan="2"><img alt="Cloud image" src="cid:AlertCloud_header.PNG" border="0"></td></tr><tr><td width="10%">&#160;&#160;</td><td><p><font color="#666666" face="Calibri,sans-serif"><span>Restore Job &lt;JOB ID&gt; started &lt;SUCCESSFULL MESSAGE&gt; by User [&lt;USER NAME&gt;] on your computer [<b>&lt;CLIENT NAME&gt;</b>] &lt;STATUS MESSAGE&gt; &lt;ERR CODE MESSAGE&gt; </span></font></p><p><b><font color="#666666" face="Calibri,sans-serif"><span>&lt;FAILURE REASON MESSAGE&gt;</span></font></b></p><p><font color="#666666" face="Calibri,sans-serif"><span>The job was started at [&lt;START TIME&gt;] </span></font></p><p><font color="#666666" face="Calibri,sans-serif">&lt;CHECK LOGS MESSAGE&gt; </font></p></td></tr></table></div>'
set @textdefaultTemplateForBackup = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END>MsgNewLine_MsgTab_ Alert: <ALERT NAME> MsgNewLine_MsgTab_ CommCell: <COMMCELL NAME> MsgNewLine_MsgTab_ Your computer: [<CLIENT NAME>] has not been backed up in over: <NO SUCCESSFUL JOB SINCE> MsgNewLine_MsgTab_ The last recorded backup was on: [<DATE OF LAST SUCCESSFUL JOB>] at: [<TIME OF LAST SUCCESSFUL JOB>] MsgNewLine_MsgTab_ It is suggested that you perform a backup as soon as possible so as to not lose any data. MsgNewLine_MsgTab_ You can do this by clicking the "Backup Now" button on the CommVault Edge Monitor control in the Taskbar Notification area. MsgNewLine_MsgTab_ '
set @textdefaultTemplateForRestore = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END>MsgNewLine_MsgTab_ Alert: <ALERT NAME> MsgNewLine_MsgTab_ CommCell: <COMMCELL NAME> MsgNewLine_MsgTab_ Restore Job <JOB ID> started <SUCCESSFULL MESSAGE> by User [<USER NAME>] on your computer [<CLIENT NAME>] <STATUS MESSAGE> <ERR CODE MESSAGE> MsgNewLine_MsgTab_ <FAILURE REASON MESSAGE> MsgNewLine_MsgTab_ The job was started at [<START TIME>] MsgNewLine_MsgTab_ <CHECK LOGS MESSAGE>'
DECLARE @thisCriteria		int
DECLARE @notifType			AS integer	= 1			-- !! WAS !! 'NT_LAPTOP_ALERTNOTIF' + EMAIL (TO FAKE OUT GUI, FOR NOW!)
--
---
----  FOR CURSOR -----
DECLARE @alertType			INTEGER
DECLARE @notificationName	NVARCHAR(128)			-- 'NT_MAX_NOTIFICATION_NAME_SIZE'
DECLARE @description		NVARCHAR(1024)			-- 'NT_MAX_ALERT_DESCRIPTION_SIZE'
DECLARE @msgFmtText			NVARCHAR(max)
DECLARE @msgFmtHtml 		NVARCHAR(max)
DECLARE @earlierName		NVARCHAR(128)
--
--
DECLARE @alertsToAdd table (
		alertType			int Not Null,
notificationName	nvarchar(128),
description			nvarchar(1024),
		msgFmtText			nvarchar(max),
		msgFmtHtml			nvarchar(max),
earlierName			nvarchar(128)
)
----------------------
DECLARE	@thisAlertId		integer
SET @errorCode	= 0
SET @errorString= ''
BEGIN TRY
	BEGIN TRAN
		-- CLEANUP FOR TESTING PURPOSES ONLY!
	--UPDATE NTNotificationRule SET status=2, revision = 0 where status = @status			-- Logically Delete old Alerts
	INSERT @alertsToAdd VALUES(
3,
			'No backup for last 4 days',
			'Alert for no successful backup in the last 4 days',
			@textdefaultTemplateForBackup,
			@htmldefaultTemplateForBackup,
			'No backup for last 3 days'
			)
	INSERT @alertsToAdd VALUES(
4,					-- 'NT_ALERTTYPE_DATA_RECOV'
			'Restore Job failed',
			'Alert when Recovery Job fails',
			@textdefaultTemplateForRestore,
			@htmldefaultTemplateForRestore,
			'Recovery Job failed alert'
			)
	DECLARE newAlertsCursor CURSOR STATIC FOR
		SELECT  alertType, notificationName, description, msgFmtText, msgFmtHtml,earlierName
		   FROM @alertsToAdd
	OPEN newAlertsCursor
		FETCH NEXT FROM newAlertsCursor INTO @alertType, @notificationName, @description, @msgFmtText, @msgFmtHtml,@earlierName
		WHILE @@FETCH_STATUS = 0
		BEGIN
		-- Check whether this alert is already present. If so, dont insert again.
		if exists(select 1 from NTNotificationRule
			where ( notificationName=@notificationName Or notificationName=@earlierName)
			and revision=1
		)
		begin
			-- If entries are already present, then just update xml entity list since they wont be present at the time of tblscript
			update NTNotificationRule
			set xmlEntityList = @xmlEntities
			where ( notificationName=@notificationName Or notificationName=@earlierName)
			and revision=1
			FETCH NEXT FROM newAlertsCursor INTO @alertType, @notificationName, @description, @msgFmtText, @msgFmtHtml,@earlierName
			continue
		end
		INSERT NTNotificationRule (	categoryId,				alertTypeId,
									notificationName,		revision,
									lastModified,			description,
									notifType,				notifOwner,
									locale,					status,
									ruleState,				ruleState2,
									lastTimeTriggered,		lastTimeTriggered2,
									lastTimeChecked,		hasAttachments,
									hasAttachments2,		xmlEntityList,
									origCCId,				GUID)
		VALUES (					@categoryId,			@alertType				,
									@notificationName,		1,
									@nowTime,				@description,
									@notifType,				@adminID,
0,					(@status|2048),			-- 0 DefaultLocale US-English
									@ruleState,				@ruleState,
									@emptyDateTime,			@emptyDateTime,
									@emptyDateTime,			0,
									0,						@xmlEntities,
									default,				newid() )
		SET @thisAlertId = @@Identity
		--if @alertType = NT_ALERTTYPE_DATA_PROT
		--begin
		--	set @reportOptions = 3
		--	set @persistTimeSeconds = 3600*24*3 -- 3 Days
		--end
		--else
		--begin
set @reportOptions = 1
			set @persistTimeSeconds = 0
		--end
if @alertType = 3
		begin
			INSERT NTSelCriteria(availCriteriaid, esclationLevel, ruleId, reportingOptions, delayTimeSeconds, persistTimeSeconds)
VALUES(65, 1, @thisAlertId, @reportOptions, 0, @persistTimeSeconds)		-- 'NT_CLIENT_JOB_NOT_RUN
			SET @SelCriteriaId = @@identity
			INSERT NTSelCriteriaParams (selCriteriaid, paramIndex, type, value, unit, occurrences)
				VALUES (@selCriteriaId, 0, 2, 4, 5, 0)
		end
		else
		begin
		INSERT NTSelCriteria(availCriteriaid, esclationLevel, ruleId, reportingOptions, delayTimeSeconds, persistTimeSeconds)
VALUES(3, 1, @thisAlertId, @reportOptions, 0, @persistTimeSeconds )		-- NT_FAILED
		end
	INSERT INTO NTmessages (NTnotificationID, escalationLevel, lastSetMessageTime, firstDetectTime, NTmessageState)
		VALUES (@thisAlertId, 1, null, null, 0)
	INSERT INTO NTmessages (NTnotificationID, escalationLevel, lastSetMessageTime, firstDetectTime, NTmessageState)
		VALUES (@thisAlertId, 2, null, null, 0)
-- ADD DEFAULT (EMAIL) MESSAGE:
									 --
		INSERT NTmessageFormat (NTnotificationID,messageType,escalationLevel,formatString,formattedMessage,
							SubjFieldStart,SubjFieldLen,MsgBodyStart,MsgBodyLen,mfOptions,
							baseDir,userName,password, rssID, messageFormatType, formatStringHtml)
			VALUES		(@thisAlertId, 1, 1, @msgFmtText, N'',
0, 0, 0, 0, 2,
						 '', '', '', '', 1, @msgFmtHtml)
-- ADD DEFAULT USER (SHOULDN'T HAVE TO DO THIS, BUT REQ'D TO SUPPORT CURRENT ALERT GUI)
--		INSERT NTnotificationUsers  (NTnotificationID, userId,    escalationLevel)
--			VALUES (@thisAlertId, @adminID, 1)
		FETCH NEXT FROM newAlertsCursor INTO @alertType, @notificationName, @description, @msgFmtText, @msgFmtHtml,@earlierName
	END
END TRY
 BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
     set @errorCode = ERROR_NUMBER()
     set @errorString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
 END CATCH
 	IF ( CURSOR_STATUS('global', 'newAlertsCursor') >= 0   OR CURSOR_STATUS('local', 'newAlertsCursor') >= 0 )  -- CLOSE CURSOR IF OPEN
		CLOSE newAlertsCursor
	IF ( CURSOR_STATUS('global','newAlertsCursor') = -1     OR CURSOR_STATUS('local','newAlertsCursor') = -1 )
		DEALLOCATE newAlertsCursor
IF @errorCode = 0
	COMMIT TRAN
ELSE
	ROLLBACK TRAN
SELECT @errorCode, @errorString
GO
/*  FOR DEBUGGING:
DECLARE @errCode as int = 0
DECLARE @errString varchar(1024)
exec br_ntPopulateLapTopAlerts @errCode output, @errString output
select @errCode, @errString
select id, notificationName, status, xmlEntityList from ntnotificationRule where (status & 128) <> 0 -- Laptop Alert
SELECT * from NTmessageFormat where NTnotificationId in (select id from ntnotificationRule where (status & 128) <> 0) -- Laptop Alert
*/

IF EXISTS (select * from GxQscripts where name = 'br_ntPopulateLapTopAlerts')
	delete from GxQscripts where name = 'br_ntPopulateLapTopAlerts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_ntPopulateLapTopAlerts')
	delete from GXDBVersions where aliasname = 'br_ntPopulateLapTopAlerts'
GO

insert into GXDBVersions values(2, 'br_ntPopulateLapTopAlerts',  '00000000000000000000', 'br_ntPopulateLapTopAlerts', '00000000000000000000')
GO

