

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/br_ntPopulateDefaultAlerts.sp] ---------- 

-- ALLOW_COMMENTS_BELOW_HERE:
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='br_ntPopulateDefaultAlerts')
BEGIN
	print '>>> Drop Stored Procedure: br_ntPopulateDefaultAlerts <<<'
	drop procedure br_ntPopulateDefaultAlerts
END
IF EXISTS (select * from GxQscripts where name='br_ntPopulateDefaultAlerts')
	delete from GxQscripts where name = 'br_ntPopulateDefaultAlerts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_ntPopulateDefaultAlerts')
	delete from GXDBVersions where aliasname = 'br_ntPopulateDefaultAlerts'
GO
print '... Creating Procedure: br_ntPopulateDefaultAlerts'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure br_ntPopulateDefaultAlerts
--	+-------------------------------+
--	| PARAMETERS   &   OUTPUTS		|
--	+-------------------------------+
  @errorCode integer         OUTPUT,
  @errorString varchar(1024)   OUTPUT
AS
set @errorCode = 0
set @errorString  = ''
Declare @releaseID int
-- Set the current releaseId instead of retrieving it from CS client.
set @releaseID = 16
set @releaseID = @releaseID-1
-- First check the CS release. This SP has to be executed only for freshly installed CS and not for upgraded CS
Declare @CSReleaseStatus table
(
	o_Flag int,
	o_TimeOfUpgrade int,
	o_errorCode int,
	o_infoString nvarchar(max)
)
Insert into @CSReleaseStatus
exec simIsClientFreshlyInstalledOnOrBeforeRelease 2,@releaseID
if (exists(select top 1 o_Flag from  @CSReleaseStatus where o_Flag = 1))
begin
	print 'Its an upgraded setup. Not creating default alerts'
	SELECT @errorCode, @errorString
	return
end
if exists(select 1 from GxGlobalParam
	   where name='PopulateDefaultAlerts')
begin
	print 'Default alerts have already been created. So not creating'
	SELECT @errorCode, @errorString
	return
end
Insert into GxGlobalParam
select 'PopulateDefaultAlerts','1',0,0
-- for VSA OEM, get default alerts from post install script alone.
DECLARE @oem INT = ISNULL((SELECT CAST(value AS INT) FROM gxglobalparam WHERE name = 'MiniBrandId'), 0)
IF @oem = 106
begin
	print 'Not creating default alerts for VSA OEM.'
	SELECT @errorCode, @errorString
	return
end
DECLARE @nowTime			as integer	= dbo.GetUnixTime (GetUTCdate())
DECLARE @xmlEntities		AS nvarchar(MAX)= '<CVGui_CommCellTreeNode xmlns:xsi="http:--www.w3.org/2001/XMLSchema-instance" xsi:noNamespaceSchemaLocation="CVGui_CommCellTreeNodeType.xsd"><trackingSchedules /><trackingJobs /></CVGui_CommCellTreeNode>'
DECLARE @allClientXmlEntities		AS nvarchar(MAX)= '<CVGui_CommCellTreeNode xmlns:xsi="http:--www.w3.org/2001/XMLSchema-instance" xsi:noNamespaceSchemaLocation="CVGui_CommCellTreeNodeType.xsd"><trackingSchedules /><trackingJobs /><associations _type_="2" clientGroupId="0" clientGroupName="" clientId="0" clientName="" applicationId="0" appName="" instanceId="0" instanceName="" backupsetId="0" backupsetName="" subclientId="0" subclientName="" mediaAgentId="0" mediaAgentName="" schedulePolicyId="0" schedulePolicyName="" libraryId="0" libraryName="" storagePolicyId="0" storagePolicyName="" copyId="0" copyName="" trackingPolicyId="0" trackingPolicyName="" workflowId="0" workflowName="" policyId="0" policyName="" criteriaId="0" criteriaName="" /></CVGui_CommCellTreeNode>'
DECLARE @allStoragePolicyXmlEntities AS nvarchar(MAX)= '<CVGui_CommCellTreeNode xmlns:xsi="http:--www.w3.org/2001/XMLSchema-instance" xsi:noNamespaceSchemaLocation="CVGui_CommCellTreeNodeType.xsd"><trackingSchedules /><trackingJobs /><associations _type_="16" clientGroupId="0" clientGroupName="" clientId="0" clientName="" applicationId="0" appName="" instanceId="0" instanceName="" backupsetId="0" backupsetName="" subclientId="0" subclientName="" mediaAgentId="0" mediaAgentName="" schedulePolicyId="0" schedulePolicyName="" libraryId="0" libraryName="" storagePolicyId="0" storagePolicyName="" copyId="0" copyName="" trackingPolicyId="0" trackingPolicyName="" workflowId="0" workflowName="" policyId="0" policyName="" criteriaId="0" criteriaName="" /></CVGui_CommCellTreeNode>'
DECLARE @allMAsXmlEntities AS nvarchar(MAX)= '<CVGui_CommCellTreeNode xmlns:xsi="http:--www.w3.org/2001/XMLSchema-instance" xsi:noNamespaceSchemaLocation="CVGui_CommCellTreeNodeType.xsd"><trackingSchedules /><trackingJobs /><associations _type_="10" clientGroupId="0" clientGroupName="" clientId="0" clientName="" applicationId="0" appName="" instanceId="0" instanceName="" backupsetId="0" backupsetName="" subclientId="0" subclientName="" mediaAgentId="0" mediaAgentName="" schedulePolicyId="0" schedulePolicyName="" libraryId="0" libraryName="" storagePolicyId="0" storagePolicyName="" copyId="0" copyName="" trackingPolicyId="0" trackingPolicyName="" workflowId="0" workflowName="" policyId="0" policyName="" criteriaId="0" criteriaName="" /></CVGui_CommCellTreeNode>'
DECLARE @allLibrariesXmlEntities AS nvarchar(MAX)= '<CVGui_CommCellTreeNode xmlns:xsi="http:--www.w3.org/2001/XMLSchema-instance" xsi:noNamespaceSchemaLocation="CVGui_CommCellTreeNodeType.xsd"><trackingSchedules /><trackingJobs /><associations _type_="8" clientGroupId="0" clientGroupName="" clientId="0" clientName="" applicationId="0" appName="" instanceId="0" instanceName="" backupsetId="0" backupsetName="" subclientId="0" subclientName="" mediaAgentId="0" mediaAgentName="" schedulePolicyId="0" schedulePolicyName="" libraryId="0" libraryName="" storagePolicyId="0" storagePolicyName="" copyId="0" copyName="" trackingPolicyId="0" trackingPolicyName="" workflowId="0" workflowName="" policyId="0" policyName="" criteriaId="0" criteriaName="" /></CVGui_CommCellTreeNode>'
DECLARE @adminID			as integer		= ISNULL((Select top 1 ID from UMUSERS where (flags & 67) = 67 AND Name <> 'ROMS'), 1)
DECLARE @masterGroupId		as integer  = ISNULL((Select top 1 ID from UMGroups where name='master'),1)	--_US_ADMIN_GROUP__
DECLARE	@emptyDateTime		AS datetime	= '1900-01-01 00:00:00.000'
DECLARE @localeId			AS integer		= 1
DECLARE	@ruleState			AS integer		= 0
DECLARE	@reportOptions		AS integer		= 1		-- 'NT_REPORT_IMMEDIATE'
DECLARE @persistTimeSeconds AS integer		= 0
DECLARE @SelCriteriaId		integer
DECLARE @createdAlertsId	INT = 1
DECLARE @thisCriteria		int
DECLARE @notifType			AS integer	= 1			-- !! WAS !! 'NT_LAPTOP_ALERTNOTIF' + EMAIL (TO FAKE OUT GUI, FOR NOW!)
--
---
----  FOR CURSOR -----
DECLARE @alertId			INTEGER
DECLARE @alertType			INTEGER
DECLARE @notificationName	NVARCHAR(128)			-- 'NT_MAX_NOTIFICATION_NAME_SIZE'
DECLARE @description		NVARCHAR(1024)			-- 'NT_MAX_ALERT_DESCRIPTION_SIZE'
DECLARE @msgFmtText			NVARCHAR(max)
DECLARE @msgFmtHtml 		NVARCHAR(max)
DECLARE @isAlertEnabled		bit
DECLARE @cursorXmlEntities  nvarchar(MAX)
--
--
DECLARE @alertsToAdd table (
		alertId				int primary key,
		alertType			int Not Null,
notificationName	nvarchar(128),
description			nvarchar(1024),
		msgFmtText			nvarchar(max),
		msgFmtHtml			nvarchar(max),
		isAlertEnabled		bit,
		xmlEntities			nvarchar(MAX)
)
DECLARE @criteriasToAdd table (
		alertId				int ,
		criteriaId			int ,
		criteriaParamType	int,
		criteriaParamValue	int,
		criteriaParamUnit	int
		primary key(alertId,criteriaId)
)
DECLARE @reportingOption table(
		alertId				int,
		reportingOptions    int
		)
----------------------
DECLARE	@thisAlertId		integer
SET @errorCode	= 0
SET @errorString= ''
DECLARE @newTemplate INT = (SELECT ISNULL(value,0) FROM GXGlobalParam WHERE name='UseNewAlertTemplate')
BEGIN TRY
	BEGIN TRAN
		-- CLEANUP FOR TESTING PURPOSES ONLY!
	--UPDATE NTNotificationRule SET status=2, revision = 0 where status = @status			-- Logically Delete old Alerts
	DECLARE @htmldefaultTemplateForAuxCopyFallenBehindAlert nvarchar(max)
	DECLARE @textdefaultTemplateForAuxCopyFallenBehindAlert nvarchar(max)
	IF @newTemplate=1
		set @htmldefaultTemplateForAuxCopyFallenBehindAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><div id="contentTbl-table-scroll"> <table cellspacing="0" cellpadding="0"  width="100%" style="border: 1px solid #2f4e66;"> <tr> <td> <center> <table id="contentTbl" cellspacing="0" cellpadding="0" width="100%" border="0"> <tr style="background-color: #2f4e66"> <td valign="middle" align="left" colspan="3"> <div style="margin-left: 20px; margin-bottom: 25px; margin-top: 25px"> <font color="#FFFFFF" size="5" face="sans-serif"><b>&lt;ALERT NAME&gt; </b></font> </div> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Type </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;ALERT CATEGORY - ALERT TYPE&gt;</font> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>CommCell </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;COMMCELL NAME&gt;</font> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Detected Criteria </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;DETECTED CRITERIA&gt;</font> </td> </tr> <tr> <td colspan="3" style="padding-top: 5px; padding-bottom: 5px; padding-right: 0; padding-left: 0"> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>User </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;USER NAME&gt;</font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Job ID</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;JOB ID&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Status</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;STATUS&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Storage Policy Name</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;SP NAME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Copy Name</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;COPY NAME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Start Time</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;START TIME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Scheduled Time</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;SCHEDULE TIME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>End Time</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;END TIME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Error Code</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;ERR CODE&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Failure Reason</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;FAILURE REASON&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Size of Data to be Copied</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;SIZE OF DATA TOBE COPIED&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Number of Jobs to be Copied</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;JOBS TOBE COPIED&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Oldest Job End Date</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;OLDEST JOB ENDDATE&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Estimated Time Needed For Copying</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;COPY HOURS&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Alert Reason</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;ALERT REASON&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Warning</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;WARNING&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Condition Cleared</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;CONDITION CLEARED Y/N&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Comments</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;COMMENT&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Media that got copied</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;COPIED MEDIA LIST&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Copied data size</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;COPIED DATA SIZE&gt;</font> </td> </tr> <tr style="background-color: #2f4e66"> <td colspan="3" align="right" style="padding-top: 7px; padding-right: 20px; padding-bottom: 7px; padding-left: 0px"> <font size="3" face="sans-serif" color="#ffffff">Generated At &lt;TIME&gt; </font> </td> </tr> </table> </center> </td> </tr> </table> </div>'
	ELSE
		set @htmldefaultTemplateForAuxCopyFallenBehindAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><table width="600" border="1" style="border-left-style: solid; border-right-color: #dedede; border-bottom-color: #dedede; border-left-width: 0px; border-right-width: 0px; border-bottom-style: solid; border-top-width: 0px; border-bottom-width: 0px; border-left-color: #dedede; border-top-style: solid; border-top-color: #dedede; border-right-style: solid" cellpadding="0" align="center" cellspacing="0"> <tr> <td> <center> <table width="600" id="contentTbl" border="0" cellpadding="0" align="center" cellspacing="0"> <tr style="background-color: #666666"> <td align="left" valign="middle"> <div style="margin-bottom: 4px; margin-left: 10px; margin-top: 4px"> <font color="#EEEEEE" face="Helvetica,sans-serif" size="6">&lt;ALERT NAME&gt; </font> </div> </td> </tr> <tr> <td bgcolor="#DCDEDE" colspan="1" align="left" valign="middle"> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>CommCell: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;COMMCELL NAME&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Type: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;ALERT CATEGORY - ALERT TYPE&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Detected Criteria: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;DETECTED CRITERIA&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Detected Time: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;TIME&gt;</font></strong> </ul> </td> </tr> <tr> <td width="100%" colspan="1" align="left"> <ul> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">User: &lt;USER NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Job ID: &lt;JOB ID&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Status: &lt;STATUS&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Storage Policy Name: &lt;SP NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Copy Name: &lt;COPY NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Start Time: &lt;START TIME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Scheduled Time: &lt;SCHEDULE TIME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">End Time: &lt;END TIME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Error Code: &lt;ERR CODE&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Failure Reason: &lt;FAILURE REASON&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Size of Data to be Copied: &lt;SIZE OF DATA TOBE COPIED&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Number of Media to be Copied: &lt;MEDIA TOBE COPIED COUNT&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Number of Jobs to be Copied: &lt;JOBS TOBE COPIED&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Oldest Job End Date: &lt;OLDEST JOB ENDDATE&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Media that got copied: &lt;COPIED MEDIA LIST&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Copied data size: &lt;COPIED DATA SIZE&gt; </font> </li> </ul> </td> </tr> <tr style="background-color: #666666"> <td colspan="1" align="left">  </td> </tr> </table> </center> </td> </tr> </table>'
	set @textdefaultTemplateForAuxCopyFallenBehindAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END> MsgNewLine_ Alert: <ALERT NAME> MsgNewLine_ Type: <ALERT CATEGORY - ALERT TYPE> MsgNewLine_MsgTab_ Detected Criteria: <DETECTED CRITERIA> MsgNewLine_MsgTab_ Detected Time: <TIME> MsgNewLine_MsgTab_ CommCell: <COMMCELL NAME> MsgNewLine_MsgTab_ User: <USER NAME> MsgNewLine_ MsgNewLine_ MsgTab_ Job ID: <JOB ID> MsgNewLine_MsgTab_ Status: <STATUS> MsgNewLine_MsgTab_ Storage Policy Name: <SP NAME> MsgNewLine_MsgTab_ Copy Name: <COPY NAME> MsgNewLine_MsgTab_ Start Time: <START TIME> MsgNewLine_MsgTab_ Scheduled Time: <SCHEDULE TIME> MsgNewLine_MsgTab_ End Time: <END TIME> MsgNewLine_MsgTab_ Error Code: <ERR CODE> MsgNewLine_MsgTab_ Failure Reason: <FAILURE REASON> MsgNewLine_MsgTab_  Size of Data to be Copied: <SIZE OF DATA TOBE COPIED> MsgNewLine_MsgTab_ Number of Media to be Copied: <MEDIA TOBE COPIED COUNT> MsgNewLine_MsgTab_ Number of Jobs to be Copied: <JOBS TOBE COPIED> MsgNewLine_MsgTab_ Oldest Job End Date: <OLDEST JOB ENDDATE> MsgNewLine_MsgTab_  Media that got copied: <COPIED MEDIA LIST> MsgNewLine_MsgTab_ Copied data size: <COPIED DATA SIZE> MsgNewLine_MsgTab_'
	Insert @alertsToAdd values(
			@createdAlertsId,
2,
			'Aux copy fallen behind',
			'Default alert for aux Copy fallen behind ',
			@textdefaultTemplateForAuxCopyFallenBehindAlert,
			@htmldefaultTemplateForAuxCopyFallenBehindAlert,
			0,
			@allStoragePolicyXmlEntities
	)
	Insert into @criteriasToAdd
select @createdAlertsId,56,NULL,NULL,NULL
	set @createdAlertsId = @createdAlertsId + 1
	DECLARE @htmldefaultTemplateForAuxCopyAlert nvarchar(max)
	DECLARE @textdefaultTemplateForAuxCopyAlert nvarchar(max)
	IF @newTemplate=1
		set @htmldefaultTemplateForAuxCopyAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><div id="contentTbl-table-scroll"> <table cellspacing="0" cellpadding="0" width="100%" style="border: 1px solid #2f4e66;"> <tr> <td> <center> <table id="contentTbl" cellspacing="0" cellpadding="0" width="100%" border="0"> <tr style="background-color: #2f4e66"> <td valign="middle" align="left" colspan="3"> <div style="margin-left: 20px; margin-bottom: 25px; margin-top: 25px"> <font color="#FFFFFF" size="5" face="sans-serif"><b>&lt;ALERT NAME&gt; </b></font> </div> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Type </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;ALERT CATEGORY - ALERT TYPE&gt;</font> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>CommCell </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;COMMCELL NAME&gt;</font> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Detected Criteria </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;DETECTED CRITERIA&gt;</font> </td> </tr> <tr> <td colspan="3" style="padding-top: 5px; padding-bottom: 5px; padding-right: 0; padding-left: 0"> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>User </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;USER NAME&gt;</font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Job ID</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;JOB ID&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Status</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;STATUS&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Storage Policy Name</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;SP NAME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Copy Name</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;COPY NAME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Start Time</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;START TIME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Scheduled Time</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;SCHEDULE TIME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>End Time</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;END TIME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Error Code</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;ERR CODE&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Failure Reason</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;FAILURE REASON&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Media that got copied</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;COPIED MEDIA LIST&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Copied data size</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;COPIED DATA SIZE&gt;</font> </td> </tr> <tr style="background-color: #2f4e66"> <td colspan="3" align="right" style="padding-top: 7px; padding-right: 20px; padding-bottom: 7px; padding-left: 0px"> <font size="3" face="sans-serif" color="#ffffff">Generated At &lt;TIME&gt; </font> </td> </tr> </table> </center> </td> </tr> </table> </div>'
	ELSE
		set @htmldefaultTemplateForAuxCopyAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><table width="600" border="1" style="border-left-style: solid; border-right-color: #dedede; border-bottom-color: #dedede; border-left-width: 0px; border-right-width: 0px; border-bottom-style: solid; border-top-width: 0px; border-bottom-width: 0px; border-left-color: #dedede; border-top-style: solid; border-top-color: #dedede; border-right-style: solid" cellpadding="0" align="center" cellspacing="0"> <tr> <td> <center> <table width="600" id="contentTbl" border="0" cellpadding="0" align="center" cellspacing="0"> <tr style="background-color: #666666"> <td align="left" valign="middle"> <div style="margin-bottom: 4px; margin-left: 10px; margin-top: 4px"> <font color="#EEEEEE" face="Helvetica,sans-serif" size="6">&lt;ALERT NAME&gt; </font> </div> </td> </tr> <tr> <td bgcolor="#DCDEDE" colspan="1" align="left" valign="middle"> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>CommCell: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;COMMCELL NAME&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Type: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;ALERT CATEGORY - ALERT TYPE&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Detected Criteria: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;DETECTED CRITERIA&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Detected Time: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;TIME&gt;</font></strong> </ul> </td> </tr> <tr> <td width="100%" colspan="1" align="left"> <ul> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">User: &lt;USER NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Job ID: &lt;JOB ID&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Status: &lt;STATUS&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Storage Policy Name: &lt;SP NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Copy Name: &lt;COPY NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Start Time: &lt;START TIME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Scheduled Time: &lt;SCHEDULE TIME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">End Time: &lt;END TIME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Error Code: &lt;ERR CODE&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Failure Reason: &lt;FAILURE REASON&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Media that got copied: &lt;COPIED MEDIA LIST&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Copied data size: &lt;COPIED DATA SIZE&gt; </font> </li> </ul> </td> </tr> <tr style="background-color: #666666"> <td colspan="1" align="left">  </td> </tr> </table> </center> </td> </tr> </table>'
	set @textdefaultTemplateForAuxCopyAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END> MsgNewLine_ Alert: <ALERT NAME> MsgNewLine_ Type: <ALERT CATEGORY - ALERT TYPE> MsgNewLine_MsgTab_ Detected Criteria: <DETECTED CRITERIA> MsgNewLine_MsgTab_ Detected Time: <TIME> MsgNewLine_MsgTab_ CommCell: <COMMCELL NAME> MsgNewLine_MsgTab_ User: <USER NAME> MsgNewLine_ MsgNewLine_ MsgTab_ Job ID: <JOB ID> MsgNewLine_MsgTab_ Status: <STATUS> MsgNewLine_MsgTab_ Storage Policy Name: <SP NAME> MsgNewLine_MsgTab_ Copy Name: <COPY NAME> MsgNewLine_MsgTab_ Start Time: <START TIME> MsgNewLine_MsgTab_ Scheduled Time: <SCHEDULE TIME> MsgNewLine_MsgTab_ End Time: <END TIME> MsgNewLine_MsgTab_ Error Code: <ERR CODE> MsgNewLine_MsgTab_ Failure Reason: <FAILURE REASON> MsgNewLine_MsgTab_ Media that got copied: <COPIED MEDIA LIST> MsgNewLine_MsgTab_ Copied data size: <COPIED DATA SIZE> MsgNewLine_MsgTab_'
	Insert @alertsToAdd values(
			@createdAlertsId,
2,
			'Aux copy job delayed',
			'Default alert for aux Copy job delayed',
			@textdefaultTemplateForAuxCopyAlert,
			@htmldefaultTemplateForAuxCopyAlert	,
			0,
			@allStoragePolicyXmlEntities
	)
	Insert into @criteriasToAdd
select @createdAlertsId,5,2,4,5
	set @createdAlertsId = @createdAlertsId + 1
	Insert @alertsToAdd values(
			@createdAlertsId,
2,
			'Aux copy job Failed',
			'Default alert for aux Copy job failed',
			@textdefaultTemplateForAuxCopyAlert,
			@htmldefaultTemplateForAuxCopyAlert	,
			0,
			@allStoragePolicyXmlEntities
	)
	Insert into @criteriasToAdd
select @createdAlertsId,3,NULL,NULL,NULL
	union
select @createdAlertsId,4,NULL,NULL,NULL
	set @createdAlertsId = @createdAlertsId + 1
	DECLARE @htmldefaultTemplateForClientAlert nvarchar(max)
	DECLARE @textdefaultTemplateForClientAlert nvarchar(max)
	IF @newTemplate=1
		set @htmldefaultTemplateForClientAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><div id="contentTbl-table-scroll"> <table cellspacing="0" cellpadding="0" width="100%" style="border: 1px solid #2f4e66;"> <tr> <td> <center> <table id="contentTbl" cellspacing="0" cellpadding="0" width="100%" border="0"> <tr style="background-color: #2f4e66"> <td valign="middle" align="left" colspan="3"> <div style="margin-left: 20px; margin-bottom: 25px; margin-top: 25px"> <font color="#FFFFFF" size="5" face="sans-serif"><b>&lt;ALERT NAME&gt; </b></font> </div> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Type </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;ALERT CATEGORY - ALERT TYPE&gt;</font> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>CommCell </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;COMMCELL NAME&gt;</font> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Detected Criteria </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;DETECTED CRITERIA&gt;</font> </td> </tr> <tr> <td colspan="3" style="padding-top: 5px; padding-bottom: 5px; padding-right: 0; padding-left: 0"> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>User </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;USER NAME&gt;</font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Property Modifications </b></font> </td> <td colspan="2"> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Status</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;STATUS&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Client</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;CLIENT NAME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Agent Type</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;AGENT TYPE NAME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Instance</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;INSTANCE NAME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Backup Set</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;BACKUPSET NAME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Subclient</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;SUBCLIENT NAME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Comments</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;COMMENT&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Disk Space Low</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;DISK SPACE LOW Y/N&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Condition Cleared</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;CONDITION CLEARED Y/N&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Media/Space left</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;DISK SPACE INFO&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Disk Space Available</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;FREE SPACE&gt;</font> </td> </tr> <tr style="background-color: #2f4e66"> <td colspan="3" align="right" style="padding-top: 7px; padding-right: 20px; padding-bottom: 7px; padding-left: 0px"> <font size="3" face="sans-serif" color="#ffffff">Generated At &lt;TIME&gt; </font> </td> </tr> </table> </center> </td> </tr> </table> </div>'
	ELSE
		set @htmldefaultTemplateForClientAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><table width="600" border="1" style="border-left-style: solid; border-right-color: #dedede; border-bottom-color: #dedede; border-left-width: 0px; border-right-width: 0px; border-bottom-style: solid; border-top-width: 0px; border-bottom-width: 0px; border-left-color: #dedede; border-top-style: solid; border-top-color: #dedede; border-right-style: solid" cellpadding="0" align="center" cellspacing="0"> <tr> <td> <center> <table width="600" id="contentTbl" border="0" cellpadding="0" align="center" cellspacing="0"> <tr style="background-color: #666666"> <td align="left" valign="middle"> <div style="margin-bottom: 4px; margin-left: 10px; margin-top: 4px"> <font color="#EEEEEE" face="Helvetica,sans-serif" size="6">&lt;ALERT NAME&gt; </font> </div> </td> </tr> <tr> <td bgcolor="#DCDEDE" colspan="1" align="left" valign="middle"> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>CommCell: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;COMMCELL NAME&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Type: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;ALERT CATEGORY - ALERT TYPE&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Detected Criteria: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;DETECTED CRITERIA&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Detected Time: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;TIME&gt;</font></strong> </ul> </td> </tr> <tr> <td width="100%" colspan="1" align="left"> <ul> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">User: &lt;USER NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Property Modifications: </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Status: &lt;STATUS&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Client: &lt;CLIENT NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Agent Type: &lt;AGENT TYPE NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Instance: &lt;INSTANCE NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Backup Set: &lt;BACKUPSET NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Subclient: &lt;SUBCLIENT NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Comments: &lt;COMMENT&gt; </font> </li> <font color="#000000" face="Helvetica,sans-serif" size="3">MsgHrzSep </font> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Disk Space Low: &lt;DISK SPACE LOW Y/N&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Media/Space left: &lt;DISK SPACE INFO&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Disk Space Available: &lt;FREE SPACE&gt; </font> </li> <font color="#000000" face="Helvetica,sans-serif" size="3">MsgHrzSep </font> </ul> </td> </tr> <tr style="background-color: #666666"> <td colspan="1" align="left">  </td> </tr> </table> </center> </td> </tr> </table>'
	set @textdefaultTemplateForClientAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END> MsgNewLine_ Alert: <ALERT NAME> MsgNewLine_ Type: <ALERT CATEGORY - ALERT TYPE> MsgNewLine_MsgTab_ Detected Criteria: <DETECTED CRITERIA> MsgNewLine_MsgTab_ Detected Time: <TIME> MsgNewLine_MsgTab_ CommCell: <COMMCELL NAME> MsgNewLine_MsgTab_ User: <USER NAME> MsgNewLine_ MsgNewLine_ MsgTab_ Property Modifications: MsgNewLine_MsgTab_ Status: <STATUS> MsgNewLine_MsgTab_ Client: <CLIENT NAME> MsgNewLine_MsgTab_ Agent Type: <AGENT TYPE NAME> MsgNewLine_MsgTab_ Instance: <INSTANCE NAME> MsgNewLine_MsgTab_ Backup Set: <BACKUPSET NAME> MsgNewLine_MsgTab_ Subclient: <SUBCLIENT NAME> MsgNewLine_MsgTab_ Comments: <COMMENT> MsgNewLine_MsgTab_ ============================================================================================================== MsgNewLine_MsgTab_ Disk Space Low: <DISK SPACE LOW Y/N> MsgNewLine_MsgTab_ Media/Space left: <DISK SPACE INFO> MsgNewLine_MsgTab_ Disk Space Available: <FREE SPACE> MsgNewLine_MsgTab_ =============================================================================================================='
	Insert @alertsToAdd values(
			@createdAlertsId,
10,
			'Low disk space on client',
			'Default alert for client disk space low',
			@textdefaultTemplateForClientAlert,
			@htmldefaultTemplateForClientAlert	,
			0,
			@allClientXmlEntities
	)
	Insert into @criteriasToAdd
select @createdAlertsId,18,NULL,NULL,NULL
	set @createdAlertsId = @createdAlertsId + 1
	DECLARE @htmldefaultTemplateForDataAgingAlert nvarchar(max)
	DECLARE @textdefaultTemplateForDataAgingAlert nvarchar(max)
	IF @newTemplate=1
		set @htmldefaultTemplateForDataAgingAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><div id="contentTbl-table-scroll"> <table cellspacing="0" cellpadding="0" width="100%" style="border: 1px solid #2f4e66;"> <tr> <td> <center> <table id="contentTbl" cellspacing="0" cellpadding="0" width="100%" border="0"> <tr style="background-color: #2f4e66"> <td valign="middle" align="left" colspan="3"> <div style="margin-left: 20px; margin-bottom: 25px; margin-top: 25px"> <font color="#FFFFFF" size="5" face="sans-serif"><b>&lt;ALERT NAME&gt; </b></font> </div> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Type </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;ALERT CATEGORY - ALERT TYPE&gt;</font> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>CommCell </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;COMMCELL NAME&gt;</font> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Detected Criteria </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;DETECTED CRITERIA&gt;</font> </td> </tr> <tr> <td colspan="3" style="padding-top: 5px; padding-bottom: 5px; padding-right: 0; padding-left: 0"> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>User </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;USER NAME&gt;</font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Job ID</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;JOB ID&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Status</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;STATUS&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Start Time</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;START TIME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Scheduled Time</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;SCHEDULE TIME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>End Time</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;END TIME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Error Code</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;ERR CODE&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Failure Reason</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;FAILURE REASON&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Pruned Media Barcode List</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;PRUNED MEDIA BARCODE LIST&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Pruned Jobs Count</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;PRUNED JOBS COUNT&gt;</font> </td> </tr> <tr style="background-color: #2f4e66"> <td colspan="3" align="right" style="padding-top: 7px; padding-right: 20px; padding-bottom: 7px; padding-left: 0px"> <font size="3" face="sans-serif" color="#ffffff">Generated At &lt;TIME&gt; </font> </td> </tr> </table> </center> </td> </tr> </table> </div>'
	ELSE
		set @htmldefaultTemplateForDataAgingAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><table width="600" border="1" style="border-left-style: solid; border-right-color: #dedede; border-bottom-color: #dedede; border-left-width: 0px; border-right-width: 0px; border-bottom-style: solid; border-top-width: 0px; border-bottom-width: 0px; border-left-color: #dedede; border-top-style: solid; border-top-color: #dedede; border-right-style: solid" cellpadding="0" align="center" cellspacing="0"> <tr> <td> <center> <table width="600" id="contentTbl" border="0" cellpadding="0" align="center" cellspacing="0"> <tr style="background-color: #666666"> <td align="left" valign="middle"> <div style="margin-bottom: 4px; margin-left: 10px; margin-top: 4px"> <font color="#EEEEEE" face="Helvetica,sans-serif" size="6">&lt;ALERT NAME&gt; </font> </div> </td> </tr> <tr> <td bgcolor="#DCDEDE" colspan="1" align="left" valign="middle"> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>CommCell: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;COMMCELL NAME&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Type: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;ALERT CATEGORY - ALERT TYPE&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Detected Criteria: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;DETECTED CRITERIA&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Detected Time: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;TIME&gt;</font></strong> </ul> </td> </tr> <tr> <td width="100%" colspan="1" align="left"> <ul> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">User: &lt;USER NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Job ID: &lt;JOB ID&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Status: &lt;STATUS&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Start Time: &lt;START TIME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Scheduled Time: &lt;SCHEDULE TIME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">End Time: &lt;END TIME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Error Code: &lt;ERR CODE&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Failure Reason: &lt;FAILURE REASON&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Pruned Media Barcode List: &lt;PRUNED MEDIA BARCODE LIST&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Pruned Jobs Count: &lt;PRUNED JOBS COUNT&gt; </font> </li> </ul> </td> </tr> <tr style="background-color: #666666"> <td colspan="1" align="left">  </td> </tr> </table> </center> </td> </tr> </table>'
	set @textdefaultTemplateForDataAgingAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END> MsgNewLine_ Alert: <ALERT NAME> MsgNewLine_ Type: <ALERT CATEGORY - ALERT TYPE> MsgNewLine_MsgTab_ Detected Criteria: <DETECTED CRITERIA> MsgNewLine_MsgTab_ Detected Time: <TIME> MsgNewLine_MsgTab_ CommCell: <COMMCELL NAME> MsgNewLine_MsgTab_ User: <USER NAME> MsgNewLine_ MsgNewLine_ MsgTab_ Job ID: <JOB ID> MsgNewLine_MsgTab_ Status: <STATUS> MsgNewLine_MsgTab_ Start Time: <START TIME> MsgNewLine_MsgTab_ Scheduled Time: <SCHEDULE TIME> MsgNewLine_MsgTab_ End Time: <END TIME> MsgNewLine_MsgTab_ Error Code: <ERR CODE> MsgNewLine_MsgTab_ Failure Reason: <FAILURE REASON> MsgNewLine_MsgTab_ Pruned Media Barcode List: <PRUNED MEDIA BARCODE LIST> MsgNewLine_MsgTab_ Pruned Jobs Count: <PRUNED JOBS COUNT> MsgNewLine_MsgTab_'
	Insert @alertsToAdd values(
			@createdAlertsId,
1,
			'Data aging job failed',
			'Default alert for data aging job failure',
			@textdefaultTemplateForDataAgingAlert,
			@htmldefaultTemplateForDataAgingAlert	,
			0,
			@XmlEntities
		)
	Insert into @criteriasToAdd
select @createdAlertsId,3,NULL,NULL,NULL
	union
select @createdAlertsId,57,NULL,NULL,NULL
	set @createdAlertsId = @createdAlertsId + 1
	DECLARE @htmldefaultTemplateForDataProtAlert nvarchar(max)
	DECLARE @textdefaultTemplateForDataProtAlert nvarchar(max)
	IF @newTemplate=1
		set @htmldefaultTemplateForDataProtAlert ='<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><div id="contentTbl-table-scroll"> <table cellspacing="0" cellpadding="0" width="100%" style="border: 1px solid #2f4e66;"> <tr> <td> <center> <table id="contentTbl" cellspacing="0" cellpadding="0" width="100%" border="0"> <tr style="background-color: #2f4e66"> <td valign="middle" align="left" colspan="3"> <div style="margin-left: 20px; margin-bottom: 25px; margin-top: 25px"> <font color="#FFFFFF" size="5" face="sans-serif"><b>&lt;ALERT NAME&gt; </b></font> </div> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Type </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;ALERT CATEGORY - ALERT TYPE&gt;</font> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>CommCell </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;COMMCELL NAME&gt;</font> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Detected Criteria </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;DETECTED CRITERIA&gt;</font> </td> </tr> <tr> <td colspan="3" style="padding-top: 5px; padding-bottom: 5px; padding-right: 0; padding-left: 0"> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>User </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;USER NAME&gt;</font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Job ID</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;JOB ID&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Status</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;STATUS&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Client</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;CLIENT NAME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Agent Type</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;AGENT TYPE NAME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Instance</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;INSTANCE NAME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Backup Set</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;BACKUPSET NAME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Subclient</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;SUBCLIENT NAME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Backup Level</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;LEVEL&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Storage Policies Used</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;STORAGE POLICIES USED&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Virtual Machine Name</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;VIRTUAL MACHINE NAME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Virtual Machine Host Name</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;VIRTUAL MACHINE HOST NAME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Virtual Machine Backup Status</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;VM STATUS&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Failure reason for Virtual Machine Backup</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;VM FAILURE REASON&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Start Time</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;START TIME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Scheduled Time</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;SCHEDULE TIME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>End Time</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;END TIME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Error Code</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;ERR CODE&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Failure Reason</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;FAILURE REASON&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Protected Counts</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;PROTECTED COUNT&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Failed Counts</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;FAILED COUNT&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Previous Job ID</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;PREVIOUS JOBID&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Current Backup Size</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;CURRENT BACKUP SIZE&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Previous Backup Size</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;PREVIOUS BACKUP SIZE&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Percentage Change</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;PERCENTAGE CHANGE&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>&lt;ADDITIONAL VM INFO&gt; </b></font> </td> </tr> <tr style="background-color: #2f4e66"> <td colspan="3" align="right" style="padding-top: 7px; padding-right: 20px; padding-bottom: 7px; padding-left: 0px"> <font size="3" face="sans-serif" color="#ffffff">Generated At &lt;TIME&gt; </font> </td> </tr> </table> </center> </td> </tr> </table> </div>'
	ELSE
		set @htmldefaultTemplateForDataProtAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><table width="600" border="1" style="border-left-style: solid; border-right-color: #dedede; border-bottom-color: #dedede; border-left-width: 0px; border-right-width: 0px; border-bottom-style: solid; border-top-width: 0px; border-bottom-width: 0px; border-left-color: #dedede; border-top-style: solid; border-top-color: #dedede; border-right-style: solid" cellpadding="0" align="center" cellspacing="0"> <tr> <td> <center> <table width="600" id="contentTbl" border="0" cellpadding="0" align="center" cellspacing="0"> <tr style="background-color: #666666"> <td align="left" valign="middle"> <div style="margin-bottom: 4px; margin-left: 10px; margin-top: 4px"> <font color="#EEEEEE" face="Helvetica,sans-serif" size="6">&lt;ALERT NAME&gt; </font> </div> </td> </tr> <tr> <td bgcolor="#DCDEDE" colspan="1" align="left" valign="middle"> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>CommCell: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;COMMCELL NAME&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Type: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;ALERT CATEGORY - ALERT TYPE&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Detected Criteria: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;DETECTED CRITERIA&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Detected Time: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;TIME&gt;</font></strong> </ul> </td> </tr> <tr> <td width="100%" colspan="1" align="left"> <ul> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">User: &lt;USER NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Job ID: &lt;JOB ID&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Status: &lt;STATUS&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Client: &lt;CLIENT NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Agent Type: &lt;AGENT TYPE NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Instance: &lt;INSTANCE NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Backup Set: &lt;BACKUPSET NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Subclient: &lt;SUBCLIENT NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Backup Level: &lt;LEVEL&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Storage Policies Used: &lt;STORAGE POLICIES USED&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Start Time: &lt;START TIME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Scheduled Time: &lt;SCHEDULE TIME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">End Time: &lt;END TIME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Error Code: &lt;ERR CODE&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Failure Reason: &lt;FAILURE REASON&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Protected Counts: &lt;PROTECTED COUNT&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Failed Counts: &lt;FAILED COUNT&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Current Backup Size: &lt;CURRENT BACKUP SIZE&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Previous Job ID: &lt;PREVIOUS JOBID&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Previous Backup Size: &lt;PREVIOUS BACKUP SIZE&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Percentage Change: &lt;PERCENTAGE CHANGE&gt; </font> </li> </ul> </td> </tr> <tr style="background-color: #666666"> <td colspan="1" align="left">  </td> </tr> </table> </center> </td> </tr> </table>'
	set @textdefaultTemplateForDataProtAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END> MsgNewLine_ Alert: <ALERT NAME> MsgNewLine_ Type: <ALERT CATEGORY - ALERT TYPE> MsgNewLine_MsgTab_ Detected Criteria: <DETECTED CRITERIA> MsgNewLine_MsgTab_ Detected Time: <TIME> MsgNewLine_MsgTab_ CommCell: <COMMCELL NAME> MsgNewLine_MsgTab_ User: <USER NAME> MsgNewLine_ MsgNewLine_ MsgTab_ Job ID: <JOB ID> MsgNewLine_MsgTab_ Status: <STATUS> MsgNewLine_MsgTab_ Client: <CLIENT NAME> MsgNewLine_MsgTab_ Agent Type: <AGENT TYPE NAME> MsgNewLine_MsgTab_ Instance: <INSTANCE NAME> MsgNewLine_MsgTab_ Backup Set: <BACKUPSET NAME> MsgNewLine_MsgTab_ Subclient: <SUBCLIENT NAME> MsgNewLine_MsgTab_ Backup Level: <LEVEL> MsgNewLine_MsgTab_ Storage Policies Used: <STORAGE POLICIES USED> MsgNewLine_MsgTab_ Start Time: <START TIME> MsgNewLine_MsgTab_ Scheduled Time: <SCHEDULE TIME> MsgNewLine_MsgTab_ End Time: <END TIME> MsgNewLine_MsgTab_ Error Code: <ERR CODE> MsgNewLine_MsgTab_ Failure Reason: <FAILURE REASON> MsgNewLine_MsgTab_ Protected Counts: <PROTECTED COUNT> MsgNewLine_MsgTab_ Failed Counts: <FAILED COUNT> MsgNewLine_MsgTab_  Current Backup Size: <CURRENT BACKUP SIZE> MsgNewLine_MsgTab_ Previous Job ID: <PREVIOUS JOBID> MsgNewLine_MsgTab_ Previous Backup Size: <PREVIOUS BACKUP SIZE> MsgNewLine_MsgTab_ Percentage Change: <PERCENTAGE CHANGE> MsgNewLine_MsgTab_'
	Insert @alertsToAdd values(
			@createdAlertsId,
3,
			'Decrease in data size',
			'Default Decrease in data size alert',
			@textdefaultTemplateForDataProtAlert,
			@htmldefaultTemplateForDataProtAlert,
			0,
			@allClientXmlEntities
	)
	Insert into @criteriasToAdd
select @createdAlertsId,53,1,10,2
	set @createdAlertsId = @createdAlertsId + 1
	Insert @alertsToAdd values(
			@createdAlertsId,
3,
			'Increase in data size',
			'Default Increase in data size Alert',
			@textdefaultTemplateForDataProtAlert,
			@htmldefaultTemplateForDataProtAlert,
			0,
			@allClientXmlEntities
	)
	Insert into @criteriasToAdd
select @createdAlertsId,52,1,10,2
	set @createdAlertsId = @createdAlertsId + 1
	Insert @alertsToAdd values(
			@createdAlertsId,
3,
			'Backup job failed',
			'Default backup job failed Alert',
			@textdefaultTemplateForDataProtAlert,
			@htmldefaultTemplateForDataProtAlert,
			0,
			@allClientXmlEntities
	)
	Insert into @criteriasToAdd
select @createdAlertsId,3,1,10,2
	set @createdAlertsId = @createdAlertsId + 1
	--Dedup job failed alert begin
    Insert @alertsToAdd values(
			@createdAlertsId,
3,
			'DDB Backup failed',
			'Default DDB backup job failed Alert',
			@textdefaultTemplateForDataProtAlert,
			@htmldefaultTemplateForDataProtAlert,
			1,
			@allClientXmlEntities
	)
	INSERT INTO @criteriasToAdd
SELECT @createdAlertsId,3,NULL,NULL,NULL
	UNION
SELECT @createdAlertsId,4,NULL,NULL,NULL
	UNION
SELECT @createdAlertsId,57,NULL,NULL,NULL
	INSERT INTO @reportingOption
SELECT @createdAlertsId,1+128
	set @createdAlertsId = @createdAlertsId + 1
	--Dedup job failed alert end
	DECLARE @htmldefaultTemplateForDDBReconAlert nvarchar(max)
	DECLARE @textdefaultTemplateForDDBReconAlert nvarchar(max)
	IF @newTemplate=1
		set @htmldefaultTemplateForDDBReconAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><div id="contentTbl-table-scroll"> <table cellspacing="0" cellpadding="0" width="100%" style="border: 1px solid #2f4e66;"> <tr> <td> <center> <table id="contentTbl" cellspacing="0" cellpadding="0" width="100%" border="0"> <tr style="background-color: #2f4e66"> <td valign="middle" align="left" colspan="3"> <div style="margin-left: 20px; margin-bottom: 25px; margin-top: 25px"> <font color="#FFFFFF" size="5" face="sans-serif"><b>&lt;ALERT NAME&gt; </b></font> </div> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Type </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;ALERT CATEGORY - ALERT TYPE&gt;</font> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>CommCell </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;COMMCELL NAME&gt;</font> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Detected Criteria </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;DETECTED CRITERIA&gt;</font> </td> </tr> <tr> <td colspan="3" style="padding-top: 5px; padding-bottom: 5px; padding-right: 0; padding-left: 0"> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>User </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;USER NAME&gt;</font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Job ID</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;JOB ID&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Status</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;STATUS&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Storage Policy Name</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;SP NAME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Copy Name</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;COPY NAME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Start Time</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;START TIME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Scheduled Time</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;SCHEDULE TIME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>End Time</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;END TIME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Error Code</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;ERR CODE&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Failure Reason</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;FAILURE REASON&gt;</font> </td> </tr> <tr style="background-color: #2f4e66"> <td colspan="3" align="right" style="padding-top: 7px; padding-right: 20px; padding-bottom: 7px; padding-left: 0px"> <font size="3" face="sans-serif" color="#ffffff">Generated At &lt;TIME&gt; </font> </td> </tr> </table> </center> </td> </tr> </table> </div>'
	ELSE
		set @htmldefaultTemplateForDDBReconAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><table width="600" border="1" style="border-left-style: solid; border-right-color: #dedede; border-bottom-color: #dedede; border-left-width: 0px; border-right-width: 0px; border-bottom-style: solid; border-top-width: 0px; border-bottom-width: 0px; border-left-color: #dedede; border-top-style: solid; border-top-color: #dedede; border-right-style: solid" cellpadding="0" align="center" cellspacing="0"> <tr> <td> <center> <table width="600" id="contentTbl" border="0" cellpadding="0" align="center" cellspacing="0"> <tr style="background-color: #666666"> <td align="left" valign="middle"> <div style="margin-bottom: 4px; margin-left: 10px; margin-top: 4px"> <font color="#EEEEEE" face="Helvetica,sans-serif" size="6">&lt;ALERT NAME&gt; </font> </div> </td> </tr> <tr> <td bgcolor="#DCDEDE" colspan="1" align="left" valign="middle"> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>CommCell: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;COMMCELL NAME&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Type: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;ALERT CATEGORY - ALERT TYPE&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Detected Criteria: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;DETECTED CRITERIA&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Detected Time: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;TIME&gt;</font></strong> </ul> </td> </tr> <tr> <td width="100%" colspan="1" align="left"> <ul> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">User: &lt;USER NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Job ID: &lt;JOB ID&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Status: &lt;STATUS&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Storage Policy Name: &lt;SP NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Copy Name: &lt;COPY NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Start Time: &lt;START TIME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Scheduled Time: &lt;SCHEDULE TIME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">End Time: &lt;END TIME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Error Code: &lt;ERR CODE&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Failure Reason: &lt;FAILURE REASON&gt; </font> </li> </ul> </td> </tr> <tr style="background-color: #666666"> <td colspan="1" align="left">  </td> </tr> </table> </center> </td> </tr> </table>'
	set @textdefaultTemplateForDDBReconAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END> MsgNewLine_ Alert: <ALERT NAME> MsgNewLine_ Type: <ALERT CATEGORY - ALERT TYPE> MsgNewLine_MsgTab_ Detected Criteria: <DETECTED CRITERIA> MsgNewLine_MsgTab_ Detected Time: <TIME> MsgNewLine_MsgTab_ CommCell: <COMMCELL NAME> MsgNewLine_MsgTab_ User: <USER NAME> MsgNewLine_ MsgNewLine_ MsgTab_ Job ID: <JOB ID> MsgNewLine_MsgTab_ Status: <STATUS> MsgNewLine_MsgTab_ Storage Policy Name: <SP NAME> MsgNewLine_MsgTab_ Copy Name: <COPY NAME> MsgNewLine_MsgTab_ Start Time: <START TIME> MsgNewLine_MsgTab_ Scheduled Time: <SCHEDULE TIME> MsgNewLine_MsgTab_ End Time: <END TIME> MsgNewLine_MsgTab_ Error Code: <ERR CODE> MsgNewLine_MsgTab_ Failure Reason: <FAILURE REASON> MsgNewLine_MsgTab_'
	Insert @alertsToAdd values(
			@createdAlertsId,
55,
			'Dedup DB reconstruction job failed',
			'Default Dedup DB reconstruction Job failed alert',
			@textdefaultTemplateForDDBReconAlert,
			@htmldefaultTemplateForDDBReconAlert,
			0,
			@allStoragePolicyXmlEntities
	)
	Insert into @criteriasToAdd
select @createdAlertsId,3,NULL,NULL,NULL
	set @createdAlertsId = @createdAlertsId + 1
	DECLARE @htmldefaultTemplateForDeviceOfflineAlert nvarchar(max)
	DECLARE @textdefaultTemplateForDeviceOfflineAlert nvarchar(max)
	IF @newTemplate = 1
		set @htmldefaultTemplateForDeviceOfflineAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><div id="contentTbl-table-scroll"> <table cellspacing="0" cellpadding="0" width="100%" style="border: 1px solid #2f4e66;"> <tr> <td> <center> <table id="contentTbl" cellspacing="0" cellpadding="0" width="100%" border="0"> <tr style="background-color: #2f4e66"> <td valign="middle" align="left" colspan="3"> <div style="margin-left: 20px; margin-bottom: 25px; margin-top: 25px"> <font color="#FFFFFF" size="5" face="sans-serif"><b>&lt;ALERT NAME&gt; </b></font> </div> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Type </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;ALERT CATEGORY - ALERT TYPE&gt;</font> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>CommCell </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;COMMCELL NAME&gt;</font> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Detected Criteria </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;DETECTED CRITERIA&gt;</font> </td> </tr> <tr> <td colspan="3" style="padding-top: 5px; padding-bottom: 5px; padding-right: 0; padding-left: 0"> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>User </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;USER NAME&gt;</font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Status</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;STATUS&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Library Name</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;LIBRARY NAME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Mount Path</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;SPAREPOOL/MOUNTPATH NAME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Drivepool</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;DRIVEPOOL NAME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Drive</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;DRIVE NAME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Failure Reason</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;FAILURE REASON&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Condition Cleared</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;CONDITION CLEARED Y/N&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> </td> </tr> <tr style="background-color: #2f4e66"> <td colspan="3" align="right" style="padding-top: 7px; padding-right: 20px; padding-bottom: 7px; padding-left: 0px"> <font size="3" face="sans-serif" color="#ffffff">Generated At &lt;TIME&gt; </font> </td> </tr> </table> </center> </td> </tr> </table> </div>'
	ELSE
		set	@htmldefaultTemplateForDeviceOfflineAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><table width="600" border="1" style="border-left-style: solid; border-right-color: #dedede; border-bottom-color: #dedede; border-left-width: 0px; border-right-width: 0px; border-bottom-style: solid; border-top-width: 0px; border-bottom-width: 0px; border-left-color: #dedede; border-top-style: solid; border-top-color: #dedede; border-right-style: solid" cellpadding="0" align="center" cellspacing="0"> <tr> <td> <center> <table width="600" id="contentTbl" border="0" cellpadding="0" align="center" cellspacing="0"> <tr style="background-color: #666666"> <td align="left" valign="middle"> <div style="margin-bottom: 4px; margin-left: 10px; margin-top: 4px"> <font color="#EEEEEE" face="Helvetica,sans-serif" size="6">&lt;ALERT NAME&gt; </font> </div> </td> </tr> <tr> <td bgcolor="#DCDEDE" colspan="1" align="left" valign="middle"> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>CommCell: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;COMMCELL NAME&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Type: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;ALERT CATEGORY - ALERT TYPE&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Detected Criteria: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;DETECTED CRITERIA&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Detected Time: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;TIME&gt;</font></strong> </ul> </td> </tr> <tr> <td width="100%" colspan="1" align="left"> <ul> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">User: &lt;USER NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Status: &lt;STATUS&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Library Name: &lt;LIBRARY NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Mount Path: &lt;SPAREPOOL/MOUNTPATH NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Drivepool: &lt;DRIVEPOOL NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Drive: &lt;DRIVE NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Failure Reason: &lt;FAILURE REASON&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Condition Cleared: &lt;CONDITION CLEARED Y/N&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Offline Since: &lt;OFFLINE SINCE&gt; </font> </li> </ul> </td> </tr> <tr style="background-color: #666666"> <td colspan="1" align="left">  </td> </tr> </table> </center> </td> </tr> </table>'
	set @textdefaultTemplateForDeviceOfflineAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END> MsgNewLine_ Alert: <ALERT NAME> MsgNewLine_ Type: <ALERT CATEGORY - ALERT TYPE> MsgNewLine_MsgTab_ Detected Criteria: <DETECTED CRITERIA> MsgNewLine_MsgTab_ Detected Time: <TIME> MsgNewLine_MsgTab_ CommCell: <COMMCELL NAME> MsgNewLine_MsgTab_ User: <USER NAME> MsgNewLine_ MsgNewLine_ MsgTab_ Status: <STATUS> MsgNewLine_MsgTab_ Library Name: <LIBRARY NAME> MsgNewLine_MsgTab_ Mount Path: <SPAREPOOL/MOUNTPATH NAME> MsgNewLine_MsgTab_ Drivepool: <DRIVEPOOL NAME> MsgNewLine_MsgTab_ Drive: <DRIVE NAME> MsgNewLine_MsgTab_ Failure Reason: <FAILURE REASON> MsgNewLine_MsgTab_ Condition Cleared: <CONDITION CLEARED Y/N> MsgNewLine_MsgTab_  Offline Since:  <OFFLINE SINCE> MsgNewLine_MsgTab_'
	Insert @alertsToAdd values(
			@createdAlertsId,
21,
			'Device went offline',
			'Default Device went offline alert',
			@textdefaultTemplateForDeviceOfflineAlert,
			@htmldefaultTemplateForDeviceOfflineAlert,
			0,
			@allLibrariesXmlEntities
	)
	Insert into @criteriasToAdd
select @createdAlertsId,29,NULL,NULL,NULL
	union
select @createdAlertsId,30,NULL,NULL,NULL
	union
select @createdAlertsId,31,NULL,NULL,NULL
	set @createdAlertsId = @createdAlertsId + 1
	DECLARE @htmldefaultTemplateForDRAlert nvarchar(max)
	DECLARE @textdefaultTemplateForDRAlert nvarchar(max)
	IF @newTemplate=1
		set @htmldefaultTemplateForDRAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><div id="contentTbl-table-scroll"> <table cellspacing="0" cellpadding="0" width="100%" style="border: 1px solid #2f4e66;"> <tr> <td> <center> <table id="contentTbl" cellspacing="0" cellpadding="0" width="100%" border="0"> <tr style="background-color: #2f4e66"> <td valign="middle" align="left" colspan="3"> <div style="margin-left: 20px; margin-bottom: 25px; margin-top: 25px"> <font color="#FFFFFF" size="5" face="sans-serif"><b>&lt;ALERT NAME&gt; </b></font> </div> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Type </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;ALERT CATEGORY - ALERT TYPE&gt;</font> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>CommCell </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;COMMCELL NAME&gt;</font> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Detected Criteria </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;DETECTED CRITERIA&gt;</font> </td> </tr> <tr> <td colspan="3" style="padding-top: 5px; padding-bottom: 5px; padding-right: 0; padding-left: 0"> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>User </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;USER NAME&gt;</font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Job ID</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;JOB ID&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Status</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;STATUS&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Level</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;LEVEL&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Start Time</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;START TIME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Scheduled Time</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;SCHEDULE TIME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>End Time</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;END TIME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Error Code</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;ERR CODE&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Failure Reason</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;FAILURE REASON&gt;</font> </td> </tr> <tr style="background-color: #2f4e66"> <td colspan="3" align="right" style="padding-top: 7px; padding-right: 20px; padding-bottom: 7px; padding-left: 0px"> <font size="3" face="sans-serif" color="#ffffff">Generated At &lt;TIME&gt; </font> </td> </tr> </table> </center> </td> </tr> </table> </div>'
	ELSE
		set @htmldefaultTemplateForDRAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><table width="600" border="1" style="border-left-style: solid; border-right-color: #dedede; border-bottom-color: #dedede; border-left-width: 0px; border-right-width: 0px; border-bottom-style: solid; border-top-width: 0px; border-bottom-width: 0px; border-left-color: #dedede; border-top-style: solid; border-top-color: #dedede; border-right-style: solid" cellpadding="0" align="center" cellspacing="0"> <tr> <td> <center> <table width="600" id="contentTbl" border="0" cellpadding="0" align="center" cellspacing="0"> <tr style="background-color: #666666"> <td align="left" valign="middle"> <div style="margin-bottom: 4px; margin-left: 10px; margin-top: 4px"> <font color="#EEEEEE" face="Helvetica,sans-serif" size="6">&lt;ALERT NAME&gt; </font> </div> </td> </tr> <tr> <td bgcolor="#DCDEDE" colspan="1" align="left" valign="middle"> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>CommCell: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;COMMCELL NAME&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Type: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;ALERT CATEGORY - ALERT TYPE&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Detected Criteria: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;DETECTED CRITERIA&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Detected Time: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;TIME&gt;</font></strong> </ul> </td> </tr> <tr> <td width="100%" colspan="1" align="left"> <ul> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">User: &lt;USER NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Job ID: &lt;JOB ID&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Status: &lt;STATUS&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Level: &lt;LEVEL&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Start Time: &lt;START TIME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Scheduled Time: &lt;SCHEDULE TIME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">End Time: &lt;END TIME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Error Code: &lt;ERR CODE&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Failure Reason: &lt;FAILURE REASON&gt; </font> </li> </ul> </td> </tr> <tr style="background-color: #666666"> <td colspan="1" align="left">  </td> </tr> </table> </center> </td> </tr> </table>'
	set @textdefaultTemplateForDRAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END> MsgNewLine_ Alert: <ALERT NAME> MsgNewLine_ Type: <ALERT CATEGORY - ALERT TYPE> MsgNewLine_MsgTab_ Detected Criteria: <DETECTED CRITERIA> MsgNewLine_MsgTab_ Detected Time: <TIME> MsgNewLine_MsgTab_ CommCell: <COMMCELL NAME> MsgNewLine_MsgTab_ User: <USER NAME> MsgNewLine_ MsgNewLine_ MsgTab_ Job ID: <JOB ID> MsgNewLine_MsgTab_ Status: <STATUS> MsgNewLine_MsgTab_ Level: <LEVEL> MsgNewLine_MsgTab_ Start Time: <START TIME> MsgNewLine_MsgTab_ Scheduled Time: <SCHEDULE TIME> MsgNewLine_MsgTab_ End Time: <END TIME> MsgNewLine_MsgTab_ Error Code: <ERR CODE> MsgNewLine_MsgTab_ Failure Reason: <FAILURE REASON> MsgNewLine_MsgTab_'
	Insert @alertsToAdd values(
			@createdAlertsId,
5,
			'Disaster recovery job failed',
			'Default DR Backup Job Failure Alert',
			@textdefaultTemplateForDRAlert,
			@htmldefaultTemplateForDRAlert,
			0,
			@XmlEntities
	)
	Insert into @criteriasToAdd
select @createdAlertsId,3,NULL,NULL,NULL
	union
select @createdAlertsId,57,NULL,NULL,NULL
	set @createdAlertsId = @createdAlertsId + 1
	DECLARE @htmldefaultTemplateForLibManAlert nvarchar(max)
	DECLARE @textdefaultTemplateForLibManAlert nvarchar(max)
	IF @newTemplate=1
		set @htmldefaultTemplateForLibManAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><div id="contentTbl-table-scroll"> <table cellspacing="0" cellpadding="0" width="100%" style="border: 1px solid #2f4e66;"> <tr> <td> <center> <table id="contentTbl" cellspacing="0" cellpadding="0" width="100%" border="0"> <tr style="background-color: #2f4e66"> <td valign="middle" align="left" colspan="3"> <div style="margin-left: 20px; margin-bottom: 25px; margin-top: 25px"> <font color="#FFFFFF" size="5" face="sans-serif"><b>&lt;ALERT NAME&gt; </b></font> </div> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Type </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;ALERT CATEGORY - ALERT TYPE&gt;</font> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>CommCell </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;COMMCELL NAME&gt;</font> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Detected Criteria </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;DETECTED CRITERIA&gt;</font> </td> </tr> <tr> <td colspan="3" style="padding-top: 5px; padding-bottom: 5px; padding-right: 0; padding-left: 0"> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>User </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;USER NAME&gt;</font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Status</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;STATUS&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Library Name</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;LIBRARY NAME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>SparePool/Mount Path</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;SPAREPOOL/MOUNTPATH NAME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Drivepool</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;DRIVEPOOL NAME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Drive</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;DRIVE NAME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>MediaAgent Name</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;MEDIAAGENT NAME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Media label</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;MEDIA LABEL&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Media/Space left (excluding reserve space)</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;MEDIA SPACE LEFT&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Failure Reason</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;FAILURE REASON&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Other library</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;OTHER LIBRARY&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Recall Reason</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;RECALL REASON&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Recall Expiration Time</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;RECALL EXPIRE TIME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Recall Destination</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;RECALL DESTINATION&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Media List</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;MEDIA LIST&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Condition Cleared</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;CONDITION CLEARED Y/N&gt; </font> </td> </tr> <tr style="background-color: #2f4e66"> <td colspan="3" align="right" style="padding-top: 7px; padding-right: 20px; padding-bottom: 7px; padding-left: 0px"> <font size="3" face="sans-serif" color="#ffffff">Generated At &lt;TIME&gt; </font> </td> </tr> </table> </center> </td> </tr> </table> </div>'
	ELSE
		set @htmldefaultTemplateForLibManAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><table width="600" border="1" style="border-left-style: solid; border-right-color: #dedede; border-bottom-color: #dedede; border-left-width: 0px; border-right-width: 0px; border-bottom-style: solid; border-top-width: 0px; border-bottom-width: 0px; border-left-color: #dedede; border-top-style: solid; border-top-color: #dedede; border-right-style: solid" cellpadding="0" align="center" cellspacing="0"> <tr> <td> <center> <table width="600" id="contentTbl" border="0" cellpadding="0" align="center" cellspacing="0"> <tr style="background-color: #666666"> <td align="left" valign="middle"> <div style="margin-bottom: 4px; margin-left: 10px; margin-top: 4px"> <font color="#EEEEEE" face="Helvetica,sans-serif" size="6">&lt;ALERT NAME&gt; </font> </div> </td> </tr> <tr> <td bgcolor="#DCDEDE" colspan="1" align="left" valign="middle"> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>CommCell: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;COMMCELL NAME&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Type: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;ALERT CATEGORY - ALERT TYPE&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Detected Criteria: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;DETECTED CRITERIA&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Detected Time: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;TIME&gt;</font></strong> </ul> </td> </tr> <tr> <td width="100%" colspan="1" align="left"> <ul> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">User: &lt;USER NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Status: &lt;STATUS&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Library Name: &lt;LIBRARY NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">SparePool/Mount Path: &lt;SPAREPOOL/MOUNTPATH NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Drivepool: &lt;DRIVEPOOL NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Drive: &lt;DRIVE NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">MediaAgent Name: &lt;MEDIAAGENT NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Media label: &lt;MEDIA LABEL&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Media/Space left (excluding reserve space): &lt;MEDIA SPACE LEFT&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Failure Reason: &lt;FAILURE REASON&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Other library: &lt;OTHER LIBRARY&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Recall Reason: &lt;RECALL REASON&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Recall Expiration Time: &lt;RECALL EXPIRE TIME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Recall Destination: &lt;RECALL DESTINATION&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Media List: &lt;MEDIA LIST&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Condition Cleared: &lt;CONDITION CLEARED Y/N&gt; </font> </li> </ul> </td> </tr> <tr style="background-color: #666666"> <td colspan="1" align="left">  </td> </tr> </table> </center> </td> </tr> </table>'
	set @textdefaultTemplateForLibManAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END> MsgNewLine_ Alert: <ALERT NAME> MsgNewLine_ Type: <ALERT CATEGORY - ALERT TYPE> MsgNewLine_MsgTab_ Detected Criteria: <DETECTED CRITERIA> MsgNewLine_MsgTab_ Detected Time: <TIME> MsgNewLine_MsgTab_ CommCell: <COMMCELL NAME> MsgNewLine_MsgTab_ User: <USER NAME> MsgNewLine_ MsgNewLine_ MsgTab_ Status: <STATUS> MsgNewLine_MsgTab_ Library Name: <LIBRARY NAME> MsgNewLine_MsgTab_ SparePool/Mount Path: <SPAREPOOL/MOUNTPATH NAME> MsgNewLine_MsgTab_ Drivepool: <DRIVEPOOL NAME> MsgNewLine_MsgTab_ Drive: <DRIVE NAME> MsgNewLine_MsgTab_ MediaAgent Name: <MEDIAAGENT NAME> MsgNewLine_MsgTab_ Media label: <MEDIA LABEL> MsgNewLine_MsgTab_ Media/Space left (excluding reserve space): <MEDIA SPACE LEFT> MsgNewLine_MsgTab_ Failure Reason: <FAILURE REASON> MsgNewLine_MsgTab_ Other library: <OTHER LIBRARY> MsgNewLine_MsgTab_ Recall Reason: <RECALL REASON> MsgNewLine_MsgTab_ Recall Expiration Time: <RECALL EXPIRE TIME> MsgNewLine_MsgTab_ Recall Destination: <RECALL DESTINATION> MsgNewLine_MsgTab_ Media List: <MEDIA LIST> MsgNewLine_MsgTab_  Condition Cleared: <CONDITION CLEARED Y/N> MsgNewLine_MsgTab_'
	Insert @alertsToAdd values(
			@createdAlertsId,
17,
			'Insufficient storage on library',
			'Default Insufficient Storage on library alert',
			@textdefaultTemplateForLibManAlert,
			@htmldefaultTemplateForLibManAlert,
			0,
			@allLibrariesXmlEntities
	)
	Insert into @criteriasToAdd
select @createdAlertsId,22,NULL,NULL,NULL
	set @createdAlertsId = @createdAlertsId + 1
	Insert @alertsToAdd values(
			@createdAlertsId,
17,					-- 'NT_ALERTTYPE_DATA_RECOV'
			'Library maintenance required',
			'Default Library Maintenance Required alert',
			@textdefaultTemplateForLibManAlert,
			@htmldefaultTemplateForLibManAlert,
			0,
			@allLibrariesXmlEntities
	)
	Insert into @criteriasToAdd
select @createdAlertsId,26,NULL,NULL,NULL
	set @createdAlertsId = @createdAlertsId + 1
	Insert @alertsToAdd values(
			@createdAlertsId,
17,					-- 'NT_ALERTTYPE_DATA_RECOV'
			'Media mount and usage error',
			'Default Media mount and usage error alert',
			@textdefaultTemplateForLibManAlert,
			@htmldefaultTemplateForLibManAlert,
			0,
			@allLibrariesXmlEntities
	)
	Insert into @criteriasToAdd
select @createdAlertsId,25,NULL,NULL,NULL
	set @createdAlertsId = @createdAlertsId + 1
	DECLARE @textdefaultTemplateForMAAlert nvarchar(max)
	DECLARE @htmldefaultTemplateForMAAlert nvarchar(max)
	IF @newTemplate=1
		set @htmldefaultTemplateForMAAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><div id="contentTbl-table-scroll"> <table cellspacing="0" cellpadding="0" width="100%" style="border: 1px solid #2f4e66;"> <tr> <td> <center> <table id="contentTbl" cellspacing="0" cellpadding="0" width="100%" border="0"> <tr style="background-color: #2f4e66"> <td valign="middle" align="left" colspan="3"> <div style="margin-left: 20px; margin-bottom: 25px; margin-top: 25px"> <font color="#FFFFFF" size="5" face="sans-serif"><b>&lt;ALERT NAME&gt; </b></font> </div> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Type </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;ALERT CATEGORY - ALERT TYPE&gt;</font> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>CommCell </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;COMMCELL NAME&gt;</font> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Detected Criteria </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;DETECTED CRITERIA&gt;</font> </td> </tr> <tr> <td colspan="3" style="padding-top: 5px; padding-bottom: 5px; padding-right: 0; padding-left: 0"> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>User </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;USER NAME&gt;</font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>MediaAgent Name</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;MEDIAAGENT NAME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Comments</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;COMMENT&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Status</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;STATUS&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Media/Space left (excluding reserve space)</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;DISK SPACE INFO&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Disk Space Low</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;DISK SPACE LOW Y/N&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Disk Space Available</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;FREE SPACE&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Condition Cleared</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;CONDITION CLEARED Y/N&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> </td> </tr> <tr style="background-color: #2f4e66"> <td colspan="3" align="right" style="padding-top: 7px; padding-right: 20px; padding-bottom: 7px; padding-left: 0px"> <font size="3" face="sans-serif" color="#ffffff">Generated At &lt;TIME&gt; </font> </td> </tr> </table> </center> </td> </tr> </table> </div>'
	ELSE
		set @htmldefaultTemplateForMAAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><table width="600" border="1" style="border-left-style: solid; border-right-color: #dedede; border-bottom-color: #dedede; border-left-width: 0px; border-right-width: 0px; border-bottom-style: solid; border-top-width: 0px; border-bottom-width: 0px; border-left-color: #dedede; border-top-style: solid; border-top-color: #dedede; border-right-style: solid" cellpadding="0" align="center" cellspacing="0"> <tr> <td> <center> <table width="600" id="contentTbl" border="0" cellpadding="0" align="center" cellspacing="0"> <tr style="background-color: #666666"> <td align="left" valign="middle"> <div style="margin-bottom: 4px; margin-left: 10px; margin-top: 4px"> <font color="#EEEEEE" face="Helvetica,sans-serif" size="6">&lt;ALERT NAME&gt; </font> </div> </td> </tr> <tr> <td bgcolor="#DCDEDE" colspan="1" align="left" valign="middle"> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>CommCell: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;COMMCELL NAME&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Type: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;ALERT CATEGORY - ALERT TYPE&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Detected Criteria: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;DETECTED CRITERIA&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Detected Time: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;TIME&gt;</font></strong> </ul> </td> </tr> <tr> <td width="100%" colspan="1" align="left"> <ul> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">User: &lt;USER NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">MediaAgent Name: &lt;MEDIAAGENT NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Comments: &lt;COMMENT&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Media/Space left (excluding reserve space): &lt;DISK SPACE INFO&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Disk Space Low: &lt;DISK SPACE LOW Y/N&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Disk Space Available: &lt;FREE SPACE&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Condition Cleared: &lt;CONDITION CLEARED Y/N&gt; </font> </li> </ul> </td> </tr> <tr style="background-color: #666666"> <td colspan="1" align="left">  </td> </tr> </table> </center> </td> </tr> </table>'
	set @textdefaultTemplateForMAAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END> MsgNewLine_ Alert: <ALERT NAME> MsgNewLine_ Type: <ALERT CATEGORY - ALERT TYPE> MsgNewLine_MsgTab_ Detected Criteria: <DETECTED CRITERIA> MsgNewLine_MsgTab_ Detected Time: <TIME> MsgNewLine_MsgTab_ CommCell: <COMMCELL NAME> MsgNewLine_MsgTab_ User: <USER NAME> MsgNewLine_ MsgNewLine_ MsgTab_ MediaAgent Name: <MEDIAAGENT NAME> MsgNewLine_MsgTab_ Comments: <COMMENT> MsgNewLine_MsgTab_ Media/Space left (excluding reserve space): <DISK SPACE INFO> MsgNewLine_MsgTab_ Disk Space Low: <DISK SPACE LOW Y/N> MsgNewLine_MsgTab_ Disk Space Available: <FREE SPACE> MsgNewLine_MsgTab_ Condition Cleared: <CONDITION CLEARED Y/N> MsgNewLine_MsgTab_'
	Insert @alertsToAdd values(
			@createdAlertsId,
13,					-- 'NT_ALERTTYPE_DATA_RECOV'
			'Disk space low on media agent',
			'Default MA Disk space low alert',
			@textdefaultTemplateForMAAlert,
			@htmldefaultTemplateForMAAlert,
			0,
			@allMAsXmlEntities
	)
	Insert into @criteriasToAdd
select @createdAlertsId,18,NULL,NULL,NULL
	set @createdAlertsId = @createdAlertsId + 1
	DECLARE @textdefaultTemplateForLicenseAlert nvarchar(max)
	DECLARE @htmldefaultTemplateForLicenseAlert nvarchar(max)
	IF @newTemplate=1
		set @htmldefaultTemplateForLicenseAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><div id="contentTbl-table-scroll"> <table cellspacing="0" cellpadding="0" width="100%" style="border: 1px solid #2f4e66;"> <tr> <td> <center> <table id="contentTbl" cellspacing="0" cellpadding="0" width="100%" border="0"> <tr style="background-color: #2f4e66"> <td valign="middle" align="left" colspan="3"> <div style="margin-left: 20px; margin-bottom: 25px; margin-top: 25px"> <font color="#FFFFFF" size="5" face="sans-serif"><b>&lt;ALERT NAME&gt; </b></font> </div> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Type </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;ALERT CATEGORY - ALERT TYPE&gt;</font> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>CommCell </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;COMMCELL NAME&gt;</font> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Detected Criteria </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;DETECTED CRITERIA&gt;</font> </td> </tr> <tr> <td colspan="3" style="padding-top: 5px; padding-bottom: 5px; padding-right: 0; padding-left: 0"> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>User </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;USER NAME&gt;</font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Comments</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;COMMENT&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>License Expired</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;LICENSE EXPIRED&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Number Of Days Left For License Expiration</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;NO. OF DAYS LEFT FOR LICENSE EXPIRY&gt; </font> </td> </tr> <tr style="background-color: #2f4e66"> <td colspan="3" align="right" style="padding-top: 7px; padding-right: 20px; padding-bottom: 7px; padding-left: 0px"> <font size="3" face="sans-serif" color="#ffffff">Generated At &lt;TIME&gt; </font> </td> </tr> </table> </center> </td> </tr> </table> </div>'
	ELSE
		set @htmldefaultTemplateForLicenseAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><table width="600" border="1" style="border-left-style: solid; border-right-color: #dedede; border-bottom-color: #dedede; border-left-width: 0px; border-right-width: 0px; border-bottom-style: solid; border-top-width: 0px; border-bottom-width: 0px; border-left-color: #dedede; border-top-style: solid; border-top-color: #dedede; border-right-style: solid" cellpadding="0" align="center" cellspacing="0"> <tr> <td> <center> <table width="600" id="contentTbl" border="0" cellpadding="0" align="center" cellspacing="0"> <tr style="background-color: #666666"> <td align="left" valign="middle"> <div style="margin-bottom: 4px; margin-left: 10px; margin-top: 4px"> <font color="#EEEEEE" face="Helvetica,sans-serif" size="6">&lt;ALERT NAME&gt; </font> </div> </td> </tr> <tr> <td bgcolor="#DCDEDE" colspan="1" align="left" valign="middle"> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>CommCell: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;COMMCELL NAME&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Type: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;ALERT CATEGORY - ALERT TYPE&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Detected Criteria: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;DETECTED CRITERIA&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Detected Time: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;TIME&gt;</font></strong> </ul> </td> </tr> <tr> <td width="100%" colspan="1" align="left"> <ul> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">User: &lt;USER NAME&gt; </font> </li> <font color="#000000" face="Helvetica,sans-serif" size="3">MsgHrzSep </font> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Comments: &lt;COMMENT&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">License Expired: &lt;LICENSE EXPIRED&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Number Of Days Left For License Expiration: &lt;NO. OF DAYS LEFT FOR LICENSE EXPIRY&gt; </font> </li> <font color="#000000" face="Helvetica,sans-serif" size="3">MsgHrzSep </font> </ul> </td> </tr> <tr style="background-color: #666666"> <td colspan="1" align="left">  </td> </tr> </table> </center> </td> </tr> </table>'
	set @textdefaultTemplateForLicenseAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END> MsgNewLine_ Alert: <ALERT NAME> MsgNewLine_ Type: <ALERT CATEGORY - ALERT TYPE> MsgNewLine_MsgTab_ Detected Criteria: <DETECTED CRITERIA> MsgNewLine_MsgTab_ Detected Time: <TIME> MsgNewLine_MsgTab_ CommCell: <COMMCELL NAME> MsgNewLine_MsgTab_ User: <USER NAME> MsgNewLine_ MsgNewLine_ MsgTab_ ============================================================================================================== MsgNewLine_MsgTab_ Comments: <COMMENT> MsgNewLine_MsgTab_  License Expired: <LICENSE EXPIRED> MsgNewLine_MsgTab_ Number Of Days Left For License Expiration: <NO. OF DAYS LEFT FOR LICENSE EXPIRY> MsgNewLine_MsgTab_  ============================================================================================================== MsgNewLine_MsgTab_'
	Insert @alertsToAdd values(
			@createdAlertsId,
60,
			'License consumed exceeds 80%',
			'Default License Consumption Alert',
			@textdefaultTemplateForLicenseAlert,
			@htmldefaultTemplateForLicenseAlert,
			0,
			@XmlEntities
	)
	Insert into @criteriasToAdd
select @createdAlertsId,60,1,80,2
	set @createdAlertsId = @createdAlertsId + 1
	Insert @alertsToAdd values(
			@createdAlertsId,
60,
			'License expires within 7 days',
			'Default License Expiration alert',
			@textdefaultTemplateForLicenseAlert,
			@htmldefaultTemplateForLicenseAlert,
			0,
			@XmlEntities
	)
	Insert into @criteriasToAdd
select @createdAlertsId,58,7,7,15
	set @createdAlertsId = @createdAlertsId + 1
	DECLARE @htmldefaultTemplateForNoBackupLastNdays nvarchar(max)
	DECLARE @textdefaultTemplateForNoBackupLastNdays nvarchar(max)
	IF @newTemplate=1
		set @htmldefaultTemplateForNoBackupLastNdays = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><div id="contentTbl-table-scroll"> <table cellspacing="0" cellpadding="0" width="100%" style="border: 1px solid #2f4e66;"> <tr> <td> <center> <table id="contentTbl" cellspacing="0" cellpadding="0" width="100%" border="0"> <tr style="background-color: #2f4e66"> <td valign="middle" align="left" colspan="3"> <div style="margin-left: 20px; margin-bottom: 25px; margin-top: 25px"> <font color="#FFFFFF" size="5" face="sans-serif"><b>&lt;ALERT NAME&gt; </b></font> </div> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Type </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;ALERT CATEGORY - ALERT TYPE&gt;</font> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>CommCell </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;COMMCELL NAME&gt;</font> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Detected Criteria </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;DETECTED CRITERIA&gt;</font> </td> </tr> <tr> <td colspan="3" style="padding-top: 5px; padding-bottom: 5px; padding-right: 0; padding-left: 0"> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>User </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;USER NAME&gt;</font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Job ID</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;JOB ID&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Status</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;STATUS&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Client</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;CLIENT NAME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Agent Type</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;AGENT TYPE NAME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Instance</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;INSTANCE NAME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Backup Set</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;BACKUPSET NAME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Subclient</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;SUBCLIENT NAME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Backup Level</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;LEVEL&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Storage Policies Used</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;STORAGE POLICIES USED&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Virtual Machine Name</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;VIRTUAL MACHINE NAME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Virtual Machine Host Name</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;VIRTUAL MACHINE HOST NAME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Virtual Machine Backup Status</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;VM STATUS&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Failure reason for Virtual Machine Backup</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;VM FAILURE REASON&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Start Time</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;START TIME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Scheduled Time</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;SCHEDULE TIME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>End Time</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;END TIME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Error Code</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;ERR CODE&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Failure Reason</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;FAILURE REASON&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Protected Counts</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;PROTECTED COUNT&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Failed Counts</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;FAILED COUNT&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Not backed up since</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;NO SUCCESSFUL JOB SINCE&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Date of last recorded backup</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;DATE OF LAST SUCCESSFUL JOB&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Time of last recorded backup</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;TIME OF LAST SUCCESSFUL JOB&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>&lt;ADDITIONAL VM INFO&gt; </b></font> </td> </tr> <tr style="background-color: #2f4e66"> <td colspan="3" align="right" style="padding-top: 7px; padding-right: 20px; padding-bottom: 7px; padding-left: 0px"> <font size="3" face="sans-serif" color="#ffffff">Generated At &lt;TIME&gt; </font> </td> </tr> </table> </center> </td> </tr> </table> </div>'
	ELSE
		set @htmldefaultTemplateForNoBackupLastNdays = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><table border="1" align="center" style="border-bottom-color: #dedede; border-top-width: 0px; border-left-color: #dedede; border-bottom-width: 0px; border-bottom-style: solid; border-left-width: 0px; border-top-color: #dedede; border-top-style: solid; border-right-style: solid; border-right-color: #dedede; border-right-width: 0px; border-left-style: solid" cellspacing="0" cellpadding="0" width="600"> <tr> <td> <center> <table border="0" align="center" cellspacing="0" id="contentTbl" cellpadding="0" width="600"> <tr style="background-color: #666666"> <td align="left" colspan="1" valign="middle"> <div style="margin-bottom: 4px; margin-top: 4px; margin-left: 10px"> <font color="#EEEEEE" size="6" face="Helvetica,sans-serif">&lt;ALERT NAME&gt; </font> </div> </td> <td align="right" colspan="1" valign="middle"> <div style="margin-bottom: 4px; margin-top: 4px; margin-left: 40px"> <font color="#EEEEEE" size="3" face="Helvetica,sans-serif">&lt;TIME&gt; </font> </div> </td> </tr> <tr> <td align="left" colspan="2" bgcolor="#DCDEDE" valign="middle"> <ul style="margin-bottom: 4px; margin-top: 4px"> <font size="4" face="Helvetica,sans-serif"><strong>CommCell: </strong></font><strong><font color="#660000" size="4" face="Helvetica,sans-serif">&lt;COMMCELL NAME&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font size="4" face="Helvetica,sans-serif"><strong>Type: </strong></font><strong><font color="#660000" size="4" face="Helvetica,sans-serif">&lt;ALERT CATEGORY - ALERT TYPE&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font size="4" face="Helvetica,sans-serif"><strong>Detected Criteria: </strong></font><strong><font color="#660000" size="4" face="Helvetica,sans-serif">&lt;DETECTED CRITERIA&gt;</font></strong> </ul> </td> </tr> <tr> <td align="left" colspan="2" width="100%"> <ul> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" size="3" face="Helvetica,sans-serif">Client: &lt;CLIENT NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" size="3" face="Helvetica,sans-serif">Agent Type: &lt;AGENT TYPE NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" size="3" face="Helvetica,sans-serif">Instance: &lt;INSTANCE NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" size="3" face="Helvetica,sans-serif">Backup Set: &lt;BACKUPSET NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" size="3" face="Helvetica,sans-serif">Subclient: &lt;SUBCLIENT NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" size="3" face="Helvetica,sans-serif">Not backed up since: &lt;NO SUCCESSFUL JOB SINCE&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" size="3" face="Helvetica,sans-serif">Date of last recorded backup: &lt;DATE OF LAST SUCCESSFUL JOB&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" size="3" face="Helvetica,sans-serif">Time of last recorded backup: &lt;TIME OF LAST SUCCESSFUL JOB&gt; </font> </li> </ul> </td> </tr> <tr style="background-color: #666666"> <td align="left" colspan="2">   </td> </tr> </table> </center> </td> </tr> </table>'
	set @textdefaultTemplateForNoBackupLastNdays = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END> MsgNewLine_ Alert: <ALERT NAME> MsgNewLine_ Type: <ALERT CATEGORY - ALERT TYPE> MsgNewLine_MsgTab_ Detected Criteria: <DETECTED CRITERIA> MsgNewLine_MsgTab_ Detected Time: <TIME> MsgNewLine_MsgTab_ CommCell: <COMMCELL NAME> MsgNewLine_MsgTab_ User: <USER NAME> MsgNewLine_ MsgNewLine_MsgTab_ Client: <CLIENT NAME> MsgNewLine_MsgTab_ Agent Type: <AGENT TYPE NAME> MsgNewLine_MsgTab_ Instance: <INSTANCE NAME> MsgNewLine_MsgTab_ Backup Set: <BACKUPSET NAME> MsgNewLine_MsgTab_ Subclient: <SUBCLIENT NAME> MsgNewLine_MsgTab_ Not backed up since:  <NO SUCCESSFUL JOB SINCE> MsgNewLine_MsgTab_ Date of last recorded backup:  <DATE OF LAST SUCCESSFUL JOB> MsgNewLine_MsgTab_ Time of last recorded backup:  <TIME OF LAST SUCCESSFUL JOB> MsgNewLine_MsgTab_'
	Insert into @alertsToAdd
	select @createdAlertsId,
              3,
              'No backup for last 7 days',
              'Default alert for No successful backup in last 7 days',
              @textdefaultTemplateForNoBackupLastNdays,
              @htmldefaultTemplateForNoBackupLastNdays,
			  0,
              @allClientXmlEntities
	Insert into @criteriasToAdd
	select @createdAlertsId,65,2,7,5
	set @createdAlertsId = @createdAlertsId + 1
	DECLARE @htmldefaultTemplateForUpdatesAvailable nvarchar(max)
	DECLARE @textdefaultTemplateForUpdatesAvailable nvarchar(max)
	IF @newTemplate=1
		set @htmldefaultTemplateForUpdatesAvailable = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><div id="contentTbl-table-scroll"> <table cellspacing="0" cellpadding="0" width="100%" style="border: 1px solid #2f4e66;"> <tr> <td> <center> <table id="contentTbl" cellspacing="0" cellpadding="0" width="100%" border="0"> <tr style="background-color: #2f4e66"> <td valign="middle" align="left" colspan="3"> <div style="margin-left: 20px; margin-bottom: 25px; margin-top: 25px"> <font color="#FFFFFF" size="5" face="sans-serif"><b>&lt;ALERT NAME&gt; </b></font> </div> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Type </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;ALERT CATEGORY - ALERT TYPE&gt;</font> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>CommCell </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;COMMCELL NAME&gt;</font> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Detected Criteria </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;DETECTED CRITERIA&gt;</font> </td> </tr> <tr> <td colspan="3" style="padding-top: 5px; padding-bottom: 5px; padding-right: 0; padding-left: 0"> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>User </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;USER NAME&gt;</font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>&lt;CONTENTS&gt; </b></font> </td> </tr> <tr style="background-color: #2f4e66"> <td colspan="3" align="right" style="padding-top: 7px; padding-right: 20px; padding-bottom: 7px; padding-left: 0px"> <font size="3" face="sans-serif" color="#ffffff">Generated At &lt;TIME&gt; </font> </td> </tr> </table> </center> </td> </tr> </table> </div>'
	ELSE
		set @htmldefaultTemplateForUpdatesAvailable = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><table border="1" align="center" style="border-bottom-color: #dedede; border-top-width: 0px; border-left-color: #dedede; border-bottom-width: 0px; border-bottom-style: solid; border-left-width: 0px; border-top-color: #dedede; border-top-style: solid; border-right-style: solid; border-right-color: #dedede; border-right-width: 0px; border-left-style: solid" cellspacing="0" cellpadding="0" width="600"> <tr> <td> <center> <table border="0" align="center" cellspacing="0" id="contentTbl" cellpadding="0" width="600"> <tr style="background-color: #666666"> <td align="left" colspan="1" valign="middle"> <div style="margin-bottom: 4px; margin-top: 4px; margin-left: 10px"> <font color="#EEEEEE" size="6" face="Helvetica,sans-serif">&lt;ALERT NAME&gt; </font> </div> </td> <td align="right" colspan="1" valign="middle"> <div style="margin-bottom: 4px; margin-top: 4px; margin-left: 40px"> <font color="#EEEEEE" size="3" face="Helvetica,sans-serif">&lt;TIME&gt; </font> </div> </td> </tr> <tr> <td align="left" colspan="2" bgcolor="#DCDEDE" valign="middle"> <ul style="margin-bottom: 4px; margin-top: 4px"> <font size="4" face="Helvetica,sans-serif"><strong>CommCell: </strong></font><strong><font color="#660000" size="4" face="Helvetica,sans-serif">&lt;COMMCELL NAME&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font size="4" face="Helvetica,sans-serif"><strong>Type: </strong></font><strong><font color="#660000" size="4" face="Helvetica,sans-serif">&lt;ALERT CATEGORY - ALERT TYPE&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font size="4" face="Helvetica,sans-serif"><strong>Detected Criteria: </strong></font><strong><font color="#660000" size="4" face="Helvetica,sans-serif">&lt;DETECTED CRITERIA&gt;</font></strong> </ul> </td> </tr> <tr> <td align="left" colspan="2" width="100%"> <ul> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" size="3" face="Helvetica,sans-serif">User: &lt;USER NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" size="3" face="Helvetica,sans-serif">&lt;CONTENTS&gt; </font> </li> </ul> </td> </tr> <tr style="background-color: #666666"> <td align="left" colspan="2">   </td> </tr> </table> </center> </td> </tr> </table>'
	set @textdefaultTemplateForUpdatesAvailable = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END> MsgNewLine_ Alert: <ALERT NAME> MsgNewLine_ Type: <ALERT CATEGORY - ALERT TYPE> MsgNewLine_MsgTab_ Detected Criteria: <DETECTED CRITERIA> MsgNewLine_MsgTab_ Detected Time: <TIME> MsgNewLine_MsgTab_ CommCell: <COMMCELL NAME> MsgNewLine_MsgTab_ User: <USER NAME> MsgNewLine_ MsgNewLine_ MsgTab_ <CONTENTS>'
	Insert into @alertsToAdd
	select @createdAlertsId,
              24,
              'Updates available for download',
              'Default alert for updates available for download',
              @textdefaultTemplateForUpdatesAvailable,
              @htmldefaultTemplateForUpdatesAvailable,
			  0,
              @xmlEntities
	Insert into @criteriasToAdd
	select @createdAlertsId,38,NULL,NULL,NULL
	set @createdAlertsId = @createdAlertsId + 1
	DECLARE @htmldefaultTemplateForDDBBackup nvarchar(max)
	DECLARE @textdefaultTemplateForDDBBackup nvarchar(max)
	IF @newTemplate=1
		set @htmldefaultTemplateForDDBBackup = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><div id="contentTbl-table-scroll"> <table cellspacing="0" cellpadding="0" width="100%" style="border: 1px solid #2f4e66;"> <tr> <td> <center> <table id="contentTbl" cellspacing="0" cellpadding="0" width="100%" border="0"> <tr style="background-color: #2f4e66"> <td valign="middle" align="left" colspan="3"> <div style="margin-left: 20px; margin-bottom: 25px; margin-top: 25px"> <font color="#FFFFFF" size="5" face="sans-serif"><b>&lt;ALERT NAME&gt; </b></font> </div> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Type </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;ALERT CATEGORY - ALERT TYPE&gt;</font> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>CommCell </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;COMMCELL NAME&gt;</font> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Detected Criteria </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;DETECTED CRITERIA&gt;</font> </td> </tr> <tr> <td colspan="3" style="padding-top: 5px; padding-bottom: 5px; padding-right: 0; padding-left: 0"> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Event ID</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;EVENT ID&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Monitoring Criteria</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;MONITORING CRITERIA STRING&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Severity</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;EVENT SEVERITY&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Job ID</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;JOB ID&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Event Date</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;EVENT DATE&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Program</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;EVENT PROGRAM&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Client</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;CLIENT NAME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Description</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;DESCRIPTION&gt;</font> </td> </tr> <tr style="background-color: #2f4e66"> <td colspan="3" align="right" style="padding-top: 7px; padding-right: 20px; padding-bottom: 7px; padding-left: 0px"> <font size="3" face="sans-serif" color="#ffffff">Generated At &lt;TIME&gt; </font> </td> </tr> </table> </center> </td> </tr> </table> </div>'
	ELSE
		set @htmldefaultTemplateForDDBBackup = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><table border="1" align="center" style="border-bottom-color: #dedede; border-top-width: 0px; border-left-color: #dedede; border-bottom-width: 0px; border-bottom-style: solid; border-left-width: 0px; border-top-color: #dedede; border-top-style: solid; border-right-style: solid; border-right-color: #dedede; border-right-width: 0px; border-left-style: solid" cellspacing="0" cellpadding="0" width="600"> <tr> <td> <center> <table border="0" align="center" cellspacing="0" id="contentTbl" cellpadding="0" width="600"> <tr style="background-color: #666666"> <td align="left" colspan="1" valign="middle"> <div style="margin-bottom: 4px; margin-top: 4px; margin-left: 10px"> <font color="#EEEEEE" size="6" face="Helvetica,sans-serif">&lt;ALERT NAME&gt; </font> </div> </td> <td align="right" colspan="1" valign="middle"> <div style="margin-bottom: 4px; margin-top: 4px; margin-left: 40px"> <font color="#EEEEEE" size="3" face="Helvetica,sans-serif">&lt;TIME&gt; </font> </div> </td> </tr> <tr> <td align="left" colspan="2" bgcolor="#DCDEDE" valign="middle"> <ul style="margin-bottom: 4px; margin-top: 4px"> <font size="4" face="Helvetica,sans-serif"><strong>CommCell: </strong></font><strong><font color="#660000" size="4" face="Helvetica,sans-serif">&lt;COMMCELL NAME&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font size="4" face="Helvetica,sans-serif"><strong>Type: </strong></font><strong><font color="#660000" size="4" face="Helvetica,sans-serif">&lt;ALERT CATEGORY - ALERT TYPE&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font size="4" face="Helvetica,sans-serif"><strong>Detected Criteria: </strong></font><strong><font color="#660000" size="4" face="Helvetica,sans-serif">&lt;DETECTED CRITERIA&gt;</font></strong> </ul> </td> </tr> <tr> <td align="left" colspan="2" width="100%"> <ul> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" size="3" face="Helvetica,sans-serif">Event ID: &lt;EVENT ID&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" size="3" face="Helvetica,sans-serif">Monitoring Criteria: &lt;MONITORING CRITERIA STRING&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" size="3" face="Helvetica,sans-serif">Severity: &lt;EVENT SEVERITY&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" size="3" face="Helvetica,sans-serif">Job ID: &lt;JOB ID&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" size="3" face="Helvetica,sans-serif">Event Date: &lt;EVENT DATE&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" size="3" face="Helvetica,sans-serif">Program: &lt;EVENT PROGRAM&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" size="3" face="Helvetica,sans-serif">Client: &lt;CLIENT NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" size="3" face="Helvetica,sans-serif">Description: &lt;DESCRIPTION&gt; </font> </li> </ul> </td> </tr> <tr style="background-color: #666666"> <td align="left" colspan="2">   </td> </tr> </table> </center> </td> </tr> </table>'
	set @textdefaultTemplateForDDBBackup = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END> MsgNewLine_ Alert: <ALERT NAME> MsgNewLine_ Type: <ALERT CATEGORY - ALERT TYPE> MsgNewLine_MsgTab_ Detected Criteria: <DETECTED CRITERIA> MsgNewLine_MsgTab_ Detected Time: <TIME> MsgNewLine_MsgTab_ CommCell: <COMMCELL NAME> MsgNewLine_ MsgNewLine_ MsgTab_ Event ID: <EVENT ID> MsgNewLine_MsgTab_ Monitoring Criteria: <MONITORING CRITERIA STRING> MsgNewLine_MsgTab_ Severity: <EVENT SEVERITY> MsgNewLine_MsgTab_ Job ID: <JOB ID> MsgNewLine_MsgTab_ Event Date: <EVENT DATE> MsgNewLine_MsgTab_ Program: <EVENT PROGRAM> MsgNewLine_MsgTab_ Client: <CLIENT NAME> MsgNewLine_MsgTab_ Description: <DESCRIPTION> MsgNewLine_MsgTab_'
	Insert into @alertsToAdd
	select @createdAlertsId,
              58,
'No recent DDB backup',
              'Default alert for no recent DDB backup',
              @textdefaultTemplateForDDBBackup,
              @htmldefaultTemplateForDDBBackup,
			  0,
              @allClientXmlEntities
	Insert into @criteriasToAdd
	select @createdAlertsId,62,NULL,NULL,NULL
	set @createdAlertsId = @createdAlertsId + 1
	DECLARE @htmldefaultTemplateForDRCSRunningAlert nvarchar(max)
	DECLARE @textdefaultTemplateForDRCSRunningAlert nvarchar(max)
	IF @newTemplate=1
		set @htmldefaultTemplateForDRCSRunningAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><div id="contentTbl-table-scroll"> <table cellspacing="0" cellpadding="0" width="100%" style="border: 1px solid #2f4e66;"> <tr> <td> <center> <table id="contentTbl" cellspacing="0" cellpadding="0" width="100%" border="0"> <tr style="background-color: #2f4e66"> <td valign="middle" align="left" colspan="3"> <div style="margin-left: 20px; margin-bottom: 25px; margin-top: 25px"> <font color="#FFFFFF" size="5" face="sans-serif"><b>&lt;ALERT NAME&gt; </b></font> </div> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Type </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;ALERT CATEGORY - ALERT TYPE&gt;</font> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>CommCell </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;COMMCELL NAME&gt;</font> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Detected Criteria </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;DETECTED CRITERIA&gt;</font> </td> </tr> <tr> <td colspan="3" style="padding-top: 5px; padding-bottom: 5px; padding-right: 0; padding-left: 0"> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Event ID</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;EVENT ID&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Monitoring Criteria</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;MONITORING CRITERIA STRING&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Severity</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;EVENT SEVERITY&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Job ID</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;JOB ID&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Event Date</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;EVENT DATE&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Program</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;EVENT PROGRAM&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Client</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;CLIENT NAME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Description</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;DESCRIPTION&gt;</font> </td> </tr> <tr style="background-color: #2f4e66"> <td colspan="3" align="right" style="padding-top: 7px; padding-right: 20px; padding-bottom: 7px; padding-left: 0px"> <font size="3" face="sans-serif" color="#ffffff">Generated At &lt;TIME&gt; </font> </td> </tr> </table> </center> </td> </tr> </table> </div>'
	ELSE
		set @htmldefaultTemplateForDRCSRunningAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><table border="1" align="center" style="border-bottom-color: #dedede; border-top-width: 0px; border-left-color: #dedede; border-bottom-width: 0px; border-bottom-style: solid; border-left-width: 0px; border-top-color: #dedede; border-top-style: solid; border-right-style: solid; border-right-color: #dedede; border-right-width: 0px; border-left-style: solid" cellspacing="0" cellpadding="0" width="600"> <tr> <td> <center> <table border="0" align="center" cellspacing="0" id="contentTbl" cellpadding="0" width="600"> <tr style="background-color: #666666"> <td align="left" colspan="1" valign="middle"> <div style="margin-bottom: 4px; margin-top: 4px; margin-left: 10px"> <font color="#EEEEEE" size="6" face="Helvetica,sans-serif">&lt;ALERT NAME&gt; </font> </div> </td> <td align="right" colspan="1" valign="middle"> <div style="margin-bottom: 4px; margin-top: 4px; margin-left: 40px"> <font color="#EEEEEE" size="3" face="Helvetica,sans-serif">&lt;TIME&gt; </font> </div> </td> </tr> <tr> <td align="left" colspan="2" bgcolor="#DCDEDE" valign="middle"> <ul style="margin-bottom: 4px; margin-top: 4px"> <font size="4" face="Helvetica,sans-serif"><strong>CommCell: </strong></font><strong><font color="#660000" size="4" face="Helvetica,sans-serif">&lt;COMMCELL NAME&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font size="4" face="Helvetica,sans-serif"><strong>Type: </strong></font><strong><font color="#660000" size="4" face="Helvetica,sans-serif">&lt;ALERT CATEGORY - ALERT TYPE&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font size="4" face="Helvetica,sans-serif"><strong>Detected Criteria: </strong></font><strong><font color="#660000" size="4" face="Helvetica,sans-serif">&lt;DETECTED CRITERIA&gt;</font></strong> </ul> </td> </tr> <tr> <td align="left" colspan="2" width="100%"> <ul> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" size="3" face="Helvetica,sans-serif">Event ID: &lt;EVENT ID&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" size="3" face="Helvetica,sans-serif">Monitoring Criteria: &lt;MONITORING CRITERIA STRING&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" size="3" face="Helvetica,sans-serif">Severity: &lt;EVENT SEVERITY&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" size="3" face="Helvetica,sans-serif">Job ID: &lt;JOB ID&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" size="3" face="Helvetica,sans-serif">Event Date: &lt;EVENT DATE&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" size="3" face="Helvetica,sans-serif">Program: &lt;EVENT PROGRAM&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" size="3" face="Helvetica,sans-serif">Client: &lt;CLIENT NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" size="3" face="Helvetica,sans-serif">Description: &lt;DESCRIPTION&gt; </font> </li> </ul> </td> </tr> <tr style="background-color: #666666"> <td align="left" colspan="2">   </td> </tr> </table> </center> </td> </tr> </table>'
	set @textdefaultTemplateForDRCSRunningAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END> MsgNewLine_ Alert: <ALERT NAME> MsgNewLine_ Type: <ALERT CATEGORY - ALERT TYPE> MsgNewLine_MsgTab_ Detected Criteria: <DETECTED CRITERIA> MsgNewLine_MsgTab_ Detected Time: <TIME> MsgNewLine_MsgTab_ CommCell: <COMMCELL NAME> MsgNewLine_ MsgNewLine_ MsgTab_ Event ID: <EVENT ID> MsgNewLine_MsgTab_ Monitoring Criteria: <MONITORING CRITERIA STRING> MsgNewLine_MsgTab_ Severity: <EVENT SEVERITY> MsgNewLine_MsgTab_ Job ID: <JOB ID> MsgNewLine_MsgTab_ Event Date: <EVENT DATE> MsgNewLine_MsgTab_ Program: <EVENT PROGRAM> MsgNewLine_MsgTab_ Client: <CLIENT NAME> MsgNewLine_MsgTab_ Description: <DESCRIPTION> MsgNewLine_MsgTab_'
	Insert into @alertsToAdd
	select @createdAlertsId,
58,
'Disaster Recovery CommServer Alert',
              'Default alert for Disaster Recovery CommServer Running',
              @textdefaultTemplateForDRCSRunningAlert,
              @htmldefaultTemplateForDRCSRunningAlert,
			  1,
              @allClientXmlEntities
	Insert into @criteriasToAdd
select @createdAlertsId,62,NULL,NULL,NULL
	declare @eventCriteriaXml nvarchar(max)
	set @eventCriteriaXml = '<?xml version=''1.0'' encoding=''UTF-8''?><LogMonitoring_ConditionsList criteriaName="(Event Code equals to 32:416)" opBetweenConditions="0"><conditions operation="0" value1="32:416" value2="" isregex="1" isCaseSensitive="0" isInclusive="0" matchWholeWord="0"><column _type_="87" columnId="6" columnName="Event Code" /></conditions></LogMonitoring_ConditionsList>'
	IF ( CURSOR_STATUS('global', 'newDefaultAlertsCursor') >= 0   OR CURSOR_STATUS('local', 'newDefaultAlertsCursor') >= 0 )  -- CLOSE CURSOR IF OPEN
		CLOSE newDefaultAlertsCursor
	IF ( CURSOR_STATUS('global','newDefaultAlertsCursor') = -1     OR CURSOR_STATUS('local','newDefaultAlertsCursor') = -1 )
		DEALLOCATE newDefaultAlertsCursor
	DECLARE newDefaultAlertsCursor CURSOR FOR
		SELECT  alertId, alertType, notificationName, description, msgFmtText, msgFmtHtml , isAlertEnabled, XmlEntities
		   FROM @alertsToAdd
	OPEN newDefaultAlertsCursor
		FETCH NEXT FROM newDefaultAlertsCursor INTO @alertId,@alertType, @notificationName, @description, @msgFmtText, @msgFmtHtml,@isAlertEnabled,@cursorXmlEntities
		WHILE @@FETCH_STATUS = 0
		BEGIN
		-- Check whether this alert is already present. If so, dont insert again.
		if exists(select 1 from NTNotificationRule
			where notificationName=@notificationName and revision=1
		)
		begin
			FETCH NEXT FROM newDefaultAlertsCursor INTO @alertId,@alertType, @notificationName, @description, @msgFmtText, @msgFmtHtml,@isAlertEnabled,@cursorXmlEntities
			continue
		end
		INSERT NTNotificationRule (	categoryId,				alertTypeId,
									notificationName,		revision,
									lastModified,			description,
									notifType,				notifOwner,
									locale,					status,
									ruleState,				ruleState2,
									lastTimeTriggered,		lastTimeTriggered2,
									lastTimeChecked,		hasAttachments,
									hasAttachments2,		xmlEntityList,
									origCCId,				GUID)
		select						categoryId,				@alertType,
									@notificationName,		1,
									@nowTime,				@description,
									@notifType,				@adminID,
									0,
case @isAlertEnabled when 1 then  2048 else 1 | 2048 end,
								        -- 1 DefaultLocale US-English .. Create  default alerts in disabled state
									-- 2048 for for specifying the alert is systam generated.
									@ruleState,				@ruleState,
									@emptyDateTime,			@emptyDateTime,
									@emptyDateTime,			0,
									0,						@cursorXmlEntities ,
									2,				newid()
				from NTAlerttype where id = @alertType
		SET @thisAlertId = @@Identity
		INSERT NTSelCriteria(availCriteriaid, esclationLevel, ruleId, reportingOptions, delayTimeSeconds, persistTimeSeconds)
		select criteriaId,1,@thisAlertId,0,0,0
		from @criteriasToAdd
		where alertId = @alertId
		SET @SelCriteriaId = @@identity
		if exists(select 1 from @criteriasToAdd where alertId = @alertId and criteriaParamType is not null and
			criteriaParamValue is not null and criteriaParamUnit is not null)
		begin
			INSERT NTSelCriteriaParams (selCriteriaid, paramIndex, type, value, unit, occurrences)
			select id,0,criteriaParamType,criteriaParamValue,criteriaParamUnit,0
			from NTSelcriteria , @criteriasToAdd newCriterias
			where NTSelcriteria.ruleid = @thisAlertId
			and newCriterias.alertId = @alertId
			and newCriterias.criteriaParamType is not null and
			newCriterias.criteriaParamValue is not null and newCriterias.criteriaParamUnit is not null
		end
		UPDATE NtSelCrit SET NtSelCrit.reportingOptions=RO.reportingOptions
		FROM NtSelCriteria NtSelCrit
		INNER JOIN @reportingOption RO
		ON RO.alertId= @alertId AND NtSelCrit.ruleId=@thisAlertId
	INSERT INTO NTmessages (NTnotificationID, escalationLevel, lastSetMessageTime, firstDetectTime, NTmessageState)
		VALUES (@thisAlertId, 1, null, null, 0)
	INSERT INTO NTmessages (NTnotificationID, escalationLevel, lastSetMessageTime, firstDetectTime, NTmessageState)
		VALUES (@thisAlertId, 2, null, null, 0)
-- ADD DEFAULT (EMAIL) MESSAGE:
									 --
		INSERT NTmessageFormat (NTnotificationID,messageType,escalationLevel,formatString,formattedMessage,
							SubjFieldStart,SubjFieldLen,MsgBodyStart,MsgBodyLen,mfOptions,
							baseDir,userName,password, rssID, messageFormatType, formatStringHtml)
			VALUES		(@thisAlertId, 1, 1, @msgFmtText, N'',
0, 0, 0, 0, 2,
						 '', '', '', '', 1, @msgFmtHtml)
		Insert into NTnotificationGroups(NtnotificationId,groupId,escalationLevel)
		select @thisAlertId,@masterGroupId,1
		 -- Add an entry into for "Simpana Event Log Monitoring" AlertType if criteria is present
        if (@alertType=58)
        begin
                declare @templateId int
                -- Only one template for Simpana events. Hence retrieve the template id and store it here.
                select @templateId = templateId
                from
                APP_Template where templateForMonitoringType = 3
IF (@notificationName = 'No recent DDB backup')
				BEGIN
					Insert into dbo.NTSimpanaEventCriteria(commcellId,notifRuleId,templateId,criteriaXML,severity)
					select 2,@thisAlertId,@templateId,@eventCriteriaXml,0
				END
ELSE IF (@notificationName = 'Disaster Recovery CommServer Alert')
				BEGIN
					Insert into dbo.NTSimpanaEventCriteria(commcellId,notifRuleId,templateId,criteriaXML,severity)
					select 2,@thisAlertId,@templateId,
						'<?xml version=''1.0'' encoding=''UTF-8''?><LogMonitoring_ConditionsList criteriaName="(Event Code equals to 19:2008)" opBetweenConditions="0"><conditions operation="0" value1="19:2008" value2="" isregex="1" isCaseSensitive="0" isInclusive="0" matchWholeWord="0"><column _type_="87" columnId="6" columnName="Event Code" /></conditions></LogMonitoring_ConditionsList>',
						0
				END
        end
		FETCH NEXT FROM newDefaultAlertsCursor INTO @alertId,@alertType, @notificationName, @description, @msgFmtText, @msgFmtHtml,@isAlertEnabled,@cursorXmlEntities
	END
END TRY
 BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
     set @errorCode = ERROR_NUMBER()
     set @errorString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
 END CATCH
 	IF ( CURSOR_STATUS('global', 'newDefaultAlertsCursor') >= 0   OR CURSOR_STATUS('local', 'newDefaultAlertsCursor') >= 0 )  -- CLOSE CURSOR IF OPEN
		CLOSE newDefaultAlertsCursor
	IF ( CURSOR_STATUS('global','newDefaultAlertsCursor') = -1     OR CURSOR_STATUS('local','newDefaultAlertsCursor') = -1 )
		DEALLOCATE newDefaultAlertsCursor
IF @errorCode = 0
	COMMIT TRAN
ELSE
	ROLLBACK TRAN
SELECT @errorCode, @errorString
GO

IF EXISTS (select * from GxQscripts where name = 'br_ntPopulateDefaultAlerts')
	delete from GxQscripts where name = 'br_ntPopulateDefaultAlerts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_ntPopulateDefaultAlerts')
	delete from GXDBVersions where aliasname = 'br_ntPopulateDefaultAlerts'
GO

insert into GXDBVersions values(2, 'br_ntPopulateDefaultAlerts',  '00000000000000000000', 'br_ntPopulateDefaultAlerts', '00000000000000000000')
GO

