

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/br_ntPopulateCIAlerts.sp] ---------- 

-- ALLOW_COMMENTS_BELOW_HERE:
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/br_ntPopulateCIAlerts.sp,v $ $Id: br_ntPopulateCIAlerts.sp,v 1.12.14.3 2017/02/10 21:21:45 sjohnson Exp $";
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: br_ntPopulateCIAlerts <<<'

IF EXISTS (select * from sysobjects where name='br_ntPopulateCIAlerts')
	drop procedure br_ntPopulateCIAlerts
IF EXISTS (select * from GxQscripts where name='br_ntPopulateCIAlerts')
	delete from GxQscripts where name = 'br_ntPopulateCIAlerts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_ntPopulateCIAlerts')
	delete from GXDBVersions where aliasname = 'br_ntPopulateCIAlerts'
GO
print '... Creating Procedure: br_ntPopulateCIAlerts'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure br_ntPopulateCIAlerts
--	+-------------------------------+
--	| PARAMETERS   &   OUTPUTS		|
--	+-------------------------------+
  @errorCode integer         OUTPUT,
  @errorString varchar(1024)   OUTPUT
AS
if exists(select 1 from GxGlobalParam
	   where name='PopulateCIAlerts')
begin
	print 'CI alerts have already been created. So not creating'
	SELECT @errorCode, @errorString
	return
end
Insert into GxGlobalParam
select 'PopulateCIAlerts','1',DATEDIFF(s, '1970-01-01 00:00:00', GETUTCDATE()),0
DECLARE @nowTime			as integer	= dbo.GetUnixTime (GetUTCdate())
DECLARE @xmlEntities		AS nvarchar(MAX)= '<CVGui_CommCellTreeNode xmlns:xsi="http:--www.w3.org/2001/XMLSchema-instance" xsi:noNamespaceSchemaLocation="CVGui_CommCellTreeNodeType.xsd"><trackingSchedules /><trackingJobs /><associations _type_="2" clientGroupId="0" clientGroupName="" clientId="0" clientName="" applicationId="0" appName="" instanceId="0" instanceName="" backupsetId="0" backupsetName="" subclientId="0" subclientName="" mediaAgentId="0" mediaAgentName="" schedulePolicyId="0" schedulePolicyName="" libraryId="0" libraryName="" storagePolicyId="0" storagePolicyName="" copyId="0" copyName="" trackingPolicyId="0" trackingPolicyName="" workflowId="0" workflowName="" policyId="0" policyName="" criteriaId="0" criteriaName="" /></CVGui_CommCellTreeNode>'
DECLARE	@emptyDateTime		AS datetime	= '1900-01-01 00:00:00.000'
DECLARE @localeId			AS integer		= 1
DECLARE @status				AS integer		= 0
DECLARE	@ruleState			AS integer		= 0
DECLARE	@reportOptions		AS integer		= 1		-- 'NT_REPORT_IMMEDIATE'
DECLARE	@categoryId			as integer 		= 8				-- 'NT_CATEGORY_OPERATION_MANAGEMENT'
DECLARE @adminID			as integer		= ISNULL((Select top 1 ID from UMUSERS where (flags & 67) = 67 AND Name <> 'ROMS'), 1)
DECLARE @notifType			AS integer		= (1	+ 8192)
DECLARE @SelCriteriaId		integer
DECLARE @thisCriteria		int
--
DECLARE @alertType			INTEGER
DECLARE @categoryType		INTEGER
DECLARE @notificationName	NVARCHAR(128)			-- 'NT_MAX_NOTIFICATION_NAME_SIZE'
DECLARE @description		NVARCHAR(1024)			-- 'NT_MAX_ALERT_DESCRIPTION_SIZE'
DECLARE @msgFmtText			NVARCHAR(max)
DECLARE @msgFmtHtml 		NVARCHAR(max)
DECLARE @alertsToAdd table (
		alertType			int Not Null,
		categoryType			int,
notificationName	nvarchar(128),
description			nvarchar(1024),
		msgFmtText			nvarchar(max),
		msgFmtHtml			nvarchar(max)
)
--
DECLARE	@thisAlertId		integer
DECLARE @NTAlertCIEntries	INT
SET @errorCode	= 0
SET @errorString= ''
SET @NTAlertCIEntries = 0
BEGIN TRY
IF (@@TRANCOUNT = 0)
BEGIN
         BEGIN TRANSACTION NTAlertCIEntries
         SET @NTAlertCIEntries = 1
END
	INSERT @alertsToAdd VALUES(
58,
			1,
			'Content Indexing - Document Count Alert',
			'Content Indexing alert for document count',
			'<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END> MsgNewLine_ Alert: <ALERT NAME> MsgNewLine_ Type: <ALERT CATEGORY - ALERT TYPE> MsgNewLine_MsgTab_ Detected Criteria: <DETECTED CRITERIA> MsgNewLine_MsgTab_ Detected Time: <TIME> MsgNewLine_MsgTab_ CommCell: <COMMCELL NAME> MsgNewLine_MsgTab_ User: admin MsgNewLine_ MsgNewLine_ MsgTab_ Event ID: <EVENT ID> MsgNewLine_MsgTab_ Monitoring Criteria: <MONITORING CRITERIA STRING> MsgNewLine_MsgTab_ Severity: <EVENT SEVERITY> MsgNewLine_MsgTab_ Job ID: N\A MsgNewLine_MsgTab_ Event Date: <EVENT DATE> MsgNewLine_MsgTab_ Program: <EVENT PROGRAM> MsgNewLine_MsgTab_ Client: <CLIENT NAME> MsgNewLine_MsgTab_ Description: <DESCRIPTION> MsgNewLine_MsgTab_',
			'<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><p><font color="#0000ff" size="5"><b>Alert: &lt;ALERT NAME&gt; </b></font></p><ul><li><font color="#000000" size="4"><b>Type: </b></font><b><font color="#990033" size="4">&lt;ALERT CATEGORY - ALERT TYPE&gt; </font></b></li><li><font color="#000000" size="4"><b>Detected Criteria: </b></font><b><font color="#990033" size="4">&lt;DETECTED CRITERIA&gt; </font></b></li><li><font color="#000000" size="4"><b>Detected Time: </b></font><b><font color="#990033" size="4">&lt;TIME&gt; </font></b></li></ul><ul><li>CommCell: &lt;COMMCELL NAME&gt;</li><li>User: admin</li><li>Event ID: &lt;EVENT ID&gt;</li><li>Monitoring Criteria: &lt;MONITORING CRITERIA STRING&gt;</li><li>Severity: &lt;EVENT SEVERITY&gt;</li><li>Job ID: N\A</li><li>Event Date: &lt;EVENT DATE&gt;</li><li>Program: &lt;EVENT PROGRAM&gt;</li><li>Client: &lt;CLIENT NAME&gt;</li><li>Description: &lt;DESCRIPTION&gt;</li></ul>'
			)
	INSERT @alertsToAdd VALUES(
58,
			2,
			'Content Indexing - Low Disk Space',
			'Content Indexing alert for low disk threshold space',
			'<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END> MsgNewLine_ Alert: <ALERT NAME> MsgNewLine_ Type: <ALERT CATEGORY - ALERT TYPE> MsgNewLine_MsgTab_ Detected Criteria: <DETECTED CRITERIA> MsgNewLine_MsgTab_ Detected Time: <TIME> MsgNewLine_MsgTab_ CommCell: <COMMCELL NAME> MsgNewLine_MsgTab_ User: admin MsgNewLine_ MsgNewLine_ MsgTab_ Event ID: <EVENT ID> MsgNewLine_MsgTab_ Monitoring Criteria: <MONITORING CRITERIA STRING> MsgNewLine_MsgTab_ Severity: <EVENT SEVERITY> MsgNewLine_MsgTab_ Job ID: N\A MsgNewLine_MsgTab_ Event Date: <EVENT DATE> MsgNewLine_MsgTab_ Program: <EVENT PROGRAM> MsgNewLine_MsgTab_ Client: <CLIENT NAME> MsgNewLine_MsgTab_ Description: <DESCRIPTION> MsgNewLine_MsgTab_',
			'<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><p><font color="#0000ff" size="5"><b>Alert: &lt;ALERT NAME&gt; </b></font></p><ul><li><font color="#000000" size="4"><b>Type: </b></font><b><font color="#990033" size="4">&lt;ALERT CATEGORY - ALERT TYPE&gt; </font></b></li><li><font color="#000000" size="4"><b>Detected Criteria: </b></font><b><font color="#990033" size="4">&lt;DETECTED CRITERIA&gt; </font></b></li><li><font color="#000000" size="4"><b>Detected Time: </b></font><b><font color="#990033" size="4">&lt;TIME&gt; </font></b></li></ul><ul><li>CommCell: &lt;COMMCELL NAME&gt;</li><li>User: admin</li><li>Event ID: &lt;EVENT ID&gt;</li><li>Monitoring Criteria: &lt;MONITORING CRITERIA STRING&gt;</li><li>Severity: &lt;EVENT SEVERITY&gt;</li><li>Job ID: N\A</li><li>Event Date: &lt;EVENT DATE&gt;</li><li>Program: &lt;EVENT PROGRAM&gt;</li><li>Client: &lt;CLIENT NAME&gt;</li><li>Description: &lt;DESCRIPTION&gt;</li></ul>'
			)
	INSERT @alertsToAdd VALUES(
58,
			3,
			'Analytics - Low Disk Space',
			'Analytics alert for low disk space',
			'<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END> MsgNewLine_ Alert: <ALERT NAME> MsgNewLine_ Type: <ALERT CATEGORY - ALERT TYPE> MsgNewLine_MsgTab_ Detected Criteria: <DETECTED CRITERIA> MsgNewLine_MsgTab_ Detected Time: <TIME> MsgNewLine_MsgTab_ CommCell: <COMMCELL NAME> MsgNewLine_MsgTab_ User: admin MsgNewLine_ MsgNewLine_ MsgTab_ Event ID: <EVENT ID> MsgNewLine_MsgTab_ Monitoring Criteria: <MONITORING CRITERIA STRING> MsgNewLine_MsgTab_ Severity: <EVENT SEVERITY> MsgNewLine_MsgTab_ Job ID: N\A MsgNewLine_MsgTab_ Event Date: <EVENT DATE> MsgNewLine_MsgTab_ Program: <EVENT PROGRAM> MsgNewLine_MsgTab_ Client: <CLIENT NAME> MsgNewLine_MsgTab_ Description: <DESCRIPTION> MsgNewLine_MsgTab_',
			'<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><p><font color="#0000ff" size="5"><b>Alert: &lt;ALERT NAME&gt; </b></font></p><ul><li><font color="#000000" size="4"><b>Type: </b></font><b><font color="#990033" size="4">&lt;ALERT CATEGORY - ALERT TYPE&gt; </font></b></li><li><font color="#000000" size="4"><b>Detected Criteria: </b></font><b><font color="#990033" size="4">&lt;DETECTED CRITERIA&gt; </font></b></li><li><font color="#000000" size="4"><b>Detected Time: </b></font><b><font color="#990033" size="4">&lt;TIME&gt; </font></b></li></ul><ul><li>CommCell: &lt;COMMCELL NAME&gt;</li><li>User: admin</li><li>Event ID: &lt;EVENT ID&gt;</li><li>Monitoring Criteria: &lt;MONITORING CRITERIA STRING&gt;</li><li>Severity: &lt;EVENT SEVERITY&gt;</li><li>Job ID: N\A</li><li>Event Date: &lt;EVENT DATE&gt;</li><li>Program: &lt;EVENT PROGRAM&gt;</li><li>Client: &lt;CLIENT NAME&gt;</li><li>Description: &lt;DESCRIPTION&gt;</li></ul>'
			)
	-- check if cursor exists
	IF ( CURSOR_STATUS('global', 'newCIAlertsCursor') >= 0   OR CURSOR_STATUS('local', 'newCIAlertsCursor') >= 0 )  -- CLOSE CURSOR IF OPEN
		CLOSE newCIAlertsCursor
	IF ( CURSOR_STATUS('global','newCIAlertsCursor') = -1     OR CURSOR_STATUS('local','newCIAlertsCursor') = -1 )
		DEALLOCATE newCIAlertsCursor
	DECLARE newCIAlertsCursor CURSOR STATIC FOR
		SELECT  alertType, categoryType, notificationName, description, msgFmtText, msgFmtHtml
		   FROM @alertsToAdd
	OPEN newCIAlertsCursor
		FETCH NEXT FROM newCIAlertsCursor INTO @alertType, @categoryType, @notificationName, @description, @msgFmtText, @msgFmtHtml
		WHILE @@FETCH_STATUS = 0
		BEGIN
		IF NOT EXISTS(SELECT * FROM NTNotificationRule where alertTypeId = @alertType AND notificationName = @notificationName AND categoryId =@categoryId)
		BEGIN
			INSERT NTNotificationRule (	categoryId,				alertTypeId,
									notificationName,		revision,
									lastModified,			description,
									notifType,				notifOwner,
									locale,					status,
									ruleState,				ruleState2,
									lastTimeTriggered,		lastTimeTriggered2,
									lastTimeChecked,		hasAttachments,
									hasAttachments2,		xmlEntityList,
									origCCId,				GUID)
			VALUES (					@categoryId,			@alertType,
									@notificationName,		1,
									@nowTime,				@description,
									@notifType,				@adminID,
0,					(@status | 2048),
								        -- 1 DefaultLocale US-English .. Create  default alerts in disabled state
									-- 2048 for for specifying the alert is systam generated.
									@ruleState,				@ruleState,
									@emptyDateTime,			@emptyDateTime,
									@emptyDateTime,			0,
									0,						@xmlEntities,
									default,				newid() )
			SET @thisAlertId = @@Identity
	--		ADD CRITERIA:
			INSERT NTSelCriteria(availCriteriaid, esclationLevel, ruleId, reportingOptions, delayTimeSeconds, persistTimeSeconds)
			VALUES(62, 1, @thisAlertId, @reportOptions, 0, 0 )		-- 'NT_EVENT_MONITORING'
			IF @categoryType = 1
			BEGIN
				INSERT INTO NTSimpanaEventCriteria
				VALUES( 2,	@thisAlertId,	4, '<?xml version="1.0" encoding="UTF-8"?><LogMonitoring_ConditionsList criteriaName="(Event Code equals to 35:2076) AND (Locale equals to English)" opBetweenConditions="0"><conditions operation="0" value1="35:2076" value2="" isregex="0" isCaseSensitive="0" isInclusive="0" matchWholeWord="0"><column _type_="87" columnId="6" columnName="Event Code" /></conditions><conditions operation="0" value1="&lt;?xml version=''1.0'' encoding=''UTF-8''?>&lt;LogMonitoring_IntegersList>&lt;valuesList val=&quot;0&quot; />&lt;/LogMonitoring_IntegersList>" value2="" isregex="0" isCaseSensitive="0" isInclusive="0" matchWholeWord="0"><column _type_="87" columnId="8" columnName="Locale" /></conditions></LogMonitoring_ConditionsList>',	0)
			END
			IF @categoryType = 2
			BEGIN
				INSERT INTO NTSimpanaEventCriteria
				VALUES( 2,	@thisAlertId,	4, '<?xml version="1.0" encoding="UTF-8"?><LogMonitoring_ConditionsList criteriaName="(Event Code equals to 72:102) AND (Locale equals to English)" opBetweenConditions="0"><conditions operation="0" value1="72:102" value2="" isregex="0" isCaseSensitive="0" isInclusive="0" matchWholeWord="0"><column _type_="87" columnId="6" columnName="Event Code" /></conditions><conditions operation="0" value1="&lt;?xml version=''1.0'' encoding=''UTF-8''?>&lt;LogMonitoring_IntegersList>&lt;valuesList val=&quot;0&quot; />&lt;/LogMonitoring_IntegersList>" value2="" isregex="0" isCaseSensitive="0" isInclusive="0" matchWholeWord="0"><column _type_="87" columnId="8" columnName="Locale" /></conditions></LogMonitoring_ConditionsList>',	0)
			END
			IF @categoryType = 3
			BEGIN
				INSERT INTO NTSimpanaEventCriteria
				VALUES( 2,	@thisAlertId,	4, '<?xml version="1.0" encoding="UTF-8"?><LogMonitoring_ConditionsList criteriaName="(Event Code equals to 72:152|72:154) AND (Locale equals to English)" opBetweenConditions="0"><conditions operation="0" value1="72:152|72:154" value2="" isregex="1" isCaseSensitive="0" isInclusive="0" matchWholeWord="0"><column _type_="87" columnId="6" columnName="Event Code" /></conditions><conditions operation="0" value1="&lt;?xml version=''1.0'' encoding=''UTF-8''?>&lt;LogMonitoring_IntegersList>&lt;valuesList val=&quot;0&quot; />&lt;/LogMonitoring_IntegersList>" value2="" isregex="1" isCaseSensitive="0" isInclusive="0" matchWholeWord="0"><column _type_="87" columnId="8" columnName="Locale" /></conditions></LogMonitoring_ConditionsList>',	0)
			END
-- ADD DEFAULT (EMAIL) MESSAGE:
			--		ADD DEFAULT (EMAIL) MESSAGE:
			INSERT NTmessageFormat (NTnotificationID,messageType,escalationLevel,formatString,formattedMessage,
							SubjFieldStart,SubjFieldLen,MsgBodyStart,MsgBodyLen,mfOptions,
							baseDir,userName,password, rssID, messageFormatType, formatStringHtml)
			VALUES		(@thisAlertId, 16, 1, '', N'',
               			 0, 0, 0, 0, 0,
						 '', '', '', '', 0, '')
			INSERT NTmessageFormat (NTnotificationID,messageType,escalationLevel,formatString,formattedMessage,
								SubjFieldStart,SubjFieldLen,MsgBodyStart,MsgBodyLen,mfOptions,
								baseDir,userName,password, rssID, messageFormatType, formatStringHtml)
				VALUES		(@thisAlertId, 1, 1, @msgFmtText, N'',
               				 0, 0, 0, 0, 0,
							 '', '', '', '', 1, @msgFmtHtml)
			INSERT NTmessageFormat (NTnotificationID,messageType,escalationLevel,formatString,formattedMessage,
								SubjFieldStart,SubjFieldLen,MsgBodyStart,MsgBodyLen,mfOptions,
								baseDir,userName,password, rssID, messageFormatType, formatStringHtml)
				VALUES		(@thisAlertId, 8192, 1, @msgFmtText, N'',
               				 0, 0, 0, 0, 0,
							 '', '', '', '', 1, @msgFmtHtml)
-- ADD DEFAULT USER (SHOULDN'T HAVE TO DO THIS, BUT REQ'D TO SUPPORT CURRENT ALERT GUI)
			INSERT NTnotificationUsers  (NTnotificationID, userId,    escalationLevel)
			VALUES (@thisAlertId, @adminID, 1)
		END
		ELSE
		BEGIN
				--update event id
			IF @categoryType = 1
			BEGIN
				UPDATE NTSimpanaEventCriteria
				SET  criteriaXML = '<?xml version="1.0" encoding="UTF-8"?><LogMonitoring_ConditionsList criteriaName="(Event Code equals to 35:2076) AND (Locale equals to English)" opBetweenConditions="0"><conditions operation="0" value1="35:2076" value2="" isregex="0" isCaseSensitive="0" isInclusive="0" matchWholeWord="0"><column _type_="87" columnId="6" columnName="Event Code" /></conditions><conditions operation="0" value1="&lt;?xml version=''1.0'' encoding=''UTF-8''?>&lt;LogMonitoring_IntegersList>&lt;valuesList val=&quot;0&quot; />&lt;/LogMonitoring_IntegersList>" value2="" isregex="0" isCaseSensitive="0" isInclusive="0" matchWholeWord="0"><column _type_="87" columnId="8" columnName="Locale" /></conditions></LogMonitoring_ConditionsList>'
				WHERE notifRuleId IN (select id from ntnotificationRule where notificationName = 'Content Indexing - Document Count Alert')
			END
			--update event id
			IF @categoryType = 3
			BEGIN
				UPDATE NTSimpanaEventCriteria
				SET  criteriaXML = '<?xml version="1.0" encoding="UTF-8"?><LogMonitoring_ConditionsList criteriaName="(Event Code equals to 72:152|72:154) AND (Locale equals to English)" opBetweenConditions="0"><conditions operation="0" value1="72:152|72:154" value2="" isregex="1" isCaseSensitive="0" isInclusive="0" matchWholeWord="0"><column _type_="87" columnId="6" columnName="Event Code" /></conditions><conditions operation="0" value1="&lt;?xml version=''1.0'' encoding=''UTF-8''?>&lt;LogMonitoring_IntegersList>&lt;valuesList val=&quot;0&quot; />&lt;/LogMonitoring_IntegersList>" value2="" isregex="1" isCaseSensitive="0" isInclusive="0" matchWholeWord="0"><column _type_="87" columnId="8" columnName="Locale" /></conditions></LogMonitoring_ConditionsList>'
				WHERE notifRuleId IN (select id from ntnotificationRule where notificationName = 'Analytics - Low Disk Space')
			END
		END
		FETCH NEXT FROM newCIAlertsCursor INTO @alertType, @categoryType, @notificationName, @description, @msgFmtText, @msgFmtHtml
	END
CLOSE newCIAlertsCursor
DEALLOCATE newCIAlertsCursor
END TRY
 BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
     set @errorCode = ERROR_NUMBER()
     set @errorString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
 END CATCH
 IF ( CURSOR_STATUS('global', 'newCIAlertsCursor') >= 0   OR CURSOR_STATUS('local', 'newCIAlertsCursor') >= 0 )  -- CLOSE CURSOR IF OPEN
		CLOSE newCIAlertsCursor
 IF ( CURSOR_STATUS('global','newCIAlertsCursor') = -1     OR CURSOR_STATUS('local','newCIAlertsCursor') = -1 )
		DEALLOCATE newCIAlertsCursor
IF @errorCode = 0
	 IF (@NTAlertCIEntries = 1)
     BEGIN
		COMMIT TRANSACTION NTAlertCIEntries
        SET @NTAlertCIEntries = 0
     END
ELSE
	IF (@NTAlertCIEntries = 1)
     BEGIN
		ROLLBACK TRANSACTION NTAlertCIEntries
        SET @NTAlertCIEntries = 0
     END
SELECT @errorCode, @errorString
GO
/*  FOR DEBUGGING:
DECLARE @errCode as int = 0
DECLARE @errString varchar(1024)
exec br_ntPopulateCIAlerts @errCode output, @errString output
select @errCode, @errString
select id, notificationName, status, xmlEntityList from ntnotificationRule where notificationName LIKE 'Content Indexing%'-- CI document count Alert
SELECT * from NTmessageFormat where NTnotificationId in (select id from ntnotificationRule where notificationName LIKE 'Content Indexing%') --message format
SELECT * from NTSimpanaEventCriteria where notifRuleId in (select id from ntnotificationRule where notificationName LIKE 'Content Indexing%') --event criteria
*/

IF EXISTS (select * from GxQscripts where name = 'br_ntPopulateCIAlerts')
	delete from GxQscripts where name = 'br_ntPopulateCIAlerts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_ntPopulateCIAlerts')
	delete from GXDBVersions where aliasname = 'br_ntPopulateCIAlerts'
GO

insert into GXDBVersions values(2, 'br_ntPopulateCIAlerts',  '00010012001400030000', 'br_ntPopulateCIAlerts', '00010012001400030000')
GO

