

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/br_ntPopulateAlertTemplateV2.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/br_ntPopulateAlertTemplateV2.sp,v $ $Id: br_ntPopulateAlertTemplateV2.sp,v 1.1.2.14 2020/12/18 06:13:09 vthakur Exp $";
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +========================================================================+
--  |   Procedure:  br_ntpopulatealerttemplateV2()
--  |
--  | Description:  Insert the new alert template msg
--  |
--  +========================================================================+
--
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='br_ntpopulatealerttemplateV2')
BEGIN
	print '>>> Drop Stored Procedure: br_ntpopulatealerttemplateV2 <<<'
	drop procedure br_ntpopulatealerttemplateV2
END
IF EXISTS (select * from GxQscripts where name='br_ntpopulatealerttemplateV2')
	delete from GxQscripts where name = 'br_ntpopulatealerttemplateV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_ntpopulatealerttemplateV2')
	delete from GXDBVersions where aliasname = 'br_ntpopulatealerttemplateV2'
GO
print '... Creating Procedure: br_ntpopulatealerttemplateV2'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure br_ntpopulatealerttemplateV2
--	+-------------------------------+
--	| PARAMETERS   &   OUTPUTS		|
--	+-------------------------------+
AS
DECLARE @templateCustomised INT = ISNULL((SELECT value FROM GXGlobalParam  with (nolock) WHERE name='AlertTemplatesCustomized' and modified=0),0)
DECLARE @isJson INT = 1
IF EXISTS (SELECT 1 FROM GxGlobalParam with(nolock) WHERE name = 'bEnableJsonConsoleAlert' AND value = 'false' AND modified = 0)
	SET @isJson = 0
DECLARE @STD_EMAIL_PREAMBLE			nvarchar(MAX)
DECLARE @STD_EMAIL_PREAMBLE_OM		nvarchar(MAX)
DECLARE @STD_EMAIL_PREAMBLE_CSFAILOVER		nvarchar(MAX)
DECLARE @STD_LM_PREAMBLE_HTML		nvarchar(MAX)
DECLARE @STD_LM_PREAMBLE			nvarchar(MAX)
DECLARE @common_Html_Preamble		nvarchar(MAX)
DECLARE @common_Html_Postamble		nvarchar(MAX)
DECLARE @STD_EMAIL_PREAMBL_HTML	    nvarchar(MAX)
declare @STD_LIVEFEED_PREAMBLE_HTML	nvarchar(max)
DECLARE @STD_EMAIL_PREAMBL_HTML_OM  nvarchar(MAX)
DECLARE @STD_EMAIL_PREAMBLE_HTML_CSFAILOVER   nvarchar(MAX)
DECLARE @STD_PAGER_PREAMBLE			nvarchar(MAX)
declare @STD_PAGER_PREAMBLE_CUSTOM_ALERT nvarchar(max)
DECLARE @STD_SRM_PREAMBLE			nvarchar(MAX)
DECLARE @STD_SRM_PREAMBLE_PAGER		nvarchar(MAX)
DECLARE @STD_CUSTOM_ALERTS_EMAIL_PREAMBLE		nvarchar(MAX)
DECLARE @STD_JSON_PREAMBLE			nvarchar(MAX)
DECLARE @STD_DBSPACE_PREAMBLE		nvarchar(MAX)
DECLARE @FORMAT_JSON				nvarchar(MAX)
DECLARE @FORMAT_EMAIL				nvarchar(MAX)
DECLARE @FORMAT_EMAIL_LM_VARIABLE_BODY	nvarchar(MAX)
DECLARE @FORMAT_EMAIL_HTML			nvarchar(MAX)
DECLARE @FORMAT_PAGER				nvarchar(MAX)
DECLARE @FORMAT						nvarchar(MAX)
DECLARE @STD_POSTAMBLE				nvarchar(MAX)
DECLARE @STD_POSTAMBLE_HTML			nvarchar(MAX)
DECLARE @LM_POSTAMBLE_HTML			nvarchar(MAX)
DECLARE @localeId					integer
DECLARE @errorCode					AS integer = 0
DECLARE @errorString				AS varchar(1024)=''
declare @subjToken		nvarchar(128)
declare @bodyToken		nvarchar(128)
declare @subjTokenId	bigint
declare @bodyTokenId	bigint
declare @cnt			int
declare @subject		nvarchar(max)
DECLARE @formattedMsgBodyStart	int
DECLARE	@subjectMessage	NVARCHAR(MAX)
set @subjTokenId = (2 | (CAST(POWER(2, 24) AS BIGINT) * 74))
set @bodyTokenId = (1 | (CAST(POWER(2, 24) AS BIGINT) * 74))
declare @minId int = (1 | (CAST(POWER(2, 24) AS BIGINT) * 74)) -- first message in alertlocale tab
declare @maxId int = (1408 | (CAST(POWER(2, 24) AS BIGINT) * 74)) -- last message in alertlocale tab
-- Now preamble and postamble are expected to be in html format.
-- Because it might have html formatting and we dont want to lose it by plainly converting
-- Below defines give way to convert text row to html by default.
-- Also if specific formatting is to be done for important tokens/tags, they can be done using NEW_ROW_TEXT_ONLY and NEW_ROW_HTML
-- If NEW_ROW is used for specific tag level html formatting, then formatting would be lost.
-- We also remove the last <li> and </li>
-- First we find the last <li> and from that we replace last <li> and </li> with ''
-- We also dont want any li and /li for line seperators like MsgHrzSep
-- set @FORMAT = replace(@FORMAT,'<li>MsgTab_  MsgTokSep&gt; &lt;MsgTokSep 18','MsgTab_  MsgTokSep&gt; &lt;MsgTokSep 18 <li>')
declare @NTnotificationTemplate table
(
	NTalertTypeID		    integer        NOT NULL,       						-- Drives offline, Commcells unreachable ....
    messageType             integer        NOT NULL,       						-- email, pager, etc ...
    locale                  integer         NOT NULL,       					-- i.e. "EN_US".. Replaced w/FK To a Locale Lookup Table?  Yes
    defaultformatString     nvarchar(MAX)         NOT NULL,       -- Default Format string for the message
	messageFormatType			integer
)
IF object_id('tempdb.dbo.##EvLocaleMsgs') IS NOT null DROP TABLE ##EvLocaleMsgs
create TABLE ##EvLocaleMsgs
(
	MessageID               bigint                          not null,
	Message                 nvarchar(1024)     not null,
	primary key (MessageID)
);;
------------------------------------------------------------------------------
-- TESTING of 5.0 RTM + SP2 Found "Bad" rows in Base content for this table --
-- .. better just to delete all the rows and start over!                    --
------------------------------------------------------------------------------
declare @subjectListTable table
(
	messageType int,
	alertType   int,
	isHtml		bit,
	subjectText nvarchar(max),
	priority	int
)
declare @preambleListTable table
(
	messageType int,
	alertType   int,
	isHtml		bit,
	itemType	nvarchar(max),
	itemText    nvarchar(max),
	priority	int
)
declare @existingAlertType table(alertType int)
insert into @existingAlertType
select distinct ntalerttypeid from NTnotificationTemplate with (nolock)
declare @recordTranStarted int = 0
begin try
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN TRANSACTION
		SET @recordTranStarted = 1
	END
	--do not delete templates if customised, add only the templates of newly added alert types, user will not get the new tokens for existing alerts
	IF @templateCustomised <> 1
		DELETE NTnotificationTemplate
		WHERE NTalertTypeid IN
		(
			SELECT id FROM NTAlertType WITH (nolock)  --where (actionsAllowed&NT_UPDATE_TEMPLATE)>0
		)
IF ( CURSOR_STATUS('global', 'GetLocaleForAlert') >= 0   OR CURSOR_STATUS('local', 'GetLocaleForAlert') >= 0 )  -- CLOSE CURSOR IF OPEN
	CLOSE GetLocaleForAlert
IF ( CURSOR_STATUS('global','GetLocaleForAlert') = -1     OR CURSOR_STATUS('local','GetLocaleForAlert') = -1 )
	DEALLOCATE GetLocaleForAlert
DECLARE	GetLocaleForAlert CURSOR FOR
SELECT  DISTINCT cvlocaleId from evlocales
OPEN GetLocaleForAlert
FETCH GetLocaleForAlert INTO @localeId
WHILE	@@FETCH_STATUS = 0
BEGIN
delete from @subjectListTable
delete from @preambleListTable
delete from ##EvLocaleMsgs
Insert into ##EvLocaleMsgs
select EvLocaleMsgs.MessageId,EvLocaleMsgs.Message from EvLocaleMsgs WITH (READUNCOMMITTED)
where MessageId>=@minId and MessageId<=@maxId
and localeId=@localeId
-- For messages which do not have localization yet, take their english value
Insert into ##EvLocaleMsgs
select EvLocaleMsgs.MessageId,EvLocaleMsgs.Message from EvLocaleMsgs WITH (READUNCOMMITTED)
left join ##EvLocaleMsgs EvLocaleMsgsTmp
on EvLocaleMsgs.MessageId = EvLocaleMsgsTmp.MessageId
where EvLocaleMsgs.MessageId>=@minId and EvLocaleMsgs.MessageId<=@maxId
and EvLocaleMsgs.localeId=0
and EvLocaleMsgsTmp.MessageId is null
SET @STD_EMAIL_PREAMBLE  = (select Message from ##EvLocaleMsgs  where MessageID=(2 | (CAST(POWER(2, 24) AS BIGINT) * 74))) +  ' '
SET @STD_EMAIL_PREAMBLE  =  @STD_EMAIL_PREAMBLE + (select Message from ##EvLocaleMsgs  where MessageID=(212 | (CAST(POWER(2, 24) AS BIGINT) * 74))) +  ' '
SET @STD_EMAIL_PREAMBLE  =  @STD_EMAIL_PREAMBLE+ (select Message from ##EvLocaleMsgs  where MessageID=(13 | (CAST(POWER(2, 24) AS BIGINT) * 74))) +  ' '
SET @STD_EMAIL_PREAMBLE  =  @STD_EMAIL_PREAMBLE + (select Message from ##EvLocaleMsgs  where MessageID=(213 | (CAST(POWER(2, 24) AS BIGINT) * 74))) +  ' '
SET @STD_EMAIL_PREAMBLE  =  @STD_EMAIL_PREAMBLE + (select Message from ##EvLocaleMsgs  where MessageID=(6 | (CAST(POWER(2, 24) AS BIGINT) * 74))) +  ' '
SET @STD_EMAIL_PREAMBLE  =  @STD_EMAIL_PREAMBLE + (select Message from ##EvLocaleMsgs  where MessageID=(22 | (CAST(POWER(2, 24) AS BIGINT) * 74))) +  ' '
SET @STD_EMAIL_PREAMBLE  =  @STD_EMAIL_PREAMBLE + (select Message from ##EvLocaleMsgs  where MessageID=(1 | (CAST(POWER(2, 24) AS BIGINT) * 74))) +  ' '
SET @STD_EMAIL_PREAMBLE  =  @STD_EMAIL_PREAMBLE  + 'MsgNewLine_'
SET @STD_EMAIL_PREAMBLE  =  @STD_EMAIL_PREAMBLE +  ' ' + ( select Message from ##EvLocaleMsgs  where MessageID=(212 | (CAST(POWER(2, 24) AS BIGINT) * 74)) ) +  ' '
SET @STD_EMAIL_PREAMBLE  =  @STD_EMAIL_PREAMBLE
SET @STD_EMAIL_PREAMBLE  =  @STD_EMAIL_PREAMBLE + (select Message from ##EvLocaleMsgs  where MessageID=(13 | (CAST(POWER(2, 24) AS BIGINT) * 74))) +  ' '
SET @STD_EMAIL_PREAMBLE  =  @STD_EMAIL_PREAMBLE
SET @STD_EMAIL_PREAMBLE  =  @STD_EMAIL_PREAMBLE+ 'MsgNewLine_ '
SET @STD_EMAIL_PREAMBLE  =  @STD_EMAIL_PREAMBLE + (select Message from ##EvLocaleMsgs  where MessageID=(213 | (CAST(POWER(2, 24) AS BIGINT) * 74))) +  ' '
SET @STD_EMAIL_PREAMBLE  =  @STD_EMAIL_PREAMBLE + (select Message from ##EvLocaleMsgs  where MessageID=(6 | (CAST(POWER(2, 24) AS BIGINT) * 74))) +  ' '
SET @STD_EMAIL_PREAMBLE  =  @STD_EMAIL_PREAMBLE + 'MsgNewLine_MsgTab_ '
SET @STD_EMAIL_PREAMBLE  =  @STD_EMAIL_PREAMBLE+ (select Message from ##EvLocaleMsgs  where MessageID=(214 | (CAST(POWER(2, 24) AS BIGINT) * 74))) +  ' '
SET @STD_EMAIL_PREAMBLE  =  @STD_EMAIL_PREAMBLE+ (select Message from ##EvLocaleMsgs  where MessageID=(14 | (CAST(POWER(2, 24) AS BIGINT) * 74))) +  ' '
SET @STD_EMAIL_PREAMBLE  =  @STD_EMAIL_PREAMBLE + 'MsgNewLine_MsgTab_ '
SET @STD_EMAIL_PREAMBLE  =  @STD_EMAIL_PREAMBLE + (select Message from ##EvLocaleMsgs  where MessageID=(215 | (CAST(POWER(2, 24) AS BIGINT) * 74))) +  ' '
SET @STD_EMAIL_PREAMBLE  =  @STD_EMAIL_PREAMBLE+ (select Message from ##EvLocaleMsgs  where MessageID=(7 | (CAST(POWER(2, 24) AS BIGINT) * 74))) +  ' '
SET @STD_EMAIL_PREAMBLE  =  @STD_EMAIL_PREAMBLE +   'MsgNewLine_MsgTab_ '
SET @STD_EMAIL_PREAMBLE  =  @STD_EMAIL_PREAMBLE+ (select Message from ##EvLocaleMsgs  where MessageID=(388 | (CAST(POWER(2, 24) AS BIGINT) * 74))) +  ' '--'ALERT_TEMPLATE_COMCELL'
SET @STD_EMAIL_PREAMBLE  =  @STD_EMAIL_PREAMBLE+ (select Message from ##EvLocaleMsgs  where MessageID=(4 | (CAST(POWER(2, 24) AS BIGINT) * 74))) +  ' '--'ALERT_TOKEN_COMMCELLNAME'
SET @STD_EMAIL_PREAMBLE_CSFAILOVER =  @STD_EMAIL_PREAMBLE
SET @STD_EMAIL_PREAMBLE_OM  =  @STD_EMAIL_PREAMBLE + 'MsgNewLine_ MsgNewLine_ '
SET @STD_EMAIL_PREAMBLE  =  @STD_EMAIL_PREAMBLE + 'MsgNewLine_MsgTab_ '
SET @STD_EMAIL_PREAMBLE  =  @STD_EMAIL_PREAMBLE + (select Message from ##EvLocaleMsgs  where MessageID=(216 | (CAST(POWER(2, 24) AS BIGINT) * 74))) +  ' '
SET @STD_EMAIL_PREAMBLE  =  @STD_EMAIL_PREAMBLE+ (select Message from ##EvLocaleMsgs  where MessageID=(183 | (CAST(POWER(2, 24) AS BIGINT) * 74))) +  ' '
SET @STD_EMAIL_PREAMBLE  =  @STD_EMAIL_PREAMBLE+ 'MsgNewLine_ MsgNewLine_ '
SET @STD_JSON_PREAMBLE  =  '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (212 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (13 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
SET @STD_JSON_PREAMBLE  =  @STD_JSON_PREAMBLE + '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (213 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (6 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
SET @STD_JSON_PREAMBLE  =  @STD_JSON_PREAMBLE + '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (214 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (14 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
SET @STD_JSON_PREAMBLE  =  @STD_JSON_PREAMBLE + '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (215 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (7 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
SET @STD_JSON_PREAMBLE  =  @STD_JSON_PREAMBLE + '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (388 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (4 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
SET @STD_JSON_PREAMBLE  =  @STD_JSON_PREAMBLE + '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (216 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (183 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
--Set email preamble for custom alerts.
if exists(select 1 from NTalerttype WITH (READUNCOMMITTED) where id=65) begin
SET @STD_CUSTOM_ALERTS_EMAIL_PREAMBLE  = (select Message from ##EvLocaleMsgs  where MessageID=(2 | (CAST(POWER(2, 24) AS BIGINT) * 74))) +  ' '
SET @STD_CUSTOM_ALERTS_EMAIL_PREAMBLE  =  @STD_CUSTOM_ALERTS_EMAIL_PREAMBLE + (select Message from ##EvLocaleMsgs  where MessageID=(212 | (CAST(POWER(2, 24) AS BIGINT) * 74))) +  ' '
SET @STD_CUSTOM_ALERTS_EMAIL_PREAMBLE  =  @STD_CUSTOM_ALERTS_EMAIL_PREAMBLE+ (select Message from ##EvLocaleMsgs  where MessageID=(13 | (CAST(POWER(2, 24) AS BIGINT) * 74))) +  ' '
SET @STD_CUSTOM_ALERTS_EMAIL_PREAMBLE  =  @STD_CUSTOM_ALERTS_EMAIL_PREAMBLE + (select Message from ##EvLocaleMsgs  where MessageID=(213 | (CAST(POWER(2, 24) AS BIGINT) * 74))) +  ' '
SET @STD_CUSTOM_ALERTS_EMAIL_PREAMBLE  =  @STD_CUSTOM_ALERTS_EMAIL_PREAMBLE + (select Message from ##EvLocaleMsgs  where MessageID=(6 | (CAST(POWER(2, 24) AS BIGINT) * 74))) +  ' '
SET @STD_CUSTOM_ALERTS_EMAIL_PREAMBLE  =  @STD_CUSTOM_ALERTS_EMAIL_PREAMBLE + (select Message from ##EvLocaleMsgs  where MessageID=(22 | (CAST(POWER(2, 24) AS BIGINT) * 74))) +  ' '
SET @STD_CUSTOM_ALERTS_EMAIL_PREAMBLE  =  @STD_CUSTOM_ALERTS_EMAIL_PREAMBLE + (select Message from ##EvLocaleMsgs  where MessageID=(1 | (CAST(POWER(2, 24) AS BIGINT) * 74))) +  ' '
SET @STD_CUSTOM_ALERTS_EMAIL_PREAMBLE  =  @STD_CUSTOM_ALERTS_EMAIL_PREAMBLE + 'MsgNewLine_'
SET @STD_CUSTOM_ALERTS_EMAIL_PREAMBLE  =  @STD_CUSTOM_ALERTS_EMAIL_PREAMBLE +  ' ' + ( select Message from ##EvLocaleMsgs  where MessageID=(212 | (CAST(POWER(2, 24) AS BIGINT) * 74)) ) +  ' '
SET @STD_CUSTOM_ALERTS_EMAIL_PREAMBLE  =  @STD_CUSTOM_ALERTS_EMAIL_PREAMBLE + (select Message from ##EvLocaleMsgs  where MessageID=(13 | (CAST(POWER(2, 24) AS BIGINT) * 74))) +  ' '
SET @STD_CUSTOM_ALERTS_EMAIL_PREAMBLE  =  @STD_CUSTOM_ALERTS_EMAIL_PREAMBLE + 'MsgNewLine_ '
SET @STD_CUSTOM_ALERTS_EMAIL_PREAMBLE  =  @STD_CUSTOM_ALERTS_EMAIL_PREAMBLE + (select Message from ##EvLocaleMsgs  where MessageID=(213 | (CAST(POWER(2, 24) AS BIGINT) * 74))) +  ' '
SET @STD_CUSTOM_ALERTS_EMAIL_PREAMBLE  =  @STD_CUSTOM_ALERTS_EMAIL_PREAMBLE + (select Message from ##EvLocaleMsgs  where MessageID=(6 | (CAST(POWER(2, 24) AS BIGINT) * 74))) +  ' '
SET @STD_CUSTOM_ALERTS_EMAIL_PREAMBLE  =  @STD_CUSTOM_ALERTS_EMAIL_PREAMBLE + 'MsgNewLine_MsgTab_ '
SET @STD_CUSTOM_ALERTS_EMAIL_PREAMBLE  =  @STD_CUSTOM_ALERTS_EMAIL_PREAMBLE + 'MsgNewLine_MsgTab_ '
SET @STD_CUSTOM_ALERTS_EMAIL_PREAMBLE  =  @STD_CUSTOM_ALERTS_EMAIL_PREAMBLE + (select Message from ##EvLocaleMsgs  where MessageID=(215 | (CAST(POWER(2, 24) AS BIGINT) * 74))) +  ' '
SET @STD_CUSTOM_ALERTS_EMAIL_PREAMBLE  =  @STD_CUSTOM_ALERTS_EMAIL_PREAMBLE + (select Message from ##EvLocaleMsgs  where MessageID=(7 | (CAST(POWER(2, 24) AS BIGINT) * 74))) +  ' '
SET @STD_CUSTOM_ALERTS_EMAIL_PREAMBLE  =  @STD_CUSTOM_ALERTS_EMAIL_PREAMBLE +   'MsgNewLine_MsgTab_ '
SET @STD_CUSTOM_ALERTS_EMAIL_PREAMBLE  =  @STD_CUSTOM_ALERTS_EMAIL_PREAMBLE + (select Message from ##EvLocaleMsgs  where MessageID=(388 | (CAST(POWER(2, 24) AS BIGINT) * 74))) +  ' '--'ALERT_TEMPLATE_COMCELL'
SET @STD_CUSTOM_ALERTS_EMAIL_PREAMBLE  =  @STD_CUSTOM_ALERTS_EMAIL_PREAMBLE + (select Message from ##EvLocaleMsgs  where MessageID=(4 | (CAST(POWER(2, 24) AS BIGINT) * 74))) +  ' '--'ALERT_TOKEN_COMMCELLNAME'
SET @STD_CUSTOM_ALERTS_EMAIL_PREAMBLE  =  @STD_CUSTOM_ALERTS_EMAIL_PREAMBLE + 'MsgNewLine_ MsgNewLine_ '
SET @STD_CUSTOM_ALERTS_EMAIL_PREAMBLE  =  @STD_CUSTOM_ALERTS_EMAIL_PREAMBLE + 'MsgNewLine_MsgTab_ '
SET @STD_CUSTOM_ALERTS_EMAIL_PREAMBLE  =  @STD_CUSTOM_ALERTS_EMAIL_PREAMBLE + (select Message from ##EvLocaleMsgs  where MessageID=(216 | (CAST(POWER(2, 24) AS BIGINT) * 74))) +  ' '
SET @STD_CUSTOM_ALERTS_EMAIL_PREAMBLE  =  @STD_CUSTOM_ALERTS_EMAIL_PREAMBLE + (select Message from ##EvLocaleMsgs  where MessageID=(183 | (CAST(POWER(2, 24) AS BIGINT) * 74))) +  ' '
SET @STD_CUSTOM_ALERTS_EMAIL_PREAMBLE  =  @STD_CUSTOM_ALERTS_EMAIL_PREAMBLE + 'MsgNewLine_ MsgNewLine_ '
END
-- For subject, we dont put html encoding. Only for message body we need html encoding
SET @subject  = (select Message from ##EvLocaleMsgs  where MessageID=(2 | (CAST(POWER(2, 24) AS BIGINT) * 74))) +  ' '
SET @subject  +=  (select Message from ##EvLocaleMsgs  where MessageID=(212 | (CAST(POWER(2, 24) AS BIGINT) * 74))) +  ' '
SET @subject  +=  (select Message from ##EvLocaleMsgs  where MessageID=(13 | (CAST(POWER(2, 24) AS BIGINT) * 74))) +  ' '
SET @subject  +=  (select Message from ##EvLocaleMsgs  where MessageID=(213 | (CAST(POWER(2, 24) AS BIGINT) * 74))) +  ' '
SET @subject  +=  (select Message from ##EvLocaleMsgs  where MessageID=(6 | (CAST(POWER(2, 24) AS BIGINT) * 74))) +  ' '
SET @subject  +=  (select Message from ##EvLocaleMsgs  where MessageID=(22 | (CAST(POWER(2, 24) AS BIGINT) * 74))) +  ' '
-- Insert this into the subject table. This is common subject for all formats. Hence lowest priority. will be picked if nothing else
-- specific is found
insert into @subjectListTable(messageType, alertType,isHtml	,subjectText ,priority)
select 0,0,1,@subject,1
SET @STD_EMAIL_PREAMBL_HTML  =  (select Message from ##EvLocaleMsgs  where MessageID=(1 | (CAST(POWER(2, 24) AS BIGINT) * 74))) +  ' '
SET @STD_EMAIL_PREAMBL_HTML  += '<div id="contentTbl-table-scroll">
  <table cellspacing="0" cellpadding="0" width="100%" style="border: 1px solid #2f4e66;">
<tr>
  <td>
<center>
  <table id="contentTbl" cellspacing="0" cellpadding="0" width="100%" border="0">
<tr style="background-color: #2f4e66">
  <td valign="middle" align="left" colspan="3">
<div style="margin-left: 20px; margin-bottom: 25px; margin-top: 25px">
<font color="#FFFFFF" size="5" face="sans-serif"><b>'+ dbo.getHtmlEscapedString((select Message from ##EvLocaleMsgs where MessageID=(13 | (CAST(POWER(2, 24) AS BIGINT) * 74))),1) +  ' ' +'</b></font>
</div>
  </td>
</tr>'
-- Common table headers for all formats. Hence will be used only when nothing else specific is set.
Insert into @preambleListTable(messageType, alertType,isHtml,itemType,itemText ,priority)
select 0,0,1,'HEADER',@STD_EMAIL_PREAMBL_HTML,1
Insert into @preambleListTable(messageType, alertType,isHtml,itemType,itemText ,priority)
select 8192,0,1,'HEADER',@STD_EMAIL_PREAMBL_HTML,10
Insert into @preambleListTable(messageType, alertType,isHtml,itemType,itemText ,priority)
select 0,65,1,'HEADER',@STD_EMAIL_PREAMBL_HTML,1
-- Row 1 finished. Alert name and <time>
--SET @STD_EMAIL_PREAMBL_HTML  =  '<table cellspacing="0" style="border-collapse:collapse;width:100%;font-size:14px;color:#444444;"><tbody>'
SET @STD_EMAIL_PREAMBL_HTML  =  '<tr style="background:#f5f5f5;"><td style="padding:7px 0px 7px 20px;"><font size="3" color="#444444" face="sans-serif"><b>' + dbo.getHtmlEscapedString((select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(213 | (CAST(POWER(2, 24) AS BIGINT) * 74)) ),1) +  ' ' + '</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">' + dbo.getHtmlEscapedString((select Message from ##EvLocaleMsgs where MessageID=(6 | (CAST(POWER(2, 24) AS BIGINT) * 74)) ),1) + '</font></td></tr>'
SET @STD_EMAIL_PREAMBL_HTML  +=  '<tr style="background:#f5f5f5;"><td style="padding:7px 0px 7px 20px;"><font size="3" color="#444444" face="sans-serif"><b>' + dbo.getHtmlEscapedString((select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(388 | (CAST(POWER(2, 24) AS BIGINT) * 74)) ),1) +  ' ' + '</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">' + dbo.getHtmlEscapedString((select Message from ##EvLocaleMsgs where MessageID=(4 | (CAST(POWER(2, 24) AS BIGINT) * 74)) ),1) + '</font></td></tr>'
SET @STD_EMAIL_PREAMBL_HTML  +=  '<tr style="background:#f5f5f5;"><td style="padding:7px 0px 7px 20px;"><font size="3" color="#444444" face="sans-serif"><b>' + dbo.getHtmlEscapedString((select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(214 | (CAST(POWER(2, 24) AS BIGINT) * 74)) ),1) +  ' ' + '</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">' + dbo.getHtmlEscapedString((select Message from ##EvLocaleMsgs where MessageID=(14 | (CAST(POWER(2, 24) AS BIGINT) * 74)) ),1) + '</font></td></tr>'
SET @STD_EMAIL_PREAMBL_HTML  += '<tr><td colspan="3" style="padding:5px 0;"></td></tr>'
-- Row 2 also finished. Commcell, type and detected criteria.
SET @STD_EMAIL_PREAMBL_HTML_OM = @STD_EMAIL_PREAMBL_HTML + '<tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>'
SET @STD_EMAIL_PREAMBL_HTML  +=  '<tr><td style="padding:7px 0px 7px 20px;"><font size="3" color="#444444" face="sans-serif"><b>' + dbo.getHtmlEscapedString((select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(216 | (CAST(POWER(2, 24) AS BIGINT) * 74)) ),1) +  ' ' + '</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">' + dbo.getHtmlEscapedString((select Message from ##EvLocaleMsgs where MessageID=(183 | (CAST(POWER(2, 24) AS BIGINT) * 74)) ),1) + '</font></td></tr>' + '<tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>'
SET @STD_EMAIL_PREAMBLE_HTML_CSFAILOVER=@STD_EMAIL_PREAMBL_HTML_OM
-- Common table "Middle" for all formats. Hence will be used only when nothing else specific is set.
-- For email dont have anything for HR Place holder
Insert into @preambleListTable(messageType, alertType,isHtml,itemType,itemText ,priority)
select 0,0,1,'MIDDLE',replace(replace(@STD_EMAIL_PREAMBL_HTML,'<HR_PLACE_HOLDER>',''),'<BGCOLOR>','#DCDEDE'),1
-- Add the entry corresponding to Event monitoring. Here User token shldnt be displayed as part of this template.
Insert into @preambleListTable(messageType, alertType,isHtml,itemType,itemText ,priority)
select 0,58,1,'MIDDLE',replace(replace(@STD_EMAIL_PREAMBL_HTML_OM,'<HR_PLACE_HOLDER>',''),'<BGCOLOR>','#DCDEDE'),20
UNION
select 0,74,1,'MIDDLE',replace(replace(@STD_EMAIL_PREAMBLE_HTML_CSFAILOVER,'<HR_PLACE_HOLDER>',''),'<BGCOLOR>','#DCDEDE'),20
UNION
select 0,75,1,'MIDDLE',replace(replace(@STD_EMAIL_PREAMBL_HTML_OM,'<HR_PLACE_HOLDER>',''),'<BGCOLOR>','#DCDEDE'),20
-- Seperate middle section for custom Query alerts. No need for detected criteria since its hidden from user.
SET @STD_EMAIL_PREAMBL_HTML  =   '<tr style="background:#f5f5f5;"><td style="padding:7px 0px 7px 20px;"><font size="3" color="#444444" face="sans-serif"><b>' + dbo.getHtmlEscapedString((select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(388 | (CAST(POWER(2, 24) AS BIGINT) * 74)) ),1) +  ' ' + '</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">' + dbo.getHtmlEscapedString((select Message from ##EvLocaleMsgs where MessageID=(4 | (CAST(POWER(2, 24) AS BIGINT) * 74)) ),1) + '</font></td></tr>'
SET @STD_EMAIL_PREAMBL_HTML  += '<tr style="background:#f5f5f5;"><td style="padding:7px 0px 7px 20px;"><font size="3" color="#444444" face="sans-serif"><b>' + dbo.getHtmlEscapedString((select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(213 | (CAST(POWER(2, 24) AS BIGINT) * 74)) ),1) +  ' ' + '</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">' + dbo.getHtmlEscapedString((select Message from ##EvLocaleMsgs where MessageID=(6 | (CAST(POWER(2, 24) AS BIGINT) * 74)) ),1) + '</font></td></tr>'
-- Add the entry corresponding to Custom alerts template. Here Detected Criteria token shldnt be displayed as part of this template.
Insert into @preambleListTable(messageType, alertType,isHtml,itemType,itemText ,priority)
select 0,65,1,'MIDDLE',replace(replace(@STD_EMAIL_PREAMBL_HTML,'<HR_PLACE_HOLDER>',''),'<BGCOLOR>','#DCDEDE'),20
SET @STD_PAGER_PREAMBLE  = ''
SET @STD_PAGER_PREAMBLE  =  @STD_PAGER_PREAMBLE+ (select Message from ##EvLocaleMsgs where MessageID=(214 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(14 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
-- change the  ALERT_TEMPLATE_FAILURE_REASON to generated time
set @STD_POSTAMBLE = ' '
set @STD_POSTAMBLE_HTML = '</td></tr><tr style="background-color: #2f4e66">  <td colspan="3" align="right" style="padding-top: 7px; padding-right: 20px; padding-bottom: 7px; padding-left: 0px"><font size="3" face="sans-serif" color="#ffffff">'+dbo.getHtmlEscapedString((select Message from ##EvLocaleMsgs where MessageID=(1334 | (CAST(POWER(2, 24) AS BIGINT) * 74))),1) +  ' '+' '+dbo.getHtmlEscapedString((select Message from ##EvLocaleMsgs where MessageID=(7 | (CAST(POWER(2, 24) AS BIGINT) * 74))),1) +  ' '+
'</font>  </td></tr>  </table></center>  </td></tr>  </table></div>'
-- Common table postamble for all formats. Hence will be used only when nothing else specific is set.
Insert into @preambleListTable(messageType, alertType,isHtml,itemType,itemText ,priority)
select 0,0,1,'POSTAMBLE',@STD_POSTAMBLE_HTML,1
-- Postamble is different for live feeds
set @STD_POSTAMBLE_HTML = '</td></tr></tbody></table>
<div style="background-color:#2f4e66; margin-top:20px;padding:7px 18px;text-align:right;font-size:14px;" class="cv-primary"><h2 color="#FFFFFF" face="sans-serif">'+dbo.getHtmlEscapedString((select Message from ##EvLocaleMsgs where MessageID=(216 | (CAST(POWER(2, 24) AS BIGINT) * 74))),1) +  ' '+' '+dbo.getHtmlEscapedString((select Message from ##EvLocaleMsgs where MessageID=(7 | (CAST(POWER(2, 24) AS BIGINT) * 74))),1) +  ' '+'</h2></div>
    </div>'
-- Common table postamble for all formats. Hence will be used only when nothing else specific is set.
--Insert into @preambleListTable(messageType, alertType,isHtml,itemType,itemText ,priority)
--select NT_LIVEFEEDS_ALERTNOTIF,0,1,'POSTAMBLE',@STD_POSTAMBLE_HTML,10
-- ================
-- Data Aging
-- ================
if exists(select 1 from NTalerttype WITH (READUNCOMMITTED) where id=1) begin
SET @FORMAT_EMAIL = 'MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(217 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(35 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(218 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(23 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(219 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(36 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(220 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(38 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(221 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(37 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(413 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(412 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(222 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(39 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(453 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(452 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(455 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(454 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''
SET @FORMAT_PAGER = (select Message from ##EvLocaleMsgs where MessageID=(218 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(23 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '+  (select Message from ##EvLocaleMsgs where MessageID=(217 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(35 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(219 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(36 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(220 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(38 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(221 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(37 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(413 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(412 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(222 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(39 | (CAST(POWER(2, 24) AS BIGINT) * 74)))
SET @FORMAT_JSON =
'"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (217 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (35 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (218 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (23 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (219 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (36 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (220 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (38 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (221 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (37 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (413 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (412 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (222 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (39 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (453 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (452 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (455 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (454 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '"'
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + @STD_POSTAMBLE	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (1, 1,  @localeId, @FORMAT,0)	set @common_Html_Postamble = @STD_POSTAMBLE  if ((1=1 OR 1=512 OR 1=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 1 or messageType = 0) and (alertType = 1 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1 or messageType = 0) and (alertType = 1 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1 or messageType = 0) and (alertType = 1 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1 or messageType = 0) and (alertType = 1 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (1, 1,  @localeId, @FORMAT,1)	end
-- NEW_ROW (@STD_PAGER_PREAMBLE, NT_ALERTTYPE_DATA_AGING,  NT_PAGER_ALERTNOTIF, @localeId, @FORMAT_PAGER,'')
set @FORMAT = @STD_PAGER_PREAMBLE + @FORMAT_PAGER + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (1, 4,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((4=1 OR 4=512 OR 4=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 4 or messageType = 0) and (alertType = 1 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 4 or messageType = 0) and (alertType = 1 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 4 or messageType = 0) and (alertType = 1 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 4 or messageType = 0) and (alertType = 1 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_PAGER if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_PAGER,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (1, 4,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_PAGER_PREAMBLE + @FORMAT_PAGER + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (1, 8,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((8=1 OR 8=512 OR 8=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 8 or messageType = 0) and (alertType = 1 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8 or messageType = 0) and (alertType = 1 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8 or messageType = 0) and (alertType = 1 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8 or messageType = 0) and (alertType = 1 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_PAGER if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_PAGER,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (1, 8,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (1, 512,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((512=1 OR 512=512 OR 512=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 512 or messageType = 0) and (alertType = 1 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 512 or messageType = 0) and (alertType = 1 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 512 or messageType = 0) and (alertType = 1 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 512 or messageType = 0) and (alertType = 1 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (1, 512,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (1, 1024,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((1024=1 OR 1024=512 OR 1024=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 1024 or messageType = 0) and (alertType = 1 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1024 or messageType = 0) and (alertType = 1 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1024 or messageType = 0) and (alertType = 1 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1024 or messageType = 0) and (alertType = 1 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (1, 1024,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + @STD_POSTAMBLE	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')   SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')   SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')  insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (1, 8192,  @localeId, @FORMAT,0)
set @FORMAT = @STD_PAGER_PREAMBLE + @FORMAT_PAGER + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (1, 32768,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((32768=1 OR 32768=512 OR 32768=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 32768 or messageType = 0) and (alertType = 1 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 32768 or messageType = 0) and (alertType = 1 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 32768 or messageType = 0) and (alertType = 1 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 32768 or messageType = 0) and (alertType = 1 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_PAGER if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_PAGER,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (1, 32768,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (1, 1048576,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((1048576=1 OR 1048576=512 OR 1048576=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 1048576 or messageType = 0) and (alertType = 1 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1048576 or messageType = 0) and (alertType = 1 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1048576 or messageType = 0) and (alertType = 1 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1048576 or messageType = 0) and (alertType = 1 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (1, 1048576,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (1, 131072,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((131072=1 OR 131072=512 OR 131072=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 131072 or messageType = 0) and (alertType = 1 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 131072 or messageType = 0) and (alertType = 1 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 131072 or messageType = 0) and (alertType = 1 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 131072 or messageType = 0) and (alertType = 1 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (1, 131072,  @localeId, @FORMAT,1)	end
if @isJson = 1		begin		set @FORMAT = '{' + @STD_JSON_PREAMBLE + @FORMAT_JSON + '}'insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (1, 8192,  @localeId, @FORMAT, 1)	end	else	begin		set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 8192 or messageType = 0) and (alertType = 1 or alertType = 0) and isHtml = 1 order by priority desc),'') 	set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8192 or messageType = 0) and (alertType = 1 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') 	set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8192 or messageType = 0) and (alertType = 1 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') 	set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8192 or messageType = 0) and (alertType = 1 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 	set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (1, 8192,  @localeId, @FORMAT,1)	end
END
-- ================
-- Aux Copy
-- ================
if exists(select 1 from NTalerttype WITH (READUNCOMMITTED) where (id=2 OR id=54) ) begin
SET @FORMAT_EMAIL = 'MsgTab_ ' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(217 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(35 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(218 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(23 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(223 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(40 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(224 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(41 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(219 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(36 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(220 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(38 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(221 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(37 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(413 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(412 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(222 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(39 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ '<MsgTokSep ' + CAST(56 as nvarchar(20)) + ' '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(704 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(705 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(708 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(709 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(710 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(711 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(989 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(991 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(998 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(999 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(1158 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(1157 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(245 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(182 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(239 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(63 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ ' MsgTokSep> '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(712 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(713 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(714 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(715 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''
SET @FORMAT_PAGER = (select Message from ##EvLocaleMsgs where MessageID=(218 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(23 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '+  (select Message from ##EvLocaleMsgs where MessageID=(217 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(35 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(223 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(40 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(224 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(41 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(219 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(36 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(220 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(38 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(221 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(37 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(413 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(412 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+   (select Message from ##EvLocaleMsgs where MessageID=(222 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(39 | (CAST(POWER(2, 24) AS BIGINT) * 74)))
SET @FORMAT_JSON =
'"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (217 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (35 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (218 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (23 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (223 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (40 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (224 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (41 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (219 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (36 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (220 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (38 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (221 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (37 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (413 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (412 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (222 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (39 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '<MsgTokSep ' + CAST(56 as nvarchar(20)) + ' '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (704 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (705 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (708 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (709 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (710 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (711 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (989 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (991 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (998 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (999 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (1158 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (1157 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (245 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (182 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (239 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (63 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ ' MsgTokSep> '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (712 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (713 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (714 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (715 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '"'
-- ===============
-- AUX COPY
-- ===============
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + @STD_POSTAMBLE	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (2, 1,  @localeId, @FORMAT,0)	set @common_Html_Postamble = @STD_POSTAMBLE  if ((1=1 OR 1=512 OR 1=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 1 or messageType = 0) and (alertType = 2 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1 or messageType = 0) and (alertType = 2 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1 or messageType = 0) and (alertType = 2 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1 or messageType = 0) and (alertType = 2 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (2, 1,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_PAGER_PREAMBLE + @FORMAT_PAGER + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (2, 4,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((4=1 OR 4=512 OR 4=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 4 or messageType = 0) and (alertType = 2 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 4 or messageType = 0) and (alertType = 2 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 4 or messageType = 0) and (alertType = 2 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 4 or messageType = 0) and (alertType = 2 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_PAGER if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_PAGER,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (2, 4,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_PAGER_PREAMBLE + @FORMAT_PAGER + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (2, 8,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((8=1 OR 8=512 OR 8=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 8 or messageType = 0) and (alertType = 2 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8 or messageType = 0) and (alertType = 2 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8 or messageType = 0) and (alertType = 2 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8 or messageType = 0) and (alertType = 2 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_PAGER if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_PAGER,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (2, 8,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (2, 512,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((512=1 OR 512=512 OR 512=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 512 or messageType = 0) and (alertType = 2 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 512 or messageType = 0) and (alertType = 2 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 512 or messageType = 0) and (alertType = 2 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 512 or messageType = 0) and (alertType = 2 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (2, 512,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (2, 1024,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((1024=1 OR 1024=512 OR 1024=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 1024 or messageType = 0) and (alertType = 2 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1024 or messageType = 0) and (alertType = 2 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1024 or messageType = 0) and (alertType = 2 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1024 or messageType = 0) and (alertType = 2 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (2, 1024,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + @STD_POSTAMBLE	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')   SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')   SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')  insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (2, 8192,  @localeId, @FORMAT,0)
set @FORMAT = @STD_PAGER_PREAMBLE + @FORMAT_PAGER + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (2, 32768,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((32768=1 OR 32768=512 OR 32768=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 32768 or messageType = 0) and (alertType = 2 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 32768 or messageType = 0) and (alertType = 2 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 32768 or messageType = 0) and (alertType = 2 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 32768 or messageType = 0) and (alertType = 2 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_PAGER if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_PAGER,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (2, 32768,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (2, 1048576,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((1048576=1 OR 1048576=512 OR 1048576=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 1048576 or messageType = 0) and (alertType = 2 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1048576 or messageType = 0) and (alertType = 2 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1048576 or messageType = 0) and (alertType = 2 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1048576 or messageType = 0) and (alertType = 2 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (2, 1048576,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (2, 131072,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((131072=1 OR 131072=512 OR 131072=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 131072 or messageType = 0) and (alertType = 2 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 131072 or messageType = 0) and (alertType = 2 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 131072 or messageType = 0) and (alertType = 2 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 131072 or messageType = 0) and (alertType = 2 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (2, 131072,  @localeId, @FORMAT,1)	end
if @isJson = 1		begin		set @FORMAT = '{' + @STD_JSON_PREAMBLE + @FORMAT_JSON + '}'insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (2, 8192,  @localeId, @FORMAT, 1)	end	else	begin		set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 8192 or messageType = 0) and (alertType = 2 or alertType = 0) and isHtml = 1 order by priority desc),'') 	set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8192 or messageType = 0) and (alertType = 2 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') 	set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8192 or messageType = 0) and (alertType = 2 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') 	set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8192 or messageType = 0) and (alertType = 2 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 	set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (2, 8192,  @localeId, @FORMAT,1)	end
-- =================
-- MEDIA REFRESHING
-- =================
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + @STD_POSTAMBLE	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (54, 1,  @localeId, @FORMAT,0)	set @common_Html_Postamble = @STD_POSTAMBLE  if ((1=1 OR 1=512 OR 1=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 1 or messageType = 0) and (alertType = 54 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1 or messageType = 0) and (alertType = 54 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1 or messageType = 0) and (alertType = 54 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1 or messageType = 0) and (alertType = 54 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (54, 1,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_PAGER_PREAMBLE + @FORMAT_PAGER + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (54, 4,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((4=1 OR 4=512 OR 4=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 4 or messageType = 0) and (alertType = 54 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 4 or messageType = 0) and (alertType = 54 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 4 or messageType = 0) and (alertType = 54 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 4 or messageType = 0) and (alertType = 54 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_PAGER if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_PAGER,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (54, 4,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_PAGER_PREAMBLE + @FORMAT_PAGER + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (54, 8,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((8=1 OR 8=512 OR 8=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 8 or messageType = 0) and (alertType = 54 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8 or messageType = 0) and (alertType = 54 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8 or messageType = 0) and (alertType = 54 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8 or messageType = 0) and (alertType = 54 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_PAGER if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_PAGER,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (54, 8,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (54, 512,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((512=1 OR 512=512 OR 512=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 512 or messageType = 0) and (alertType = 54 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 512 or messageType = 0) and (alertType = 54 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 512 or messageType = 0) and (alertType = 54 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 512 or messageType = 0) and (alertType = 54 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (54, 512,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (54, 1024,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((1024=1 OR 1024=512 OR 1024=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 1024 or messageType = 0) and (alertType = 54 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1024 or messageType = 0) and (alertType = 54 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1024 or messageType = 0) and (alertType = 54 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1024 or messageType = 0) and (alertType = 54 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (54, 1024,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + @STD_POSTAMBLE	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')   SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')   SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')  insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (54, 8192,  @localeId, @FORMAT,0)
set @FORMAT = @STD_PAGER_PREAMBLE + @FORMAT_PAGER + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (54, 32768,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((32768=1 OR 32768=512 OR 32768=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 32768 or messageType = 0) and (alertType = 54 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 32768 or messageType = 0) and (alertType = 54 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 32768 or messageType = 0) and (alertType = 54 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 32768 or messageType = 0) and (alertType = 54 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_PAGER if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_PAGER,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (54, 32768,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (54, 1048576,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((1048576=1 OR 1048576=512 OR 1048576=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 1048576 or messageType = 0) and (alertType = 54 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1048576 or messageType = 0) and (alertType = 54 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1048576 or messageType = 0) and (alertType = 54 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1048576 or messageType = 0) and (alertType = 54 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (54, 1048576,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (54, 131072,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((131072=1 OR 131072=512 OR 131072=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 131072 or messageType = 0) and (alertType = 54 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 131072 or messageType = 0) and (alertType = 54 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 131072 or messageType = 0) and (alertType = 54 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 131072 or messageType = 0) and (alertType = 54 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (54, 131072,  @localeId, @FORMAT,1)	end
if @isJson = 1		begin		set @FORMAT = '{' + @STD_JSON_PREAMBLE + @FORMAT_JSON + '}'insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (54, 8192,  @localeId, @FORMAT, 1)	end	else	begin		set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 8192 or messageType = 0) and (alertType = 54 or alertType = 0) and isHtml = 1 order by priority desc),'') 	set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8192 or messageType = 0) and (alertType = 54 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') 	set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8192 or messageType = 0) and (alertType = 54 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') 	set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8192 or messageType = 0) and (alertType = 54 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 	set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (54, 8192,  @localeId, @FORMAT,1)	end
END
-- ===============
-- Data Protection
-- ===============
if exists(select 1 from NTalerttype WITH (READUNCOMMITTED) where id=3) begin
SET @FORMAT_EMAIL = 'MsgTab_ ' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(217 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(35 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(218 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(23 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(225 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(1384 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(226 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(43 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(227 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(44 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(228 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(45 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(229 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(46 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(230 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(47 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(470 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(472 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(1129 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(1128 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(1130 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(1131 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(1126 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(1125 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(1127 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(1124 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(219 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(36 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(220 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(38 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(221 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(37 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(413 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(412 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(222 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(39 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(232 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(48 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(231 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(49 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ '<MsgTokSep ' +  CAST(52 as nvarchar(20))+','+ CAST(53 as nvarchar(20))+','+ CAST(85 as nvarchar(20)) + ' '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(449 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(448 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ ' MsgTokSep> '
+ '<MsgTokSep ' + CAST(52 as nvarchar(20))+','+ CAST(53 as nvarchar(20))+ ' '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(445 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(444 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(447 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(446 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(451 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(450 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ ' MsgTokSep> '
+ '<MsgTokSep ' + CAST(65 as nvarchar(20)) + ' '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(848 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(845 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(849 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(844 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(850 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(843 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ ' MsgTokSep> '
+ '<MsgTokSep ' + CAST(68 as nvarchar(20))+','+ CAST(69 as nvarchar(20))+ ' '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(853 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(854 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ ' MsgTokSep> '
+ '<MsgTokSep ' + CAST(71 as nvarchar(20)) + ' '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(867 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(868 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '-- Failed Job Info: <FAILED JOB INFO>
+ ' MsgTokSep> '
+ '<MsgTokSep ' + CAST(73 as nvarchar(20)) + ' '
   -- Hard coding ids since tab change is no longer allowed
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(875 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(870 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '-- Total no of running jobs : <TOTAL JOBS>
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(876 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(871 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '-- No of pending jobs: <PENDING JOBS COUNT>
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(877 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(872 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '-- Top pending errors list: <TOP PENDING ERRORS LIST>
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(878 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(873 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '-- Top waiting errors list: <TOP WAITING ERRORS LIST>
+ ' MsgTokSep> '
+ '<MsgTokSep ' + CAST(74 as nvarchar(20)) + ' '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(445 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(801 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ ' MsgTokSep> '
+ '<MsgTokSep ' + CAST(85 as nvarchar(20)) + ' '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(1277 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(458 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(1279 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(1281 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(1278 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(1280 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''
+ ' MsgTokSep> '
+ dbo.getHtmlEscapedString((select Message from ##EvLocaleMsgs where MessageID=(1170 | (CAST(POWER(2, 24) AS BIGINT) * 74)) ),0) +  ' '
SET @FORMAT_PAGER = (select Message from ##EvLocaleMsgs where MessageID=(225 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(1384 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(226 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(43 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(227 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(44 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(228 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(45 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(229 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(46 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(218 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(23 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(217 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(35 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(413 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(412 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(222 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(39 | (CAST(POWER(2, 24) AS BIGINT) * 74)))
SET @FORMAT_JSON =
'"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (217 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (35 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (218 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (23 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (225 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (1384 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (226 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (43 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (227 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (44 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (228 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (45 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (229 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (46 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (230 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (47 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (470 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (472 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (1129 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (1128 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (1130 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (1131 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (1126 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (1125 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (1127 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (1124 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (219 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (36 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (220 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (38 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (221 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (37 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (413 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (412 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (222 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (39 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (232 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (48 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (231 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (49 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '<MsgTokSep ' +  CAST(52 as nvarchar(20))+','+ CAST(53 as nvarchar(20))+','+ CAST(85 as nvarchar(20)) + ' '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (449 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (448 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ ' MsgTokSep> '
+ '<MsgTokSep ' + CAST(52 as nvarchar(20))+','+ CAST(53 as nvarchar(20))+ ' '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (445 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (444 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (447 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (446 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (451 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (450 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ ' MsgTokSep> '
+ '<MsgTokSep ' + CAST(65 as nvarchar(20)) + ' '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (848 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (845 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (849 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (844 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (850 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (843 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ ' MsgTokSep> '
+ '<MsgTokSep ' + CAST(68 as nvarchar(20))+','+ CAST(69 as nvarchar(20))+ ' '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (853 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (854 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ ' MsgTokSep> '
+ '<MsgTokSep ' + CAST(71 as nvarchar(20)) + ' '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (867 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (868 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '-- Failed Job Info: <FAILED JOB INFO>
+ ' MsgTokSep> '
+ '<MsgTokSep ' + CAST(73 as nvarchar(20)) + ' '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (875 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (870 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '-- Total no of running jobs : <TOTAL JOBS>
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (876 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (871 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '-- No of pending jobs: <PENDING JOBS COUNT>
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (877 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (872 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '-- Top pending errors list: <TOP PENDING ERRORS LIST>
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (878 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (873 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '-- Top waiting errors list: <TOP WAITING ERRORS LIST>
+ ' MsgTokSep> '
+ '<MsgTokSep ' + CAST(74 as nvarchar(20)) + ' '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (1406 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (801 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ ' MsgTokSep> '
+ '<MsgTokSep ' + CAST(85 as nvarchar(20)) + ' '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (1277 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (458 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (1279 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (1281 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (1278 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (1280 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ ' MsgTokSep> '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (1184 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (1170 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '"'
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + @STD_POSTAMBLE	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (3, 1,  @localeId, @FORMAT,0)	set @common_Html_Postamble = @STD_POSTAMBLE  if ((1=1 OR 1=512 OR 1=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 1 or messageType = 0) and (alertType = 3 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1 or messageType = 0) and (alertType = 3 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1 or messageType = 0) and (alertType = 3 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1 or messageType = 0) and (alertType = 3 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (3, 1,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_PAGER_PREAMBLE + @FORMAT_PAGER + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (3, 4,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((4=1 OR 4=512 OR 4=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 4 or messageType = 0) and (alertType = 3 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 4 or messageType = 0) and (alertType = 3 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 4 or messageType = 0) and (alertType = 3 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 4 or messageType = 0) and (alertType = 3 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_PAGER if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_PAGER,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (3, 4,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_PAGER_PREAMBLE + @FORMAT_PAGER + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (3, 8,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((8=1 OR 8=512 OR 8=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 8 or messageType = 0) and (alertType = 3 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8 or messageType = 0) and (alertType = 3 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8 or messageType = 0) and (alertType = 3 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8 or messageType = 0) and (alertType = 3 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_PAGER if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_PAGER,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (3, 8,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (3, 512,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((512=1 OR 512=512 OR 512=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 512 or messageType = 0) and (alertType = 3 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 512 or messageType = 0) and (alertType = 3 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 512 or messageType = 0) and (alertType = 3 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 512 or messageType = 0) and (alertType = 3 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (3, 512,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (3, 1024,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((1024=1 OR 1024=512 OR 1024=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 1024 or messageType = 0) and (alertType = 3 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1024 or messageType = 0) and (alertType = 3 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1024 or messageType = 0) and (alertType = 3 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1024 or messageType = 0) and (alertType = 3 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (3, 1024,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + @STD_POSTAMBLE	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')   SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')   SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')  insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (3, 8192,  @localeId, @FORMAT,0)
set @FORMAT = @STD_PAGER_PREAMBLE + @FORMAT_PAGER + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (3, 32768,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((32768=1 OR 32768=512 OR 32768=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 32768 or messageType = 0) and (alertType = 3 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 32768 or messageType = 0) and (alertType = 3 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 32768 or messageType = 0) and (alertType = 3 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 32768 or messageType = 0) and (alertType = 3 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_PAGER if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_PAGER,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (3, 32768,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (3, 1048576,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((1048576=1 OR 1048576=512 OR 1048576=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 1048576 or messageType = 0) and (alertType = 3 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1048576 or messageType = 0) and (alertType = 3 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1048576 or messageType = 0) and (alertType = 3 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1048576 or messageType = 0) and (alertType = 3 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (3, 1048576,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (3, 131072,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((131072=1 OR 131072=512 OR 131072=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 131072 or messageType = 0) and (alertType = 3 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 131072 or messageType = 0) and (alertType = 3 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 131072 or messageType = 0) and (alertType = 3 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 131072 or messageType = 0) and (alertType = 3 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (3, 131072,  @localeId, @FORMAT,1)	end
if @isJson = 1		begin		set @FORMAT = '{' + @STD_JSON_PREAMBLE + @FORMAT_JSON + '}'insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (3, 8192,  @localeId, @FORMAT, 1)	end	else	begin		set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 8192 or messageType = 0) and (alertType = 3 or alertType = 0) and isHtml = 1 order by priority desc),'') 	set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8192 or messageType = 0) and (alertType = 3 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') 	set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8192 or messageType = 0) and (alertType = 3 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') 	set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8192 or messageType = 0) and (alertType = 3 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 	set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (3, 8192,  @localeId, @FORMAT,1)	end
END
-- ================
-- Data Recovery
-- ================
if exists(select 1 from NTalerttype WITH (READUNCOMMITTED) where id=4) begin
SET @FORMAT_EMAIL = 'MsgTab_ '    + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(217 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(35 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(218 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(23 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(225 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(1384 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(226 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(43 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(227 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(44 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(228 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(45 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(940 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(1154 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(219 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(36 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(220 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(38 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(221 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(37 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ '<MsgTokSep ' + CAST(1 as nvarchar(20)) + ' '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(946 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(459 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ ' MsgTokSep> '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(413 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(412 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(222 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(39 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(231 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(49 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(233 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(51 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(234 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(50 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''
SET @FORMAT_PAGER = (select Message from ##EvLocaleMsgs where MessageID=(225 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(1384 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(226 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(43 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(227 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(44 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(228 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(45 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(218 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(23 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(217 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(35 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(413 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(412 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(222 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(39 | (CAST(POWER(2, 24) AS BIGINT) * 74)))
SET @FORMAT_JSON =
'"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (217 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (35 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (218 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (23 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (225 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (1384 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (226 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (43 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (227 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (44 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (228 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (45 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (940 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (1154 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (219 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (36 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (220 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (38 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (221 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (37 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (413 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (412 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (222 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (39 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (231 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (49 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (233 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (51 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (234 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (50 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '<MsgTokSep ' + CAST(1 as nvarchar(20)) + ' '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (946 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (459 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '"'
+ ' MsgTokSep> '
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + @STD_POSTAMBLE	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (4, 1,  @localeId, @FORMAT,0)	set @common_Html_Postamble = @STD_POSTAMBLE  if ((1=1 OR 1=512 OR 1=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 1 or messageType = 0) and (alertType = 4 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1 or messageType = 0) and (alertType = 4 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1 or messageType = 0) and (alertType = 4 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1 or messageType = 0) and (alertType = 4 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (4, 1,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_PAGER_PREAMBLE + @FORMAT_PAGER + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (4, 4,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((4=1 OR 4=512 OR 4=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 4 or messageType = 0) and (alertType = 4 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 4 or messageType = 0) and (alertType = 4 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 4 or messageType = 0) and (alertType = 4 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 4 or messageType = 0) and (alertType = 4 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_PAGER if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_PAGER,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (4, 4,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_PAGER_PREAMBLE + @FORMAT_PAGER + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (4, 8,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((8=1 OR 8=512 OR 8=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 8 or messageType = 0) and (alertType = 4 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8 or messageType = 0) and (alertType = 4 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8 or messageType = 0) and (alertType = 4 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8 or messageType = 0) and (alertType = 4 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_PAGER if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_PAGER,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (4, 8,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (4, 512,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((512=1 OR 512=512 OR 512=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 512 or messageType = 0) and (alertType = 4 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 512 or messageType = 0) and (alertType = 4 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 512 or messageType = 0) and (alertType = 4 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 512 or messageType = 0) and (alertType = 4 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (4, 512,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (4, 1024,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((1024=1 OR 1024=512 OR 1024=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 1024 or messageType = 0) and (alertType = 4 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1024 or messageType = 0) and (alertType = 4 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1024 or messageType = 0) and (alertType = 4 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1024 or messageType = 0) and (alertType = 4 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (4, 1024,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + @STD_POSTAMBLE	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')   SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')   SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')  insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (4, 8192,  @localeId, @FORMAT,0)
set @FORMAT = @STD_PAGER_PREAMBLE + @FORMAT_PAGER + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (4, 32768,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((32768=1 OR 32768=512 OR 32768=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 32768 or messageType = 0) and (alertType = 4 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 32768 or messageType = 0) and (alertType = 4 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 32768 or messageType = 0) and (alertType = 4 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 32768 or messageType = 0) and (alertType = 4 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_PAGER if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_PAGER,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (4, 32768,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (4, 1048576,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((1048576=1 OR 1048576=512 OR 1048576=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 1048576 or messageType = 0) and (alertType = 4 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1048576 or messageType = 0) and (alertType = 4 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1048576 or messageType = 0) and (alertType = 4 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1048576 or messageType = 0) and (alertType = 4 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (4, 1048576,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (4, 131072,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((131072=1 OR 131072=512 OR 131072=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 131072 or messageType = 0) and (alertType = 4 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 131072 or messageType = 0) and (alertType = 4 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 131072 or messageType = 0) and (alertType = 4 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 131072 or messageType = 0) and (alertType = 4 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (4, 131072,  @localeId, @FORMAT,1)	end
if @isJson = 1		begin		set @FORMAT = '{' + @STD_JSON_PREAMBLE + @FORMAT_JSON + '}'insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (4, 8192,  @localeId, @FORMAT, 1)	end	else	begin		set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 8192 or messageType = 0) and (alertType = 4 or alertType = 0) and isHtml = 1 order by priority desc),'') 	set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8192 or messageType = 0) and (alertType = 4 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') 	set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8192 or messageType = 0) and (alertType = 4 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') 	set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8192 or messageType = 0) and (alertType = 4 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 	set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (4, 8192,  @localeId, @FORMAT,1)	end
END
-- ================
-- Express Recovery
-- ================
if exists(select 1 from NTalerttype WITH (READUNCOMMITTED) where id=5) begin
SET @FORMAT_EMAIL = 'MsgTab_ ' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(217 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(35 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(218 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(23 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(235 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(47 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(219 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(36 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(220 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(38 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(221 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(37 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(413 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(412 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(222 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(39 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''
SET @FORMAT_PAGER = (select Message from ##EvLocaleMsgs where MessageID=(218 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(23 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(217 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(35 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(235 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(47 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(219 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(36 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(220 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(38 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(221 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(37 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(413 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(412 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(222 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(39 | (CAST(POWER(2, 24) AS BIGINT) * 74)))
SET @FORMAT_JSON =
'"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (217 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (35 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (218 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (23 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (235 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (47 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (219 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (36 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (220 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (38 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (221 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (37 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (413 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (412 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (222 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (39 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '"'
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + @STD_POSTAMBLE	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (5, 1,  @localeId, @FORMAT,0)	set @common_Html_Postamble = @STD_POSTAMBLE  if ((1=1 OR 1=512 OR 1=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 1 or messageType = 0) and (alertType = 5 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1 or messageType = 0) and (alertType = 5 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1 or messageType = 0) and (alertType = 5 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1 or messageType = 0) and (alertType = 5 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (5, 1,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_PAGER_PREAMBLE + @FORMAT_PAGER + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (5, 4,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((4=1 OR 4=512 OR 4=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 4 or messageType = 0) and (alertType = 5 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 4 or messageType = 0) and (alertType = 5 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 4 or messageType = 0) and (alertType = 5 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 4 or messageType = 0) and (alertType = 5 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_PAGER if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_PAGER,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (5, 4,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_PAGER_PREAMBLE + @FORMAT_PAGER + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (5, 8,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((8=1 OR 8=512 OR 8=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 8 or messageType = 0) and (alertType = 5 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8 or messageType = 0) and (alertType = 5 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8 or messageType = 0) and (alertType = 5 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8 or messageType = 0) and (alertType = 5 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_PAGER if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_PAGER,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (5, 8,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (5, 512,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((512=1 OR 512=512 OR 512=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 512 or messageType = 0) and (alertType = 5 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 512 or messageType = 0) and (alertType = 5 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 512 or messageType = 0) and (alertType = 5 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 512 or messageType = 0) and (alertType = 5 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (5, 512,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (5, 1024,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((1024=1 OR 1024=512 OR 1024=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 1024 or messageType = 0) and (alertType = 5 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1024 or messageType = 0) and (alertType = 5 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1024 or messageType = 0) and (alertType = 5 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1024 or messageType = 0) and (alertType = 5 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (5, 1024,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + @STD_POSTAMBLE	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')   SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')   SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')  insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (5, 8192,  @localeId, @FORMAT,0)
set @FORMAT = @STD_PAGER_PREAMBLE + @FORMAT_PAGER + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (5, 32768,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((32768=1 OR 32768=512 OR 32768=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 32768 or messageType = 0) and (alertType = 5 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 32768 or messageType = 0) and (alertType = 5 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 32768 or messageType = 0) and (alertType = 5 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 32768 or messageType = 0) and (alertType = 5 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_PAGER if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_PAGER,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (5, 32768,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (5, 1048576,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((1048576=1 OR 1048576=512 OR 1048576=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 1048576 or messageType = 0) and (alertType = 5 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1048576 or messageType = 0) and (alertType = 5 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1048576 or messageType = 0) and (alertType = 5 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1048576 or messageType = 0) and (alertType = 5 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (5, 1048576,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (5, 131072,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((131072=1 OR 131072=512 OR 131072=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 131072 or messageType = 0) and (alertType = 5 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 131072 or messageType = 0) and (alertType = 5 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 131072 or messageType = 0) and (alertType = 5 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 131072 or messageType = 0) and (alertType = 5 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (5, 131072,  @localeId, @FORMAT,1)	end
if @isJson = 1		begin		set @FORMAT = '{' + @STD_JSON_PREAMBLE + @FORMAT_JSON + '}'insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (5, 8192,  @localeId, @FORMAT, 1)	end	else	begin		set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 8192 or messageType = 0) and (alertType = 5 or alertType = 0) and isHtml = 1 order by priority desc),'') 	set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8192 or messageType = 0) and (alertType = 5 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') 	set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8192 or messageType = 0) and (alertType = 5 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') 	set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8192 or messageType = 0) and (alertType = 5 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 	set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (5, 8192,  @localeId, @FORMAT,1)	end
END
-- ==================
-- Data Verification
-- ==================
if exists(select 1 from NTalerttype WITH (READUNCOMMITTED) where id=6) begin
SET @FORMAT_EMAIL = 'MsgTab_ ' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(217 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(35 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(218 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(23 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(223 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(40 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(224 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(41 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(219 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(36 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(220 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(38 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(221 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(37 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(413 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(412 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(222 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(39 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''
SET @FORMAT_PAGER = (select Message from ##EvLocaleMsgs where MessageID=(218 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(23 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(217 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(35 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(223 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(40 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(224 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(41 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(219 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(36 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(220 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(38 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(221 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(37 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(413 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(412 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(222 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(39 | (CAST(POWER(2, 24) AS BIGINT) * 74)))
SET @FORMAT_JSON =
'"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (217 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (35 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (218 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (23 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (223 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (40 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (224 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (41 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (219 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (36 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (220 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (38 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (221 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (37 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (413 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (412 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (222 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (39 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '"'
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + @STD_POSTAMBLE	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (6, 1,  @localeId, @FORMAT,0)	set @common_Html_Postamble = @STD_POSTAMBLE  if ((1=1 OR 1=512 OR 1=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 1 or messageType = 0) and (alertType = 6 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1 or messageType = 0) and (alertType = 6 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1 or messageType = 0) and (alertType = 6 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1 or messageType = 0) and (alertType = 6 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (6, 1,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_PAGER_PREAMBLE + @FORMAT_PAGER + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (6, 4,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((4=1 OR 4=512 OR 4=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 4 or messageType = 0) and (alertType = 6 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 4 or messageType = 0) and (alertType = 6 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 4 or messageType = 0) and (alertType = 6 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 4 or messageType = 0) and (alertType = 6 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_PAGER if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_PAGER,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (6, 4,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_PAGER_PREAMBLE + @FORMAT_PAGER + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (6, 8,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((8=1 OR 8=512 OR 8=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 8 or messageType = 0) and (alertType = 6 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8 or messageType = 0) and (alertType = 6 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8 or messageType = 0) and (alertType = 6 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8 or messageType = 0) and (alertType = 6 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_PAGER if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_PAGER,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (6, 8,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (6, 512,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((512=1 OR 512=512 OR 512=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 512 or messageType = 0) and (alertType = 6 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 512 or messageType = 0) and (alertType = 6 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 512 or messageType = 0) and (alertType = 6 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 512 or messageType = 0) and (alertType = 6 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (6, 512,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (6, 1024,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((1024=1 OR 1024=512 OR 1024=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 1024 or messageType = 0) and (alertType = 6 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1024 or messageType = 0) and (alertType = 6 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1024 or messageType = 0) and (alertType = 6 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1024 or messageType = 0) and (alertType = 6 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (6, 1024,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + @STD_POSTAMBLE	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')   SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')   SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')  insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (6, 8192,  @localeId, @FORMAT,0)
set @FORMAT = @STD_PAGER_PREAMBLE + @FORMAT_PAGER + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (6, 32768,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((32768=1 OR 32768=512 OR 32768=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 32768 or messageType = 0) and (alertType = 6 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 32768 or messageType = 0) and (alertType = 6 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 32768 or messageType = 0) and (alertType = 6 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 32768 or messageType = 0) and (alertType = 6 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_PAGER if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_PAGER,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (6, 32768,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (6, 1048576,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((1048576=1 OR 1048576=512 OR 1048576=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 1048576 or messageType = 0) and (alertType = 6 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1048576 or messageType = 0) and (alertType = 6 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1048576 or messageType = 0) and (alertType = 6 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1048576 or messageType = 0) and (alertType = 6 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (6, 1048576,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (6, 131072,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((131072=1 OR 131072=512 OR 131072=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 131072 or messageType = 0) and (alertType = 6 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 131072 or messageType = 0) and (alertType = 6 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 131072 or messageType = 0) and (alertType = 6 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 131072 or messageType = 0) and (alertType = 6 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (6, 131072,  @localeId, @FORMAT,1)	end
if @isJson = 1		begin		set @FORMAT = '{' + @STD_JSON_PREAMBLE + @FORMAT_JSON + '}'insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (6, 8192,  @localeId, @FORMAT, 1)	end	else	begin		set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 8192 or messageType = 0) and (alertType = 6 or alertType = 0) and isHtml = 1 order by priority desc),'') 	set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8192 or messageType = 0) and (alertType = 6 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') 	set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8192 or messageType = 0) and (alertType = 6 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') 	set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8192 or messageType = 0) and (alertType = 6 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 	set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (6, 8192,  @localeId, @FORMAT,1)	end
END
-- ==================
-- DEDUP DB SYNC
-- ==================
if exists(select 1 from NTalerttype WITH (READUNCOMMITTED) where id=55) begin
SET @FORMAT_EMAIL = 'MsgTab_ ' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(217 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(35 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(218 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(23 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(223 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(40 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(224 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(41 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(219 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(36 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(220 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(38 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(221 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(37 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(413 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(412 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(222 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(39 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''
SET @FORMAT_PAGER = (select Message from ##EvLocaleMsgs where MessageID=(218 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(23 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(217 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(35 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(223 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(40 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(224 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(41 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(219 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(36 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(220 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(38 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(221 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(37 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(413 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(412 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(222 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(39 | (CAST(POWER(2, 24) AS BIGINT) * 74)))
SET @FORMAT_JSON =
'"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (217 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (35 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (218 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (23 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (223 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (40 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (224 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (41 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (219 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (36 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (220 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (38 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (221 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (37 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (413 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (412 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (222 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (39 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '"'
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + @STD_POSTAMBLE	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (55, 1,  @localeId, @FORMAT,0)	set @common_Html_Postamble = @STD_POSTAMBLE  if ((1=1 OR 1=512 OR 1=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 1 or messageType = 0) and (alertType = 55 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1 or messageType = 0) and (alertType = 55 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1 or messageType = 0) and (alertType = 55 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1 or messageType = 0) and (alertType = 55 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (55, 1,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_PAGER_PREAMBLE + @FORMAT_PAGER + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (55, 4,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((4=1 OR 4=512 OR 4=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 4 or messageType = 0) and (alertType = 55 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 4 or messageType = 0) and (alertType = 55 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 4 or messageType = 0) and (alertType = 55 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 4 or messageType = 0) and (alertType = 55 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_PAGER if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_PAGER,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (55, 4,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_PAGER_PREAMBLE + @FORMAT_PAGER + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (55, 8,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((8=1 OR 8=512 OR 8=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 8 or messageType = 0) and (alertType = 55 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8 or messageType = 0) and (alertType = 55 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8 or messageType = 0) and (alertType = 55 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8 or messageType = 0) and (alertType = 55 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_PAGER if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_PAGER,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (55, 8,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (55, 512,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((512=1 OR 512=512 OR 512=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 512 or messageType = 0) and (alertType = 55 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 512 or messageType = 0) and (alertType = 55 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 512 or messageType = 0) and (alertType = 55 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 512 or messageType = 0) and (alertType = 55 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (55, 512,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (55, 1024,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((1024=1 OR 1024=512 OR 1024=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 1024 or messageType = 0) and (alertType = 55 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1024 or messageType = 0) and (alertType = 55 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1024 or messageType = 0) and (alertType = 55 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1024 or messageType = 0) and (alertType = 55 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (55, 1024,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + @STD_POSTAMBLE	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')   SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')   SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')  insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (55, 8192,  @localeId, @FORMAT,0)
set @FORMAT = @STD_PAGER_PREAMBLE + @FORMAT_PAGER + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (55, 32768,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((32768=1 OR 32768=512 OR 32768=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 32768 or messageType = 0) and (alertType = 55 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 32768 or messageType = 0) and (alertType = 55 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 32768 or messageType = 0) and (alertType = 55 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 32768 or messageType = 0) and (alertType = 55 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_PAGER if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_PAGER,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (55, 32768,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (55, 1048576,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((1048576=1 OR 1048576=512 OR 1048576=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 1048576 or messageType = 0) and (alertType = 55 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1048576 or messageType = 0) and (alertType = 55 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1048576 or messageType = 0) and (alertType = 55 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1048576 or messageType = 0) and (alertType = 55 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (55, 1048576,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (55, 131072,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((131072=1 OR 131072=512 OR 131072=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 131072 or messageType = 0) and (alertType = 55 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 131072 or messageType = 0) and (alertType = 55 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 131072 or messageType = 0) and (alertType = 55 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 131072 or messageType = 0) and (alertType = 55 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (55, 131072,  @localeId, @FORMAT,1)	end
if @isJson = 1		begin		set @FORMAT = '{' + @STD_JSON_PREAMBLE + @FORMAT_JSON + '}'insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (55, 8192,  @localeId, @FORMAT, 1)	end	else	begin		set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 8192 or messageType = 0) and (alertType = 55 or alertType = 0) and isHtml = 1 order by priority desc),'') 	set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8192 or messageType = 0) and (alertType = 55 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') 	set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8192 or messageType = 0) and (alertType = 55 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') 	set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8192 or messageType = 0) and (alertType = 55 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 	set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (55, 8192,  @localeId, @FORMAT,1)	end
END
-- ==================
-- Media Inventory
-- ==================
if exists(select 1 from NTalerttype WITH (READUNCOMMITTED) where id=7) begin
SET @FORMAT_EMAIL = 'MsgTab_ '    + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(217 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(35 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(218 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(23 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(249 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(57 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(219 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(36 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(220 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(38 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(221 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(37 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(413 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(412 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(222 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(39 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''
SET @FORMAT_PAGER = (select Message from ##EvLocaleMsgs where MessageID=(218 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(23 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(249 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(57 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(217 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(35 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(219 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(36 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(220 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(38 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(221 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(37 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(413 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(412 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(222 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(39 | (CAST(POWER(2, 24) AS BIGINT) * 74)))
SET @FORMAT_JSON =
'"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (217 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (35 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (218 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (23 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (249 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (57 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (219 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (36 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (220 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (38 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (221 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (37 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (413 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (412 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (222 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (39 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '"'
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + @STD_POSTAMBLE	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (7, 1,  @localeId, @FORMAT,0)	set @common_Html_Postamble = @STD_POSTAMBLE  if ((1=1 OR 1=512 OR 1=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 1 or messageType = 0) and (alertType = 7 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1 or messageType = 0) and (alertType = 7 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1 or messageType = 0) and (alertType = 7 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1 or messageType = 0) and (alertType = 7 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (7, 1,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_PAGER_PREAMBLE + @FORMAT_PAGER + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (7, 4,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((4=1 OR 4=512 OR 4=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 4 or messageType = 0) and (alertType = 7 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 4 or messageType = 0) and (alertType = 7 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 4 or messageType = 0) and (alertType = 7 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 4 or messageType = 0) and (alertType = 7 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_PAGER if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_PAGER,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (7, 4,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_PAGER_PREAMBLE + @FORMAT_PAGER + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (7, 8,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((8=1 OR 8=512 OR 8=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 8 or messageType = 0) and (alertType = 7 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8 or messageType = 0) and (alertType = 7 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8 or messageType = 0) and (alertType = 7 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8 or messageType = 0) and (alertType = 7 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_PAGER if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_PAGER,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (7, 8,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (7, 512,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((512=1 OR 512=512 OR 512=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 512 or messageType = 0) and (alertType = 7 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 512 or messageType = 0) and (alertType = 7 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 512 or messageType = 0) and (alertType = 7 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 512 or messageType = 0) and (alertType = 7 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (7, 512,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (7, 1024,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((1024=1 OR 1024=512 OR 1024=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 1024 or messageType = 0) and (alertType = 7 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1024 or messageType = 0) and (alertType = 7 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1024 or messageType = 0) and (alertType = 7 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1024 or messageType = 0) and (alertType = 7 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (7, 1024,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + @STD_POSTAMBLE	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')   SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')   SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')  insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (7, 8192,  @localeId, @FORMAT,0)
set @FORMAT = @STD_PAGER_PREAMBLE + @FORMAT_PAGER + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (7, 32768,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((32768=1 OR 32768=512 OR 32768=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 32768 or messageType = 0) and (alertType = 7 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 32768 or messageType = 0) and (alertType = 7 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 32768 or messageType = 0) and (alertType = 7 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 32768 or messageType = 0) and (alertType = 7 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_PAGER if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_PAGER,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (7, 32768,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (7, 1048576,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((1048576=1 OR 1048576=512 OR 1048576=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 1048576 or messageType = 0) and (alertType = 7 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1048576 or messageType = 0) and (alertType = 7 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1048576 or messageType = 0) and (alertType = 7 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1048576 or messageType = 0) and (alertType = 7 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (7, 1048576,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (7, 131072,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((131072=1 OR 131072=512 OR 131072=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 131072 or messageType = 0) and (alertType = 7 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 131072 or messageType = 0) and (alertType = 7 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 131072 or messageType = 0) and (alertType = 7 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 131072 or messageType = 0) and (alertType = 7 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (7, 131072,  @localeId, @FORMAT,1)	end
if @isJson = 1		begin		set @FORMAT = '{' + @STD_JSON_PREAMBLE + @FORMAT_JSON + '}'insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (7, 8192,  @localeId, @FORMAT, 1)	end	else	begin		set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 8192 or messageType = 0) and (alertType = 7 or alertType = 0) and isHtml = 1 order by priority desc),'') 	set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8192 or messageType = 0) and (alertType = 7 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') 	set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8192 or messageType = 0) and (alertType = 7 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') 	set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8192 or messageType = 0) and (alertType = 7 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 	set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (7, 8192,  @localeId, @FORMAT,1)	end
END
-- ==================
-- Media Erase
-- ==================
if exists(select 1 from NTalerttype WITH (READUNCOMMITTED) where id=9) begin
SET @FORMAT_EMAIL = 'MsgTab_ ' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(217 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(35 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(218 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(23 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(249 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(57 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(219 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(36 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(220 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(38 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(221 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(37 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(236 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(60 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(237 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(61 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(238 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(62 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(413 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(412 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(222 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(39 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''
SET @FORMAT_PAGER = (select Message from ##EvLocaleMsgs where MessageID=(218 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(23 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(249 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(57 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(217 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(35 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(219 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(36 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(220 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(38 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(221 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(37 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(413 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(412 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(222 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(39 | (CAST(POWER(2, 24) AS BIGINT) * 74)))
SET @FORMAT_JSON =
'"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (217 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (35 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (218 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (23 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (249 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (57 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (219 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (36 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (220 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (38 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (221 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (37 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (236 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (60 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (237 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (61 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (238 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (62 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (413 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (412 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (222 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (39 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '"'
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + @STD_POSTAMBLE	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (9, 1,  @localeId, @FORMAT,0)	set @common_Html_Postamble = @STD_POSTAMBLE  if ((1=1 OR 1=512 OR 1=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 1 or messageType = 0) and (alertType = 9 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1 or messageType = 0) and (alertType = 9 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1 or messageType = 0) and (alertType = 9 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1 or messageType = 0) and (alertType = 9 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (9, 1,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_PAGER_PREAMBLE + @FORMAT_PAGER + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (9, 4,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((4=1 OR 4=512 OR 4=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 4 or messageType = 0) and (alertType = 9 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 4 or messageType = 0) and (alertType = 9 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 4 or messageType = 0) and (alertType = 9 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 4 or messageType = 0) and (alertType = 9 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_PAGER if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_PAGER,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (9, 4,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_PAGER_PREAMBLE + @FORMAT_PAGER + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (9, 8,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((8=1 OR 8=512 OR 8=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 8 or messageType = 0) and (alertType = 9 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8 or messageType = 0) and (alertType = 9 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8 or messageType = 0) and (alertType = 9 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8 or messageType = 0) and (alertType = 9 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_PAGER if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_PAGER,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (9, 8,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (9, 512,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((512=1 OR 512=512 OR 512=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 512 or messageType = 0) and (alertType = 9 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 512 or messageType = 0) and (alertType = 9 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 512 or messageType = 0) and (alertType = 9 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 512 or messageType = 0) and (alertType = 9 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (9, 512,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (9, 1024,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((1024=1 OR 1024=512 OR 1024=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 1024 or messageType = 0) and (alertType = 9 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1024 or messageType = 0) and (alertType = 9 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1024 or messageType = 0) and (alertType = 9 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1024 or messageType = 0) and (alertType = 9 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (9, 1024,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + @STD_POSTAMBLE	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')   SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')   SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')  insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (9, 8192,  @localeId, @FORMAT,0)
set @FORMAT = @STD_PAGER_PREAMBLE + @FORMAT_PAGER + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (9, 32768,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((32768=1 OR 32768=512 OR 32768=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 32768 or messageType = 0) and (alertType = 9 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 32768 or messageType = 0) and (alertType = 9 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 32768 or messageType = 0) and (alertType = 9 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 32768 or messageType = 0) and (alertType = 9 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_PAGER if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_PAGER,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (9, 32768,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (9, 1048576,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((1048576=1 OR 1048576=512 OR 1048576=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 1048576 or messageType = 0) and (alertType = 9 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1048576 or messageType = 0) and (alertType = 9 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1048576 or messageType = 0) and (alertType = 9 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1048576 or messageType = 0) and (alertType = 9 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (9, 1048576,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (9, 131072,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((131072=1 OR 131072=512 OR 131072=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 131072 or messageType = 0) and (alertType = 9 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 131072 or messageType = 0) and (alertType = 9 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 131072 or messageType = 0) and (alertType = 9 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 131072 or messageType = 0) and (alertType = 9 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (9, 131072,  @localeId, @FORMAT,1)	end
if @isJson = 1		begin		set @FORMAT = '{' + @STD_JSON_PREAMBLE + @FORMAT_JSON + '}'insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (9, 8192,  @localeId, @FORMAT, 1)	end	else	begin		set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 8192 or messageType = 0) and (alertType = 9 or alertType = 0) and isHtml = 1 order by priority desc),'') 	set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8192 or messageType = 0) and (alertType = 9 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') 	set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8192 or messageType = 0) and (alertType = 9 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') 	set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8192 or messageType = 0) and (alertType = 9 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 	set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (9, 8192,  @localeId, @FORMAT,1)	end
END
-- =====================
-- Clients configuration
-- =====================
if exists(select 1 from NTalerttype WITH (READUNCOMMITTED) where id=10) begin
SET @FORMAT_EMAIL = 'MsgTab_ ' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs  where MessageID=(269 | (CAST(POWER(2, 24) AS BIGINT) * 74))) +  ' ' +'TableDataSep' + 'MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(218 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(23 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(225 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(1384 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(226 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(43 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(227 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(44 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(228 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(45 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(229 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(46 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(239 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(63 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(241 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(164 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(245 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(182 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(254 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(271 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(406 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(65 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''
SET @FORMAT_PAGER = (select Message from ##EvLocaleMsgs where MessageID=(225 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(1384 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(218 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(23 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(226 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(43 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(227 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(44 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(228 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(45 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(229 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(46 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(239 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(63 | (CAST(POWER(2, 24) AS BIGINT) * 74)))
SET @FORMAT_JSON =
'"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (218 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (23 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (225 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (1384 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (226 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (43 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (227 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (44 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (228 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (45 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (229 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (46 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (239 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (63 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (241 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (164 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (245 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (182 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (254 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (271 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (406 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (65 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '"'
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + @STD_POSTAMBLE	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (10, 1,  @localeId, @FORMAT,0)	set @common_Html_Postamble = @STD_POSTAMBLE  if ((1=1 OR 1=512 OR 1=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 1 or messageType = 0) and (alertType = 10 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1 or messageType = 0) and (alertType = 10 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1 or messageType = 0) and (alertType = 10 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1 or messageType = 0) and (alertType = 10 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (10, 1,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_PAGER_PREAMBLE + @FORMAT_PAGER + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (10, 4,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((4=1 OR 4=512 OR 4=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 4 or messageType = 0) and (alertType = 10 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 4 or messageType = 0) and (alertType = 10 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 4 or messageType = 0) and (alertType = 10 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 4 or messageType = 0) and (alertType = 10 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_PAGER if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_PAGER,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (10, 4,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_PAGER_PREAMBLE + @FORMAT_PAGER + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (10, 8,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((8=1 OR 8=512 OR 8=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 8 or messageType = 0) and (alertType = 10 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8 or messageType = 0) and (alertType = 10 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8 or messageType = 0) and (alertType = 10 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8 or messageType = 0) and (alertType = 10 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_PAGER if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_PAGER,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (10, 8,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (10, 512,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((512=1 OR 512=512 OR 512=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 512 or messageType = 0) and (alertType = 10 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 512 or messageType = 0) and (alertType = 10 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 512 or messageType = 0) and (alertType = 10 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 512 or messageType = 0) and (alertType = 10 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (10, 512,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (10, 1024,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((1024=1 OR 1024=512 OR 1024=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 1024 or messageType = 0) and (alertType = 10 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1024 or messageType = 0) and (alertType = 10 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1024 or messageType = 0) and (alertType = 10 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1024 or messageType = 0) and (alertType = 10 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (10, 1024,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + @STD_POSTAMBLE	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')   SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')   SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')  insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (10, 8192,  @localeId, @FORMAT,0)
set @FORMAT = @STD_PAGER_PREAMBLE + @FORMAT_PAGER + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (10, 32768,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((32768=1 OR 32768=512 OR 32768=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 32768 or messageType = 0) and (alertType = 10 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 32768 or messageType = 0) and (alertType = 10 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 32768 or messageType = 0) and (alertType = 10 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 32768 or messageType = 0) and (alertType = 10 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_PAGER if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_PAGER,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (10, 32768,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (10, 1048576,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((1048576=1 OR 1048576=512 OR 1048576=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 1048576 or messageType = 0) and (alertType = 10 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1048576 or messageType = 0) and (alertType = 10 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1048576 or messageType = 0) and (alertType = 10 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1048576 or messageType = 0) and (alertType = 10 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (10, 1048576,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (10, 131072,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((131072=1 OR 131072=512 OR 131072=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 131072 or messageType = 0) and (alertType = 10 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 131072 or messageType = 0) and (alertType = 10 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 131072 or messageType = 0) and (alertType = 10 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 131072 or messageType = 0) and (alertType = 10 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (10, 131072,  @localeId, @FORMAT,1)	end
if @isJson = 1		begin		set @FORMAT = '{' + @STD_JSON_PREAMBLE + @FORMAT_JSON + '}'insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (10, 8192,  @localeId, @FORMAT, 1)	end	else	begin		set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 8192 or messageType = 0) and (alertType = 10 or alertType = 0) and isHtml = 1 order by priority desc),'') 	set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8192 or messageType = 0) and (alertType = 10 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') 	set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8192 or messageType = 0) and (alertType = 10 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') 	set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8192 or messageType = 0) and (alertType = 10 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 	set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (10, 8192,  @localeId, @FORMAT,1)	end
END
-- ======================
-- Commcell configuration
-- ======================
if exists(select 1 from NTalerttype WITH (READUNCOMMITTED) where id=12) begin
SET @FORMAT_EMAIL = 'MsgTab_' +  (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(240 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(167 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(241 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(164 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '--'ALERT_TEMPLATE_DISK_SPACE_LOW'
+ '<MsgTokSep ' + CAST(18 as nvarchar(20)) + ' '+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(254 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(271 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '--'ALERT_TEMPLATE_MEDIA_SPACE_LEFT'
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(242 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(65 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(245 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(182 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ ' MsgTokSep> '			--'ALERT_TEMPLATE_FREE_SPACE_AVAIL'
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(218 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(23 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(243 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(66 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(225 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(1384 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(226 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(43 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(227 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(44 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(244 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(68 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ '<MsgTokSep ' + CAST(55 as nvarchar(20)) + ' '+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(461 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(462 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(463 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(464 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(465 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(466 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(467 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(468 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ ' MsgTokSep> '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(239 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(63 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''
SET @FORMAT_PAGER = (select Message from ##EvLocaleMsgs where MessageID=(240 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(167 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(239 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(63 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(218 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(23 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(241 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(164 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(242 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(65 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(243 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(66 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(225 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(1384 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(226 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(43 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(227 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(44 | (CAST(POWER(2, 24) AS BIGINT) * 74)))
SET @FORMAT_JSON =
'"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (240 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (167 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (241 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (164 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '--'ALERT_TEMPLATE_DISK_SPACE_LOW'
+ '<MsgTokSep ' + CAST(18 as nvarchar(20)) + ' '+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (254 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (271 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '--'ALERT_TEMPLATE_MEDIA_SPACE_LEFT'
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (242 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (65 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (245 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (182 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ ' MsgTokSep> '			--'ALERT_TEMPLATE_FREE_SPACE_AVAIL'
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (218 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (23 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (243 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (66 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (225 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (1384 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (226 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (43 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (227 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (44 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (244 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (68 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '<MsgTokSep ' + CAST(55 as nvarchar(20)) + ' '+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (461 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (462 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (463 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (464 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (465 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (466 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (467 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (468 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ ' MsgTokSep> '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (239 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (63 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '"'
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + @STD_POSTAMBLE	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (12, 1,  @localeId, @FORMAT,0)	set @common_Html_Postamble = @STD_POSTAMBLE  if ((1=1 OR 1=512 OR 1=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 1 or messageType = 0) and (alertType = 12 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1 or messageType = 0) and (alertType = 12 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1 or messageType = 0) and (alertType = 12 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1 or messageType = 0) and (alertType = 12 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (12, 1,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_PAGER_PREAMBLE + @FORMAT_PAGER + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (12, 4,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((4=1 OR 4=512 OR 4=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 4 or messageType = 0) and (alertType = 12 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 4 or messageType = 0) and (alertType = 12 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 4 or messageType = 0) and (alertType = 12 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 4 or messageType = 0) and (alertType = 12 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_PAGER if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_PAGER,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (12, 4,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_PAGER_PREAMBLE + @FORMAT_PAGER + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (12, 8,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((8=1 OR 8=512 OR 8=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 8 or messageType = 0) and (alertType = 12 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8 or messageType = 0) and (alertType = 12 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8 or messageType = 0) and (alertType = 12 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8 or messageType = 0) and (alertType = 12 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_PAGER if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_PAGER,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (12, 8,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (12, 512,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((512=1 OR 512=512 OR 512=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 512 or messageType = 0) and (alertType = 12 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 512 or messageType = 0) and (alertType = 12 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 512 or messageType = 0) and (alertType = 12 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 512 or messageType = 0) and (alertType = 12 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (12, 512,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (12, 1024,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((1024=1 OR 1024=512 OR 1024=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 1024 or messageType = 0) and (alertType = 12 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1024 or messageType = 0) and (alertType = 12 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1024 or messageType = 0) and (alertType = 12 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1024 or messageType = 0) and (alertType = 12 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (12, 1024,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + @STD_POSTAMBLE	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')   SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')   SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')  insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (12, 8192,  @localeId, @FORMAT,0)
set @FORMAT = @STD_PAGER_PREAMBLE + @FORMAT_PAGER + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (12, 32768,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((32768=1 OR 32768=512 OR 32768=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 32768 or messageType = 0) and (alertType = 12 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 32768 or messageType = 0) and (alertType = 12 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 32768 or messageType = 0) and (alertType = 12 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 32768 or messageType = 0) and (alertType = 12 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_PAGER if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_PAGER,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (12, 32768,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (12, 1048576,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((1048576=1 OR 1048576=512 OR 1048576=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 1048576 or messageType = 0) and (alertType = 12 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1048576 or messageType = 0) and (alertType = 12 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1048576 or messageType = 0) and (alertType = 12 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1048576 or messageType = 0) and (alertType = 12 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (12, 1048576,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (12, 131072,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((131072=1 OR 131072=512 OR 131072=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 131072 or messageType = 0) and (alertType = 12 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 131072 or messageType = 0) and (alertType = 12 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 131072 or messageType = 0) and (alertType = 12 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 131072 or messageType = 0) and (alertType = 12 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (12, 131072,  @localeId, @FORMAT,1)	end
if @isJson = 1		begin		set @FORMAT = '{' + @STD_JSON_PREAMBLE + @FORMAT_JSON + '}'insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (12, 8192,  @localeId, @FORMAT, 1)	end	else	begin		set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 8192 or messageType = 0) and (alertType = 12 or alertType = 0) and isHtml = 1 order by priority desc),'') 	set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8192 or messageType = 0) and (alertType = 12 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') 	set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8192 or messageType = 0) and (alertType = 12 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') 	set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8192 or messageType = 0) and (alertType = 12 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 	set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (12, 8192,  @localeId, @FORMAT,1)	end
END
-- ========================
-- MediaAgent configuration
-- ========================
if exists(select 1 from NTalerttype WITH (READUNCOMMITTED) where id=13) begin
SET @FORMAT_EMAIL = 'MsgTab_ '    + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(244 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(68 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ '<MsgTokSep ' +  CAST(70 as nvarchar(20))+','+ CAST(72 as nvarchar(20))+','+ CAST(84 as nvarchar(20)) + ' '+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(860 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(859 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(223 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(40 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(224 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(41 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ ' MsgTokSep> '
+ '<MsgTokSep ' + CAST(70 as nvarchar(20))+','+ CAST(84 as nvarchar(20))+ ' '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(996 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(997 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ ' MsgTokSep> '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(239 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(63 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(218 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(23 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(1302 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(271 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(241 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(164 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(406 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(65 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(245 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(182 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ '<MsgTokSep ' + CAST(30 as nvarchar(20)) + ' '+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(861 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(862 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ ' MsgTokSep> '
+ '<MsgTokSep ' + CAST(84 as nvarchar(20)) + ' '+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(1267 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(1268 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''
+ ' MsgTokSep> '
SET @FORMAT_PAGER = (select Message from ##EvLocaleMsgs where MessageID=(244 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(68 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(239 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(63 | (CAST(POWER(2, 24) AS BIGINT) * 74)))
+ (select Message from ##EvLocaleMsgs where MessageID=(218 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(23 | (CAST(POWER(2, 24) AS BIGINT) * 74)))
SET @FORMAT_JSON =
'"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (244 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (68 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '<MsgTokSep ' +  CAST(70 as nvarchar(20))+','+ CAST(72 as nvarchar(20))+','+ CAST(84 as nvarchar(20)) + ' '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (860 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (859 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (223 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (40 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (224 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (41 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ ' MsgTokSep> '
+ '<MsgTokSep ' + CAST(70 as nvarchar(20))+','+ CAST(84 as nvarchar(20))+ ' '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (996 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (997 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ ' MsgTokSep> '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (239 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (63 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (218 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (23 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (1302 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (271 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (241 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (164 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (406 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (65 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (245 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (182 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '<MsgTokSep ' + CAST(30 as nvarchar(20)) + ' '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (861 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (862 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ ' MsgTokSep> '
+ '<MsgTokSep ' + CAST(84 as nvarchar(20)) + ' '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (1267 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (1268 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '"'
+ ' MsgTokSep> '
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + @STD_POSTAMBLE	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (13, 1,  @localeId, @FORMAT,0)	set @common_Html_Postamble = @STD_POSTAMBLE  if ((1=1 OR 1=512 OR 1=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 1 or messageType = 0) and (alertType = 13 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1 or messageType = 0) and (alertType = 13 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1 or messageType = 0) and (alertType = 13 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1 or messageType = 0) and (alertType = 13 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (13, 1,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_PAGER_PREAMBLE + @FORMAT_PAGER + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (13, 4,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((4=1 OR 4=512 OR 4=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 4 or messageType = 0) and (alertType = 13 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 4 or messageType = 0) and (alertType = 13 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 4 or messageType = 0) and (alertType = 13 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 4 or messageType = 0) and (alertType = 13 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_PAGER if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_PAGER,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (13, 4,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_PAGER_PREAMBLE + @FORMAT_PAGER + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (13, 8,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((8=1 OR 8=512 OR 8=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 8 or messageType = 0) and (alertType = 13 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8 or messageType = 0) and (alertType = 13 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8 or messageType = 0) and (alertType = 13 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8 or messageType = 0) and (alertType = 13 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_PAGER if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_PAGER,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (13, 8,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (13, 512,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((512=1 OR 512=512 OR 512=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 512 or messageType = 0) and (alertType = 13 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 512 or messageType = 0) and (alertType = 13 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 512 or messageType = 0) and (alertType = 13 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 512 or messageType = 0) and (alertType = 13 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (13, 512,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (13, 1024,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((1024=1 OR 1024=512 OR 1024=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 1024 or messageType = 0) and (alertType = 13 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1024 or messageType = 0) and (alertType = 13 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1024 or messageType = 0) and (alertType = 13 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1024 or messageType = 0) and (alertType = 13 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (13, 1024,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + @STD_POSTAMBLE	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')   SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')   SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')  insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (13, 8192,  @localeId, @FORMAT,0)
set @FORMAT = @STD_PAGER_PREAMBLE + @FORMAT_PAGER + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (13, 32768,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((32768=1 OR 32768=512 OR 32768=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 32768 or messageType = 0) and (alertType = 13 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 32768 or messageType = 0) and (alertType = 13 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 32768 or messageType = 0) and (alertType = 13 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 32768 or messageType = 0) and (alertType = 13 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_PAGER if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_PAGER,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (13, 32768,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (13, 1048576,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((1048576=1 OR 1048576=512 OR 1048576=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 1048576 or messageType = 0) and (alertType = 13 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1048576 or messageType = 0) and (alertType = 13 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1048576 or messageType = 0) and (alertType = 13 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1048576 or messageType = 0) and (alertType = 13 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (13, 1048576,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (13, 131072,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((131072=1 OR 131072=512 OR 131072=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 131072 or messageType = 0) and (alertType = 13 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 131072 or messageType = 0) and (alertType = 13 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 131072 or messageType = 0) and (alertType = 13 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 131072 or messageType = 0) and (alertType = 13 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (13, 131072,  @localeId, @FORMAT,1)	end
if @isJson = 1		begin		set @FORMAT = '{' + @STD_JSON_PREAMBLE + @FORMAT_JSON + '}'insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (13, 8192,  @localeId, @FORMAT, 1)	end	else	begin		set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 8192 or messageType = 0) and (alertType = 13 or alertType = 0) and isHtml = 1 order by priority desc),'') 	set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8192 or messageType = 0) and (alertType = 13 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') 	set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8192 or messageType = 0) and (alertType = 13 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') 	set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8192 or messageType = 0) and (alertType = 13 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 	set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (13, 8192,  @localeId, @FORMAT,1)	end
END
-- =======================
-- Schedular configuration
-- =======================
if exists(select 1 from NTalerttype WITH (READUNCOMMITTED) where id=14) begin
SET @FORMAT_EMAIL = 'MsgTab_ '    + (select Message from ##EvLocaleMsgs  where MessageID=(246 | (CAST(POWER(2, 24) AS BIGINT) * 74))) +  ' ' + 'MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(940 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(396 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(247 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(69 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(239 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(63 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''
--SET @FORMAT_PAGER = br_ntPopulateAlertTemplateV2_EMSG(@localeId, ALERT_TEMPLATE_SCHED_NAME, ALERT_TOKEN_SCHEDULE_NAME)
SET @FORMAT_PAGER = (select Message from ##EvLocaleMsgs where MessageID=(247 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(69 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(940 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(396 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(239 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(63 | (CAST(POWER(2, 24) AS BIGINT) * 74)))
SET @FORMAT_JSON =
'"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (940 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (396 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (247 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (69 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (239 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (63 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '"'
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + @STD_POSTAMBLE	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (14, 1,  @localeId, @FORMAT,0)	set @common_Html_Postamble = @STD_POSTAMBLE  if ((1=1 OR 1=512 OR 1=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 1 or messageType = 0) and (alertType = 14 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1 or messageType = 0) and (alertType = 14 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1 or messageType = 0) and (alertType = 14 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1 or messageType = 0) and (alertType = 14 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (14, 1,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_PAGER_PREAMBLE + @FORMAT_PAGER + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (14, 4,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((4=1 OR 4=512 OR 4=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 4 or messageType = 0) and (alertType = 14 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 4 or messageType = 0) and (alertType = 14 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 4 or messageType = 0) and (alertType = 14 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 4 or messageType = 0) and (alertType = 14 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_PAGER if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_PAGER,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (14, 4,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_PAGER_PREAMBLE + @FORMAT_PAGER + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (14, 8,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((8=1 OR 8=512 OR 8=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 8 or messageType = 0) and (alertType = 14 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8 or messageType = 0) and (alertType = 14 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8 or messageType = 0) and (alertType = 14 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8 or messageType = 0) and (alertType = 14 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_PAGER if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_PAGER,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (14, 8,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (14, 512,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((512=1 OR 512=512 OR 512=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 512 or messageType = 0) and (alertType = 14 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 512 or messageType = 0) and (alertType = 14 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 512 or messageType = 0) and (alertType = 14 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 512 or messageType = 0) and (alertType = 14 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (14, 512,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (14, 1024,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((1024=1 OR 1024=512 OR 1024=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 1024 or messageType = 0) and (alertType = 14 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1024 or messageType = 0) and (alertType = 14 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1024 or messageType = 0) and (alertType = 14 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1024 or messageType = 0) and (alertType = 14 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (14, 1024,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + @STD_POSTAMBLE	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')   SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')   SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')  insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (14, 8192,  @localeId, @FORMAT,0)
set @FORMAT = @STD_PAGER_PREAMBLE + @FORMAT_PAGER + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (14, 32768,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((32768=1 OR 32768=512 OR 32768=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 32768 or messageType = 0) and (alertType = 14 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 32768 or messageType = 0) and (alertType = 14 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 32768 or messageType = 0) and (alertType = 14 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 32768 or messageType = 0) and (alertType = 14 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_PAGER if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_PAGER,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (14, 32768,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (14, 1048576,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((1048576=1 OR 1048576=512 OR 1048576=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 1048576 or messageType = 0) and (alertType = 14 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1048576 or messageType = 0) and (alertType = 14 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1048576 or messageType = 0) and (alertType = 14 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1048576 or messageType = 0) and (alertType = 14 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (14, 1048576,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (14, 131072,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((131072=1 OR 131072=512 OR 131072=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 131072 or messageType = 0) and (alertType = 14 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 131072 or messageType = 0) and (alertType = 14 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 131072 or messageType = 0) and (alertType = 14 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 131072 or messageType = 0) and (alertType = 14 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (14, 131072,  @localeId, @FORMAT,1)	end
if @isJson = 1		begin		set @FORMAT = '{' + @STD_JSON_PREAMBLE + @FORMAT_JSON + '}'insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (14, 8192,  @localeId, @FORMAT, 1)	end	else	begin		set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 8192 or messageType = 0) and (alertType = 14 or alertType = 0) and isHtml = 1 order by priority desc),'') 	set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8192 or messageType = 0) and (alertType = 14 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') 	set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8192 or messageType = 0) and (alertType = 14 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') 	set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8192 or messageType = 0) and (alertType = 14 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 	set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (14, 8192,  @localeId, @FORMAT,1)	end
END
-- ==============
-- Storage Policy
-- ==============
if exists(select 1 from NTalerttype WITH (READUNCOMMITTED) where id=15) begin
SET @FORMAT_EMAIL = 'MsgTab_ ' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(223 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(40 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(224 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(41 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(239 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(63 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''
SET @FORMAT_PAGER = (select Message from ##EvLocaleMsgs where MessageID=(223 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(40 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+  (select Message from ##EvLocaleMsgs where MessageID=(224 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(41 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+  (select Message from ##EvLocaleMsgs where MessageID=(239 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(63 | (CAST(POWER(2, 24) AS BIGINT) * 74)))
SET @FORMAT_JSON =
'"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (223 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (40 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (224 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (41 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (239 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (63 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '"'
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + @STD_POSTAMBLE	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (15, 1,  @localeId, @FORMAT,0)	set @common_Html_Postamble = @STD_POSTAMBLE  if ((1=1 OR 1=512 OR 1=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 1 or messageType = 0) and (alertType = 15 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1 or messageType = 0) and (alertType = 15 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1 or messageType = 0) and (alertType = 15 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1 or messageType = 0) and (alertType = 15 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (15, 1,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_PAGER_PREAMBLE + @FORMAT_PAGER + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (15, 4,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((4=1 OR 4=512 OR 4=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 4 or messageType = 0) and (alertType = 15 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 4 or messageType = 0) and (alertType = 15 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 4 or messageType = 0) and (alertType = 15 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 4 or messageType = 0) and (alertType = 15 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_PAGER if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_PAGER,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (15, 4,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_PAGER_PREAMBLE + @FORMAT_PAGER + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (15, 8,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((8=1 OR 8=512 OR 8=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 8 or messageType = 0) and (alertType = 15 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8 or messageType = 0) and (alertType = 15 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8 or messageType = 0) and (alertType = 15 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8 or messageType = 0) and (alertType = 15 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_PAGER if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_PAGER,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (15, 8,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (15, 512,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((512=1 OR 512=512 OR 512=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 512 or messageType = 0) and (alertType = 15 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 512 or messageType = 0) and (alertType = 15 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 512 or messageType = 0) and (alertType = 15 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 512 or messageType = 0) and (alertType = 15 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (15, 512,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (15, 1024,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((1024=1 OR 1024=512 OR 1024=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 1024 or messageType = 0) and (alertType = 15 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1024 or messageType = 0) and (alertType = 15 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1024 or messageType = 0) and (alertType = 15 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1024 or messageType = 0) and (alertType = 15 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (15, 1024,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + @STD_POSTAMBLE	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')   SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')   SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')  insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (15, 8192,  @localeId, @FORMAT,0)
set @FORMAT = @STD_PAGER_PREAMBLE + @FORMAT_PAGER + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (15, 32768,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((32768=1 OR 32768=512 OR 32768=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 32768 or messageType = 0) and (alertType = 15 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 32768 or messageType = 0) and (alertType = 15 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 32768 or messageType = 0) and (alertType = 15 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 32768 or messageType = 0) and (alertType = 15 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_PAGER if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_PAGER,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (15, 32768,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (15, 1048576,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((1048576=1 OR 1048576=512 OR 1048576=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 1048576 or messageType = 0) and (alertType = 15 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1048576 or messageType = 0) and (alertType = 15 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1048576 or messageType = 0) and (alertType = 15 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1048576 or messageType = 0) and (alertType = 15 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (15, 1048576,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (15, 131072,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((131072=1 OR 131072=512 OR 131072=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 131072 or messageType = 0) and (alertType = 15 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 131072 or messageType = 0) and (alertType = 15 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 131072 or messageType = 0) and (alertType = 15 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 131072 or messageType = 0) and (alertType = 15 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (15, 131072,  @localeId, @FORMAT,1)	end
if @isJson = 1		begin		set @FORMAT = '{' + @STD_JSON_PREAMBLE + @FORMAT_JSON + '}'insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (15, 8192,  @localeId, @FORMAT, 1)	end	else	begin		set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 8192 or messageType = 0) and (alertType = 15 or alertType = 0) and isHtml = 1 order by priority desc),'') 	set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8192 or messageType = 0) and (alertType = 15 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') 	set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8192 or messageType = 0) and (alertType = 15 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') 	set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8192 or messageType = 0) and (alertType = 15 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 	set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (15, 8192,  @localeId, @FORMAT,1)	end
END
-- =======
-- Library
-- =======
if exists(select 1 from NTalerttype WITH (READUNCOMMITTED) where id=16) begin
SET @FORMAT_EMAIL = 'MsgTab_ ' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs  where MessageID=(269 | (CAST(POWER(2, 24) AS BIGINT) * 74))) +  ' ' + 'TableDataSep'+'MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(249 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(57 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(239 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(63 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''
SET @FORMAT_PAGER = (select Message from ##EvLocaleMsgs where MessageID=(249 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(57 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(239 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(63 | (CAST(POWER(2, 24) AS BIGINT) * 74)))
SET @FORMAT_JSON =
'"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (249 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (57 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (239 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (63 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '"'
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + @STD_POSTAMBLE	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (16, 1,  @localeId, @FORMAT,0)	set @common_Html_Postamble = @STD_POSTAMBLE  if ((1=1 OR 1=512 OR 1=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 1 or messageType = 0) and (alertType = 16 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1 or messageType = 0) and (alertType = 16 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1 or messageType = 0) and (alertType = 16 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1 or messageType = 0) and (alertType = 16 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (16, 1,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_PAGER_PREAMBLE + @FORMAT_PAGER + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (16, 4,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((4=1 OR 4=512 OR 4=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 4 or messageType = 0) and (alertType = 16 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 4 or messageType = 0) and (alertType = 16 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 4 or messageType = 0) and (alertType = 16 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 4 or messageType = 0) and (alertType = 16 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_PAGER if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_PAGER,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (16, 4,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_PAGER_PREAMBLE + @FORMAT_PAGER + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (16, 8,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((8=1 OR 8=512 OR 8=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 8 or messageType = 0) and (alertType = 16 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8 or messageType = 0) and (alertType = 16 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8 or messageType = 0) and (alertType = 16 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8 or messageType = 0) and (alertType = 16 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_PAGER if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_PAGER,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (16, 8,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (16, 512,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((512=1 OR 512=512 OR 512=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 512 or messageType = 0) and (alertType = 16 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 512 or messageType = 0) and (alertType = 16 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 512 or messageType = 0) and (alertType = 16 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 512 or messageType = 0) and (alertType = 16 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (16, 512,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (16, 1024,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((1024=1 OR 1024=512 OR 1024=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 1024 or messageType = 0) and (alertType = 16 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1024 or messageType = 0) and (alertType = 16 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1024 or messageType = 0) and (alertType = 16 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1024 or messageType = 0) and (alertType = 16 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (16, 1024,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + @STD_POSTAMBLE	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')   SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')   SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')  insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (16, 8192,  @localeId, @FORMAT,0)
set @FORMAT = @STD_PAGER_PREAMBLE + @FORMAT_PAGER + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (16, 32768,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((32768=1 OR 32768=512 OR 32768=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 32768 or messageType = 0) and (alertType = 16 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 32768 or messageType = 0) and (alertType = 16 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 32768 or messageType = 0) and (alertType = 16 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 32768 or messageType = 0) and (alertType = 16 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_PAGER if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_PAGER,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (16, 32768,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (16, 1048576,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((1048576=1 OR 1048576=512 OR 1048576=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 1048576 or messageType = 0) and (alertType = 16 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1048576 or messageType = 0) and (alertType = 16 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1048576 or messageType = 0) and (alertType = 16 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1048576 or messageType = 0) and (alertType = 16 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (16, 1048576,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (16, 131072,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((131072=1 OR 131072=512 OR 131072=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 131072 or messageType = 0) and (alertType = 16 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 131072 or messageType = 0) and (alertType = 16 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 131072 or messageType = 0) and (alertType = 16 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 131072 or messageType = 0) and (alertType = 16 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (16, 131072,  @localeId, @FORMAT,1)	end
if @isJson = 1		begin		set @FORMAT = '{' + @STD_JSON_PREAMBLE + @FORMAT_JSON + '}'insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (16, 8192,  @localeId, @FORMAT, 1)	end	else	begin		set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 8192 or messageType = 0) and (alertType = 16 or alertType = 0) and isHtml = 1 order by priority desc),'') 	set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8192 or messageType = 0) and (alertType = 16 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') 	set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8192 or messageType = 0) and (alertType = 16 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') 	set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8192 or messageType = 0) and (alertType = 16 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 	set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (16, 8192,  @localeId, @FORMAT,1)	end
END
-- ==================
-- Library Management
-- ==================
if exists(select 1 from NTalerttype WITH (READUNCOMMITTED) where id=17) begin
SET @FORMAT_EMAIL = 'MsgTab_ '    + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(218 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(23 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(249 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(57 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(250 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(70 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(251 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(74 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(252 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(75 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(244 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(68 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(253 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(56 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(1302 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(71 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(222 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(39 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(255 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(73 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ '<MsgTokSep ' + CAST(18 as nvarchar(20)) + ' '+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(294 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(60 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(293 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(282 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ ' + ' MsgTokSep> '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(422 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(419 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(423 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(420 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(424 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(421 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(236 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(60 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ '<MsgTokSep ' +  CAST(22 as nvarchar(20))+','+ CAST(26 as nvarchar(20))+','+ CAST(24 as nvarchar(20)) + ' '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(245 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(182 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''
+ ' MsgTokSep> '
SET @FORMAT_PAGER = (select Message from ##EvLocaleMsgs where MessageID=(218 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(23 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(249 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(57 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(250 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(70 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(251 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(74 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(252 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(75 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(244 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(68 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(253 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(56 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(1302 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(71 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(222 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(39 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(255 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(73 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(236 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(60 | (CAST(POWER(2, 24) AS BIGINT) * 74)))
SET @FORMAT_JSON =
'"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (218 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (23 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (249 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (57 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (250 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (70 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (251 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (74 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (252 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (75 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (244 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (68 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (253 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (56 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (1302 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (71 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (222 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (39 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (255 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (73 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '<MsgTokSep ' + CAST(18 as nvarchar(20)) + ' '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (294 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (60 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (293 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (282 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , ' + ' MsgTokSep> '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (422 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (419 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (423 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (420 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (424 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (421 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (236 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (60 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '<MsgTokSep ' +  CAST(22 as nvarchar(20))+','+ CAST(26 as nvarchar(20))+','+ CAST(24 as nvarchar(20)) + ' '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (245 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (182 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '"'
+ ' MsgTokSep> '
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + @STD_POSTAMBLE	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (17, 1,  @localeId, @FORMAT,0)	set @common_Html_Postamble = @STD_POSTAMBLE  if ((1=1 OR 1=512 OR 1=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 1 or messageType = 0) and (alertType = 17 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1 or messageType = 0) and (alertType = 17 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1 or messageType = 0) and (alertType = 17 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1 or messageType = 0) and (alertType = 17 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (17, 1,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_PAGER_PREAMBLE + @FORMAT_PAGER + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (17, 4,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((4=1 OR 4=512 OR 4=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 4 or messageType = 0) and (alertType = 17 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 4 or messageType = 0) and (alertType = 17 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 4 or messageType = 0) and (alertType = 17 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 4 or messageType = 0) and (alertType = 17 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_PAGER if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_PAGER,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (17, 4,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_PAGER_PREAMBLE + @FORMAT_PAGER + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (17, 8,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((8=1 OR 8=512 OR 8=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 8 or messageType = 0) and (alertType = 17 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8 or messageType = 0) and (alertType = 17 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8 or messageType = 0) and (alertType = 17 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8 or messageType = 0) and (alertType = 17 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_PAGER if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_PAGER,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (17, 8,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (17, 512,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((512=1 OR 512=512 OR 512=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 512 or messageType = 0) and (alertType = 17 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 512 or messageType = 0) and (alertType = 17 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 512 or messageType = 0) and (alertType = 17 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 512 or messageType = 0) and (alertType = 17 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (17, 512,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (17, 1024,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((1024=1 OR 1024=512 OR 1024=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 1024 or messageType = 0) and (alertType = 17 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1024 or messageType = 0) and (alertType = 17 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1024 or messageType = 0) and (alertType = 17 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1024 or messageType = 0) and (alertType = 17 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (17, 1024,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + @STD_POSTAMBLE	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')   SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')   SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')  insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (17, 8192,  @localeId, @FORMAT,0)
set @FORMAT = @STD_PAGER_PREAMBLE + @FORMAT_PAGER + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (17, 32768,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((32768=1 OR 32768=512 OR 32768=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 32768 or messageType = 0) and (alertType = 17 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 32768 or messageType = 0) and (alertType = 17 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 32768 or messageType = 0) and (alertType = 17 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 32768 or messageType = 0) and (alertType = 17 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_PAGER if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_PAGER,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (17, 32768,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (17, 1048576,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((1048576=1 OR 1048576=512 OR 1048576=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 1048576 or messageType = 0) and (alertType = 17 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1048576 or messageType = 0) and (alertType = 17 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1048576 or messageType = 0) and (alertType = 17 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1048576 or messageType = 0) and (alertType = 17 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (17, 1048576,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (17, 131072,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((131072=1 OR 131072=512 OR 131072=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 131072 or messageType = 0) and (alertType = 17 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 131072 or messageType = 0) and (alertType = 17 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 131072 or messageType = 0) and (alertType = 17 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 131072 or messageType = 0) and (alertType = 17 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (17, 131072,  @localeId, @FORMAT,1)	end
if @isJson = 1		begin		set @FORMAT = '{' + @STD_JSON_PREAMBLE + @FORMAT_JSON + '}'insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (17, 8192,  @localeId, @FORMAT, 1)	end	else	begin		set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 8192 or messageType = 0) and (alertType = 17 or alertType = 0) and isHtml = 1 order by priority desc),'') 	set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8192 or messageType = 0) and (alertType = 17 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') 	set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8192 or messageType = 0) and (alertType = 17 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') 	set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8192 or messageType = 0) and (alertType = 17 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 	set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (17, 8192,  @localeId, @FORMAT,1)	end
END
-- =============
-- Device Status
-- =============
if exists(select 1 from NTalerttype WITH (READUNCOMMITTED) where id=21) begin
SET @FORMAT_EMAIL = 'MsgTab_ '    + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(218 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(23 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(249 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(57 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(256 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(70 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(251 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(74 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(252 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(75 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(222 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(39 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(245 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(182 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ '<MsgTokSep ' + CAST(20 as nvarchar(20)) + ' '+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(861 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(862 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''
+ ' MsgTokSep> '
SET @FORMAT_PAGER = (select Message from ##EvLocaleMsgs where MessageID=(218 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(23 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(249 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(57 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(256 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(70 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(251 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(74 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(252 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(75 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(222 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(39 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(245 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(182 | (CAST(POWER(2, 24) AS BIGINT) * 74)))
SET @FORMAT_JSON =
'"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (218 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (23 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (249 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (57 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (256 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (70 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (251 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (74 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (252 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (75 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (222 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (39 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (245 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (182 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '<MsgTokSep ' + CAST(20 as nvarchar(20)) + ' '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (861 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (862 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '"'
+ ' MsgTokSep> '
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + @STD_POSTAMBLE	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (21, 1,  @localeId, @FORMAT,0)	set @common_Html_Postamble = @STD_POSTAMBLE  if ((1=1 OR 1=512 OR 1=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 1 or messageType = 0) and (alertType = 21 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1 or messageType = 0) and (alertType = 21 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1 or messageType = 0) and (alertType = 21 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1 or messageType = 0) and (alertType = 21 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (21, 1,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_PAGER_PREAMBLE + @FORMAT_PAGER + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (21, 4,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((4=1 OR 4=512 OR 4=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 4 or messageType = 0) and (alertType = 21 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 4 or messageType = 0) and (alertType = 21 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 4 or messageType = 0) and (alertType = 21 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 4 or messageType = 0) and (alertType = 21 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_PAGER if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_PAGER,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (21, 4,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_PAGER_PREAMBLE + @FORMAT_PAGER + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (21, 8,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((8=1 OR 8=512 OR 8=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 8 or messageType = 0) and (alertType = 21 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8 or messageType = 0) and (alertType = 21 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8 or messageType = 0) and (alertType = 21 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8 or messageType = 0) and (alertType = 21 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_PAGER if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_PAGER,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (21, 8,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (21, 512,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((512=1 OR 512=512 OR 512=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 512 or messageType = 0) and (alertType = 21 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 512 or messageType = 0) and (alertType = 21 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 512 or messageType = 0) and (alertType = 21 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 512 or messageType = 0) and (alertType = 21 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (21, 512,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (21, 1024,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((1024=1 OR 1024=512 OR 1024=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 1024 or messageType = 0) and (alertType = 21 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1024 or messageType = 0) and (alertType = 21 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1024 or messageType = 0) and (alertType = 21 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1024 or messageType = 0) and (alertType = 21 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (21, 1024,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + @STD_POSTAMBLE	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')   SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')   SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')  insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (21, 8192,  @localeId, @FORMAT,0)
set @FORMAT = @STD_PAGER_PREAMBLE + @FORMAT_PAGER + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (21, 32768,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((32768=1 OR 32768=512 OR 32768=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 32768 or messageType = 0) and (alertType = 21 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 32768 or messageType = 0) and (alertType = 21 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 32768 or messageType = 0) and (alertType = 21 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 32768 or messageType = 0) and (alertType = 21 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_PAGER if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_PAGER,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (21, 32768,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (21, 1048576,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((1048576=1 OR 1048576=512 OR 1048576=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 1048576 or messageType = 0) and (alertType = 21 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1048576 or messageType = 0) and (alertType = 21 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1048576 or messageType = 0) and (alertType = 21 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1048576 or messageType = 0) and (alertType = 21 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (21, 1048576,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (21, 131072,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((131072=1 OR 131072=512 OR 131072=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 131072 or messageType = 0) and (alertType = 21 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 131072 or messageType = 0) and (alertType = 21 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 131072 or messageType = 0) and (alertType = 21 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 131072 or messageType = 0) and (alertType = 21 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (21, 131072,  @localeId, @FORMAT,1)	end
if @isJson = 1		begin		set @FORMAT = '{' + @STD_JSON_PREAMBLE + @FORMAT_JSON + '}'insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (21, 8192,  @localeId, @FORMAT, 1)	end	else	begin		set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 8192 or messageType = 0) and (alertType = 21 or alertType = 0) and isHtml = 1 order by priority desc),'') 	set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8192 or messageType = 0) and (alertType = 21 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') 	set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8192 or messageType = 0) and (alertType = 21 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') 	set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8192 or messageType = 0) and (alertType = 21 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 	set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (21, 8192,  @localeId, @FORMAT,1)	end
END
-- ============
-- VaultTracker
-- ============
if exists(select 1 from NTalerttype WITH (READUNCOMMITTED) where id=18) begin
SET @FORMAT_EMAIL = 'MsgTab_ ' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(218 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(23 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(257 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(76 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(249 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(57 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(236 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(60 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(258 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(79 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(259 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(77 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(260 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(78 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(261 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(80 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''+ ' MsgNewLine_MsgTab_ '
+ (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID=(222 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + 'TableDataSep' +  (select Message from ##EvLocaleMsgs where MessageID=(39 | (CAST(POWER(2, 24) AS BIGINT) * 74)))+ ''
SET @FORMAT_PAGER = (select Message from ##EvLocaleMsgs where MessageID=(218 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(23 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(257 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(76 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(249 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(57 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(259 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(77 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(260 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(78 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(261 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(80 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + ' , '
+ (select Message from ##EvLocaleMsgs where MessageID=(222 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + ' ' +  (select Message from ##EvLocaleMsgs where MessageID=(39 | (CAST(POWER(2, 24) AS BIGINT) * 74)))
SET @FORMAT_JSON =
'"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (218 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (23 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (257 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (76 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (249 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (57 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (236 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (60 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (258 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (79 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (259 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (77 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (260 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (78 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (261 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (80 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '" , '
+ '"' + (select SUBSTRING(Message,1,len(Message)-1) from ##EvLocaleMsgs where MessageID = (222 | (CAST(POWER(2, 24) AS BIGINT) * 74)) )  + '" : "' +  (select Message from ##EvLocaleMsgs where MessageID = (39 | (CAST(POWER(2, 24) AS BIGINT) * 74))) + '"'
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + @STD_POSTAMBLE	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (18, 1,  @localeId, @FORMAT,0)	set @common_Html_Postamble = @STD_POSTAMBLE  if ((1=1 OR 1=512 OR 1=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 1 or messageType = 0) and (alertType = 18 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1 or messageType = 0) and (alertType = 18 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1 or messageType = 0) and (alertType = 18 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1 or messageType = 0) and (alertType = 18 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (18, 1,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_PAGER_PREAMBLE + @FORMAT_PAGER + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (18, 4,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((4=1 OR 4=512 OR 4=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 4 or messageType = 0) and (alertType = 18 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 4 or messageType = 0) and (alertType = 18 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 4 or messageType = 0) and (alertType = 18 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 4 or messageType = 0) and (alertType = 18 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_PAGER if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_PAGER,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (18, 4,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_PAGER_PREAMBLE + @FORMAT_PAGER + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (18, 8,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((8=1 OR 8=512 OR 8=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 8 or messageType = 0) and (alertType = 18 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8 or messageType = 0) and (alertType = 18 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8 or messageType = 0) and (alertType = 18 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8 or messageType = 0) and (alertType = 18 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_PAGER if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_PAGER,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (18, 8,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (18, 512,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((512=1 OR 512=512 OR 512=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 512 or messageType = 0) and (alertType = 18 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 512 or messageType = 0) and (alertType = 18 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 512 or messageType = 0) and (alertType = 18 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 512 or messageType = 0) and (alertType = 18 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (18, 512,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (18, 1024,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((1024=1 OR 1024=512 OR 1024=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 1024 or messageType = 0) and (alertType = 18 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1024 or messageType = 0) and (alertType = 18 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1024 or messageType = 0) and (alertType = 18 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1024 or messageType = 0) and (alertType = 18 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (18, 1024,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + @STD_POSTAMBLE	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')   SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')   SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')  insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (18, 8192,  @localeId, @FORMAT,0)
set @FORMAT = @STD_PAGER_PREAMBLE + @FORMAT_PAGER + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (18, 32768,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((32768=1 OR 32768=512 OR 32768=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 32768 or messageType = 0) and (alertType = 18 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 32768 or messageType = 0) and (alertType = 18 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 32768 or messageType = 0) and (alertType = 18 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 32768 or messageType = 0) and (alertType = 18 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_PAGER if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_PAGER,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (18, 32768,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (18, 1048576,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((1048576=1 OR 1048576=512 OR 1048576=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 1048576 or messageType = 0) and (alertType = 18 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1048576 or messageType = 0) and (alertType = 18 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1048576 or messageType = 0) and (alertType = 18 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 1048576 or messageType = 0) and (alertType = 18 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (18, 1048576,  @localeId, @FORMAT,1)	end
set @FORMAT = @STD_EMAIL_PREAMBLE + @FORMAT_EMAIL + ''	SET @FORMAT= REPLACE(@FORMAT,'TableDataSep','  ')	SET @FORMAT= REPLACE(@FORMAT,'OpenTags','  ')	SET @FORMAT= REPLACE(@FORMAT,'CloseTags','  ')	insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (18, 131072,  @localeId, @FORMAT,0)	set @common_Html_Postamble = ''  if ((131072=1 OR 131072=512 OR 131072=8192)) begin set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 131072 or messageType = 0) and (alertType = 18 or alertType = 0) and isHtml = 1 order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 131072 or messageType = 0) and (alertType = 18 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 131072 or messageType = 0) and (alertType = 18 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 131072 or messageType = 0) and (alertType = 18 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 		set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">') set @FORMAT = @FORMAT + '</font></td></tr>'	set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li>MsgHrzSep</li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgHrzSep </li>',' MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li> MsgTokSep&gt;',' MsgTokSep&gt; <li>') set @FORMAT = replace(@FORMAT,'<li> &lt;MsgTokSep','<li>&lt;MsgTokSep') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 18','&lt;MsgTokSep 18 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 56','&lt;MsgTokSep 56 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53,85','&lt;MsgTokSep 52,53,85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 85','&lt;MsgTokSep 85 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 52,53','&lt;MsgTokSep 52,53 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 55','&lt;MsgTokSep 55 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 58','&lt;MsgTokSep 58 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 22,26,24','&lt;MsgTokSep 22,26,24 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 64','&lt;MsgTokSep 64 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 65','&lt;MsgTokSep 65 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 1','&lt;MsgTokSep 1 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,72,84','&lt;MsgTokSep 70,72,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 70,84','&lt;MsgTokSep 70,84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 84','&lt;MsgTokSep 84 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 68,69','&lt;MsgTokSep 68,69 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 30','&lt;MsgTokSep 30 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 20','&lt;MsgTokSep 20 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 71','&lt;MsgTokSep 71 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 73','&lt;MsgTokSep 73 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 74','&lt;MsgTokSep 74 <li>') set @FORMAT = replace(@FORMAT,'<li>&lt;MsgTokSep 80,81,82','&lt;MsgTokSep 80,81,82 <li>') set @FORMAT = replace(@FORMAT,'<li></li>','') set @FORMAT = replace(@FORMAT,'<li> </li>','') set @FORMAT = replace(@FORMAT,'<li>  </li>','') set @FORMAT = replace(@FORMAT,'<li>','<li style="margin-top: 4px; margin-bottom: 4px">') set @FORMAT = @common_Html_Preamble + @FORMAT + @common_Html_Postamble								set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px">MsgHrzSep </li>','MsgHrzSep ') set @FORMAT = replace(@FORMAT,'<li style="margin-top: 4px; margin-bottom: 4px"> MsgHrzSep </li>','MsgHrzSep ') insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (18, 131072,  @localeId, @FORMAT,1)	end
if @isJson = 1		begin		set @FORMAT = '{' + @STD_JSON_PREAMBLE + @FORMAT_JSON + '}'insert into @NTnotificationTemplate (NTalertTypeID, messageType, locale, defaultformatString,messageFormatType)	VALUES (18, 8192,  @localeId, @FORMAT, 1)	end	else	begin		set @common_Html_Preamble = IsNull( (Select top 1 subjectText from @subjectListTable where (messageType = 8192 or messageType = 0) and (alertType = 18 or alertType = 0) and isHtml = 1 order by priority desc),'') 	set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8192 or messageType = 0) and (alertType = 18 or alertType = 0) and isHtml = 1 and itemType = 'HEADER' order by priority desc),'') 	set @common_Html_Preamble += IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8192 or messageType = 0) and (alertType = 18 or alertType = 0) and isHtml = 1 and itemType = 'MIDDLE' order by priority desc),'') 	set @common_Html_Postamble = IsNull( (Select top 1 itemText from @preambleListTable where (messageType = 8192 or messageType = 0) and (alertType = 18 or alertType = 0) and isHtml = 1 and itemType = 'POSTAMBLE' order by priority desc),'') 	set @FORMAT_EMAIL_HTML = @FORMAT_EMAIL if (1 = 1) begin	set @FORMAT_EMAIL_HTML = dbo.getHtmlEscapedString(@FORMAT_EMAIL,1) end	set @FORMAT = @FORMAT_EMAIL_HTML set @FORMAT = replace(@FORMAT,'MsgTab_ ','') set @FORMAT = replace(@FORMAT,'OpenTags','<tr><td colspan="3" style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif">') set @FORMAT = replace(@FORMAT,'CloseTags','</font></tr></td>') set @FORMAT = replace(@FORMAT,'MsgNewLine_','</font></td></tr><tr><td style="padding:7px 0px 7px 20px;" ><font size="3" color="#444444" face="sans-serif"><b>') set @FORMAT = replace(@FORMAT,'TableDataSep','</b></font></td><td colspan="2"><font size=