

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/br_ntPerformOpOnCustomQuery.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/br_ntPerformOpOnCustomQuery.sp,v $ $Id: br_ntPerformOpOnCustomQuery.sp,v 1.7.46.2 2018/03/27 09:13:16 jiechen Exp $";
--
--  +========================================================================+
--  |   Procedure:  br_ntPerformOpOnCustomQuery()
--  |
--  | Description:  SP to enable/disable/delete custom query
--  |
--  |       Input:  QueryId and operation to be performed on the query
--  |      Output:  XML Output with information on whether the operation succeeded
--  |      Return:  xxx
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  +========================================================================+-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: br_ntPerformOpOnCustomQuery <<<'

IF EXISTS (select * from sysobjects where name='br_ntPerformOpOnCustomQuery')
	drop procedure br_ntPerformOpOnCustomQuery
IF EXISTS (select * from GxQscripts where name='br_ntPerformOpOnCustomQuery')
	delete from GxQscripts where name = 'br_ntPerformOpOnCustomQuery'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_ntPerformOpOnCustomQuery')
	delete from GXDBVersions where aliasname = 'br_ntPerformOpOnCustomQuery'
GO
print '... Creating Procedure: br_ntPerformOpOnCustomQuery'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure br_ntPerformOpOnCustomQuery
  @queryId int	,
  @queryOp int ,
  @userId int	,
  @localeId int	
AS
declare @errorCode int
declare @errorString nvarchar(max)
declare @isUserAdmin int
declare @queryCreator int
declare @taskId int
set @errorCode = 0
select @queryCreator = queryCreator from NTQueryList
where queryId = @queryId
select @taskId = taskId from NTQueryList
where queryId = @queryId
if (@queryCreator!=@userId)
begin
	IF OBJECT_ID('tempdb.dbo.#CCCapabilityForQuery') IS NOT null
		DROP TABLE #CCCapabilityForQuery
create table  #CCCapabilityForQuery ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	EXEC sec_getUserObjects @userId, 0, 0, '#CCCapabilityForQuery'
	delete sec
	from #CCCapabilityForQuery sec
WHERE (not (sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0))
	if exists(select 1 from #CCCapabilityForQuery
where (capabilities & CAST(POWER(2.0, 1 - 1) AS bigint)) <> 0
		)
	begin
		set @isUserAdmin = 1
	end
end
if (@queryCreator!=@userId and @isUserAdmin = 0)
begin
declare @objMessType int = (1008 | (CAST(POWER(2, 24) AS BIGINT) * 35));
		declare @objectName nvarchar(max)
		set @objectName = dbo.fn_EvFormatEventMsgText(0,@localeId, @objMessType, 0,2)
		declare @userName nvarchar(max)
		set @userName = IsNull((select Login from UMUsers where id = @userId),'')
set @errorString = (select message from EvLocaleMsgs Where messageId=(462 | (CAST(POWER(2, 24) AS BIGINT) * 35))  AND [localeId] = @localeId)
		SET @errorString = REPLACE(@errorString, '^1%s', @userName)
		SET @errorString = REPLACE(@errorString, '^2%s',
			dbo.fn_EvFormatEventMsgText(0,@localeId,(Select tokenId from UMCapability where id = 1),0,2))
		SET @errorString = REPLACE(@errorString, '^3%s', @objectName)
		set @errorCode = 1
		goto END_RESULTS
end
if @queryOp = 0-- ENABLE
begin
	Update NTQueryList
set status = status - 1
	where queryId = @queryId
and ((status & 1)>0)
	Update TM_Task
	set disabled = 0
	where taskId = @taskId
	-- Mark all notification rules created on this query enabled.
	Update NTnotificationRule
SET status = status - 512
	where id in
	(
		select ntnotificationid from NTNotificationQueryMapping
		where NTNotificationQueryMapping.queryId = @queryId
	)
and alertTypeId = 65
and ((status & 512)>0)
	and revision = 1
end
else if @queryOp = 1 -- DISABLE
begin
	Update NTQueryList
set status = status | 1
	where queryId = @queryId
	Update TM_Task
	set disabled = 1
	where taskId = @taskId
	-- Mark all notification rules created on this query disabled.
	Update NTnotificationRule
SET status = status | 512
	where id in
	(
		select NTNotificationQueryMapping.ntnotificationid from NTNotificationQueryMapping
		where NTNotificationQueryMapping.queryId = @queryId
	)
and alertTypeId = 65
	and revision = 1
end
else if @queryOp = 2 -- DELETE
begin
	-- First check whether its query for external entity. We can only disable/enable in that case.. We cant delete it.
	declare @customqueryType int
	set @customqueryType = 1
	select @customqueryType = IsNull(convert(xml,NTQueryList.xmlInfo).value('(App_AdditionalQueryDetails/externalQueryEntity/@queryType)[1]','int'),1)
	from NTQueryList
	where queryId = @queryId
	if (@customqueryType<>1 and @customqueryType<>0)
	begin
set @errorCode = (2295 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		set @errorString = dbo.fn_EvFormatEventMsgText(0,@localeId,@errorCode, 0,2)
		Goto END_RESULTS
	end
	-- Delete all alert mappings for this query
	-- Mark all such above alerts for this query deleted
	Update NTnotificationRule
SET revision = 0 , status = 2
	where id in
	(
		select ntnotificationid from NTNotificationQueryMapping
		where NTNotificationQueryMapping.queryId = @queryId
	)
and alertTypeId = 65
	delete from NTNotificationQueryMapping
	where queryId = @queryId
	delete from UMGroupAssociation
	where type1=9648 and id1 = @queryId
EXEC sec_deleteSecurityAssociationsForEntity 124, @queryId
	update NTDetectedAlerts
	set processStat = 8
where alertType = 65 and eventId in
	(
		select QR.eventId from NTDQueryResults QR
		where QueryId = @queryId
	)
	Update TM_Task
	set deleted = 1
	where taskId = @taskId
	-- Delete the query
	delete from NTQueryList
	where queryId = @queryId
end
END_RESULTS:
select @errorCode '@errorCode',@errorString '@errorString'
for xml path('App_GenericEntityResponse')
GO

IF EXISTS (select * from GxQscripts where name = 'br_ntPerformOpOnCustomQuery')
	delete from GxQscripts where name = 'br_ntPerformOpOnCustomQuery'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_ntPerformOpOnCustomQuery')
	delete from GXDBVersions where aliasname = 'br_ntPerformOpOnCustomQuery'
GO

insert into GXDBVersions values(2, 'br_ntPerformOpOnCustomQuery',  '00010007004600020000', 'br_ntPerformOpOnCustomQuery', '00010007004600020000')
GO

