

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/br_ntMatchUserSubscriptionPreference.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems,  Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems,  Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/br_ntMatchUserSubscriptionPreference.sp,v $ $Id: br_ntMatchUserSubscriptionPreference.sp,v 1.2.60.7 2018/03/27 09:02:42 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			CURSOR : "br_ntMatchClientsNotBackedUp"			|
--	|									|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: br_ntMatchUserSubscriptionPreference <<<'

IF EXISTS (select * from sysobjects where name='br_ntMatchUserSubscriptionPreference')
	drop procedure br_ntMatchUserSubscriptionPreference
IF EXISTS (select * from GxQscripts where name='br_ntMatchUserSubscriptionPreference')
	delete from GxQscripts where name = 'br_ntMatchUserSubscriptionPreference'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_ntMatchUserSubscriptionPreference')
	delete from GXDBVersions where aliasname = 'br_ntMatchUserSubscriptionPreference'
GO
print '... Creating Procedure: br_ntMatchUserSubscriptionPreference'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure br_ntMatchUserSubscriptionPreference
  @ntRuleId integer,
  @escLevel integer,
  @entityType1 INT,
  @entityId1 INT,
  @entityType2 INT = 0,
  @entityId2 INT = 0,
  @entityType3 INT = 0,
  @entityId3 INT = 0,
  @entityType4 INT = 0,
  @entityId4 INT = 0,
  @entityType5 INT = 0,
  @entityId5 INT = 0
AS
  DECLARE @o_isMatched integer;
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET ANSI_WARNINGS ON
-- If the notif rule does not have status NT_STATUS_LAPTOP_ALERT then it doesnt match
if not exists(	select 1 from NTNotificationRule where ((status & 128)>0)
			and id = @ntRuleId)
begin
	select 0
	return
end
-- If its not a laptop client then return 0 straight away and dont match.
-- For clients we check whether its a laptop client.
if (@entityType1=3)
begin
	declare @laptopClient int = 0
	select  @laptopClient = 1 from App_client
where (STATUS & 0x1000)>0
	and id=@entityId1
	if @laptopClient=0
	begin
		select 0
		return
	end
end
if exists(select 1 from NTAlertSubScriptions
		where ntRuleId = @ntRuleId and escalationLevel = @escLevel
and (flags & 1)>0
		AND (entityId1 = @entityId1 OR entityId1 = 0) AND entityType1 = @entityType1
		AND (entityId2 = @entityId2 OR entityId2 = 0) AND entityType2 = @entityType2
		AND (entityId3 = @entityId3 OR entityId3 = 0) AND entityType3 = @entityType3
		AND (entityId4 = @entityId4 OR entityId4 = 0) AND entityType4 = @entityType4
		AND (entityId5 = @entityId5 OR entityId5 = 0) AND entityType5 = @entityType5
		)
begin
	-- Matched
	select 1
	return
end
-- Check whether any user has subscribed to this at global level.
if exists(select 1 from NTAlertSubScriptions
		where ntRuleId = @ntRuleId and escalationLevel = @escLevel
and (flags & 1)>0
		AND entityId1 = 0 AND entityType1 = 0
		AND entityId2 = 0 AND entityType2 = 0
		AND entityId3 = 0 AND entityType3 = 0
		AND entityId4 = 0 AND entityType4 = 0
		AND entityId5 = 0 AND entityType5 = 0
		)
begin
	-- Matched
	select 1
	return
end
if (@entityType1=3)
begin
	declare @ownersForClient table
	(
		clientId INT,
		userId INT,
		userGroupId INT
	)
	Insert into @ownersForClient
	select * from dbo.sec_getClientOwnersWithParam(@entityId1,0,1)
	where clientId=@entityId1
	-- Else check whether any owner of this client has OPTED globally for this alert.
	if exists(select 1 from NTAlertSubScriptions
			where ntRuleId = @ntRuleId and escalationLevel = @escLevel
and (flags & 1)>0
			and userId in
			(
				select ownersForClient.userID from @ownersForClient ownersForClient
			)
			and entityId1 = 0
		)
		begin
			-- Matched
			select 1
			return
		end
	-- Else check whether its part of entity selection list for this alert.
	-- We check this only for laptop clients. If its not a laptop client then we will not match it.
	-- If its part of entity selection list, then we should have alteast one client owner who hasnt made any selection so far.
	-- This change is to OPT in/Enable subscription based alerts by default without user having to enable from webconsole manually.
	declare @genericEntity nvarchar(max)
	declare @xmlEntityList xml
	declare @resultMatch int = 0
	set @genericEntity = '<CvEntities_GenericEntity clientId="'+convert(nvarchar(10),@entityId1)+'"/>'
	select @xmlEntityList = xmlEntityList from NTNotificationRule
	where id = @ntRuleId
	set @xmlEntityList = @xmlEntityList.query('CVGui_CommCellTreeNode/associations')
	set @xmlEntityList = convert(xml,replace(replace(convert(nvarchar(max),@xmlEntityList),
		'<associations','<entity'),'</associations>','</entity>'))
	set @xmlEntityList = (
		select @xmlEntityList.query('.')
		for xml path(''),root('App_Associations')
		)
	--declare @entityCheckResult table
	--(
	--	result int
	--)
	--Insert into @entityCheckResult
	--exec AppCheckEntityIncluded @genericEntity,@xmlEntityList,@ntRuleId
	--select @resultMatch = result From @entityCheckResult
	select @resultMatch = dbo.IsEntityInAssocList(@genericEntity,@xmlEntityList,@ntRuleId)
	if @resultMatch=1
	begin
		select 1
		return
	end
end
select 0
return
GO
--dummy check-in becuase one update on build 52 failed to get built correctly Form (52563).

IF EXISTS (select * from GxQscripts where name = 'br_ntMatchUserSubscriptionPreference')
	delete from GxQscripts where name = 'br_ntMatchUserSubscriptionPreference'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_ntMatchUserSubscriptionPreference')
	delete from GXDBVersions where aliasname = 'br_ntMatchUserSubscriptionPreference'
GO

insert into GXDBVersions values(2, 'br_ntMatchUserSubscriptionPreference',  '00010002006000070000', 'br_ntMatchUserSubscriptionPreference', '00010002006000070000')
GO

