

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/br_ntMaintenance.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/br_ntMaintenance.sp,v $ $Id: br_ntMaintenance.sp,v 1.28.46.4 2018/08/26 17:15:06 mnatarajan Exp $";
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +========================================================================+
--  |   Procedure:  br_ntMaintenance()
--  |
--  | Description:  Prunes NTMessageHistory Table
--  |
--  |       Input:
--	|
--	|
--  |      Output:  NTmessageTracking Table updated
--  |      Return:  xxx
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: br_ntMaintenance <<<'

IF EXISTS (select * from sysobjects where name='br_ntMaintenance')
	drop procedure br_ntMaintenance
IF EXISTS (select * from GxQscripts where name='br_ntMaintenance')
	delete from GxQscripts where name = 'br_ntMaintenance'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_ntMaintenance')
	delete from GXDBVersions where aliasname = 'br_ntMaintenance'
GO
print '... Creating Procedure: br_ntMaintenance'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure br_ntMaintenance
--	+-------------------------------+
--	| PARAMETERS   &   OUTPUTS		|
--	+-------------------------------+
--:PARAM	notifId  			integer,
AS
declare @latencyDays		integer
declare @expireTimeHours	integer
declare @oldestTime			datetime
declare @notifCount			integer
declare @spoolCount			integer
declare @latencyDaysStr		nvarchar(256)
declare @expireTimeHoursStr	nvarchar(256)
DECLARE @nowTime			INTEGER = dbo.getunixTime(getutcdate())
declare @jobIdList	table
(
	jobId int
)
DECLARE @oldTaskId			int
declare @haveAllJobsBeenSubmitted int
DECLARE @entities			XML
declare @skipCheck          integer
select @latencyDaysStr = value FROM GXGlobalParam WHERE Name = 'Notification Latency Days'  				-- 'CNNTF_PROP_HISTORY_LATENCY_DAYS'. hash define value not longer used here due to making QUOTED IDENTIFIER ON
select @expireTimeHoursStr = value FROM GXGlobalParam WHERE Name = 'Notification Generic Expiration Hours'  		-- 'CNNTF_PROP_EXPIRE_HOURS_GENERIC' hash define value not longer used here due to making QUOTED IDENTIFIER ON
select @skipCheck           = CAST(ISNULL((Select value FROM GXGlobalParam WHERE Name = 'Notification Skip Check'), '0')  as int)       -- 'CNNTF_PROP_EXPIRE_HOURS_GENERIC'
set @latencyDays = CAST(@latencyDaysStr as int)
set @expireTimeHours = CAST(@expireTimeHoursStr as int)
IF @skipCheck <> 0
BEGIN
    SET @oldestTime = ''
    SET @notifCount = 0
    SET @spoolCount = 0
    GOTO REPORT_RESULTS
 END
-------------------------------------------------
-- DON'T WANT TO DELETE ENTRIES IF WE HAVEN'T ---
--  EXPIRED NON-SENDABLE "MAIL" YET!          ---
-------------------------------------------------
IF ((@latencyDays) < @expiretimehours)
	SET @latencyDays = @expiretimehours +1
set @oldestTime = dateAdd(Hour, -@latencyDays, GETUTCDATE())
--------------------
-- DO THE PRUNING --
--------------------
--Delete the spoolqueue entries, which are already processed
--Delete the expired entries
DELETE NTspoolQueue WHERE triggerTime < @oldestTime OR status <> 0
set @spoolCount = @@rowcount
--Delete the MessageHistory, which is already processed and sent.
DELETE NTmessageHistory WHERE notificationsToBeSent = sentStatus OR triggerTime < @oldestTime
set @notifCount = @@rowcount
-- Delete property "Last Notif Time" from table NTNotificationProps for event viewer alerts
-- Esp for cases where repeated options are no longer selected or prop entries are too old.
declare @EVAlertTableForLastNotifTime table
(
	ntRuleId int,
	delayTimeSeconds int
)
Insert into @EVAlertTableForLastNotifTime
select distinct ruleId,persistTimeSeconds
from NTSelCriteria
inner join NTNotificationRule
on NTSelCriteria.ruleId=NTNotificationRule.id
where NTNotificationRule.alertTypeId=58
Delete NTnotificationProp from  NTnotificationProp
INNER JOIN
(
	SELECT LastNotifPropList.ID
	FROM @EVAlertTableForLastNotifTime EVAlertTableForLastNotifTime
	INNER JOIN
	(
		SELECT NTnotificationProp.id,NTnotificationProp.componentnameId, NTnotificationProp.attrval
		FROM NTnotificationProp
		WHERE NTnotificationProp.attrname like 'Last Notif Time%'
		AND attrval NOT LIKE '%[^0-9]%'
	) LastNotifPropList
	ON LastNotifPropList.componentnameId = EVAlertTableForLastNotifTime.ntRuleId
	AND	 (@nowTime -	CASE WHEN attrval NOT LIKE '%[^0-9]%' THEN convert(int,attrval)
		ELSE @nowTime END )>EVAlertTableForLastNotifTime.delayTimeSeconds
		-- In case its not numeric value then return @nowTime so that it doesnt get deleted.
) DeletedNTPRops ON
DeletedNTPRops.ID = NTNotificationProp.ID
DELETE NTattachedFiles WHERE  triggerTime < cast(@oldestTime as varchar(128))
UPDATE ntnotificationrule set revision = 0 , STATUS = 2 where status = 8 and lastModified < dbo.getUnixtime(@oldestTime)
DECLARE @notifId as int
DECLARE @selCriId as int
--Delete the logically deleted notfication rule
		DECLARE	GetNotificationRuleDelCursor CURSOR FOR
SELECT id FROM ntnotificationrule as NTR where revision = 0 AND ((status & 2) = 2) AND NOT EXISTS (select * from ntmessageHistory where NtnotificationId = NTR.id)
		OPEN GetNotificationRuleDelCursor
		FETCH GetNotificationRuleDelCursor INTO @notifId
		WHILE	@@FETCH_STATUS = 0
		BEGIN
			IF EXISTS ( SELECT 1 FROM NTLiveFeedsMessageHistory WHERE NTnotificationID = @notifId )
			BEGIN
				FETCH GetNotificationRuleDelCursor INTO @notifId
				CONTINUE
			END
			--Delete the users and groups
			Delete  NTnotificationUsers where NTnotificationID = @notifId
			Delete  NTnotificationGroups where NTnotificationID = @notifId
			Delete  NTnotificationExternalGroups where NTnotificationID = @notifId
			Delete  NTnotificationNonGalaxyUsers where NTnotificationID = @notifId
			--Delete the Message and History
			Delete  NTmessages where NTnotificationID = @notifId
			Delete  NTmessageFormat where NTnotificationID = @notifId
			--Delete the selected criteria
			DECLARE	GetSelCriNotifDelCursor CURSOR FOR
			SELECT id FROM NTSelCriteria where  ruleId = @notifId
			OPEN GetSelCriNotifDelCursor
			FETCH GetSelCriNotifDelCursor INTO @selCriId
			WHILE	@@FETCH_STATUS = 0
			BEGIN
				Delete NTSelCriteriaParams where selCriteriaId = @selCriId
				FETCH GetSelCriNotifDelCursor INTO @selCriId
			END
			CLOSE GetSelCriNotifDelCursor
			DEALLOCATE GetSelCriNotifDelCursor
			Delete  NTSelCriteria where ruleId = @notifId
			Delete NTnotificationAction where NTnotificationID = @notifId
			Delete  NTattachedFiles where NTnotificationID = @notifId
			-- Delete from RomsQueue table first to avoid foreign key constraint errors
			DELETE NTRomsQueue WHERE NTnotificationID = @notifId
			Delete ntnotificationrule where id = @notifId
			FETCH GetNotificationRuleDelCursor INTO @notifId
		END
		CLOSE GetNotificationRuleDelCursor
		DEALLOCATE GetNotificationRuleDelCursor
------------------------------------------------------------------------------------
--Mark delayed delete for alert having missing entities.
		DECLARE	GetNotificationRuleDelCursor CURSOR FOR
SELECT id FROM ntnotificationrule as NTR where revision = 1 AND ((status & 4) = 4)
		OPEN GetNotificationRuleDelCursor
		FETCH GetNotificationRuleDelCursor INTO @notifId
		WHILE	@@FETCH_STATUS = 0
		BEGIN
			DECLARE @rowCount int
			set @rowcount = (select count(*) from TM_Task where alertId = @notifId)
		   -- set @rowCount = @rowCount + (select count(*) from JMJobInfo where jobBasedAlertId = @notifId)
			-- Now immediate jobs gets pruned from TM_Task table by TM_Maintenance SP. So if rowcount is 0 then
			-- we check whether the corresponding job is running
			if(@rowCount = 0)
			begin
				SET @entities = ( SELECT CAST([xmlEntityList] AS XML) FROM ntnotificationrule WHERE id = @notifId)
				delete from @jobIdList
				set @haveAllJobsBeenSubmitted = 1
					-- Check if already taskId is associated. Task Id association is present in case we create an alert at the same time job is started
					SET @oldTaskId = @entities.value('(/CVGui_CommCellTreeNode/trackingSchedules/schedules/@taskId)[1]', 'int' )
					if @oldTaskId is null
					begin
						Insert into @jobIdList
						SELECT ISNULL(Tbl.Col.value('@jobId_l', 'int'),-1)
						FROM @entities.nodes('/CVGui_CommCellTreeNode/trackingJobs/jobs') as Tbl(Col)
					end
					else
					begin
						-- Task id is specified.
						Insert into @jobIdList
						select distinct TM_Jobs.jobId from TM_JobRequest
						inner join TM_Jobs
						on TM_JobRequest.jobRequestId = TM_Jobs.jobRequestId
						where TM_JobRequest.taskId = @oldTaskId
					end
					if exists(select * from TM_Jobs where jobId in
						(
							select jobId from @jobIdList
						)
						 AND TM_Jobs.status!=2)
					begin
						set @haveAllJobsBeenSubmitted = 0
					end
				-- First check whether any job is running from the specified list . And all of thmem has to be submitted first
				if (( not exists
						(
							select * from JMJobInfo
							where JMJobInfo.jobId in
								(select jobId from @jobIdList)
						)
					  ) and @haveAllJobsBeenSubmitted =1
					)
				begin
UPDATE ntnotificationrule set  STATUS = 8 , lastModified = @nowTime where id = @notifId
				end
			end
			FETCH GetNotificationRuleDelCursor INTO @notifId
		END
		CLOSE GetNotificationRuleDelCursor
		DEALLOCATE GetNotificationRuleDelCursor
------------------------------------------------------------------------------
---Delete the entries in UMLoginFailedHistroy which are marked for pruning----
------------------------------------------------------------------------------
	delete UMLoginFailedHistory where flags = 1;
-----------------------------------------------------------------------------
-- Delete Console alerts
-----------------------------------------------------------------------------
DECLARE @noOfAlertPerNotificationPerCriteria INTEGER = ISNULL((SELECT value FROM GXGlobalParam WHERE name like 'nConsoleAlertCountForUser'),100)
DECLARE @AlertToPrune TABLE (id INTEGER,userId INTEGER,notoficationId INTEGER ,rank INTEGER)
INSERT INTO @AlertToPrune
SELECT ntf.LiveFeedId,nts.userId,ntf.NTnotificationID,
DENSE_RANK() OVER (PARTITION BY nts.userId,ntf.NTnotificationID,ntf.AlertType,ntf.AlertCriteria ORDER BY ntf.LiveFeedId DESC ) as rank
FROM NTLiveFeedsMessageHistory ntf INNER JOIN NTLiveFeedsStatus nts
                           ON ntf.LiveFeedId = nts.liveFeedsId
DELETE FROM @AlertToPrune WHERE rank <= @noOfAlertPerNotificationPerCriteria
DELETE nts
FROM @AlertToPrune prune INNER JOIN NTLiveFeedsStatus nts
       ON prune.id = nts.liveFeedsId AND prune.userId = nts.userId
DELETE FROM NTLiveFeedsMessageHistory
WHERE livefeedid NOT IN (SELECT DISTINCT liveFeedsId FROM NTLiveFeedsStatus)
-------------------------
-- PRUNING NTROMSQueue --
-------------------------
DECLARE @processedAlerts integer
DECLARE @ROMSMaxRowsInAlertQueue integer
DECLARE @ROMSMaxRowsInAlertQueueStr nvarchar(256)
DECLARE @rowsInQueue integer
SET @processedAlerts = (SELECT COUNT(*) FROM NTRomsQueue WHERE flags = 2)
SET @ROMSMaxRowsInAlertQueueStr = (SELECT value FROM GXGlobalParam WHERE name = 'ROMSMaxRowsInAlertQueue' AND modified = 0)
SET @ROMSMaxRowsInAlertQueue = CAST(@ROMSMaxRowsInAlertQueueStr AS int)
-- Prune all rows which are greater than the expireTimeHours
IF @processedAlerts > 0
	DELETE FROM NTRomsQueue WHERE triggerTime >= @expireTimeHours AND flags = 2
SET @rowsInQueue = (SELECT COUNT(*) FROM NTRomsQueue)
-- Delete all processed rows if the no of rows is greater than ROMSMaxRowsInAlertQueue --
IF @rowsInQueue > @ROMSMaxRowsInAlertQueue
	DELETE FROM NTRomsQueue WHERE flags = 2
SET @rowsInQueue = (SELECT COUNT(*) FROM NTRomsQueue)
-- Delete the top #ROMSMaxRowsInAlertQueue of rows in NTRomsQueue if there are more rows --
IF @rowsInQueue > @ROMSMaxRowsInAlertQueue
BEGIN
	DECLARE @triggerTime datetime
	SELECT @triggerTime = MIN(triggerTime)
    FROM
    (SELECT TOP (@ROMSMaxRowsInAlertQueue) triggerTime
    FROM    NTROMSQueue
    ORDER BY triggerTime DESC) inQueue
    DELETE FROM NTROMSQueue
	WHERE triggerTime < @triggerTime
END
------------------------
-- REPORT THE RESULTS --
------------------------
REPORT_RESULTS:
select @spoolCount, @notifCount, @oldestTime
GO

IF EXISTS (select * from GxQscripts where name = 'br_ntMaintenance')
	delete from GxQscripts where name = 'br_ntMaintenance'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_ntMaintenance')
	delete from GXDBVersions where aliasname = 'br_ntMaintenance'
GO

insert into GXDBVersions values(2, 'br_ntMaintenance',  '00010028004600040000', 'br_ntMaintenance', '00010028004600040000')
GO

