

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/br_ntHandleUserAction.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems,  Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems,  Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/br_ntHandleUserAction.sp,v $ $Id: br_ntHandleUserAction.sp,v 1.3.40.2 2018/03/27 08:42:37 jiechen Exp $";
-- 	+---------------------------------------------------+
--	| 			PROCEDURE : "br_ntHandleUserAction"			|
-- 	+---------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: br_ntHandleUserAction <<<'

IF EXISTS (select * from sysobjects where name='br_ntHandleUserAction')
	drop procedure br_ntHandleUserAction
IF EXISTS (select * from GxQscripts where name='br_ntHandleUserAction')
	delete from GxQscripts where name = 'br_ntHandleUserAction'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_ntHandleUserAction')
	delete from GXDBVersions where aliasname = 'br_ntHandleUserAction'
GO
print '... Creating Procedure: br_ntHandleUserAction'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure br_ntHandleUserAction
  @i_userId INTEGER,
  @i_userAction INTEGER,
  @i_returnCursor INTEGER,
  @i_errorCode INTEGER  output
AS
  DECLARE @o_errorCode INTEGER;
set @o_errorCode=0
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
declare @providerId				integer
DECLARE @i_flags INT
set @providerId = 0
select @providerId = umdsproviderId from UMUsers
where id=@i_userId
-- if user is going to be deleted, then for normal user we delete all his alerts/metrics alerts.
-- For all AD users, we disable them. They will have to be enabled by the creator once he/she logs in again
if @i_userAction=0
begin
	if @providerId<=0
	begin
		delete from CustomAlarmProps
		where userId = @i_userId
		if @@error<>0
		begin
			set @o_errorCode = @@error
			goto EXIT_PROC
		end
		Update NTNotificationRule
set status = 2,
		revision=0
		where alertTypeId=65 and notifOwner= @i_userId
		if @@error<>0
		begin
			set @o_errorCode = @@error
			goto EXIT_PROC
		end
	end
	-- when user is going to be deleted (for both AD and normal users), we delete his recent and saved search, alert and schedules.
	declare @searchOpXml xml
	set @searchOpXml = (select searchId as '@searchId',
			case when (status&2)>0 then 2 -- when we delete saved search, everything (including dashboard and alert) gets deleted internally. Because alert could be disabled and (status&8)=0 for LMUserSearch
			else 1
			end as '@status'
			from LMUserSearch with (nolock)
			where creatorUserId=@i_userId
			for xml path('searchInfo'),root('LogMonitoring_SearchOperationReq'))
	if (@searchOpXml is not null)
	begin
		set @searchOpXml.modify('insert attribute operationType {3} into (/LogMonitoring_SearchOperationReq)[1]')
		declare @o_xmlMsg xml
		exec LMSearchOperations @i_userId,@searchOpXml,@o_xmlMsg output
		set @o_errorCode = (SELECT ref.value('@errorCode','INTEGER') FROM @o_xmlMsg.nodes('LogMonitoring_GenericEntityResponse') as R(ref))
		if (@o_errorCode is null)
		begin
			set @o_errorCode = 0
		end
		if (@o_errorCode<>0)
		begin
			goto EXIT_PROC
		end
	end
	goto EXIT_PROC
end
if @i_userAction=1 Or @i_userAction=0
begin
	Update CustomAlarmProps
	set flags = flags | 1
	where userId = @i_userId
	SET @i_flags = 1
	UPDATE	CustomAlarmProps SET extendedProps.modify('replace value of (/alarmProps/@flags)[1] with sql:variable("@i_flags")')
	FROM	CustomAlarmProps AP
	where userId = @i_userId
	if @@error<>0
	begin
		set @o_errorCode = @@error
		goto EXIT_PROC
	end
	Update NTNotificationRule
set status = status | 1
	where alertTypeId=65 and notifOwner= @i_userId
	if @@error<>0
	begin
		set @o_errorCode = @@error
		goto EXIT_PROC
	end
	-- Now we disable all lm search schedules created by this user. As well as alerts for his searches.
	Update TM_task
	set disabled=1
	from TM_task inner join TM_Subtask on
	TM_task.taskId=TM_Subtask.taskId
	and TM_Subtask.operationType=5015 --LM_DASH_SEARCH_OPERATION
	where ownerId=@i_userId
	-- We also disable all alerts for searches.
	-- We create a temp table with all alerts and searches. And send a request for disabling alerts so that workqueue request
	-- is sent for updating search rules
	if exists(select 1 from LMuserSearch with (nolock) where creatorUserId=@i_userId)
	begin
		declare @userSearchalertList table
		(
			searchId int,
			alertID int
		)
		Insert into @userSearchalertList
		select searchId, x.value('(alertEntity/@alertId)[1]','int')
		from LMUserSearch with (nolock)
		cross apply searchInfo.nodes('LogMonitoring_SearchURLInfo/alertInfoLst') M(x)
		where creatorUserId=@i_userId
		declare @searchOpXmlDisableAlerts xml
		set @searchOpXmlDisableAlerts = (select searchId as '@searchId',
					(
						select alertId as 'alertEntity/@alertId' from
						@userSearchalertList InnerQuery
						where InnerQuery.SearchId=OuterQuery.SearchId
						for xml path('alertInfoLst'),root('LogMonitoring_SearchURLInfo')
					) as '@urlInfo'
				from @userSearchalertList OuterQuery
				for xml path('searchInfo'),root('LogMonitoring_SearchOperationReq'))
		if (@searchOpXmlDisableAlerts is not null)
		begin
			set @searchOpXmlDisableAlerts.modify('insert attribute operationType {11} into (/LogMonitoring_SearchOperationReq)[1]')
			declare @o_xmlMsgDisableOp xml
			exec LMSearchOperations @i_userId,@searchOpXmlDisableAlerts,@o_xmlMsgDisableOp output
			set @o_errorCode = (SELECT ref.value('@errorCode','INTEGER') FROM @o_xmlMsgDisableOp.nodes('LogMonitoring_GenericEntityResponse') as R(ref))
			if (@o_errorCode is null)
			begin
				set @o_errorCode = 0
			end
			if (@o_errorCode<>0)
			begin
				goto EXIT_PROC
			end
		end
	end
end
EXIT_PROC:
	set @i_errorCode = @o_errorCode
	IF (@i_returnCursor <> 0)
	begin
		select @o_errorCode
	end
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'br_ntHandleUserAction')
	delete from GxQscripts where name = 'br_ntHandleUserAction'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_ntHandleUserAction')
	delete from GXDBVersions where aliasname = 'br_ntHandleUserAction'
GO

insert into GXDBVersions values(2, 'br_ntHandleUserAction',  '00010003004000020000', 'br_ntHandleUserAction', '00010003004000020000')
GO

