

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/br_ntGetNotificationsToSend.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/br_ntGetNotificationsToSend.sp,v $ $Id: br_ntGetNotificationsToSend.sp,v 1.5.304.2 2018/09/04 03:23:57 snandhini Exp $";
--
--  +========================================================================+
--  |   Procedure:  br_NTgetNotificationsToSend()
--  |
--  | Description:  Intended to be called by Cursor "NTgetNotificationsToSend'
--	|				and others.  Fetches rows & formats Subject & Message Body
--	|				fields by token substitution.
--  |
--  |       Input:  messageType
--	|
--  |      Output:  xxx
--  |      Return:  xxx
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  +========================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: br_ntGetNotificationsToSend <<<'

IF EXISTS (select * from sysobjects where name='br_ntGetNotificationsToSend')
	drop procedure br_ntGetNotificationsToSend
IF EXISTS (select * from GxQscripts where name='br_ntGetNotificationsToSend')
	delete from GxQscripts where name = 'br_ntGetNotificationsToSend'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_ntGetNotificationsToSend')
	delete from GXDBVersions where aliasname = 'br_ntGetNotificationsToSend'
GO
print '... Creating Procedure: br_ntGetNotificationsToSend'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure br_ntGetNotificationsToSend
  @messType integer
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--   PARAMETERS   &   OUTPUTS
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
DECLARE @now DATETIME
DECLARE @notifBit	integer
set @now = GetUTCDate();
set @notifBit = @messType
SELECT
		MH.NTnotificationId,
		ageMinutes = datediff(minute, triggerTime, @now),
		triggerTime,
		unixTime=dbo.GetUnixTime(triggerTime),
		escalationLevel,
		alertName = N.notificationName
FROM	NTmessageHistory AS MH, NTnotification AS N
WHERE
		    (notificationsToBeSent & @notifBit) <> 0
		AND ( sentStatus & @notifBit) = 0
AND ( attachStatus = 0 OR attachStatus = 3 OR attachStatus=2)
		AND MH.NTnotificationID = N.NTnotificationID
		AND N.revision > 0
ORDER BY triggerTime
GO

IF EXISTS (select * from GxQscripts where name = 'br_ntGetNotificationsToSend')
	delete from GxQscripts where name = 'br_ntGetNotificationsToSend'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_ntGetNotificationsToSend')
	delete from GXDBVersions where aliasname = 'br_ntGetNotificationsToSend'
GO

insert into GXDBVersions values(2, 'br_ntGetNotificationsToSend',  '00010005030400020000', 'br_ntGetNotificationsToSend', '00010005030400020000')
GO

