

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/br_ntGetExpandedEntityListForAlerts.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems,  Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems,  Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/br_ntGetExpandedEntityListForAlerts.sp,v $ $Id: br_ntGetExpandedEntityListForAlerts.sp,v 1.3.42.4 2018/03/27 08:43:46 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			SP : "br_ntGetExpandedEntityListForAlerts"						|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: br_ntGetExpandedEntityListForAlerts <<<'

IF EXISTS (select * from sysobjects where name='br_ntGetExpandedEntityListForAlerts')
	drop procedure br_ntGetExpandedEntityListForAlerts
IF EXISTS (select * from GxQscripts where name='br_ntGetExpandedEntityListForAlerts')
	delete from GxQscripts where name = 'br_ntGetExpandedEntityListForAlerts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_ntGetExpandedEntityListForAlerts')
	delete from GXDBVersions where aliasname = 'br_ntGetExpandedEntityListForAlerts'
GO
print '... Creating Procedure: br_ntGetExpandedEntityListForAlerts'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure br_ntGetExpandedEntityListForAlerts
  @notifId integer,
  @criteriaId integer,
  @alertTypeId integer
AS
  DECLARE @clientId int
  DECLARE @appTypeId int
  DECLARE @instanceId int
  DECLARE @backupsetId int
  DECLARE @subclientId int
  DECLARE @subclientStatus int
  DECLARE @ntRuleId int
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET ANSI_WARNINGS ON
-- Now @selectedEntityIds table contains list of all selections at client level done by user.
-- Now we will expand it till subclient level and store it in @Expandedselectedclientids list.
declare @expandedSelectedEntityIds table
(
	clientId int,
	appTypeId int,
	instanceId int,
	backupsetId int,
	subclientId int,
	subclientStatus int,
	excluded int,
	ntRuleId int
)
-- First check whether any alert is present with this criteria selected. Else disable.
-- In case there are no active alerts with these criterias selected, then SP returns empty
if not exists(
		select 1 from NTSelCriteria NTSel with (nolock)
		inner join NTNotificationRule  NTRule with (nolock)
		on NTRule.id = NTsel.ruleid
		where (availCriteriaid=@criteriaId or @criteriaId=0)
		and (NTRule.alertTypeId = @alertTypeId or @alertTypeId=0)
and (NTRule.status & (1|2)) = 0
		and (NTRule.id = @notifId or @notifId=0)
	)
begin
	select clientId,appTypeId ,instanceId ,backupsetId ,subclientId ,subclientStatus ,	ntRuleId from @expandedSelectedEntityIds
	return
end
declare @associationListTbl table
(
	associations xml,
	ntRuleId	 int
)
declare @xmlEntityListTbl table
(
	xmlEntityList xml,
	ntRuleId	 int
)
-- First look at all entities selected for non (disabled/deleted) alerts
Insert into @xmlEntityListTbl
select xmlEntityList,id
from NTnotificationRule with (nolock)
where id in
(
	select ruleId from NTSelCriteria with (nolock)
	where (NTSelCriteria.availCriteriaid=@criteriaId or @criteriaId=0)
)
-- Also only look at rules created for the given alert type.
and (status & (1|2)) = 0
and (NTnotificationRule.alertTypeId = @alertTypeId or @alertTypeId=0)
and (NTnotificationRule.id = @notifId or @notifId=0)
-- Remove all entries which are job based alerts or schedule based alerts.
delete from @xmlEntityListTbl
where xmlEntityList.exist('CVGui_CommCellTreeNode/trackingJobs/jobs')=1
delete from @xmlEntityListTbl
where xmlEntityList.exist('CVGui_CommCellTreeNode/trackingSchedules/schedules')=1
Insert into @associationListTbl
select xmlEntityList.query('CVGui_CommCellTreeNode/associations'),ntRuleId
from @xmlEntityListTbl
where xmlEntityList.exist('CVGui_CommCellTreeNode/associations')=1
-- For retrieving entity information stored in older format in CommcellTreeNode under clients and clientgroups node
declare @selectedEntityIds table
(
	clientGroupId int,
	clientId int,
	appTypeId int,
	instanceId int,
	backupsetId int,
	subclientId int,
	excluded int,
	ntRuleId int
)
-- For retrieving entity information stored in new format in CommcellTreeNode under associations
declare @associatedEntityIds table
(
	clientGroupId int,
	clientId int,
	appTypeId int,
	instanceId int,
	backupsetId int,
	subclientId int,
	excluded int,
	entityType int,
	ntRuleId int
)
if (@criteriaId=65)
begin
	-- Now for clients not online, we pick up active clients from NTAlertSubscriptions list for laptop alerts...
	-- Since there is no way to hide criteria, we pick up clients from entities selection list also
	-- For client specific subscriptions, we pick up from here.
	Insert into @selectedEntityIds(clientGroupId,clientId,appTypeId,instanceId,backupsetId,subclientId,excluded,ntRuleId)
	select 0,entityId1,0,0,0,0,0,NTAlertSubScriptions.ntRuleId from NTAlertSubScriptions with (nolock)
	inner join NTNotificationRule NTR with (nolock) on NTAlertSubScriptions.ntRuleId = NTR.id
	inner join NTSelCriteria NTsel with (nolock) on NTsel.ruleId = NTR.id
	where (NTsel.availCriteriaid = @criteriaId or @criteriaId=0)
and (NTR.status & (1|2))=0
	and NTAlertSubScriptions.entityId1<>0
	and NTAlertSubScriptions.entityType1=3
and (NTAlertSubScriptions.flags & 1)>0
	-- Now for global subscription, we include all clients this user is owner of
	Insert into @selectedEntityIds(clientGroupId,clientId,appTypeId,instanceId,backupsetId,subclientId,excluded,ntRuleId)
	select 0,UMOwnerCredentials.clientId,0,0,0,0,0,NTAlertSubScriptions.ntRuleId from NTAlertSubScriptions with (nolock)
	inner join NTNotificationRule NTR with (nolock) on NTAlertSubScriptions.ntRuleId = NTR.id
	inner join NTSelCriteria NTsel with (nolock) on NTsel.ruleId = NTR.id
	inner join UMOwnerCredentials on UMOwnerCredentials.userId=NTAlertSubScriptions.userId
	where (NTsel.availCriteriaid = @criteriaId or @criteriaId=0)
and (NTR.status & (1|2))=0
	and NTAlertSubScriptions.entityId1=0
	and NTAlertSubScriptions.entityType1=3
and (NTAlertSubScriptions.flags & 1)>0
end
declare @allXmls xml
--- Now handle associations also ...
set @allXmls = (select ntRuleId '@ntRuleId',associations.query('.')
		from @associationListTbl
		for xml path('associations'),root('newroot'))
Insert into @associatedEntityIds(clientGroupId,clientId,appTypeId,instanceId,backupsetId,subclientId,entityType,excluded,ntRuleId)
select
	ISNULL(Tbl.Col.value('@clientGroupId', 'int'),0),
	ISNULL(Tbl.Col.value('@clientId', 'int'),0),
	ISNULL(Tbl.Col.value('@applicationId', 'int'),0),
	ISNULL(Tbl.Col.value('@instanceId', 'int'),0),
	ISNULL(Tbl.Col.value('@backupsetId', 'int'),0),
	ISNULL(Tbl.Col.value('@subclientId', 'int'),0),
	ISNULL(Tbl.Col.value('@_type_', 'int'),0),
	ISNULL(Tbl.Col.value('(flags/@exclude)[1]', 'int'),0),
	ISNULL(Tbl.Col.value('(../@ntRuleId)[1]', 'int'),0)
	from
@allXmls.nodes('/newroot/associations/associations') as Tbl(Col)
-- In case all client groups are selected
if exists(select 1 from @associatedEntityIds
	where clientGroupId=0 and clientId =0 and appTypeId = 0 and instanceId = 0 and backupsetId =0 and subclientId = 0
	and excluded = 0 and entityType=27) --ALL_CLIENT_GROUPS_ENTITY
begin
	Insert into @selectedEntityIds(clientGroupId,clientId,appTypeId,instanceId,backupsetId,subclientId,excluded,ntRuleId)
	select distinct 0,App_ClientGroupAssoc.clientId,0,0,0,0,0,AssociatedEntities.ntRuleId
	from App_ClientGroupAssoc,
	@associatedEntityIds AssociatedEntities
	where AssociatedEntities.clientGroupId=0 and AssociatedEntities.clientId =0 and AssociatedEntities.appTypeId = 0 and AssociatedEntities.instanceId = 0 and AssociatedEntities.backupsetId =0 and AssociatedEntities.subclientId = 0
	and AssociatedEntities.excluded = 0 and AssociatedEntities.entityType=27
	delete from @associatedEntityIds
	where clientGroupId=0 and clientId =0 and appTypeId = 0 and instanceId = 0 and backupsetId =0 and subclientId = 0
	and excluded = 0 and entityType=27 --ALL_CLIENT_GROUPS_ENTITY
end
-- In case all clients are selected,
if exists(select 1 from @associatedEntityIds
	where clientGroupId=0 and clientId =0 and appTypeId = 0 and instanceId = 0 and backupsetId =0 and subclientId = 0
	and excluded = 0) --ALL_CLIENTS
begin
	Insert into @selectedEntityIds(clientGroupId,clientId,appTypeId,instanceId,backupsetId,subclientId,excluded,ntRuleId)
	select distinct 0,App_Client.Id,0,0,0,0,0,AssociatedEntities.ntRuleId
	from App_Client,
	@associatedEntityIds AssociatedEntities
	where AssociatedEntities.clientGroupId=0 and AssociatedEntities.clientId =0 and AssociatedEntities.appTypeId = 0 and AssociatedEntities.instanceId = 0 and AssociatedEntities.backupsetId =0 and AssociatedEntities.subclientId = 0
	and AssociatedEntities.excluded = 0
	delete from @associatedEntityIds
	where clientGroupId=0 and clientId =0 and appTypeId = 0 and instanceId = 0 and backupsetId =0 and subclientId = 0
	and excluded = 0
end
Insert into @selectedEntityIds(clientGroupId,clientId,appTypeId,instanceId,backupsetId,subclientId,excluded,ntRuleId)
select clientGroupId,clientId,appTypeId,instanceId,backupsetId,subclientId,excluded,ntRuleId
from @associatedEntityIds
-- If a client group is selected then all clients under the group is selected.
-- If a client group is not selected, then all clients under the group are not selected.
Insert into @selectedEntityIds(clientGroupId,clientId,appTypeId,instanceId,backupsetId,subclientId,excluded,ntRuleId)
select 0,App_clientGroupAssoc.clientId,0,0,0,0,AEIds.excluded,AEIds.ntRuleId
from App_clientGroupAssoc with (nolock) inner join @associatedEntityIds AEIds on
AEIds.clientGroupId = App_clientGroupAssoc.clientGroupId
where AEIds.clientId = 0
Insert into @expandedSelectedEntityIds(clientId,appTypeId,instanceId,backupsetId,subclientId,subclientStatus,excluded,ntRuleId)
select distinct App.clientId,App.appTypeId,App.instance,App.backupSet,App.id,App.subclientStatus,SelectedEntities.excluded,SelectedEntities.ntRuleId
from APP_Application App with (nolock)
inner join @selectedEntityIds SelectedEntities
on SelectedEntities.clientId = App.clientId
and (SelectedEntities.appTypeId = App.appTypeId or SelectedEntities.appTypeId = 0)
and (SelectedEntities.instanceId = App.instance or SelectedEntities.instanceId = 0)
and (SelectedEntities.backupsetId = App.backupSet or SelectedEntities.backupsetId = 0)
and (SelectedEntities.subclientId = App.id or SelectedEntities.subclientId = 0)
and (App.subclientstatus & (4|2))=0   --- We dont want deleted and uninstalled subclients _CV_STATUS_DELETED| CV_STATUS_UNINSTALLED
and SelectedEntities.clientId<>0
-- Now remove subclients which are not valid
Delete from @expandedSelectedEntityIds
where dbo.IsSubClientValid(appTypeId,subclientStatus,0)=0
-- Now remove entries which are excluded.
Delete ExpandedOuter from @expandedSelectedEntityIds ExpandedOuter,
(
	-- Figure out all subclients which are excluded and delete them.
	select ExpandedSubclients.subclientId, SelectedEntities.ntRuleId
	from @expandedSelectedEntityIds ExpandedSubclients
	inner join @selectedEntityIds SelectedEntities
	on SelectedEntities.clientId = ExpandedSubclients.clientId
	and (SelectedEntities.appTypeId = ExpandedSubclients.appTypeId or SelectedEntities.appTypeId = 0)
	and (SelectedEntities.instanceId = ExpandedSubclients.instanceId or SelectedEntities.instanceId = 0)
	and (SelectedEntities.backupsetId = ExpandedSubclients.backupsetId or SelectedEntities.backupsetId = 0)
	and (SelectedEntities.subclientId = ExpandedSubclients.subclientId or SelectedEntities.subclientId = 0)
	and SelectedEntities.clientId<>0
	and SelectedEntities.excluded=1
) t
where ExpandedOuter.subclientId = t.subclientId
and ExpandedOuter.ntRuleId = t.ntRuleId
-- also delete from @expandedSelectedEntityIds where excluded = 1
delete from @expandedSelectedEntityIds
where excluded=1
-- For all subscription based alerts, delete all clients which are not laptop clients.
delete expandedSelectedEntityIds
from @expandedSelectedEntityIds expandedSelectedEntityIds inner join App_client on
expandedSelectedEntityIds.clientId=App_client.id
inner join NTNotificationRule on
NTNotificationRule.id = expandedSelectedEntityIds.ntRuleId
and (NTNotificationRule.status & 128)>0
where (App_client.STATUS & 0x1000)=0
-- Apply agent filters on alerts' entities where apptype filters are given
declare @appTypesMatched table
(
	ntRuleId int,
	appType int,
	appTypeMatched int
)
Insert into @appTypesMatched(ntRuleId,appType ,appTypeMatched)
select distinct ntRuleId,appTypeId,0
from @expandedSelectedEntityIds
update @appTypesMatched
set appTypeMatched = dbo.IsAppTypeInNTAppTypeFilter(ntRuleId,appType)
where appType <> 0
update @appTypesMatched
set appTypeMatched = 1
where appType = 0
select distinct expandedSelectedEntityIds.clientId,expandedSelectedEntityIds.appTypeId ,expandedSelectedEntityIds.instanceId ,expandedSelectedEntityIds.backupsetId ,
	expandedSelectedEntityIds.subclientId ,expandedSelectedEntityIds.subclientStatus ,	expandedSelectedEntityIds.ntRuleId
from @expandedSelectedEntityIds expandedSelectedEntityIds
inner join @appTypesMatched appTypesMatched
on expandedSelectedEntityIds.ntRuleid=appTypesMatched.ntruleid
and expandedSelectedEntityIds.appTypeid=appTypesMatched.appType
where appTypesMatched.appTypeMatched=1
GO
--dummy check-in becuase one update on build 52 failed to get built correctly Form (52563).

IF EXISTS (select * from GxQscripts where name = 'br_ntGetExpandedEntityListForAlerts')
	delete from GxQscripts where name = 'br_ntGetExpandedEntityListForAlerts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_ntGetExpandedEntityListForAlerts')
	delete from GXDBVersions where aliasname = 'br_ntGetExpandedEntityListForAlerts'
GO

insert into GXDBVersions values(2, 'br_ntGetExpandedEntityListForAlerts',  '00010003004200040000', 'br_ntGetExpandedEntityListForAlerts', '00010003004200040000')
GO

