

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/br_ntGetCustomQueryProperties.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/br_ntGetCustomQueryProperties.sp,v $ $Id: br_ntGetCustomQueryProperties.sp,v 1.17.2.6 2018/03/27 08:59:45 jiechen Exp $";
--
--  +========================================================================+
--  |   Procedure:  br_ntGetCustomQueryProperties()
--  |
--  | Description:  SP for retreiving list of custom queries
--  |
--  |       Input:  XML input containing user id, localeid, List of input entities
--  |      Output:  XML Output containing queryId, Query friendly name and its properties if requested for
--  |      Return:  xxx
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  +========================================================================+-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: br_ntGetCustomQueryProperties <<<'

IF EXISTS (select * from sysobjects where name='br_ntGetCustomQueryProperties')
	drop procedure br_ntGetCustomQueryProperties
IF EXISTS (select * from GxQscripts where name='br_ntGetCustomQueryProperties')
	delete from GxQscripts where name = 'br_ntGetCustomQueryProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_ntGetCustomQueryProperties')
	delete from GXDBVersions where aliasname = 'br_ntGetCustomQueryProperties'
GO
print '... Creating Procedure: br_ntGetCustomQueryProperties'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure br_ntGetCustomQueryProperties
  @i_xml XML	
AS
declare @userId int
declare @localeId int
declare @getAllEntities int
declare @propertyLevel int
declare @queryType int
declare @externalEntityId nvarchar(max)
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
declare @inputQueryIdList table
(
	queryId int,
	queryType int,
	externalEntityId nvarchar(max)
)
declare @idoc int
DECLARE @adminUserId int
SET @adminUserId = (SELECT TOP 1 UMUsers.id FROM UMUsers WHERE ((UMUsers.flags & 0x040) <> 0) and enabled =1)
if @adminUserId is null
begin
	set @adminUserId = 1
end
SET @getAllEntities = ISNULL((SELECT  ref.value('@allEntities', 'int') AS Agent
                         FROM    @i_xml.nodes('App_GetQueryListForAlertsReq/listOptions') R ( ref )),0)
SET @propertyLevel = ISNULL((SELECT  ref.value('@propertyLevel', 'int') AS Agent
                         FROM    @i_xml.nodes('App_GetQueryListForAlertsReq/listOptions') R ( ref )),30) -- By default, all properties will be retrieved
SET @userId = ISNULL((SELECT  ref.value('@userId', 'int') AS Agent
                         FROM    @i_xml.nodes('App_GetQueryListForAlertsReq/processinginstructioninfo/user') R ( ref )),1)
SET @localeId = ISNULL((SELECT  ref.value('@localeId', 'int') AS Agent
                         FROM    @i_xml.nodes('App_GetQueryListForAlertsReq/processinginstructioninfo/locale') R ( ref )),0)
SET @queryType = ISNULL((SELECT  ref.value('@queryType', 'int') AS Agent
                         FROM    @i_xml.nodes('App_GetQueryListForAlertsReq/externalQueryEntity') R ( ref )),0)
SET @externalEntityId = ISNULL((SELECT  ref.value('@externalEntityId', 'nvarchar(max)') AS Agent
                         FROM    @i_xml.nodes('App_GetQueryListForAlertsReq/externalQueryEntity') R ( ref )),'')
EXEC sp_xml_preparedocument @idoc OUTPUT, @i_xml
Insert into @inputQueryIdList
SELECT *,0,0
FROM OPENXML(@idoc, '//App_GetQueryListForAlertsReq/queryId', 0)
WITH
(
	val		int
)
if (not exists(
	select 1 from @inputQueryIdList
	where queryId is not null
))
begin
	if (@getAllEntities=1)
	begin
		delete from @inputQueryIdList
		Insert into @inputQueryIdList
		select queryId,0,0 from NTQueryList with (nolock)
	end
end
declare @queryDetailsOutput table
(
	queryId int,
	friendlyName nvarchar(max),
	frequency int,
	isDisabled int,
	isSystemCreated int,
	queryCriteriaName nvarchar(max),
	isQuerySupportOutputFilter int,
	isModifyEnabled int,
	visibility int,
	taskInfoXml nvarchar(max),
	queryOutputColumns xml,
	associatedUserGroups xml,
	sqlQuery nvarchar(max),
	queryDescription nvarchar(max),
	queryParamsList xml,
	additionalQueryDetails xml,
	isPrimaryKeyPresent int,
	commcellAssociation xml,
	isOverwriteAssociationAtAlertAllowed int,
	entitySecurityAssociation xml,
	creatorId int,
	creatorName nvarchar(max),
	isRuleAssociatedWithAlert int
)
--Now ensure security here and ensure only visible queries for the user are returned.
declare @visibleQueries table
(
	queryId int
)
declare @entitySecurity table
(
	queryId int,
	userGroupId int,
	userGroupName nvarchar(max)
)
IF object_id('tempdb.dbo.#br_ntGetCustomQueryProperties_userObjects') is not null 		DROP TABLE #br_ntGetCustomQueryProperties_userObjects
create table  #br_ntGetCustomQueryProperties_userObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
EXEC sec_getUserObjects @userId,9651      ,0,'#br_ntGetCustomQueryProperties_userObjects'
-- If user has access at commcell level, then he can see all custom rules and for that entityId3 will be 0.
if exists(Select 1 from #br_ntGetCustomQueryProperties_userObjects where entityId3=0)
begin
	Insert INTO @visibleQueries
	select QueryId
	from NTQueryList with (nolock)
end
else
begin
Insert INTO @visibleQueries
	select QueryId
	from NTQueryList with (nolock)
	where queryCreator = @userId or @userId = @adminUserId -- Creator can always see queries he created. Also admin user can see all queries. This is done specifically for custom queries created for metrics reports.
	union
	select entityId3
	from #br_ntGetCustomQueryProperties_userObjects U with (nolock)
	inner join NTQueryList with (nolock)
		on NTQueryList.queryId = U.entityId3
	where NTQueryList.visibility = 1 -- We check sec_getUserObjects only for public queries.
end
IF object_id('tempdb.dbo.#br_ntGetCustomQueryProperties_userObjects') is not null 		DROP TABLE #br_ntGetCustomQueryProperties_userObjects
delete from @inputQueryIdList
where queryId not in
(
	select VisibleQueries.QueryId from @visibleQueries VisibleQueries
)
-- Update input entities list based on queryType and externalQueryId
Update InputQueries
set queryType = IsNull(convert(xml,NTqueryList.xmlInfo).value('(App_AdditionalQueryDetails/externalQueryEntity/@queryType)[1]','int'),1),
externalEntityId = IsNull(convert(xml,NTqueryList.xmlInfo).value('(App_AdditionalQueryDetails/externalQueryEntity/@externalQueryId)[1]','nvarchar(max)'),0)
from @inputQueryIdList InputQueries
inner join NTqueryList
on InputQueries.queryid = NTqueryList.queryId
where NTqueryList.xmlInfo is not null and len(NTqueryList.xmlInfo)>0
Update @inputQueryIdList
set queryType = 1
where queryType = 0
--- Now filter based on query Context.
-- If queryType of custom query doesnt match with input query Type or externalQueryId of custom query doesnt match with input then we remove them.
delete from @inputQueryIdList
where (@queryType <>0 and queryType <> @queryType)
or (len(@externalEntityId) > 0 and externalEntityId<>@externalEntityId)
-- Now always filter out LM alerts custom rule since user cant modify anything from GUI.
delete from @inputQueryIdList
where queryType=3
-- Now always filter out default hidden custom rules.
delete inputQueryIdList
from @inputQueryIdList inputQueryIdList
inner join NTQueryList on
NTQueryList.queryId = inputQueryIdList.queryId
and (NTQueryList.status&512)>0 -- NT_QUERY_HIDDEN
-- Now always filter out all external metrics rules for which no alert is present.
delete from @inputQueryIdList
where queryType=2 and queryId not in
(
	select NTNotificationQueryMapping.QueryId from NTNotificationQueryMapping
)
Insert into @queryDetailsOutput
select queryId,queryName,NULL,
CASE WHEN (status & 1)>0 THEN 1
	ELSE 0
	END, -- whether its disabled or not
CASE WHEN (status & 2)>0 THEN 1
	ELSE 0
	END, -- whether its system created or not
	queryCriteriaName,
CASE WHEN (status & 8)=0 THEN 1
	ELSE 0
	END, -- whether filter is supported or not
CASE WHEN (status & 256)=0 THEN 1
	ELSE 0
	END, -- For certain cases, query modification is not supported...
	visibility, -- whether its private or public
	NULL, -- taskInfo Xml
	NULL, -- query output columns xml
	NULL, -- associatedUserGroups xml
	NULL,	--sqlQuery
	NULL,	--queryDescription
	NULL,    -- queryParamsList
	NULL,    -- xmlInfo
	0,		 -- isprimarykey present
	'',
	isOverwriteAssociationAtAlertAllowed,
	NULL,	-- entitySecurityAssociation
	queryCreator, -- creatorId column
	NULL,
	NULL
from NTQueryList with (nolock)
where queryId in
(select InputQueries.queryId from @inputQueryIdList InputQueries)
Update QueryDetailsOutput
set creatorName=UMUsers.login
from @queryDetailsOutput QueryDetailsOutput
inner join UMUsers
on UMUsers.id=QueryDetailsOutput.creatorId
if @propertyLevel<>1
begin
	-- Now also update security information.
	Insert into @entitySecurity(userGroupId,userGroupName,queryId)
	select UMGroupAssociation.groupId,UMGroups.name,id1
	from UMGroupAssociation with (nolock)
	inner join UMGroups with (nolock)
	on UMGroups.id = UMGroupAssociation.GroupId
	inner join @inputQueryIdList InputQueries
	on InputQueries.queryId = UMGroupAssociation.id1
where type1 = 9651	 -- 9648
	INSERT INTO @entitySecurity(userGroupId,userGroupName,queryId)
	SELECT UG.id,UG.name,QueryDetails.queryId
	FROM UMGroups UG with (nolock)
	inner join @queryDetailsOutput QueryDetails on
	QueryDetails.visibility = 1 -- Public visibility we add master and view all always.
	where UG.allAssociations=1
	-- Now update associatedUserGroups and queryOutputColumns xml columns for each Query
	-- queryOutputColumns xml,
	-- associatedUserGroups xml
	Update QueryDetails
	set QueryDetails.queryOutputColumns = (
		select isColumnFilterable '@isColumnFilterable',
			columnName '@columnName',
			lmDataType '@lmDataType',
			columnFriendlyName '@columnFriendlyName',
			isPrimaryKey '@isPrimaryKey',
			(
				select _ID '@val' from dbo.SplitIDs(supportedOpTypes)
				for xml path('supportedOpTypes'), TYPE
			),
			convert(xml,
			replace(
				replace(convert(varchar(max),xmlInfo),'<App_AdditionalOutputColumnDetails','<columnAdditionalDetails'),
				'</App_AdditionalOutputColumnDetails>',
				'</columnAdditionalDetails>')
			)
		from NTQueryColumnList
		where NTQueryColumnList.queryId = QueryDetails.queryId
		and NTQueryColumnList.columnType = 0 -- Output column list
		order by NTQueryColumnList.columnIndex
		for xml path('queryOutputColumns'), TYPE
	)
	from @queryDetailsOutput QueryDetails
	Update QueryDetails
	set QueryDetails.queryParamsList = (
		select convert(xml,
			replace(
				replace(convert(nvarchar(max),xmlInfo),'<App_XMLSchema','<queryParamsList'),
				'</App_XMLSchema>',
				'</queryParamsList>')
			)
		from NTQueryColumnList
		where NTQueryColumnList.queryId = QueryDetails.queryId
		and NTQueryColumnList.columnType = 1 -- Input column list
		order by NTQueryColumnList.columnIndex
		for xml path(''), TYPE
	)
	from @queryDetailsOutput QueryDetails
	Update QueryDetails
	set QueryDetails.associatedUserGroups = (
		select distinct Security.userGroupId as '@userGroupId',
		Security.userGroupName as '@userGroupName'
		from @entitySecurity Security
		where Security.queryId = QueryDetails.queryId
		for xml Path('associatedUserGroups'), root('security'),Type
		)
	from @queryDetailsOutput QueryDetails
	Update QueryDetails
	set QueryDetails.additionalQueryDetails = convert(xml,
		replace(
				replace(convert(nvarchar(max),query.xmlInfo),'<App_AdditionalQueryDetails','<additionalQueryDetails'),
				'</App_AdditionalQueryDetails>',
				'</additionalQueryDetails>')
		)
	from @queryDetailsOutput QueryDetails
	inner join NTQueryList query with (nolock)
	on query.QueryId = QueryDetails.QueryId
	Update QueryDetails
	set QueryDetails.commcellAssociation = query.commcellAssociation.query('App_Associations/*')
	from @queryDetailsOutput QueryDetails
	inner join NTQueryList query with (nolock)
	on query.QueryId = QueryDetails.QueryId
	IF ( CURSOR_STATUS('global', 'QueryListcursor') >= 0   OR CURSOR_STATUS('local', 'QueryListcursor') >= 0 )  -- CLOSE CURSOR IF OPEN
		CLOSE QueryListcursor
	IF ( CURSOR_STATUS('global','QueryListcursor') = -1     OR CURSOR_STATUS('local','QueryListcursor') = -1 )
		DEALLOCATE QueryListcursor
	-- Now retrieve taskInfoXml for each query
	declare @currentQueryId int
	DECLARE QueryListcursor CURSOR for
	select QueryId from @inputQueryIdList
	Open QueryListcursor
	Fetch next FROM QueryListcursor into @currentQueryId
	WHILE @@FETCH_STATUS = 0
	begin
		declare @taskInfoXml xml
		set @taskInfoXml = ''
		declare @customtaskId int
		declare @queryGuid uniqueIdentifier
		declare @currQueryName nvarchar(max) = ''
		declare @currQueryDescription nvarchar(max) = ''
		declare @currRevision nvarchar(max) = ''
		declare @scriptDescription xml
		declare @commcellAssociation xml
		declare @scheduleDetailInfo table
		(
			value xml
		)
		declare @EntityIdToNameConverterInfo table
		(
			value xml
		)
		set @customtaskId = 0
		select @customtaskId = NTQueryList.taskId from NTQueryList with (nolock) inner join tm_subtask with (nolock) on
			NTQueryList.taskId = TM_subtask.taskId and NTQueryList.queryId = @currentQueryId
			inner join TM_patternassoc with (nolock) on TM_patternassoc.subtaskId = TM_subtask.subtaskId
			inner join TM_pattern with (nolock) on TM_patternassoc.patternId = TM_pattern.patternId
			and TM_pattern.deleted = 0
		select @queryGuid = GUID,@currQueryName=queryName,
		@currQueryDescription=queryDescription,
		@commcellAssociation = commcellAssociation
		 from NTQueryList where queryId = @currentQueryId
		 delete from @EntityIdToNameConverterInfo
		 Insert into @EntityIdToNameConverterInfo
		 exec EntityIdToNameConverter @commcellAssociation output
		 Update QueryDetails
		set QueryDetails.commcellAssociation = @commcellAssociation
		from @queryDetailsOutput QueryDetails
		where QueryDetails.QueryId = @currentQueryId
		 select @currRevision = additionalQueryDetails.value('(additionalQueryDetails/scriptDescription/@revision)[1]','nvarchar(max)')
		 from @queryDetailsOutput QueryDetails
		 where QueryDetails.queryid = @currentQueryId
		 set @scriptDescription = (select @queryGuid as '@guid',
			@currQueryName as '@reportName',
			@currQueryDescription as '@description',
			@currRevision as '@revision'
			for xml path('scriptDescription'))
		UPDATE QueryDetails
		SET additionalQueryDetails.modify('delete additionalQueryDetails/scriptDescription')
		from @queryDetailsOutput QueryDetails
		where QueryDEtails.queryId = @currentQueryId
		UPDATE QueryDetails
		SET additionalQueryDetails.modify('insert sql:variable("@scriptDescription") into (additionalQueryDetails)[1]')
		from @queryDetailsOutput QueryDetails
		where QueryDEtails.queryId = @currentQueryId
		declare @entitySecurityAssociation xml
		set @entitySecurityAssociation = ''
		-- Now we fill new security blob here.
		EXEC [dbo].[sec_getSecurityForEntity] @userId,
				@entitySecurityAssociation OUTPUT,
				124, --CUSTOM_QUERY_ENTITY
				@currentQueryId
		UPDATE QueryDetails
		SET entitySecurityAssociation = @entitySecurityAssociation
		from @queryDetailsOutput QueryDetails
		where QueryDetails.queryId = @currentQueryId
		delete from @scheduleDetailInfo
		if @customtaskId=0
		begin
			Fetch next FROM QueryListcursor into @currentQueryId
			continue
		end
		Insert into @scheduleDetailInfo
		exec dbo.TM_GetTaskDetail @customtaskId ,@adminUserId,0
		select top 1 @taskInfoXml = value from @scheduleDetailInfo
		set @taskInfoXml = (
			select T2.Loc.query('*')
			from @taskInfoXml.nodes('/TMMsg_GetTaskDetailResp/taskInfo') as T2(Loc)
			for xml path('TMMsg_TaskInfo'))
		Update @queryDetailsOutput
		set taskInfoXml = convert(nvarchar(max),@taskInfoXml)
		where QueryId = @currentQueryId
		Fetch next FROM QueryListcursor into @currentQueryId
	end
	IF ( CURSOR_STATUS('global', 'QueryListcursor') >= 0   OR CURSOR_STATUS('local', 'QueryListcursor') >= 0 )  -- CLOSE CURSOR IF OPEN
		CLOSE QueryListcursor
	IF ( CURSOR_STATUS('global','QueryListcursor') = -1     OR CURSOR_STATUS('local','QueryListcursor') = -1 )
		DEALLOCATE QueryListcursor
	--get the information if a rule is associated with any alert
	UPDATE QueryDetails
	SET QueryDetails.isRuleAssociatedWithAlert = 1
	FROM @queryDetailsOutput QueryDetails
	JOIN NTNotificationQueryMapping QueryMapping
	ON QueryDetails.QueryId = QueryMapping.QueryId
	JOIN NTnotificationrule NTRule
ON NTRule.id = QueryMapping.NTNotificationId and NTRule.revision = 1 and (NTRule.status & 2 ) = 0
end
Update QueryDetails
set QueryDetails.isPrimaryKeyPresent = 1
from @queryDetailsOutput QueryDetails
inner join NTQueryColumnList with (nolock)
on NTQueryColumnList.QueryId=QueryDetails.QueryId
where NTQueryColumnList.isPrimaryKey=1 and NTQueryColumnList.columnType=0
/* Not supporting localized versions for now..
-- Update the friendlyname with localized version if present
Update Query
set queryCriteriaName = dbo.fn_EvFormatEventMsgText(0,@localeId,NTQueryList.queryMessageId,0,2)
from @queryDetailsOutput Query,
NTQueryList
where Query.queryId = NTQueryList.queryId
and NTQueryList.queryMessageId <> 0
*/
Update @queryDetailsOutput
set queryCriteriaName = friendlyName
where queryCriteriaName is null or len(queryCriteriaName)=0
-- We currently dont return disabled queries for now.
-- Once GUI-Server protocol for this comes into place, we will do this based on flags
if @propertyLevel<>1
begin
	update Query
	set frequency = NTQueryList.defaultfrequency,
	sqlQuery = NTQueryList.queryString,
	queryDescription = NTQueryList.queryDescription
	from @queryDetailsOutput Query, NTQueryList	with (nolock)
	where Query.queryId = NTQueryList.queryId
end
set @i_xml = (
	select QueryDetails.frequency '@frequency',
	QueryDetails.queryCriteriaName '@queryCriteriaName',QueryDetails.isQuerySupportOutputFilter '@doesQuerySupportOutputFilter',
	QueryDetails.isDisabled '@isDisabled',QueryDetails.isModifyEnabled '@isQueryModifyEnabled',
	QueryDetails.isSystemCreated '@isSystemCreated',
	QueryDetails.visibility '@visibility',QueryDetails.taskInfoXml '@taskInfoXml',
	QueryDetails.sqlQuery '@sqlQuery',
	QueryDetails.queryDescription '@queryDescription',
	QueryDetails.isPrimaryKeyPresent '@isPrimaryKeyPresent',
	QueryDetails.isOverwriteAssociationAtAlertAllowed '@isOverwriteAssociationAtAlertAllowed',
	QueryDetails.isRuleAssociatedWithAlert '@isRuleAssociatedWithAlert',
	QueryDetails.queryId 'queryEntity/@queryId', QueryDetails.friendlyName 'queryEntity/@queryName',
	queryOutputColumns.query('.'),
	associatedUserGroups.query('.'),
	queryParamsList,
	additionalQueryDetails.query('.'),
	commcellAssociation,
	entitySecurityAssociation AS 'securityAssociations',
	creatorId as 'creator/@userId',
	creatorName as 'creator/@userName'
	from @queryDetailsOutput QueryDetails
	for xml path('queryEntities'),root('App_GetQueryListForAlertsResp')
)
if (@i_xml is null)
begin
	set @i_xml = '<App_GetQueryListForAlertsResp/>'
end
select @i_xml
GO

IF EXISTS (select * from GxQscripts where name = 'br_ntGetCustomQueryProperties')
	delete from GxQscripts where name = 'br_ntGetCustomQueryProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_ntGetCustomQueryProperties')
	delete from GXDBVersions where aliasname = 'br_ntGetCustomQueryProperties'
GO

insert into GXDBVersions values(2, 'br_ntGetCustomQueryProperties',  '00010017000200060000', 'br_ntGetCustomQueryProperties', '00010017000200060000')
GO

