

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/br_ntGetAlertruleDetail.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/br_ntGetAlertRuleDetail.sp,v $ $Id: br_ntGetAlertRuleDetail.sp,v 1.2.54.11 2018/11/02 19:57:21 mnatarajan Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   br_ntGetAlertRuleDetail   - Gets the alert detail in AlertRuleAdvancedDetail format
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='br_ntGetAlertRuleDetail')
BEGIN
	print '>>> Drop Stored Procedure: br_ntGetAlertRuleDetail <<<'
	drop procedure br_ntGetAlertRuleDetail
END
IF EXISTS (select * from GxQscripts where name='br_ntGetAlertRuleDetail')
	delete from GxQscripts where name = 'br_ntGetAlertRuleDetail'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_ntGetAlertRuleDetail')
	delete from GXDBVersions where aliasname = 'br_ntGetAlertRuleDetail'
GO
print '... Creating Procedure: br_ntGetAlertRuleDetail'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure br_ntGetAlertRuleDetail
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @callerID int,
  @alertId int,
  @localeId int
AS
SET NOCOUNT ON
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  BEGIN
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--Alert detail will be send to the user only if the alert is visible to the user
DECLARE @userHasRight INT = 0
DECLARE @errorCode INT = 0
DECLARE @errorString NVARCHAR(1024) = N''
DECLARE @o_responseXML XML
EXEC sec_checkPermissionOnEntity @callerID, 0, @userHasRight OUTPUT, 64, @alertId
IF @userHasRight = 0
BEGIN
SET @errorCode = (2829 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2829 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId)
    SET @errorString = REPLACE(@errorString, '^1%s', ISNULL((SELECT login FROM UMUsers WHERE id = @callerID),''))
SET @errorString = REPLACE(@errorString, '^2%s', (SELECT message FROM EvLocaleMsgs WHERE messageId = (2812 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId))
	set @o_responseXML = (
		SELECT
			(	SELECT	@errorCode as '@errorCode',
					@errorString as '@errorMessage'
				FOR XML PATH ('errorResponse'),TYPE
			)
			FOR XML PATH ('CVGui_AlertRuleAdvancedDetailResp')
		)
END
ELSE
BEGIN
	DECLARE @securityAssociations XML
EXEC sec_getSecurityForEntity @callerID, @securityAssociations OUTPUT, 64, @alertId
	declare @alertCriteria int
	DECLARE @textMessage NVARCHAR(MAX) = ''
	DECLARE @htmlMessage NVARCHAR(MAX) = ''
	DECLARE @textMessageEsc NVARCHAR(MAX) = ''
	DECLARE @htmlMessageEsc NVARCHAR(MAX) = ''
	SELECT @textMessage = NTMessageFormat.formatString FROM NTMessageFormat
	WHERE NTNotificationId = @alertId AND escalationLevel = 1
	AND messageType IN (4,8)
	SELECT @htmlMessage = NTMessageFormat.formatStringHTML FROM NTMessageFormat
	WHERE NTNotificationId = @alertId AND escalationLevel = 1
	AND messageType IN (1,8192)
	SELECT @textMessageEsc = NTMessageFormat.formatString FROM NTMessageFormat
	WHERE NTNotificationId = @alertId AND escalationLevel = 2
	AND messageType IN (4,8)
	SELECT @htmlMessageEsc = NTMessageFormat.formatStringHTML FROM NTMessageFormat
	WHERE NTNotificationId = @alertId AND escalationLevel = 2
	AND messageType IN (1,8192)
	select @alertCriteria = NSC.availCriteriaid
	from NTnotificationRule AS NRule with (nolock)
	LEFT OUTER JOIN NTSelCriteria  AS NSC with (nolock)
	ON NSC.ruleId = NRule.id
	where NRule.id=@alertId
	DECLARE @recipientTypetable TABLE
	(
		recipientType INT PRIMARY KEY(recipientType)
	)
	INSERT INTO @recipientTypetable
	VALUES (0), (1), (2)
	SET @o_responseXML = (
	  SELECT
		  ( SELECT
			  ( SELECT  alertTypeId AS '@alertType' , ruleState AS '@alertSeverity',ruleState2 AS '@escalationSeverity', xmlEntityList as 'EntityList', @securityAssociations as 'securityAssociations',
				  (SELECT id AS '@alertId' , notificationName AS '@alertName'
				   FROM NTnotificationRule with (nolock)
				   WHERE  id = @alertId
				   FOR XML PATH ('alertrule'),TYPE
				  ),
				  (SELECT messageType AS '@val'
				   FROM NTmessageFormat  with (nolock)
				   WHERE NTnotificationID = @alertId AND escalationLevel = 1 AND messageType <> 16 AND messageType <>131072
				   FOR XML PATH ('notifType'),TYPE
				  ),
				  (
					SELECT RT.recipientType '@recipientType',
					(
					  SELECT 13  AS'@_type_' , userid AS '@userId' , login as '@userName'
					  FROM NTnotificationUsers with (nolock)
					  LEFT OUTER JOIN UMUsers with (nolock)
					  ON userId = id
					  WHERE NTnotificationID = @alertId AND escalationLevel = 1
					  AND NTnotificationUsers.recipientType = RT.recipientType
					  FOR XML PATH ('userList'), TYPE
					)
					FROM @recipientTypetable RT
				   FOR XML PATH ('recipientUserList'), TYPE
				  ),
				  (
				   SELECT RT.recipientType '@recipientType',(
						SELECT  14 AS '@_type_', groupId AS '@userGroupId' , name as '@userGroupName'
						FROM NTnotificationGroups with (nolock)
						LEFT OUTER JOIN UMGroups with (nolock)
						ON groupId = id
						WHERE NTnotificationID = @alertId AND escalationLevel = 1
						AND NTnotificationGroups.recipientType = RT.recipientType
						FOR XML PATH ('userGroupList') ,TYPE
						)
						FROM @recipientTypetable RT
				  FOR XML PATH ('recipientUserGroupList'), TYPE
				  ),
				  (
					SELECT
					(
					SELECT nonGalaxyUserName AS '@val'
					FROM NTnotificationNonGalaxyUsers with (nolock)
					WHERE NTnotificationID = @alertId AND escalationLevel = 1 and recipientType=0 -- Put To list here...
					FOR XML PATH ('nonGalaxyUserList'),TYPE
					)
					FOR XML PATH ('regNonGalaxyUserList'),TYPE
				  ),
				  (
					SELECT RT.recipientType '@recipientType',
						(
						SELECT 13 AS '@_type_' ,userid AS '@userId' , login as '@userName'
						FROM NTnotificationUsers with (nolock)
						LEFT OUTER JOIN UMUsers with (nolock)
						ON userId = id
						WHERE NTnotificationID = @alertId AND escalationLevel > 1
						AND NTnotificationUsers.recipientType = RT.recipientType
						FOR XML PATH ('userList'),TYPE
						)
						FROM @recipientTypetable RT
						FOR XML PATH ('recipientEscUserList'), TYPE
				  ),
				  (
					SELECT RT.recipientType '@recipientType',
					(
						SELECT 14 AS '@_type_', groupId AS '@userGroupId' , name as '@userGroupName'
						FROM NTnotificationGroups with (nolock)
						LEFT OUTER JOIN UMGroups  with (nolock)
						ON groupId = id
						WHERE NTnotificationID = @alertId AND escalationLevel > 1
						AND NTnotificationGroups.recipientType = RT.recipientType
						FOR XML PATH ('userGroupList') , TYPE
					)
					FROM @recipientTypetable RT
					FOR XML PATH ('recipientEscUserGroupList'), TYPE
				  ),
				  (
					SELECT
					(
					SELECT nonGalaxyUserName AS '@val'
					FROM NTnotificationNonGalaxyUsers with (nolock)
					WHERE NTnotificationID = @alertId AND escalationLevel = 2 and recipientType=0 -- Put To list here...
					FOR XML PATH ('nonGalaxyUserList'),TYPE
					)
					FOR XML PATH ('EscNonGalaxyUserList'),TYPE
				  ),
				  (
					SELECT nonGalaxyUserName AS '@nonGalaxyUser',
						escalationLevel AS '@escalationLevel',
						recipientType as '@recipientType'
					FROM NTnotificationNonGalaxyUsers with (nolock)
					WHERE NTnotificationID = @alertId and recipientType<>0 -- To list mentioned above ...
					FOR XML PATH ('nonGalaxyUserList'), ROOT('nonGalaxyList'),TYPE
				  ),
				  (
					select @alertCriteria '@criteria', (
					SELECT paramIndex AS '@paramIndex',  type AS '@type', value AS '@value',unit AS '@unit'
					FROM NTnotificationRule AS NRule with (nolock)
					INNER JOIN NTSelCriteria  AS NSC with (nolock)
					ON NSC.ruleId = NRule.id
					INNER JOIN NTSelCriteriaParams AS NSCP with (nolock)
					ON NSC.id = NSCP.selCriteriaid
					WHERE NRule.id = @alertId  And NSC.availcriteriaid=@alertCriteria
					FOR XML PATH ('paramsList'),TYPE
					)
					FOR XML PATH ('criteria'),TYPE
				  ),
				  (SELECT locale AS '@localeID'
				   FROM NTnotificationRule  with (nolock)
				   WHERE id  =  @alertId
				   FOR XML PATH ('locale'),TYPE
				  ),
				  (
SELECT case when (status&16)>0 then 1 else 0 end '@isSendIndividualNotificationSelected',
case when (status&1024)>0 then 1 else 0 end '@processDiscoveredVMs'
						FROM NTnotificationRule  with (nolock)
						WHERE id  =  @alertId
						FOR XML PATH ('alertStatus'),TYPE
				  ),
				  (
					SELECT @textMessage '@textMessage',@htmlMessage '@htmlMessage' FOR XML PATH ('alertContent'),TYPE
				  )
				  FROM NTnotificationRule with (nolock)
				  WHERE id  =  @alertId
				FOR XML PATH ('alertDetail'),TYPE
			  ) ,
			(  SELECT reportingOptions AS '@reportingOptions',
					   delayTimeSeconds AS '@delayTimeSeconds',
					   persistTimeSeconds AS '@persistTimeSeconds'
				FROM NTSelCriteria AS NSC with (nolock)
				LEFT OUTER JOIN NTnotificationRule AS NRule with (nolock)
				ON NSC.ruleId = NRule.id
				WHERE NRule.id = @alertId and esclationLevel =1
				FOR XML PATH ('regularOption') ,TYPE
			 ),
			 ( SELECT reportingOptions AS '@reportingOptions',
					   delayTimeSeconds AS '@delayTimeSeconds',
					   persistTimeSeconds AS '@persistTimeSeconds'
				FROM NTSelCriteria AS NSC with (nolock)
				LEFT OUTER JOIN NTnotificationRule AS NRule with (nolock)
				ON NSC.ruleId = NRule.id
				WHERE NRule.id = @alertId and esclationLevel >1
				FOR XML PATH ('escOptions'),Type
			 ),
			 (
				 SELECT messageType AS '@val'
				 FROM NTmessageFormat  with (nolock)
				 WHERE NTnotificationID = @alertId AND escalationLevel >1 AND messageType <> 16 AND messageType <>131072
				 FOR XML PATH ('escNotifType'),TYPE
			 ),
			 (
				SELECT @textMessageEsc '@textMessage',@htmlMessageEsc '@htmlMessage' FOR XML PATH ('escAlertContent'),TYPE
			 )
			 FOR XML PATH ('alertDetail'),TYPE
		  ),
		  ( SELECT 0 AS '@errorCode',
					N'' as '@errorMessage'
			FOR XML PATH ('errorResponse'),TYPE
		  )
		  FOR XML PATH ('CVGui_AlertRuleAdvancedDetailResp')
	  )
END
select @o_responseXML as o_responseXML
SET NOCOUNT OFF
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  END
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
GO

IF EXISTS (select * from GxQscripts where name = 'br_ntGetAlertruleDetail')
	delete from GxQscripts where name = 'br_ntGetAlertruleDetail'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_ntGetAlertruleDetail')
	delete from GXDBVersions where aliasname = 'br_ntGetAlertruleDetail'
GO

insert into GXDBVersions values(2, 'br_ntGetAlertruleDetail',  '00010002005400110000', 'br_ntGetAlertruleDetail', '00010002005400110000')
GO

