

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/br_ntFormatNotificationToSend.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/br_ntFormatNotificationToSend.sp,v $ $Id: br_ntFormatNotificationToSend.sp,v 1.93.42.3 2017/02/10 21:21:45 sjohnson Exp $";
--
--  +========================================================================+
--  |   Procedure:  br_ntFormatNotificationToSend()
--  |
--  | Description:  Intended to be called by Cursor "NTgetNotificationsToSend"
--	|				and others.  Fetches rows & formats Subject & Message Body
--	|				fields by token substitution.
--  |
--  |       Input:  messageType
--	|
--  |      Output:  xxx
--  |      Return:  xxx
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  +========================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: br_ntFormatNotificationToSend <<<'

IF EXISTS (select * from sysobjects where name='br_ntFormatNotificationToSend')
	drop procedure br_ntFormatNotificationToSend
IF EXISTS (select * from GxQscripts where name='br_ntFormatNotificationToSend')
	delete from GxQscripts where name = 'br_ntFormatNotificationToSend'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_ntFormatNotificationToSend')
	delete from GXDBVersions where aliasname = 'br_ntFormatNotificationToSend'
GO
print '... Creating Procedure: br_ntFormatNotificationToSend'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure br_ntFormatNotificationToSend
  @notifId integer ,
  @inpTriggerTime DATETIME ,
  @escLevel integer ,
  @messType integer ,
  @maxMessageBodySize integer,
  @entities NTEXT
AS
Set transaction isolation level read uncommitted
DECLARE @brAlertTrace			varchar(256)
set @brAlertTrace				=(select value from gxglobalParam Where name = 'bralertTrace')
set @brAlertTrace               = ISNULL(@brAlertTrace, 0)
----------------------------------------------------------
--	FETCH PARAMETERS FROM THE XML STRING PASSED IN	--
----------------------------------------------------------
if @brAlertTrace <> 0
	exec br_ntTrace '.. br_ntFormatNotificationToSend', @notifId, @inpTriggerTime, @escLevel, 0, @entities
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--   PARAMETERS   &   OUTPUTS
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
DECLARE @iDoc     				integer
DECLARE @commcellId				integer
DECLARE @alertName				NVARCHAR(256)
DECLARE @notifOwnerId			integer
DECLARE @localeId				integer
DECLARE @notifState				integer
DECLARE @qnetId					integer
DECLARE @triggerBitMap			integer
DECLARE @triggerEvalCriteria	integer
DECLARE @thresholdValue			integer
DECLARE @thresholdTime			integer
DECLARE @measuredValue			integer
DECLARE @measuredTime			integer
DECLARE @scalarType				NVARCHAR(256)
-- Following is (english) "% of", or empty string
DECLARE @scalarTypeName			NVARCHAR(8)
DECLARE @statusString			NVARCHAR(80)
DECLARE @timePeriodUnit			VARCHAR(10)
DECLARE @displaytimeUnits		NVARCHAR(256)
declare @listTokenId			BIGINT
DECLARE @notifOwnerName			NVARCHAR(256)
DECLARE @alertTypeName			NVARCHAR(256)
DECLARE @rawMessage				NVARCHAR(MAX)
DECLARE @tokenMessage			NVARCHAR(MAX)
DECLARE @loginList				NVARCHAR(MAX)
DECLARE @emailList				NVARCHAR(MAX)
DECLARE @noEmailList			NVARCHAR(MAX)
DECLARE @tokenStrVal			NVARCHAR(MAX)
DECLARE @AlertCategoryName		NVARCHAR(1024)
DECLARE @attachTokenMsg			NVARCHAR(256)
DECLARE @PTRVAL					varbinary(16)
DECLARE @msgCount				integer
DECLARE @alertTypeId			integer
DECLARE @msgTokenId				integer
DECLARE @encodingType			integer
DECLARE @subjectMessage			NVARCHAR(MAX)
DECLARE  @msgTokenVal  nvarchar(MAX)
DECLARE  @msgId			integer
DECLARE  @index			integer
DECLARE  @jobId			nvarchar(256)
declare @attachedFile	nvarchar(1024)
declare @attachedName	nvarchar(1024)
declare @userId 	integer
declare @eSeperator   nvarchar(10)
declare @lSeperator   nvarchar(10)
declare @neSeperator  nvarchar(10)
DECLARE @msgSeperator  nvarchar(256)
DECLARE @actualMsgSeperator  nvarchar(256)
DECLARE @msgHrzSeperator  nvarchar(256)
DECLARE @notAvailStr   nvarchar(256)
declare @login		nvarchar(1024)
declare @email		nvarchar(1024)
declare @userName	nvarchar(1024)
DECLARE @strCondiHappTime nvarchar(1024)
--Below variable are seperated by ; for multiple message
DECLARE @clientNames nvarchar(1024)
DECLARE @idaNames	 nvarchar(1024)
DECLARE @instanceNames nvarchar(1024)
DECLARE @bsetNames	   nvarchar(1024)
DECLARE @scNames	   nvarchar(1024)
DECLARE @maNames	   nvarchar(1024)
DECLARE @spNames	   nvarchar(1024)
DECLARE @libNames	   nvarchar(1024)
DECLARE @allStatus	   nvarchar(1024)
DECLARE @oldAlertTypes		nvarchar(1024)
DECLARE @oldAlertActions 	nvarchar(1024)
DECLARE @tokenclientName nvarchar(1024)
DECLARE @tokenidaName	 nvarchar(1024)
DECLARE @tokeninstanceName nvarchar(1024)
DECLARE @tokenbsetName	   nvarchar(1024)
DECLARE @tokenscName	   nvarchar(1024)
DECLARE @tokenmaName	   nvarchar(1024)
DECLARE @tokenspName	   nvarchar(1024)
DECLARE @tokenlibName	   nvarchar(1024)
DECLARE @tokenStatus	   nvarchar(1024)
DECLARE @tokenCriteria	   nvarchar(1024)
DECLARE @notifCriteriaForFeeds 	nvarchar(1024)
DECLARE @notifCriteriaId	int
DECLARE @tokListType       integer
DECLARE @queryId			integer
DECLARE @oldAlertTypeId     integer
DECLARE @oldAlertActionId	integer
declare @liveFeedsJobIdint	int
declare @table table
(
	Id int ,
	Data nvarchar(max)
)
declare @PreviousEntriesTable table
(
	Id int ,
	Data nvarchar(max)
)
declare @validFlags		integer
----------------------------------------------------------------------------------------------
-- NOW THAT ALL THE TOKENS HAVE BEEN PROCESSED, WE CAN SPLIT THE MESSAGE INTO SUBJECT AND 	--
-- MESSAGE BODY COMPONENTS																	--
----------------------------------------------------------------------------------------------
declare @SubjFieldStart	integer
declare @SubjFieldLen	integer
declare @MsgBodyStart	integer
declare @MsgBodyLen		integer
declare @totalLen		integer
declare @subjToken		nvarchar(128)
declare @bodyToken		nvarchar(128)
declare @CRNL			nvarchar(10)
declare @MSGSEP			nvarchar(10)
declare @QnetNewLine	nvarchar(25)
declare @QnetNewLineLen	integer
declare @TokenString  nvarchar(MAX)
declare @tokenLen  int
declare @tokenOffset  int
declare @isHtmlEncoding	int
declare @formattedMsgBodyStart int
declare @variableBodyString nvarchar(MAX)
declare @variableBodyEndString nvarchar(MAX)
declare @postAmbleMessage nvarchar(MAX)
declare @fixedBodyString nvarchar(MAX)
declare @curentfixedBodyString nvarchar(MAX)
declare @isVariableMessageIncluded int
declare @isVariableMessageEndIncluded int
declare @shldPostAmbleBePrepended	int
declare @variablebodyStart int
declare @variablebodyEndStart int
declare @clientId		int
declare @cnt int = 0
declare @firstVaryingComponent int = 0
set @fixedBodyString = ''
set @variablebodyStart = 0
DECLARE @notApplicableTokenMsg			NVARCHAR(max)
DECLARE @reportCriteriaTokenMsg			NVARCHAR(max)
DECLARE @severity INTEGER
DECLARE @autoComputeSeverity INTEGER = 0
IF @escLevel = 1
	SET @severity = (SELECT ruleState FROM NTNotificationRule WHERE id = @notifId)
ELSE
	SET @severity = (SELECT ruleState2 FROM NTNotificationRule WHERE id = @notifId)
IF @severity = 0
	SET @autoComputeSeverity = 1
DECLARE @CriteriaIds TABLE(criterias INTEGER)
SELECT @alertTypeId =  alertTypeId from NTnotificationRule where id = @notifId
-- Now we have introduced new token <VARIABLE BODY> to indicate Part of the format message
-- which varies within mail and those which remain mostly same within mail.
set @CRNL 			=CHAR(13)+CHAR(10)
set @MSGSEP			= CHAR(20)
set @QnetNewLine    = 'MsgNewLine_'
set @QnetNewLineLen = 11					--hardcoded 'cause LEN() discounts trailing spaces!
set @isHtmlEncoding = 0
set @SubjFieldLen	= 0
set @MsgBodyLen		= 0
-- FOLLOWING ADDED FOR LAPTOP ALERTS --
DECLARE	@laptopClientName	nvarchar(256)
DECLARE @laptopClientId	as integer	= 0
/*
PARAM	notifId				integer ,
  @inpTriggerTime DATETIME ,
  @escLevel integer ,
  @messType integer ,
  @maxMessageBodySize integer,
  @entities NTEXT
*/
if exists(select 1 from NTNotificationRule where id = @notifId and revision = 0 and status=2)
begin
	-- In case alert is already deleted, then we dont process these entries and send notifications unnecessarily
	-- This is mainly needed for LM alerts where GetNotifications SP started reading all valid entries from message history
	-- and calls format notification on each row. if alert is deleted in the middle, then we might get blank emails.
	Goto RETURNRESULTS
end
DECLARE @isOwnerReporting as integer =  0
IF EXISTS (select 1 from NTnotificationRule where [ID] = @notifId and (status & 128)>0)
	SET @isOwnerReporting = 1
-- --------------------------------- --
--------------------------------------------------------------------
--	TABLE ##entityList will be used to create a unique list of --
--  token values --
--------------------------------------------------------------------
	if object_id('tempdb.dbo.##entityList') is not null
		DROP TABLE ##entityList
	CREATE TABLE ##entityList
	(
		msgIndex		int,
		tokenId			int,
		tokenVal	    nvarchar(max),
		msgIndexNew		int
	)
--------------------------------------------------------------------
--	TABLE #RecepientsList will be used to create a unique list of --
--  .. recepients from selected users and groups                  --
--------------------------------------------------------------------
	if object_id('tempdb.dbo.#recepientsList') is not null
		DROP TABLE #RecepientsList
	CREATE TABLE #RecepientsList
	(
		userId		int,
Login       nvarchar(255),
UserName    nvarchar(255),
-- type = 0 => user; type = 1 => external group; type = 2 => non-galaxy users;
		type		int,
Email       nvarchar(255)
	)
----------------------------------------------------------
-- FIND ALL THE NOTIFICATIONS WE NEED EMAILS FOR FIRST	--
----------------------------------------------------------
--                                                      (Encoding Type may be overwritten later)
set @encodingType		= 1
	set @attachedFile		= N''
	set @attachedName		= N''
set @validFlags			= CAST(0x001 AS INT)						--'USERS_VALID'
if (@messType = 1 OR @messType = 512 OR @messType = 8192 OR @messType=65536)
    begin
		-- Check whether the active mfoption is plain text(0) or html (1)
		-- Currently only 1 mfoption per alert is supported.
		set @isHtmlEncoding = IsNull((select 1 from NTmessageFormat
			where NTnotificationID = @notifId and messageType = @messType
			and escalationLevel = @escLevel
			and messageFormatType = 1),0) -- by default messageFormatType = 2 FOR TEXT and 1 for HTML
		if (@isHtmlEncoding = 1)
		begin
set @encodingType = 4 --_ENCODE_SMTP_HTMLTEXT
		end
	end
--  Moved tuis up from below so we could have the entities list to obtain the client Name from the tokens list
exec sp_xml_preparedocument @iDoc OUTPUT, @entities
INSERT INTO  ##entityList (msgIndex, tokenId, tokenVal,msgIndexNew)
		SELECT id, tokenId, dbo.decodeInvalidXmlChar(val),id
		FROM OPENXML(@iDoc, 'CVGui_DetectedAlertsData/details/tokVal/tokenValueList', 0)
		WITH (id int '../../@index', tokenId int '../@tokenId' , val nvarchar(max) '@val' )
--
----------------------------------------------------------------------
--	FLUSH OUT EMAIL RECEPIENTS, AS REQUIRED BY NOTIFICATION TYPE	--
----------------------------------------------------------------------
IF  @messType in (1, 8192)
BEGIN
	IF (@isOwnerReporting <> 0)			--'NT_STATUS_LAPTOP_ALERT'
	BEGIN						-- NEED TO FETCH EMAILS FROM USERS/GROUPS WHO "OWN" THE CLIENT
SET @lapTopClientName = ISNULL((Select tokenVal from ##entityList where tokenId = (42 | (CAST(POWER(2, 24) AS BIGINT) * 74))), N'')		-- 'ALERT_TOKEN_CLIENT_NAME'
		SET @lapTopClientId	  = ISNULL((Select id from APP_CLIENT Where name=@lapTopClientName), 0)
		INSERT #RecepientsList(userId, type)
			SELECT	userId, 0
			FROM	sec_getClientOwnersConfig owners
			WHERE	owners.clientId = @lapTopClientId and owners.userId <> 0
		UNION
			SELECT UG.userId,0
				FROM sec_getClientOwnersConfig AS owners, UMuserGroup as UG, UMgroups as G
				WHERE  owners.clientID = @clientId
				AND ((owners.userGroupId <> 0 AND owners.userGroupId = G.id) OR (owners.externalGroupId <> 0 AND owners.externalGroupId = G.id))
				AND G.id = UG.groupId
AND (G.groupFlags & 0x0001) = 0x0001			--'GF_GROUP_ENABLED'
		UNION
		SELECT UMDSUG.userid,0
				FROM sec_getClientOwnersConfig AS owners, UMDSGroups as UEG,UMDSUserGroup UMDSUG,UMDSGroupMaps UMDSGM,
				UMGroups AS G
				WHERE owners.usergroupId = UMDSGM.umgroupId
				 AND owners.clientId = @clientId
				  AND UMDSGM.umDSgroupId = UMDSUG.groupId
				  AND  G.id       = UMDSGM.umgroupId
				  AND  ((G.groupFlags & 1) =1)
		-- Now that client owners are retrieved, we will remove users who dont wish to be notified.
		declare @userSubscription table
		(
			userId int,
			flags int,
			preferenceLevel int
		)
		-- First we give preference to users
		Insert into @userSubscription
		select userId,flags,0 from NTAlertSubScriptions
		where ntRuleId=@notifId
		and @lapTopClientId = clientID
		and @lapTopClientId > 0
		and escalationLevel = @escLevel
		Insert into @userSubscription
		select userId,flags,1 from NTAlertSubScriptions
		where ntRuleId=@notifId
		and clientID = 0
		and escalationLevel = @escLevel
		-- First we check whether that client is a dlo client.
		if exists(select  1 from App_client
where (STATUS & 0x1000)>0
			and id=@lapTopClientId)
		begin
			-- Then check whether this client is part of entity selection list for this alert.
			declare @genericEntity nvarchar(max)
			declare @resultMatch int = 0
			set @genericEntity = '<CvEntities_GenericEntity clientId="'+convert(nvarchar(10),@lapTopClientId)+'"/>'
			declare @subscripNTRuleXmlEntityList xml
			select @subscripNTRuleXmlEntityList = xmlEntityList from NTNotificationRule
			where id=@notifId
			declare @entityCheckResult table
			(
				result int
			)
			set @subscripNTRuleXmlEntityList = @subscripNTRuleXmlEntityList.query('CVGui_CommCellTreeNode/associations')
			set @subscripNTRuleXmlEntityList = convert(xml,replace(replace(convert(nvarchar(max),@subscripNTRuleXmlEntityList),
				'<associations','<entity'),'</associations>','</entity>'))
			set @subscripNTRuleXmlEntityList = (
				select @subscripNTRuleXmlEntityList.query('.')
				for xml path(''),root('App_Associations')
				)
			Insert into @entityCheckResult
			exec AppCheckEntityIncluded @genericEntity,@subscripNTRuleXmlEntityList,@notifId
			select @resultMatch = result From @entityCheckResult
			if @resultMatch=1
			begin
				Insert into @userSubscription
				-- Now we want to enable subscription based alert for all users by default even if they havent made any selection from webconsole.
select ClientOwners.userId,1,2 from #RecepientsList ClientOwners
				left join NTAlertSubScriptions on
				NTAlertSubScriptions.userId = ClientOwners.userId and
				NTAlertSubScriptions.ntRuleId = @notifId and
				(NTAlertSubScriptions.clientId = @lapTopClientId Or NTAlertSubScriptions.clientId = 0)
				where ClientOwners.userId <> 0
				and @lapTopClientId > 0
				and NTAlertSubScriptions.ntRuleId is null
			end
		end
		-- Retrieve users who want to get notified. And remove the rest.
		delete from #RecepientsList
		where userId not in
		(
			select userId from
			(
				select userId,flags,
				Rank() over (Partition by userId Order by preferenceLevel) as rowNo
				from @userSubscription
			) t
			where rowNo = 1
and ((flags & 1)>0)
		)
		and type=0
		-- IF @lapTopClientId = 0 .. NEED TO ABORT OUT SOMEHOW?
		-- TODO, FLUSH OUT GETTING EMAIL RECEPIENTS BASED ON A JOIN WITH TABLE "UMUserandGroupEntityAssociation".
		-- .. (Should be a mimic of code to retrieve from NT tables below)
	END
	Else
	BEGIN						-- NOT A LAPTOP ALERT, FETCH EMAILS STORED WITH ALERT ITSELF
		INSERT INTO   #RecepientsList(userId,type)
		SELECT NU.userId,0
		  FROM NTnotificationUsers AS NU
			WHERE NU.NTnotificationId = @notifId
				AND NU.escalationLevel = @escLevel
		UNION
		SELECT UG.userId,0
				FROM NTnotificationGroups AS NG, USuserGroups as UG, USgroups as G
				WHERE NTnotificationId = @notifId	AND escalationLevel = @escLevel
				  AND G.groupId = UG.groupId
				  AND NG.groupId = UG.groupId
AND (G.groupFlags & 0x0001) = 0x0001			--'GF_GROUP_ENABLED'
		UNION
		SELECT NEG.externalGroupId,1
				FROM NTnotificationExternalGroups AS NEG, UMDSGroups as UEG
				WHERE NTnotificationId = @notifId	AND escalationLevel = @escLevel
				  AND NEG.externalGroupId = UEG.id
				  AND UEG.enabled = 1
		-- Inserting the non-galaxy user information
		INSERT INTO   #RecepientsList(type,Email)
		SELECT 2,NNG.nonGalaxyUserName FROM NTnotificationNonGalaxyUsers NNG
		WHERE NTnotificationId = @notifId	AND escalationLevel = @escLevel
	END
END
                                ----------------
	set @commcellId = (SELECT TOP 1 id from APP_CommCell where clientId > 0)
	set @localeId			= (select locale			FROM NTnotification WHERE NTnotificationId = @notifId AND revision > 0)
	set @notifOwnerId		= (select notifOwner		FROM NTnotification WHERE NTnotificationId = @notifId AND revision > 0)
	set @alertName			= (select notificationName	FROM NTnotification WHERE NTnotificationId = @notifId AND revision > 0)
	if @isHtmlEncoding=0
	begin
		set @rawMessage			= (select formatString		FROM NTmessageFormat WHERE NTnotificationID = @notifId
															AND EscalationLevel = @escLevel AND messageType = @messType)
	end
	else
	begin
		set @rawMessage			= (select formatStringHtml 	FROM NTmessageFormat WHERE NTnotificationID = @notifId
															AND EscalationLevel = @escLevel AND messageType = @messType)
	end
set @subjToken      =	dbo.fn_EvFormatEventMsgText(0,@localeId,(2 | (CAST(POWER(2, 24) AS BIGINT) * 74)), 0,2)
set @bodyToken      =	dbo.fn_EvFormatEventMsgText(0,@localeId,(1 | (CAST(POWER(2, 24) AS BIGINT) * 74)), 0,2)
	-- Now html specific handling is to be done only for Body and not for subject.
	-- Currently when we replace tokens , we shld (html escape them) and replace them only for body and not for subject.
	-- So ideally we shld split it into variables and replace all tokens in both variables (instead of 1 as is done for @rawmessage)
	-- That wuld be too costly. So for html encoding, we escape Subject also. Html Escape tokens and replace them appropriately
	-- Then we un-escape subject component.
	if @isHtmlEncoding=1
	begin
		set @formattedMsgBodyStart  = (SELECT PATINDEX('%'+@bodyToken+'%', @rawMessage ))
		set @subjectMessage			= ''
		if @formattedMsgBodyStart>1
		begin
			set @subjectMessage		= SUBSTRING(@rawMessage,1,@formattedMsgBodyStart-1)
		end
		set @rawMessage				= SUBSTRING(@rawMessage,Len(@subjectMessage)+1,LEN(@rawMessage)-Len(@subjectMessage)+1)
		-- Then we escape Subject part
		set @subjectMessage			= dbo.getHtmlEscapedString(@subjectMessage,1)
		set @rawMessage				= @subjectMessage+@rawMessage
		--select @rawMessage
	end
	set @tokenMessage = @rawMessage
	set @AlertTypeName		=  dbo.fn_EvFormatEventMsgText(0,@localeId, (SELECT nameID
														FROM NtAlertType as AT, NTnotificationRule AS NR
														WHERE NR.id = @notifId
														  AND NR.alertTypeId = AT.id) ,0,2)
	-- For custom alerts, the query name will be the alert type.
if (@alertTypeId = 65)
	begin
		set @queryId = 0
		select @AlertTypeName = substring(NTQueryList.queryName,1,255),@queryId = NTQueryList.queryId
		from NTQueryList with (nolock)
		inner join NTNotificationQueryMapping with (nolock)
		on NTQueryList.queryId = NTNotificationQueryMapping.queryId
		where NTNotificationQueryMapping.NTNotificationId = @notifId
	end
	set @AlertCategoryName		=  dbo.fn_EvFormatEventMsgText(0,@localeId, (SELECT nameID
														FROM NtCategory as AT, NTnotificationRule AS NR
														WHERE NR.id = @notifId
														  AND NR.categoryId = AT.id) ,0,2)
	set @attachedFile = ISNULL((SELECT attachmentPath  FROM NTMessageHistory where NTnotificationId = @notifId AND triggerTime= @inpTriggerTime AND escalationLevel = @escLevel), '')
	set @attachedName = ISNULL((SELECT attachmentName FROM NTMessageHistory where NTnotificationId = @notifId AND triggerTime= @inpTriggerTime AND escalationLevel = @escLevel), '')
	-- Now for the message type, we retrieve attachmentPath and attachmentName.
	declare @attachmentIndex int
	set @attachmentIndex = PatIndex('%**'+convert(nvarchar(10),@messType)+'*%**%', @attachedFile)
	if @attachmentIndex>0
	begin
		set @attachedFile = SUBSTRING(@attachedFile,
			@attachmentIndex + LEN('%%'+convert(nvarchar(10),@messType)+'%'),
			LEN(@attachedFile))
		set @attachmentIndex = PATINDEX('%**%',@attachedFile)-1
		if @attachmentIndex<0
			set @attachmentIndex =0
		set @attachedFile = SUBSTRING(@attachedFile,
			1,
			@attachmentIndex)
	end
	else
	begin
		set @attachedFile = ''
	end
	set @attachmentIndex = PatIndex('%**'+convert(nvarchar(10),@messType)+'*%', @attachedName)
	if @attachmentIndex>0
	begin
		set @attachedName = SUBSTRING(@attachedName,
			@attachmentIndex + LEN('%%'+convert(nvarchar(10),@messType)+'%'),
			LEN(@attachedName))
		set @attachmentIndex = PATINDEX('%**%',@attachedName)-1
		if @attachmentIndex<0
			set @attachmentIndex =0
		set @attachedName = SUBSTRING(@attachedName,
			1,
			@attachmentIndex)
	end
	else
	begin
		set @attachedName = ''
	end
	set @notifOwnerName = (select login FROM UMUsers WHERE id = @notifOwnerId)
if (@messType = 1)
	BEGIN
		if @isHtmlEncoding=0
		begin
			set @msgSeperator = N'MsgNewLine_*****************************************************************MsgNewLine_ '
		end
		else
		begin
			set @msgSeperator = N'MsgNewLine_<hr>MsgNewLine_ '
		end
		set @msgHrzSeperator = N'MsgNewLine_ =================================================================MsgNewLine_ '
	END
	else
	BEGIN
		set @msgSeperator =  @MSGSEP
		set @msgHrzSeperator =  N''
	END
	set @notAvailStr = N'Not Available'
------------------------------------------------------------------------
-- WE'VE ALREADY FILTERED OUT GROUPS THAT ARE DISABLED, BUT NOW PRUNE --
-- RECEPIENTS LIST OF USERS THAT ARE DISABLED                        --
------------------------------------------------------------------------
	DeLeTe #RecepientsList
		FROM  #RecepientsList AS RL, UMUsers as U
			WHERE RL.userID = U.id
			  AND RL.type = 0
			  AND U.enabled = 0
IF ( @messType = 1 )
BEGIN
	UPDATE #RecepientsList
	SET login = US.login, UserName = US.name, Email=US.Email
	FROM #RecepientsList as RL, UMUsers AS US
    WHERE RL.userId = US.id AND RL.type = 0
-- External Groups
	UPDATE #RecepientsList
	SET login = UEG.name, UserName = UEG.name, Email=UEG.Email
	FROM #RecepientsList as RL, UMDSGroups AS UEG
    WHERE RL.userId = UEG.id AND RL.type = 1
END
IF ( @messType = 2)
	UPDATE #RecepientsList
	SET login = US.login, UserName = US.name, Email=US.pager
	FROM #RecepientsList as RL, UMUsers AS US
    WHERE RL.userId = US.id and RL.type = 0
---------------------------------------------------------------------------------------------------------------
-- Following code IS common to both NTNotification[Users, Groups] and scheduler derived lists               ---
---------------------------------------------------------------------------------------------------------------
	SET     @eSeperator  = ''
	SET     @lSeperator  = ''
	SET     @neSeperator = ''
	SET 	@emailList   = ''
	SET 	@noEmailList = ''
	SET 	@loginList   = ''
	-- "NT_RUNCMD_ALERTNOTIF, NT_SNMP_ALERTNOTIF, NT_APPLOG_ALERTNOTIF"
IF @messType not in (16, 4, 8)
    BEGIN
		DECLARE conCat_Cursor CURSOR FOR
			SELECT DISTINCT userId, login, userName, email
			FROM #RecepientsList
		OPEN conCat_Cursor
		FETCH NEXT FROM conCat_Cursor INTO @userId, @login, @UserName, @email
		WHILE @@FETCH_STATUS = 0
		BEGIN
			if (@email <> '')
			BEGIN
				set @emailList     = @emailList     + @eseperator + @email
				set @eSeperator = '; '
			END
			else
			BEGIN
				set @noEmailList     = @noEmailList     + @neseperator + @login
				set @neSeperator = '; '
			END
			if (@login <> '')
			BEGIN
				set @loginList     = @loginList     + @lseperator + @login
				set @lSeperator = '; '
			END
				FETCH NEXT FROM conCat_Cursor INTO @userId, @login, @UserName, @email
		END
		CLOSE       conCat_Cursor
		DEALLOCATE  conCat_Cursor
	END
DROP TABLE #RecepientsList
--------------------------------------------------------------------------------------
-- FOR EACH TOKEN TYPE WE SUPPORT, REPLACE THE TOKENS WITH THE APPROPRIATE VALUES	--
--------------------------------------------------------------------------------------
  SET	@notifState     = (SELECT notifState FROM NTMessageHistory
							WHERE NTNotificationID = @notifId AND triggerTime = @inpTriggerTime AND escalationLevel = @escLevel)
  SET   @measuredtime   = (SELECT actualthresholdtime/(60*60)	FROM NTmessageHistory			--Convert to hours
							WHERE NTNotificationID = @notifId AND triggerTime = @inpTriggerTime AND escalationLevel = @escLevel)
-------------------------------------------------------------------------
--- WE NEED TO FETCH A LOT OF STUFF FROM the NTNotoficationRule Table ---
-------------------------------------------------------------------------
if (@timePeriodUnit = 'days')
BEGIN
	SET @thresholdTime = @thresholdTime/24
	SET @measuredtime  = @measuredtime/24
END
	SET @displaytimeUnits = @timePeriodUnit							-- KLUDGE, temporary!@#!@#!
----	-		-----------------------------------------------------------		-	----
--   CN_ALERT_TOKEN_MESSAGE_BODY, CN_ALERT_TOKEN_SUBJECT are NOT processed here!    --
----	-		-----------------------------------------------------------		-	----
SET     @lSeperator  = ''
SET @clientNames =  ''
SET @idaNames	 =  ''
SET @instanceNames =  ''
SET @bsetNames	   =  ''
SET @scNames	   =  ''
SET @maNames	   =  ''
SET @spNames	   =  ''
SET @libNames	   =  ''
SET @allStatus	   =  ''
SET @oldAlertTypes		=  ''
SET @oldAlertActions 	=  ''
--Replace token--
-- Now we first compute the <VARIABLE BODY> token in localised html escaped form.
set @variableBodyString = dbo.getHtmlEscapedString(dbo.fn_EvFormatEventMsgText(0,@localeId,(950 | (CAST(POWER(2, 24) AS BIGINT) * 74)), 0,2),@isHtmlEncoding)
set @variableBodyEndString = dbo.getHtmlEscapedString('<VARIABLE END>',@isHtmlEncoding)
--GET EACH VALID CURSOR FOR THE GIVEN MESSAGE
set @msgCount = 1
set @postAmbleMessage = ''
-- Check whether variable message is part of formatMessage/formatMessageHtml so that we know whether grouping of messages needs to be done
set @isVariableMessageIncluded = 0
set @isVariableMessageEndIncluded = 0
if ((exists(select 1 from NTnotificationRule AS NR
				WHERE NR.id = @notifId
and ((NR.alertTypeId=57 OR NR.alertTypeId=62))) and @rawMessage like '%'+@variableBodyString+'%')
and @messType=1 and ((@alertTypeId=57 OR @alertTypeId=62)))
begin
	set @isVariableMessageIncluded = 1
end
if ((exists(select 1 from NTnotificationRule AS NR
				WHERE NR.id = @notifId
and ((NR.alertTypeId=57 OR NR.alertTypeId=62))) and @rawMessage like '%'+@variableBodyEndString+'%')
and @messType=1 and((@alertTypeId=57 OR @alertTypeId=62)))
begin
	set @isVariableMessageEndIncluded = 1
	set @variablebodyEndStart = (SELECT PATINDEX('%'+@variableBodyEndString+'%', @rawMessage ))
	set @totalLen = LEN(@rawMessage)
	if @variablebodyEndStart>0
	begin
		set @postAmbleMessage = RIGHT(@rawMessage , (@totalLen + 1 - @variablebodyEndStart - LEN(@variableBodyEndString)))
	end
end
-- In case the variable message is part of formatted message, then rearrange the order.
-- Here we compute the new order of messages based on values for tokens (in the order stored in NTRuleTokenOrdering for this Notifrule)
if @isVariableMessageIncluded=1
begin
	begin try
		DECLARE @listCol NVARCHAR(max)
		DECLARE @listColDesc NVARCHAR(max)
		declare @sql nvarchar(max)
		if object_id('tempdb.dbo.##TEMP_Tbl') is not null
			DROP TABLE ##TEMP_Tbl
		if object_id('tempdb.dbo.##temp_OrderMsgs') is not null
			DROP TABLE ##temp_OrderMsgs
		SELECT  @listCol = COALESCE(@listCol + ',[' + convert(nvarchar(max),tokenId) + ']','[' + convert(nvarchar(max),tokenId) + ']')
		FROM    NTRuleTokenOrdering
		where NTNotificationID = @notifId AND [escalationLevel] = @escLevel AND [messageType] = @messType
		SELECT  @listColDesc = COALESCE(@listColDesc + ',[' + convert(nvarchar(max),tokenId) + '] desc',
				'[' + convert(nvarchar(max),tokenId) + '] desc')
		FROM    NTRuleTokenOrdering
		where NTNotificationID = @notifId AND [escalationLevel] = @escLevel AND [messageType] = @messType
		--print @listCol
		--print @listColDesc
		set @sql = 'SELECT	*
			INTO ##TEMP_Tbl
			FROM
			(
				SELECT	msgIndex, tokenId, tokenVal
				FROM	##entityList
			) AS clients
			PIVOT
			(
				MAX(tokenVal)
				FOR tokenId IN
				(
					'+@listCol+'
				)
			) AS pvt'
		execute sp_executesql @sql
		set @sql = 'select msgIndex, NewOrder into ##temp_OrderMsgs from (select *,
			ROW_NUMBER() over
			(order by '+@listColDesc
			+ ') as NewOrder from ##TEMP_Tbl) t'
		--order by
		execute sp_executesql @sql
		-- Now ##temp_OrderMsgs contains the mapping between the old Order and new Order.
		update E
		set msgIndexNew = t.NewOrder
		from ##temp_OrderMsgs t,##entityList E
		where t.msgIndex = E.msgIndex
	end try
	begin catch
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		-- Error in this computation. We just retain the original order in which messages are sent.
		update ##entityList
		set msgIndexNew = MsgIndex
		goto ORDERMESSAGES
	end catch
end
-- ORder MEssages
ORDERMESSAGES:
declare @cursorTokenstable table
(
	cursorTokenId int
)
Insert into @cursorTokenstable
select (14 | (CAST(POWER(2, 24) AS BIGINT) * 74))
union
select (52 | (CAST(POWER(2, 24) AS BIGINT) * 74))
union
select (53 | (CAST(POWER(2, 24) AS BIGINT) * 74))
union
select (54 | (CAST(POWER(2, 24) AS BIGINT) * 74))
union
select (55 | (CAST(POWER(2, 24) AS BIGINT) * 74))
union
select (180 | (CAST(POWER(2, 24) AS BIGINT) * 74))
-- Now we want to insert tokens like PROTECTED_OBJECTS, FAILED_OBJECTS etc appropriate to the alert type
-- if not present already.
Insert into ##entityList(msgIndex,tokenid, msgIndexNew,tokenVal)
select distinct msgIndex,cursorTokenId,msgIndexNew,''
from ##entityList ELA,@cursorTokenstable CTT
where not exists
(
	select 1 from ##entityList ELInner
	where ELInner.msgIndex = ELInner.msgindex and
	ELInner.tokenid = CTT.cursorTokenId
)
-- we want to have only tokens for that alert type
delete from ##entityList
where tokenid not in
(
	select NTTA.tokenID
	from NTmessageTokensForAlert NTTA
	inner join NTAvailCriteria NTAC
	on NTAC.id = NTTA.availCriteriaID
	where NTAC.alertTypeId = @alertTypeId
)
-- we want to have only valid tokens
delete from ##entityList
where tokenid not in
(
	select distinct MessageId
	from EvLocaleMsgs with (nolock)
	where SubsystemID=74 and LocaleID=0
)
-- Now aggregate all tokens within single message appropriately. And put this in a new temp table.
if object_id('tempdb.dbo.##entityListAggregated') is not null
	DROP TABLE ##entityListAggregated
CREATE TABLE ##entityListAggregated
(
	msgIndex		int,
	tokenId			int,
	tokenVal	    nvarchar(max),
	msgIndexNew		int,
	tokenFlag		int
)
Insert into ##entityListAggregated(msgIndex,tokenid, msgIndexNew,tokenVal,tokenFlag)
select distinct msgIndex,tokenid, msgIndexNew,'',0
from ##entityList
update ELA
set tokenFlag = NTMessagetokensForalert.flag
from ##entityListAggregated ELA, NTMessagetokensForalert,NTAvailCriteria NTAC
where NTMessagetokensForalert.tokenid = ELA.tokenid
and NTAC.alertTypeId = @alertTypeId
and NTMessagetokensForalert.availCriteriaID = NTAC.id
-- Handle all tokens other than comments and list token
Update ELA
set TokenVal = dbo.DecodeInvalidXMLChar(temp.AggregatedToken)
from ##entityListAggregated ELA,
(
	select ELA.msgIndex,ELA.tokenId,
	(
		select
			(select dbo.EncodeInvalidXMLChar(EL.tokenVal) + ','
			from ##entityList EL
			WHERE EL.msgIndex = ELA.msgIndex
			and EL.tokenId = ELA.tokenId
			FOR XML PATH(''),type).value('.', 'nvarchar(max)')
			-- Here the issue is that for xml('') escapes charecters like '<,>,&'.
			-- Hence highlighting tokens got escaped and didnt get replaced
	) as AggregatedToken
	from ##entityListAggregated ELA
where (((ELA.tokenFlag & CAST(128 AS INT)) <>  CAST(128 AS INT)))
	and
(((ELA.tokenFlag & CAST(4096 AS INT)) <>  CAST(4096 AS INT)))
	group by ELA.msgIndex,ELA.tokenId
) temp
where temp.msgIndex = ELA.msgIndex
and temp.tokenId = ELA.tokenId
-- Remove last comma for such tokens
Update ELA
set tokenVal = substring(tokenVal,1,len(tokenVal)-1)
from ##entityListAggregated ELA
where
(((ELA.tokenFlag & CAST(128 AS INT)) <>  CAST(128 AS INT))) and
(((ELA.tokenFlag & CAST(4096 AS INT)) <>  CAST(4096 AS INT)))  and
patindex('%,',tokenVal)>0
-- Handle comments token
Update ELA
set TokenVal = dbo.DecodeInvalidXMLChar(temp.AggregatedToken)
from ##entityListAggregated ELA,
(
	select ELA.msgIndex,ELA.tokenId,
	(
		select
			(select dbo.EncodeInvalidXMLChar(EL.tokenVal) + ''
			from ##entityList EL
			WHERE EL.msgIndex = ELA.msgIndex
			and EL.tokenId = ELA.tokenId
			FOR XML PATH(''),type).value('.', 'nvarchar(max)')
			-- Here the issue is that for xml('') escapes charecters like '<,>,&'.
			-- Hence highlighting tokens got escaped and didnt get replaced
	) as AggregatedToken
	from ##entityListAggregated ELA
where (((ELA.tokenFlag & CAST(4096 AS INT)) =  CAST(4096 AS INT)))
	group by ELA.msgIndex,ELA.tokenId
) temp
where temp.msgIndex = ELA.msgIndex
and temp.tokenId = ELA.tokenId
SELECT top 1 @strCondiHappTime = tokenVal from ##entityListAggregated
where tokenID = (7 | (CAST(POWER(2, 24) AS BIGINT) * 74))
SELECT top 1 @reportCriteriaTokenMsg = tokenVal from ##entityListAggregated
where tokenID = (1112 | (CAST(POWER(2, 24) AS BIGINT) * 74))
if @reportCriteriaTokenMsg is null
begin
	set @reportCriteriaTokenMsg = ''
end
-- Handle Cursor related tokens (Alert criteria token and attachment related tokens) seperately.
DECLARE CursorTokensCursor Cursor for
select msgIndex, tokenId,tokenVal from ##entityList
where tokenId in (select cursorTokenId from @cursorTokenstable)
order by msgIndex asc,tokenId asc
OPEN  CursorTokensCursor
Fetch CursorTokensCursor into @msgId,@msgTokenId,@tokenStrVal
WHILE	@@FETCH_STATUS = 0
BEGIN
	declare @cursorFlag int
	select @cursorFlag = NTTA.flag  from ntmessagetokensforalert NTTA inner join NTAvailCriteria NTAC
	on NTAC.id = NTTA.availCriteriaID
	where NTAC.alertTypeId = @alertTypeId
	and NTTA.tokenid = @msgTokenId
IF (@msgTokenId = (14 | (CAST(POWER(2, 24) AS BIGINT) * 74)))-- Jobs in pending state criteria. Has 2 parameters to be filled.
	BEGIN
		declare @charIndex as int
		if (@tokenStrVal is NULL or len(@tokenStrVal)=0)
		begin
			Fetch CursorTokensCursor into @msgId,@msgTokenId,@tokenStrVal
			continue
		end
		declare @strVal as nvarchar(255)
		SET @strVal = dbo.fn_EvFormatEventMsgText(0,@localeId, CAST(@tokenStrVal AS INT), 0,2)
		set @notifCriteriaId = IsNull((select id from ntcriteria where nameID = CAST(@tokenStrVal AS INT)),0)
		INSERT INTO @CriteriaIds
		SELECT @notifCriteriaId
		set @charIndex =  CHARINDEX(N'<', @strVal)
		declare @paramIndex int
		set @paramIndex = 0
		while (@charIndex > 0)
		BEGIN
			declare @valParams as int
			declare @strVal1 as nvarchar(255)
			declare @strVal2 as nvarchar(255)
			set @valParams = (select value from ntselcriteriaparams where paramIndex=@paramIndex and selCriteriaId = (select id from ntselcriteria where ruleid = @notifId and esclationlevel = @escLevel and availcriteriaId = (select id from ntcriteria where nameID = CAST(@tokenStrVal AS INT) )))
			if @valParams is null
				set @valParams = ''
			set @strVal1 = LEFT(@strVal, CHARINDEX(N'<', @strVal) -1 )
			set @strVal2 = RIGHT(@strVal,Len(@strVal) - CHARINDEX(N'>', @strVal)  )
			set @strVal = @strVal1 + LTRIM(STR(@valParams)) +  @strVal2
			-- Replace "ALERT_TOKEN_CRITERIA" --
			set @charIndex =  CHARINDEX(N'<', @strVal)
			set @paramIndex = @paramIndex + 1
		END
SET @rawMessage =REPLACE(@rawMessage,	dbo.fn_EvFormatEventMsgText(0,@localeId,(14 | (CAST(POWER(2, 24) AS BIGINT) * 74)), 0, 2),
			@strVal )
		set @notifCriteriaForFeeds = @strVal
		Update ELA
		set tokenVal = @notifCriteriaForFeeds
		from ##entityListAggregated ELA
		where ELA.tokenId  = @msgTokenId and
		ELA.msgIndex = @msgId
	--Get the old alert type and action id
		--Below are the values passed backe fot the SNMP , as per request from stu.
		SELECT @oldalerttypeid = oldAlertId , @oldAlertActionId = oldActionId from ANalertNewAlertAssoc where alertCriId = @notifCriteriaId AND newAlertId = @AlertTypeId
	--Store the names
		SET @oldAlertTypes	   =	@oldAlertTypes		+  @lSeperator +	CAST(	@oldalerttypeid as nvarchar(20))
		SET @oldAlertActions	   =	@oldAlertActions		+  @lSeperator +	CAST(	@oldAlertActionId as nvarchar(20))
		set @lSeperator = '; '
	--End
	END
	SELECT @jobId = tokenVal from ##entityListAggregated
			where msgIndex = @msgId
and tokenID = (35 | (CAST(POWER(2, 24) AS BIGINT) * 74))
	SELECT @strCondiHappTime = tokenVal from ##entityListAggregated
			where msgIndex = @msgId
and tokenID = (7 | (CAST(POWER(2, 24) AS BIGINT) * 74))
if ((@msgTokenId <> (1 | (CAST(POWER(2, 24) AS BIGINT) * 74)) ) AND (@msgTokenId <> (2 | (CAST(POWER(2, 24) AS BIGINT) * 74)) ) AND  (((@cursorFlag & CAST(128 AS INT)) <>  CAST(128 AS INT))) )
	begin
IF 	((@msgTokenId = (52 | (CAST(POWER(2, 24) AS BIGINT) * 74)) ) OR (@msgTokenId = (53 | (CAST(POWER(2, 24) AS BIGINT) * 74)) ) OR (@msgTokenId = (54 | (CAST(POWER(2, 24) AS BIGINT) * 74)) ) OR (@msgTokenId = (55 | (CAST(POWER(2, 24) AS BIGINT) * 74)) ) OR (@msgTokenId = (180 | (CAST(POWER(2, 24) AS BIGINT) * 74)) ))
		BEGIN
			SET @attachTokenMsg = ''
			DECLARE @tempId int
			set @tempId = @jobId
if (@msgTokenId = (180 | (CAST(POWER(2, 24) AS BIGINT) * 74)))
				set @jobId = @msgCount
			--fetch the attachment file name from the NTattchedfile to replace the token value
			IF EXISTS( SELECT attachFile FROM NTattachedFiles where jobId = @jobId AND tokenId = @msgTokenId AND triggertime = @strCondiHappTime and NTnotificationId = @notifId )
				SET @attachTokenMsg = (SELECT attachFile FROM NTattachedFiles where jobId = @jobId AND tokenId = @msgTokenId And triggertime = @strCondiHappTime and NTnotificationId = @notifId )
			--If attachment file doesn't exist, replace with Not applicable
			ELSE
			Begin
SET @notApplicableTokenMsg = ltrim(rtrim(dbo.fn_EvFormatEventMsgText(0,@localeId, (165 | (CAST(POWER(2, 24) AS BIGINT) * 74)), 0 ,2)))
				SET @attachTokenMsg = @notApplicableTokenMsg
			END
			Update ELA
			set tokenVal = @attachTokenMsg
			from ##entityListAggregated ELA
			where ELA.tokenId  = @msgTokenId and
			ELA.msgIndex = @msgId
			set @jobId = @tempId
		END
	End
	Fetch CursorTokensCursor into @msgId,@msgTokenId,@tokenStrVal
end
CLOSE CursorTokensCursor
DEALLOCATE CursorTokensCursor
declare @NTMessageTokensListForNotApplicable table
(
	tokenId int
)
Insert into @NTMessageTokensListForNotApplicable
select tokenId from NTMEssagetokensForAlert
where availcriteriaid in
(
	select id from ntAvailcriteria
	where alertTypeId = @alertTypeId
)
and tokenid <> (1 | (CAST(POWER(2, 24) AS BIGINT) * 74)) and tokenid <> (2 | (CAST(POWER(2, 24) AS BIGINT) * 74))
and tokenid <> (950 | (CAST(POWER(2, 24) AS BIGINT) * 74)) AND tokenid <> (953 | (CAST(POWER(2, 24) AS BIGINT) * 74))
-- Remove invalid tokens which are not present in EvLocaleMsgs table
delete from @NTMessageTokensListForNotApplicable
where tokenId  not in
(
	select distinct MessageId
	from EvLocaleMsgs with (nolock)
	where SubsystemID=74 and LocaleID=0
)
if (@alertTypeId = 65)
begin
	delete from @NTMessageTokensListForNotApplicable
	where @rawMessage not like '%'+ltrim(rtrim(dbo.getHtmlEscapedString(dbo.fn_EvFormatEventMsgText(0,@localeId, tokenId, 0 ,2),@isHtmlEncoding)))+'%'
end
SET @notApplicableTokenMsg = ltrim(rtrim(dbo.fn_EvFormatEventMsgText(0,@localeId, (165 | (CAST(POWER(2, 24) AS BIGINT) * 74)), 0 ,2)))
Update ##entityListAggregated
set tokenval = ''
where tokenval is NULL
DECLARE	GetSelMsgCursor CURSOR FOR
SELECT DISTINCT msgIndexNew FROM ##entityListAggregated
order by msgIndexNew asc
OPEN GetSelMsgCursor
FETCH GetSelMsgCursor INTO @msgId
WHILE	@@FETCH_STATUS = 0
BEGIN
	SET @tokenclientName = ''
	SET @tokenidaName	 = ''
	SET @tokeninstanceName = ''
	SET @tokenbsetName	   = ''
	SET @tokenscName	   = ''
	SET @tokenmaName	   = ''
	SET @tokenspName	   = ''
	SET @tokenlibName	   = ''
	SET @tokenStatus	   = ''
	SET @tokenCriteria	   = ''
	SET @shldPostAmbleBePrepended = 0
	-- Replace HORIZONTAL LINE --
	 SET @rawMessage =REPLACE(@rawMessage,	'MsgHrzSep', @msgHrzSeperator)
	-- Replace "ALERT_TOKEN_NOTIFICATION_NAME" --
	SET @rawMessage =REPLACE(@rawMessage,
dbo.getHtmlEscapedString(dbo.fn_EvFormatEventMsgText(0,@localeId,(13 | (CAST(POWER(2, 24) AS BIGINT) * 74)), 0,2),@isHtmlEncoding),
			dbo.getHtmlEscapedString((select notificationName from NTnotification
			WHERE NTnotificationID = @notifId AND revision > 0),@isHtmlEncoding))
	-- Replace "CN_ALERT_TOKEN_UTC_DATETIME" --
	--	SET @rawMessage =REPLACE(@rawMessage,	dbo.fn_EvFormatEventMsgText(0,@localeId,ALERT_TOKEN_UTC_DATETIME, 0,2),
	--				convert(nvarchar(20),@inpTriggerTime))
	-- Replace "ALERT_TOKEN_DATETIME" --
	--	SET @rawMessage =REPLACE(@rawMessage,	dbo.fn_EvFormatEventMsgText(0,@localeId,ALERT_TOKEN_DATETIME, 0,2),
	--				convert(nvarchar(20),dbo.UTCToClientLocalTime(@inpTriggerTime, @commcellId)))
	-- Replace "ALERT_TOKEN_OWNER_NAME" --
		SET @rawMessage =REPLACE(@rawMessage,
dbo.getHtmlEscapedString(dbo.fn_EvFormatEventMsgText(0,@localeId,(10 | (CAST(POWER(2, 24) AS BIGINT) * 74)), 0,2),@isHtmlEncoding),
					dbo.getHtmlEscapedString(@notifOwnerName,@isHtmlEncoding))
	-- Replace "ALERT_TOKEN_ALERT_TYPE" --
		SET @rawMessage =REPLACE(@rawMessage,
dbo.getHtmlEscapedString(dbo.fn_EvFormatEventMsgText(0,@localeId,(6 | (CAST(POWER(2, 24) AS BIGINT) * 74)), 0,2),@isHtmlEncoding),
					dbo.getHtmlEscapedString((@AlertCategoryName + N' - ' +  @AlertTypeName),@isHtmlEncoding))
	-- Replace "ALERT_TOKEN_NOTIFICATION_ID --
		SET @rawMessage =REPLACE(@rawMessage,
dbo.getHtmlEscapedString(dbo.fn_EvFormatEventMsgText(0,@localeId,(12 | (CAST(POWER(2, 24) AS BIGINT) * 74)), 0,2),@isHtmlEncoding),
					@notifId)
	-- Replace "ALERT_TOKEN_OWNER_EMAIL" --
		SET @rawMessage =REPLACE(@rawMessage,
dbo.getHtmlEscapedString(dbo.fn_EvFormatEventMsgText(0,@localeId,(11 | (CAST(POWER(2, 24) AS BIGINT) * 74)), 0,2),@isHtmlEncoding),
					dbo.getHtmlEscapedString((select email FROM UMUsers WHERE id = @notifOwnerId),@isHtmlEncoding))
	-- Replace "ALERT_TOKEN_IF_ESCALATED" --
	if(@escLevel > 1)
	BEGIN
		SET @rawMessage =REPLACE(@rawMessage,
dbo.getHtmlEscapedString(dbo.fn_EvFormatEventMsgText(0,@localeId,(22 | (CAST(POWER(2, 24) AS BIGINT) * 74)), 0,2),@isHtmlEncoding),
dbo.getHtmlEscapedString(dbo.fn_EvFormatEventMsgText(0,@localeId,(211 | (CAST(POWER(2, 24) AS BIGINT) * 74)), 0,2),@isHtmlEncoding))
	END
	ELSE
	BEGIN
	   SET @rawMessage =REPLACE(@rawMessage,
dbo.getHtmlEscapedString(dbo.fn_EvFormatEventMsgText(0,@localeId,(22 | (CAST(POWER(2, 24) AS BIGINT) * 74)), 0,2),@isHtmlEncoding),
					'')
	END
-----------------------------------------------------------------------------------------------------------
--  IN THE EVENT THAT THERE ARE NO TOKEN GENERATED ATTACHMENT FILES,  THE FOLLOWING LOGIC LOOKS FOR AN
--  APPLICATION SPECIFIED ATTACHMENT FILE AND WILL RETURN  TO THE CALLER A FILENAME AND SHORT (BASENAME)
--  FOR THAT ATTACHMENT.  IT WOULD HAVE BEENMORE APPROPRIATE TO PUT THIS LOGIC IN "BR_NTCheckAndAddHistory",
--  BUT THE ATTACHMENT NAME IS CONTAINED IN THE "ENTITIES" COLUMN OF THE SPOOLQUEUE AND IS NOT PROCESSED THERE,
--  WHEREAS WE DO PROCESS THE ENTITIES XML HERE ... NO REASON TO EXTRACT FROM XML IN TWO PLACES!
-----------------------------------------------------------------------------------------------------------
	if @attachedName = ''
	BEGIN
SET @attachedFile = ISNULL((Select tokenVal from ##entityListAggregated where msgIndexNew = @msgId AND tokenId = (32 | (CAST(POWER(2, 24) AS BIGINT) * 74))), '')     --1241514016
		IF charindex('\', @attachedFile) <> 0
		   set @attachedName = reverse(substring(reverse(@attachedFile), 1, charindex('\', reverse(@attachedFile))-1))
		ELSE
		   set @attachedName=@attachedFile
END
-----------------------------------------------------------------------------------------------------------
	SELECT @rawMessage = Replace(@rawMessage,
				dbo.getHtmlEscapedString(ltrim(rtrim(dbo.fn_EvFormatEventMsgText(0,@localeId, tokenId, 0 ,2))),@isHtmlEncoding),
				case
when (@isHtmlEncoding = 1 ) and ((tokenFlag & CAST(16384 AS INT)) <>  CAST(16384 AS INT)) then dbo.getHtmlEscapedString(tokenVal,1)
					else dbo.getHtmlEscapedString(tokenVal,0)
					end
				)
			from ##entityListAggregated
			where msgIndexNew = @msgId
and ((tokenFlag & CAST(128 AS INT)) <>  CAST(128 AS INT))
	-- Now we need to replace Not Applicable tokens
	SELECT @rawMessage = Replace(@rawMessage,
				dbo.getHtmlEscapedString(ltrim(rtrim(dbo.fn_EvFormatEventMsgText(0,@localeId, tokenId, 0 ,2))),@isHtmlEncoding),
				dbo.getHtmlEscapedString(@notApplicableTokenMsg,@isHtmlEncoding)
				)
			from
			(
				select distinct tokenid from  @NTMessageTokensListForNotApplicable
				except
				select distinct tokenid from  ##entityListAggregated
				where msgIndexNew = @msgId
			) t
	SET @MsgBodyStart	= (SELECT PATINDEX('%'+@bodyToken+'%', @rawMessage ))
	-- Now if variable message end is included, then we always strip it off...
	-- We always add the end message at the end so that the last message is closed properly
	-- We Prepend this postamble in case of next/new message so that previous message is completed.
	if (@isVariableMessageEndIncluded=1)
	begin
		set @variablebodyEndStart = (SELECT PATINDEX('%'+@variableBodyEndString+'%', @rawMessage ))
		if @variablebodyEndStart>0
		begin
			set @rawMessage = LEFT(@rawMessage , @variablebodyEndStart-1)
		end
	end
	set @totalLen = LEN(@rawMessage)
	IF (@MsgBodyStart > 0)
		set @curentfixedBodyString = substring(@rawMessage ,@MsgBodyStart+LEN(@bodyToken), @totalLen )
	-- For run command notification type,if multiple detected alerts came at the same time, only the first alert got formatted correctly. Subsequent ones werent replaced correctly.
	if (@msgCount > 1 and @MsgBodyStart > 0)
	BEGIN
		set @rawMessage = @curentfixedBodyString
	END
	set @actualMsgSeperator = @msgSeperator
	-- Now if the variable message is included, then generate a table split by variable components and compare with the previous table.
	if (@isVariableMessageIncluded=1)
	begin
		declare @rawMessageTmp nvarchar(max)
		delete from @table
		set @rawMessageTmp = @curentfixedBodyString
		-- This will split and insert the entries here.
while (len(@rawMessageTmp)>0) begin if PATINDEX('%'+@variableBodyString+'%',@rawMessageTmp)>0 begin Insert into @table(Id,Data) select @cnt,SUBSTRING(@rawMessageTmp,1,PATINDEX('%'+@variableBodyString+'%',@rawMessageTmp)-1) set @rawMessageTmp = SUBSTRING(@rawMessageTmp,PATINDEX('%'+@variableBodyString+'%',@rawMessageTmp)+LEN(@variableBodyString),LEN(@rawMessageTmp)) end else begin Insert into @table(Id,Data) select @cnt,@rawMessageTmp set @rawMessageTmp=''	 end set @cnt = @cnt + 1 end set @cnt = 0
		if (@msgCount = 1 )
		begin
			-- rawmessage remains the same.
			Insert into @PreviousEntriesTable
			select * from @table
		end
		else
		begin
			set @firstVaryingComponent = isnull((Select min(Curr.Id)
				from @table Curr inner join @PreviousEntriesTable Previous
				on Curr.Id = Previous.Id
				where Curr.Data!=Previous.Data),-1)
			if @firstVaryingComponent = -1
			begin
				set @rawMessage = IsNull((select top 1 data from @table
				where Id in
				(
					select MAX(id) from @table
				)),'')
				-- Same message as before apparently. So dont modify rawmessage
				print 'same'
			end
			else
			begin
				set @rawMessage = ''
				select @rawMessage = COALESCE(@rawMessage+data,data)
				from @table
				where Id>=@firstVaryingComponent
				--print @rawMessage
				-- Now that the new message is different, we store this split parts into @PreviousEntriesTable
				delete from @PreviousEntriesTable
				Insert into @PreviousEntriesTable
				select * from @table
				if @firstVaryingComponent = 0
				begin
					set @shldPostAmbleBePrepended = 1
				end
			end
		end
	end
	if @isVariableMessageEndIncluded=1
	begin
		set @actualMsgSeperator = ''
	end
	--Here we will copy the partially formatted message to ntext table for further processing
	if object_id('tempdb.dbo.#ntnotifmsg') is not null
		DROP TABLE #ntnotifmsg
		create table #ntnotifmsg(formatMsg ntext)
		insert into #ntnotifmsg (formatMsg) values(@rawMessage)
    --GET EACH VALID CURSOR FOR THE GIVEN ALERTTYPE AND REPLACE
	DECLARE	GetSelTokenCursor CURSOR FOR
	SELECT DISTINCT NTTA.tokenID, NTTA.flag FROM NTmessageTokensForAlert NTTA
	inner join NTAvailCriteria NTAC
	on NTAC.id = NTTA.availCriteriaID
	where NTAC.alertTypeId = @alertTypeId
and (((NTTA.flag & CAST(128 AS INT)) =  CAST(128 AS INT)))
	order by NTTA.tokenId
	OPEN GetSelTokenCursor
	FETCH GetSelTokenCursor INTO @msgTokenId, @tokListType
	WHILE	@@FETCH_STATUS = 0
	BEGIN
		--Fetch the value from the list
If (((@tokListType & CAST(128 AS INT)) =  CAST(128 AS INT)))
			EXEC br_ntformatEntities @msgId, @localeId, @msgTokenId, @isHtmlEncoding
	FETCH GetSelTokenCursor INTO @msgTokenId , @tokListType
	END
	CLOSE GetSelTokenCursor
	DEALLOCATE GetSelTokenCursor
	-- In case of html encoding, We have html escaped before forming the formattedmessage. But the subject neednt be html escaped.
	-- So we reverse html escape it
	if @isHtmlEncoding=1
	begin
		--select @rawMessage
		set @rawMessage = (select top 1 formatMsg from #ntnotifmsg)
		-- Body token is not in html escaped form. So we can directly search for the token
		set @formattedMsgBodyStart  = (SELECT PATINDEX('%'+@bodyToken+'%', @rawMessage ))
		set @subjectMessage			= ''
		if @formattedMsgBodyStart>1
		begin
			set @subjectMessage		= SUBSTRING(@rawMessage,1,@formattedMsgBodyStart-1)
		end
		set @rawMessage				= SUBSTRING(@rawMessage,Len(@subjectMessage)+1,LEN(@rawMessage)-Len(@subjectMessage)+1)
		set @subjectMessage			= replace(@subjectMessage,'&lt;','<')
		set @subjectMessage			= replace(@subjectMessage,'&gt;','>')
		set @subjectMessage			= replace(@subjectMessage,'&amp;','&')
		set @rawMessage				= @subjectMessage + @rawMessage
		delete from #ntnotifmsg
		insert into #ntnotifmsg (formatMsg) values(@rawMessage)
	end
		-- In case there is a new message added then we prepend the postamble to this rawmessage so that the previous message
	-- is completed.
	if @shldPostAmbleBePrepended=1
	begin
		set @rawMessage = (select top 1 formatMsg from #ntnotifmsg)
		-- No seperator needed in this case since postAmble itself acts like a seperator
		if len(@postAmbleMessage)>0
		begin
			set @rawMessage = @postAmbleMessage + @msgSeperator + @rawMessage
			set @actualMsgSeperator = ''
			delete from #ntnotifmsg
			insert into #ntnotifmsg (formatMsg) values(@rawMessage)
		end
	end
	-- Criteria based processing for default laptop alerts not being done since it affects LM
	-- Now replace highlight begin and end tokens for LM. To highlight the matches
if ((@alertTypeId=57 OR @alertTypeId=62))
	begin
		if (@isHtmlEncoding=1)
		begin
			-- Replace highlight tokens. Done only for LM alerts to avoid performance hit for other alerts
			-- html escape for below tokens
			set @rawMessage = REPLACE(@rawMessage,'&lt;HIGHLIGHT BEGIN TOKEN&gt;','<span style="background-color:#FFFF00">')
			set @rawMessage = REPLACE(@rawMessage,'&lt;HIGHLIGHT END TOKEN&gt;','</span>')
		end
		else
		begin -- for text formatting. Replace these tokens with empty messages.
			set @rawMessage = REPLACE(@rawMessage,'<HIGHLIGHT BEGIN TOKEN>','')
			set @rawMessage = REPLACE(@rawMessage,'<HIGHLIGHT END TOKEN>','')
		end
		delete from #ntnotifmsg
		insert into #ntnotifmsg (formatMsg) values(@rawMessage)
	end
	--Insert the message
	SELECT @PTRVAL = TEXTPTR(formattedMessage)
			FROM NTmessageFormat
			WHERE NTnotificationId = @notifId
			  AND  messageType=@messType
			  AND  escalationLevel = @escLevel
	if (@msgCount > 1)
	BEGIN
			UPDATETEXT NTmessageFormat.formattedMessage @PTRVAL Null 0 @actualMsgSeperator
			SELECT @PTRVAL = TEXTPTR(formattedMessage)
			FROM NTmessageFormat
			WHERE NTnotificationId = @notifId
			  AND  messageType=@messType
			  AND  escalationLevel = @escLevel
			UPDATETEXT NTmessageFormat.formattedMessage @PTRVAL Null 0 @rawMessage
			--EXEC br_ntformatCopyNtext @notifId, @messType, @escLevel
	END
	ELSE
	BEGIN
		UPDATE NTMessageFormat
		SET    formattedMessage = formatMsg FROM NTMessageFormat as NTM , #ntnotifmsg AS NTF
		WHERE NTnotificationId = @notifID AND messageType = @messType AND escalationLevel = @escLevel
	END
	delete #ntnotifmsg
	set @rawMessage = @tokenMessage
	SET @msgCount  = @msgCount + 1
	set @lSeperator = '; '
	FETCH GetSelMsgCursor INTO @msgId
END
CLOSE GetSelMsgCursor
DEALLOCATE GetSelMsgCursor
SET @clientNames =		''
	SET @idaNames	 =		''
	SET @instanceNames =	''
	SET @bsetNames	   =	''
	SET @scNames	   =	''
	SET @maNames	   =	''
	SET @spNames	   =	''
	SET @libNames	   =	''
	SET @allStatus	   =	''
	SELECT @clientNames = @clientNames+@lSeperator+tokenVal from ##entityListAggregated
where tokenID = (42 | (CAST(POWER(2, 24) AS BIGINT) * 74))
			and tokenVal is not null and len(tokenVal)>0
	SELECT @idaNames = @idaNames+@lSeperator+tokenVal from ##entityListAggregated
where tokenID = (43 | (CAST(POWER(2, 24) AS BIGINT) * 74))
			and tokenVal is not null and len(tokenVal)>0
		SELECT @instanceNames = @instanceNames+@lSeperator+tokenVal from ##entityListAggregated
where tokenID = (44 | (CAST(POWER(2, 24) AS BIGINT) * 74))
			and tokenVal is not null and len(tokenVal)>0
		SELECT @bsetNames = @bsetNames +@lSeperator+ tokenVal from ##entityListAggregated
where tokenID = (45 | (CAST(POWER(2, 24) AS BIGINT) * 74))
			and tokenVal is not null and len(tokenVal)>0
		SELECT @scNames = @scNames +@lSeperator+ tokenVal from ##entityListAggregated
where tokenID = (46 | (CAST(POWER(2, 24) AS BIGINT) * 74))
			and tokenVal is not null and len(tokenVal)>0
		SELECT @maNames = @maNames+@lSeperator+tokenVal from ##entityListAggregated
where tokenID = (68 | (CAST(POWER(2, 24) AS BIGINT) * 74))
			and tokenVal is not null and len(tokenVal)>0
		SELECT @spNames = @spNames+@lSeperator+tokenVal from ##entityListAggregated
where tokenID = (40 | (CAST(POWER(2, 24) AS BIGINT) * 74))
			and tokenVal is not null and len(tokenVal)>0
		SELECT @libNames = @libNames+@lSeperator+tokenVal from ##entityListAggregated
where tokenID = (57 | (CAST(POWER(2, 24) AS BIGINT) * 74))
			and tokenVal is not null and len(tokenVal)>0
		SELECT @allStatus = @allStatus+@lSeperator+tokenVal from ##entityListAggregated
where tokenID = (23 | (CAST(POWER(2, 24) AS BIGINT) * 74))
			and tokenVal is not null and len(tokenVal)>0
	-- Remove semi colons(@lSeperator) from all above variables.
if (datalength(@lSeperator)>0 and Patindex(@lSeperator+'%',@clientNames)>0) begin SET @clientNames = Substring(@clientNames,datalength(@lSeperator)/2+1,datalength(@clientNames))	end
if (datalength(@lSeperator)>0 and Patindex(@lSeperator+'%',@idaNames)>0) begin SET @idaNames = Substring(@idaNames,datalength(@lSeperator)/2+1,datalength(@idaNames))	end
if (datalength(@lSeperator)>0 and Patindex(@lSeperator+'%',@instanceNames)>0) begin SET @instanceNames = Substring(@instanceNames,datalength(@lSeperator)/2+1,datalength(@instanceNames))	end
if (datalength(@lSeperator)>0 and Patindex(@lSeperator+'%',@bsetNames)>0) begin SET @bsetNames = Substring(@bsetNames,datalength(@lSeperator)/2+1,datalength(@bsetNames))	end
if (datalength(@lSeperator)>0 and Patindex(@lSeperator+'%',@scNames)>0) begin SET @scNames = Substring(@scNames,datalength(@lSeperator)/2+1,datalength(@scNames))	end
if (datalength(@lSeperator)>0 and Patindex(@lSeperator+'%',@maNames)>0) begin SET @maNames = Substring(@maNames,datalength(@lSeperator)/2+1,datalength(@maNames))	end
if (datalength(@lSeperator)>0 and Patindex(@lSeperator+'%',@spNames)>0) begin SET @spNames = Substring(@spNames,datalength(@lSeperator)/2+1,datalength(@spNames))	end
if (datalength(@lSeperator)>0 and Patindex(@lSeperator+'%',@libNames)>0) begin SET @libNames = Substring(@libNames,datalength(@lSeperator)/2+1,datalength(@libNames))	end
if (datalength(@lSeperator)>0 and Patindex(@lSeperator+'%',@allStatus)>0) begin SET @allStatus = Substring(@allStatus,datalength(@lSeperator)/2+1,datalength(@allStatus))	end
-- If vairable message end is present, then add it to the end of the formatted message
if @isVariableMessageEndIncluded=1 and @isVariableMessageIncluded=1
begin
	set @variablebodyEndStart = (SELECT PATINDEX('%'+@variableBodyEndString+'%', @rawMessage ))
	set @totalLen = LEN(@rawMessage)
	if @variablebodyEndStart>0
	begin
		if object_id('tempdb.dbo.#ntnotifmsg') is not null
		begin
			delete #ntnotifmsg
			insert into #ntnotifmsg (formatMsg) values(@postAmbleMessage)
			SELECT @PTRVAL = TEXTPTR(formattedMessage)
			FROM NTmessageFormat
			WHERE NTnotificationId = @notifId
			  AND  messageType=@messType
			  AND  escalationLevel = @escLevel
			UPDATETEXT NTmessageFormat.formattedMessage @PTRVAL Null 0 ''
			EXEC br_ntformatCopyNtext @notifId, @messType, @escLevel
		end
	end
end
-- Now variable body is not to be displayed when mail is sent. So we remove it before we send the message.
if (@isVariableMessageIncluded=1)
begin
	UPDATE NTMessageFormat
	SET    formattedMessage = replace(convert(nvarchar(max),formattedMessage),@variableBodyString,'')
	WHERE NTnotificationId = @notifID AND messageType = @messType AND escalationLevel = @escLevel
end
-- Now variable body is not to be displayed when mail is sent. So we remove it before we send the message.
if (@isVariableMessageEndIncluded=1)
begin
	UPDATE NTMessageFormat
	SET    formattedMessage = replace(convert(nvarchar(max),formattedMessage),@variableBodyEndString,'')
	WHERE NTnotificationId = @notifID AND messageType = @messType AND escalationLevel = @escLevel
end
set @SubjFieldLen	= 0
set @MsgBodyLen		= 0
set @totalLen		= 0
set @SubjFieldStart	= 0
set @MsgBodyStart	= 0
------------------------------------------------------------------------------
-- PARSE OUT SUBJECT FIELD, AND COLLECT SOME PIECES NEEDED FOR MESSAGE BODY --
-- FIELD TOO                                                                --
------------------------------------------------------------------------------
set @SubjFieldStart	= (SELECT PATINDEX('%'+@subjToken+'%', formattedMessage)
							FROM NTmessageFormat
							WHERE NTnotificationId = @notifId
								AND  messageType=@messType
								AND  escalationLevel = @escLevel)
SET @MsgBodyStart	= (SELECT PATINDEX('%'+@bodyToken+'%', formattedMessage)
							FROM NTmessageFormat
							WHERE NTnotificationId = @notifId
								AND  messageType=@messType
								AND  escalationLevel = @escLevel)
set @totalLen = 		(SELECT DATALENGTH(formattedMessage)
							FROM NTmessageFormat
							WHERE NTnotificationId = @notifId
								AND  messageType=@messType
								AND  escalationLevel = @escLevel)
IF (@SubjFieldStart = 0)
	GOTO PROCESS_BODY_TEXT
------------------------------------------------------------
---		WE HAVE A SUBJECT FIELD TOKEN, LET'S PROCESS IT! ---
------------------------------------------------------------
SET @subjFieldStart = @subjFieldStart + LEN(@subjToken)		-- Get past Token
IF (@MsgBodyStart  > @subjFieldStart )
  SET @subjFieldLen   = @MsgBodyStart - @subjFieldStart
WHILE (select PATINDEX('%'+@QnetNewLine+'%', subString(formattedMessage, @SubjFieldStart, @QnetNewLineLen))
					FROM NTmessageFormat
					WHERE NTnotificationId = @notifId
						AND  messageType=@messType
						AND  escalationLevel = @escLevel	) = 1
BEGIN
	set @SubjFieldStart = @SubjFieldStart + @QnetNewLineLen		-- Skip Over Any "newlines" between subject token and
	SET @subjFieldLen   = @MsgBodyStart - @subjFieldStart +1	-- Actual subject text
END
IF (@MsgBodyStart = 0)											-- MY RULE: CANNOT HAVE SUBJECT IF YOU DON'T HAVE MESSAGE BODY
BEGIN															-- INTERPRET ALL TEXT AS MESSAGE BODY AND LET AUTHOR CORRECT
	SET @SubjFieldStart = 0										-- NOTIFICATION TEMPLATE
	SET @SubjFieldLen   = 0
	GOTO PROCESS_BODY_TEXT
END
-- Get Rid of Trailing Newlines in Message --
---------------------------------------------
--select subString(formattedMessage, @SubjFieldStart+@subjFieldLen-@QnetNewLineLen-1, @QnetNewLineLen)
--					FROM NTmessageFormat
--					WHERE NTnotificationId = @notifId
--						AND  messageType=@messType
--						AND  escalationLevel = @escLevel
WHILE (select PATINDEX('%'+@QnetNewLine+'%', subString(formattedMessage, @SubjFieldStart+@subjFieldLen-@QnetNewLineLen-1, @QnetNewLineLen))
					FROM NTmessageFormat
					WHERE NTnotificationId = @notifId
						AND  messageType=@messType
						AND  escalationLevel = @escLevel	) = 1
BEGIN
	SET @subjFieldLen   = @subjFieldLen - @QnetNewLineLen -1	-- Actual subject text
END
PROCESS_BODY_TEXT:
IF (@MsgBodyStart > 0)
	SET @MsgBodyStart = @MsgBodyStart + LEN(@bodyToken)
ELSE
	SET @MsgBodyStart = 1
WHILE (select PATINDEX('%'+@QnetNewLine+'%', subString(formattedMessage, @MsgBodyStart, @QnetNewLineLen))
					FROM NTmessageFormat
					WHERE NTnotificationId = @notifId
						AND  messageType=@messType
						AND  escalationLevel = @escLevel	) = 1
BEGIN
	set @MsgBodyStart = @MsgBodyStart + @QnetNewLineLen		-- Skip Over Any "newlines" between subject token and
END
SET @MsgBodyLen = @totalLen - @MsgBodyStart
EXEC sp_xml_removedocument @idoc
set @liveFeedsJobIdint = 0
if isnumeric(@jobId)>0
begin
	set @liveFeedsJobIdint = convert(int,@jobId)
end
IF @autoComputeSeverity = 1
BEGIN
   IF @alertTypeId = 58
   BEGIN
DECLARE @severityList TABLE(severity NVARCHAR(1024))
		INSERT INTO @severityList
SELECT tokenVal FROM ##entityList WHERE tokenId = (923 | (CAST(POWER(2, 24) AS BIGINT) * 74))
		IF EXISTS ( SELECT 1 FROM @severityList WHERE severity = 'Critical')
			SET @severity = 1
		ELSE IF EXISTS (SELECT 1 FROM @severityList WHERE severity = 'Minor' OR severity = 'Major')
			SET @severity = 2
		ELSE
			SET @severity = 3
   END
ELSE IF @alertTypeId = 65
   BEGIN
		set @severity = 3
		select @severity = IsNull(convert(xml,NTQueryList.xmlInfo).value('(App_AdditionalQueryDetails/@querySeverity)[1]','int'),3)
		from NTQueryList where queryId = @queryId
   END
   ELSE
   BEGIN
		SET @severity = ISNULL((SELECT
		TOP 1 MIN(NTACS.severitynameid)
		FROM
		NTAvailCriteria NTAC INNER JOIN NTAvailCriteriaSeverity NTACS
			ON NTAC.id = NTACS.availCriteriaId
				INNER JOIN @CriteriaIds cIDS
					ON cIDS.criterias = NTAC.criteriaid WHERE NTAC.alertTypeId = @alertTypeId),3)
   END
    if (@severity=0)
	begin
		set @severity = 3
	end
END
if object_id('tempdb.dbo.##entityList') is not null
	DROP TABLE ##entityList
if object_id('tempdb.dbo.##entityListAggregated') is not null
	DROP TABLE ##entityListAggregated
if (@alertTypeId = 65 and
	(@notifCriteriaForFeeds is null OR len(@notifCriteriaForFeeds)=0)
	)
begin
	set @notifCriteriaForFeeds = dbo.fn_WeedOutHtmlTags(@reportCriteriaTokenMsg)
end
SELECT
			alertName     =@alertName,
            qnetWenString =convert(varchar(20), @inpTriggerTime, 9),
			ownerName	  =@notifOwnerName,
			alertType     =@alertTypeName,
			alertStatus   =@allStatus,
--			fullMessage =formattedMessage,
		 	subjectStart= @SubjFieldStart,
			subjectLen  = @subjFieldLen,
			bodyStart   = @MsgBodyStart,
			bodyLen		= @MsgBodyLen,
			totalLen	= @totalLen,
			loginLst	= @loginList,
			emailList	= @emailList,
			noEmailList	= @noEmailList,
			encodingType = @encodingType,
			attachedFile = @attachedFile,
			attachedName = @attachedName,
			locale =		@localeId,
			clientNames		= @clientNames,
			idaNames		= @idaNames,
			instanceName	= @instanceNames,
			bsetNames		= @bsetNames,
			scNames			= @scNames,
			maNames			= @maNames,
			spNames			= @spNames,
			libNames		= @libNames,
			allStatus		= @allStatus,
			alertTypeId		= @alertTypeId,
			criteriaName = @notifCriteriaForFeeds,
			jobID  = @liveFeedsJobIdint,
			ownerId =@notifOwnerId,
			@severity as alertSeverity,
			detectedTime = @strCondiHappTime
--			oldAlertTypes		= @oldAlertTypes,
--			oldAlertActions	= @oldAlertActions
FROM NTmessageFormat
WHERE NTnotificationId = @notifId
	AND  messageType=@messType
	AND  escalationLevel = @escLevel
RETURNRESULTS:
GO

IF EXISTS (select * from GxQscripts where name = 'br_ntFormatNotificationToSend')
	delete from GxQscripts where name = 'br_ntFormatNotificationToSend'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_ntFormatNotificationToSend')
	delete from GXDBVersions where aliasname = 'br_ntFormatNotificationToSend'
GO

insert into GXDBVersions values(2, 'br_ntFormatNotificationToSend',  '00010093004200030000', 'br_ntFormatNotificationToSend', '00010093004200030000')
GO

