

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/br_ntFormatNotificationForCI.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/br_ntFormatNotificationForCI.sp,v $ $Id: br_ntFormatNotificationForCI.sp,v 1.5.52.3 2018/06/06 11:16:05 vthakur Exp $";
--
--  +========================================================================+
--  |   Procedure:  br_ntFormatLiveFeedsNotifications()
--  |
--  | Description:  Intended to be called for populating LiveFeeds entries.
--	|				Fetches rows & formats Subject & Message Body
--	|				fields by token substitution.
--  |
--  |       Input:  messageType
--	|
--  |      Output:  xxx
--  |      Return:  xxx
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  +========================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: br_ntFormatNotificationForCI <<<'

IF EXISTS (select * from sysobjects where name='br_ntFormatNotificationForCI')
	drop procedure br_ntFormatNotificationForCI
IF EXISTS (select * from GxQscripts where name='br_ntFormatNotificationForCI')
	delete from GxQscripts where name = 'br_ntFormatNotificationForCI'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_ntFormatNotificationForCI')
	delete from GXDBVersions where aliasname = 'br_ntFormatNotificationForCI'
GO
print '... Creating Procedure: br_ntFormatNotificationForCI'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure br_ntFormatNotificationForCI
  @notifId integer ,
  @inpTriggerTime char(128) ,
  @escLevel integer ,
  @messType integer ,
  @maxMessageBodySize integer,
  @entities NTEXT,
  @xmlLiveFeedsListParam NTEXT
AS
  DECLARE @returnCode integer
SET NOCOUNT ON
DECLARE @iDoc     				integer
DECLARE @xml     				xml
DECLARE @currentEntity     		xml
DECLARE @currentEntityNText     nvarchar(max)
DECLARE @commcellId				integer
DECLARE @jobId					nvarchar(max)
DECLARE @alertCriteria			nvarchar(max)
DECLARE @description			nvarchar(max)
DECLARE @detectedTime			nvarchar(max)
DECLARE @triggerTime			datetime
DECLARE @xmlLiveFeedsList       XML
set @xmlLiveFeedsList = @xmlLiveFeedsListParam
DECLARE @iCount int
DECLARE @brAlertTrace			varchar(256)
set @brAlertTrace				=(select value from gxglobalParam Where name = 'bralertTrace')
set @brAlertTrace               = ISNULL(@brAlertTrace, 0)
if @brAlertTrace <> 0
	exec br_ntTrace '.. br_ntFormatLiveFeedsNotifications', @notifId, @inpTriggerTime, @escLevel, 0, @entities
set @triggerTime = convert(datetime,@inpTriggerTime)
declare @minLiveFeedId int
declare @maxLiveFeedId int
select top 1 @minLiveFeedId = LiveFeedId from NTLiveFeedsMessageHistory
order by LiveFeedId desc
Insert into NTNotificationsForCI(NTnotificationID,escalationLevel,Severity,ClientID,Client,CommCellID,CommCell,
		JobId,MessageFormatType,Status,Created,AlertName,AlertType,AlertCriteria,TokenValList,Description,DetectedTimeUTC,DetectedTime)
Select
Tbl.Col.value('@ntNotificationId', 'int'),
Tbl.Col.value('@escalationLevel', 'int'),
(CASE Tbl.Col.value('@severity', 'int') WHEN 1 THEN 'Critical' WHEN 2 THEN 'Warning' ELSE 'Information' END),
ISNULL(Tbl.Col.value('client[1]/@clientId', 'integer'),0),
ISNULL(Tbl.Col.value('client[1]/@clientName', 'nvarchar(max)'),''),
Tbl.Col.value('commCell[1]/@commCellId', 'integer'),
Tbl.Col.value('commCell[1]/@commCellName', 'nvarchar(max)'),
IsNull(Tbl.Col.value('@jobId', 'int'),0),
Tbl.Col.value('@messageFormatType', 'int'),
0,
dbo.GetUnixTime(GetUTCDate()),
Tbl.Col.value('@alertName', 'nvarchar(max)'),
Tbl.Col.value('@alertType', 'nvarchar(max)'),
Tbl.Col.value('@alertcriteria', 'nvarchar(max)'),
CONVERT(xml,Tbl.Col.value('@TokenValList', 'NVARCHAR(MAX)')),
Tbl.Col.value('@description', 'nvarchar(max)'),
(CASE WHEN Tbl.Col.value('detectedTime[1]/@timeValue', 'nvarchar(max)') IS NULL OR Tbl.Col.value('detectedTime[1]/@timeValue', 'nvarchar(max)') = ''
		THEN dbo.GetUnixTime(GetDate())
	  ELSE dbo.GetUnixTime(dbo.AlertDetectedTimeInUTC(Tbl.Col.value('detectedTime[1]/@timeValue', 'nvarchar(max)')))
END),
Tbl.Col.value('detectedTime[1]/@timeValue', 'nvarchar(max)')
FROM @xmlLiveFeedsList.nodes('/App_AlertNotificationList/notificationList') as Tbl(Col)
if @@ERROR>0
begin
	select @@ERROR
	return
end
select 0

IF EXISTS (select * from GxQscripts where name = 'br_ntFormatNotificationForCI')
	delete from GxQscripts where name = 'br_ntFormatNotificationForCI'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_ntFormatNotificationForCI')
	delete from GXDBVersions where aliasname = 'br_ntFormatNotificationForCI'
GO

insert into GXDBVersions values(2, 'br_ntFormatNotificationForCI',  '00010005005200030000', 'br_ntFormatNotificationForCI', '00010005005200030000')
GO

