

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/br_ntFormatLiveFeedsNotifications.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/br_ntFormatLiveFeedsNotifications.sp,v $ $Id: br_ntFormatLiveFeedsNotifications.sp,v 1.11.14.7 2018/03/27 08:12:16 jiechen Exp $";
--
--  +========================================================================+
--  |   Procedure:  br_ntFormatLiveFeedsNotifications()
--  |
--  | Description:  Intended to be called for populating LiveFeeds entries.
--	|				Fetches rows & formats Subject & Message Body
--	|				fields by token substitution.
--  |
--  |       Input:  messageType
--	|
--  |      Output:  xxx
--  |      Return:  xxx
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  +========================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: br_ntFormatLiveFeedsNotifications <<<'

IF EXISTS (select * from sysobjects where name='br_ntFormatLiveFeedsNotifications')
	drop procedure br_ntFormatLiveFeedsNotifications
IF EXISTS (select * from GxQscripts where name='br_ntFormatLiveFeedsNotifications')
	delete from GxQscripts where name = 'br_ntFormatLiveFeedsNotifications'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_ntFormatLiveFeedsNotifications')
	delete from GXDBVersions where aliasname = 'br_ntFormatLiveFeedsNotifications'
GO
print '... Creating Procedure: br_ntFormatLiveFeedsNotifications'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure br_ntFormatLiveFeedsNotifications
  @notifId integer ,
  @inpTriggerTime char(128) ,
  @escLevel integer ,
  @messType integer ,
  @maxMessageBodySize integer,
  @entities NTEXT,
  @xmlLiveFeedsListParam NTEXT
AS
Set transaction isolation level read uncommitted
  DECLARE @returnCode integer
SET NOCOUNT ON
DECLARE @iDoc     				integer
DECLARE @xml     				xml
DECLARE @currentEntity     		xml
DECLARE @currentEntityNText     nvarchar(max)
DECLARE @commcellId				integer
DECLARE @jobId					nvarchar(max)
DECLARE @alertCriteria			nvarchar(max)
DECLARE @description			nvarchar(max)
DECLARE @detectedTime			nvarchar(max)
DECLARE @triggerTime			datetime
DECLARE @xmlLiveFeedsList       XML
DEclare @laptopClientId			int
Declare @userId                 int = 0
set @xmlLiveFeedsList = @xmlLiveFeedsListParam
DECLARE @iCount int
DECLARE @brAlertTrace			varchar(256)
set @brAlertTrace				=(select value from gxglobalParam Where name = 'bralertTrace')
set @brAlertTrace               = ISNULL(@brAlertTrace, 0)
if @brAlertTrace <> 0
	exec br_ntTrace '.. br_ntFormatLiveFeedsNotifications', @notifId, @inpTriggerTime, @escLevel, 0, @entities
set @triggerTime = convert(datetime,@inpTriggerTime)
declare @minLiveFeedId int
declare @maxLiveFeedId int
select top 1 @minLiveFeedId = LiveFeedId from NTLiveFeedsMessageHistory
order by LiveFeedId desc
declare @userListXml xml
Insert into NTLiveFeedsMessageHistory(NTnotificationID,escalationLevel,ClientId,
		JobId,messageFormatType,AlertType,AlertCriteria,Description,DetectedTime,created)
Select
Tbl.Col.value('@ntNotificationId', 'int'),
(Tbl.Col.value('@escalationLevel', 'int') + (Tbl.Col.value('@severity', 'int') * POWER(2,16))),
IsNull(C.id,0),
IsNull(Tbl.Col.value('@jobId', 'int'),0),
Tbl.Col.value('@messageFormatType', 'int'),
Tbl.Col.value('@alertType', 'nvarchar(max)'),
Tbl.Col.value('@alertcriteria', 'nvarchar(max)'),
Tbl.Col.value('@description', 'nvarchar(max)'),
Tbl.Col.value('detectedTime[1]/@timeValue', 'nvarchar(max)'),
dbo.GetUnixTime(GetUTCDate())
FROM @xmlLiveFeedsList.nodes('/App_LiveFeedListResp/feedsList') as Tbl(Col)
left join App_client C on
Tbl.Col.value('client[1]/@clientName', 'nvarchar(max)') = C.name
select top 1  @maxLiveFeedId = LiveFeedId,@laptopClientId=clientId from NTLiveFeedsMessageHistory
order by LiveFeedId desc
SELECT  @userId=ref.value('@userId', 'int')
 FROM  @xmlLiveFeedsList.nodes('App_LiveFeedListResp/feedsList') R ( ref )
if @minLiveFeedId is null
	set @minLiveFeedId = 0
if @maxLiveFeedId is null
	set @maxLiveFeedId = -1
-- Now for each added alert, insert into NTLiveFeedsMessageHistoryTable also with default status UNREAD
DECLARE @NtNotificationUsers TABLE(NTnotificationID Integer,userId integer,escalationLevel integer)
-- '<App_Associations><entity userId="@userId"/></App_Associations>'
set @userListXml = (select @userId
	for xml path('entity'),root('App_Associations')
	)
INSERT INTO @NtNotificationUsers
SELECT DISTINCT @notifId  , userId , @escLevel
FROM  dbo.NTGetUsersForAlertRule(@notifId , @escLevel, 8192 , @laptopClientId, @userListXml )
WHERE userId IS NOT NULL
-- For subscription based alerts which restrict recipients based on user security, remove recipients who shouldnt receive this alert.
IF EXISTS (select 1 from NTnotificationRule where [ID] = @notifId and (status & 128)>0 )
begin
	if exists(select 1 from Gxglobalparam where name='bEnableSecurityForSubscriptionAlerts' and value='true' and modified=0)
	begin
		-- Call security api to see which user has CAT_ALERT_RECIPIENTS_ADD_REMOVE cap on alert.
			DECLARE @i_entityList XML
			SET @i_entityList = (SELECT
64 as '@entityType1',
			@notifId  as '@entityId1'
			for xml path('entity'),root('entityList') )
			IF object_id('tempdb.dbo.#tgroupObjects') is not null
			DROP TABLE #tgroupObjects
CREATE TABLE #tgroupObjects([userORGroupId] integer,[isUSer] integer,[roleId] integer,[permissionId] integer,[entitytype1]	 integer,[entityId1] integer,[entityType2] integer DEFAULT 0,[entityId2] integer DEFAULT 0,[entityType3] integer DEFAULT 0,[entityId3] integer DEFAULT 0,[entityType4] integer DEFAULT 0,[entityId4] integer DEFAULT 0,[entityType5] integer DEFAULT 0,  [entityId5] integer DEFAULT 0)
exec sec_getUMEntityandPermissionOnEntity '#tgroupObjects' ,64, @i_entityList,0,1,154,0
			-- For users not associated to plan we check security recipient list.
			delete from @NtNotificationUsers
			where userId>0 and userId not in
			(
				select tgroupObjects.userORGroupId from #tgroupObjects tgroupObjects
				where tgroupObjects.isUSer=1
			)
			and dbo.appgetPlanforUser(userId)=0
	end
if exists(select 1 from App_planProp with (READUNCOMMITTED) where attrname='Alert' + ' ' + cast(@notifId as nvarchar(32)) and attrval='1') OR
exists(select 1 from App_planProp with (READUNCOMMITTED) where attrname='Alert' and @notifId in (select cast(_ID as int) FROM dbo.SplitIDString(attrVal)) )
	begin
		-- if user recipient property is not set for alert, then refresh.
		if not exists(select 1 from NTNotificationProp with (READUNCOMMITTED) where componentNameId = @notifId
and attrName = 'Recipient UserId' and modified = 0)
					and not exists(select 1 from NTNotificationProp with (READUNCOMMITTED) where componentNameId = @notifId
and attrName = 'Recipient UserGroupId' and modified = 0)
		begin
			declare @userRGroupListFromPlan table
			(
				userRGroupId int,
				isUser int
			)
			Insert into @userRGroupListFromPlan
			select * from dbo.NTGetPlanRecipientsForRule(@notifId)
			Insert into NTNotificationProp(componentNameId,attrName,attrType,attrVal,created,modified)
select @notifId,'Recipient UserId',7,userRGroupId, dbo.getunixtime(getutcdate()),0
			from @userRGroupListFromPlan
			where isUser=1
			Insert into NTNotificationProp(componentNameId,attrName,attrType,attrVal,created,modified)
select @notifId,'Recipient UserGroupId',7,userRGroupId, dbo.getunixtime(getutcdate()),0
			from @userRGroupListFromPlan
			where isUser=0
		end
		-- For users associated to some plan we check plan recipient list.
		delete from @NtNotificationUsers
		where userId>0 and userId not in
		(
			select cast(attrval as int) from NTNotificationProp
			where componentNameId = @notifId
and attrName = 'Recipient UserId'
			and modified = 0
			union
			select UMUsergroup.userid from NTNotificationProp
			inner join UMuserGroup
			on componentNameId = @notifId
and attrName = 'Recipient UserGroupId'
			and modified = 0
			and isnumeric(attrval)=1
			and cast(attrval as int)=UMUsergroup.groupId
		)
		and dbo.appgetPlanforUser(userId)>0
	end
end
insert into NTLiveFeedsStatus
select distinct NTLFMH.LiveFeedId,tempNotif.userId,8,''
from NTLiveFeedsMEssageHistory NTLFMH
inner join @NtNotificationUsers  AS tempNotif
on NTLFMH.NTNotificationId = tempNotif.NTnotificationID
and (NTLFMH.escalationLevel & 0x0000FFFF) = tempNotif.escalationLevel
where NTLFMH.LiveFeedID > @minLiveFeedId
and NTLFMH.LiveFeedID <= @maxLiveFeedId
if @@ERROR>0
begin
	select @@ERROR
	return
end
select 0

IF EXISTS (select * from GxQscripts where name = 'br_ntFormatLiveFeedsNotifications')
	delete from GxQscripts where name = 'br_ntFormatLiveFeedsNotifications'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_ntFormatLiveFeedsNotifications')
	delete from GXDBVersions where aliasname = 'br_ntFormatLiveFeedsNotifications'
GO

insert into GXDBVersions values(2, 'br_ntFormatLiveFeedsNotifications',  '00010011001400070000', 'br_ntFormatLiveFeedsNotifications', '00010011001400070000')
GO

