

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/br_ntExecuteCustomQuery.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/br_ntExecuteCustomQuery.sp,v $ $Id: br_ntExecuteCustomQuery.sp,v 1.9.48.5 2018/08/26 17:15:24 mnatarajan Exp $";
--
--  +========================================================================+
--  |   Procedure:  br_ntExecuteCustomQuery()
--  |
--  | Description:  Executes query and return results
--  |
--  |       Input:  QueryId
--  |
--  |      Output:  Returns results of execution of the query
--  |      Return:  None
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |   1.0        mnatarajan     Initial Edit
--  +========================================================================+
-- Procedure Name
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: br_ntExecuteCustomQuery <<<'

IF EXISTS (select * from sysobjects where name='br_ntExecuteCustomQuery')
	drop procedure br_ntExecuteCustomQuery
IF EXISTS (select * from GxQscripts where name='br_ntExecuteCustomQuery')
	delete from GxQscripts where name = 'br_ntExecuteCustomQuery'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_ntExecuteCustomQuery')
	delete from GXDBVersions where aliasname = 'br_ntExecuteCustomQuery'
GO
print '... Creating Procedure: br_ntExecuteCustomQuery'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure br_ntExecuteCustomQuery
  @inputXml xml
AS
SET NOCOUNT ON
declare	@userId				INT
declare @userName			nvarchar(max)
declare	@localeId			INT
declare	@lastRunTime		INT
declare @xmlVal				xml
declare	@queryString		nvarchar(max)
declare @filterString		nvarchar(max)
declare @sqlQuery			nvarchar(max)
declare @queryIdForCursor	int
declare @ntNotificationId	int
declare @currCommcellId		int
declare @errorMessageString nvarchar(max) = ''
SET @localeId = ISNULL((SELECT  ref.value('@localeId', 'int') AS Agent
      FROM    @inputXml.nodes('CVGui_QueryExecuteReqParams') R ( ref )),0)
SET @lastRunTime = ISNULL((SELECT  ref.value('@lastRunTime', 'int') AS Agent
      FROM    @inputXml.nodes('CVGui_QueryExecuteReqParams') R ( ref )),0)
SET @userName = ISNULL((SELECT  ref.value('@userName', 'nvarchar(max)') AS Agent
      FROM    @inputXml.nodes('CVGui_QueryExecuteReqParams/userInfo') R ( ref )),'')
SET @userId = ISNULL((SELECT  ref.value('@userId', 'int') AS Agent
      FROM    @inputXml.nodes('CVGui_QueryExecuteReqParams/userInfo') R ( ref )),0)
SET @queryString = ISNULL((SELECT  ref.value('@queryString', 'nvarchar(max)') AS Agent
      FROM    @inputXml.nodes('CVGui_QueryExecuteReqParams') R ( ref )),'')
SET @filterString = ISNULL((SELECT  ref.value('@filterString', 'nvarchar(max)') AS Agent
      FROM    @inputXml.nodes('CVGui_QueryExecuteReqParams') R ( ref )),'')
SET @queryIdForCursor = ISNULL((SELECT  ref.value('@queryId', 'int') AS Agent
      FROM    @inputXml.nodes('CVGui_QueryExecuteReqParams') R ( ref )),0)
SET @ntNotificationId = ISNULL((SELECT  ref.value('@ntNotificationId', 'int') AS Agent
      FROM    @inputXml.nodes('CVGui_QueryExecuteReqParams') R ( ref )),0)
set @currCommcellId = ISNULL((SELECT  ref.value('@grcCommcellId', 'int') AS Agent
      FROM    @inputXml.nodes('CVGui_QueryExecuteReqParams') R ( ref )),0)
IF @userId = 0
BEGIN
	SELECT @userId = id from UMUsers
	where login=@userName
END
declare @alertsToBeProcessed table
(
	resultId int,
	entity xml,
	queryId int, -- Query Id corresponding to the primary key in NTQueryList table
	ntnotificationId int,
	errorMessage nvarchar(max),
	entityId nvarchar(max)
)
declare @columnValueList table
(
	queryId int,
	ntNotificationId int,
	resultId int,
	colName nvarchar(max),
	colValue nvarchar(max),
	colIndex int,
	primaryKey int
)
declare @columnNames table
(
    columnName nvarchar(max),
    sqlcolumnType nvarchar(max),
	isPrimaryKey int,
	colIndex int identity(1,1)
)
if object_id('tempdb.dbo.##customqueryResults') is not null
	DROP TABLE ##customqueryResults
declare @InputsToSP table
(
	paramName nvarchar(max),
	paramValue nvarchar(max),
	sqlDataType nvarchar(max),
	isList int,
	listColDataType nvarchar(max),
	javaType nvarchar(max),
	paramId int identity(1,1)
)
declare @query nvarchar(max)
begin try
	delete from @InputsToSP
	set @query = @queryString
	declare @queryParams nvarchar(max)
	set @queryParams = N'@userId int, @localeId int, @lastRunTime int'
	Insert into @InputsToSP(paramName,paramValue,sqlDataType,isList,listColDataType,javaType)
	select T2.Col.value('@paramName','nvarchar(MAX)'),
	IsNull(T2.Col.value('@value','nvarchar(MAX)'),''),
	T2.Col.value('@sqlDataType','nvarchar(MAX)'),
	IsNull(T2.Col.value('@isList','int'),0),
	T2.Col.value('@listColDataType','nvarchar(MAX)'),
	T2.Col.value('@javaType','nvarchar(MAX)')
	from @inputXml.nodes('CVGui_QueryExecuteReqParams/queryAdditionalInfo/queryParameters/queryParameters') as T2(Col)
	delete from @InputsToSP
	where paramName is null or len(paramName)=0
	Insert into @columnNames(columnName, sqlcolumnType,isPrimaryKey)
	select T2.Col.value('@columnName','nvarchar(MAX)'),
	T2.Col.value('@sqlDataType','nvarchar(MAX)'),
	T2.Col.value('@isPrimaryKey','int')
	from @inputXml.nodes('CVGui_QueryExecuteReqParams/queryOutputCols/queryOutputCols') as T2(Col)
	delete from @columnNames
	where columnName is null or sqlcolumnType is null
	declare @paramAttrXml xml
	declare @paramAttrstring nvarchar(max)
	set @paramAttrXml = (select paramName '@paramName',
	paramValue '@paramValue',
	sqlDataType '@sqlDataType',
	isList '@isList',
	listColDataType '@listColDataType',
	javaType '@javaType'
	from @InputsToSP
	for xml path('Param'),root('App_ParamList'))
	set @paramAttrstring = convert(nvarchar(max),@paramAttrXml)
	-- Create the temp table first.
	declare @tableCreationString nvarchar(max)
	set @tableCreationString = 'Create table ##customqueryResults( _resultId int identity(1,1) '
	select @tableCreationString = @tableCreationString + ' , ' + columnName + ' ' + sqlcolumnType
	from @columnNames
	set @tableCreationString += ' )'
	execute sp_executesql @tableCreationString
	-- First param to sp_executesql is the string query to be executed. Second param is param definition for the string query
	-- second param indicates @xmlVal in @query is of xml type
	-- third param maps param in param definition to local variable.
	-- Insert into ##customqueryResults
	-- No need to insert into temp table now.. this is done from clr itself.
	-- Now we return error message only.
	exec dbo.ExecuteCustomQuery @query,@paramAttrstring, @errorMessageString out
	if len(@errorMessageString)>0
	begin
		Insert into @alertsToBeProcessed(queryId,entity,ntnotificationId,errorMessage)
		select @queryIdForCursor,'',@ntNotificationId,@errorMessageString
		Goto END_ITEM_SP
	end
	if (@filterString is not null and len(@filterString)>0)
	begin
		set @sqlQuery = 'delete from ##customqueryResults where not ('+ @filterString+ ')'
		execute sp_executesql @sqlQuery
	end
	declare @columnListString nvarchar(max)
	set @columnListString = '('
	select @columnListString = @columnListString + columnName + ' ,'
	from @columnNames
	if (patindex('%,',@columnListString)>0)
		select @columnListString = substring(@columnListString,1,len(@columnListString)-1)
	set @columnListString += ' ) '
	declare @columnListStringForSelect nvarchar(max)
	set @columnListStringForSelect = ''
	select @columnListStringForSelect = @columnListStringForSelect +
		' IsNull(convert(nvarchar(max),'+ columnName + '),''NULL'') as '+columnName+' ,'
	from @columnNames
	if (patindex('%,',@columnListStringForSelect)>0)
		select @columnListStringForSelect = substring(@columnListStringForSelect,1,len(@columnListStringForSelect)-1)
	set @columnListStringForSelect += ' '
	set @sqlQuery = 'SELECT '+convert(nvarchar(max),@queryIdForCursor)+' , ' +
			convert(nvarchar(max),@ntNotificationId)+' , _resultId, colName, colValue
			FROM (SELECT _resultId, '+@columnListStringForSelect+ ' FROM ##customqueryResults) p
			UNPIVOT
			(ColValue FOR colName IN '+ convert(nvarchar(max),@columnListString) +')AS unpvt;'
	Insert into @columnValueList(queryId,ntNotificationId, resultId ,colName ,colValue)
	execute sp_executesql @sqlQuery
	update @columnValueList
	set colValue = ''
	where colValue is null
	Update colValueList
	set colIndex = templateColList.colIndex,
	primaryKey = templateColList.isPrimaryKey
	from @columnNames templateColList,@columnValueList colValueList
	where templateColList.columnName =  colValueList.colName
	Insert into @alertsToBeProcessed(queryId,entity,ntnotificationId,errorMessage,resultId)
		select @queryIdForCursor,'',@ntNotificationId,'',_resultId -- No error
		from ##customqueryResults
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	-- Error in execution
	Insert into @alertsToBeProcessed(queryId,entity,ntnotificationId,errorMessage)
	select @queryIdForCursor,'',@ntNotificationId,Error_MEssage()
	Goto END_ITEM_SP
END CATCH
-- In case query doesnt return any results, we return a dummy row so that cpp layer knows
-- this query has run but didnt return any results.
-- This will be used for clearing all existing rows for that query and rule.
if not exists(select 1 from @alertsToBeProcessed where queryId = @queryIdForCursor
	and ntnotificationId = @ntNotificationId)
begin
	Insert into @alertsToBeProcessed(queryId,entity,ntnotificationId,errorMessage)
	select @queryIdForCursor,'',@ntNotificationId,'' -- No error
end
update @alertsToBeProcessed
	set entityId = colValueList.entityId +
		case when @currCommcellId<>2 and @currCommcellId<>0 then cast(@currCommcellId as nvarchar(max))
		else ''
		end
	from @alertsToBeProcessed Results inner join
	(
		select queryId,resultId,NTNotificationId,
				(SELECT ', ' + cast(dbo.EncodeInvalidXmlChar(t2.colValue) as nvarchar(max))
				FROM @columnValueList t2
				where t.queryId = t2.queryId
				and t.resultId = t2.resultId
				and t.ntnotificationId = t2.ntnotificationId
				and t2.PrimaryKey = 1
				FOR XML PATH(''),type).value('.', 'nvarchar(max)') AS entityId
			from @columnValueList t
			group by queryId,resultId,NTNotificationId
	) colValueList
	on results.queryId = colValueList.queryId
	and results.resultId = colValueList.resultId
	and results.ntnotificationId = colValueList.NTNotificationId
END_ITEM_SP:
if object_id('tempdb.dbo.##customqueryResults') is not null
	DROP TABLE ##customqueryResults
-- Now that we have all the results/ all new alerts to be sent, we will return xml
declare @xml xml
set @xml = (select queryId '@queryId',
	convert(nvarchar(max),entity) '@queryResults',
	ntnotificationId '@notifRuleId',
	errorMessage '@errorMessage',
	@currCommcellId '@commcellId',
	entityId '@entityId',
	(
		select colValueList.colIndex '@colIndex', dbo.EncodeInvalidXmlChar(colValueList.colValue) '@value'
		from @columnValueList colValueList
		where colValueList.resultId  = Alerts.resultId and
		Alerts.queryId = colValueList.queryId and
		Alerts.ntnotificationId = colValueList.ntnotificationId
		for xml path('columnValueList')	,root('columnValueList'),type
	)
	from @alertsToBeProcessed Alerts
	order by queryId,ntnotificationId
	for xml path('queryResultsList'),root('App_QueryResultsContainerList'))
if @xml is null
begin
	set @xml = '<App_QueryResultsContainerList/>'
end
select @xml
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'br_ntExecuteCustomQuery')
	delete from GxQscripts where name = 'br_ntExecuteCustomQuery'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_ntExecuteCustomQuery')
	delete from GXDBVersions where aliasname = 'br_ntExecuteCustomQuery'
GO

insert into GXDBVersions values(2, 'br_ntExecuteCustomQuery',  '00010009004800050000', 'br_ntExecuteCustomQuery', '00010009004800050000')
GO

