

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/br_ntEnableDisableNotificationTypeForNTRule.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems,  Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems,  Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/br_ntEnableDisableNotificationTypeForNTRule.sp,v $ $Id: br_ntEnableDisableNotificationTypeForNTRule.sp,v 1.2.54.3 2018/03/27 09:03:24 jiechen Exp $";
-- 	+---------------------------------------------------+
--	| 			PROCEDURE : "br_ntEnableDisableNotificationTypeForNTRule"			|
-- 	+---------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: br_ntEnableDisableNotificationTypeForNTRule <<<'

IF EXISTS (select * from sysobjects where name='br_ntEnableDisableNotificationTypeForNTRule')
	drop procedure br_ntEnableDisableNotificationTypeForNTRule
IF EXISTS (select * from GxQscripts where name='br_ntEnableDisableNotificationTypeForNTRule')
	delete from GxQscripts where name = 'br_ntEnableDisableNotificationTypeForNTRule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_ntEnableDisableNotificationTypeForNTRule')
	delete from GXDBVersions where aliasname = 'br_ntEnableDisableNotificationTypeForNTRule'
GO
print '... Creating Procedure: br_ntEnableDisableNotificationTypeForNTRule'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure br_ntEnableDisableNotificationTypeForNTRule
  @i_userId INTEGER,
  @i_userAction INTEGER,
  @i_ntRuleId INTEGER,
  @i_notifType INTEGER,
  @locale int
AS
declare @errorCode	int
declare @errorString	nvarchar(1024)
set @errorCode=0
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
declare @sqlError       int
declare @alertName      nvarchar(255)
BEGIN TRAN
------------------------------
-- MAKE SURE ALERT EXISTS:	--
------------------------------
IF NOT EXISTS (select * from NTnotificationRule with (nolock) WHERE id = @i_ntRuleId  and revision=1  )
BEGIN
set @errorCode = CAST(0x0B0003 AS INT)
set @errorString = dbo.fn_EvFormatEventMsgText(0,@locale, (143 | (CAST(POWER(2, 24) AS BIGINT) * 74)), 0,2)
	goto PERFORM_ALERTOP_EXIT
END
ELSE
	Set @alertName = (SELECT notificationName from NTnotificationRule with (nolock) WHERE id = @i_ntRuleId)
------------------------------------------------------------------------------------
--  CHECK FOR THE RIGHTS! --
------------------------------------------------------------------------------------
--Only users with 'Edit Alert' permission on the alert can enable/disable the notification type for the alert
DECLARE @userHasRight INT = 0
EXEC sec_checkPermissionOnEntity @i_userId, 152, @userHasRight OUTPUT, 64, @i_ntRuleId
IF @userHasRight = 0
BEGIN
SET @errorCode = (2409 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2409 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale)
    SET @errorString = REPLACE(@errorString, '^1%s', ISNULL((SELECT login FROM UMUsers WHERE id = @i_userId),''))
SET @errorString = REPLACE(@errorString, '^2%s', (SELECT message FROM EvLocaleMsgs WHERE messageId = (2815 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale))
    SET @errorString = REPLACE(@errorString, '^3%s', @alertName)
SET @errorString = REPLACE(@errorString, '^4%s', (SELECT message FROM EvLocaleMsgs WHERE messageId = (2812 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale))
    GOTO PERFORM_ALERTOP_EXIT
END
declare @notifTypeList table
(
	notifType int,
	isText int
)
Insert into @notifTypeList
select 1,0
union
select 4,1
union
select 8,1
union
select 512,0
union
select 1024,0
union
select 8192,0
union
select 65536,0
union
select 32768,1
union
select 131072,1
if (not exists(select 1 from @notifTypeList where notifType=@i_notifType))
begin
set @errorCode = CAST((1134 | (CAST(POWER(2, 24) AS BIGINT) * 74)) AS INT)
	set @errorString = 'Invalid notification type passed'
	goto PERFORM_ALERTOP_EXIT
end
-- For disabling notification type, We need to check whether that alert has only that notification type. If so, we shouldnt allow it
if @i_userAction=1
begin
	if exists(select 1 from NTNotificationRule where id=@i_ntRuleId AND revision > 0
		and ( notifType = @i_notifType Or (notifType - 131072) = @i_notifType))
	begin
		set @errorCode = 1
		set @errorString = 'Removing notification type not allowed since alert rule provided has only this notification type selected.'
		goto PERFORM_ALERTOP_EXIT
	end
end
if @i_userAction=1	--Notification type disabled
begin
	UPDATE NTnotificationRule set notifType = notifType - @i_notifType
		WHERE id = @i_ntRuleId AND revision > 0
		and (notifType & @i_notifType)>0
	delete from NTMessageFormat
	where NTNotificationId=@i_ntRuleId
	and messageType=@i_notifType
end
else
begin
	UPDATE NTnotificationRule set notifType = notifType | @i_notifType
	WHERE id = @i_ntRuleId AND revision > 0
	declare @defaultTextTemplate nvarchar(max) = ''
	declare @defaultHtmlTemplate nvarchar(max) = ''
	select @defaultTextTemplate=formatString, @defaultHtmlTemplate=formatStringHtml
	from NTMessageFormat with (nolock)
	inner join @notifTypeList NotifTypeList on
	NTMessageFormat.messageType=NotifTypeList.notifType
	inner join @notifTypeList NotifTypeList1 on
	NotifTypeList1.notifType=@i_notifType
	where NotifTypeList1.isText = NotifTypeList.isText
	and NTnotificationID=@i_ntRuleId
	and NTMessageFormat.messageType not in (16,65536,131072)
	if (len(@defaultTextTemplate)=0 and len(@defaultHtmlTemplate)=0)
	begin
		declare @ntAlertTypeId int = 0
		declare @localeId int=0
		select @ntAlertTypeId = alertTypeid,@localeId=locale from NTNotificationRule with (nolock)
		where id=@i_ntRuleId
		select @defaultTextTemplate=defaultFormatString
		from NTNotificationTemplate with (nolock)
		where NTAlertTypeId=@ntAlertTypeId and locale=@localeId
		and messageformatType=0
		and messageType=@i_notifType
		select @defaultHtmlTemplate=defaultFormatString
		from NTNotificationTemplate with (nolock)
		where NTAlertTypeId=@ntAlertTypeId and locale=@localeId
		and messageformatType=1
		and messageType=@i_notifType
	end
	if not exists(select 1 from NTmessageFormat with (nolock)
		where messageType=@i_notifType and NTnotificationID=@i_ntRuleId)
	begin
		INSERT NTmessageFormat (NTnotificationID,messageType,escalationLevel,formatString,formattedMessage,
							SubjFieldStart,SubjFieldLen,MsgBodyStart,MsgBodyLen,mfOptions,
							baseDir,userName,password, rssID, messageFormatType, formatStringHtml)
		select @i_ntRuleId, @i_notifType, 1, @defaultTextTemplate, N'',
               			 0, 0, 0, 0, 2,
						 '', '', '', '', 1, @defaultHtmlTemplate
	end
end
set @sqlError = @@error
if @sqlError <> 0
BEGIN
	set @errorCode = 2
set @errorString = dbo.fn_EvFormatEventMsgText(0,@locale, (172 | (CAST(POWER(2, 24) AS BIGINT) * 74)), 0,2) + N' : ' + @alertName
	goto PERFORM_ALERTOP_EXIT
END
PERFORM_ALERTOP_EXIT:
select (
	SELECT	1			         as TAG,
		NULL		         as Parent,
		@errorCode			     as [CVGui_GenericResp!1!errorCode],
		@errorString	         as [CVGui_GenericResp!1!errorMessage]
	FOR XML EXPLICIT
) as o_responseXML
if (@errorCode = 0)
    COMMIT TRAN
else
    ROLLBACK TRAN
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'br_ntEnableDisableNotificationTypeForNTRule')
	delete from GxQscripts where name = 'br_ntEnableDisableNotificationTypeForNTRule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_ntEnableDisableNotificationTypeForNTRule')
	delete from GXDBVersions where aliasname = 'br_ntEnableDisableNotificationTypeForNTRule'
GO

insert into GXDBVersions values(2, 'br_ntEnableDisableNotificationTypeForNTRule',  '00010002005400030000', 'br_ntEnableDisableNotificationTypeForNTRule', '00010002005400030000')
GO

