

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/br_ntCheckAndAddHistory.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/CTE/Modules/Source/DbLib/sp/br_ntCheckAndAddHistory.sp,v $ $Id: br_ntCheckAndAddHistory.sp,v 1.22.2.1 2017/02/10 20:53:27 sjohnson Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   br_ntCheckAndAddHistory   - Check the specified SpoolQueue entry and conditionally
--                      		 add it to the NTmessageHistory table based on reporting
--							     rules for this Notification
--
--			Return:				 @retVal: < 0:      Error
--										  ==0:      No addition to History
--										 ==notifId: new messages to be sent!
--
--			 Note:				 There will be a seperate entry in the NTmessages table for the normal and escalated version
--								 of every Notification message
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  'MAGIC' Numbers used here, as defined in "CNAlertDefines.h"
--	----------------------------------------------------------
declare  @defines int					-- (Not used in proc, only here to expose following Macro defs.)
set @defines = 0	--'NT_NOTIF_STATE_CLEARED'
set @defines = 1	--'NT_NOTIF_STATE_DETECTED'
set @defines = 2	--'NT_NOTIF_STATE_CONTENTCHANGED'
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: br_ntCheckAndAddHistory <<<'

IF EXISTS (select * from sysobjects where name='br_ntCheckAndAddHistory')
	drop procedure br_ntCheckAndAddHistory
IF EXISTS (select * from GxQscripts where name='br_ntCheckAndAddHistory')
	delete from GxQscripts where name = 'br_ntCheckAndAddHistory'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_ntCheckAndAddHistory')
	delete from GXDBVersions where aliasname = 'br_ntCheckAndAddHistory'
GO
print '... Creating Procedure: br_ntCheckAndAddHistory'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure br_ntCheckAndAddHistory
--	+-------------------------------+
--	| PARAMETERS   &   OUTPUTS		|
--	+-------------------------------+
  @notifId int,
  @timeStamp datetime,
  @escLevelParam int,
  @notificationState int,
  @retVal int  OUTPUT
AS
--	+-------------------------------+
--	| LOCAL VARIABLE DECLARATION	|
--	+-------------------------------+
declare @reportingOptions		integer						-- From NTnotification definition
declare @delayTimeSeconds		integer
declare	@persistTimeSeconds		integer
declare @notifLevel				integer						-- From SpoolQueue Entry
declare @lastSetConditonSent	datetime						-- From NTmessages
declare @firstDetectTime		datetime
declare @NTmessageState			integer
declare @rerportingOptions		integer
declare @OKtoAddToHistory		integer						-- Locals
declare @OKtoGenerateMessage	integer
declare @localError				integer
declare @schedId				integer
declare @attachStatus			integer
declare @escLevel				integer
declare @actualTimeStamp		datetime
declare @nextIterationTimeStamp		datetime
-- We use actualThresholdValue field in NTSpoolQueue to figure out whether this message
declare @actualThresholdValue	integer
set @actualThresholdValue = 0
select @actualThresholdValue = actualThresholdValue from NTspoolQueue
WHERE NTnotificationId = @notifId AND triggerTime = @timeStamp
--	+-------------------------------+
--	| LOCAL VARIABLE INITIALIZATION	|
--	+-------------------------------+
	set @retVal				 = 0	-- Assume we will just ignore this record
	set @OKtoAddToHistory	 = 0    -- By Default we assume that we will NOT be adding an entry to the History
	set @OKtoGenerateMessage = 0    -- By Default, even if we add to the history, we don't automatically cause messages to be sent!
set @schedID			 = (select ntnotificationId FROM NTnotification WHERE notificationName = 'Scheduler Routing')
set @attachStatus		 = 0
	set @escLevel			 = @escLevelParam          -- For QNet, this is how it stays. For Qinetix, we need to derive
                                                       -- Escalation level from reporting Criteria (time based vs. statistics based)
	-- First check whether its a Start of the iteration entry. For that ContentStatus will be 4. And esc will be 0.
	-- If so. dont process this entry further. Subsequent "proper" entries will use this.
	-- This entry is added to indicate start of the iteration. So that if u have 18 media agents added in an iteration,
	-- either all of them meet the criteria (of persistTimeSeconds or persistTimeSeconds2) or none of them meet
	-- Sometimes it happens that (due to few seconds), 10 of them meet the criteria and first 8 dont.
	if @escLevel = 0 and @notificationState = 4
	begin
		return
	end
	--- FROM NOTIFICATION DEFINITION ---
	------------------------------------
--#ifndef COMMNET
	DECLARE  @lastSetConditonSent2  datetime
	DECLARE	@persistTimeSeconds2	integer
	DECLARE	@delayTimeSeconds2		integer
	SET @persistTimeSeconds2		=  ISNULL((select persistTimeSeconds2 from NTnotification where NTnotificationID = @notifId AND revision > 0), 0)
	SET @delayTimeSeconds2			=  ISNULL((select delayTimeSeconds2   from NTnotification where NTnotificationID = @notifId AND revision > 0), 0)
IF (@notificationState  & 1) >0 AND (@delayTimeSeconds2 > 0)		--'NT_NOTIF_STATE_DETECTED'
	BEGIN
			SET @lastSetConditonSent2 	=  (select firstDetectTime    from NTmessages where NTnotificationId = @notifId AND escalationLevel = 1)
--		SELECT 'DEBUG', '@persistTimeSeconds2'=@persistTimeSeconds2, '@lastSetConditonSent2'=@lastSetConditonSent2, '@timeStamp'=@timeStamp
--		IF ((@delayTimeSeconds2 >0  AND @timeStamp >= DATEADD(second, @delayTimeSeconds2, @lastSetConditonSent2))  OR @notifId = @schedId)
--			SET @escLevel =2
	END
--#endif
	IF (@escLevel = 1)
	  BEGIN
		set @reportingOptions	=	(select reportingOptions   from NTnotification where NTnotificationID = @notifId AND revision > 0)
		set @delayTimeSeconds	=	ISNULL((select delayTimeSeconds   from NTnotification where NTnotificationID = @notifId AND revision > 0), 0)
		set @persistTimeSeconds =	(select persistTimeSeconds from NTnotification where NTnotificationID = @notifId AND revision > 0)
		IF  ((select hasAttachments from NTnotification where NTnotificationID = @notifId AND revision > 0) > 0)
set @attachStatus = 1
	  END
	ELSE
	  BEGIN
		set @reportingOptions	=	(select reportingOptions2   from NTnotification where NTnotificationID = @notifId AND revision > 0)
		set @delayTimeSeconds	=	ISNULL((select delayTimeSeconds2   from NTnotification where NTnotificationID = @notifId AND revision > 0), 0)
		set @persistTimeSeconds =	(select persistTimeSeconds2 from NTnotification where NTnotificationID = @notifId AND revision > 0)
		IF  ((select hasAttachments2 from NTnotification where NTnotificationID = @notifId AND revision > 0) > 0)
set @attachStatus = 1
	  END
	set @delayTimeSeconds=0			-- KLUDGE: GUI is senting this value to the backend. Currently though, this option is not used in Galaxy (only QNet)
--	set @persistTimeSeconds =1		-- WE HAVE 'REPEAT TEST" NOW!
	--- FROM NTmessages ENTRY ---
	-----------------------------
	set @lastSetConditonSent 		=  (select lastSetMessageTime from NTmessages where NTnotificationId = @notifId AND escalationLevel = @escLevel)
	set @firstDetectTime     		=  (select firstDetectTime from NTmessages  where NTnotificationId = @notifId AND escalationLevel = @escLevel)
----------------------------------------
---          DO THE WORK!            ---
----------------------------------------
BEGIN TRANSACTION
IF ((@notificationState  & 2) <> 0)		--'NT_NOTIF_STATE_CONTENTCHANGED'
BEGIN
		SET @OKtoAddToHistory = 1
		SET @OKtoGenerateMessage =1				-- NOTE FOR NOW, !NOT! DOING DELAY TIME CHECK ... ALL CONTENT CHANGES WILL BE "REPORTED"
		GOTO CHECK_AND_ADD_HISTORY_EXIT
END
IF (@notificationState = 0)		--'NT_NOTIF_STATE_CLEARED'
BEGIN																-- Note: may want to add some "state" flag so that we can
	if (@lastSetConditonSent IS NOT NULL)							--       "debounce" messages
	BEGIN
		SET @OKtoAddToHistory = 1
IF ((@reportingOptions  & 4) <> 0)		--'NT_REPORT_NOTIFY_CONDITION_CLEAR'
		BEGIN
			SET @OKtoGenerateMessage =1
		END
	END
	GOTO CHECK_AND_ADD_HISTORY_EXIT
END
IF (@firstDetectTime IS NULL)
BEGIN
	SET @firstDetectTime = @timeStamp
			UPDATE NTmessages
			SET firstDetectTime = @timeStamp
			WHERE NTnotificationId = @notifId
			   AND escalationLevel = @escLevel
END
-- Compute the actual timeStamp at the start of the iteration.
set @actualTimeStamp = @timeStamp
-- Indicates the start of the current iteration
set @actualTimeStamp = IsNull((select max(triggerTime) from NTSpoolQueue
			where NTNotificationId = @notifId and triggerTime<@timeStamp
			and notifState = 4 and status!=-1 and escalationlevel=0),@timeStamp)
-------------------------------------------------------------------------
---               HAS TO BE "CONDITION DETECTED" STATE                ---
--- DO THE FOLLOWING CHECK IF WE HAVE NOT SENT NOTIFICATIONS YET      ---
-------------------------------------------------------------------------
if (@lastSetConditonSent IS NULL)										-- Condition HAS NOT been detected/reported Yet (or was cleared by a "clear" reported condition
BEGIN
	SET @OKtoAddToHistory = 1
	IF (@actualTimeStamp >= DATEADD(second, @delayTimeSeconds, @firstDetectTime) OR @notifId = @schedId)
	BEGIN
		SET @OKtoGenerateMessage =1
	END
	GOTO CHECK_AND_ADD_HISTORY_EXIT
END
--	,actionTime=CONVERT(CHAR(2),DATEPART(hour,actionTime))+':'+CONVERT(CHAR(2),DATEPART(minute,actionTime))+':'+CONVERT(CHAR(2),DATEPART(second,actionTime))
-------------------------------------------------------------------------
---          (STILL) HAS TO BE "CONDITION DETECTED" STATE             ---
--- DO THE FOLLOWING CHECK IF WE HAVE NOT SENT NOTIFICATIONS YET      ---
-------------------------------------------------------------------------
	IF ((@persistTimeSeconds >0  AND @actualTimeStamp >= DATEADD(second, @persistTimeSeconds, @lastSetConditonSent))  OR @notifId = @schedId)
	BEGIN
	SET @OKtoAddToHistory = 1
	SET @OKtoGenerateMessage =1
END
GOTO CHECK_AND_ADD_HISTORY_EXIT
-------------------
---     END     ---
-------------------
CHECK_AND_ADD_HISTORY_EXIT:
--	+-----------------------------------------------------------------------------------------------------------------------------------+
--	| IF NOTIFICATIONS ARE TO BE SENT, WE NEED TO GENERATE A BIT MASK HERE TO ESTABLISH WHICH TYPES OF NOTIFICATIONS ARE TO BE SENT		|
--	| .. BY COMPARING THESE BITS TO THE BITS SET INT NTmessageHistory.sentStatus, WE WILL KNOW WHICH NOTIFICATION TYPES FOR A GIVEN		|
--	| .. HISTORY ITEM STILL NEED TO BE SENT																								|
--	+-----------------------------------------------------------------------------------------------------------------------------------+
	DECLARE @templateId INTEGER = ISNULL((SELECT TOP 1 templateId FROM APP_Template WHERE templateForMonitoringType = 5 AND templateName = 'Alert'),0)
	DECLARE @doAlertIndexing INTEGER = ISNULL((SELECT TOP 1 1 FROM
			APP_MonitoringPolicy mp WITH(NOLOCK) INNER JOIN APP_MonitorTemplateAssoc mpAssoc WITH(NOLOCK)
				ON mp.monitorPolicyId = mpAssoc.monitorPolicyId
					WHERE mpAssoc.templateId = @templateId AND mp.status NOT IN (1,3)),0)
	if (@OKtoGenerateMessage <> 0)
	BEGIN
		SET @OKtoGenerateMessage = 0
		IF EXISTS (SELECT * FROM NTnotification WHERE NTnotificationId = @notifId AND revision > 0 AND emailEnable <> 0)
SET @OKtoGenerateMessage = @OKtoGenerateMessage + 1					-- 'NT_EMAIL_ALERTNOTIF'
		IF EXISTS (SELECT * FROM NTnotification WHERE NTnotificationId = @notifId AND revision > 0 AND pagerEnable <> 0)
SET @OKtoGenerateMessage = @OKtoGenerateMessage + 2					-- 'NT_PAGER_ALERTNOTIF'
		IF EXISTS (SELECT * FROM NTnotification WHERE NTnotificationId = @notifId AND revision > 0 AND snmpEnable <> 0)
SET @OKtoGenerateMessage = @OKtoGenerateMessage + 4					-- 'NT_SNMP_ALERTNOTIF'
		IF EXISTS (SELECT * FROM NTnotification WHERE NTnotificationId = @notifId AND revision > 0 AND actionEnable <> 0)
SET @OKtoGenerateMessage = @OKtoGenerateMessage + 16					-- 'NT_RUNCMD_ALERTNOTIF'
		IF EXISTS (SELECT * FROM NTnotification WHERE NTnotificationId = @notifId AND revision > 0 AND appLogEnable <> 0)
SET @OKtoGenerateMessage = @OKtoGenerateMessage + 8					-- 'NT_APPLOG_ALERTNOTIF'
			IF EXISTS (SELECT * FROM NTnotification WHERE NTnotificationId = @notifId AND revision > 0 AND romsEnable <> 0)
SET @OKtoGenerateMessage = @OKtoGenerateMessage + 2048					-- 'NT_ROMS_ALERTNOTIF'
IF EXISTS (SELECT * FROM NTnotificationRule WHERE Id = @notifId AND revision > 0 AND ((notifType & 8192) <> 0))
SET @OKtoGenerateMessage = @OKtoGenerateMessage + 8192					-- 'NT_ROMS_ALERTNOTIF'
IF EXISTS (SELECT * FROM NTnotificationRule WHERE Id = @notifId AND revision > 0 AND ((notifType & 65536) <> 0))
SET @OKtoGenerateMessage = @OKtoGenerateMessage + 65536				-- 'NT_WorkFlowNotif'
IF EXISTS (SELECT * FROM NTnotificationRule WHERE Id = @notifId AND revision > 0 AND ((notifType & 32768) <> 0))
SET @OKtoGenerateMessage = @OKtoGenerateMessage + 32768
		IF @doAlertIndexing = 1
		BEGIN
IF EXISTS (SELECT * FROM NTnotificationRule WHERE Id = @notifId AND revision > 0 AND ((notifType & 131072) <> 0))
SET @OKtoGenerateMessage = @OKtoGenerateMessage + 131072
		END
		IF (@notifId = @schedID)
SET @OKtoGenerateMessage = @OKtoGenerateMessage + 64				-- 'NT_SCHEDULER_ALERTNOTIF'
		IF EXISTS (SELECT * FROM NTnotification WHERE NTnotificationId = @notifId  AND revision > 0 AND saveAlertEnable <> 0)
SET @OKtoGenerateMessage = @OKtoGenerateMessage + 512					-- 'NT_SAVE_ALERTNOTIF'
		IF EXISTS (SELECT * FROM NTnotification WHERE NTnotificationId = @notifId  AND revision > 0 AND rssFeedEnable <> 0)
SET @OKtoGenerateMessage = @OKtoGenerateMessage + 1024					-- 'NT_RSS_ALERTNOTIF'
		-- Using variable @actualThresholdValue check and restrict notification Types depending on whether its Text or Html message
		-- @actualThresholdValue =0 means this is for both text and html messages.
		-- @actualThresholdValue = 1 means this is only for Text notification types like Event Viewer
		-- @actualThresholdValue = 2 means this is only for Html notification types
		if (@actualThresholdValue = 1)
		begin
			-- Remove all notification types which are html based.
			select  @OKtoGenerateMessage = (@OKtoGenerateMessage & ~messageType)
			from NTMessageFormat
			where  messageFormatType=1
			and NTNotificationId=@notifId
			AND escalationLevel = @escLevel
		end
		if (@actualThresholdValue = 2)
		begin
			-- Remove all notification types which are text based.
			select  @OKtoGenerateMessage = (@OKtoGenerateMessage & ~messageType)
			from NTMessageFormat
			where  messageFormatType=0
			and NTNotificationId=@notifId
			AND escalationLevel = @escLevel
		end
	END
	if (@OKtoAddToHistory <> 0)
	BEGIN
		INSERT NTmessageHistory (NTnotificationID, triggerTime, escalationLevel, notifState,
		                             actualThresholdValue, actualThresholdTime, routeFlag, messageText, entities, notificationsToBeSent, sentStatus, attachStatus, attachProcStartTime, attachmentPath, attachmentName )
		SELECT                   NTnotificationID, triggerTime, @escLevel, notifState,
		                             0, actualThresholdTime, @OKtoGenerateMessage, messageText, entities, @OKtoGenerateMessage, 0, @attachStatus ,0, N'', N''
		FROM NTspoolQueue
		WHERE NTnotificationId = @notifId AND triggerTime = @timeStamp
		UPDATE NTMessages set NTmessageState = @notificationState
		WHERE NTnotificationId = @notifId AND escalationLevel = @escLevel
	END
	-- Now in case, content is changed, we want to update lastSetMessageTime only when no message has been sent so far.
IF ((@notificationState  & 2) <> 0)
	BEGIN
		-- In case repeated notification has been configured for this alert and a detected alert occurs first time (with no existing detected alerts for NTRule), then immediately repeated alert
		-- also gets sent.
		IF ((@OKtoGenerateMessage <> 0) AND Exists(
				Select * from NTMessages
				where	(lastSetMessageTime is NULL Or
				@timestamp >= DATEADD(second, (@persistTimeSeconds*3)/2, lastSetMessageTime))
				AND NTnotificationId = @notifId AND escalationLevel = @escLevel
				)
			)
		BEGIN
			UPDATE NTMessages
			SET 	lastSetMessageTime = @timeStamp
			WHERE NTnotificationId = @notifId AND escalationLevel = @escLevel
		END
	END
IF (@notificationState = 1) 			--'NT_NOTIF_STATE_DETECTED'
	BEGIN
		-- When last message time is to be set, we need to check
		-- First we check whether the next iteration has been started from AlertDetector layer to the spoolqueue for the
		-- same notification rule
		set @nextIterationTimeStamp = (select min(triggerTime) from NTSpoolQueue
			where NTNotificationId = @notifId and triggerTime>@timeStamp
			and notifState = 4 and escalationlevel=0)
		-- We want to update the NTMessages only when this is the last detected entry in the current iteration (or before the start of the next iteration)
		IF (@OKtoGenerateMessage <> 0) AND NOT EXISTS(select * from NTSpoolQueue where NTnotificationID= @notifId AND status = 0
AND escalationLevel = @escLevel AND  notifState = 1
			and (@nextIterationTimeStamp is null OR triggerTime<@nextIterationTimeStamp ))
		BEGIN
			-- MR: 101504
			-- Update lastsetMessageTime only when there are no other entries to be processed for the notificationId
			-- Otherwise for the  entries with same notificationID
			-- the the condition presentTime > lastSetMessageTime + repeatTimeInterval will not be met
			-- So we end up not sending the message.
			UPDATE NTMessages
			SET 	lastSetMessageTime = @timeStamp
			WHERE NTnotificationId = @notifId AND escalationLevel = @escLevel
		END
		IF (@firstDetectTime is NULL)
		BEGIN
			UPDATE NTmessages
			SET firstDetectTime = @timeStamp
			WHERE NTnotificationId = @notifId
			   AND escalationLevel = @escLevel
		END
	END
	COMMIT TRAN									-- OK, right now no Error Processing !@#!@#
	if (@okToGenerateMessage <> 0)
		set @retVal = @notifId
GO
---------------------------------------------------------------------------------------------------
-- for Qinetix (not QNet) We only want to send alert based on whether the content has changed
-- .. or the content has cleared, as multiple alerts may be combined in the same "detection"
-- .. if we Allowed the following test for Qinetix, we might get a "false" notification everytime
-- .. we got a NT_NOTIF_STATE_DETECTED after any NT_NOTIF_STATE_CLEARED for this alert
---------------------------------------------------------------------------------------------------
--	IF (@notificationState  = (NT_NOTIF_STATE_CONTENTCHANGED+NT_NOTIF_STATE_DETECTED))			--'NT_NOTIF_STATE_CONTENTCHANGED+NT_NOTIF_STATE_DETECTED'

IF EXISTS (select * from GxQscripts where name = 'br_ntCheckAndAddHistory')
	delete from GxQscripts where name = 'br_ntCheckAndAddHistory'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_ntCheckAndAddHistory')
	delete from GXDBVersions where aliasname = 'br_ntCheckAndAddHistory'
GO

insert into GXDBVersions values(2, 'br_ntCheckAndAddHistory',  '00010022000200010000', 'br_ntCheckAndAddHistory', '00010022000200010000')
GO

