

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/br_ntAlertModify.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/br_ntAlertModify.sp,v $ $Id: br_ntAlertModify.sp,v 1.72.12.21 2020/11/27 17:00:01 kbora Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   br_ntAlertModify   - Fetch the (short) list of currently defined alert
--                      notifications.
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='br_ntAlertModify')
BEGIN
	print '>>> Drop Stored Procedure: br_ntAlertModify <<<'
	drop procedure br_ntAlertModify
END
IF EXISTS (select * from GxQscripts where name='br_ntAlertModify')
	delete from GxQscripts where name = 'br_ntAlertModify'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_ntAlertModify')
	delete from GXDBVersions where aliasname = 'br_ntAlertModify'
GO
print '... Creating Procedure: br_ntAlertModify'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure br_ntAlertModify
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @callerID int,
  @userLocale int,
  @xmlString NTEXT,
  @xmlEntities NTEXT
AS
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  BEGIN
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
SET NOCOUNT ON
declare @iDoc     				int
declare @locale					int					-- THIS WILL BE THE LOCALE FOR THE ALERT, USUALLY THE USER LOCALE
declare @eventCriteriaXml		nvarchar(max)
declare @customQueryDetailsXml	xml
declare @originalLocale			int					-- For update, preserve existing Locale if new one isn't provided!
declare @alertName 				nvarchar(255)
declare @alertCategoryId		int
declare @alertCategoryName		varchar(128)
declare @hasEscalation			int
declare @alertTypeID   			integer
declare @alertCategory			integer
declare @alertTypeName			varchar(128)
declare @tokenRuleXml    		nvarchar(max)
declare @minJobCountForJobAnomaly INT
declare @description			nvarchar(1024)
declare @selrunarguments		nvarchar(1024)
declare @notifMsg				nvarchar(MAX)
declare @selrunEsclationId		integer
declare @selCriteriaId			integer
declare @availCriteriaid		integer
declare @esclationLevel			integer
declare @ruleid					integer
declare @selCriId				integer
declare @selCricriteriaId		integer
declare @selCriEsclationId		integer
declare @selCriparamIndex				integer
declare @selCritype			integer
declare @selCrivalue		integer
declare @selCriunit		integer
declare @notificationId			integer             -- PK referenced by everybody!
declare @notifType				integer
declare @currentState			integer
declare @currentEscalatedState	integer
declare @timeStamp				integer
declare @errorCode              integer
declare @errorString            nvarchar(1024)
declare @modifiedFlag			int
DECLARE @runPassword           nvarchar(512)
DECLARE @escRunPassword		   nvarchar(512)
DECLARE @saveAsPassword        varchar(MAX)
DECLARE @escSaveAsPassword	   varchar(MAX)
DECLARE @hasAttachments			integer
DECLARE @hasAttachments2		integer
DECLARE @capabilies			integer
DECLARE @capabiliesWant		integer
DECLARE @ownerId			integer
DECLARE @hasRights			integer
DECLARE @status   			integer
DECLARE @oldStatus			integer
-- for apptype filter
declare @_type_  int
declare @appGroupId  int
declare @applicationId  int
-- for mail sender details
declare @senderEmailId nvarchar(512)
declare @senderDisplayName nvarchar(512)
DECLARE @taskId           integer                 -- SRM CHANGE
DECLARE @sValue             nvarchar(2048)
DECLARE @existsChannel		integer
declare @copyrightString		nvarchar(MAX)
declare @rssFeed				nvarchar(MAX)
declare @tstring				nvarchar(MAX)
declare @tpasstring				nvarchar(MAX)
declare @baseLocation			nvarchar(MAX)
declare @channelName			nvarchar(MAX)
declare @retVal					integer
declare @channelId				integer
declare @count					integer
declare @isHtmlEncoding			integer
declare @messageFormatType		integer
declare @messageType			integer
declare @messageHtml			nvarchar(MAX)
declare @checkForEventParams    integer
DECLARE @xmlInPutReq           XML
DECLARE @isLinuxCs			   INT = ~dbo.IsOSOnCSWindows()
SET @xmlInPutReq=  CONVERT(XML,@xmlString)
-- For CCM
declare @origCCId				integer
DECLARE @alertOrganizationId	integer = 0
DECLARE @workTokenId			INTEGER	= 47 -- WORK_TOKEN_REFRESH_ALERT_CONFIG
DECLARE @alertSeverity INTEGER = 0	-- Having the severity in the ruleState column of NTNotificationRule
DECLARE @escalationSeverity INTEGER = 0	-- Having the severity in the ruleState2 column of NTNotificationRule
SET @timeStamp = dbo.GetUnixTime (GetUTCdate())
set @errorCode = 0				  -- Assume it will work!
set @hasAttachments = 0			-- TODOTODO   ANAND .... THIS NEEDS TO BE SET SOMEWHERE TODOTODOTODO
set @hasAttachments2 = 0		-- TODOTODO   ANAND .... THIS NEEDS TO BE SET SOMEWHERE TODOTODOTODO
DECLARE	@capability int
SET		@capability				= 18				--'EV_MANAGE_ALERTS' (EvCapability.h)
declare @brAlertTrace                 varchar(256)
set @brAlertTrace                             =(select value from gxglobalParam Where name = 'bralertTrace')
set @brAlertTrace               = ISNULL(@brAlertTrace, 0)
if @brAlertTrace <> 0
exec br_ntTrace '.. br_ntAlertModify', 0, 0, 0, 0, @xmlString
exec sp_xml_preparedocument @iDoc OUTPUT, @xmlString
--Basic notication information should be filled correctly.
set @notificationId 		 = (select * from OPENXML(@iDoc, 'CVGui_AlertModifyReq/alertDetail/alert/alert', 0)
				 WITH (id int '@id'))
SET		@alertCategoryId	= ISNULL((Select CategoryID from NTNotificationRule where id = @notificationId), 0)
set @alertName 		 = (select * from OPENXML(@iDoc, 'CVGui_AlertModifyReq/alertDetail/alert/alert', 0)
				 WITH (name nvarchar(255) '@name'))
set @eventCriteriaXml = ISNULL((select * from OPENXML(@iDoc, 'CVGui_AlertModifyReq/alertDetail', 0)
						WITH (eventCriteriaXml nvarchar(max) '@eventCriteriaXML')), '')
set @customQueryDetailsXml = ISNULL((select * from OPENXML(@iDoc, 'CVGui_AlertModifyReq/alertDetail', 0)
						WITH (customQueryDetailsXml nvarchar(max) '@customQueryDetailsXml')), '')
set @modifiedFlag 		 = (select * from OPENXML(@iDoc, 'CVGui_AlertModifyReq', 0)
				 WITH (modifiedFlag int '@modifiedFlag'))
set @alertCategoryId	 = (select * from OPENXML(@iDoc, 'CVGui_AlertModifyReq/alertDetail/alert/alertCategory', 0)
				 WITH (id int '@id'))
set @alertCategoryName	 = (select * from OPENXML(@iDoc, 'CVGui_AlertModifyReq/alertDetail/alert/alertCategory', 0)
				 WITH (name nvarchar(128) '@name'))
set @alertTypeID	 = (select * from OPENXML(@iDoc, 'CVGui_AlertModifyReq/alertDetail/alert/alertType', 0)
				 WITH (id int '@id'))
set @alertTypeName	 = (select * from OPENXML(@iDoc, 'CVGui_AlertModifyReq/alertDetail/alert/alertType', 0)
				 WITH (name nvarchar(128) '@name'))
set @notifType	 = (select * from OPENXML(@iDoc, 'CVGui_AlertModifyReq/alertDetail/alert', 0)
				 WITH (notifType int '@notifType'))
SET @notifType = @notifType | 131072
IF @isLinuxCs = 1
SET @notifType = @notifType & (~8)
set @status	 = (select * from OPENXML(@iDoc, 'CVGui_AlertModifyReq/alertDetail/alert', 0)
				 WITH (status int '@status'))
set @description = (select * from OPENXML(@iDoc, 'CVGui_AlertModifyReq/alertDetail/alert', 0)
				 WITH (description varchar(128) '@description'))
set @origCCId = (select * from OPENXML(@iDoc, 'CVGui_AlertModifyReq/alertDetail/alert', 0)
				 WITH (origCCId int '@origCCId'))
set @tokenRuleXml = ISNULL((select * from OPENXML(@iDoc, 'CVGui_AlertModifyReq/alertDetail', 0)
						WITH (alertTokenRuleGroupXml nvarchar(max) '@alertTokenRuleGroupXml')), '')
set @minJobCountForJobAnomaly = ISNULL((select * from OPENXML(@iDoc, 'CVGui_AlertModifyReq/alertDetail', 0)
								WITH (minJobCountForJobAnomaly nvarchar(max) '@minJobCountForJobAnomaly')),0)
if(@origCCId IS NULL) or (@origCCId = 0)
	select @origCCId = origCCId
	from NTnotificationRule
	where id = @notificationId
SET @taskId = ISNULL((select taskId from OPENXML(@iDoc, 'CVGui_AlertModifyReq/alertDetail/criteria', 0)
                                                      WITH (taskId int '@taskId', criteriaId int)
                                                      Where criteriaId = 200), 0)    --NT_SRM_CRITERIA_TRIGGER_REPORT
SET @sValue   = ISNULL((select value from OPENXML(@iDoc, 'CVGui_AlertModifyReq/alertDetail/criteria', 0)                      -- SRM
                                                      WITH (value nvarchar(2048) '@value', criteriaId nvarchar(2048))
                                                      Where criteriaId = 200), 0)         --NT_SRM_CRITERIA_TRIGGER_REPORT
if (@description IS NULL)
	set @description = ''
set @hasAttachments = (SELECT hasAttachments from NTnotificationRule WHERE  id = @notificationId)
set @hasAttachments2 = (SELECT hasAttachments2 from NTnotificationRule WHERE  id = @notificationId)
set @currentState			= (SELECT NTmessageState FROM NTmessages WHERE NTnotificationID = @notificationId AND escalationLevel = 1)
set @currentEscalatedState	= (SELECT NTmessageState FROM NTmessages WHERE NTnotificationID = @notificationId AND escalationLevel = 2)
set @ownerId = (SELECT notifOwner from NTnotificationRule WHERE  id = @notificationId)
set @hasRights = 0
set @oldStatus = (SELECT status from NTnotificationRule WHERE  id = @notificationId)
set @originalLocale	 =  ISNULL((SELECT locale FROM NTnotificationRule
                                   WHERE id = @notificationId AND categoryId = @alertCategoryId
										AND alertTypeId = @alertTypeID AND revision > 0), @userLocale)
set @locale          =  ISNULL((select * from OPENXML(@iDoc, 'CVGui_AlertModifyReq/alertDetail/locale', 0)
						WITH (localeID int '@localeID')), @originalLocale)
set	@checkForEventParams = (select * from OPENXML(@iDoc, 'CVGui_AlertModifyReq/alertDetail', 0)
				 WITH (checkForEventParams varchar(40) '@checkForEventParams'))
set @senderEmailId = (select * from OPENXML(@iDoc, 'CVGui_AlertModifyReq/alertDetail', 0)
							 WITH (senderEmailId nvarchar(512) '@senderEmailId'))
set @senderDisplayName = (select * from OPENXML(@iDoc, 'CVGui_AlertModifyReq/alertDetail', 0)
							 WITH (senderDisplayName nvarchar(512) '@senderDisplayName'))
DECLARE @tranCount integer = @@TRANCOUNT
DECLARE @isTranStarted INT = 0
IF (@trancount = 0)
BEGIN
      BEGIN TRAN
      SET @isTranStarted = 1
END
------------------------------
-- MAKE SURE ALERT EXISTS:	--
------------------------------
IF NOT EXISTS (SELECT 1 FROM NTnotificationRule
				WHERE id = @notificationId AND categoryId = @alertCategoryId AND alertTypeId = @alertTypeID AND revision > 0)
BEGIN
set @errorCode = CAST(0x0B0003 AS INT)
set @errorString = dbo.fn_EvFormatEventMsgText(0,@locale, (143 | (CAST(POWER(2, 24) AS BIGINT) * 74)), 0,2)
	GOTO MODIFY_EXIT
END
-- Check whether the alert type is disabled. If so, dont allow modification.
If exists(select 1 from NTalertType where id=@alertTypeID and (actionsAllowed&8)>0)
begin
SET @errorCode = (1244 | (CAST(POWER(2, 24) AS BIGINT) * 74))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (1244 | (CAST(POWER(2, 24) AS BIGINT) * 74)) and localeid = @locale)
	-- if string is not there for that locale, take it from english locale
	if @errorString is null or len(@errorString)=0
	begin
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (1244 | (CAST(POWER(2, 24) AS BIGINT) * 74)) and localeid = 0)
	end
	GOTO MODIFY_EXIT
end
------------------------------------------------------------------------------------
--  CHECK FOR THE RIGHTS! --
------------------------------------------------------------------------------------
--Security check to modify alert - First check if user has 'Edit Alert' permission on the alert
--Otherwise check for 'Add/Remove Associations' and 'Add/Remove Recipients' permissions
DECLARE @userHasRightToEdit INT = 0
DECLARE @userHasRightToEditAssociations INT = 0
DECLARE @userHasRightToEditRecipients INT = 0
EXEC sec_checkPermissionOnEntity @callerID, 152, @userHasRightToEdit OUTPUT, 64, @notificationId
EXEC sec_checkPermissionOnEntity @callerID, 154, @userHasRightToEditAssociations OUTPUT, 64, @notificationId
EXEC sec_checkPermissionOnEntity @callerID, 155, @userHasRightToEditRecipients OUTPUT, 64, @notificationId
--Admin alert can only be modified by users with admin capabilities
IF @alertTypeID = 75
	BEGIN
		DECLARE @isAdmin INT = 0
EXEC DBO.sec_checkPermissionOnEntity @callerID , 1, @isAdmin OUTPUT, 1, 2
		IF @isAdmin = 0
		BEGIN
SET @errorCode = (1878 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (1878 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale)
			GOTO MODIFY_EXIT
		END
	END
--Modify Entity Associations if user has permission to edit Associations
IF (@userHasRightToEditAssociations = 1)
BEGIN
IF ((@modifiedFlag & CAST(0x0001 AS INT)) = CAST(0x0001 AS INT))-- 'NT_ENTITIES_MODBIT'
	BEGIN
		--Get the old xmlEntities
		DECLARE @oldXmlEntities XML = N''
		SELECT @oldXmlEntities = xmlEntityList
			FROM NTnotificationRule
		WHERE id = @notificationId AND revision > 0
		--Check if user has permission on entities to associate the new entities and remove old entities
IF @alertCategoryId <> 9 --No need to check pemissions on entitylist for custom alerts
		BEGIN
			DECLARE @isAllowed INT = 0
			DECLARE @entitiesNotAllowed NVARCHAR(MAX) = N''
			DECLARE @permissionId Int = 0
			set @permissionId = dbo.NTGetPermissionForEntityAssociation(@alertTypeID)
			EXEC sec_checkPermissionOnEntityList @callerID, @locale, @xmlEntities, @oldXmlEntities, @permissionId , @isAllowed OUTPUT, @entitiesNotAllowed OUTPUT
			IF @isAllowed = 0
			BEGIN
SET @errorCode = (1197 | (CAST(POWER(2, 24) AS BIGINT) * 74))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (1197 | (CAST(POWER(2, 24) AS BIGINT) * 74)) and localeid = @locale)
				SET @errorString = REPLACE(@errorString, '^1%s', ISNULL((SELECT login FROM UMUsers  WITH(NOLOCK) WHERE id = @callerID),''))
				SET @errorString = REPLACE(@errorString, '^2%s', @entitiesNotAllowed)
				GOTO MODIFY_EXIT
			END
		END
		--If user has permission update the entities list
		Update NTnotificationRule
			Set xmlEntityList = @xmlEntities
		WHERE  id = @notificationId AND revision > 0
	--Check Error
		set @errorCode = @@error
		IF(@errorCode <> 0)
			GOTO MODIFY_EXIT
	--Error Check
	END
END
--Modify Recipients if user has permission to edit Recipients
IF (@userHasRightToEditRecipients = 1)
BEGIN
IF ((@modifiedFlag & CAST(0x0002 AS INT)) = CAST(0x0002 AS INT))-- 'NT_USERS_MODBIT'
	BEGIN
		--Check if recipients are visible to user
		DECLARE @usersList TABLE
		(
			userId INT,
			escalationLevel	INT,
			recipientType INT
		)
		IF OBJECT_ID('tempdb.dbo.#usersForUser') IS NOT NULL
			DROP TABLE #usersForUser
		CREATE TABLE #usersForUser (userId INT)
		--Get the old users list and new users list difference
		INSERT INTO @usersList (userId, escalationLevel, recipientType)
			((SELECT id1, id2, 0
				FROM OPENXML(@iDoc, 'CVGui_AlertModifyReq/alertDetail/userList', 0)
				WITH (id1 int, id2 int)
				UNION
				SELECT id1, id2, 1
				FROM OPENXML(@iDoc, 'CVGui_AlertModifyReq/alertDetail/userListCc', 0)
				WITH (id1 int, id2 int)
				UNION
				SELECT id1, id2, 2
				FROM OPENXML(@iDoc, 'CVGui_AlertModifyReq/alertDetail/userListBcc', 0)
				WITH (id1 int, id2 int)
				)
			EXCEPT
			SELECT userId, escalationLevel, recipientType
				FROM NTnotificationUsers
			WHERE NTnotificationID = @notificationId)
			UNION
			(SELECT userId, escalationLevel, recipientType
				FROM NTnotificationUsers
			WHERE NTnotificationID = @notificationId
			EXCEPT
			(SELECT id1, id2, 0
				FROM OPENXML(@iDoc, 'CVGui_AlertModifyReq/alertDetail/userList', 0)
				WITH (id1 int, id2 int)
				UNION
				SELECT id1, id2, 1
				FROM OPENXML(@iDoc, 'CVGui_AlertModifyReq/alertDetail/userListCc', 0)
				WITH (id1 int, id2 int)
				UNION
				SELECT id1, id2, 2
				FROM OPENXML(@iDoc, 'CVGui_AlertModifyReq/alertDetail/userListBcc', 0)
				WITH (id1 int, id2 int))
				)
		--Get the list of users visible to the user
		EXEC sec_getUsersForThisUser '#usersForUser', @callerID
		--Check if users are visible to the user to associate as new recipients and remove old recipients
		DECLARE @usersNotAllowed NVARCHAR(MAX) = N''
		SET @usersNotAllowed = STUFF((SELECT ', ' + users.name
												FROM (SELECT tbl1.userId FROM @usersList tbl1 LEFT OUTER JOIN #usersForUser tbl2
															ON tbl1.userId = tbl2.userId
														WHERE tbl2.userId IS NULL) as tbl
												INNER JOIN UMUsers users WITH(NOLOCK)
													ON tbl.userId = users.id
WHERE users.flags & 0x004 = 0
												FOR XML PATH('')),1,2,'')
		IF @usersNotAllowed is not null
		BEGIN
SET @errorCode = (1195 | (CAST(POWER(2, 24) AS BIGINT) * 74))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (1195 | (CAST(POWER(2, 24) AS BIGINT) * 74)) and localeid = @locale)
			SET @errorString = REPLACE(@errorString, '^1%s', ISNULL((SELECT login FROM UMUsers WITH(NOLOCK) WHERE id = @callerID),''))
			SET @errorString = REPLACE(@errorString, '^2%s', @usersNotAllowed)
			GOTO MODIFY_EXIT
		END
		DROP TABLE #usersForUser
		DECLARE @userGroupsList TABLE
		(
			userGroupId INT,
			escalationLevel	INT,
			recipientType INT
		)
		IF OBJECT_ID('tempdb.dbo.#userGroupsForUser') IS NOT NULL
			DROP TABLE #userGroupsForUser
		CREATE TABLE #userGroupsForUser (userGroupId INT)
		--Get the difference of old local and external user groups list and new local and external user groups list
		INSERT INTO @userGroupsList (userGroupId, escalationLevel, recipientType)
			((SELECT id1, id2, 0
				FROM OPENXML(@iDoc, 'CVGui_AlertModifyReq/alertDetail/userGroupList', 0)
				WITH (id1 int, id2 int)
				UNION
				SELECT id1, id2, 1
				FROM OPENXML(@iDoc, 'CVGui_AlertModifyReq/alertDetail/userGroupListCc', 0)
				WITH (id1 int, id2 int)
				UNION
				SELECT id1, id2, 2
				FROM OPENXML(@iDoc, 'CVGui_AlertModifyReq/alertDetail/userGroupListBcc', 0)
				WITH (id1 int, id2 int)
				)
			EXCEPT
			SELECT groupId, escalationLevel, recipientType
				FROM NTnotificationGroups
			WHERE NTnotificationID = @notificationId)
			UNION
			(SELECT groupId, escalationLevel, recipientType
				FROM NTnotificationGroups
			WHERE NTnotificationID = @notificationId
			EXCEPT
			(SELECT id1, id2, 0
				FROM OPENXML(@iDoc, 'CVGui_AlertModifyReq/alertDetail/userGroupList', 0)
				WITH (id1 int, id2 int)
				UNION
				SELECT id1, id2, 1
				FROM OPENXML(@iDoc, 'CVGui_AlertModifyReq/alertDetail/userGroupListCc', 0)
				WITH (id1 int, id2 int)
				UNION
				SELECT id1, id2, 2
				FROM OPENXML(@iDoc, 'CVGui_AlertModifyReq/alertDetail/userGroupListBcc', 0)
				WITH (id1 int, id2 int)
				))
			UNION
			((SELECT id1, id2, 0
				FROM OPENXML(@iDoc, 'CVGui_AlertModifyReq/alertDetail/externalGroupList', 0)
				WITH (id1 int, id2 int)
				UNION
				SELECT id1, id2, 1
				FROM OPENXML(@iDoc, 'CVGui_AlertModifyReq/alertDetail/externalGroupListCc', 0)
				WITH (id1 int, id2 int)
				UNION
				SELECT id1, id2, 2
				FROM OPENXML(@iDoc, 'CVGui_AlertModifyReq/alertDetail/externalGroupListBcc', 0)
				WITH (id1 int, id2 int)
				)
			EXCEPT
			SELECT externalGroupId, escalationLevel, recipientType
				FROM NTnotificationExternalGroups
			WHERE NTnotificationID = @notificationId)
			UNION
			(SELECT externalGroupId, escalationLevel, recipientType
				FROM NTnotificationExternalGroups
			WHERE NTnotificationID = @notificationId
			EXCEPT
			(SELECT id1, id2, 0
				FROM OPENXML(@iDoc, 'CVGui_AlertModifyReq/alertDetail/externalGroupList', 0)
				WITH (id1 int, id2 int)
				UNION
				SELECT id1, id2, 1
				FROM OPENXML(@iDoc, 'CVGui_AlertModifyReq/alertDetail/externalGroupListCc', 0)
				WITH (id1 int, id2 int)
				UNION
				SELECT id1, id2, 2
				FROM OPENXML(@iDoc, 'CVGui_AlertModifyReq/alertDetail/externalGroupListBcc', 0)
				WITH (id1 int, id2 int)
				))
		--Get the list of local and external user groups visible to the user
		EXEC sec_getUserGroupsForThisUser '#userGroupsForUser', @callerID
		--Check if user groups are visible to the user to associate as new recipients and remove old recipients
		DECLARE @groupsNotAllowed NVARCHAR(MAX) = N''
		SET @groupsNotAllowed = STUFF((SELECT ', ' + groups.name
												FROM (SELECT tbl1.userGroupId FROM @userGroupsList tbl1 LEFT OUTER JOIN #userGroupsForUser tbl2
															ON tbl1.userGroupId = tbl2.userGroupId
														WHERE tbl2.userGroupId IS NULL) as tbl
												INNER JOIN UMGroups groups WITH(NOLOCK)
													ON tbl.userGroupId = groups.id
WHERE groups.groupFlags & 0x0010 = 0
												FOR XML PATH('')),1,2,'')
		IF @groupsNotAllowed is not null
		BEGIN
SET @errorCode = (1196 | (CAST(POWER(2, 24) AS BIGINT) * 74))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (1196 | (CAST(POWER(2, 24) AS BIGINT) * 74)) and localeid = @locale)
			SET @errorString = REPLACE(@errorString, '^1%s', ISNULL((SELECT login FROM UMUsers WITH(NOLOCK) WHERE id = @callerID),''))
			SET @errorString = REPLACE(@errorString, '^2%s', @groupsNotAllowed)
			GOTO MODIFY_EXIT
		END
		DROP TABLE #userGroupsForUser
		--If user is allowed modify the users ans user groups
		DELETE NTnotificationUsers where NTnotificationID = @notificationId
		DELETE NTnotificationGroups where NTnotificationID = @notificationId
		DELETE NTnotificationExternalGroups where NTnotificationID = @notificationId
		DELETE NTnotificationNonGalaxyUsers where NTnotificationID = @notificationId
	--Check Error
		set @errorCode = @@error
		IF(@errorCode <> 0)
			GOTO MODIFY_EXIT
	--Error Check
	-- Inserting the user details
		INSERT INTO  NTnotificationUsers (NTnotificationID, userId, escalationLevel,recipientType)
			SELECT @notificationID, id1, id2, 0
			  FROM OPENXML(@iDoc, 'CVGui_AlertModifyReq/alertDetail/userList', 0)
				WITH (id1 int, id2  int)
		INSERT INTO  NTnotificationUsers (NTnotificationID, userId, escalationLevel,recipientType)
			SELECT @notificationID, id1, id2, 1
			  FROM OPENXML(@iDoc, 'CVGui_AlertModifyReq/alertDetail/userListCc', 0)
				WITH (id1 int, id2  int)
		INSERT INTO  NTnotificationUsers (NTnotificationID, userId, escalationLevel,recipientType)
			SELECT @notificationID, id1, id2, 2
			  FROM OPENXML(@iDoc, 'CVGui_AlertModifyReq/alertDetail/userListBcc', 0)
				WITH (id1 int, id2  int)
	--Check Error
		set @errorCode = @@error
		IF(@errorCode <> 0)
			GOTO MODIFY_EXIT
	--Error Check
	-- Inserting the user Group details
		INSERT INTO  NTnotificationGroups (NTnotificationID, groupId, escalationLevel,recipientType)
			SELECT  @notificationID, id1, id2, 0
			  FROM OPENXML(@iDoc, 'CVGui_AlertModifyReq/alertDetail/userGroupList', 0)
				WITH (id1 int,  id2 int)
		INSERT INTO  NTnotificationGroups (NTnotificationID, groupId, escalationLevel,recipientType)
			SELECT  @notificationID, id1, id2, 1
			  FROM OPENXML(@iDoc, 'CVGui_AlertModifyReq/alertDetail/userGroupListCc', 0)
				WITH (id1 int,  id2 int)
		INSERT INTO  NTnotificationGroups (NTnotificationID, groupId, escalationLevel,recipientType)
			SELECT  @notificationID, id1, id2, 2
			  FROM OPENXML(@iDoc, 'CVGui_AlertModifyReq/alertDetail/userGroupListBcc', 0)
				WITH (id1 int,  id2 int)
	--Check Error
		set @errorCode = @@error
		IF(@errorCode <> 0)
			GOTO MODIFY_EXIT
	--Error Check
	-- Inserting the external Group details
		INSERT INTO  NTnotificationExternalGroups (NTnotificationID, externalGroupId, escalationLevel, recipientType)
			SELECT  @notificationID, id1, id2, 0
			  FROM OPENXML(@iDoc, 'CVGui_AlertModifyReq/alertDetail/externalGroupList', 0)
				WITH (id1 int,  id2 int)
		INSERT INTO  NTnotificationExternalGroups (NTnotificationID, externalGroupId, escalationLevel, recipientType)
			SELECT  @notificationID, id1, id2, 1
			  FROM OPENXML(@iDoc, 'CVGui_AlertModifyReq/alertDetail/externalGroupListCc', 0)
				WITH (id1 int,  id2 int)
		INSERT INTO  NTnotificationExternalGroups (NTnotificationID, externalGroupId, escalationLevel, recipientType)
			SELECT  @notificationID, id1, id2, 2
			  FROM OPENXML(@iDoc, 'CVGui_AlertModifyReq/alertDetail/externalGroupListBcc', 0)
				WITH (id1 int,  id2 int)
	--Check Error
		set @errorCode = @@error
		IF(@errorCode <> 0)
			GOTO MODIFY_EXIT
	--Error Check
	-- Inserting the non-galaxy user email details
		INSERT INTO  NTnotificationNonGalaxyUsers (NTnotificationID, nonGalaxyUserName, escalationLevel, recipientType)
			SELECT  @notificationID, name, id2, 0
			  FROM OPENXML(@iDoc, 'CVGui_AlertModifyReq/alertDetail/nonGalaxyUserList', 0)
				WITH (name nvarchar(255),  id2 int)
		INSERT INTO  NTnotificationNonGalaxyUsers (NTnotificationID, nonGalaxyUserName, escalationLevel, recipientType)
		SELECT distinct @notificationID, name, id2, 1
		  FROM OPENXML(@iDoc, 'CVGui_AlertModifyReq/alertDetail/nonGalaxyUserListCc', 0)
			WITH (name nvarchar(255),  id2 int)
		INSERT INTO  NTnotificationNonGalaxyUsers (NTnotificationID, nonGalaxyUserName, escalationLevel, recipientType)
		SELECT distinct @notificationID, name, id2, 2
		  FROM OPENXML(@iDoc, 'CVGui_AlertModifyReq/alertDetail/nonGalaxyUserListBcc', 0)
			WITH (name nvarchar(255),  id2 int)
	--Check Error
		set @errorCode = @@error
		IF(@errorCode <> 0)
			GOTO MODIFY_EXIT
	--Error Check
	END
END
--Modify Alert if user has permission to edit Alert
IF (@userHasRightToEdit = 1)
BEGIN
---------Check if there is any alert already present with new alert name ---------------------
-- If yes throw error and exit
-- Each organization has same set of alerts and hence this will throw error. So we consider organization of alert also.
select @alertOrganizationId = attrval from NTNotificationProp
where componentNameid=@notificationId and attrname='OrganizationId'
and IsNumeric(attrval)>0
IF EXISTS (SELECT NTNotificationRule.id FROM  NTNotificationRule
	left join NTNotificationProp on NTNotificationRule.id=NTNotificationProp.componentNameId
and NTNotificationProp.attrname='OrganizationId' and IsNumeric(NTNotificationProp.attrval)>0
	WHERE notificationName = @alertName AND NTNotificationRule.id <> @notificationId and NTNotificationRule.revision>0
	and @alertOrganizationId = IsNull(NTNotificationProp.attrval,0)
	)
BEGIN
SET  @errorCode = 0x0B0004
SET @errorString = dbo.fn_EvFormatEventMsgText(0,@locale, (159 | (CAST(POWER(2, 24) AS BIGINT) * 74)), 0,2) + N' : ' + @alertName
   goto MODIFY_EXIT
END
--------------------------------------------------------------------------------------------
IF((@notifType & 65536)=65536)
	BEGIN
	    DECLARE @workFlowId INTEGER
		DECLARE @oldWorkFlowId INTEGER =0
		DECLARE @entity nvarchar(max)
		DECLARE @xmlEntity XML
		SET @workFlowId=ISNULL((SELECT workflowId FROM OPENXML(@iDoc,'CVGui_AlertModifyReq/alertDetail/notifMsgs',0)
						WITH (workflowId int 'entity/@workflowId' , notifType int,esclationLevel int)
WHERE notifType=65536 and esclationLevel=1),0)
		IF(@workFlowId<>0)
		BEGIN
SET  @entity =(select formatString from NTmessageFormat where NTnotificationID=@notificationId and messageType=65536 and escalationLevel=1)
			SET @xmlEntity = (SELECT CONVERT(XML,@entity))
			SET @oldWorkFlowId=(SELECT ISNULL((SELECT  ref.value('@workflowId','INT')
			FROM @xmlEntity.nodes ('entity')R(ref)),0))
			IF @workFlowId<>@oldWorkFlowId
			BEGIN
exec br_NTPermCheck @callerID,@locale,33, 14033,@workFlowId,@errorCode OUTPUT,@errorString OUTPUT
				IF @errorCode<>0
					goto MODIFY_EXIT
				IF @callerID <> @ownerId
				BEGIN
exec br_NTPermCheck @ownerId,@locale,33, 14033,@workFlowId,@errorCode OUTPUT,@errorString OUTPUT
				IF @errorCode<>0
					goto MODIFY_EXIT
				END
			END
		END
		SET @workFlowId=ISNULL((select workflowId from OPENXML(@iDoc,'CVGui_AlertModifyReq/alertDetail/notifMsgs',0)
						WITH (workflowId int 'entity/@workflowId' , notifType int,esclationLevel int)
WHERE notifType=65536 and esclationLevel=2),0)
		IF(@workFlowId<>0)
		BEGIN
SET @entity =(select formatString from NTmessageFormat where NTnotificationID=@notificationId and messageType=65536 and escalationLevel=2)
			SET @xmlEntity = (SELECT CONVERT(XML,@entity))
			SET @oldWorkFlowId=(SELECT ISNULL((SELECT  ref.value('@workflowId','INT')
			FROM @xmlEntity.nodes ('entity')R(ref)),0))
			IF @workFlowId<>@oldWorkFlowId
			BEGIN
exec br_NTPermCheck @callerID,@locale,33, 14033,@workFlowId,@errorCode OUTPUT,@errorString OUTPUT
				IF @errorCode<>0
					goto MODIFY_EXIT
				IF @callerID <> @ownerId
				BEGIN
exec br_NTPermCheck @ownerId,@locale,33, 14033,@workFlowId,@errorCode OUTPUT,@errorString OUTPUT
				IF @errorCode<>0
					goto MODIFY_EXIT
				END
			END
		END
	END
SET  @alertSeverity = ISNULL((SELECT alertSeverity FROM OPENXML(@iDoc, 'CVGui_AlertModifyReq/alertDetail',0)
							WITH (alertSeverity INTEGER '@alertSeverity')),0)
SET  @escalationSeverity = ISNULL((SELECT escalationSeverity FROM OPENXML(@iDoc, 'CVGui_AlertModifyReq/alertDetail',0)
							WITH (escalationSeverity INTEGER '@escalationSeverity')),0)
------------------------------------------------------------------------------------
--  GATHERED ENOUGH INFORMATION, TIME TO START INSERTING SOME DATA TO THE TABLES! --
------------------------------------------------------------------------------------
--Update the notification rule
Update NTnotificationRule
	Set notificationName = @alertName,
		description		 = 	@description,
		notifType		 = @notifType,
		status			 = @status,
		lastModified	 = @timeStamp,
		locale			 = @locale,
		origCCId		 = @origCCId,
		ruleState		 = @alertSeverity,
		ruleState2		 = @escalationSeverity
WHERE  id = @notificationId AND revision > 0
--Check Error
	set @errorCode = @@error
	IF(@errorCode <> 0)
		GOTO MODIFY_EXIT
--Error Check
-----------------------
-- SRM DATA          --			 DON'T HAVE A "MOD" BIT FOR THIS!
-----------------------
--	IF @taskId <> 0
--	BEGIN
--		IF EXISTS (Select * from RSReportThresholds WHERE ntNotificationRuleId = @notificationId)
--				UPDATE RSReportThresholds
--					SET taskId = @taskId, filter = @svalue
--					WHERE ntNotificationRuleId = @notificationId
--		ELSE
--			INSERT  RSReportThresholds VALUES (@notificationId, 0, @sValue, @taskId)
--    END
-------------------------------------
-- Apptype and AppGroup Filter list--
-------------------------------------
BEGIN
DELETE NTnotificationProp where componentNameId = @notificationId and attrName in ('App Type Filter','App Group Filter')
set @errorCode = @@error
IF(@errorCode <> 0)
      GOTO MODIFY_EXIT
Insert into NTNotificationProp(componentNameId,attrName,attrType,attrVal,created,modified)
select @notificationId,'App Type Filter','7',applicationId,dbo.GetUnixTime(GETUTCDATE()),0
        FROM OPENXML(@iDoc, 'CVGui_AlertModifyReq/alertDetail/appTypeFilters/appTypeFilter', 0)
         with(_type_ int,applicationId int)
WHERE _type_=79
Insert into NTNotificationProp(componentNameId,attrName,attrType,attrVal,created,modified)
select @notificationId,'App Group Filter','7',appGroupId,dbo.GetUnixTime(GETUTCDATE()),0
         FROM OPENXML(@iDoc, 'CVGui_AlertModifyReq/alertDetail/appTypeFilters/appTypeFilter', 0)
           with(_type_ int,appGroupId int)
WHERE _type_=78
--Check Error
      set @errorCode = @@error
      IF(@errorCode <> 0)
              GOTO MODIFY_EXIT
END
-------------------------------------
	-- Mail Alert Sender --
-------------------------------------
DELETE NTnotificationProp where componentNameId = @notificationId and attrName in ('Sender MailId', 'Sender Display Name')
set @errorCode = @@error
IF(@errorCode <> 0)
      GOTO MODIFY_EXIT
IF @senderEmailId is not null AND @senderEmailId <> N''
	Insert into NTNotificationProp(componentNameId,attrName,attrType,attrVal,created,modified)
values ( @notificationId,'Sender MailId','1',@senderEmailId,dbo.GetUnixTime(GETUTCDATE()),0)
IF @senderDisplayName is not null AND @senderDisplayName <> N''
	Insert into NTNotificationProp(componentNameId,attrName,attrType,attrVal,created,modified)
values ( @notificationId,'Sender Display Name','1',@senderDisplayName,dbo.GetUnixTime(GETUTCDATE()),0)
--Check Error
      set @errorCode = @@error
      IF(@errorCode <> 0)
              GOTO MODIFY_EXIT
--Error Check
IF ((@modifiedFlag & CAST(0x0010 AS INT)) = CAST(0x0010 AS INT))-- 'NT_RUN_COMMAND_MODBIT'
BEGIN
	--------------------------
	-- Run Command --
	--------------------------
	set @runPassword = (SELECT runAsUserPassword from NTnotificationAction where NTnotificationID = @notificationId and escalationLevel = 1)
	set @escRunPassword = (SELECT runAsUserPassword from NTnotificationAction where NTnotificationID = @notificationId and escalationLevel = 2)
	DELETE NTnotificationAction where NTnotificationID = @notificationId
--Check Error
	set @errorCode = @@error
	IF(@errorCode <> 0)
		GOTO MODIFY_EXIT
--Error Check
DELETE NTmessageFormat where NTnotificationID = @notificationId and messageType = 16
--Check Error
	set @errorCode = @@error
	IF(@errorCode <> 0)
		GOTO MODIFY_EXIT
--Error Check
	INSERT INTO  NTnotificationAction (NTnotificationID, escalationLevel, useImpersonation, useNetworkShare,
				runAsUserLogin, runAsUserPassword, runCommand, arguments)
		SELECT  @notificationID,esclationLevel,  impersonateUser , useNetworkShare,  loginName, cvpassword, cmdPath, arguments
			FROM OPENXML(@iDoc, 'CVGui_AlertModifyReq/alertDetail/runCommands', 0)
				WITH (enabled int,  esclationLevel int, impersonateUser int,  loginName nvarchar(128), cvpassword nvarchar(128) ,
				useNetworkShare int, cmdPath nvarchar(1024), arguments nvarchar(1024) )
			WHERE cmdPath <> ''
--Check Error
	set @errorCode = @@error
	IF(@errorCode <> 0)
		GOTO MODIFY_EXIT
--Error Check
	--Password is not modified
IF ((@modifiedFlag & CAST(0x0020 AS INT)) <> CAST(0x0020 AS INT))-- 'NT_RUN_PASSWORD_MODBIT'
		Update NTnotificationAction set runAsUserPassword = @runPassword where NTnotificationID = @notificationId and escalationLevel = 1
IF ((@modifiedFlag & CAST(0x0040 AS INT)) <> CAST(0x0040 AS INT))-- 'NT_ESC_RUN_PASSWORD_MODBIT'
		Update NTnotificationAction set runAsUserPassword = @escRunPassword where NTnotificationID = @notificationId and escalationLevel = 2
--Check Error
	set @errorCode = @@error
	IF(@errorCode <> 0)
		GOTO MODIFY_EXIT
--Error Check
	--Insert the arguments
	DECLARE	GetSelRunCmdCursor CURSOR FOR
	SELECT arguments,escalationLevel FROM NTnotificationAction where  NTnotificationID = @notificationID
	OPEN GetSelRunCmdCursor
	FETCH GetSelRunCmdCursor INTO @selrunarguments, @selrunEsclationId
	WHILE	@@FETCH_STATUS = 0
	BEGIN
		INSERT INTO  NTmessageFormat  ( NTnotificationID,   messageType,     formatString, escalationLevel,
				formattedMessage, subjFieldStart, subjFieldLen, MsgBodyStart, MsgBodyLen,messageFormatType)
VALUES (@notificationID, 16, @selrunarguments, @selrunEsclationId ,
				'', 0, 0, 0, 0,0)
--Check Error
	set @errorCode = @@error
	IF(@errorCode <> 0)
		GOTO MODIFY_EXIT
--Error Check
		FETCH GetSelRunCmdCursor INTO @selrunarguments, @selrunEsclationId
	END
	CLOSE GetSelRunCmdCursor
	DEALLOCATE GetSelRunCmdCursor
END
IF ((@modifiedFlag & CAST(0x0004 AS INT)) = CAST(0x0004 AS INT))-- 'NT_NOTIFMSGS_MODBIT'
BEGIN
	--------------------------
	-- Notification Message --
	--------------------------
set @saveAsPassword = (SELECT password from NTMessageFormat where NTnotificationID = @notificationId and escalationLevel = 1 and messageType = 512)
set @escSaveAsPassword = (SELECT password from NTMessageFormat where NTnotificationID = @notificationId and escalationLevel = 2 and messageType = 512)
DELETE NTmessageFormat where NTnotificationID = @notificationId and messageType <> 16
	INSERT INTO  NTmessageFormat  ( NTnotificationID,   messageType,     formatString, escalationLevel,
				formattedMessage, subjFieldStart, subjFieldLen, MsgBodyStart, MsgBodyLen, mfOptions,messageFormatType,formatStringHtml)
		SELECT @notificationID, notifType, notifMessage, esclationLevel ,
				'', 0, 0, 0, 0, ISNULL(notifOptions, 0),ISNULL(messageFormat,0),notifMessageHtml from OPENXML(@iDoc, 'CVGui_AlertModifyReq/alertDetail/notifMsgs', 0)
			WITH  (notifType int, notifMessage nvarchar(MAX), esclationLevel int, notifOptions int,messageFormat int,notifMessageHtml nvarchar(MAX))
WHERE @isLinuxCs = 0 OR (@isLinuxCs = 1 AND notifType & 8 = 0)
	IF NOT EXISTS (SELECT 1 FROM @xmlInPutReq.nodes('CVGui_AlertModifyReq/alertDetail/notifMsgs') as ref(f)
WHERE f.value('(@notifType)[1]','int')=131072)
	BEGIN
		DECLARE @formateString NVARCHAR(1024)
SET @formateString = (SELECT defaultformatString FROM NTnotificationTemplate WHERE messageType = 131072 AND locale = 0 AND messageFormatType = 0 AND NTalertTypeID = @alertTypeID)
IF EXISTS (SELECT 1 FROM NTmessageFormat WHERE NTnotificationID = @notificationID AND messageType = 131072)
		BEGIN
DELETE FROM NTmessageFormat WHERE NTnotificationID = @notificationID AND messageType = 131072
		END
		IF EXISTS (SELECT 1 FROM NTmessageFormat ntf INNER JOIN NTnotificationRule ntr
				ON ntf.NTnotificationID = ntr.id AND (ntr.notifType & ntf.messageType) <> 0
			 WHERE NTnotificationID = @notificationID AND escalationLevel = 1)
		BEGIN
			INSERT INTO  NTmessageFormat  ( NTnotificationID,   messageType,     formatString, escalationLevel,
						formattedMessage, subjFieldStart, subjFieldLen, MsgBodyStart, MsgBodyLen, mfOptions,messageFormatType,formatStringHtml)
SELECT @notificationID,131072,@formateString,1,'',0,0,0,0,0,'',''
		END
		IF EXISTS (SELECT 1 FROM NTmessageFormat ntf INNER JOIN NTnotificationRule ntr
				ON ntf.NTnotificationID = ntr.id AND (ntr.notifType & ntf.messageType) <> 0
			 WHERE NTnotificationID = @notificationID AND escalationLevel = 2)
		BEGIN
			INSERT INTO  NTmessageFormat  ( NTnotificationID,   messageType,     formatString, escalationLevel,
						formattedMessage, subjFieldStart, subjFieldLen, MsgBodyStart, MsgBodyLen, mfOptions,messageFormatType,formatStringHtml)
SELECT @notificationID,131072,@formateString,2,'',0,0,0,0,0,'',''
		END
	END
--Check Error
	set @errorCode = @@error
	IF(@errorCode <> 0)
		GOTO MODIFY_EXIT
--Error Check
	-- Now for html alerts alone, to fix the token break issues from GUI, temporarily we fix it here. Currently only for email
	-- We basically replace multiple spaces with single space.
	set @messageHtml = IsNull((SELECT top 1 formatStringHtml FROM NTmessageFormat WHERE 	NTnotificationID = @notificationId
and messageType = 1 and escalationLevel = 1),'')
	while (patIndex('%  %',@messageHtml)>0)
	begin
		set @messageHtml = replace(@messageHtml,'  ',' ')
	end
	-- Once replacement is done, update the table again.
	update NTmessageFormat
	set formatStringHtml = @messageHtml
	WHERE 	NTnotificationID = @notificationId
and messageType = 1 and escalationLevel = 1
	CREATE TABLE #NtRssParams ( ntype integer, elevel integer, channelId integer, location nvarchar(MAX), channelloc nvarchar(MAX), userName nvarchar(MAX), password varchar(MAX))
if ((@notifType & 512) = 512)
	BEGIN
		INSERT INTO #NtRssParams (ntype, elevel, channelId, location, channelloc, userName, password)
		SELECT notifType, esclationLevel, 0, alertLocation, NULL, loginName, cvpassword
		FROM OPENXML(@iDoc, 'CVGui_AlertModifyReq/alertDetail/notifMsgs/saveAlertToDisk', 0)
		WITH (notifType int '../@notifType',
			  esclationLevel int '../@esclationLevel',
			  alertLocation nvarchar(MAX),
			  loginName nvarchar(MAX),
			  cvpassword varchar(MAX))
	END
if ((@notifType & 1024) = 1024)
	BEGIN
		INSERT INTO #NtRssParams (ntype, elevel, channelId, location, channelloc, userName, password)
		SELECT notifType, esclationLevel, 0, baseLocation, selectedChannel, NULL, NULL
		FROM OPENXML(@iDoc, 'CVGui_AlertModifyReq/alertDetail/notifMsgs/feeds', 0)
		WITH (notifType int '../@notifType',
			  esclationLevel int '../@esclationLevel',
			  baseLocation nvarchar(MAX),
			  selectedChannel nvarchar(MAX))
	END
if ((@notifType & 512) = 512)
	BEGIN
--		SET @rssFeed = (SELECT * from OPENXML(@iDoc, 'CVGui_AlertModifyReq/alertDetail/notifMsgs/saveAlertToDisk', 0)
--						WITH (alertLocation nvarchar(MAX)))
SET @rssFeed = ISNULL((SELECT location FROM #NtRssParams where #NtRssParams.ntype = 512 and location <> '' and elevel = 1 ),'')
		if @rssFeed <> ''
		BEGIN
UPDATE NTmessageFormat SET baseDir = @rssFeed where NTnotificationID = @notificationId and messageType = 512 and escalationLevel = 1
SET @tstring = (SELECT userName FROM #NtRssParams where #NtRssParams.ntype = 512 and userName <> '' and elevel = 1)
UPDATE NTmessageFormat SET userName = @tstring where NTnotificationID = @notificationId and messageType = 512 and escalationLevel = 1
SET @tpasstring = (SELECT password FROM #NtRssParams where #NtRssParams.ntype = 512 and password <> '' and elevel = 1)
UPDATE NTmessageFormat SET password = @tpasstring where NTnotificationID = @notificationId and messageType = 512 and escalationLevel = 1
IF ((@modifiedFlag & CAST(0x0080 AS INT)) <> CAST(0x0080 AS INT))-- 'NT_SAVEAS_PASSWORD_MODBIT'
			BEGIN
UPDATE NTmessageFormat SET password = @saveAsPassword where NTnotificationID = @notificationId and messageType = 512 and escalationLevel = 1
			END
		END
SET @rssFeed = ISNULL((SELECT location FROM #NtRssParams where #NtRssParams.ntype = 512 and location <> '' and elevel = 2 ),'')
		if @rssFeed <> ''
		BEGIN
UPDATE NTmessageFormat SET baseDir = @rssFeed where NTnotificationID = @notificationId and messageType = 512 and escalationLevel = 2
SET @tstring = (SELECT userName FROM #NtRssParams where #NtRssParams.ntype = 512 and userName <> '' and elevel = 2)
UPDATE NTmessageFormat SET userName = @tstring where NTnotificationID = @notificationId and messageType = 512 and escalationLevel = 2
SET @tpasstring = (SELECT password FROM #NtRssParams where #NtRssParams.ntype = 512 and password <> '' and elevel = 2)
UPDATE NTmessageFormat SET password = @tpasstring where NTnotificationID = @notificationId and messageType = 512 and escalationLevel = 2
IF ((@modifiedFlag & CAST(0x0100 AS INT)) <> CAST(0x0100 AS INT))-- 'NT_ESC_SAVEAS_PASSWORD_MODBIT'
			BEGIN
UPDATE NTmessageFormat SET password = @escSaveAsPassword where NTnotificationID = @notificationId and messageType = 512 and escalationLevel = 2
			END
		END
	END
if ((@notifType & 1024) = 1024)
	BEGIN
--		SET @rssFeed = (SELECT * from OPENXML(@iDoc, 'CVGui_AlertModifyReq/alertDetail/notifMsgs/feeds', 0)
--						WITH (rssFeedLocation nvarchar(MAX)))
SET @baseLocation = (SELECT DISTINCT location FROM #NtRssParams where #NtRssParams.ntype = 1024 and location <> '' )  -- base location are common for regular and escalated
SET @channelName = (SELECT DISTINCT channelloc FROM #NtRssParams where #NtRssParams.ntype = 1024 and channelloc <> '' ) -- channelName location are common for regular and escalated
--		SET @rssFeed = @baseLocation + '/' + @channelName
--		SET @copyrightString = "Copyright XXXXX @ 2009"
UPDATE NTmessageFormat SET baseDir = @baseLocation where NTnotificationID = @notificationId  and messageType = 1024
		SET @channelId = ISNULL((SELECT channelID from RssChannel where feedLocation = @channelName), 0)
		if (@channelId = 0)
		BEGIN
			INSERT INTO RssChannel (title, feedLocation, language, refCount, publish, feedCount, oldestTime)
			VALUES (@alertName, @channelName, @locale, 1, 1, 0, NULL)
			SET @channelId = (SELECT channelID from RssChannel where feedLocation = @channelName)
		END
		else
		BEGIN
			SET @count = (SELECT refCount from RssChannel where channelID = @channelId)
			SET @count = @count + 1
			UPDATE RssChannel SET refCount = @count
		END
UPDATE NTmessageFormat SET rssId = @channelId where NTnotificationID = @notificationId  and messageType = 1024
	END
IF((@notifType&65536)=65536)
	BEGIN
		UPDATE NTmessageFormat
		SET formatString=(select CAST( f.query('entity')AS nvarchar(max)) FROM
				@xmlInPutReq.nodes('CVGui_AlertModifyReq/alertDetail/notifMsgs') as ref(f)
where f.value('(@notifType)[1]','int')=65536 and f.value('(@esclationLevel)[1]','int')=1)
where NTnotificationID = @notificationId and messageType=65536 and escalationLevel=1
IF EXISTS(SELECT * FROM NTmessageFormat where NTnotificationID = @notificationId and messageType=65536 and escalationLevel=2)
				UPDATE NTmessageFormat
				SET formatString=(SELECT CAST( f.query('entity')AS nvarchar(max))
									FROM @xmlInPutReq.nodes('CVGui_AlertModifyReq/alertDetail/notifMsgs') as ref(f)
WHERE f.value('(@notifType)[1]','int')=65536 and f.value('(@esclationLevel)[1]','int')=2)
where NTnotificationID = @notificationId and messageType=65536 and escalationLevel=2
	END
	DROP TABLE #NtRssParams
	set @hasAttachments = 0
    DECLARE	GetAttachCursor CURSOR FOR
	SELECT
		case
			when messageFormatType = 1 then formatStringHtml
			else formatString
		end,
		messageFormatType,
		messageType
FROM NTmessageFormat where  NTnotificationID = @notificationID and ( messageType = 1 or messageType = 512 or messageType = 1024)  and escalationLevel = 1
	OPEN GetAttachCursor
	FETCH GetAttachCursor INTO @notifMsg,@messageFormatType,@messageType
	WHILE	@@FETCH_STATUS = 0
	BEGIN
   --Attachement for regular
	--set @notifMsg = (SELECT formatString FROM NTmessageFormat WHERE 	NTnotificationID = @notificationId and (messageType = NT_EMAIL_ALERTNOTIF or messageType = NT_SAVE_ALERTNOTIF or  messageType = NT_RSS_ALERTNOTIF)  and escalationLevel = 1)
	set @isHtmlEncoding = 0
	if @messageFormatType=1
	begin
		set @isHtmlEncoding = 1
	end
	if @notifMsg is NULL
	begin
		continue
	end
	declare @patStr nvarchar(1024)
set @patStr = N'%' + dbo.getHtmlEscapedString(dbo.fn_EvFormatEventMsgText(0,@locale, (55 | (CAST(POWER(2, 24) AS BIGINT) * 74)), 0,2),@isHtmlEncoding) + N'%'
	if (PATINDEX(@patStr , @notifMsg) > 0)
		set @hasAttachments |= @messageType
set @patStr = N'%' + dbo.getHtmlEscapedString(dbo.fn_EvFormatEventMsgText(0,@locale, (54 | (CAST(POWER(2, 24) AS BIGINT) * 74)), 0,2),@isHtmlEncoding) + N'%'
	if (PATINDEX(@patStr , @notifMsg) > 0)
		set @hasAttachments |= @messageType
set @patStr = N'%' + dbo.getHtmlEscapedString(dbo.fn_EvFormatEventMsgText(0,@locale, (53 | (CAST(POWER(2, 24) AS BIGINT) * 74)), 0,2),@isHtmlEncoding) + N'%'
	if (PATINDEX(@patStr , @notifMsg) > 0)
		set @hasAttachments |= @messageType
set @patStr = N'%' + dbo.getHtmlEscapedString(dbo.fn_EvFormatEventMsgText(0,@locale, (52 | (CAST(POWER(2, 24) AS BIGINT) * 74)), 0,2),@isHtmlEncoding) + N'%'
	if (PATINDEX(@patStr , @notifMsg) > 0)
		set @hasAttachments |= @messageType
set @patStr = N'%' + dbo.getHtmlEscapedString(dbo.fn_EvFormatEventMsgText(0,@locale, (180 | (CAST(POWER(2, 24) AS BIGINT) * 74)), 0,2),@isHtmlEncoding) + N'%'
	if (PATINDEX(@patStr , @notifMsg) > 0)
		set @hasAttachments |= @messageType
	FETCH GetAttachCursor INTO @notifMsg,@messageFormatType,@messageType
	END
	CLOSE GetAttachCursor
	DEALLOCATE GetAttachCursor
	--Update the notification rule
	Update NTnotificationRule
		Set hasAttachments   = @hasAttachments
	WHERE  id = @notificationId AND revision > 0
	--Attachment for escalation. Currently html is not supported here. Will be modified when html is supported.
	set @notifMsg = N''
set @notifMsg = (SELECT formatString FROM NTmessageFormat WHERE 	NTnotificationID = @notificationId and messageType = 1 and escalationLevel = 2 AND messageFormatType = 0)
	if(LEN(@notifMsg) > 1)
	BEGIN
		set @hasAttachments2 = 0
set @patStr = N'%' + dbo.fn_EvFormatEventMsgText(0,@locale, (55 | (CAST(POWER(2, 24) AS BIGINT) * 74)), 0,2) + N'%'
		if (PATINDEX(@patStr , @notifMsg) > 0)
			set @hasAttachments2 = 1
set @patStr = N'%' + dbo.fn_EvFormatEventMsgText(0,@locale, (54 | (CAST(POWER(2, 24) AS BIGINT) * 74)), 0,2) + N'%'
		if (PATINDEX(@patStr , @notifMsg) > 0)
			set @hasAttachments2 = 1
set @patStr = N'%' + dbo.fn_EvFormatEventMsgText(0,@locale, (53 | (CAST(POWER(2, 24) AS BIGINT) * 74)), 0,2) + N'%'
		if (PATINDEX(@patStr , @notifMsg) > 0)
			set @hasAttachments2 = 1
set @patStr = N'%' + dbo.fn_EvFormatEventMsgText(0,@locale, (52 | (CAST(POWER(2, 24) AS BIGINT) * 74)), 0,2) + N'%'
		if (PATINDEX(@patStr , @notifMsg) > 0)
			set @hasAttachments2 = 1
set @patStr = N'%' + dbo.fn_EvFormatEventMsgText(0,@locale, (180 | (CAST(POWER(2, 24) AS BIGINT) * 74)), 0,2) + N'%'
		if (PATINDEX(@patStr , @notifMsg) > 0)
			set @hasAttachments2 = 1
		--Update the notification rule
		Update NTnotificationRule
			Set hasAttachments2   = @hasAttachments2
		WHERE  id = @notificationId AND revision > 0
	END
END
IF ((@modifiedFlag & CAST(0x0008 AS INT)) = CAST(0x0008 AS INT))-- 'NT_REPORTCRITERIA_MODBIT'
BEGIN
	--------------------------
	-- Selected Criteria --
	--------------------------
	DELETE NTSelCriteriaParams where selCriteriaid IN (SELECT id from  NTSelCriteria where ruleId = @notificationId)
	DELETE NTSelCriteria where ruleId = @notificationId
	INSERT INTO  NTSelCriteria (availCriteriaid, esclationLevel, ruleId, reportingOptions, delayTimeSeconds,
				persistTimeSeconds)
		SELECT  criteriaId, esclationLevel,  @notificationID, reportingOptions, delayTimeSeconds,persistTimeSeconds
		  FROM OPENXML(@iDoc, 'CVGui_AlertModifyReq/alertDetail/criteria', 0)
			WITH (criteriaId int,  esclationLevel int,
			reportingOptions int, delayTimeSeconds int, persistTimeSeconds int )
--Check Error
	set @errorCode = @@error
	IF(@errorCode <> 0)
		GOTO MODIFY_EXIT
--Error Check
	set @errorCode = @@error
	IF(@errorCode <> 0)
		GOTO MODIFY_EXIT
	--------------------------
	-- Selected Criteria Params--
	--------------------------
	--Create temp table and store the values
	IF object_id('tempdb.dbo.#tempNTSelCriteriaParams') IS NOT NULL DROP TABLE #tempNTSelCriteriaParams
	create table #tempNTSelCriteriaParams ( criteriaId int, esclationLevel int,  paramIndex int, type int, value int, unit int)
	INSERT INTO  #tempNTSelCriteriaParams ( criteriaId,esclationLevel,  paramIndex, type,  value, unit)
			SELECT  criteriaId, esclationLevel,  paramIndex, type,  value,unit
			FROM OPENXML(@iDoc, 'CVGui_AlertModifyReq/alertDetail/criteria/criteriaParams', 0)
				WITH (criteriaId int '../@criteriaId',  esclationLevel int '../@esclationLevel', paramIndex int,  type int,  value int, unit int )
--Check Error
	set @errorCode = @@error
	IF(@errorCode <> 0)
		GOTO MODIFY_EXIT
--Error Check
	DECLARE	GetSelCriteriaCursor CURSOR FOR
	SELECT criteriaId,esclationLevel, paramIndex, type, value, unit FROM #tempNTSelCriteriaParams
	OPEN GetSelCriteriaCursor
	FETCH GetSelCriteriaCursor INTO @selCricriteriaId, @selCriEsclationId, @selCriparamIndex, @selCritype, @selCrivalue, @selCriunit
	WHILE	@@FETCH_STATUS = 0
	BEGIN
		SELECT 	@selCriId = id from NTSelCriteria where availCriteriaid = @selCricriteriaId AND esclationLevel =  @selCriEsclationId AND ruleId =  @notificationID
		INSERT INTO  NTSelCriteriaParams VALUES( @selCriId, @selCriparamIndex,  @selCritype, @selCrivalue, @selCriunit, 0)
--Check Error
	set @errorCode = @@error
	IF(@errorCode <> 0)
		GOTO MODIFY_EXIT
--Error Check
		FETCH GetSelCriteriaCursor INTO @selCricriteriaId, @selCriEsclationId, @selCriparamIndex, @selCritype, @selCrivalue, @selCriunit
	END
	CLOSE GetSelCriteriaCursor
	DEALLOCATE GetSelCriteriaCursor
	DROP TABLE #tempNTSelCriteriaParams
	set @errorCode = @@error
	IF(@errorCode <> 0)
		GOTO MODIFY_EXIT
END
IF ((((@modifiedFlag & CAST(0x0008 AS INT)) = CAST(0x0008 AS INT))OR ((@modifiedFlag & CAST(0x0001 AS INT)) = CAST(0x0001 AS INT))) AND @currentState > 0)
BEGIN
		UPDATE NTmessages SET lastSetMessageTime=NULL, firstDetectTime=NULL WHERE NTnotificationID = @notificationID AND escalationLevel = 1
--Check Error
	set @errorCode = @@error
	IF(@errorCode <> 0)
		GOTO MODIFY_EXIT
--Error Check
END
IF ((((@modifiedFlag & CAST(0x0008 AS INT)) = CAST(0x0008 AS INT))OR ((@modifiedFlag & CAST(0x0001 AS INT)) = CAST(0x0001 AS INT))) AND @currentEscalatedState > 0)
BEGIN
		UPDATE NTmessages SET lastSetMessageTime=NULL, firstDetectTime=NULL WHERE NTnotificationID = @notificationID AND escalationLevel = 2
--Check Error
	set @errorCode = @@error
	IF(@errorCode <> 0)
		GOTO MODIFY_EXIT
--Error Check
END
------- Modify Token Rule of the alert  ------
    --  Always overWrite token rule xml --
	DELETE NTNotificationProp WHERE componentNameId = @notificationId AND  attrName = 'Alert Token Rule Xml'
	if( len(@tokenRuleXml ) >0 )
	BEGIN
	    Insert into NTNotificationProp(componentNameId,attrName,attrType,attrVal,created,modified)
		select @notificationId,'Alert Token Rule Xml','1',@tokenRuleXml,dbo.GetUnixTime(GETUTCDATE()),0
	END
--------Modify Minimum Number of Anomalous Jobs property------------------------------------
DELETE NTNotificationProp WHERE componentNameId = @notificationId AND  attrName = 'Minimum Number of Anomalous Jobs'
	IF @minJobCountForJobAnomaly > 0
	BEGIN
		-- PROPERTY_INTEGER 7
	    Insert into NTNotificationProp(componentNameId,attrName,attrType,attrVal,created,modified)
VALUES (@notificationId, 'Minimum Number of Anomalous Jobs', 7, @minJobCountForJobAnomaly, dbo.GetUnixTime(GETUTCDATE()), 0)
	END
---------------------------------------------------------------------------------------------
-- Now update the earlier eventcriteriaXML entry if present for this rule else add it.
if (@alertTypeID=58)
begin
	delete from dbo.NTSimpanaEventCriteria
	where notifRuleId = @notificationId
	if (LEN(@eventCriteriaXml)>0)
	begin
		declare @eventCode nvarchar(max)
		set @eventCode = convert(xml,convert(varchar(max),@eventCriteriaXml)).value('(LogMonitoring_ConditionsList/conditions/column[@columnName=''Event Code'']/../@value1)[1]','nvarchar(max)')
		if @eventCode is null
		begin
			set @eventCode = ''
		end
		-- Check whether repeat condition is selected for event viewer alerts without event code being part of filter.
		if (len(@eventCode)=0 Or convert(xml,convert(varchar(max),@eventCriteriaXml)).exist('LogMonitoring_ConditionsList/conditions/column[@columnName=''Event Code'']')=0)
		begin
			if exists(select 1 from NTSelCriteria where ruleId=@notificationId and persistTimeSeconds>0)
			begin
set @errorCode = (1160 | (CAST(POWER(2, 24) AS BIGINT) * 74))
set @errorString = dbo.fn_EvFormatEventMsgText(0,@locale, (1160 | (CAST(POWER(2, 24) AS BIGINT) * 74)), 0,2)
				goto MODIFY_EXIT
			end
		end
		delete from NTNotificationProp
		where componentNameId=@notificationId
and attrName in ('Match Event Params','Event Code filter','Event MessageId filter','Event MessageId filter')
		Insert into NTNotificationProp(componentNameId,attrName,attrType,attrVal,created,modified)
select @notificationId,'Match Event Params','7',@checkForEventParams,dbo.GetUnixTime(GETUTCDATE()),0
		if (len(@eventCode)>0)
		begin
			Insert into NTNotificationProp(componentNameId,attrName,attrType,attrVal,created,modified)
select @notificationId,'Event Code filter','1',@eventCode,dbo.GetUnixTime(GETUTCDATE()),0
		end
		declare @templateId int
		-- Only one template for Simpana events. Hence retrieve the template id and store it here.
		select @templateId = templateId
		from
		APP_Template where templateForMonitoringType = 3
		Insert into dbo.NTSimpanaEventCriteria(commcellId,notifRuleId,templateId,criteriaXML,severity)
		select 2,@notificationId,@templateId,@eventCriteriaXml,0
	end
end
-- Add an entry into for "Custom Query" AlertType if criteria is present
if (@alertTypeID=65)
begin
	declare @previousRunType int
	declare @currentRunType int
	set @previousRunType = (select isScheduled from NTNotificationQueryMapping
		where NTNotificationId = @notificationId)
	-- In case its CUSTOM_QUERY alert type, update all relevant information into the table NTQueryCriteria
	Update dbo.NTNotificationQueryMapping
	set criteriaXML = ISNULL(Tbl.Col.value('@criteriaListxml', 'nvarchar(max)'),''),
	--taskId = ISNULL(Tbl.Col.value('@taskId', 'nvarchar(max)'),''),
	--isScheduled = ISNULL(Tbl.Col.value('@isScheduled', 'int'),0),
	xmlInfo = ISNULL(Tbl.Col.value('@additionalQueryInfo', 'nvarchar(max)'),''),
	queryCriteriaString = ISNULL(Tbl.Col.value('@queryCriteriaString', 'nvarchar(max)'),'')
	FROM @customQueryDetailsXml.nodes('/CVGui_CustomQueryDetailsForAlert') as Tbl(Col)
	where NtNotificationId = @notificationId
	Update dbo.NTNotificationQueryMapping
	set taskId = NTQueryList.taskId,
	queryParamDisplayString =
				case when NTQueryList.queryCriteriaName is not null and len(NTQueryList.queryCriteriaName)>0
				then NTQueryList.queryCriteriaName
				else NTQueryList.queryName
	end
	from NTQueryList
	where NTQueryList.queryId = NTNotificationQueryMapping.queryId
	and NTNotificationQueryMapping.NTNotificationId = @notificationId
	Update dbo.NTNotificationQueryMapping
	set isScheduled = case when NTNotificationQueryMapping.taskId>0 then 1
		else 0
		end
	from NTQueryList
	where NTQueryList.queryId = NTNotificationQueryMapping.queryId
	and NTNotificationQueryMapping.NTNotificationId = @notificationId
	-- Subclients recently created within <hrVal,0,1,0,10> hrs
	-- <?xml version="1.0" encoding="UTF-16" standalone="no" ?><CVGui_QueryAdditionalInfo><queryParameters><queryParameters paramName="hrVal" value="10"/></queryParameters></CVGui_QueryAdditionalInfo>
	Update dbo.NTNotificationQueryMapping
	set queryParamDisplayString = dbo.GetQueryDisplayNameForNTRule(@notificationId)
	where NTNotificationQueryMapping.NtNotificationId = @notificationId
end
if ( ((@alertTypeID=57 OR @alertTypeID=62)) Or (@alertTypeID=65))
begin
	set @notifMsg = N''
	set @notifMsg = (SELECT
					case
						when messageFormatType = 1 then formatStringHtml
						else formatString
					end
					FROM NTmessageFormat where  NTnotificationID = @notificationID
and messageType = 1 and escalationLevel = 1)
	declare @tokenOrderTable table
	(
		tokenId bigint,
		indexPos	int,
		message nvarchar(max)
	)
	declare @messagesList table
	(
		message nvarchar(max),
		tokenId bigint
	)
	Insert into @tokenOrderTable
	SELECT distinct NTOKEN.tokenID,0,NULL
		FROM NTavailCriteria AS NTAC, NTAlertType as NTS,  NTmessageTokensForAlert NTOKEN
		WHERE
		NTAC.alertTypeId = NTS.id and NTOKEN.availcriteriaId = NTAC.id
		and NTS.id=@alertTypeID
	Insert into @messagesList
	select Message,MessageID
	from EvLocaleMsgs
	where MessageID in
	(
		select tokenid from @tokenOrderTable
	)
	and LocaleID=0
	update TOT
	set message = ML.message
	from @messagesList ML,
	@tokenOrderTable TOT
	where ML.tokenId = TOT.tokenId
	Update @tokenOrderTable
	set message = dbo.getHtmlEscapedString(message,@isHtmlEncoding)
	Update @tokenOrderTable
	set indexPos = patindex('%'+message+'%',@notifMsg)
	declare @variableBodyLen int
	declare @variableBodyString nvarchar(max)
set @variableBodyString = dbo.getHtmlEscapedString(dbo.fn_EvFormatEventMsgText(0,@locale,(950 | (CAST(POWER(2, 24) AS BIGINT) * 74)), 0,2),@isHtmlEncoding)
	set @variableBodyLen = patindex('%'+@variableBodyString+'%',@notifMsg)
	delete from @tokenOrderTable
	where indexPos = 0 or indexPos is null
	delete from NTRuleTokenOrdering
	where NTnotificationID = @notificationID
and messageType = 1 and escalationLevel = 1
	Insert into NTRuleTokenOrdering(NTnotificationID,messageType,escalationLevel,TokenId,TokenOrder)
select @notificationID,1,1,tokenId,
	RANK() over (order by indexpos asc)
	from @tokenOrderTable
end
END
--Show Error OR Warning based on the permissions
IF (@userHasRightToEditAssociations = 0 AND @userHasRightToEditRecipients = 0 AND @userHasRightToEdit = 0)
	BEGIN
SET @errorCode = (2409 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WITH (NOLOCK) WHERE messageId = (2409 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale)
		SET @errorString = REPLACE(@errorString, '^1%s', ISNULL((SELECT login FROM UMUsers WITH (NOLOCK) WHERE id = @callerID),''))
SET @errorString = REPLACE(@errorString, '^2%s', (SELECT message FROM EvLocaleMsgs WITH (NOLOCK) WHERE messageId = (2815 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale))
		SET @errorString = REPLACE(@errorString, '^3%s', @alertName)
SET @errorString = REPLACE(@errorString, '^4%s', (SELECT message FROM EvLocaleMsgs WITH (NOLOCK) WHERE messageId = (2812 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale))
		GOTO MODIFY_EXIT
	END
ELSE IF (@userHasRightToEditAssociations = 0 OR @userHasRightToEditRecipients = 0 OR @userHasRightToEdit = 0)
	BEGIN
		DECLARE @userHasPermissions nvarchar(64)
		DECLARE @sep nvarchar(20)
		SET @userHasPermissions = ''
		SET @sep = ','
		IF (@userHasRightToEditAssociations = 1)
SET @userHasPermissions = (SELECT message FROM EvLocaleMsgs WITH (NOLOCK) WHERE messageId = (2817 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale) + @sep
		IF (@userHasRightToEditRecipients = 1)
SET @userHasPermissions = @userHasPermissions + (SELECT message FROM EvLocaleMsgs WITH (NOLOCK) WHERE messageId = (2818 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale) + @sep
		IF (@userHasRightToEdit = 1)
SET @userHasPermissions = @userHasPermissions + (SELECT message FROM EvLocaleMsgs WITH (NOLOCK) WHERE messageId = (2815 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale) + @sep
		IF len(@userHasPermissions) > 0
			SET @userHasPermissions = substring(@userHasPermissions, 1, len(@userHasPermissions )-1 )
SET @errorCode = (1194 | (CAST(POWER(2, 24) AS BIGINT) * 74))
SET @errorString = (SELECT message FROM EvLocaleMsgs WITH (NOLOCK) WHERE messageId = (1194 | (CAST(POWER(2, 24) AS BIGINT) * 74)) and localeid = @locale)
		SET @errorString = REPLACE(@errorString, '^1%s', ISNULL((SELECT login FROM UMUsers WITH (NOLOCK) WHERE id = @callerID),''))
		SET @errorString = REPLACE(@errorString, '^2%s', @alertName)
		SET @errorString = REPLACE(@errorString, '^3%s', ISNULL((SELECT login FROM UMUsers WITH (NOLOCK) WHERE id = @callerID),''))
		SET @errorString = REPLACE(@errorString, '^4%s', @userHasPermissions)
	END
	-- Check if its failover configuration alert and send workqueue request to all failover nodes.
	INSERT INTO APP_WorkQueueRequest (clientId, workToken, workTokenParams, createTime, lastUpdateTime, retryCount, flag, remoteClient)
	SELECT C.Id,
		@workTokenId,
		'',
		dbo.GetUnixTime(GetUTCDate()), 0, 0, 0, -1
		FROM SimInstalledPackages WITH (READUNCOMMITTED)
        INNER JOIN App_client C WITH (READUNCOMMITTED) on SimInstalledPackages.clientId = C.Id
AND (C.status&2)=0 and simPackageID IN (24, 1024)
		INNER JOIN NTAlertType WITH (READUNCOMMITTED) ON NTAlertType.ID = @alertTypeID
AND  ( NTAlertType.actionsAllowed & 1024 ) > 0
MODIFY_EXIT:
if (@errorCode = 0)
BEGIN
SET @errorString = dbo.fn_EvFormatEventMsgText(0,@locale, (171 | (CAST(POWER(2, 24) AS BIGINT) * 74)), 0,2) + N' : ' + @alertName
END
else
BEGIN
	IF @errorString = ''			-- IF Error and no errorString yet defined, add one!
SET @errorString = dbo.fn_EvFormatEventMsgText(0,@locale, (172 | (CAST(POWER(2, 24) AS BIGINT) * 74)), 0,2) + N' : ' + @alertName
END
---------------------------------------------
-- THIS IS THE RESPONSE IF ALL WENT WELL ----
---------------------------------------------
SELECT	1			         as TAG,
		NULL		         as Parent,
	@errorCode			     as [CVGui_GenericResp!1!errorCode],
	@errorString	         as [CVGui_GenericResp!1!errorMessage]
FOR XML EXPLICIT
if @isTranStarted =1
BEGIN
if (@errorCode = 0 OR @errorCode = (1194 | (CAST(POWER(2, 24) AS BIGINT) * 74)))
	BEGIN
		commit tran
	END
	else
	BEGIN
		rollback tran
	END
END
EXEC sp_xml_removedocument @idoc
SET NOCOUNT OFF
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  END
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
GO

IF EXISTS (select * from GxQscripts where name = 'br_ntAlertModify')
	delete from GxQscripts where name = 'br_ntAlertModify'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_ntAlertModify')
	delete from GXDBVersions where aliasname = 'br_ntAlertModify'
GO

insert into GXDBVersions values(2, 'br_ntAlertModify',  '00010072001200210000', 'br_ntAlertModify', '00010072001200210000')
GO

