

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/br_ntAlertEntitiesAppIdUpdate.sp] ---------- 

-- -------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/br_ntAlertEntitiesAppIdUpdate.sp,v $ $Id: br_ntAlertEntitiesAppIdUpdate.sp,v 1.4.60.2 2018/03/27 08:02:53 jiechen Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   br_ntAlertEntitiesAppIdUpdate   - Select/Deselect appid in alert entities list
--	-------------------------------------------------------
--	-- Error Codes:
--	--	0 -Success (alert deleted)
--	--      1 - Failure
--	-------------------------------------------------------
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: br_ntAlertEntitiesAppIdUpdate <<<'

IF EXISTS (select * from sysobjects where name='br_ntAlertEntitiesAppIdUpdate')
	drop procedure br_ntAlertEntitiesAppIdUpdate
IF EXISTS (select * from GxQscripts where name='br_ntAlertEntitiesAppIdUpdate')
	delete from GxQscripts where name = 'br_ntAlertEntitiesAppIdUpdate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_ntAlertEntitiesAppIdUpdate')
	delete from GXDBVersions where aliasname = 'br_ntAlertEntitiesAppIdUpdate'
GO
print '... Creating Procedure: br_ntAlertEntitiesAppIdUpdate'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure br_ntAlertEntitiesAppIdUpdate
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @alertId int,
  @subclientId int,
  @locale int,
  @selected int,
  @wasModified int OUTPUT,
  @errorCode int OUTPUT,
  @errorString varchar(1024) OUTPUT
AS
SET NOCOUNT ON
--
DECLARE @alreadyInList	integer						-- Need to know this before we attempt insert or delete
DECLARE @clientId	 	integer
DECLARE	@appTypeId		integer
DECLARE @idaNameId		integer
DECLARE	@instanceId		integer
DECLARE @backupsetId	integer
DECLARE @entities		XML
DECLARE @nameFromId		varchar(256)
--
-- ASSUME WE WILL HAVE NO ERROR --
--
SET @errorCode		= 0	     -- Be optimistic!
SET @errorString	= ''
SET @wasModified	= 0
--
-- ----------------------------------------------------------------------------
--   BEGIN
-- ----------------------------------------------------------------------------
BEGIN TRY
	--
	--set @ownerId = (SELECT notifOwner from NTnotificationRule WHERE  id = @alertId)
	------------------------------------------------------------------------------------
	--  CHECK FOR THE RIGHTS! --
	------------------------------------------------------------------------------------
	/*
IF (@ownerId <> @callerID OR @alertCategoryId = 7)
	BEGIN
		exec br_NTPermCheck @callerID, @locale, @capability, 2018, 2, @errorCode OUTPUT, @errorString OUTPUT
		IF @errorCode <> 0
			goto ENTITY_UPDATE_EXIT
	END
	*/
--
	IF NOT EXISTS (select * from NTnotificationRule WHERE id = @alertId )
	BEGIN
set @errorCode = CAST(0x0B0003 AS INT)
set @errorString = dbo.fn_EvFormatEventMsgText(0,@locale, (143 | (CAST(POWER(2, 24) AS BIGINT) * 74)), 0,2)
		goto ENTITY_UPDATE_EXIT
	END
--
--
	-- -------------------------------------------------------------------------------
	-- DO THE WORK HERE																--
	-- -------------------------------------------------------------------------------
	SET @entities 	= (select xmlentityList from NTnotificationRule where id = @alertId)
--
	SET @alreadyInList = 	 ISNULL (( SELECT TOP 1 ref.value('@subclientId', 'integer')
								FROM @entities.nodes ('/CVGui_CommCellTreeNode[1]/clients[1]/clients[@subclientId=sql:variable("@subclientId")]') R(ref)), 0)
--
	IF @selected <> 0
	BEGIN
		IF @alreadyInList <> 0
			GOTO ENTITY_UPDATE_EXIT
--
		SELECT @clientId=clientId, @appTypeId=appTypeId, @instanceId=instance, @backupsetId=backupSet from APP_Application where id=@subclientId
--
		SET @entities.modify('insert <clients/> as first into (/CVGui_CommCellTreeNode[1]/clients[1])')
--
		SET @nameFromId = ISNULL((Select subClientName from app_application where id = @subclientId), '')
		SET @entities.modify('insert (attribute subclientName {sql:variable("@nameFromId")}) as last into (/CVGui_CommCellTreeNode[1]/clients[1]/clients[1])')
		SET @entities.modify('insert (attribute subclientId {sql:variable("@subclientId")}) as first into (/CVGui_CommCellTreeNode[1]/clients[1]/clients[1])')
--
		SET @nameFromId = ISNULL((Select name from app_instanceName where id = @instanceId), '')
		SET @entities.modify('insert (attribute instanceName {sql:variable("@nameFromId")}) as last into (/CVGui_CommCellTreeNode[1]/clients[1]/clients[1])')
		SET @entities.modify('insert (attribute instanceId {sql:variable("@instanceId")}) as first into (/CVGui_CommCellTreeNode[1]/clients[1]/clients[1])')
--
		SET @nameFromId = ISNULL((Select name from app_idaType where type=@appTypeId), '')
		SET @entities.modify('insert (attribute idaName {sql:variable("@nameFromId")}) as last into (/CVGui_CommCellTreeNode[1]/clients[1]/clients[1])')
		SET @entities.modify('insert (attribute idaTypeId {sql:variable("@appTypeId")}) as first into (/CVGui_CommCellTreeNode[1]/clients[1]/clients[1])')
--
		SET @nameFromId = ISNULL((Select name from app_client where id=@clientId), '')
		SET @entities.modify('insert (attribute clientName {sql:variable("@nameFromId")}) as last into (/CVGui_CommCellTreeNode[1]/clients[1]/clients[1])')
		SET @entities.modify('insert (attribute clientId {sql:variable("@clientId")}) as first into (/CVGui_CommCellTreeNode[1]/clients[1]/clients[1])')
--
		SET @nameFromId = ISNULL((Select name from app_backupsetName where id=@backupsetId), '')
		SET @entities.modify('insert (attribute backupsetName {sql:variable("@nameFromId")}) as last into (/CVGui_CommCellTreeNode[1]/clients[1]/clients[1])')
		SET @entities.modify('insert (attribute backupsetId {sql:variable("@backupsetId")}) as first into (/CVGui_CommCellTreeNode[1]/clients[1]/clients[1])')
--
		UPDATE NTnotificationRule SET xmlentityList=@entities WHERE id = @alertId
		SET @wasModified = 1
	END
	ELSE					-- @selected == 0
	BEGIN
		IF @alreadyInList <> 0
		BEGIN
			SET @entities.modify('delete (/CVGui_CommCellTreeNode[1]/clients[1]/clients[@subclientId=sql:variable("@subclientId")])')
			UPDATE NTnotificationRule SET xmlentityList=@entities WHERE id = @alertId
			SET @wasModified = 1
		END
	END
END TRY
--
--
--
--=====================================================================
--==============  COME HERE IF THERE WAS A PROBLEM!     ===============
--=====================================================================
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode	 = ERROR_NUMBER()
	SET @errorString  = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END CATCH
---------------------------------------------
-- SEND THE RESPONSE TO THE GUI           ---
---------------------------------------------
ENTITY_UPDATE_EXIT:
---------------------------------------------
-- THIS IS THE RESPONSE IF ALL WENT WELL ----
---------------------------------------------
--SELECT	errorCode=@errorCode, errorString=@errorString
SET NOCOUNT OFF
--   END
GO
/*
DECLARE @modified as int = 0
DECLARE @errorCode as int = 9999
DECLARE @errorString as varchar(512) = 'Silly Rabbit'
DECLARE @alertID as int = 134
--
select wasModified=@modified, errorCode=@errorCode, errorString=@errorString, xmlentityList from NTnotificationRule where id=@alertID
--
exec br_ntAlertEntitiesAppIdUpdate 134, 4, 0, 0, @modified OUTPUT, @errorCode OUTPUT, @errorString OUTPUT
select wasModified=@modified, errorCode=@errorCode, errorString=@errorString, xmlentityList from NTnotificationRule where id=@alertID
--
exec br_ntAlertEntitiesAppIdUpdate 134, 4, 0, 0, @modified OUTPUT, @errorCode OUTPUT, @errorString OUTPUT
select wasModified=@modified, errorCode=@errorCode, errorString=@errorString, xmlentityList from NTnotificationRule where id=@alertID
--
exec br_ntAlertEntitiesAppIdUpdate 134, 4, 0, 0, @modified OUTPUT, @errorCode OUTPUT, @errorString OUTPUT
select wasModified=@modified, errorCode=@errorCode, errorString=@errorString, xmlentityList from NTnotificationRule where id=@alertID
*/

IF EXISTS (select * from GxQscripts where name = 'br_ntAlertEntitiesAppIdUpdate')
	delete from GxQscripts where name = 'br_ntAlertEntitiesAppIdUpdate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_ntAlertEntitiesAppIdUpdate')
	delete from GXDBVersions where aliasname = 'br_ntAlertEntitiesAppIdUpdate'
GO

insert into GXDBVersions values(2, 'br_ntAlertEntitiesAppIdUpdate',  '00010004006000020000', 'br_ntAlertEntitiesAppIdUpdate', '00010004006000020000')
GO

