

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/br_ntAddMessageForUsers.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/br_ntAddMessageForUsers.sp,v $ $Id: br_ntAddMessageForUsers.sp,v 1.4.294.1 2017/02/10 21:21:45 sjohnson Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   br_ntAddMessageForUsers   - Fetch the (short) list of currently defined alert
--                      notifications.
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: br_ntAddMessageForUsers <<<'

IF EXISTS (select * from sysobjects where name='br_ntAddMessageForUsers')
	drop procedure br_ntAddMessageForUsers
IF EXISTS (select * from GxQscripts where name='br_ntAddMessageForUsers')
	delete from GxQscripts where name = 'br_ntAddMessageForUsers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_ntAddMessageForUsers')
	delete from GXDBVersions where aliasname = 'br_ntAddMessageForUsers'
GO
print '... Creating Procedure: br_ntAddMessageForUsers'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure br_ntAddMessageForUsers
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @notifId int,
  @timeStamp datetime,
  @escLevel int,
  @retVal int  OUTPUT
AS
-------------------
---    BEGIN    ---
-------------------
declare @localError integer
declare @currentUser integer
declare @traceMessage varchar(1024)
declare @brAlertTrace                 varchar(256)
  set @brAlertTrace               =(select value from gxglobalParam Where name = 'bralertTrace')
  set @brAlertTrace               = ISNULL(@brAlertTrace, 0)
if @brAlertTrace <> 0
	exec br_ntTrace '.. br_ntAddMessageForUsers', @notifId, @timeStamp, @escLevel, 9999, 'Processing ...'
	set @retVal = -1			-- Smudge it
--  HANDLE "AD" UserGroups  -----
if object_id('tempdb.dbo.#UMuserGroup') is not Null     DROP TABLE #UMuserGroup
create table #UMuserGroup (
        userId int not null,
        groupId int not null
)
INSERT #UMuserGroup
	SELECT UG.userId, UG.groupId
	FROM	UMUserGroup AS UG,
			NTnotificationGroups AS NG
	WHERE
			UG.groupId = NG.groupId
	 AND	NG.NTnotificationId = @notifId
	 AND	NG.escalationLevel = @escLevel
INSERT #UMUserGroup
	SELECT distinct DSUG.userId, MAP.umGroupId
	FROM	UMDSUserGroup as DSUG,
			UMDSGroupMaps AS MAP,
			NTnotificationGroups AS NG
	WHERE
			NG.groupId = MAP.umgroupId
			AND	MAP.umdsgroupID = DSUG.groupID
			AND NG.NTnotificationId = @notifId
			AND	NG.escalationLevel = @escLevel
DELETE #UMUserGroup
	FROM	#UMUserGroup as UG,
			UMGroups AS G
	WHERE
			 UG.groupId = G.id
	  AND	(G.GroupFlags & 1) = 0								--#define GF_GROUP_ENABLED   0x0001
DELETE #UMUserGroup
	FROM #UMUserGroup as UG, UMUsers AS U
	WHERE U.id = UG.userId
	AND U.enabled = 0
BEGIN TRANSACTION
------------------------------------------------------------------------------------------
--- FOLLOWING CODE FRAGMENT SELECTS ALL THE USERS WHO ARE TO RECEIVE THIS NOTIFICATION ---
------------------------------------------------------------------------------------------
DECLARE NTaddMessageForUsers_Cursor CURSOR FOR
SELECT userId FROM NTnotificationUsers
WHERE NTnotificationId = @notifId
  AND escalationLevel = @escLevel
UNION
SELECT DISTINCT userId from #UMUserGroup
OPEN NTaddMessageForUsers_Cursor
FETCH NEXT FROM NTaddMessageForUsers_Cursor INTO @currentUser
WHILE @@FETCH_STATUS = 0
BEGIN
------------------------------------------------------------------------------------
---	CHECK IF EMAILS ARE ENABLED FOR THIS NOTIFICATION AND ADD FOR SELECTED USERS ---
------------------------------------------------------------------------------------
	IF EXISTS (SELECT * FROM NTnotification WHERE NTnotificationId = @notifId AND emailEnable <> 0 AND revision > 0)
	BEGIN
		IF NOT EXISTS (SELECT * FROM NTMessageTracking
						WHERE NTnotificationId = @notifId
AND messageType = 1					--"NT_EMAIL_ALERTNOTIF"
						AND escalationLevel = @escLevel
		)
		BEGIN
    if @brAlertTrace <> 0
	BEGIN
	set @traceMessage = 'Adding Entry for id('+convert(varchar(2), @notifId)+'), EscalationLevel(' +convert(varchar(1), @escLevel) +').'
	exec br_ntTrace '.. br_ntAddMessageForUsers', @notifId, @timeStamp, @escLevel, 9999, @tracemessage
	END
			INSERT INTO NTMessageTracking (
					NTnotificationID,
					messageType,
					escalationLevel,
					lastMessageSent,
					lastFailureTime,
					lastFailureReason
			) VALUES (
					@notifId,				--NTnotificationId
1,										--"NT_EMAIL_ALERTNOTIF"
					@escLevel,
					0,						--lastMessageSent
					0,						--lastFailureTime
					''						--lastFailureReason
			)
		SET @retVal = @@error
		END
	END
------------------------------------------------------------------------------------
---	CHECK IF PAGERS ARE ENABLED FOR THIS NOTIFICATION AND ADD FOR SELECTED USERS ---
------------------------------------------------------------------------------------
	IF EXISTS (SELECT * FROM NTnotification WHERE NTnotificationId = @notifId AND pagerEnable <> 0 AND revision > 0)
	BEGIN
		IF NOT EXISTS (SELECT * FROM NTMessageTracking
						WHERE NTnotificationId = @notifId
AND messageType = 2				--"NT_PAGER_ALERTNOTIF"
						AND escalationLevel = @escLevel
		)
		BEGIN
			INSERT INTO NTMessageTracking (
					NTnotificationID,
					messageType,
					escalationLevel,
					lastMessageSent,
					lastFailureTime,
					lastFailureReason
			) VALUES (
					@notifId,				--NTnotificationId
2,									--"NT_PAGER_ALERTNOTIF"
					@escLevel,
					0,						--lastMessageSent
					0,						--lastFailureTime
					''						--lastFailureReason
			)
			SET @retVal = @@error
		END
	END
    if @brAlertTrace <> 0
	BEGIN
	IF (@retVal <> 0)
	BEGIN
		set @traceMessage = 'Error(' +convert(varchar(10), @retVal)	+').'
		exec br_ntTrace '.. br_ntAddMessageForUsers', @notifId, @timeStamp, @escLevel, 9999, @tracemessage
	END
	END
--------------------------------------------------------------------------------------------------
---	HERE WOULD GO THE CHECKS FOR THE OTHER NOTIFICATION TYPES AND ADDITIONF FOR SELECTED USERS ---
--------------------------------------------------------------------------------------------------
--							O
--							O
--							O
--							O
------------------------------------------------------------
--- FINISHED WITH THIS USER, LOOP FOR THE NEXT ONE       ---
------------------------------------------------------------
FETCH NEXT FROM NTaddMessageForUsers_Cursor INTO @currentUser
END
CLOSE		NTaddMessageForUsers_Cursor
DEALLOCATE	NTaddMessageForUsers_Cursor
--             ==============================================================
--        =========================================================================
--   =====================================================================================
--   == CHECKS DONE HERE ARE OUTSIDE THE "FETCH NOTIFICATION RECEPIENTS" LOOP BECAUSE   ==
--   ==  NOTIFICATION TYPES DO NOT HAVE SPECIFIC USERS ASSOCIATED WITH THEM		        ==
--   ======================================================================================
--        =========================================================================
--             ==============================================================
----------------------------------------------------------------
---	CHECK IF RUN COMMAND IS ENABLED FOR THIS NOTIFICATION	 ---
----------------------------------------------------------------
	IF EXISTS (SELECT * FROM NTnotification WHERE NTnotificationId = @notifId AND actionEnable <> 0 AND revision > 0)
	BEGIN
--												USER IN THIS CASE IS OWNER!
		SET @currentUser = (select notifOwner
		 FROM NTnotification
		   WHERE NTnotificationId = @notifId AND actionEnable <> 0 AND revision > 0)
		IF NOT EXISTS (SELECT * FROM NTMessageTracking
						WHERE NTnotificationId = @notifId
AND messageType = 16					--"NT_RUNCMD_ALERTNOTIF"
						AND escalationLevel = @escLevel
		)
		BEGIN
    if @brAlertTrace <> 0
	BEGIN
	set @traceMessage = 'Adding Entry for id('+convert(varchar(2), @notifId)+'), EscalationLevel(' +convert(varchar(1), @escLevel) +').'
	exec br_ntTrace '.. br_ntAddMessageForUsers', @notifId, @timeStamp, @escLevel, 9999, @tracemessage
	END
			INSERT INTO NTMessageTracking (
					NTnotificationID,
					messageType,
					escalationLevel,
					lastMessageSent,
					lastFailureTime,
					lastFailureReason
			) VALUES (
					@notifId,				--NTnotificationId
16,										--"NT_RUNCMD_ALERTNOTIF"
					@escLevel,
					0,						--lastMessageSent
					0,						--lastFailureTime
					''						--lastFailureReason
			)
		SET @retVal = @@error
		END
	END
----------------------------------------------------------------
---	CHECK IF SNMP TRAPS ARE ENABLED FOR THIS NOTIFICATION	 ---
----------------------------------------------------------------
	IF EXISTS (SELECT * FROM NTnotification WHERE NTnotificationId = @notifId AND snmpEnable <> 0 AND revision > 0)
	BEGIN
--												USER IN THIS CASE IS OWNER!
		SET @currentUser = (select notifOwner
		 FROM NTnotification
		   WHERE NTnotificationId = @notifId AND snmpEnable <> 0 AND revision > 0)
		IF NOT EXISTS (SELECT * FROM NTMessageTracking
						WHERE NTnotificationId = @notifId
AND messageType = 4					--"NT_SNMP_ALERTNOTIF"
						AND escalationLevel = @escLevel
		)
		BEGIN
    if @brAlertTrace <> 0
	BEGIN
	set @traceMessage = 'Adding Entry for id('+convert(varchar(2), @notifId)+'), EscalationLevel(' +convert(varchar(1), @escLevel) +').'
	exec br_ntTrace '.. br_ntAddMessageForUsers', @notifId, @timeStamp, @escLevel, 9999, @tracemessage
	END
			INSERT INTO NTMessageTracking (
					NTnotificationID,
					messageType,
					escalationLevel,
					lastMessageSent,
					lastFailureTime,
					lastFailureReason
			) VALUES (
					@notifId,				--NTnotificationId
4,										--"NT_SNMP_ALERTNOTIF"
					@escLevel,
					0,						--lastMessageSent
					0,						--lastFailureTime
					''						--lastFailureReason
			)
		SET @retVal = @@error
		END
	END
----------------------------------------------------------------
---	CHECK IF WINDOWS EVENT LOGS  ARE ENABLED FOR THIS NOTIFICATION	 ---
----------------------------------------------------------------
	IF EXISTS (SELECT * FROM NTnotification WHERE NTnotificationId = @notifId AND appLogEnable <> 0 AND revision > 0)
	BEGIN
--												USER IN THIS CASE IS OWNER!
		SET @currentUser = (select notifOwner
		 FROM NTnotification
		   WHERE NTnotificationId = @notifId AND appLogEnable <> 0 AND revision > 0)
		IF NOT EXISTS (SELECT * FROM NTMessageTracking
						WHERE NTnotificationId	= @notifId
AND messageType			= 8					--"NT_APPLOG_ALERTNOTIF"
						AND escalationLevel		= @escLevel
		)
		BEGIN
    if @brAlertTrace <> 0
	BEGIN
	set @traceMessage = 'Adding Entry for id('+convert(varchar(2), @notifId)+'), EscalationLevel(' +convert(varchar(1), @escLevel) +').'
	exec br_ntTrace '.. br_ntAddMessageForUsers', @notifId, @timeStamp, @escLevel, 9999, @tracemessage
	END
			INSERT INTO NTMessageTracking (
					NTnotificationID,
					messageType,
					escalationLevel,
					lastMessageSent,
					lastFailureTime,
					lastFailureReason
			) VALUES (
					@notifId,				--NTnotificationId
8,										--"NT_APPLOG_ALERTNOTIF"
					@escLevel,
					0,						--lastMessageSent
					0,						--lastFailureTime
					''						--lastFailureReason
			)
		SET @retVal = @@error
		END
	END
-------------------
---     END     ---
-------------------
ADD_MESSAGE_EXIT:
	if (@retVal = 0)
		COMMIT TRAN
	else
		ROLLBACK TRAN
if object_id('tempdb.dbo.#UMuserGroup') is not Null     DROP TABLE #UMuserGroup
GO

IF EXISTS (select * from GxQscripts where name = 'br_ntAddMessageForUsers')
	delete from GxQscripts where name = 'br_ntAddMessageForUsers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_ntAddMessageForUsers')
	delete from GXDBVersions where aliasname = 'br_ntAddMessageForUsers'
GO

insert into GXDBVersions values(2, 'br_ntAddMessageForUsers',  '00010004029400010000', 'br_ntAddMessageForUsers', '00010004029400010000')
GO

