

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/br_NTalertList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/br_NTalertList.sp,v $ $Id: br_NTalertList.sp,v 1.27.12.10 2020/09/03 14:44:15 vthakur Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   br_NTalertList   - Fetch the (short) list of currently defined alert
--                      notifications.
--
--                      If alertGroup is set to 1, retrieve all alerts, if
--                      set to 2, retrieve only alerts user owns or is targeted
--                      to be a recepient of (currently not implemented),if set
--						4 return only the job based alert and if set 64 return
--						only ROMS alerts
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='br_NTalertList')
BEGIN
	print '>>> Drop Stored Procedure: br_NTalertList <<<'
	drop procedure br_NTalertList
END
IF EXISTS (select * from GxQscripts where name='br_NTalertList')
	delete from GxQscripts where name = 'br_NTalertList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_NTalertList')
	delete from GXDBVersions where aliasname = 'br_NTalertList'
GO
print '... Creating Procedure: br_NTalertList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure br_NTalertList
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @userID int,
  @localeId int,
  @alertGroup int,
  @organizationId int = 0
AS
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  BEGIN
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
declare @myReceiveTotal int
declare @myCreateTotal	int
DECLARE @capabilies			int
DECLARE @capabiliesWant		int
DECLARE @hasRights			int
DECLARE @hasSRM             int
SET @hasSRM    = ISNULL(db_id('SRM'), 0)
--set @externalQueryId = 0
DECLARE @entityType AS INT
SET @entityType = 64					--CvEntities::EntityType_ALERT_ENTITY(64)
-----------------------------------------------------------------------------------------
-- SINCE WE WILL BE USING THE NOTIFICATION LIST OVER AND OVER AGAIN, MIGHT AS WELL PUT --
-- THE NOTIFICATIONS WE ARE INTERESTED IN INTO A TEMPORARY TABLE                       --
-----------------------------------------------------------------------------------------
if object_id('tempdb.dbo.#notifList') is not null
BEGIN
    DROP TABLE #notifList
END
CREATE TABLE #notifList (
	NTnotificationId integer NOT NULL,
	LcategoryId		 integer NOT NULL,
	LalertTypeId	 integer NOT NULL,
	Lstatus			 integer NOT NULL,
	queryId			 integer NOT NULL,
	queryName		 nvarchar(max) NOT NULL,
	organizationId	 INTEGER NULL,
	organizationName NVARCHAR(MAX) NULL,
	creatorId        integer NOT NULL,
	creatorGroupId   integer NOT NULL
)
--Get the list of alert (notif) ids which are visible to user
if object_id('tempdb.dbo.#alertList') is not null
BEGIN
    DROP TABLE #alertList
END
CREATE TABLE #alertList (NTnotificationId integer NOT NULL)
EXEC sec_getNonIdaObjectsForThisUser @userId, @entityType, 0, '#alertList'
INSERT INTO #notifList(NTnotificationId,LcategoryId,LalertTypeId,Lstatus, queryId,queryName,creatorId,creatorGroupId )
	SELECT NTnotificationId, 0,0,0,0,'',0,0
		From #alertList
DROP TABLE #alertList
-- Now remove all custom alerts for queries which he cant see.
-- FILL IN MISSING COLUMNS
UPDATE #notifList
		SET LCategoryId = categoryId, LalertTypeId = alertTypeId, Lstatus = status
			FROM NTnotificationRule
			WHERE id = NTnotificationId
------------------------------------------------------
--   DECIDE WHICH ALERTS WE DO NOT WANT TO REPORT: ---
------------------------------------------------------
declare @visibleQueries table
(
	queryId int,
	queryType int,
	externalEntityId nvarchar(max)
)
IF object_id('tempdb.dbo.#customQueriesList') IS NOT Null DROP TABLE #customQueriesList
CREATE TABLE #customQueriesList (NTqueryId integer NOT NULL)
EXEC sec_getNonIdaObjectsForThisUser @userId, 124 /* CUSTOM_QUERY_ENTITY */, 0, '#customQueriesList'
Insert into @visibleQueries
select QueryId,0,0 from NTQueryList with (nolock) where queryCreator = @userId -- Creator can always see queries he created.
union
select NTqueryId,0,0 from #customQueriesList U with (nolock)
-- Now return custom alerts only for specified external queries.
Update InputQueries
set queryType = IsNull(convert(xml,NTqueryList.xmlInfo).value('(App_AdditionalQueryDetails/externalQueryEntity/@queryType)[1]','int'),1)
--externalEntityId = IsNull(convert(xml,NTqueryList.xmlInfo).value('(App_AdditionalQueryDetails/externalQueryEntity/@externalQueryId)[1]','nvarchar(max)'),0)
from @visibleQueries InputQueries
inner join NTqueryList
on InputQueries.queryid = NTqueryList.queryId
where NTqueryList.xmlInfo is not null and len(NTqueryList.xmlInfo)>0
-- Dont return alerts for Metrics reports here.. To be done later based on queryType from param
delete from @visibleQueries
where queryType = 2 --CustomQueryType_METRICS_QUERY
OR queryType = 3 --CustomQueryType_LM_SEARCH
/*
-- If queryType of custom query doesnt match with input query Type or externalQueryId of custom query doesnt match with input then we remove them.
delete from @visibleQueries
where (@queryType <>0 and queryType <> @queryType)
or(@externalQueryId <> 0 and externalEntityId<>@externalQueryId)
*/
-- Delete custom alerts for queries which he cant see.. .
DELETE FROM #notifList
WHERE LalertTypeId = 65
AND  NTnotificationId not in
(
	select distinct NTNotificationId from NTNotificationQueryMapping
	inner join @visibleQueries VisibleQueries on
	VisibleQueries.queryId = NTNotificationQueryMapping.queryId
)
-- Dont show hidden alerts in commcell console.
DELETE 	#notifList
where  (Lstatus & 262144 )  > 0
-- JOB BASED:
IF ((@alertGroup & 4) <> 4)
	DELETE 	#notifList
		 where  (Lstatus &4 = 4) OR (Lstatus &8 = 8)
-- SRM ADVISORIES, NEVER SHOW!:
	DELETE 	#notifList
		 where (Lstatus &32 = 32) OR (Lstatus &8 = 8)
-- ROMS ALERTS:
IF ((@alertGroup & 64) <> 64)
	DELETE 	#notifList
		 where  (Lstatus &64 = 64)
-- IF SRM ISN'T INSTALLED (ANYMORE) --
-- .. DON'T RETURN SRM ALERTS       --
IF (@hasSRM = 0)
	DELETE #notifList
WHERE  LcategoryId = 7   				--'NT_CATEGORY_SRM'
		   OR 	LalertTypeId in (
51,					-- 'NT_ALERTTYPE_SRM'
56,			-- 'NT_ALERTTYPE_SRM_REPORT'
31, 			-- 'NT_ALERTTYPE_SRM_WINFS'
32,			-- 'NT_ALERTTYPE_SRM_ORACLE'
33,				-- 'NT_ALERTTYPE_SRM_SQL'
34,				-- 'NT_ALERTTYPE_SRM_NAS'
35,			-- 'NT_ALERTTYPE_SRM_EXCHANGE'
36,		-- 'NT_ALERTTYPE_SRM_SHARE_POINT'
37,			-- 'NT_ALERTTYPE_SRM_UNIXFS'
38,		--'NT_ALERTTYPE_SRM_COST_ANALYSIS'
39 )   		--'NT_ALERTTYPE_SRM_NETWARE'
-- Update query name and id for custom query alerts...
Update NotifList
set queryId = queryMapping.queryId
from #notifList NotifList inner join NTNotificationQueryMapping queryMapping with (nolock)
on queryMapping.NTNotificationId = NotifList.NTnotificationId
where NotifList.LalertTypeId = 65 -- _NT_ALERTTYPE_CUSTOM_QUERY
Update NotifList
set queryName = queryList.queryName
from #notifList NotifList inner join NTQueryList queryList with (nolock)
on NotifList.QueryId = queryList.QueryId
where NotifList.LalertTypeId = 65 -- _NT_ALERTTYPE_CUSTOM_QUERY
-- Update organization details for alerts.
UPDATE NotifList
SET organizationId = CONVERT(INT,NTNotificationProp.attrVal)
FROM #notifList NotifList
INNER JOIN NTNotificationProp WITH (NOLOCK) ON
NTNotificationProp.componentNameId=NotifList.NTnotificationId
AND attrName='OrganizationId' and modified=0
UPDATE NotifList
SET organizationId = UMSecurityAssociations.companyId
FROM #notifList NotifList
INNER JOIN UMSecurityAssociations WITH (NOLOCK) ON
UMSecurityAssociations.entityType1=64 and UMSecurityAssociations.entityId1 = NotifList.NTnotificationId
AND UMSecurityAssociations.isCreator = 1
AND (NotifList.organizationId IS NULL OR NotifList.organizationId = 0 )
AND UMSecurityAssociations.companyId> 0
UPDATE NotifList
SET organizationName = ISNULL(UMdsProviders.hostName, UMdsProviders.domainName) -- In command center, we shows hostname instead of domainName for company.
FROM #notifList NotifList
INNER JOIN UMdsProviders WITH (NOLOCK) ON UMdsProviders.id = NotifList.organizationId
AND UMdsProviders.flags & 0x0002 = 0
AND NotifList.organizationId>0
UPDATE NotifList
SET creatorId = ISNULL(creator.creatorUserId,0),creatorGroupId = ISNULL(creator.creatorUsergroupId,0)
FROM #notifList NotifList
Cross apply sec_getCreatorIdForEntity(64,NotifList.NTnotificationId , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0)creator
--if we dont get creator data from sec tables , use the one in ntnotificationrule
UPDATE NotifList
SET creatorId = notifOwner
FROM #notifList NotifList
INNER JOIN NTNotificationRule NtRule
ON NtRule.id = NotifList.NTnotificationId
WHERE NotifList.creatorId = 0 AND NotifList.creatorGroupId = 0
set @myReceiveTotal = (SELECT COUNT(*) FROM NTnotificationsByUserView NView
						INNER JOIN	#notifList NotifList ON NotifList.NtNotificationId = NView.NTnotificationId
						WHERE NView.userId = @userId AND (NotifList.organizationId = @organizationId OR @organizationId = 0)
						)
set @myCreateTotal = (SELECT count(*) FROM NTnotificationRule AS N
						INNER JOIN	#notifList NotifList ON NotifList.NtNotificationId = N.id
						WHERE  N.notifOwner = @userId AND N.revision > 0  AND (NotifList.organizationId = @organizationId OR @organizationId = 0)
						 )
DECLARE @outputXml XML
SET @outputXml = (SELECT
		@myReceiveTotal '@myReceiveTotal',
		@myCreateTotal '@myCreatedTotal' ,
		(
			SELECT NTR.description '@description', NTR.lastModified '@createdTime', NTR.notifType '@notifType', NTR.status '@status',
			ISNULL(organizationId,0) '@organizationId',
			(
				SELECT NTR.id '@id',NTR.notificationName '@name'
				FOR XML PATH('alert'),TYPE
			),
			(
				SELECT NTR.categoryId '@id', dbo.fn_EvFormatEventMsgText(0,@localeId, NTC.nameID, 0,2) '@name'
				FROM NTcategory (NOLOCK) AS NTC
				WHERE NTR.categoryId = NTC.id
				FOR XML PATH('alertCategory'),TYPE
			),
			(
SELECT CASE WHEN NTR.alertTypeId=65 THEN NL.queryId ELSE NTR.alertTypeId END as '@id',
CASE WHEN NTR.alertTypeId=65 then NL.Queryname ELSE dbo.fn_EvFormatEventMsgText(0,@localeId, NTS.nameID, 0,2) END as '@name'
				FROM NTAlertType AS NTS
				WHERE NTR.alertTypeId = NTS.id
				FOR XML PATH('alertType'),TYPE
			),
			CASE NL.creatorGroupId
				WHEN 0 THEN
				(
					SELECT NL.creatorId '@id', US.login '@name'
					FROM UMUsers AS US
					WHERE NL.creatorId = US.id
					FOR XML PATH('creator'),TYPE
				)
				ELSE
				(
					SELECT NL.creatorGroupId '@id', UG.name '@name'
					FROM UMGroups AS UG
					WHERE NL.creatorGroupId = UG.id
					FOR XML PATH('creator'),TYPE
				)
				END
			,
			(
				SELECT organizationId '@companyId', organizationName '@companyName'
				FOR XML PATH('organization'),TYPE
			)
			FROM NTnotificationRule AS NTR INNER JOIN #NotifList AS NL
			ON NTR.id = NL.NTnotificationId
			WHERE @organizationId = organizationId or @organizationId = 0
			FOR XML PATH('alertList'),TYPE
		)
	FOR XML PATH('CVGui_AlertListResp')
)
-- ----------------------------------------------------------------------------
--   RETURN RESULTS:
-- ----------------------------------------------------------------------------
if object_id('tempdb.dbo.#notifList') is not null
BEGIN
    DROP TABLE #notifList
END
select IsNull(@outputXml,'<CVGui_AlertListResp/>') as o_xml
SET NOCOUNT OFF
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  END
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
GO

IF EXISTS (select * from GxQscripts where name = 'br_NTalertList')
	delete from GxQscripts where name = 'br_NTalertList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_NTalertList')
	delete from GXDBVersions where aliasname = 'br_NTalertList'
GO

insert into GXDBVersions values(2, 'br_NTalertList',  '00010027001200100000', 'br_NTalertList', '00010027001200100000')
GO

