

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/br_NTUpdateAlertLiveFeedStatus.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/br_NTUpdateAlertLiveFeedStatus.sp,v $ $Id: br_NTUpdateAlertLiveFeedStatus.sp,v 1.12.60.3 2018/03/27 08:09:09 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 						SP: " br_NTUpdateAlertLiveFeedStatus"							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: br_NTUpdateAlertLiveFeedStatus <<<'

IF EXISTS (select * from sysobjects where name='br_NTUpdateAlertLiveFeedStatus')
	drop procedure br_NTUpdateAlertLiveFeedStatus
IF EXISTS (select * from GxQscripts where name='br_NTUpdateAlertLiveFeedStatus')
	delete from GxQscripts where name = 'br_NTUpdateAlertLiveFeedStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_NTUpdateAlertLiveFeedStatus')
	delete from GXDBVersions where aliasname = 'br_NTUpdateAlertLiveFeedStatus'
GO
print '... Creating Procedure: br_NTUpdateAlertLiveFeedStatus'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure br_NTUpdateAlertLiveFeedStatus
  @input xml
AS
  DECLARE @outXmlStr xml	
DECLARE @livefeedId BIGINT
DECLARE @liveFeedStatus INTEGER
DECLARE @userId INTEGER
DECLARE @notes nvarchar(max)
DECLARE @errorCode INTEGER = 0
DECLARE @errorMessage nvarchar(1024)
	  SET @userId  = ISNULL((SELECT ref.value('@userId','INTEGER') AS data FROM @input.nodes('App_UpdateLiveFeedListStatusReq/processinginstructioninfo/user') R ( ref )),1)
BEGIN TRY
	DECLARE @tempTable TABLE(userid integer,data xml)
	CREATE TABLE #tempListTbl (liveFeedId INTEGER, LiveFeedStatus INTEGER,feedNotes NVARCHAR(max))
	INSERT INTO #tempListTbl
	SELECT DISTINCT
	R.col.value('@liveFeedId','INTEGER'),
	ISNULL(R.col.value('@status','INTEGER'),0),
	R.col.value('@notes','nvarchar(max)')
	FROM @input.nodes('App_UpdateLiveFeedListStatusReq/updateFeedsList') as R(col)
	MERGE NTLiveFeedsStatus as fsts
	USING (SELECT liveFeedId,LiveFeedStatus,feedNotes FROM #tempListTbl) as tmp
	ON fsts.liveFeedsId = tmp.liveFeedId AND fsts.userId = @userId
	WHEN MATCHED THEN UPDATE SET fsts.liveFeedStatus = tmp.LiveFeedStatus,fsts.notes = case when tmp.feedNotes is not null then tmp.feedNotes else fsts.notes end;
	SET @outXmlStr = (SELECT liveFeedsId as '@liveFeedId', ISNULL(liveFeedStatus,0) as '@status',ISNULL(notes,'') as '@notes'
			 FROM NTLiveFeedsStatus with (nolock) where userId = @userId AND liveFeedsId IN (SELECT liveFeedId FROM #tempListTbl)
			 FOR XML PATH('feedsList'))
		INSERT INTO @tempTable
			SELECT @userId,@outXmlStr
		--SELECT * from @tempTable
SET @outXmlStr = (SELECT(SELECT COUNT(liveFeedsId) FROM NTLiveFeedsStatus
							WHERE userId = @userId AND (liveFeedStatus & 8) <>0 ) as  'App_LiveFeedListResp/@numberOfNewAlert',
						  data AS 'App_LiveFeedListResp' FROM @tempTable WHERE userid = @userId
				  FOR XML PATH (''))
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
SET @outXmlStr = (SELECT  1 AS '@errorCode', 'Error occured while modifying livefeed status' AS '@errorMessage' FOR XML PATH ( 'CVGui_GenericResp' ))
END CATCH
SELECT @outXmlStr
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'br_NTUpdateAlertLiveFeedStatus')
	delete from GxQscripts where name = 'br_NTUpdateAlertLiveFeedStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_NTUpdateAlertLiveFeedStatus')
	delete from GXDBVersions where aliasname = 'br_NTUpdateAlertLiveFeedStatus'
GO

insert into GXDBVersions values(2, 'br_NTUpdateAlertLiveFeedStatus',  '00010012006000030000', 'br_NTUpdateAlertLiveFeedStatus', '00010012006000030000')
GO

