

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/br_NTPerformAlertOp.sp] ---------- 

-- -------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/br_NTPerformAlertOp.sp,v $ $Id: br_NTPerformAlertOp.sp,v 1.3.56.6 2020/11/27 16:58:30 kbora Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   br_NTPerformAlertOp   - Enable/Disable an Alert
--	-------------------------------------------------------
--	-- Error Codes:
--	--	0 -Success (alert deleted)
--	--      1 -Alert Nonexistent
--	--      2 -Constraint Violation (should never get this)
--	-------------------------------------------------------
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='br_NTPerformAlertOp')
BEGIN
	print '>>> Drop Stored Procedure: br_NTPerformAlertOp <<<'
	drop procedure br_NTPerformAlertOp
END
IF EXISTS (select * from GxQscripts where name='br_NTPerformAlertOp')
	delete from GxQscripts where name = 'br_NTPerformAlertOp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_NTPerformAlertOp')
	delete from GXDBVersions where aliasname = 'br_NTPerformAlertOp'
GO
print '... Creating Procedure: br_NTPerformAlertOp'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure br_NTPerformAlertOp
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @callerID int,
  @alertId int,
  @locale int,
  @opId int
AS
SET NOCOUNT ON
declare @errorCode	int
declare @sqlError       int
declare @errorString	nvarchar(1024)
declare @alertName      nvarchar(255)
set @errorCode = 0
declare @opMessageId  int
declare @opMsgId      int = 0
declare @oldStatus    int = 0
declare @auditID	  int
declare @opEvMsgId	  int
declare @paramMsgId   int
if (@opId=1)
begin
set @opMessageId = (1391 | (CAST(POWER(2, 24) AS BIGINT) * 83))
end
else
begin
set @opMessageId = (1390 | (CAST(POWER(2, 24) AS BIGINT) * 83))
end
DECLARE @workTokenId		AS  INTEGER	 = 47 -- WORK_TOKEN_REFRESH_ALERT_CONFIG
BEGIN TRAN
------------------------------
-- MAKE SURE ALERT EXISTS:	--
------------------------------
IF NOT EXISTS (select * from NTnotificationRule WHERE id = @alertId  and revision=1  )
BEGIN
set @errorCode = CAST(0x0B0003 AS INT)
set @errorString = dbo.fn_EvFormatEventMsgText(0,@locale, (143 | (CAST(POWER(2, 24) AS BIGINT) * 74)), 0,2)
	goto PERFORM_ALERTOP_EXIT
END
ELSE
	SELECT @alertName = notificationName, @oldStatus = status from NTnotificationRule WHERE id = @alertId
DECLARE  @alertTypeId		AS  integer	 = ISNULL((select top 1 alertTypeId from NTnotificationRule where id=@alertId),0)
------------------------------------------------------------------------------------
--  CHECK FOR THE RIGHTS! --
------------------------------------------------------------------------------------
--Only users with 'Edit Alert' permission on the alert can enable/disable the alert
DECLARE @userHasRight INT = 0
EXEC sec_checkPermissionOnEntity @callerID, 152, @userHasRight OUTPUT, 64, @alertId
IF @userHasRight = 0
BEGIN
SET @errorCode = (2409 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2409 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale)
    SET @errorString = REPLACE(@errorString, '^1%s', ISNULL((SELECT login FROM UMUsers WHERE id = @callerID),''))
SET @errorString = REPLACE(@errorString, '^2%s', (SELECT message FROM EvLocaleMsgs WHERE messageId = (2815 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale))
    SET @errorString = REPLACE(@errorString, '^3%s', @alertName)
SET @errorString = REPLACE(@errorString, '^4%s', (SELECT message FROM EvLocaleMsgs WHERE messageId = (2812 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale))
    GOTO PERFORM_ALERTOP_EXIT
END
-- -------------------------------------------------------------------------------
-- DELETES ARE NOW ALL LOGICAL, PHYSICAL DELETION WOULD REQUIRE A "PURGE" SP	--
-- -------------------------------------------------------------------------------
if @opId=1	--Alert disabled
begin
UPDATE NTnotificationRule set status = status | 1
		WHERE id = @alertId AND revision > 0
IF (@oldStatus & 1) <> 1
	BEGIN
SET @opMsgId= (576 | (CAST(POWER(2, 24) AS BIGINT) * 84))
SET @paramMsgId=(1573 | (CAST(POWER(2, 24) AS BIGINT) * 85))
	END
end
else
begin
UPDATE NTnotificationRule set status = status - 1
WHERE id = @alertId AND revision > 0 and (status & 1)>0
IF (@oldStatus & 1) = 1
		BEGIN
SET @opMsgId= (577 | (CAST(POWER(2, 24) AS BIGINT) * 84))
SET @paramMsgId=(1574 | (CAST(POWER(2, 24) AS BIGINT) * 85))
		END
end
set @sqlError = @@error
if @sqlError <> 0
BEGIN
	set @errorCode = 2
set @errorString = dbo.fn_EvFormatEventMsgText(0,@locale, (172 | (CAST(POWER(2, 24) AS BIGINT) * 74)), 0,2) + N' : ' + @alertName
	goto PERFORM_ALERTOP_EXIT
END
ELSE
	set @errorString = dbo.fn_EvFormatEventMsgText(0,@locale,@opMessageId, 0,2) + N' : ' + @alertName
-- Check if its failover configuration alert and send workqueue request to all failover nodes.
INSERT INTO APP_WorkQueueRequest (clientId, workToken, workTokenParams, createTime, lastUpdateTime, retryCount, flag, remoteClient)
SELECT C.Id,
	@workTokenId,
	'',
	dbo.GetUnixTime(GetUTCDate()), 0, 0, 0, -1
	FROM SimInstalledPackages  WITH (READUNCOMMITTED)
    INNER JOIN App_client C WITH (READUNCOMMITTED) ON SimInstalledPackages.clientId = C.Id
AND (C.status&2)=0 and simPackageID IN (24, 1024)
	INNER JOIN NTAlertType WITH (READUNCOMMITTED) ON NTAlertType.ID = @alertTypeID
AND  ( NTAlertType.actionsAllowed & 1024 ) > 0
IF(@opMsgId<>0)
BEGIN
	EXEC EvGuiAuditSetOperation @opMsgId, @callerID, @opEvMsgId OUTPUT, @auditID OUTPUT
	EXEC EvGuiAuditSetParamData @auditID, @alertName, 0
	EXEC EvGuiAuditSetParameter @auditID, @paramMsgId, @callerID
END
PERFORM_ALERTOP_EXIT:
select (
	SELECT	1			         as TAG,
		NULL		         as Parent,
		@errorCode			     as [CVGui_GenericResp!1!errorCode],
		@errorString	         as [CVGui_GenericResp!1!errorMessage]
	FOR XML EXPLICIT
) as o_responseXML
if (@errorCode = 0)
    COMMIT TRAN
else
    ROLLBACK TRAN
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'br_NTPerformAlertOp')
	delete from GxQscripts where name = 'br_NTPerformAlertOp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_NTPerformAlertOp')
	delete from GXDBVersions where aliasname = 'br_NTPerformAlertOp'
GO

insert into GXDBVersions values(2, 'br_NTPerformAlertOp',  '00010003005600060000', 'br_NTPerformAlertOp', '00010003005600060000')
GO

