

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/br_NTMsgTemplatesForAlert.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/br_NTMsgTemplatesForAlert.sp,v $ $Id: br_NTMsgTemplatesForAlert.sp,v 1.9.70.2 2018/07/17 21:01:38 mnatarajan Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   br_NTMsgTemplatesForAlert
--					 - Fetch the template messages for the given alertType and locale
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: br_NTMsgTemplatesForAlert <<<'

IF EXISTS (select * from sysobjects where name='br_NTMsgTemplatesForAlert')
	drop procedure br_NTMsgTemplatesForAlert
IF EXISTS (select * from GxQscripts where name='br_NTMsgTemplatesForAlert')
	delete from GxQscripts where name = 'br_NTMsgTemplatesForAlert'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_NTMsgTemplatesForAlert')
	delete from GXDBVersions where aliasname = 'br_NTMsgTemplatesForAlert'
GO
print '... Creating Procedure: br_NTMsgTemplatesForAlert'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure br_NTMsgTemplatesForAlert
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @alertTypeId int,
  @localeId int,
  @queryId int,
  @xmlInput XML
AS
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  BEGIN
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--Message 1024 AlertMsgsForLocaleResp
--{
--    list<AlertNotifMsg> msgs
--    list<AlertNotifToken> tokenList
--}
--Message 7 AlertNotifMsg
--{
--    int             notifType       -- e-mail, pager, snmp, event viewer, send command
--    int             esclationLevel      -- 1 = regular
--    int             localeId            -- the locale the message is in...
--    wstring         notifMessage
--}
--Message 5 AlertNotifToken
--{
--    int         tokenId
--    wstring     tokenFormat
--    int         flag
--}
declare @brAlertTrace			varchar(256)
set @brAlertTrace				=(select value from gxglobalParam Where name = 'bralertTrace')
set @brAlertTrace               = ISNULL(@brAlertTrace, 0)
DECLARE @nowTime				datetime
-- Create a new temp table which has all messages modified for custom query
declare @NTnotificationTemplateTemp table
(
	NTalertTypeID		    integer,       -- Drives offline, Commcells unreachable ....
    messageType             integer,       -- email, pager, etc ...
    locale                  integer,       -- i.e. "EN_US".. Replaced w/FK To a Locale Lookup Table?  Yes
    defaultformatString     nvarchar(MAX), -- Default Format string for the message
	messageFormatType			integer
)
DECLARE @AlertCriteriaList table
(
	criteriaID		    integer       -- Drives offline, Commcells unreachable ....
)
INSERT INTO @AlertCriteriaList
SELECT ref.value('@val', 'int') AS Agent
FROM @xmlInput.nodes('CVGui_AlertMsgsForLocaleReq/alertCriteria') R ( ref )
Insert into @NTnotificationTemplateTemp(NTalertTypeID,messageType,locale,defaultformatString,messageFormatType)
select NTalertTypeID,messageType,locale,defaultformatString,messageFormatType
from NTnotificationTemplate N1
WHERE N1.NTalertTypeID = @alertTypeId and N1.locale = @localeId
if (@alertTypeId = 65)
begin
	exec NTGetDefaultTemplateForQuery @queryId,@localeId,''
	return
end
----------------------------------------------------------
--	Optionally Log Input Paramters						--
----------------------------------------------------------
if @brAlertTrace <> 0
BEGIN
	SET @nowTime		=getDate()
	SET @brAlertTrace	='alertType(' + CONVERT(varchar(5), @alertTypeId) + '), localeId(' + CONVERT(varchar(5), @localeId) + ').'
	exec br_ntTrace '.. br_NTMsgTemplatesForAlert', 0, @nowTime, 0, 0, @brAlertTrace
END
-- ----------------------------------------------------------------------------
--   BEGIN
-- ----------------------------------------------------------------------------
DECLARE @alertTemplateResp XML
SET @alertTemplateResp = (SELECT * FROM
	(SELECT	1			         as TAG,
	NULL			         as Parent,
	NULL			         as [CVGui_AlertMsgsForLocaleResp!1],
	NULL					 as [msgs!2!notifType],
	NULL					 as [msgs!2!notifMessage],
	NULL					 as [msgs!2!localeID],
	NULL					 as [msgs!2!esclationLevel],
	NULL					 as [msgs!2!notifMessageHtml],
	NULL					 as [tokenList!3!tokenId],
	NULL					 as [tokenList!3!tokenFormat],
	NULL					 as [tokenList!3!flag]
UNION ALL
----------------------------------
--Load the alert type format string
----------------------------------
SELECT	DISTINCT 2, 1, NULL,
    messageType,
    (select defaultformatString
		from @NTnotificationTemplateTemp N1
		WHERE N1.NTalertTypeID = @alertTypeId and N1.locale = @localeId and
		N1.messageType = NTnotificationTemplate.messageType
		and N1.messageFormatType=0
	),
    locale,
    1,
    (select defaultformatString
		from @NTnotificationTemplateTemp N1
		WHERE N1.NTalertTypeID = @alertTypeId and N1.locale = @localeId and
		N1.messageType = NTnotificationTemplate.messageType
		and N1.messageFormatType=1
	),
    NULL,		NULL,	NULL
	FROM NTnotificationTemplate
	WHERE
	NTalertTypeID = @alertTypeId and locale = @localeId
UNION ALL
SELECT DISTINCT	3, 1, NULL,
	NULL, NULL,NULL,NULL,NULL,
    NTOKEN.tokenID, dbo.fn_EvFormatEventMsgText(0,@localeId, NTOKEN.tokenID, 0,2), NTOKEN.flag
	FROM NTavailCriteria AS NTAC, NTAlertType as NTS,  NTmessageTokensForAlert NTOKEN
	WHERE
	NTAC.alertTypeId = NTS.id and NTOKEN.availcriteriaId = NTAC.id
	and NTS.id = @alertTypeId
	AND (NOT EXISTS(SELECT 1 FROM @AlertCriteriaList)
		OR
		EXISTS(SELECT 1 FROM @AlertCriteriaList AlertCriteriaList WHERE NTAC.criteriaId = AlertCriteriaList.criteriaID)
	)
	) SUB
--ORDER BY  [alertTypeList!3!alertTypeId], [availCriteriaList!4!id!hide], TAG
FOR XML EXPLICIT
)
DECLARE @notifTypesSupportedList TABLE
(
	notifType INT PRIMARY KEY(notifType)
)
INSERT INTO @notifTypesSupportedList
SELECT 1 -- Email
UNION ALL
SELECT 4 -- SNMP
UNION ALL
SELECT 8 -- Windows event viewer.
UNION ALL
SELECT 16 -- Run command
UNION
SELECT 512 -- Save to disk
UNION
SELECT 1024 -- RSS
UNION
SELECT 8192 --Console Alerts
UNION
SELECT 65536 --Workflow
UNION
SELECT 32768 --Scom
DECLARE @NotifTypesAllowed INT = 0
SELECT @NotifTypesAllowed = notifTypesallowed FROM NTAlertType WITH (nolock) WHERE Id = @alertTypeId
DECLARE @notifTypesAllowedXML XML
SET @notifTypesAllowedXML = (SELECT notifType '@val' FROM @notifTypesSupportedList
	WHERE (notifType&@NotifTypesAllowed)>0
	FOR XML PATH('notifTypesSupported') )
SET @alertTemplateResp.modify('insert sql:variable("@notifTypesAllowedXML") as first into (/CVGui_AlertMsgsForLocaleResp)[1]')
SELECT @alertTemplateResp as o_responseXML
SET NOCOUNT OFF
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  END
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
GO

IF EXISTS (select * from GxQscripts where name = 'br_NTMsgTemplatesForAlert')
	delete from GxQscripts where name = 'br_NTMsgTemplatesForAlert'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_NTMsgTemplatesForAlert')
	delete from GXDBVersions where aliasname = 'br_NTMsgTemplatesForAlert'
GO

insert into GXDBVersions values(2, 'br_NTMsgTemplatesForAlert',  '00010009007000020000', 'br_NTMsgTemplatesForAlert', '00010009007000020000')
GO

