

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/br_NTGetLiveFeedAlert.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/br_NTGetLiveFeedAlert.sp,v $ $Id: br_NTGetLiveFeedAlert.sp,v 1.18.40.2 2018/06/13 17:33:42 prakash Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 						Procedure: "br_NTGetLiveFeedAlert"				|
-- 	+-----------------------------------------------------------------------+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: br_NTGetLiveFeedAlert <<<'

IF EXISTS (select * from sysobjects where name='br_NTGetLiveFeedAlert')
	drop procedure br_NTGetLiveFeedAlert
IF EXISTS (select * from GxQscripts where name='br_NTGetLiveFeedAlert')
	delete from GxQscripts where name = 'br_NTGetLiveFeedAlert'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_NTGetLiveFeedAlert')
	delete from GXDBVersions where aliasname = 'br_NTGetLiveFeedAlert'
GO
print '... Creating Procedure: br_NTGetLiveFeedAlert'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure br_NTGetLiveFeedAlert
  @lastliveid integer = 0,
  @userId integer =0,
  @liveFeedIntervalInSec integer = 172800,
  @numFeedsToSend integer = 200,
  @requestStatus integer = 0,
  @pageStartId integer = 1,
  @pageCount integer = 1,
  @lastLiveFeedIdSend integer = 0
AS
  DECLARE @xmlStr xml
SET NOCOUNT ON
DECLARE @now as integer = dbo.GetUnixTime(GETDATE())
DECLARE @lastFeedTime integer = @now
DECLARE @lastFeed integer = @lastliveid
DECLARE @tempTable TABLE(userid integer,data xml)
DECLARE @totalNoOfAlerts integer
DECLARE @pageCapacity integer
CREATE TABLE #tmpUserLiveFeedsStatus
(
	liveFeedsId int,
	userId 	   int,
	liveFeedStatus int,
	notes 		nvarchar(max),
	primary key (liveFeedsId),
)
IF @liveFeedIntervalInSec = 0
BEGIN
SET @liveFeedIntervalInSec = 172800
END
SET @lastFeedTime = @now - @liveFeedIntervalInSec
SET @pageCapacity = CAST (CAST (ISNULL((SELECT value FROM App_AdvanceSettings where keyName like 'NTConsoleAlertPageSize' and relativePath like 'CommServDB.Console' and deleted <> 1 and enabled = 1),'200') as nvarchar(max)) as INT)
IF @pageCapacity = 0
BEGIN
SET @pageCapacity = 200
END
DECLARE @FeedCount2days INTEGER = 0
DECLARE @newLastFeedId INTEGER =0
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED;
SET @FeedCount2days = (SELECT COUNT(*) FROM NTLiveFeedsMessageHistory WHERE created > @lastFeedTime)
IF @FeedCount2days > @numFeedsToSend
BEGIN
	DECLARE @minidTbl TABLE(liveid integer)
	INSERT INTO @minidTbl
		SELECT TOP (@numFeedsToSend) LiveFeedId FROM NTLiveFeedsMessageHistory hist LEFT JOIN NTLiveFeedsStatus st with (nolock) ON hist.LiveFeedId = st.liveFeedsId
			 WHERE hist.created > @lastFeedTime AND (st.liveFeedStatus <> 1 OR st.liveFeedStatus IS NULL) ORDER BY LiveFeedId DESC
	SET @lastFeedTime = ISNULL((SELECT created FROM NTLiveFeedsMessageHistory
							WHERE LiveFeedId = (SELECT MIN(liveid)FROM @minidTbl)),@lastFeedTime)
END
IF @lastliveid = 0
BEGIN
	IF @userId <> 0
		SET @lastliveid = ISNULL((SELECT MAX(LiveFeedId) FROM NTLiveFeedsMessageHistory WHERE created > @lastFeedTime),0)
	ELSE
		SET @lastliveid = (ISNULL((SELECT MIN(LiveFeedId) FROM NTLiveFeedsMessageHistory WHERE created > @lastFeedTime),0)-1)
END
IF @userId = 0
BEGIN
SET @newLastFeedId = (SELECT MAX(LiveFeedId) FROM NTLiveFeedsMessageHistory)
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED;
INSERT INTO @tempTable
SELECT DISTINCT U.id,
(SELECT DISTINCT hist.LiveFeedId as '@liveFeedId',
                                    (SELECT notificationName FROM NTnotificationRule WHERE id = hist.NTnotificationID) as '@alertName',
                                    hist.NTnotificationID as '@ntNotificationId',
                                    (hist.escalationLevel & 0x0000FFFF) as '@escalationLevel',
                                    JobId as '@jobId',
                                    messageFormatType as '@messageFormatType',
                                    stat.liveFeedStatus as '@status',
									(hist.escalationLevel & 0xFFFF0000)/ POWER(2,17) as '@severity',
                                    ((dbo.NTGetCategoryName(hist.NTnotificationID,0))+N'-'+ AlertType) as '@alertType',
                                    AlertCriteria as '@alertcriteria',
                                    --Description as '@description',
                                    ISNULL(stat.notes,'') as '@notes',
                                    DetectedTime as 'detectedTime/@timeValue',
                                    created as 'detectedTime/@time',
                                    ClientId as 'client/@clientId',
                                    (select c1.name from APP_Client c1 where c1.id = ClientId) as 'client/@clientName',
                                    (select c1.displayname from APP_Client c1 where c1.id = ClientId) as 'client/@displayName'
FROM NTLiveFeedsMessageHistory hist INNER JOIN NTLiveFeedsStatus stat with (nolock) ON hist.LiveFeedId = stat.LiveFeedsId AND stat.userId = U.id
where (hist.LiveFeedId >= @lastliveid +1 )
ORDER BY hist.LiveFeedId DESC
--and (stat.liveFeedStatus <> 1 OR stat.liveFeedStatus IS NULL)
--gWHERE hist.NTnotificationID = usr.NTnotificationID AND (hist.LiveFeedId > 0  OR hist.created > 0)
FOR XML PATH('feedsList')) as c
FROM UMUsers U
where U.id in
(
      select distinct ntu.userId
      from NTLiveFeedsStatus as ntu
)
END
ELSE IF @userId <> 0
BEGIN
SET @newLastFeedId = @lastliveid
DECLARE @minLastliveid INTEGER = (SELECT MIN(LiveFeedId)
						FROM NTLiveFeedsMessageHistory hist INNER JOIN NTLiveFeedsStatus stat with (nolock)
							ON hist.LiveFeedId = stat.LiveFeedsId AND stat.userId = @userId WHERE hist.created > @lastFeedTime AND hist.LiveFeedId <= @lastliveid)
--print @minLastliveid
SET @newLastFeedId = (SELECT MAX(LiveFeedId) FROM NTLiveFeedsMessageHistory hist INNER JOIN NTLiveFeedsStatus stat with (nolock) ON hist.LiveFeedId = stat.LiveFeedsId AND stat.userId = @userId)
INSERT INTO #tmpUserLiveFeedsStatus
			SELECT  * FROM NTLiveFeedsStatus with (nolock)
				WHERE ((@requestStatus <> 2 AND ((((liveFeedsId > @minLastliveid-1 AND liveFeedsId <= @newLastFeedId) AND (LiveFeedStatus <> 1)))
						OR ((liveFeedStatus & 2) <> 0 OR (liveFeedStatus & 8) <> 0 OR (liveFeedStatus = 0) OR (liveFeedStatus IS NULL))))
						OR (@requestStatus = 2 AND (liveFeedStatus & 8) <> 0)) AND userId = @userId
				ORDER BY LiveFeedsId DESC
SET @totalNoOfAlerts = (SELECT COUNT (DISTINCT liveFeedsId) FROM #tmpUserLiveFeedsStatus)
IF @lastLiveFeedIdSend  <> 0
BEGIN
--Delete already send alerts
	DELETE FROM #tmpUserLiveFeedsStatus WHERE  liveFeedsId >= @lastLiveFeedIdSend
-- not considering the value of page start
	SET @pageStartId = 1
END
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED;
INSERT INTO @tempTable
SELECT DISTINCT U.id,
(SELECT DISTINCT LiveFeedId as '@liveFeedId',
                                    (SELECT notificationName FROM NTnotificationRule WHERE id = NTnotificationID) as '@alertName',
                                    NTnotificationID as '@ntNotificationId',
                                    (escalationLevel & 0x0000FFFF) as '@escalationLevel',
                                    JobId as '@jobId',
                                    messageFormatType as '@messageFormatType',
                                    liveFeedStatus as '@status',
                                    (escalationLevel & 0xFFFF0000)/ POWER(2,17) as '@severity',
                                    ((dbo.NTGetCategoryName(NTnotificationID,0))+N' - '+AlertType) as '@alertType',
                                    AlertCriteria as '@alertcriteria',
                                    --Description as '@description',
                                    ISNULL(notes,'') as '@notes',
                                    DetectedTime as 'detectedTime/@timeValue',
                                    created as 'detectedTime/@time',
                                    ClientId as 'client/@clientId',
                                    (select c1.name from APP_Client c1 where c1.id = ClientId) as 'client/@clientName',
                                    (select c1.displayname from APP_Client c1 where c1.id = ClientId) as 'client/@displayName'
                                    --    for xml path('client')
                                    --as 'node()'
FROM (SELECT *,ROW_NUMBER() OVER (ORDER BY LiveFeedId DESC) as rowNo
	  FROM NTLiveFeedsMessageHistory  INNER JOIN #tmpUserLiveFeedsStatus with (nolock) ON LiveFeedId = LiveFeedsId) as t1
WHERE rowNo > ((@pageStartId-1)*@pageCapacity) AND rowNo <= ((@pageCount+@pageStartId-1)*@pageCapacity)
ORDER BY LiveFeedId DESC
FOR XML PATH('feedsList')) as c
FROM UMUsers U WHERE U.id = @userId
END
DELETE FROM  @tempTable WHERE data IS NULL
--SELECT * FROM @tempTable
CREATE TABLE  #finalnvarchar (userid integer,xdats nvarchar(max),newcnt nvarchar(80))
INSERT INTO #finalnvarchar
SELECT
  userid,CONVERT(nvarchar(max),(SELECT
		(SELECT COUNT(liveFeedsId) FROM NTLiveFeedsStatus with (nolock)
				WHERE userId = Result.userid AND (liveFeedStatus & 8) <>0 ) as  'App_LiveFeedListResp/@numberOfNewAlert',
				CONVERT(nvarchar(max),@totalNoOfAlerts) as 'App_LiveFeedListResp/@totalNoOfAlerts',
     (CASE WHEN @requestStatus = 2 THEN NULL ELSE data END) AS 'App_LiveFeedListResp'
    FROM @tempTable
    WHERE userid = Result.userid
    FOR XML PATH (''))),''
FROM @tempTable Result
GROUP BY userid
--select * from #finalnvarchar
--select CONVERT(xml,xdats) from #finalnvarchar
SET @xmlStr = (SELECT @newLastFeedId AS '@lastFeedId', userid as '@userId',xdats as '@feedsList' FROM #finalnvarchar
FOR XML PATH('useridFeed'),ROOT('App_LiveFeedUserIdDataMap'))
SELECT ISNULL(@xmlStr,'<App_LiveFeedUserIdDataMap></App_LiveFeedUserIdDataMap>')
GO

IF EXISTS (select * from GxQscripts where name = 'br_NTGetLiveFeedAlert')
	delete from GxQscripts where name = 'br_NTGetLiveFeedAlert'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_NTGetLiveFeedAlert')
	delete from GXDBVersions where aliasname = 'br_NTGetLiveFeedAlert'
GO

insert into GXDBVersions values(2, 'br_NTGetLiveFeedAlert',  '00010018004000020000', 'br_NTGetLiveFeedAlert', '00010018004000020000')
GO

