

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/br_NTAlertStaticInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/br_NTAlertStaticInfo.sp,v $ $Id: br_NTAlertStaticInfo.sp,v 1.30.64.16 2019/10/08 23:02:34 vdevassy Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   br_NTAlertStaticInfo   - Fetch the (short) list of currently defined alert
--                      notifications.
--
--                      If alertGroup is set to 1, retrieve all alerts, if
--                      set to 2, retrieve only alerts user owns or is targeted
--                      to be a recepient of (currently not implemented)
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='br_NTAlertStaticInfo')
BEGIN
	print '>>> Drop Stored Procedure: br_NTAlertStaticInfo <<<'
	drop procedure br_NTAlertStaticInfo
END
IF EXISTS (select * from GxQscripts where name='br_NTAlertStaticInfo')
	delete from GxQscripts where name = 'br_NTAlertStaticInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_NTAlertStaticInfo')
	delete from GXDBVersions where aliasname = 'br_NTAlertStaticInfo'
GO
print '... Creating Procedure: br_NTAlertStaticInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure br_NTAlertStaticInfo
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @userID int,
  @localeId int,
  @inpCategoryId int,
  @inpAlertTypeId int
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
-- Check whether any query is visible for this user.
-- If no query is visible then we dont show the NT_CATEGORY_CUSTOM_ALERT category at all.
declare @IsCustomQueryShown int
set @IsCustomQueryShown = 0
declare @queryResponseXml table
(
	queryResponse xml
)
declare @queryReqXml nvarchar(max)
set @queryReqXml = '<App_GetQueryListForAlertsReq>
	<listOptions allEntities="1" propertyLevel="1"/><processinginstructioninfo>
		<user userId="'+convert(nvarchar(max),@userID) +'"/>
	</processinginstructioninfo>
</App_GetQueryListForAlertsReq>'
Insert into @queryResponseXml
exec br_ntGetCustomQueryProperties @queryReqXml
select @IsCustomQueryShown = queryResponse.exist('App_GetQueryListForAlertsResp/queryEntities')
from @queryResponseXml
if (@IsCustomQueryShown is null)
begin
	set @IsCustomQueryShown = 0
end
declare @NTcategory table
(
       id                   integer                           NOT NULL,
       name          nvarchar(max)        NOT NULL,
       nameID        BIGINT                     NOT NULL,
	   PRIMARY KEY(Id)
)
Insert into @NTcategory
select * from NTCategory
where (id <> 9 OR @IsCustomQueryShown>0)
and id in
(
       select CategoryId from NTAlertType NTA
where NTA.id <> 49
AND NTA.actionsAllowed <> 8
)
-- If we have specific categoryId input to this SP, then we return only this category.
IF (@inpCategoryId<>0)
BEGIN
	DELETE FROM @NTcategory
	WHERE id <> @inpCategoryId
END
DECLARE @errorCode INT = 0
DECLARE @errorString NVARCHAR(MAX) = ''
DECLARE @isCSAdmin INT = 0
-- In case user isnt Admin at CS level, then we dont show him entity tree node.
EXEC br_NTPermCheck @userID, @localeId, 1, 2018, 2, @errorCode OUTPUT, @errorString OUTPUT --EV_SCHEDULE_ADMIN
IF (@errorCode=0)
BEGIN
	SET @isCSAdmin = 1
END
DECLARE @NTalertType TABLE
(
       id                   integer              NOT Null,
       name          nvarchar(max) NOT Null,
       nameID        BIGINT        NOT Null,
       categoryID                        integer       NOT Null,
       notifTypesAllowed          integer       NOT Null,
       actionsAllowed                    integer       NOT Null,
       description                       integer       NULL,
       license                                  integer NULL,
	   PRIMARY KEY (id)
)
INSERT INTO @NTalertType
SELECT id,name,nameID,categoryID,notifTypesAllowed,actionsAllowed,description,license FROM NTAlertType
WHERE id <> 49
AND actionsAllowed <> 8
AND CategoryId in
(
       SELECT id from @NTcategory
)
-- If we have specific alertType input to this SP, then we return only these alertType.
AND (@inpAlertTypeId = 0 OR id = @inpAlertTypeId)
DECLARE @NTalertNodeTypeMap TABLE
(
    NTalertTypeID    integer ,        -- FK Key to NTalertType table
    nodeType         integer ,
    nameID           BIGINT  ,        -- message id to get the localized node name
    parentNodeType   integer ,
    flag			 integer
	PRIMARY KEY (NTalertTypeID,nodeType,parentnodeType)
)
INSERT INTO @NTalertNodeTypeMap
SELECT NTalertTypeID, nodeType,nameID,parentNodeType, flag  FROM NTalertNodeTypeMap
WHERE (@isCSAdmin = 1 OR NTalertTypeID <> 65)
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  BEGIN
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
-- ----------------------------------------------------------------------------
--   BEGIN
-- ----------------------------------------------------------------------------
DECLARE @genericEntityDefMapping TABLE
   (
    nodeType               INT,
	nodeNameDef            nvarchar(200),
    idNameDef              nvarchar(200)
   )
INSERT INTO @genericEntityDefMapping (nodeType, nodeNameDef, idNameDef) VALUES (1, 'commCellName', 'commCellId')
INSERT INTO @genericEntityDefMapping (nodeType, nodeNameDef, idNameDef) VALUES (28, 'clientGroupName', 'clientGroupId')
INSERT INTO @genericEntityDefMapping (nodeType, nodeNameDef, idNameDef) VALUES (3, 'clientName', 'clientId')
INSERT INTO @genericEntityDefMapping (nodeType, nodeNameDef, idNameDef) VALUES (4, 'appName', 'applicationId')
INSERT INTO @genericEntityDefMapping (nodeType, nodeNameDef, idNameDef) VALUES (5, 'instanceName', 'instanceId')
INSERT INTO @genericEntityDefMapping (nodeType, nodeNameDef, idNameDef) VALUES (6, 'backupsetName', 'backupsetId')
INSERT INTO @genericEntityDefMapping (nodeType, nodeNameDef, idNameDef) VALUES (7, 'subclientName', 'subclientId')
INSERT INTO @genericEntityDefMapping (nodeType, nodeNameDef, idNameDef) VALUES (9, 'libraryName', 'libraryId')
INSERT INTO @genericEntityDefMapping (nodeType, nodeNameDef, idNameDef) VALUES (11, 'mediaAgentName', 'mediaAgentId')
INSERT INTO @genericEntityDefMapping (nodeType, nodeNameDef, idNameDef) VALUES (21, 'trackingPolicyName', 'trackingPolicyId')
INSERT INTO @genericEntityDefMapping (nodeType, nodeNameDef, idNameDef) VALUES (17, 'storagePolicyName', 'storagePolicyId')
INSERT INTO @genericEntityDefMapping (nodeType, nodeNameDef, idNameDef) VALUES (18, 'copyName', 'copyId')
INSERT INTO @genericEntityDefMapping (nodeType, nodeNameDef, idNameDef) VALUES (96, 'criteriaName', 'criteriaId')
INSERT INTO @genericEntityDefMapping (nodeType, nodeNameDef, idNameDef) VALUES (83, 'workflowName', 'workflowId')
INSERT INTO @genericEntityDefMapping (nodeType, nodeNameDef, idNameDef) VALUES (1, 'commCellName', 'commCellId')
INSERT INTO @genericEntityDefMapping (nodeType, nodeNameDef, idNameDef) VALUES (124, 'commCellName', 'commCellId')
INSERT INTO @genericEntityDefMapping (nodeType, nodeNameDef, idNameDef) VALUES (15, 'userGroupName', 'userGroupId')
INSERT INTO @genericEntityDefMapping (nodeType, nodeNameDef, idNameDef) VALUES (13, 'userName', 'userId')
INSERT INTO @genericEntityDefMapping (nodeType, nodeNameDef, idNameDef) VALUES (7987, 'shareName', 'shareId')
-- Modifying @alertStaticInfoResp now..
DECLARE @AvailCriteriaTableforVWeb table
(
	alertCategory int,
	alertType int,
	alertCriteria int,
	localizedMessId int,
	localizedName nvarchar(max),
	processDiscoveredVMs int
)
INSERT INTO @AvailCriteriaTableforVWeb(alertCategory,alertType,alertCriteria,localizedMessId,localizedName,processDiscoveredVMs)
SELECT NTCategory.id,NTalertType.id,NTAvailCriteria.criteriaid,NTAvailCriteria.nameMessId,NULL,0
FROM NTAvailCriteria
INNER JOIN NTAlertType on NTAvailCriteria.alertTypeId=NTalertType.id
AND (NTAvailCriteria.flags & 1) > 0 AND (ISNULL(NTAvailCriteria.flags,0) & 2) = 0
INNER JOIN NTCategory ON NTalertType.categoryID = NTCategory.id
INSERT INTO @AvailCriteriaTableforVWeb(alertCategory,alertType,alertCriteria,localizedMessId,localizedName,processDiscoveredVMs)
SELECT 1,3,1,(1214 | (CAST(POWER(2, 24) AS BIGINT) * 74)),NULL,1
UNION ALL
SELECT 1,3,3,(1215 | (CAST(POWER(2, 24) AS BIGINT) * 74)),NULL,1
UNION ALL
SELECT 1,3,57,(1216 | (CAST(POWER(2, 24) AS BIGINT) * 74)),NULL,1
UPDATE @AvailCriteriaTableforVWeb
set localizedName =  dbo.fn_EvFormatEventMsgText(0,@localeId,localizedMessId, 0,2)
DECLARE @alertCriteriaListXML xml
SET @alertCriteriaListXML = (select alertCategory '@alertCategory',
	alertType '@alertType',
	alertCriteria '@alertCriteria',
	localizedName '@localizedName',
	processDiscoveredVMs 'alertStatus/@processDiscoveredVMs'
	from @AvailCriteriaTableforVWeb
	for xml path('alertCriteria'),root('alertCriteria'))
DECLARE @alertStaticInfoResp XML
SET @alertStaticInfoResp = (SELECT
	@alertCriteriaListXML,
	--Load the category list
	(
		SELECT id '@id', dbo.fn_EvFormatEventMsgText(0,@localeId, nameID, 0,2) '@name'
		FROM @NTcategory
		FOR XML PATH('alertCategoryList'),TYPE
	),
	(
		--Load the criteria list
		SELECT id '@id', dbo.fn_EvFormatEventMsgText(0,@localeId, nameID, 0,2) '@name'
		FROM NTCriteria
		FOR XML PATH('alertCriteriaList'),TYPE
	),
	(
		--Load the sub category list (alert type)
		SELECT categoryID '@alertCategoryId', id '@alertTypeId', dbo.fn_EvFormatEventMsgText(0,@localeId, nameID, 0,2) '@alertTypeName', notifTypesAllowed '@notifTypesAllowed',
			actionsAllowed '@actionsAllowed', dbo.fn_EvFormatEventMsgText(0,@localeId, description, 0,2) '@alertDescription', license '@license',
			(
				--Load the alert type node type map
				SELECT NTMap.nodeType '@nodeType', dbo.fn_EvFormatEventMsgText(0,@localeId, NTMap.nameID, 0,2) '@nodeName',
					NTMap.parentNodeType '@parentNodeType',GEMap.nodeNameDef '@nodeNameDef',GEMap.idNameDef '@idNameDef',  NTMap.flag '@flag'
				FROM @NTalertNodeTypeMap AS NTMap
				LEFT OUTER JOIN  @genericEntityDefMapping AS GEMap
				ON NTMap.nodeType = GEMap.nodeType
				WHERE NTMap.NTalertTypeID = NTS.id
				FOR XML PATH('nodeTypesList'),TYPE
			),
			(
				--Load the alert type available criteria list
				SELECT NTAC.criteriaId '@criteriaId', NTAC.reportingOptions '@reportOption', NTAC.escReportingOptions '@escReportOption' ,NTAC.defaultSelection '@defaultSelection',
				(
					--Load the alert type avialable criteria token list
					SELECT NTOKEN.tokenID '@tokenId', EvLocaleMsgs.Message '@tokenFormat', NTOKEN.flag '@flag', NTOKEN.tokenType '@tokenType', NTOKEN.tokenInputFormat '@tokenInputFormat'   -- Token Subtree
					FROM NTmessageTokensForAlert NTOKEN
					INNER JOIN EvLocaleMsgs (NOLOCK) ON NTOKEN.availcriteriaId = NTAC.id AND
					EvLocaleMsgs.localeId = @localeId AND EvLocaleMsgs.MessageId = NTOKEN.tokenID
					FOR XML PATH('tokenList'),TYPE
				)
				FROM NTavailCriteria AS NTAC
WHERE NTAC.alertTypeId = NTS.id	AND ISNULL(NTAC.flags,0) & 2 = 0
				FOR XML PATH('availCriteriaList'),TYPE
			)
		FROM @NTAlertType as NTS
WHERE id <> 49
AND actionsAllowed <> 8
		FOR XML PATH('alertTypeList'),TYPE
	)
	FOR XML PATH('CVGui_AlertStaticInfoResp')
)
SELECT @alertStaticInfoResp as o_responseXML
SET NOCOUNT OFF
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  END
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
GO

IF EXISTS (select * from GxQscripts where name = 'br_NTAlertStaticInfo')
	delete from GxQscripts where name = 'br_NTAlertStaticInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_NTAlertStaticInfo')
	delete from GXDBVersions where aliasname = 'br_NTAlertStaticInfo'
GO

insert into GXDBVersions values(2, 'br_NTAlertStaticInfo',  '00010030006400160000', 'br_NTAlertStaticInfo', '00010030006400160000')
GO

