

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/br_NTAlertSRMList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/br_NTAlertSRMList.sp,v $ $Id: br_NTAlertSRMList.sp,v 1.8.50.2 2018/03/27 08:11:19 jiechen Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   br_NTalertList   - Fetch the (short) list of currently defined alert
--                      notifications.
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: br_NTalertSRMList <<<'

IF EXISTS (select * from sysobjects where name='br_NTalertSRMList')
	drop procedure br_NTalertSRMList
IF EXISTS (select * from GxQscripts where name='br_NTalertSRMList')
	delete from GxQscripts where name = 'br_NTalertSRMList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_NTalertSRMList')
	delete from GXDBVersions where aliasname = 'br_NTalertSRMList'
GO
print '... Creating Procedure: br_NTalertSRMList'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure br_NTalertSRMList
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @userID int,
  @localeId int,
  @alertId int,
  @taskId int
AS
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  BEGIN
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
SET NOCOUNT ON
-----------------------------------------------------------------------------------------
-- SINCE WE WILL BE USING THE NOTIFICATION LIST OVER AND OVER AGAIN, MIGHT AS WELL PUT --
-- THE NOTIFICATIONS WE ARE INTERESTED IN INTO A TEMPORARY TABLE                       --
-----------------------------------------------------------------------------------------
if object_id('tempdb.dbo.#srmList') is not null
    DROP TABLE #srmList
CREATE TABLE #srmList
(
	[alertId]		integer NOT NuLL,
[alertName]		nvarchar(128),
	[alertTypeId]	integer NOT NuLL,
[alertTypeName]	nvarchar(1024),
	[alertEnabled]	integer NOT NuLL,
	[rsReportId]	integer NOT NuLL,
	[rsFilter]		nvarchar(1024),
	[rsName]		nvarchar(1024),
	[taskId]		integer NOT NuLL
)
--------------------------------------------------
-- BASED ON INPUT PARAMETERS, DETERMINE DATASET	--
--------------------------------------------------
-- IF @alertId <> 0
--	INSERT #srmList
--	SELECT ntNotificationRuleId, '', 0, '', 0, [rsReportId], Filter, '', [taskId]
--	FROM RSREPORTTHRESHOLDS
--	Where ntNotificationRuleId = @alertId
-- ELSE IF @taskId <> 0
--	INSERT #srmList
--	SELECT ntNotificationRuleId, '', 0, '',  0, [rsReportId], Filter, '', [taskId]
--	FROM RSREPORTTHRESHOLDS
--	Where [taskId] = @taskId
--ELSE
--	INSERT #srmList
--	SELECT [ntNotificationRuleId], '', 0, '',  0, [rsReportId], Filter, '', [taskId]
--	FROM RSREPORTTHRESHOLDS
--------------------------------------------------
-- GET THINGS WE NEED FROM NTNotificationRule	--
--------------------------------------------------
UPDATE #srmList
	SET [alertEnabled] = status, [alertName] = [notificationName], alertTypeId = NR.alertTypeId
	FROM NTNotificationRule AS NR, #srmList AS SL
	WHERE NR.id = SL.alertId
----------------------------------------------
--  REMOVE ALL DELETED AND NON-SRM ALERTS	--
----------------------------------------------
DELETE #srmList
WHERE [alertEnabled] & ((2+ 4+8+16)) <> 0
----------------------------------------------
--  SINCE 'ENABLED' IS 0 and DISABLED IS 1,	--
--    NEED TO FLIP VALUE OF STATUS HERE		--
----------------------------------------------
UPDATE #srmList
	SET [alertEnabled] = CASE [alertEnabled]
		WHEN 0 THEN 1
		WHEN 1 THEN 0
		ELSE [alertEnabled]
		END
----------------------------------------------
-- alertTypeName is a little tricky. Need	--
-- to do a locale specific lookup here		--
----------------------------------------------
UPDATE #srmList
	set [alertTypeName] = dbo.fn_EvFormatEventMsgText(0, @localeId, (select nameId from NTalertType where id = alertTypeId) , 0 ,2)
----------------------------------------------
-- FILL IN ANY REMAINING MISSING DATA		--
----------------------------------------------
--UPDATE #srmList
--Set RsName = (select name from RSREPORTS where  id = [rsReportId])
----------------------
--	FILL IN THE XML	--
----------------------
SELECT	1			                as TAG,
	NuLL			                as Parent,
	NuLL			                as [CVGui_AlertSRMReportListResp!1],
	NuLL							as [srmAlerts!2!alertId],
	NuLL							as [srmAlerts!2!alertName],
	NuLL							as [srmAlerts!2!alertTypeId],
	NuLL							as [srmAlerts!2!alertTypeName],
	NuLL							as [srmAlerts!2!alertEnabled],
	NuLL							as [srmAlerts!2!rsReportId],
	NuLL							as [srmAlerts!2!rsFilter],
	NuLL							as [srmAlerts!2!rsName],
	NuLL							as [srmAlerts!2!taskId]
UNION ALL
----------------------------------
---- ALERT INFO ----
----------------------------------
SELECT	2, 1, NuLL,
	[alertId],	[alertName], [alertTypeId],	[alertTypeName], [alertEnabled], [rsReportId], [rsFilter], [rsName], [taskId]
	FROM #srmList
FOR XML EXPLICIT
if object_id('tempdb.dbo.#srmList') is not null
BEGIN
    DROP TABLE #srmList
END
SET NOCOUNT OFF
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  END
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
GO

IF EXISTS (select * from GxQscripts where name = 'br_NTAlertSRMList')
	delete from GxQscripts where name = 'br_NTAlertSRMList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_NTAlertSRMList')
	delete from GXDBVersions where aliasname = 'br_NTAlertSRMList'
GO

insert into GXDBVersions values(2, 'br_NTAlertSRMList',  '00010008005000020000', 'br_NTAlertSRMList', '00010008005000020000')
GO

