

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/br_NTAlertDetail.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/br_NTAlertDetail.sp,v $ $Id: br_NTAlertDetail.sp,v 1.50.32.18 2019/07/17 02:40:24 snandhini Exp $";
--
--  +========================================================================+
--  |   Procedure:  br_NTAlertDetail
--  |
--  |       Scope:  -PUBLIC-
--  |
--  | Description:  Fetches detailed information for the specified Notification
--  |
--  |       Input:  xxxx
--  |      Output:  xxxx
--  |      Return:  xxxx
--  |
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='br_NTAlertDetail')
BEGIN
	print '>>> Drop Stored Procedure: br_NTAlertDetail <<<'
	drop procedure br_NTAlertDetail
END
IF EXISTS (select * from GxQscripts where name='br_NTAlertDetail')
	delete from GxQscripts where name = 'br_NTAlertDetail'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_NTAlertDetail')
	delete from GXDBVersions where aliasname = 'br_NTAlertDetail'
GO
print '... Creating Procedure: br_NTAlertDetail'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure br_NTAlertDetail
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @callerId int,
  @notifID int,
  @localeId int
AS
-- ----------------------------------------------------------------------------
--   BEGIN
-- ----------------------------------------------------------------------------
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
declare @isEscalated		integer
declare @triggerTimeScalar	integer
declare @NTalertTypeID		integer
declare @xmlEntityList		xml
declare @taskId               integer         -- SRM CHANGE
declare @sValue                 nvarchar(2048)
declare @escReportingOptions integer
declare @runCommandEnabled 	integer
declare @runCommandEnabled2	integer
declare @customQueryDetailsXml nvarchar(max)
declare @alertTokenRuleGroupXml nvarchar(MAX)
set @runCommandEnabled  = 0     -- Default No Enabled Run Command
set @runCommandEnabled2 = 0     -- Default No Enabled Escalated Run Command
set @isEscalated = 0			-- Default No Escalation
set @escReportingOptions  =  ISNULL((select SUM(distinct reportingOptions) from NTselCriteria where ruleid=@notifID and esclationlevel=2),0)
declare @ntAlertTypeName nvarchar(max) = ''
declare @ntCriteriaName  nvarchar(max) = ''
DECLARE @XML_PREFIX nvarchar(100)
SET     @XML_PREFIX ='<?xml version="1.0" encoding="UTF-16" standalone="no" ?>'
DECLARE	@ruleLocaleId   Integer
SET		@ruleLocaleID	= ISNULL((Select locale from NTnotification where NTnotificationID = @notifID), 0)
	SET @taskId = 0
	SET @sValue = ''
DECLARE @organizationID INT  = NULL
DECLARE @organizationName NVARCHAR(MAX) = NULL
DECLARE @organizationXML XML = NULL
--------------------------------
--  Security check --
--------------------------------
--Alert detail will be send to the user only if the alert is visible to the user
DECLARE @userHasRight INT = 0
DECLARE @errorCode INT = 0
DECLARE @errorString NVARCHAR(1024) = N''
EXEC sec_checkPermissionOnEntity @callerId, 0, @userHasRight OUTPUT, 64, @notifID
IF @userHasRight = 0
BEGIN
SET @errorCode = (2829 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2829 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId)
    SET @errorString = REPLACE(@errorString, '^1%s', ISNULL((SELECT login FROM UMUsers WHERE id = @callerId),''))
SET @errorString = REPLACE(@errorString, '^2%s', (SELECT message FROM EvLocaleMsgs WHERE messageId = (2812 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId))
	SELECT	1			         as TAG,
			null		         as Parent,
		@errorCode			     as [CVGui_GenericResp!1!errorCode],
		@errorString	         as [CVGui_GenericResp!1!errorMessage]
	FOR XML EXPLICIT
END
ELSE
BEGIN
	----------------------------------------------------------------
	--- CHECK IS THIS ALERT HAS ESCALATED RUN COMMANDS
	----------------------------------------------------------------
IF NOT EXISTS (select 1 from NTnotificationRule WHERE id = @notifID and revision=1 and (status& 2)=0  )
	BEGIN
set @errorCode = CAST(0x0B0003 AS INT)
set @errorString = dbo.fn_EvFormatEventMsgText(0,@localeId, (143 | (CAST(POWER(2, 24) AS BIGINT) * 74)), 0,2)
		SELECT	1			         as TAG,
			null		         as Parent,
			@errorCode			     as [CVGui_GenericResp!1!errorCode],
			@errorString	         as [CVGui_GenericResp!1!errorMessage]
			FOR XML EXPLICIT
		return
	END
	IF (EXISTS (select * from NTnotificationAction WHERE NTnotificationID = @notifID AND escalationLevel = 2))
		set @runCommandEnabled2 = 1
	-------------------------------------
	--- CHECK FOR RUN COMMAND ENABLES ---
	-------------------------------------
	if exists (select * from NTselCriteria where ruleid=@notifId AND (reportingOptions & 8) <> 0 AND esclationLevel =1)
		set @runCommandEnabled = 1
	if exists (select * from NTselCriteria where ruleid=@notifId AND (reportingOptions & 8) <> 0 AND esclationLevel =2)
		set @runCommandEnabled2 = 1
	SET @NTalertTypeID   =  ISNULL((select alertTypeId from NTNotificationRule with (nolock) WHERE id = @notifId), 0)
if (@NTalertTypeID=65)
	begin
		select @ntAlertTypeName = queryName from NTqueryList with (nolock)
		inner join NTNotificationQueryMapping with (nolock) on NTqueryList.queryId=NTNotificationQueryMapping.queryid
		and NTNotificationQueryMapping.NTNotificationId = @notifID
		set @customQueryDetailsXml = (
			select QueryId as '@queryId',
			criteriaXML as '@criteriaListxml',
			xmlInfo as '@additionalQueryInfo',
			taskId as '@taskId',
			--convert(nvarchar(max),@taskInfoXml) as '@taskInfoXml',
			isScheduled as '@isScheduled'
			from NTNotificationQueryMapping with (nolock)
			where NtNotificationId = @notifID
			for xml path('CVGui_CustomQueryDetailsForAlert'))
	end
if (@NTalertTypeID=58)
	begin
		select @ntCriteriaName = convert(xml,convert(varchar(max),criteriaxml)).value('(LogMonitoring_ConditionsList/@criteriaName)[1]','nvarchar(max)')
		from NTSimpanaEventCriteria with (nolock)
		where notifRuleId=@notifID
	end
SELECT @alertTokenRuleGroupXml = attrVal FROM NTnotificationProp WHERE componentNameId = @notifId AND attrName = 'Alert Token Rule Xml' AND modified = 0
IF( LEN(@alertTokenRuleGroupXml) = 0 )
BEGIN
  SET @alertTokenRuleGroupXml =  NULL
END
	select @xmlEntityList = xmlEntityList from NTnotificationRule WHERE Id = @notifId
	DECLARE @securityAssociations XML
EXEC sec_getSecurityForEntity @callerId, @securityAssociations OUTPUT, 64, @notifId
	DECLARE @alertProp xml
	-- First get list of attr names and their values.
	declare @attrNamesList table
	(
		attrName nvarchar(max)
	)
	Insert into @attrNamesList
	select distinct attrname from NTnotificationProp with (readuncommitted)
		where componentnameid=@notifId
	set @alertProp = (	select attrname '@propName',
			(
				select attrval '@val'
				from NTnotificationProp with (readuncommitted)
				where componentnameid=@notifId
				and attrname=attrNames.attrname
				for xml path('propValue'),TYPE
				)
			from @attrNamesList attrNames
		for xml path('property'),root('alertProperties')
		)
	SELECT @organizationId = CONVERT(INT,NTNotificationProp.attrVal)
	FROM NTNotificationProp WITH (NOLOCK)
	WHERE NTNotificationProp.componentNameId=@notifId
AND attrName='OrganizationId' and modified=0
	IF (@organizationId IS NULL OR @organizationId <= 0)
	BEGIN
		SELECT @organizationId = UMSecurityAssociations.companyId
		FROM UMSecurityAssociations WITH (NOLOCK) WHERE
		UMSecurityAssociations.entityType1=64 and UMSecurityAssociations.entityId1 = @notifId
		AND UMSecurityAssociations.isCreator = 1
		AND UMSecurityAssociations.companyId> 0
	END
	IF (@organizationId IS NOT NULL AND @organizationId > 0)
	BEGIN
		SELECT @organizationName = UMdsProviders.domainName
		FROM UMdsProviders WITH (NOLOCK) WHERE UMdsProviders.id = @organizationId
AND UMdsProviders.flags & 0x0002 = 0
	END
	IF @organizationName IS NOT NULL AND LEN(@organizationName)>0
	BEGIN
		SET @organizationXML = (SELECT @organizationId '@companyId', @organizationName '@companyName'
				FOR XML PATH('organization')  )
	END
	DECLARE @xmlResponse xml
		select @xmlResponse = (select * from
		(
		SELECT	1			         as TAG,
		NULL			         as Parent,
		NULL			         as [CVGui_AlertDetailResp!1],
	--                                       -->ALERTDETAIL
   		NULL				as [alertDetail!2!xmlEntityList],
		NULL				as [alertDetail!2!alertSeverity],
		NULL				as [alertDetail!2!escalationSeverity],
		NULL				as [alert!3!id!hide],
		NULL				as [alert!3!notifType],
		NULL				as [alert!3!escNotifType],
		NULL				as [alert!3!status],
		NULL				as [alert!3!origCCId],
		NULL				as [alert!3!GUID],
   		NULL				as [alert!4!id],
   		NULL                as [alert!4!name],
		NULL			    as [alertCategory!5!id],
		NULL			    as [alertCategory!5!name],
		NULL			    as [alertType!6!id],
		NULL			    as [alertType!6!name],
   		NULL                as [userList!7!id1],
   		NULL                as [userList!7!id2],
   		NULL                as [userList!7!name],
   		NULL                as [userGroupList!8!id1],
   		NULL                as [userGroupList!8!id2],
   		NULL                as [userGroupList!8!name],
		NULL				as [runCommands!9!enabled],
		NULL				as [runCommands!9!esclationLevel],
		NULL				as [runCommands!9!impersonateUser],
		NULL				as [runCommands!9!loginName],
		NULL				as [runCommands!9!password],
		NULL				as [runCommands!9!useNetworkShare],
		NULL				as [runCommands!9!cmdPath],
		NULL				as [runCommands!9!arguments],
		NULL				as [criteria!10!id!hide],
		NULL				as [criteria!10!criteriaId],
		NULL				as [criteria!10!esclationLevel],
		NULL				as [criteria!10!reportingOptions],
		NULL				as [criteria!10!delayTimeSeconds],
		NULL				as [criteria!10!persistTimeSeconds],
		NULL				as [criteria!10!taskId],
		NULL				as [criteria!10!value],
		NULL				as [criteriaParams!11!paramIndex],
		NULL				as [criteriaParams!11!type],
		NULL				as [criteriaParams!11!value],
		NULL				as [criteriaParams!11!unit],
		NULL                as [notifMsgs!12!notifType],
		NULL                as [notifMsgs!12!notifMessage],
		NULL                as [notifMsgs!12!localeId],
		NULL				as [notifMsgs!12!notifOptions],
		NULL                as [notifMsgs!12!esclationLevel],
		NULL                as [notifMsgs!12!messageFormat],
		NULL                as [notifMsgs!12!notifMessageHtml],
   		NULL                as [externalGroupList!13!id1],
   		NULL                as [externalGroupList!13!id2],
   		NULL                as [externalGroupList!13!name],
   		NULL                as [nonGalaxyUserList!14!id1],
   		NULL                as [nonGalaxyUserList!14!id2],
   		NULL                as [nonGalaxyUserList!14!name],
   		NULL				as [locale!15!localeID],
		NULL				as [ReportingParams!16!ReportingOptions],
		NULL				as [ReportingParams!16!delayTimeSeconds],
		NULL				as [ReportingParams!16!persistTimeSeconds],
		NULL				as [criteriasSelected!17!val],
		NULL				as [regularNotifications!18!val],
		NULL				as [escalatedNotifications!19!val],
   		NULL				as [alertDetail!2!eventCriteriaXML],
		NULL				as [alertDetail!2!customQueryDetailsXml],
   		NULL				as [alertDetail!2!checkForEventParams],
        NULL				as [alertDetail!2!alertTokenRuleGroupXml],
		NULL				as [alertDetail!2!senderEmailId],
		NULL				as [alertDetail!2!senderDisplayName],
		NULL				as [alertDetail!2!minJobCountForJobAnomaly],
		NULL				as [appTypeFilters!20],
		NULL				as [appTypeFilter!21!applicationId],
		NULL				as [appTypeFilter!21!appGroupId],
		NULL				as [appTypeFilter!21!_type_],
		NULL				as [appTypeFilter!21!appName],
		NULL				as [appTypeFilter!21!appGroupName],
		NULL				as [securityAssociations!22]
	UNION ALL
	-------------------------------------
	---- ENTITY LIST ----
	-------------------------------------
	SELECT  2, 1, NULL,
		 (CASE  LEN(CONVERT(nvarchar(max), @xmlEntityList))
				 WHEN 0 THEN null
				 ELSE @XML_PREFIX+CONVERT(nvarchar(max), @xmlEntityList)
				 END),alertSeverity,escalationSeverity,
		 NULL, NULL, NULL, NULL,
		 NULL, NULL,
		 NULL, NULL,
		 NULL, NULL,
		 NULL, NULL,
		 NULL, NULL, NULL,
		 NULL, NULL, NULL,
		 NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
		 NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
		 NULL, NULL,NULL,NULL,NULL,
		 NULL, NULL, NULL,NULL,
		 NULL, NULL, NULL,NULL,
		 NULL, NULL, NULL,
		 NULL, NULL, NULL, NULL,
		 NULL,NULL,NULL,NULL,
			 (CASE  LEN(criteriaXML)
				 WHEN 0 THEN null
				 ELSE criteriaXML
				 END),
			 (CASE  LEN(@customQueryDetailsXml)
				 WHEN 0 THEN null
				 ELSE @customQueryDetailsXml
				 END),
			IsNull((select attrVal from NTNotificationProp where componentNameId=@notifID
				and attrName='Match Event Params' and modified=0),0),
                 @alertTokenRuleGroupXml,
			(select attrVal from NTNotificationProp where componentNameId=@notifID
and attrName = 'Sender MailId' and modified=0),
			(select attrVal from NTNotificationProp where componentNameId=@notifID
and attrName = 'Sender Display Name' and modified=0),
			(select attrVal from NTNotificationProp where componentNameId=@notifID
and attrName = 'Minimum Number of Anomalous Jobs' and modified=0),
		 NULL,NULL,NULL,NULL,NULL,NULL,
		 NULL
		 FROM
		 (
			select ntnr.ruleState as alertSeverity,ntnr.ruleState2 as escalationSeverity, ntnr.xmlEntityList as xmlEntityList, isnull(NTSec.criteriaxml,'') as criteriaxml,ntnr.id as Id
			from NTnotificationRule ntnr left join dbo.NTSimpanaEventCriteria NTSec
			on ntnr.id = @notifID and NTSec.notifRuleId=@notifID
		 ) t
		 where t.id=@notifId
	UNION ALL
	----------------------------------
	---- ALERT ID ----
	----------------------------------
	SELECT  3, 2, NULL,
		 NULL,NULL,NULL,
		 @notifID,notifType, @escReportingOptions, status, origCCId, GUID,
		 NULL, NULL,
		 NULL, NULL,
		 NULL, NULL,
		 NULL, NULL, NULL,
		 NULL, NULL, NULL,
		 NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
		 NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
		 NULL, NULL,NULL,NULL,
		 NULL, NULL, NULL,NULL,
		 NULL, NULL, NULL,NULL,
		 NULL, NULL, NULL,NULL,
		 NULL, NULL,NULL, NULL,
		 NULL, NULL,NULL ,NULL,
		 NULL ,NULL,NULL,NULL,NULL,NULL,NULL,
		 NULL,NULL,NULL,NULL,NULL,NULL,
		 NULL
		 FROM  NTnotificationRule
	WHERE id = @notifID
	UNION ALL
	----------------------------------
	---- ALERT  ----
	----------------------------------
	SELECT  4, 3, NULL,
		 NULL,NULL,NULL,
		 @notifID,NULL, NULL, NULL,
		 NULL, NULL,
		 id, notificationName,
		 NULL, NULL,
		 NULL, NULL,
		 NULL, NULL, NULL,
		 NULL, NULL, NULL,
		 NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
		 NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
		 NULL, NULL,NULL,NULL,
		 NULL, NULL, NULL,NULL,
		 NULL, NULL, NULL,NULL,
		 NULL, NULL, NULL,NULL,
		 NULL, NULL,NULL, NULL,
		 NULL, NULL,NULL,NULL,
		 NULL,NULL,NULL,NULL,NULL,NULL,NULL,
		 NULL,NULL,NULL,NULL,NULL,NULL,
		 NULL
	FROM  NTnotificationRule
	WHERE id = @notifID
	UNION ALL
	----------------------------------
	---- ALERT CATEGORY ----
	----------------------------------
	SELECT  5, 3, NULL,
		 NULL,NULL,NULL,
		 @notifID,NULL,NULL, NULL,
		 NULL, NULL,
		 NULL, NULL,
		 NTC.id, dbo.fn_EvFormatEventMsgText(0,@localeId, NTC.nameID, 0,2),
		 NULL, NULL,
		 NULL, NULL, NULL,
		 NULL, NULL, NULL,
		 NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
		 NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
		 NULL, NULL,NULL,NULL,
		 NULL, NULL, NULL,NULL,
		 NULL, NULL, NULL,NULL,
		 NULL, NULL, NULL,NULL,
		 NULL, NULL,NULL, NULL,
		 NULL, NULL,NULL,NULL,
		 NULL, NULL,NULL,NULL,NULL,NULL,NULL,
		 NULL,NULL,NULL,NULL,NULL,NULL,
		 NULL
	FROM  NTnotificationRule AS NTR, NTcategory AS NTC
	WHERE NTR.id = @notifID AND NTR.categoryId = NTC.id
	UNION ALL
	----------------------------------
	---- ALERT SUB CATEGORY ----
	----------------------------------
	SELECT  6, 3, NULL,
		 NULL,NULL,NULL,
		 @notifID,NULL,NULL, NULL,
		 NULL, NULL,
		 NULL, NULL,
		 NULL, NULL,
		 NTSC.id, case when len(@ntAlertTypeName)=0 then dbo.fn_EvFormatEventMsgText(0,@localeId, NTSC.nameID, 0,2) else @ntAlertTypeName end,
		 NULL, NULL, NULL,
		 NULL, NULL, NULL,
		 NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
		 NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
		 NULL, NULL,NULL,NULL,
		 NULL, NULL, NULL,NULL,
		 NULL, NULL, NULL,NULL,
		 NULL, NULL, NULL,NULL,
		 NULL, NULL,NULL, NULL,
		 NULL, NULL,NULL,NULL,
		 NULL,NULL,NULL,NULL,NULL,NULL,NULL,
		 NULL,NULL,NULL,NULL,NULL,NULL,
		 NULL
	FROM  NTnotificationRule AS NTR, NTAlertType AS NTSC
	WHERE NTR.id = @notifID AND NTR.alertTypeId = NTSC.id
	UNION ALL
	----------------------------------
	---- USER LIST ----
	----------------------------------
	SELECT  7, 2, NULL,
		 NULL,NULL,NULL,
		 @notifID,NULL,NULL, NULL,
		 NULL, NULL,
		 NULL, NULL,
		 NULL, NULL,
		 NULL, NULL,
		 NTU.userId, NTU.escalationLevel, U.login,
		 NULL, NULL, NULL,
		 NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
		 NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
		 NULL, NULL,NULL,NULL,
		 NULL, NULL, NULL,NULL,
		 NULL, NULL, NULL,NULL,
		 NULL, NULL, NULL,NULL,
		 NULL, NULL,NULL, NULL,
		 NULL, NULL,NULL,NULL,
		 NULL  ,NULL,NULL,NULL,NULL,NULL,NULL,
		 NULL,NULL,NULL,NULL,NULL,NULL,
		 NULL
	FROM NTnotificationUsers AS NTU, UMUsers AS U
WHERE NTU.NTnotificationID = @notifID AND NTU.userId = U.id AND U.enabled <> 0 AND NTU.recipientType=0 AND (U.flags & 0x004) = 0
	UNION ALL
	----------------------------------
	---- GROUP LIST ----
	----------------------------------
	SELECT  8, 2, NULL,
		 NULL,NULL,NULL,
		 @notifID,NULL,NULL, NULL,
		 NULL, NULL,
		 NULL, NULL,
		 NULL, NULL,
		 NULL, NULL,
		 NULL, NULL, NULL,
		 NTG.groupId, NTG.escalationLevel, case when UP.id is not null and UP.id>0 then UP.domainname+'\'+G.name else G.name end,
		 NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
		 NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
		 NULL, NULL,NULL,NULL,
		 NULL, NULL, NULL,NULL,
		 NULL, NULL, NULL,NULL,
		 NULL, NULL, NULL,NULL,
		 NULL, NULL , NULL, NULL,
		 NULL, NULL, NULL, NULL,
		 NULL,NULL,NULL,NULL,NULL,NULL,NULL,
		 NULL,NULL,NULL,NULL,NULL,NULL,
		 NULL
	FROM NTnotificationGroups AS NTG, UMGroups AS G
	left join UMDSProviders UP on G.umdsProviderId = UP.id
WHERE NTG.NTnotificationID = @notifID AND NTG.groupId = G.id and NTG.recipientType=0 AND (G.groupFlags & 0x0010) = 0
	UNION ALL
	----------------------------------
	---- RUM COMMAND LIST ----
	----------------------------------
	--
	--  IF THE ROW EXISTS IN THE NTnotificationAction Table, then we ASSUME it is enabled!
	--
	SELECT  9, 2, NULL,
		 NULL,NULL,NULL,
		 @notifID,NULL,NULL, NULL,
		 NULL, NULL,
		 NULL, NULL,
		 NULL, NULL,
		 NULL, NULL,
		 NULL, NULL, NULL,
		 NULL, NULL, NULL,
		 @runCommandEnabled, escalationLevel,useImpersonation, runAsUserLogin, runAsUserPassword, useNetworkShare, runCommand, arguments,
		 NULL, NULL, NULL, NULL, NULL, NULL,
		 NULL, NULL,NULL,NULL, NULL, NULL,
		 NULL, NULL, NULL,NULL,
		 NULL, NULL, NULL,NULL,
		 NULL, NULL, NULL,NULL,
		 NULL, NULL, NULL, NULL,
		 NULL,NULL,NULL,NULL,
		 NULL,NULL,NULL,NULL,NULL,NULL,NULL,
		 NULL,NULL,NULL,NULL,NULL,NULL,
		 NULL
	FROM NTnotificationAction
	WHERE   NTnotificationID = @notifID AND escalationLevel=1
	UNION ALL
	SELECT  9, 2, NULL,
		 NULL,NULL,NULL,
		 @notifID,NULL,NULL, NULL,
		 NULL, NULL,
		 NULL, NULL,
		 NULL, NULL,
		 NULL, NULL,
		 NULL, NULL, NULL,
		 NULL, NULL, NULL,
		 @runCommandEnabled2, escalationLevel,useImpersonation, runAsUserLogin, runAsUserPassword, useNetworkShare, runCommand, arguments,
		 NULL, NULL, NULL, NULL, NULL, NULL,
		 NULL, NULL,NULL,NULL, NULL, NULL,
		 NULL, NULL, NULL,NULL,
		 NULL, NULL, NULL,NULL,
		 NULL, NULL, NULL,NULL,
		 NULL, NULL, NULL, NULL,
		 NULL,NULL,NULL,NULL,
		 NULL,NULL,NULL,NULL,NULL,NULL,NULL,
		 NULL,NULL,NULL,NULL,NULL,NULL,
		 NULL
	FROM NTnotificationAction
	WHERE   NTnotificationID = @notifID AND escalationLevel=2
	UNION ALL
	----------------------------------
	---- CRITERIA LIST ----
	----------------------------------
	SELECT  10, 2, NULL,
		 NULL,NULL,NULL,
		 @notifID,NULL,NULL, NULL,
		 NULL, NULL,
		 NULL, NULL,
		 NULL, NULL,
		 NULL, NULL,
		 NULL, NULL, NULL,
		 NULL, NULL, NULL,
		 NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
		 NTS.id , NTS.availCriteriaid, NTS.esclationLevel, NTS.reportingOptions, NTS.delayTimeSeconds, NTS.persistTimeSeconds, NULL,
			 case when len(@ntCriteriaName)>0 then @ntCriteriaName else dbo.fn_EvFormatEventMsgText(0,@localeId,NTCriteria.nameId, 0,2) end ,
		 NULL, NULL, NULL,NULL,
		 NULL, NULL, NULL,NULL,
		 NULL, NULL, NULL,NULL,
		 NULL, NULL, NULL,NULL,
		 NULL, NULL , NULL, NULL, NULL,
		 NULL,NULL, NULL, NULL,NULL,NULL ,NULL,NULL,NULL,NULL,
		 NULL,NULL, NULL, NULL,NULL,NULL,
		 NULL
	FROM NTSelCriteria AS NTS, NTAvailcriteria AS NTA
	inner join NTCriteria on NTA.criteriaid = NTCriteria.id
	WHERE NTS.ruleId = @notifID AND NTS.availCriteriaid = NTA.criteriaid AND NTS.availCriteriaid <> 200
	and NTA.alertTypeId=@NTalertTypeID
	UNION ALL
	SELECT  10, 2, NULL,
		 NULL,NULL,NULL,
		 @notifID,NULL,NULL, NULL,
		 NULL, NULL,
		 NULL, NULL,
		 NULL, NULL,
		 NULL, NULL,
		 NULL, NULL, NULL,
		 NULL, NULL, NULL,
		 NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
		 NTS.id , NTS.availCriteriaid, NTS.esclationLevel, NTS.reportingOptions, NTS.delayTimeSeconds, NTS.persistTimeSeconds, @taskId, @sValue,
		 NULL, NULL, NULL,NULL,
		 NULL, NULL, NULL,NULL,
		 NULL, NULL, NULL,NULL,
		 NULL, NULL, NULL,NULL,
		 NULL, NULL, NULL,NULL,
		 NULL, NULL, NULL,NULL,
		 NULL,NULL,NULL,NULL,NULL,NULL,NULL,
		 NULL,NULL,NULL,NULL,NULL,NULL,
		 NULL
	FROM NTSelCriteria AS NTS
	WHERE NTS.ruleId = @notifID AND NTS.availCriteriaid = 200
	UNION ALL
	----------------------------------
	---- CRITERIA PARAM LIST ----
	----------------------------------
	SELECT  11, 10, NULL,
		 NULL,NULL,NULL,
		 @notifID,NULL,NULL, NULL,
		 NULL, NULL,
		 NULL, NULL,
		 NULL, NULL,
		 NULL, NULL,
		 NULL, NULL, NULL,
		 NULL, NULL, NULL,
		 NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
		 NTS.id , NULL, NULL, NULL, NULL, NULL, NULL, NULL,
		 NTSParams.paramIndex, NTSParams.type, NTSParams.value , NTSParams.unit,
		 NULL, NULL, NULL,NULL,
		 NULL, NULL, NULL,NULL,
		 NULL, NULL, NULL,NULL,
		 NULL, NULL, NULL,NULL,
		 NULL, NULL, NULL,NULL,
		 NULL ,NULL,NULL,NULL,NULL,NULL,NULL,
		 NULL,NULL,NULL,NULL,NULL,NULL,
		 NULL
	FROM NTSelCriteria AS NTS, NTAvailcriteria AS NTA, NTSelCriteriaParams NTSParams
	WHERE NTS.ruleId = @notifID AND NTS.availCriteriaid = NTA.criteriaId AND NTSParams.selCriteriaid = NTS.id and NTA.alertTypeId=@NTalertTypeID
	UNION ALL
	----------------------------------
	---- NOTIFICATION MESSAGE ----
	----------------------------------
	SELECT  12, 2, NULL,
		 NULL,NULL,NULL,
		 @notifID,NULL,NULL, NULL,
		 NULL, NULL,
		 NULL, NULL,
		 NULL, NULL,
		 NULL, NULL,
		 NULL, NULL, NULL,
		 NULL, NULL, NULL,
		 NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
		 NULL, NULL, NULL, NULL, NULL, NULL,  NULL, NULL,
		 NULL, NULL,NULL,NULL,
		 NTMF.messageType,NTMF.formatString, 0 ,NTMF.mfOptions, NTMF.escalationLevel,NTMF.messageFormatType,NTMF.formatStringHtml,
		 NULL, NULL, NULL,
		 NULL, NULL, NULL,
		 NULL, NULL ,NULL,
		 NULL, NULL ,NULL,NULL,
		 NULL  ,NULL,NULL,NULL,NULL,NULL,NULL,
		 NULL,NULL,NULL,NULL,NULL,NULL,
		 NULL
	FROM NTmessageFormat as NTMF
	WHERE NTMF.NTnotificationID = @notifID AND messageType <> 16
	UNION ALL
	----------------------------------
	---- External GROUP LIST ----
	----------------------------------
	SELECT  13, 2, NULL,
		 NULL,NULL,NULL,
		 @notifID,NULL,NULL, NULL,
		 NULL, NULL,
		 NULL, NULL,
		 NULL, NULL,
		 NULL, NULL,
		 NULL, NULL, NULL,
		 NULL, NULL, NULL,
		 NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
		 NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
		 NULL, NULL,NULL,NULL,
		 NULL, NULL, NULL,NULL,NULL,NULL,NULL,
		  NTEG.externalGroupId, NTEG.escalationLevel,
			   (select domainName from umdsProviders where id = EG.umdsProviderId)+'\'+ EG.name,
		 NULL, NULL,NULL,
		 NULL, NULL, NULL,NULL,
		 NULL, NULL ,NULL,NULL,
		 NULL,NULL,NULL,NULL,NULL,NULL,
		 NULL,NULL,NULL,NULL,NULL,NULL,
		 NULL
	FROM NTnotificationExternalGroups AS NTEG, UMGroups AS EG
WHERE NTEG.NTnotificationID = @notifID AND NTEG.externalGroupId = EG.id and NTEG.recipientType = 0 AND (EG.groupFlags & 0x0010) = 0
	UNION ALL
	----------------------------------
	---- Non-Galaxy user email list --
	----------------------------------
	SELECT  14, 2, NULL,
		 NULL,NULL,NULL,
		 @notifID,NULL,NULL, NULL,
		 NULL, NULL,
		 NULL, NULL,
		 NULL, NULL,
		 NULL, NULL,
		 NULL, NULL, NULL,
		 NULL, NULL, NULL,
		 NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
		 NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
		 NULL, NULL,NULL,NULL,
		 NULL, NULL, NULL,NULL,NULL,
		 NULL, NULL, NULL, NULL,NULL,
		 NTNG.NTnotificationID,NTNG.escalationLevel,NTNG.nonGalaxyUserName,
		 NULL, NULL,NULL,
		 NULL, NULL ,NULL,NULL,
		 NULL,NULL,NULL,NULL,NULL,NULL,NULL,
		 NULL,NULL,NULL,NULL,NULL,NULL,
		 NULL
	FROM NTnotificationNonGalaxyUsers AS NTNG
	WHERE NTNG.NTnotificationID = @notifID AND NTNG.recipientType=0  -- Return only to list here... compute cc and bcc list below.
	UNION ALL
	-- STARTING IN 9.0, WE CAN CHANGE THE LOCALE FOR THE ALERT, SO WE MUST PROVIDE IT NOW IN ALERT DETAIL
	SELECT  15, 2, NULL,
		 NULL,NULL,NULL,
		 @notifID,NULL,NULL, NULL,
		 NULL, NULL,
		 NULL, NULL,
		 NULL, NULL,
		 NULL, NULL,
		 NULL, NULL, NULL,
		 NULL, NULL, NULL,
		 NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
		 NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
		 NULL, NULL, NULL, NULL,
		 NULL, NULL, NULL,NULL,
		 NULL, NULL, NULL,NULL,NULL,
		 NULL, NULL, NULL, NULL,
		 @ruleLocaleId, NULL,NULL,
		 NULL, NULL ,NULL,NULL,
		 NULL, NULL,NULL,NULL,NULL,NULL,NULL,
		 NULL,NULL,NULL,NULL,NULL,NULL,
		 NULL
		 FROM  NTnotificationRule
	WHERE id = @notifID
	UNION ALL
	--for auditing purpose only
	SELECT  DISTINCT 16, 2, NULL,                                --distinct because in NTSelCriteria these options have entries for each criteria
		 NULL,NULL,NULL,
		 @notifID,NULL,NULL, NULL,
		 NULL, NULL,
		 NULL, NULL,
		 NULL, NULL,
		 NULL, NULL,
		 NULL, NULL, NULL,
		 NULL, NULL, NULL,
		 NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
		 NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
		 NULL, NULL, NULL, NULL,
		 NULL, NULL, NULL,NULL,
		 NULL, NULL, NULL,NULL,NULL,
		 NULL, NULL, NULL, NULL,
		 NULL, NTS.reportingOptions, NTS.delayTimeSeconds, NTS.persistTimeSeconds,
		 NULL ,NULL,NULL,
		 NULL ,NULL,NULL,NULL,NULL,NULL,NULL,
		 NULL,NULL,NULL,NULL,NULL,NULL,
		 NULL
	FROM NTSelCriteria AS NTS
	WHERE NTS.ruleId = @notifID
	UNION ALL
	--for auditing purpose only
	SELECT  DISTINCT 17, 2, NULL,
		 NULL,NULL,NULL,
		 @notifID,NULL,NULL, NULL,
		 NULL, NULL,
		 NULL, NULL,
		 NULL, NULL,
		 NULL, NULL,
		 NULL, NULL, NULL,
		 NULL, NULL, NULL,
		 NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
		 NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
		 NULL, NULL, NULL, NULL,
		 NULL, NULL, NULL,NULL,
		 NULL, NULL, NULL,NULL,NULL,
		 NULL, NULL, NULL, NULL,
		 NULL, NULL,NULL,
		 NULL, NTA.criteriaid ,NULL,NULL,
		  NULL,NULL,NULL,NULL,NULL,NULL,NULL,
		 NULL,NULL,NULL,NULL,NULL,NULL,
		 NULL
	FROM NTSelCriteria AS NTS, NTAvailcriteria AS NTA
	WHERE NTS.ruleId = @notifID AND NTS.availCriteriaid = NTA.criteriaid AND NTS.availCriteriaid <> 200
	UNION ALL
	--for auditing purpose only
	SELECT  18, 2, NULL,
		 NULL,NULL,NULL,
		 @notifID,NULL,NULL, NULL,
		 NULL, NULL,
		 NULL, NULL,
		 NULL, NULL,
		 NULL, NULL,
		 NULL, NULL, NULL,
		 NULL, NULL, NULL,
		 NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
		 NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
		 NULL, NULL, NULL, NULL,
		 NULL, NULL, NULL,NULL,
		 NULL, NULL, NULL,NULL,NULL,
		 NULL, NULL, NULL, NULL,
		 NULL, NULL,NULL,
		 NULL, NULL ,messageType,NULL,
		 NULL,NULL,NULL,NULL,NULL,NULL,NULL,
		 NULL,NULL,NULL,NULL,NULL,NULL,
		 NULL
	FROM NTmessageFormat WHERE NTnotificationID = @notifID and messageType <> 16 and escalationLevel = 1
	UNION ALL
	--for auditing purpose only
	SELECT  19, 2, NULL,
		 NULL,NULL,NULL,
		 @notifID,NULL,NULL, NULL,
		 NULL, NULL,
		 NULL, NULL,
		 NULL, NULL,
		 NULL, NULL,
		 NULL, NULL, NULL,
		 NULL, NULL, NULL,
		 NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
		 NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
		 NULL, NULL, NULL, NULL,
		 NULL, NULL, NULL,NULL,
		 NULL, NULL, NULL,NULL,NULL,
		 NULL, NULL, NULL, NULL,
		 NULL, NULL,NULL,
		 NULL, NULL ,NULL,messageType,
		 NULL,NULL,NULL,NULL,NULL,NULL,NULL,
		 NULL,NULL,NULL,NULL,NULL,NULL,
		 NULL
	FROM NTmessageFormat WHERE NTnotificationID = @notifID and messageType <> 16 and escalationLevel <> 1
	UNION ALL
	SELECT distinct 20, 2, NULL,
	     NULL,NULL,NULL,
	     @notifID,NULL,NULL, NULL,
	     NULL, NULL,
	     NULL, NULL,
	     NULL, NULL,
	     NULL, NULL,
	     NULL, NULL, NULL,
	     NULL, NULL, NULL,
	     NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	     NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	     NULL, NULL, NULL, NULL,
	     NULL, NULL, NULL,NULL,
	     NULL, NULL, NULL,NULL,NULL,
	     NULL, NULL, NULL, NULL,
	     NULL, NULL,NULL,
		 NULL, NULL ,NULL,NULL,
		 NULL, NULL,NULL,NULL,NULL,NULL,NULL,
		 NULL,NULL,NULL,NULL,NULL,NULL,
		 NULL
	     FROM  NTnotificationProp
WHERE componentNameId = @notifID and attrName in ('App Type Filter','App Group Filter')
	UNION ALL
	SELECT   21, 20 ,NULL,
	     NULL,NULL,NULL,
	     @notifID,NULL,NULL, NULL,
	     NULL, NULL,
	     NULL, NULL,
	     NULL, NULL,
	     NULL, NULL,
	     NULL, NULL, NULL,
	     NULL, NULL, NULL,
	     NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	     NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	     NULL, NULL, NULL, NULL,
	     NULL, NULL, NULL,NULL,
	     NULL, NULL, NULL,NULL,NULL,
	     NULL, NULL, NULL, NULL,
	     NULL, NULL,NULL,
		 NULL, NULL ,NULL,NULL,
		 NULL, NULL,NULL,NULL,NULL,NULL,NULL,
NULL, attrVal,NULL,79,name,NULL,
		 NULL
	     FROM  NTNotificationProp,APP_iDAType
WHERE componentNameId = @notifID and attrName = 'App Type Filter' and type=attrVal
	UNION ALL
	SELECT   21, 20 ,NULL,
	     NULL,NULL,NULL,
	     @notifID,NULL,NULL, NULL,
	     NULL, NULL,
	     NULL, NULL,
	     NULL, NULL,
	     NULL, NULL,
	     NULL, NULL, NULL,
	     NULL, NULL, NULL,
	     NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	     NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	     NULL, NULL, NULL, NULL,
	     NULL, NULL, NULL,NULL,
	     NULL, NULL, NULL,NULL,NULL,
	     NULL, NULL, NULL, NULL,
	     NULL, NULL,NULL,
		 NULL, NULL ,NULL,NULL,
		 NULL, NULL,NULL,NULL,NULL,NULL,NULL,
NULL, NULL, attrVal,78,NULL,groupName,
		 NULL
	     FROM  NTNotificationProp,APP_AppTypeGroup
WHERE componentNameId = @notifID and attrName = 'App Group Filter' and appTypeGroupId=attrVal and typeOfGroup=0
	UNION ALL
	----------------------------------
	---- Security Associations ----
	----------------------------------
	SELECT  22, 2, NULL,
		 NULL,NULL,NULL,
		 @notifID,NULL,NULL, NULL,
		 NULL, NULL,
		 NULL, NULL,
		 NULL, NULL,
		 NULL, NULL,
		 NULL, NULL, NULL,
		 NULL, NULL, NULL,
		 NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
		 NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
		 NULL, NULL,NULL,NULL,
		 NULL, NULL, NULL,NULL,
		 NULL, NULL, NULL,NULL,
		 NULL, NULL, NULL,NULL,
		 NULL, NULL,NULL, NULL,
		 NULL, NULL,NULL ,NULL,
		 NULL ,NULL,NULL,NULL,NULL,NULL,NULL,
		 NULL,NULL,NULL,NULL,NULL,NULL,
		(CASE  LEN(CONVERT(nvarchar(max), @securityAssociations))
			WHEN 0 THEN null
			ELSE @securityAssociations
			END)
		 FROM  NTnotificationRule
	WHERE id = @notifID
	) A
	ORDER BY  [alert!3!id!hide], [criteria!10!id!hide], TAG
	FOR XML EXPLICIT)
	declare @ccNonGalaxyListxml xml
	declare @bccNonGalaxyListxml xml
	set @ccNonGalaxyListxml = (select @notifID '@id1', escalationLevel '@id2', nonGalaxyUserName '@name'
		from NTnotificationNonGalaxyUsers
		WHERE NTnotificationID = @notifID and recipientType=1 -- CC
		for xml path('nonGalaxyUserListCc')
		)
	set @bccNonGalaxyListxml = (select @notifID '@id1', escalationLevel '@id2', nonGalaxyUserName '@name'
		from NTnotificationNonGalaxyUsers
		WHERE NTnotificationID = @notifID and recipientType=2 -- BCC
		for xml path('nonGalaxyUserListBcc')
		)
	if @ccNonGalaxyListxml is not null
	begin
		set @xmlResponse.modify('insert sql:variable("@ccNonGalaxyListxml") into (CVGui_AlertDetailResp/alertDetail)[1]')
	end
	if @bccNonGalaxyListxml is not null
	begin
		set @xmlResponse.modify('insert sql:variable("@bccNonGalaxyListxml") into (CVGui_AlertDetailResp/alertDetail)[1]')
	end
	--to fill cc, bcc galaxy users
	declare @userListxml xml
	declare @userGroupListxml xml
	declare @externalGroupListxml xml
	 IF OBJECT_ID('tempdb.dbo.#recipient') IS NOT NULL
		DROP TABLE #recipient
	 CREATE TABLE #recipient
				 (type INT, -- 0 user,1 group, 2 externalgroup
				  userOrGroupId INT,
				  escalationLevel INT,
				  name nvarchar(512),
				  recipientType INT  --0 to, 1 cc, 2 bcc
				  )
	 -- get only for bcc and cc as to users, groups,externalgroups are already populated in xml
	 insert into #recipient
	 select 0, NTU.userID,NTU.escalationLevel, U.login , NTU.recipientType
		 from NTnotificationUsers NTU inner join UMUsers U
on NTU.userId = U.id and NTU.recipientType <> 0 and NTU.NTnotificationID = @notifID and (U.flags & 0x004) = 0
	 UNION
	 select 1, NTG.groupID, NTG.escalationLevel, G.name , NTG.recipientType
		 from NTnotificationGroups NTG inner join UMGroups G
on NTG.groupId = G.id and NTG.recipientType <> 0 and NTG.NTnotificationID = @notifID and (G.groupFlags & 0x0010) = 0
	 UNION
	 select 2, NTEG.externalGroupID, NTEG.escalationLevel, case when UP.id is not null and UP.id>0 then UP.domainname+'\'+G.name else G.name end , NTEG.recipientType
		from NTnotificationExternalGroups AS NTEG
inner join UMGroups AS G on NTEG.externalgroupId = G.id and NTEG.recipientType <> 0 and NTEG.NTnotificationID = @notifID and (G.groupFlags & 0x0010) = 0
		left join UMDSProviders UP on G.umdsProviderId = UP.id
	set @userListxml = (select
		(select userOrGroupId '@id1', escalationLevel '@id2', name '@name'
			from #recipient
			where recipientType=1 and type=0  -- CC user
			for xml path('userListCc'),type),
		(select userOrGroupId '@id1', escalationLevel '@id2', name '@name'
			from #recipient
			where recipientType=2 and type=0  --BCC user
			for xml path('userListBcc'),type)
		for xml path(''))
	set @userGroupListxml = (select
		(select userOrGroupId '@id1', escalationLevel '@id2', name '@name'
			from #recipient
			where recipientType=1 and type=1  -- CC group
			for xml path('userGroupListCc'),type),
		(select userOrGroupId '@id1', escalationLevel '@id2', name '@name'
			from #recipient
			where recipientType=2 and type=1 -- BCC group
			for xml path('userGroupListBcc'),type)
		for xml path(''))
	set @externalGroupListxml = (select
		(select userOrGroupId '@id1', escalationLevel '@id2', name '@name'
			from #recipient
			where recipientType=1 and type=2 -- CC ExternalGroup
			for xml path('userGroupListCc'),type),
		(select userOrGroupId '@id1', escalationLevel '@id2', name '@name'
			from #recipient
			where recipientType=2 and type=2 -- BCC ExternalGroup
			for xml path('userGroupListBcc'),type)
		for xml path(''))
	-- modify xml for adding galaxy cc,bcc users
	if @userListxml is not null
	begin
		set @xmlResponse.modify('insert sql:variable("@userListxml") into (CVGui_AlertDetailResp/alertDetail)[1]')
	end
	if @userGroupListxml is not null
	begin
		set @xmlResponse.modify('insert sql:variable("@userGroupListxml") into (CVGui_AlertDetailResp/alertDetail)[1]')
	end
	if @externalGroupListxml is not null
	begin
		set @xmlResponse.modify('insert sql:variable("@externalGroupListxml") into (CVGui_AlertDetailResp/alertDetail)[1]')
	end
	DROP TABLE #recipient
	if @organizationXML is not null
	begin
		set @xmlResponse.modify('insert sql:variable("@organizationXML") into (CVGui_AlertDetailResp/alertDetail/alert)[1]')
	end
	-- Modify xml response to include alert properties also
	set @xmlResponse.modify('insert sql:variable("@alertProp") into (CVGui_AlertDetailResp/alertDetail)[1]')
	select @xmlResponse as o_responseXML
END
SET NOCOUNT OFF
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  END
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
GO

IF EXISTS (select * from GxQscripts where name = 'br_NTAlertDetail')
	delete from GxQscripts where name = 'br_NTAlertDetail'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_NTAlertDetail')
	delete from GXDBVersions where aliasname = 'br_NTAlertDetail'
GO

insert into GXDBVersions values(2, 'br_NTAlertDetail',  '00010050003200180000', 'br_NTAlertDetail', '00010050003200180000')
GO

