

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/br_NTAlertDelete.sp] ---------- 

-- -------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/br_NTAlertDelete.sp,v $ $Id: br_NTAlertDelete.sp,v 1.22.32.7 2020/11/27 16:59:17 kbora Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   br_NTAlertDelete   - Delete an Alert
--	-------------------------------------------------------
--	-- Error Codes:
--	--	0 -Success (alert deleted)
--	--      1 -Alert Nonexistent
--	--      2 -Constraint Violation (should never get this)
--	-------------------------------------------------------
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='br_NTAlertDelete')
BEGIN
	print '>>> Drop Stored Procedure: br_NTAlertDelete <<<'
	drop procedure br_NTAlertDelete
END
IF EXISTS (select * from GxQscripts where name='br_NTAlertDelete')
	delete from GxQscripts where name = 'br_NTAlertDelete'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_NTAlertDelete')
	delete from GXDBVersions where aliasname = 'br_NTAlertDelete'
GO
print '... Creating Procedure: br_NTAlertDelete'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure br_NTAlertDelete
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @callerID int,
  @alertId int,
  @locale int
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
declare @sqlError       int
declare @errorCode	int
declare @errorString	nvarchar(1024)
declare @alertName      nvarchar(255)
DECLARE @capabilies			int
DECLARE @capabiliesWant		int
DECLARE @ownerId			int
DECLARE @count				int
DECLARE @channelId			int
DECLARE	@capability int
SET		@capability				= 18				--'EV_MANAGE_ALERTS' (EvCapability.h)
DECLARE @alertCategoryId	AS integer	= ISNULL((Select CategoryID from NTNotificationRule where id = @alertId), 0)
DECLARE @status				AS integer	= ISNULL((Select status from NTNotificationRule where id = @alertId), 0)
DECLARE  @alertTypeId		AS  integer	 = ISNULL((select top 1 alertTypeId from NTnotificationRule where id=@alertId),0)
DECLARE @workTokenId		AS  INTEGER	 = 47 -- WORK_TOKEN_REFRESH_ALERT_CONFIG
-- ASSUME WE WILL HAVE NO ERROR --
set @errorCode = 0
-- ----------------------------------------------------------------------------
--   BEGIN
-- ----------------------------------------------------------------------------
BEGIN TRY
BEGIN TRAN
--
--
------------------------------------------
-- MAKE SURE ALERT IS NOT "PERMANENT":	--
------------------------------------------
IF (@status & 256) = 256		-- 'NT_STATUS_PERMANENT'
BEGIN
set @errorCode = CAST(0x0B0009 AS INT)
set @errorString = dbo.fn_EvFormatEventMsgText(0,@locale, (941 | (CAST(POWER(2, 24) AS BIGINT) * 74)), 0,2)
	goto DELETE_ALERT_EXIT
END
--
------------------------------
-- MAKE SURE ALERT EXISTS:	--
------------------------------
IF NOT EXISTS (select 1 from NTnotificationRule WHERE id = @alertId and revision=1 and (status& 2)=0  )
BEGIN
set @errorCode = CAST(0x0B0003 AS INT)
set @errorString = dbo.fn_EvFormatEventMsgText(0,@locale, (143 | (CAST(POWER(2, 24) AS BIGINT) * 74)), 0,2)
	goto DELETE_ALERT_EXIT
END
ELSE
	Set @alertName = (SELECT notificationName from NTnotificationRule WHERE id = @alertId)
--------------------------------
--  Security check --
--------------------------------
--Only users with 'Delete Alert' permission on the alert can delete the alert
DECLARE @userHasRight INT = 0
EXEC sec_checkPermissionOnEntity @callerID, 153, @userHasRight OUTPUT, 64, @alertId
IF @userHasRight = 0
BEGIN
SET @errorCode = (2409 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2409 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale)
    SET @errorString = REPLACE(@errorString, '^1%s', ISNULL((SELECT login FROM UMUsers WHERE id = @callerID),''))
SET @errorString = REPLACE(@errorString, '^2%s', (SELECT message FROM EvLocaleMsgs WHERE messageId = (2816 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale))
    SET @errorString = REPLACE(@errorString, '^3%s', @alertName)
SET @errorString = REPLACE(@errorString, '^4%s', (SELECT message FROM EvLocaleMsgs WHERE messageId = (2812 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale))
    GOTO DELETE_ALERT_EXIT
END
-- First mark all rule based detected alerts processed.
Update NTdetectedAlerts
set processStat=8
where ntNotificationId=@alertId
-- -------------------------------------------------------------------------------
-- DELETES ARE NOW ALL LOGICAL, PHYSICAL DELETION WOULD REQUIRE A "PURGE" SP	--
-- -------------------------------------------------------------------------------
UPDATE NTnotificationRule SET revision = 0 , status = 2
	WHERE id = @alertId AND revision > 0
--Delete from the JMJobInfo
UPDATE JMJobInfo SET jobBasedAlertId = 0, alertName = N'', lastStateChangeTime = dbo.GetUnixTime(GETUTCDATE())*2147483648 where jobBasedAlertId = @alertId
Update ntdetectedAlerts
set processStat=8
where ntNotificationId is not null and ntNotificationId=@alertId
-- RSS cleanup
-- Set all rss items to be cleanup that belong to this alertId
-- Set rsschannel to be deleted if this is the only alert that references it
SET @channelId = (SELECT DISTINCT rssId from NTMessageFormat where NTNotificationId = @alertId and messageType = 1024)
UPDATE RssItem set status = 1 where channelID = @channelId and externID = @alertId
SET @count = (SELECT refCount from RssChannel where channelID = @channelId)
SET @count = @count - (SELECT COUNT(*) from NTMessageFormat where NTNotificationId = @alertId and messageType = 1024 and rssId = @channelId)
UPDATE RssChannel set refCount = @count where channelID = @channelId
--Delete Security Associations that belong to this alert
EXEC sec_deleteSecurityAssociationsForEntity 64, @alertId
-- Check if its failover configuration alert and send workqueue request to all failover nodes.
INSERT INTO APP_WorkQueueRequest (clientId, workToken, workTokenParams, createTime, lastUpdateTime, retryCount, flag, remoteClient)
SELECT C.Id,
	@workTokenId,
	'',
	dbo.GetUnixTime(GetUTCDate()), 0, 0, 0, -1
	FROM SimInstalledPackages  WITH (READUNCOMMITTED)
    INNER JOIN App_client C WITH (READUNCOMMITTED) on SimInstalledPackages.clientId = C.Id
AND (C.status&2)=0 and simPackageID IN (24, 1024)
	INNER JOIN NTAlertType WITH (READUNCOMMITTED) ON NTAlertType.ID = @alertTypeID
AND  ( NTAlertType.actionsAllowed & 1024 ) > 0
SET @errorString = dbo.fn_EvFormatEventMsgText(0,@locale, (169 | (CAST(POWER(2, 24) AS BIGINT) * 74)), 0,2) + N' : ' + @alertName
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    	SET @errorCode = 2
SET @errorString = dbo.fn_EvFormatEventMsgText(0,@locale, (170 | (CAST(POWER(2, 24) AS BIGINT) * 74)), 0,2) + N' : ' + @alertName
END CATCH
---------------------------------------------
-- SEND THE RESPONSE TO THE GUI           ---
---------------------------------------------
DELETE_ALERT_EXIT:
---------------------------------------------
-- THIS IS THE RESPONSE IF ALL WENT WELL ----
---------------------------------------------
-- Doing below so that we can use "insert into" query from romspopulatealerts. Its called from PostUpgrade script execsetcsdb
-- (romspopulatealerts). Insert into is not allowed for "For xml"
select (
	SELECT	1			         as TAG,
		NULL		         as Parent,
		@errorCode			     as [CVGui_GenericResp!1!errorCode],
		@errorString	         as [CVGui_GenericResp!1!errorMessage]
	FOR XML EXPLICIT
) as o_responseXML
if (@errorCode = 0)
    COMMIT TRAN
else
    ROLLBACK TRAN
SET NOCOUNT OFF
--   END
GO

IF EXISTS (select * from GxQscripts where name = 'br_NTAlertDelete')
	delete from GxQscripts where name = 'br_NTAlertDelete'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_NTAlertDelete')
	delete from GXDBVersions where aliasname = 'br_NTAlertDelete'
GO

insert into GXDBVersions values(2, 'br_NTAlertDelete',  '00010022003200070000', 'br_NTAlertDelete', '00010022003200070000')
GO

