

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/br_NTAlertCreate.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/br_NTAlertCreate.sp,v $ $Id: br_NTAlertCreate.sp,v 1.70.12.19 2020/11/27 16:59:25 kbora Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   br_ntAlertCreate   - Create the new alert definition
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='br_ntAlertCreate')
BEGIN
	print '>>> Drop Stored Procedure: br_ntAlertCreate <<<'
	drop procedure br_ntAlertCreate
END
IF EXISTS (select * from GxQscripts where name='br_ntAlertCreate')
	delete from GxQscripts where name = 'br_ntAlertCreate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_ntAlertCreate')
	delete from GXDBVersions where aliasname = 'br_ntAlertCreate'
GO
print '... Creating Procedure: br_ntAlertCreate'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure br_ntAlertCreate
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @ownerID int,
  @userLocale int,
  @xmlString NTEXT,
  @xmlEntities NTEXT
AS
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  BEGIN
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
SET NOCOUNT ON
declare @iDoc     				int
declare @locale					int					-- THIS WILL BE THE LOCALE FOR THE ALERT, USUALLY THE USER LOCALE
declare @eventCriteriaXml		nvarchar(max)
declare @tokenRuleXml    		nvarchar(max)
declare @customQueryDetailsXml	xml
declare @minJobCountForJobAnomaly	    int
declare @alertName 				nvarchar(255)
declare @alertCategoryId		int
declare @alertCategoryName		varchar(128)
declare @hasEscalation			int
declare @alertTypeID   			integer
declare @alertTypeName			varchar(128)
declare @description			nvarchar(1024)
declare @selrunarguments		nvarchar(1024)
declare @selrunEsclationId		integer
declare @notifMsg				nvarchar(MAX)
declare @selCriteriaId			integer
declare @availCriteriaid		integer
declare @esclationLevel			integer
declare @ruleid					integer
declare @notificationId			integer             -- PK referenced by everybody!
declare @notifType				integer
declare @selCriId				integer
declare @selCricriteriaId		integer
declare @selCriEsclationId		integer
declare @selCriparamIndex				integer
declare @selCritype			integer
declare @selCrivalue		integer
declare @selCriunit		integer
declare @taskId				integer			-- SRM CHANGE
declare @sValue					nvarchar(2048)
declare @hasAttachments			integer
declare @hasAttachments2		integer
declare @status   			integer
declare @timeStamp				integer
declare @errorCode              integer
declare @errorString            nvarchar(1024)
declare @copyrightString		nvarchar(MAX)
declare @rssFeed				nvarchar(MAX)
declare @tstring				nvarchar(MAX)
declare @tpasstring				nvarchar(MAX)
declare @baseLocation			nvarchar(MAX)
declare @channelName			nvarchar(MAX)
declare @retVal					integer
declare @channelId				integer
declare @count					integer
declare @messageHtml			nvarchar(MAX)
-- for apptype filter
declare @_type_  int
declare @appGroupId  int
declare @applicationId  int
-- sender details in alert
declare @senderEmailId nvarchar(512)
declare @senderDisplayName nvarchar(512)
-- For CCM
declare @origCCID				integer
declare @GUID					varchar(40)
declare @isHtmlEncoding			integer
declare @messageFormatType		integer
declare @messageType			integer
declare @checkForEventParams    integer
DECLARE @workTokenId			INTEGER	= 47 -- WORK_TOKEN_REFRESH_ALERT_CONFIG
DECLARE @xmlInPutReq           	XML
DECLARE @isLinuxCs 			   	INT = ~dbo.IsOSOnCSWindows()
SET @xmlInPutReq=  CONVERT(XML,@xmlString)
SET @timeStamp = dbo.GetUnixTime (GetUTCdate())
set @errorCode = 0				  -- Assume it will work!
set @hasAttachments2 = 0		-- TODOTODO   ANAND .... THIS NEEDS TO BE SET SOMEWHERE TODOTODOTODO
set @hasAttachments = 0			-- TODOTODO   ANAND .... THIS NEEDS TO BE SET SOMEWHERE TODOTODOTODO
declare @brAlertTrace			varchar(256)
set @brAlertTrace				=(select value from gxglobalParam Where name = 'bralertTrace')
set @brAlertTrace               = ISNULL(@brAlertTrace, 0)
DECLARE @alertSeverity INTEGER = 0	-- Having the severity in the ruleState column of NTNotificationRule
DECLARE @escalationSeverity INTEGER = 0	-- Having the severity in the ruleState2 column of NTNotificationRule
----------------------------------------------------------
--	FETCH PARAMETERS FROM THE XML STRING PASSED IN	--
----------------------------------------------------------
if @brAlertTrace <> 0
	exec br_ntTrace '.. br_ntAlertCreate', 0, 0, 0, 0, @xmlString
EXEC sec_updateUserCredentials @ownerID								-- Really only need this for SRM Reports (Thresholds)
exec sp_xml_preparedocument @iDoc OUTPUT, @xmlString
set @locale          =  ISNULL((select * from OPENXML(@iDoc, 'CVGui_AlertCreateReq/alertDetail/locale', 0)
						WITH (localeID int '@localeID')), @userLocale)
set @eventCriteriaXml = ISNULL((select * from OPENXML(@iDoc, 'CVGui_AlertCreateReq/alertDetail', 0)
						WITH (eventCriteriaXml nvarchar(max) '@eventCriteriaXML')), '')
set @tokenRuleXml = ISNULL((select * from OPENXML(@iDoc, 'CVGui_AlertCreateReq/alertDetail', 0)
						WITH (alertTokenRuleGroupXml nvarchar(max) '@alertTokenRuleGroupXml')), '')
set @customQueryDetailsXml = ISNULL((select * from OPENXML(@iDoc, 'CVGui_AlertCreateReq/alertDetail', 0)
						WITH (customQueryDetailsXml nvarchar(max) '@customQueryDetailsXml')), '')
set @minJobCountForJobAnomaly = ISNULL((select * from OPENXML(@iDoc, 'CVGui_AlertCreateReq/alertDetail', 0)
								WITH (minJobCountForJobAnomaly nvarchar(max) '@minJobCountForJobAnomaly')),0)
set @alertName 		 = (select * from OPENXML(@iDoc, 'CVGui_AlertCreateReq/alertDetail/alert/alert', 0)
				 WITH (name nvarchar(255) '@name'))
set @alertCategoryId	 = (select * from OPENXML(@iDoc, 'CVGui_AlertCreateReq/alertDetail/alert/alertCategory', 0)
				 WITH (id int '@id'))
set @alertCategoryName	 = (select * from OPENXML(@iDoc, 'CVGui_AlertCreateReq/alertDetail/alert/alertCategory', 0)
				 WITH (name nvarchar(128) '@name'))
set @alertTypeID	 = (select * from OPENXML(@iDoc, 'CVGui_AlertCreateReq/alertDetail/alert/alertType', 0)
				 WITH (id int '@id'))
set @alertTypeName	 = (select * from OPENXML(@iDoc, 'CVGui_AlertCreateReq/alertDetail/alert/alertType', 0)
				 WITH (name nvarchar(128) '@name'))
set @notifType	 = (select * from OPENXML(@iDoc, 'CVGui_AlertCreateReq/alertDetail/alert', 0)
				 WITH (notifType int '@notifType'))
SET @notifType = @notifType | 131072
IF @isLinuxCs = 1
SET @notifType = @notifType & (~8)
set @status	 = (select * from OPENXML(@iDoc, 'CVGui_AlertCreateReq/alertDetail/alert', 0)
				 WITH (status int '@status'))
set @description = (select * from OPENXML(@iDoc, 'CVGui_AlertCreateReq/alertDetail/alert', 0)
				 WITH (description varchar(128) '@description'))
if (@description IS null)
	set @description = ''
set @origCCID = (select * from OPENXML(@iDoc, 'CVGui_AlertCreateReq/alertDetail/alert', 0)
				 WITH (origCCID int '@origCCID'))
if(@origCCID IS null) or (@origCCID = 0)
	set @origCCID = 2
set @GUID = (select * from OPENXML(@iDoc, 'CVGui_AlertCreateReq/alertDetail/alert', 0)
				 WITH (GUID varchar(40) '@GUID'))
if(@GUID IS null) or (@GUID = '')
	set @GUID = NEWID()
set @taskId = ISNULL((select taskId from OPENXML(@iDoc, 'CVGui_AlertCreateReq/alertDetail/criteria', 0)
							WITH (taskId int '@taskId', criteriaId int)
							Where criteriaId = 200), 0)    --NT_SRM_CRITERIA_TRIGGER_REPORT
set	@sValue	= ISNULL((select value from OPENXML(@iDoc, 'CVGui_AlertCreateReq/alertDetail/criteria', 0)			-- SRM
							WITH (value nvarchar(2048) '@value', criteriaId nvarchar(2048))
							Where criteriaId = 200), 0)	    --NT_SRM_CRITERIA_TRIGGER_REPORT
set	@checkForEventParams = (select * from OPENXML(@iDoc, 'CVGui_AlertCreateReq/alertDetail', 0)
				 WITH (checkForEventParams varchar(40) '@checkForEventParams'))
set	@senderDisplayName = (select * from OPENXML(@iDoc, 'CVGui_AlertCreateReq/alertDetail', 0)
				WITH (senderDisplayName varchar(40) '@senderDisplayName'))
set	@senderEmailId = (select * from OPENXML(@iDoc, 'CVGui_AlertCreateReq/alertDetail', 0)
				WITH (senderEmailId varchar(40) '@senderEmailId'))
DECLARE @tranCount integer = @@TRANCOUNT
DECLARE @isTranStarted INT = 0
IF (@trancount = 0)
BEGIN
      BEGIN TRAN
      SET @isTranStarted = 1
END
------------------------------------------------------------------------------------
--  SECURITY CHECKS --
------------------------------------------------------------------------------------
-- Check whether the alert type is disabled. If so, dont allow creation.
If exists(select 1 from NTalertType where id=@alertTypeID and (actionsAllowed&8)>0)
begin
SET @errorCode = (1244 | (CAST(POWER(2, 24) AS BIGINT) * 74))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (1244 | (CAST(POWER(2, 24) AS BIGINT) * 74)) and localeid = @locale)
	-- if string is not there for that locale, take it from english locale
	if @errorString is null or len(@errorString)=0
	begin
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (1244 | (CAST(POWER(2, 24) AS BIGINT) * 74)) and localeid = 0)
	end
	GOTO CREATE_EXIT
end
--Only users with 'Create Alert' permission on commcell can create the alert
DECLARE @userHasRight INT = 0
EXEC sec_checkPermissionOnEntity @ownerId, 151, @userHasRight OUTPUT, 1, 2
IF @userHasRight = 0
BEGIN
SET @errorCode = (2408 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2408 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale)
	SET @errorString = REPLACE(@errorString, '^1%s', ISNULL((SELECT CASE WHEN name <> '' THEN name ELSE login END FROM UMUsers WHERE id = @ownerId),''))
SET @errorString = REPLACE(@errorString, '^2%s', (SELECT message FROM EvLocaleMsgs WHERE messageId = (2814 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale))
SET @errorString = REPLACE(@errorString, '^3%s', (SELECT message FROM EvLocaleMsgs WHERE messageId = (468 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale))
	GOTO CREATE_EXIT
END
--Check if user has permission on entities to associate the entities to the alert
IF @alertCategoryId <> 9 --No need to check pemissions on entitylist for custom alerts
BEGIN
	DECLARE @isAllowed INT = 0
	DECLARE @entitiesNotAllowed NVARCHAR(MAX) = N''
	DECLARE @permissionId Int = 0
	set @permissionId = dbo.NTGetPermissionForEntityAssociation(@alertTypeID)
	EXEC sec_checkPermissionOnEntityList @ownerId, @locale, @xmlEntities, N'', @permissionId, @isAllowed OUTPUT, @entitiesNotAllowed OUTPUT
	IF @isAllowed = 0
	BEGIN
SET @errorCode = (1197 | (CAST(POWER(2, 24) AS BIGINT) * 74))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (1197 | (CAST(POWER(2, 24) AS BIGINT) * 74)) and localeid = @locale)
		SET @errorString = REPLACE(@errorString, '^1%s', ISNULL((SELECT CASE WHEN name <> '' THEN name ELSE login END FROM UMUsers WHERE id = @ownerId),''))
		SET @errorString = REPLACE(@errorString, '^2%s', @entitiesNotAllowed)
		GOTO CREATE_EXIT
	END
END
--Admin alert can only be created by users with admin capabilities
IF @alertTypeID = 75
	BEGIN
		DECLARE @isAdmin INT = 0
EXEC DBO.sec_checkPermissionOnEntity @ownerID , 1, @isAdmin OUTPUT, 1, 2
		IF @isAdmin = 0
		BEGIN
SET @errorCode = (1878 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (1878 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale)
			GOTO CREATE_EXIT
		END
	END
--Check if recipients associated to the alert are visible to user
DECLARE @usersList TABLE
(
	userId INT
)
IF OBJECT_ID('tempdb.dbo.#usersForUser') IS NOT NULL
	DROP TABLE #usersForUser
CREATE TABLE #usersForUser (userId INT)
--Get the associated users list
INSERT INTO @usersList (userId)
	SELECT id1
		FROM OPENXML(@iDoc, 'CVGui_AlertCreateReq/alertDetail/userList', 0)
		WITH (id1 int)
--Get the list of users visible to the user
EXEC sec_getUsersForThisUser '#usersForUser', @ownerId
--Check if users are visible to the user to associate as new recipients and remove old recipients
IF EXISTS (SELECT 1 FROM @usersList tbl1 LEFT OUTER JOIN #usersForUser tbl2
						ON tbl1.userId = tbl2.userId
					WHERE tbl2.userId IS NULL)
BEGIN
	DECLARE @usersNotAllowed NVARCHAR(MAX) = N''
	SET @usersNotAllowed = STUFF((SELECT ', ' + users.name
											FROM (SELECT tbl1.userId FROM @usersList tbl1 LEFT OUTER JOIN #usersForUser tbl2
														ON tbl1.userId = tbl2.userId
													WHERE tbl2.userId IS NULL) as tbl
											INNER JOIN UMUsers users
												ON tbl.userId = users.id
											FOR XML PATH('')),1,2,'')
SET @errorCode = (1195 | (CAST(POWER(2, 24) AS BIGINT) * 74))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (1195 | (CAST(POWER(2, 24) AS BIGINT) * 74)) and localeid = @locale)
	SET @errorString = REPLACE(@errorString, '^1%s', ISNULL((SELECT CASE WHEN name <> '' THEN name ELSE login END FROM UMUsers WHERE id = @ownerId),''))
	SET @errorString = REPLACE(@errorString, '^2%s', @usersNotAllowed)
	GOTO CREATE_EXIT
END
DROP TABLE #usersForUser
DECLARE @userGroupsList TABLE
(
	userGroupId INT
)
IF OBJECT_ID('tempdb.dbo.#userGroupsForUser') IS NOT NULL
	DROP TABLE #userGroupsForUser
CREATE TABLE #userGroupsForUser (userGroupId INT)
--Get the associated local and external user groups list
INSERT INTO @userGroupsList (userGroupId)
	SELECT id1
		FROM OPENXML(@iDoc, 'CVGui_AlertCreateReq/alertDetail/userGroupList', 0)
		WITH (id1 int)
	UNION
	SELECT id1
		FROM OPENXML(@iDoc, 'CVGui_AlertCreateReq/alertDetail/externalGroupList', 0)
		WITH (id1 int)
--Get the list of local and external user groups visible to the user
EXEC sec_getUserGroupsForThisUser '#userGroupsForUser', @ownerId
--Check if user groups are visible to the user to associate as new recipients and remove old recipients
IF EXISTS (SELECT 1 FROM @userGroupsList tbl1 LEFT OUTER JOIN #userGroupsForUser tbl2
						ON tbl1.userGroupId = tbl2.userGroupId
					WHERE tbl2.userGroupId IS NULL)
BEGIN
	DECLARE @groupsNotAllowed NVARCHAR(MAX) = N''
	SET @groupsNotAllowed = STUFF((SELECT ', ' + groups.name
											FROM (SELECT tbl1.userGroupId FROM @userGroupsList tbl1 LEFT OUTER JOIN #userGroupsForUser tbl2
														ON tbl1.userGroupId = tbl2.userGroupId
													WHERE tbl2.userGroupId IS NULL) as tbl
											INNER JOIN UMGroups groups
												ON tbl.userGroupId = groups.id
											FOR XML PATH('')),1,2,'')
SET @errorCode = (1196 | (CAST(POWER(2, 24) AS BIGINT) * 74))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (1196 | (CAST(POWER(2, 24) AS BIGINT) * 74)) and localeid = @locale)
	SET @errorString = REPLACE(@errorString, '^1%s', ISNULL((SELECT CASE WHEN name <> '' THEN name ELSE login END FROM UMUsers WHERE id = @ownerId),''))
	SET @errorString = REPLACE(@errorString, '^2%s', @groupsNotAllowed)
	GOTO CREATE_EXIT
END
DROP TABLE #userGroupsForUser
IF((@notifType & 65536)=65536)
	BEGIN
	    DECLARE @workFlowId INTEGER
		SET @workFlowId=ISNULL((select top 1 workflowId from OPENXML(@iDoc,'CVGui_AlertCreateReq/alertDetail/notifMsgs',0)
						WITH (workflowId int 'entity/@workflowId' , notifType int,esclationLevel int)
WHERE notifType=65536 and esclationLevel=1),0)
		IF(@workFlowId<>0)
		BEGIN
exec br_NTPermCheck @ownerId,@locale,33, 14033,@workFlowId,@errorCode OUTPUT,@errorString OUTPUT
			IF @errorCode<>0
			goto CREATE_EXIT
		END
		SET @workFlowId=ISNULL((select top 1 workflowId from OPENXML(@iDoc,'CVGui_AlertCreateReq/alertDetail/notifMsgs',0)
						WITH (workflowId int 'entity/@workflowId' , notifType int,esclationLevel int)
WHERE notifType=65536 and esclationLevel=2),0)
		IF(@workFlowId<>0)
		BEGIN
exec br_NTPermCheck @ownerId,@locale,33, 14033,@workFlowId,@errorCode OUTPUT,@errorString OUTPUT
			IF @errorCode<>0
			goto CREATE_EXIT
		END
	END
SET  @alertSeverity = ISNULL((SELECT alertSeverity FROM OPENXML(@iDoc, 'CVGui_AlertCreateReq/alertDetail',0)
							WITH (alertSeverity INTEGER '@alertSeverity')),0)
SET  @escalationSeverity = ISNULL((SELECT escalationSeverity FROM OPENXML(@iDoc, 'CVGui_AlertCreateReq/alertDetail',0)
							WITH (escalationSeverity INTEGER '@escalationSeverity')),0)
------------------------------------------------------------------------------------
--  GATHERED ENOUGH INFORMATION, TIME TO START INSERTING SOME DATA TO THE TABLES! --
------------------------------------------------------------------------------------
IF NOT EXISTS (SELECT NTNotificationRule.id FROM  NTNotificationRule
	left join NTNotificationProp on NTNotificationRule.id=NTNotificationProp.componentNameId
and NTNotificationProp.attrname='OrganizationId' and IsNumeric(NTNotificationProp.attrval)>0
	WHERE notificationName = @alertName and NTNotificationRule.revision>0
	and IsNull(NTNotificationProp.attrval,0)=0)
BEGIN
	INSERT INTO NTnotificationRule (categoryId, alertTypeId, notificationName, revision, lastModified,description, notifOwner,
			notifType, status,locale, lastTimeTriggered,  lastTimeChecked, ruleState, ruleState2, hasAttachments, hasAttachments2,  xmlEntityList, origCCId, GUID
	)VALUES ( @alertCategoryId,  @alertTypeID, @alertName,  1, @timeStamp,@description,	@ownerID, @notifType, @status, @locale,
			 0, 0, @alertSeverity, @escalationSeverity,  @hasAttachments, @hasAttachments2, @xmlEntities, @origCCID, @GUID )
	SET @notificationId = @@IDENTITY
	set @errorCode = @@error
	INSERT INTO NTmessages (NTnotificationID, escalationLevel, lastSetMessageTime, firstDetectTime, NTmessageState)
		VALUES (@notificationID, 1, null, null, 0)
	INSERT INTO NTmessages (NTnotificationID, escalationLevel, lastSetMessageTime, firstDetectTime, NTmessageState)
		VALUES (@notificationID, 2, null, null, 0)
	set @errorCode = @@error
	-----------------------
	-- User & Group List --
	-----------------------
	INSERT INTO  NTnotificationUsers (NTnotificationID, userId, escalationLevel, recipientType)
		SELECT @notificationID, id1, id2 ,0
		  FROM OPENXML(@iDoc, 'CVGui_AlertCreateReq/alertDetail/userList', 0)
			WITH (id1 int, id2  int)
	INSERT INTO  NTnotificationUsers (NTnotificationID, userId, escalationLevel, recipientType)
		SELECT @notificationID, id1, id2, 1
		  FROM OPENXML(@iDoc, 'CVGui_AlertCreateReq/alertDetail/userListCc', 0)
			WITH (id1 int, id2  int)
	INSERT INTO  NTnotificationUsers (NTnotificationID, userId, escalationLevel, recipientType)
		SELECT @notificationID, id1, id2, 2
		  FROM OPENXML(@iDoc, 'CVGui_AlertCreateReq/alertDetail/userListBcc', 0)
			WITH (id1 int, id2  int)
	set @errorCode = @@error
	INSERT INTO  NTnotificationGroups (NTnotificationID, groupId, escalationLevel, recipientType)
		SELECT  @notificationID, id1, id2, 0
		  FROM OPENXML(@iDoc, 'CVGui_AlertCreateReq/alertDetail/userGroupList', 0)
			WITH (id1 int,  id2 int)
	INSERT INTO  NTnotificationGroups (NTnotificationID, groupId, escalationLevel, recipientType)
		SELECT  @notificationID, id1, id2, 1
		  FROM OPENXML(@iDoc, 'CVGui_AlertCreateReq/alertDetail/userGroupListCc', 0)
			WITH (id1 int,  id2 int)
	INSERT INTO  NTnotificationGroups (NTnotificationID, groupId, escalationLevel, recipientType)
		SELECT  @notificationID, id1, id2, 2
		  FROM OPENXML(@iDoc, 'CVGui_AlertCreateReq/alertDetail/userGroupListBcc', 0)
			WITH (id1 int,  id2 int)
	set @errorCode = @@error
	--------------------------
	-- External Group List ---
	--------------------------
	INSERT INTO  NTnotificationExternalGroups (NTnotificationID, externalgroupId, escalationLevel, recipientType)
		SELECT  @notificationID, id1, id2, 0
		  FROM OPENXML(@iDoc, 'CVGui_AlertCreateReq/alertDetail/externalGroupList', 0)
			WITH (id1 int,  id2 int)
	INSERT INTO  NTnotificationExternalGroups (NTnotificationID, externalgroupId, escalationLevel, recipientType)
		SELECT  @notificationID, id1, id2, 1
		  FROM OPENXML(@iDoc, 'CVGui_AlertCreateReq/alertDetail/externalGroupListCc', 0)
			WITH (id1 int,  id2 int)
	INSERT INTO  NTnotificationExternalGroups (NTnotificationID, externalgroupId, escalationLevel, recipientType)
		SELECT  @notificationID, id1, id2, 2
		  FROM OPENXML(@iDoc, 'CVGui_AlertCreateReq/alertDetail/externalGroupListBcc', 0)
			WITH (id1 int,  id2 int)
	set @errorCode = @@error
	--------------------------
	-- Non-Galaxy User List ---
	--------------------------
	INSERT INTO  NTnotificationNonGalaxyUsers (NTnotificationID, nonGalaxyUserName, escalationLevel, recipientType)
		SELECT  @notificationID, name, id2, 0
		  FROM OPENXML(@iDoc, 'CVGui_AlertCreateReq/alertDetail/nonGalaxyUserList', 0)
			WITH (name nvarchar(255),  id2 int)
	INSERT INTO  NTnotificationNonGalaxyUsers (NTnotificationID, nonGalaxyUserName, escalationLevel, recipientType)
		SELECT distinct @notificationID, name, id2, 1
		  FROM OPENXML(@iDoc, 'CVGui_AlertCreateReq/alertDetail/nonGalaxyUserListCc', 0)
			WITH (name nvarchar(255),  id2 int)
	INSERT INTO  NTnotificationNonGalaxyUsers (NTnotificationID, nonGalaxyUserName, escalationLevel, recipientType)
		SELECT distinct @notificationID, name, id2, 2
		  FROM OPENXML(@iDoc, 'CVGui_AlertCreateReq/alertDetail/nonGalaxyUserListBcc', 0)
			WITH (name nvarchar(255),  id2 int)
	set @errorCode = @@error
	-------------------------------------
	-- Apptype and AppGroup Filter list--
	-------------------------------------
	Insert into NTNotificationProp(componentNameId,attrName,attrType,attrVal,created,modified)
select @notificationId,'App Type Filter','7',applicationId,dbo.GetUnixTime(GETUTCDATE()),0
		 FROM OPENXML(@iDoc, 'CVGui_AlertCreateReq/alertDetail/appTypeFilters/appTypeFilter', 0)
		   with(_type_ int,applicationId int)
WHERE _type_=79
	Insert into NTNotificationProp(componentNameId,attrName,attrType,attrVal,created,modified)
select @notificationId,'App Group Filter','7',appGroupId,dbo.GetUnixTime(GETUTCDATE()),0
		 FROM OPENXML(@iDoc, 'CVGui_AlertCreateReq/alertDetail/appTypeFilters/appTypeFilter', 0)
		   with(_type_ int,appGroupId int)
WHERE _type_=78
	set @errorCode = @@error
	--------------------------------------
	---sender details for email alert-----
	--------------------------------------
	IF @senderEmailId is not null AND @senderEmailId <> N''
		Insert into NTNotificationProp(componentNameId,attrName,attrType,attrVal,created,modified)
values ( @notificationId,'Sender MailId','1',@senderEmailId,dbo.GetUnixTime(GETUTCDATE()),0)
	IF @senderDisplayName is not null AND @senderDisplayName <> N''
		Insert into NTNotificationProp(componentNameId,attrName,attrType,attrVal,created,modified)
values ( @notificationId,'Sender Display Name','1',@senderDisplayName,dbo.GetUnixTime(GETUTCDATE()),0)
	set @errorCode = @@error
	--------------------------
	-- SRM Data				--
	--------------------------
	--IF @taskId <> 0 -- AND EXISTS (select * from sysobjects where name = 'RSReportThresholds')
	--		INSERT  RSReportThresholds VALUES (@notificationId, 0, @sValue, @taskId)
	-- Run Command --
	--------------------------
	INSERT INTO  NTnotificationAction (NTnotificationID, escalationLevel, useImpersonation, useNetworkShare,
				runAsUserLogin, runAsUserPassword, runCommand, arguments)
		SELECT  @notificationID,esclationLevel,  impersonateUser , useNetworkShare,  loginName, cvpassword, cmdPath, arguments
			FROM OPENXML(@iDoc, 'CVGui_AlertCreateReq/alertDetail/runCommands', 0)
				WITH (enabled int,  esclationLevel int, impersonateUser int,  loginName nvarchar(128), cvpassword nvarchar(128) ,
				useNetworkShare int, cmdPath nvarchar(1024), arguments nvarchar(1024) )
			WHERE cmdPath <> ''
	--Insert the arguments
	DECLARE	GetSelRunCmdCursor CURSOR FOR
	SELECT arguments,escalationLevel FROM NTnotificationAction where  NTnotificationID = @notificationID
	OPEN GetSelRunCmdCursor
	FETCH GetSelRunCmdCursor INTO @selrunarguments, @selrunEsclationId
	WHILE	@@FETCH_STATUS = 0
	BEGIN
		INSERT INTO  NTmessageFormat  ( NTnotificationID,   messageType,     formatString, escalationLevel,
				formattedMessage, subjFieldStart, subjFieldLen, MsgBodyStart, MsgBodyLen,messageFormatType, formatStringHtml)
VALUES (@notificationID, 16, @selrunarguments, @selrunEsclationId ,
				'', 0, 0, 0, 0,0,'')
		FETCH GetSelRunCmdCursor INTO @selrunarguments, @selrunEsclationId
	END
	CLOSE GetSelRunCmdCursor
	DEALLOCATE GetSelRunCmdCursor
	set @errorCode = @@error
	--------------------------
	-- Selected Criteria --
	--------------------------
	INSERT INTO  NTSelCriteria (availCriteriaid, esclationLevel, ruleId, reportingOptions, delayTimeSeconds,
				persistTimeSeconds)
		SELECT  criteriaId, esclationLevel,  @notificationID, reportingOptions, delayTimeSeconds,persistTimeSeconds
		  FROM OPENXML(@iDoc, 'CVGui_AlertCreateReq/alertDetail/criteria', 0)
			WITH (criteriaId int,  esclationLevel int,
			reportingOptions int, delayTimeSeconds int, persistTimeSeconds int )
	set @errorCode = @@error
	--------------------------
	-- Selected Criteria Params--
	--------------------------
	--Create temp table and store the values
	IF object_id('tempdb.dbo.#tempNTSelCriteriaParams') IS NOT null DROP TABLE #tempNTSelCriteriaParams
	create table #tempNTSelCriteriaParams ( criteriaId int, esclationLevel int,  paramIndex int, type int, value int, unit int)
	INSERT INTO  #tempNTSelCriteriaParams ( criteriaId,esclationLevel,  paramIndex, type,  value, unit)
			SELECT  criteriaId, esclationLevel,  paramIndex, type,  value,unit
			FROM OPENXML(@iDoc, 'CVGui_AlertCreateReq/alertDetail/criteria/criteriaParams', 0)
				WITH (criteriaId int '../@criteriaId',  esclationLevel int '../@esclationLevel', paramIndex int,  type int,  value int, unit int )
	DECLARE	GetSelCriteriaCursor CURSOR FOR
	SELECT criteriaId,esclationLevel, paramIndex, type, value, unit FROM #tempNTSelCriteriaParams
	OPEN GetSelCriteriaCursor
	FETCH GetSelCriteriaCursor INTO @selCricriteriaId, @selCriEsclationId, @selCriparamIndex, @selCritype, @selCrivalue, @selCriunit
	WHILE	@@FETCH_STATUS = 0
	BEGIN
		SELECT 	@selCriId = id from NTSelCriteria where availCriteriaid = @selCricriteriaId AND esclationLevel =  @selCriEsclationId AND ruleId =  @notificationID
		INSERT INTO  NTSelCriteriaParams VALUES( @selCriId, @selCriparamIndex,  @selCritype, @selCrivalue, @selCriunit, 0)
		FETCH GetSelCriteriaCursor INTO @selCricriteriaId, @selCriEsclationId, @selCriparamIndex, @selCritype, @selCrivalue, @selCriunit
	END
	CLOSE GetSelCriteriaCursor
	DEALLOCATE GetSelCriteriaCursor
	DROP TABLE #tempNTSelCriteriaParams
	set @errorCode = @@error
	--------------------------
	-- Notification Message --
	--------------------------
	INSERT INTO  NTmessageFormat  ( NTnotificationID,   messageType,     formatString, escalationLevel,
				formattedMessage, subjFieldStart, subjFieldLen, MsgBodyStart, MsgBodyLen, mfOptions,messageFormatType,formatStringHtml)
		SELECT @notificationID, notifType, notifMessage, esclationLevel ,
				'', 0, 0, 0, 0, ISNULL(notifOptions, 0), ISNULL(messageFormat, 0), ISNULL(notifMessageHtml,'') from OPENXML(@iDoc, 'CVGui_AlertCreateReq/alertDetail/notifMsgs', 0)
			WITH  (notifType int, notifMessage nvarchar(MAX), esclationLevel int, notifOptions int,messageFormat int,notifMessageHtml nvarchar(MAX) )
WHERE @isLinuxCs = 0 OR (@isLinuxCs = 1 AND notifType & 8 = 0)
	IF NOT EXISTS (SELECT 1 FROM @xmlInPutReq.nodes('CVGui_AlertCreateReq/alertDetail/notifMsgs') as ref(f)
WHERE f.value('(@notifType)[1]','int')=131072)
	BEGIN
		DECLARE @formateString NVARCHAR(1024)
SET @formateString = (SELECT defaultformatString FROM NTnotificationTemplate WHERE messageType = 131072 AND locale = 0 AND messageFormatType = 0 AND NTalertTypeID = @alertTypeID)
IF EXISTS (SELECT 1 FROM NTmessageFormat WHERE NTnotificationID = @notificationID AND messageType = 131072)
		BEGIN
DELETE FROM NTmessageFormat WHERE NTnotificationID = @notificationID AND messageType = 131072
		END
		IF EXISTS (SELECT 1 FROM NTmessageFormat ntf INNER JOIN NTnotificationRule ntr
				ON ntf.NTnotificationID = ntr.id AND (ntr.notifType & ntf.messageType) <> 0
			 WHERE NTnotificationID = @notificationID AND escalationLevel = 1)
		BEGIN
			INSERT INTO  NTmessageFormat  ( NTnotificationID,   messageType,     formatString, escalationLevel,
						formattedMessage, subjFieldStart, subjFieldLen, MsgBodyStart, MsgBodyLen, mfOptions,messageFormatType,formatStringHtml)
SELECT @notificationID,131072,@formateString,1,'',0,0,0,0,0,'',''
		END
		IF EXISTS (SELECT 1 FROM NTmessageFormat ntf INNER JOIN NTnotificationRule ntr
				ON ntf.NTnotificationID = ntr.id AND (ntr.notifType & ntf.messageType) <> 0
			 WHERE NTnotificationID = @notificationID AND escalationLevel = 2)
		BEGIN
			INSERT INTO  NTmessageFormat  ( NTnotificationID,   messageType,     formatString, escalationLevel,
						formattedMessage, subjFieldStart, subjFieldLen, MsgBodyStart, MsgBodyLen, mfOptions,messageFormatType,formatStringHtml)
SELECT @notificationID,131072,@formateString,2,'',0,0,0,0,0,'',''
		END
	END
	-- Now for html alerts alone, to fix the token break issues from GUI, temporarily we fix it here. Currently only for email
	-- We basically replace multiple spaces with single space.
	set @messageHtml = IsNull((SELECT top 1 formatStringHtml FROM NTmessageFormat WHERE 	NTnotificationID = @notificationId
and messageType = 1 and escalationLevel = 1),'')
	--This is for temp fix for LM Alert attachments files to prune, SMTP_FLAGS_KEEP_ATTACHMENT is always set in delivery flags, files are not getting deleted.
	--So looking at this option mfoptions=2 we know that its LM type Alert, so reset this delivery flag
if ((@alertTypeID=57 OR @alertTypeID=62))
	begin
		UPDATE NTmessageFormat
		SET mfoptions=2
		where NTnotificationID= @notificationID
	end
	while (patIndex('%  %',@messageHtml)>0)
	begin
		set @messageHtml = replace(@messageHtml,'  ',' ')
	end
	-- Once replacement is done, update the table again.
	update NTmessageFormat
	set formatStringHtml = @messageHtml
	WHERE 	NTnotificationID = @notificationId
and messageType = 1 and escalationLevel = 1
	CREATE TABLE #NtRssParams ( ntype integer, elevel integer, channelId integer, location nvarchar(MAX), channelloc nvarchar(MAX), userName nvarchar(MAX), password varchar(MAX))
if ((@notifType & 512) = 512)
	BEGIN
		INSERT INTO #NtRssParams (ntype, elevel, channelId, location, channelloc, userName, password)
		SELECT notifType, esclationLevel, 0, alertLocation, null, loginName, cvpassword
		FROM OPENXML(@iDoc, 'CVGui_AlertCreateReq/alertDetail/notifMsgs/saveAlertToDisk', 0)
		WITH (notifType int '../@notifType',
			  esclationLevel int '../@esclationLevel',
			  alertLocation nvarchar(MAX),
			  loginName nvarchar(MAX),
			  cvpassword varchar(MAX))
	END
if ((@notifType & 1024) = 1024)
	BEGIN
		INSERT INTO #NtRssParams (ntype, elevel, channelId, location, channelloc, userName, password)
		SELECT notifType, esclationLevel, 0, baseLocation, selectedChannel, null, null
		FROM OPENXML(@iDoc, 'CVGui_AlertCreateReq/alertDetail/notifMsgs/feeds', 0)
		WITH (notifType int '../@notifType',
			  esclationLevel int '../@esclationLevel',
			  baseLocation nvarchar(MAX),
			  selectedChannel nvarchar(MAX))
	END
if ((@notifType & 512) = 512)
	BEGIN
--		SET @rssFeed = (SELECT * from OPENXML(@iDoc, 'CVGui_AlertCreateReq/alertDetail/notifMsgs/saveAlertToDisk', 0)
--						WITH (alertLocation nvarchar(MAX)))
SET @rssFeed = ISNULL((SELECT location FROM #NtRssParams where #NtRssParams.ntype = 512 and location <> '' and elevel = 1 ),'')
		if @rssFeed <> ''
		BEGIN
UPDATE NTmessageFormat SET baseDir = @rssFeed where NTnotificationID = @notificationId and messageType = 512 and escalationLevel = 1
SET @tstring = (SELECT userName FROM #NtRssParams where #NtRssParams.ntype = 512 and userName <> '' and elevel = 1)
UPDATE NTmessageFormat SET userName = @tstring where NTnotificationID = @notificationId and messageType = 512 and escalationLevel = 1
SET @tpasstring = (SELECT password FROM #NtRssParams where #NtRssParams.ntype = 512 and password <> '' and elevel = 1)
UPDATE NTmessageFormat SET password = @tpasstring where NTnotificationID = @notificationId and messageType = 512 and escalationLevel = 1
		END
SET @rssFeed = ISNULL((SELECT location FROM #NtRssParams where #NtRssParams.ntype = 512 and location <> '' and elevel = 2 ),'')
		if @rssFeed <> ''
		BEGIN
UPDATE NTmessageFormat SET baseDir = @rssFeed where NTnotificationID = @notificationId and messageType = 512 and escalationLevel = 2
SET @tstring = (SELECT userName FROM #NtRssParams where #NtRssParams.ntype = 512 and userName <> '' and elevel = 2)
UPDATE NTmessageFormat SET userName = @tstring where NTnotificationID = @notificationId and messageType = 512 and escalationLevel = 2
SET @tpasstring = (SELECT password FROM #NtRssParams where #NtRssParams.ntype = 512 and password <> '' and elevel = 2)
UPDATE NTmessageFormat SET password = @tpasstring where NTnotificationID = @notificationId and messageType = 512 and escalationLevel = 2
		END
	END
if ((@notifType & 1024) = 1024)
	BEGIN
--		SET @rssFeed = (SELECT * from OPENXML(@iDoc, 'CVGui_AlertCreateReq/alertDetail/notifMsgs/feeds', 0)
--						WITH (rssFeedLocation nvarchar(MAX)))
SET @baseLocation = (SELECT DISTINCT location FROM #NtRssParams where #NtRssParams.ntype = 1024 and location <> '')
SET @channelName = (SELECT DISTINCT channelloc FROM #NtRssParams where #NtRssParams.ntype = 1024 and channelloc <> '')
		--SET @rssFeed = @baseLocation + '/' + @channelName
--		SET @copyrightString = "Copyright XXXXX @ 2009"
UPDATE NTmessageFormat SET baseDir = @baseLocation where NTnotificationID = @notificationId  and messageType = 1024
		SET @channelId = ISNULL((SELECT channelID from RssChannel where feedLocation = @channelName), 0)
		if (@channelId = 0)
		BEGIN
			INSERT INTO RssChannel (title, feedLocation, language, refCount, publish, feedCount, oldestTime)
			VALUES (@alertName, @channelName, @locale, 1, 1, 0, null)
			SET @channelId = (SELECT channelID from RssChannel where feedLocation = @channelName)
		END
		else
		BEGIN
			SET @count = (SELECT refCount from RssChannel where channelID = @channelId)
			SET @count = @count + 1
			UPDATE RssChannel SET refCount = @count
		END
UPDATE NTmessageFormat SET rssId = @channelId where NTnotificationID = @notificationId  and messageType = 1024
	END
IF((@notifType & 65536)=65536)
	BEGIN
		UPDATE NTmessageFormat
		SET formatString=(select CAST( f.query('entity')AS nvarchar(max)) FROM
				@xmlInPutReq.nodes('CVGui_AlertCreateReq/alertDetail/notifMsgs') as ref(f)
where f.value('(@notifType)[1]','int')=65536 and f.value('(@esclationLevel)[1]','int')=1)
where NTnotificationID = @notificationId and messageType=65536 and escalationLevel=1
IF EXISTS(SELECT * FROM NTmessageFormat where NTnotificationID = @notificationId and messageType=65536 and escalationLevel=2)
				UPDATE NTmessageFormat
				SET formatString=(SELECT CAST( f.query('entity')AS nvarchar(max))
									FROM @xmlInPutReq.nodes('CVGui_AlertCreateReq/alertDetail/notifMsgs') as ref(f)
WHERE f.value('(@notifType)[1]','int')=65536 and f.value('(@esclationLevel)[1]','int')=2)
where NTnotificationID = @notificationId and messageType=65536 and escalationLevel=2
	END
	DROP TABLE #NtRssParams
	set @hasAttachments = 0
	DECLARE	GetAttachCursor CURSOR FOR
	SELECT
		case
			when messageFormatType = 1 then formatStringHtml
			else formatString
		end,
		messageFormatType,
		messageType
FROM NTmessageFormat where  NTnotificationID = @notificationID and ( messageType = 1 or messageType = 512 or messageType = 1024)  and escalationLevel = 1
	OPEN GetAttachCursor
	FETCH GetAttachCursor INTO @notifMsg,@messageFormatType,@messageType
	WHILE	@@FETCH_STATUS = 0
	BEGIN
	-- set @notifMsg = (SELECT formatString FROM NTmessageFormat WHERE 	NTnotificationID = @notificationId and ( messageType = NT_EMAIL_ALERTNOTIF or messageType = NT_SAVE_ALERTNOTIF or messageType = NT_RSS_ALERTNOTIF)  and escalationLevel = 1)
	set @isHtmlEncoding = 0
	if @messageFormatType=1
	begin
		set @isHtmlEncoding = 1
	end
	if @notifMsg is NULL
	begin
		continue
	end
	declare @patStr nvarchar(1024)
set @patStr = N'%' + dbo.getHtmlEscapedString(dbo.fn_EvFormatEventMsgText(0,@locale, (55 | (CAST(POWER(2, 24) AS BIGINT) * 74)), 0,2),@isHtmlEncoding) + N'%'
	if (PATINDEX(@patStr , @notifMsg) > 0)
		set @hasAttachments |= @messageType
set @patStr = N'%' + dbo.getHtmlEscapedString(dbo.fn_EvFormatEventMsgText(0,@locale, (54 | (CAST(POWER(2, 24) AS BIGINT) * 74)), 0,2),@isHtmlEncoding) + N'%'
	if (PATINDEX(@patStr , @notifMsg) > 0)
		set @hasAttachments |= @messageType
set @patStr = N'%' + dbo.getHtmlEscapedString(dbo.fn_EvFormatEventMsgText(0,@locale, (53 | (CAST(POWER(2, 24) AS BIGINT) * 74)), 0,2),@isHtmlEncoding) + N'%'
	if (PATINDEX(@patStr , @notifMsg) > 0)
		set @hasAttachments |= @messageType
set @patStr = N'%' + dbo.getHtmlEscapedString(dbo.fn_EvFormatEventMsgText(0,@locale, (52 | (CAST(POWER(2, 24) AS BIGINT) * 74)), 0,2),@isHtmlEncoding) + N'%'
	if (PATINDEX(@patStr , @notifMsg) > 0)
		set @hasAttachments |= @messageType
set @patStr = N'%' + dbo.getHtmlEscapedString(dbo.fn_EvFormatEventMsgText(0,@locale, (180 | (CAST(POWER(2, 24) AS BIGINT) * 74)), 0,2),@isHtmlEncoding) + N'%'
	if (PATINDEX(@patStr , @notifMsg) > 0)
		set @hasAttachments |= @messageType
	FETCH GetAttachCursor INTO @notifMsg,@messageFormatType,@messageType
	END
	CLOSE GetAttachCursor
	DEALLOCATE GetAttachCursor
	--Update the notification rule
	Update NTnotificationRule
		Set hasAttachments   = @hasAttachments
	WHERE  id = @notificationId AND revision > 0
	--Attachment for escalation
	set @notifMsg = N''
set @notifMsg = (SELECT formatString FROM NTmessageFormat WHERE 	NTnotificationID = @notificationId and messageType = 1 and escalationLevel = 2 AND messageFormatType=0)
	if(LEN(@notifMsg) > 1)
	BEGIN
		set @hasAttachments2 = 0
set @patStr = N'%' + dbo.fn_EvFormatEventMsgText(0,@locale, (55 | (CAST(POWER(2, 24) AS BIGINT) * 74)), 0,2) + N'%'
		if (PATINDEX(@patStr , @notifMsg) > 0)
			set @hasAttachments2 = 1
set @patStr = N'%' + dbo.fn_EvFormatEventMsgText(0,@locale, (54 | (CAST(POWER(2, 24) AS BIGINT) * 74)), 0,2) + N'%'
		if (PATINDEX(@patStr , @notifMsg) > 0)
			set @hasAttachments2 = 1
set @patStr = N'%' + dbo.fn_EvFormatEventMsgText(0,@locale, (53 | (CAST(POWER(2, 24) AS BIGINT) * 74)), 0,2) + N'%'
		if (PATINDEX(@patStr , @notifMsg) > 0)
			set @hasAttachments2 = 1
set @patStr = N'%' + dbo.fn_EvFormatEventMsgText(0,@locale, (52 | (CAST(POWER(2, 24) AS BIGINT) * 74)), 0,2) + N'%'
		if (PATINDEX(@patStr , @notifMsg) > 0)
			set @hasAttachments2 = 1
set @patStr = N'%' + dbo.fn_EvFormatEventMsgText(0,@locale, (180 | (CAST(POWER(2, 24) AS BIGINT) * 74)), 0,2) + N'%'
		if (PATINDEX(@patStr , @notifMsg) > 0)
			set @hasAttachments2 = 1
		--Update the notification rule
		Update NTnotificationRule
			Set hasAttachments2   = @hasAttachments2
		WHERE  id = @notificationId AND revision > 0
	END
		----------------------------------------------------------
		--Update the Job manager table with alert entries--
		----------------------------------------------------------
			DECLARE @iDoc2     int
			DECLARE @rowCount int
			DECLARE @jobCount int
			exec sp_xml_preparedocument @iDoc2 OUTPUT, @xmlEntities
		    set @jobCount = (SELECT count(jobId_l)
		    FROM OPENXML(@iDoc2, 'CVGui_CommCellTreeNode/trackingJobs/jobs', 0)
			WITH (jobId_l int))
			if (@jobCount > 0)
			BEGIN
				UPDATE JMJobInfo SET jobBasedAlertId = @notificationID, alertName = @alertName, lastStateChangeTime = dbo.GetUnixTime(GETUTCDATE())*2147483648
				WHERE jobId in (SELECT jobId_l
				FROM OPENXML(@iDoc2, 'CVGui_CommCellTreeNode/trackingJobs/jobs', 0)
				WITH (jobId_l int))
and commCellId = 2
		    END
	-- Add an entry into for "Simpana Event Log Monitoring" AlertType if criteria is present
if (len(@eventCriteriaXml)>0 and @alertTypeID=58)
	begin
		declare @eventCode nvarchar(max)
		set @eventCode = convert(xml,convert(varchar(max),@eventCriteriaXml)).value('(LogMonitoring_ConditionsList/conditions/column[@columnName=''Event Code'']/../@value1)[1]','nvarchar(max)')
		if @eventCode is null
		begin
			set @eventCode = ''
		end
		-- Check whether repeat condition is selected for event viewer alerts without event code being part of filter.
		if (len(@eventCode)=0 Or convert(xml,convert(varchar(max),@eventCriteriaXml)).exist('LogMonitoring_ConditionsList/conditions/column[@columnName=''Event Code'']')=0)
		begin
			if exists(select 1 from NTSelCriteria where ruleId=@notificationId and persistTimeSeconds>0)
			begin
set @errorCode = (1160 | (CAST(POWER(2, 24) AS BIGINT) * 74))
set @errorString = dbo.fn_EvFormatEventMsgText(0,@locale, (1160 | (CAST(POWER(2, 24) AS BIGINT) * 74)), 0,2)
				goto CREATE_EXIT
			end
		end
		Insert into NTNotificationProp(componentNameId,attrName,attrType,attrVal,created,modified)
select @notificationId,'Match Event Params','7',@checkForEventParams,dbo.GetUnixTime(GETUTCDATE()),0
		if (len(@eventCode)>0)
		begin
			Insert into NTNotificationProp(componentNameId,attrName,attrType,attrVal,created,modified)
select @notificationId,'Event Code filter','1',@eventCode,dbo.GetUnixTime(GETUTCDATE()),0
		end
		declare @templateId int
		-- Only one template for Simpana events. Hence retrieve the template id and store it here.
		select @templateId = templateId
		from
		APP_Template where templateForMonitoringType = 3
		Insert into dbo.NTSimpanaEventCriteria(commcellId,notifRuleId,templateId,criteriaXML,severity)
		select 2,@notificationId,@templateId,@eventCriteriaXml,0
	end
	-- Adding token rule in ntnotificationprop
	if( len(@tokenRuleXml ) >0 )
	BEGIN
	    Insert into NTNotificationProp(componentNameId,attrName,attrType,attrVal,created,modified)
		select @notificationId,'Alert Token Rule Xml','1',@tokenRuleXml,dbo.GetUnixTime(GETUTCDATE()),0
	END
	IF @minJobCountForJobAnomaly > 0
	BEGIN
	-- PROPERTY_INTEGER 7
	 INSERT INTO NTNotificationProp(componentNameId, attrName, attrType, attrVal, created, modified)
VALUES ( @notificationId,	'Minimum Number of Anomalous Jobs', 7, @minJobCountForJobAnomaly,	dbo.GetUnixTime(GETUTCDATE()), 0)
	END
	-- Add an entry into for "Custom Query" AlertType if criteria is present
if (@alertTypeID=65)
	begin
		-- In case its CUSTOM_QUERY alert type, insert all relevant information into the table NTQueryCriteria
		Insert into dbo.NTNotificationQueryMapping
		(QueryId,NtNotificationId ,nextRunTime,isScheduled, criteriaXML,xmlInfo,queryCriteriaString,taskId,queryParamDisplayString)
		select
		ISNULL(Tbl.Col.value('@queryId', 'int'),0) ,
		@notificationId,
		0,
		ISNULL(Tbl.Col.value('@isScheduled', 'int'),0) ,
		ISNULL(Tbl.Col.value('@criteriaListxml', 'nvarchar(max)'),''),
		ISNULL(Tbl.Col.value('@additionalQueryInfo', 'nvarchar(max)'),''),
		ISNULL(Tbl.Col.value('@queryCriteriaString', 'nvarchar(max)'),''),
		0,
		''
		FROM @customQueryDetailsXml.nodes('/CVGui_CustomQueryDetailsForAlert') as Tbl(Col)
		Update dbo.NTNotificationQueryMapping
				set taskId = NTQueryList.taskId,
				queryParamDisplayString =
					case when NTQueryList.queryCriteriaName is not null and len(NTQueryList.queryCriteriaName)>0
					then NTQueryList.queryCriteriaName
					else NTQueryList.queryName
				end
				from NTQueryList
				where NTQueryList.queryId = NTNotificationQueryMapping.queryId
				and NTNotificationQueryMapping.NtNotificationId = @notificationId
		Update dbo.NTNotificationQueryMapping
		set isScheduled = case when NTNotificationQueryMapping.taskId>0 then 1
			else 0
			end
		from NTQueryList
		where NTQueryList.queryId = NTNotificationQueryMapping.queryId
		and NTNotificationQueryMapping.NTNotificationId = @notificationId
		Update dbo.NTNotificationQueryMapping
		set nextRunTime = cast('12/31/9999 23:59:59' as datetime)
		where NTNotificationQueryMapping.NtNotificationId = @notificationId
		and isScheduled = 1
		-- Subclients recently created within <hrVal,0,1,0,10> hrs
		-- <?xml version="1.0" encoding="UTF-16" standalone="no" ?><CVGui_QueryAdditionalInfo><queryParameters><queryParameters paramName="hrVal" value="10"/></queryParameters></CVGui_QueryAdditionalInfo>
		Update dbo.NTNotificationQueryMapping
		set queryParamDisplayString = dbo.GetQueryDisplayNameForNTRule(@notificationId)
		where NTNotificationQueryMapping.NtNotificationId = @notificationId
	end
if ( ((@alertTypeID=57 OR @alertTypeID=62)) Or (@alertTypeID=65))
	begin
		set @notifMsg = N''
		set @notifMsg = (SELECT
						case
							when messageFormatType = 1 then formatStringHtml
							else formatString
						end
						FROM NTmessageFormat where  NTnotificationID = @notificationID
and messageType = 1 and escalationLevel = 1)
		declare @tokenOrderTable table
		(
			tokenId bigint,
			indexPos	int,
			message nvarchar(max)
		)
		declare @messagesList table
		(
			message nvarchar(max),
			tokenId bigint
		)
		Insert into @tokenOrderTable
		SELECT distinct NTOKEN.tokenID,0,NULL
			FROM NTavailCriteria AS NTAC, NTAlertType as NTS,  NTmessageTokensForAlert NTOKEN
			WHERE
			NTAC.alertTypeId = NTS.id and NTOKEN.availcriteriaId = NTAC.id
			and NTS.id=@alertTypeID
		Insert into @messagesList
		select Message,MessageID
		from EvLocaleMsgs
		where MessageID in
		(
			select tokenid from @tokenOrderTable
		)
		and LocaleID=0
		update TOT
		set message = ML.message
		from @messagesList ML,
		@tokenOrderTable TOT
		where ML.tokenId = TOT.tokenId
		Update @tokenOrderTable
		set message = dbo.getHtmlEscapedString(message,@isHtmlEncoding)
		Update @tokenOrderTable
		set indexPos = patindex('%'+message+'%',@notifMsg)
		declare @variableBodyLen int
		declare @variableBodyString nvarchar(max)
set @variableBodyString = dbo.getHtmlEscapedString(dbo.fn_EvFormatEventMsgText(0,@locale,(950 | (CAST(POWER(2, 24) AS BIGINT) * 74)), 0,2),@isHtmlEncoding)
		set @variableBodyLen = patindex('%'+@variableBodyString+'%',@notifMsg)
		delete from @tokenOrderTable
		where indexPos = 0 or indexPos is null
		delete from NTRuleTokenOrdering
		where NTnotificationID = @notificationID
and messageType = 1 and escalationLevel = 1
		Insert into NTRuleTokenOrdering(NTnotificationID,messageType,escalationLevel,TokenId,TokenOrder)
select @notificationID,1,1,tokenId,
		RANK() over (order by indexpos asc)
		from @tokenOrderTable
	end
	--Set the creator of the Alert and assign him 'Alert Owner' role on the alert
	--'Alert Owner' Role contains all permissions in 'Alert' category except 'Create Alert'
	--This role also has'Change Security Settings' permission
	DECLARE @roleId INTEGER =0
	SET @roleId =ISNULL((SELECT id
                            FROM UMRoles
WHERE flags & 1 | 2 <> 0 and name like 'Alert Owner'),0)
EXEC sec_setCreatorForEntity @ownerId, @roleId, '', @errorCode OUTPUT, @errorString OUTPUT, 64, @notificationID
	set @errorCode = @@error
	if (@errorCode <> 0)
	BEGIN
		set @errorCode = @@error;
set @errorString = dbo.fn_EvFormatEventMsgText(0,@locale, (141 | (CAST(POWER(2, 24) AS BIGINT) * 74)), 0,2) + N' : ' + @alertName
	END
	ELSE
	BEGIN
set @errorString = dbo.fn_EvFormatEventMsgText(0,@locale, (160 | (CAST(POWER(2, 24) AS BIGINT) * 74)), 0,2) + N' : ' + @alertName
	END
	-- Check if its failover configuration alert and send workqueue request to all failover nodes.
	INSERT INTO APP_WorkQueueRequest (clientId, workToken, workTokenParams, createTime, lastUpdateTime, retryCount, flag, remoteClient)
	SELECT C.Id,
		@workTokenId,
		'',
		dbo.GetUnixTime(GetUTCDate()), 0, 0, 0, -1
		FROM SimInstalledPackages WITH (READUNCOMMITTED)
        INNER JOIN App_client C WITH (READUNCOMMITTED) on SimInstalledPackages.clientId = C.Id
AND (C.status&2)=0 and simPackageID IN (24, 1024)
		INNER JOIN NTAlertType WITH (READUNCOMMITTED) ON NTAlertType.ID = @alertTypeID
AND  ( NTAlertType.actionsAllowed & 1024 ) > 0
END
--		-- NOTIFICATION ALREADY EXISTS, SO THIS IS AN ERROR! ---  --
ELSE
BEGIN
	set @errorCode   = 1
set @errorString = dbo.fn_EvFormatEventMsgText(0,@locale, (159 | (CAST(POWER(2, 24) AS BIGINT) * 74)), 0,2) + N' : ' + @alertName
END
/*
-- FOLLOWING LINE FOR DEBUG ONLY!
select NTnotificationId, notificationName=convert(nvarchar(20), notificationName),MailBoxEnable,
     EmailEnable,  SnmpEnable, @reportCriteriaType, @reportCriteriaval from NTnotification
*/
CREATE_EXIT:
---------------------------------------------
-- THIS IS THE RESPONSE IF ALL WENT WELL ----
---------------------------------------------
if (@errorCode <> 0)
 BEGIN
SELECT	1			         as TAG,
		null		         as Parent,
	@errorCode			     as [CVGui_GenericResp!1!errorCode],
	@errorString	         as [CVGui_GenericResp!1!errorMessage]
FOR XML EXPLICIT
END
ELSE
SELECT	1			         as TAG,
		null		         as Parent,
	@notificationId		     as [CVGui_AlertCreateResp!1!alertId]
FOR XML EXPLICIT
if @isTranStarted =1
BEGIN
	if (@errorCode = 0)
		commit tran
	else
		rollback tran
END
EXEC sp_xml_removedocument @idoc
SET NOCOUNT OFF
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  END
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
GO

IF EXISTS (select * from GxQscripts where name = 'br_NTAlertCreate')
	delete from GxQscripts where name = 'br_NTAlertCreate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_NTAlertCreate')
	delete from GXDBVersions where aliasname = 'br_NTAlertCreate'
GO

insert into GXDBVersions values(2, 'br_NTAlertCreate',  '00010070001200190000', 'br_NTAlertCreate', '00010070001200190000')
GO

