

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/br_NTAdvisoryTypeUpdate.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/br_NTAdvisoryTypeUpdate.sp,v $ $Id: br_NTAdvisoryTypeUpdate.sp,v 1.5.60.1 2017/02/10 21:21:45 sjohnson Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   br_NTAdvisoryTypeUpdate -
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: br_NTAdvisoryTypeUpdate <<<'

IF EXISTS (select * from sysobjects where name='br_NTAdvisoryTypeUpdate')
	drop procedure br_NTAdvisoryTypeUpdate
IF EXISTS (select * from GxQscripts where name='br_NTAdvisoryTypeUpdate')
	delete from GxQscripts where name = 'br_NTAdvisoryTypeUpdate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_NTAdvisoryTypeUpdate')
	delete from GXDBVersions where aliasname = 'br_NTAdvisoryTypeUpdate'
GO
print '... Creating Procedure: br_NTAdvisoryTypeUpdate'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure br_NTAdvisoryTypeUpdate
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @ownerID int,
  @locale int,
  @xmlString varchar(MAX)
AS
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  BEGIN
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
SET NOCOUNT ON
DECLARE	@function				varchar(80)
SET		@function				= 'br_NTAdvisoryTypeUpdate'
DECLARE @brAlertTrace           varchar(256)
SET		@brAlertTrace               =(select value from gxglobalParam Where name = 'bralertTrace')
DECLARE @iDoc     				int
DECLARE @errorCode				int
SET		@errorCode				=0
DECLARE	@errorString			varchar(512)
SET		@errorString			=''
DECLARE	@capability int
SET		@capability				= 1				--'EV_SCHEDULE_ADMIN' (EvCapability.h) per defect 17813
----------------------------------------------------------
--	FETCH PARAMETERS FROM THE XML STRING PASSED IN	--
	exec br_ntTrace '.. br_NTAdvisoryTypeUpdate', 0, 0, 0, 0, @xmlString
exec sp_xml_preparedocument @iDoc OUTPUT, @xmlString
BEGIN TRY
	if object_id('tempdb.dbo.#advisoryWorkList') is not null
		DROP TABLE #advisoryWorkList
--  ----------------------------------------------------------------------------
--	For now, the only action we can take is to enable or disable the Advisory --
--  ----------------------------------------------------------------------------
	CREATE TABLE #advisoryWorkList
	(
		[advisoryId]       integer NOT NuLL,
		[enabled]  integer NOT NuLL
	)
	exec br_NTPermCheck @ownerId, @locale, @capability, 2018, 2, @errorCode OUTPUT, @errorString OUTPUT
	IF @errorCode <> 0
		goto CREATE_EXIT
	----------------------------------------------------
	--- Collect List of Advisories to Clear From XML ---
	----------------------------------------------------
	INSERT #advisoryWorkList
		SELECT advisoryId, enabled
		FROM OPENXML(@iDoc, 'CVGui_AlertSRMAdvisoryTypeUpdateReq/srmAsdvisoryTypes', 0)
			WITH (	advisoryId		integer		'./@advisoryId',
					enabled			integer		'./@enabled')
-- select step='Raw Table', * from #advisoryWorkList
--	---------------------------------------------------------------------------------
--	GATHERED ENOUGH INFORMATION, TIME TO START INSERTING SOME DATA TO THE TABLES! ---
--	---------------------------------------------------------------------------------
	UPDATE NTAdvisoryMsg
	SET flags = WL.enabled
	FROM NTAdvisoryMsg AS AM, #advisoryWorkList as WL
	WHERE AM.id = WL.advisoryId
--	----------------------------------------------------------------------
--	DELETE ANY "PENDING" ADVISORIES OF THE TYPE THAT WERE JUST DISABLED --
--	----------------------------------------------------------------------
	DELETE NTDetectedAlerts
	FROM NTDSRMAdvisory AS ADV, #AdvisoryWorkList AS WL, NTAdvisoryMsg AS AM
	WHERE
		WL.advisoryId				= AM.id
		AND ADV.NTadvisoryMsgId		= AM.id
		AND ADV.eventId				= NTDetectedAlerts.eventId
		AND  WL.enabled             = 0
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode	 = 1
	SET @errorString = 'Problems Executing [' + @function +'] Error Message [' + ERROR_MESSAGE() + '].'
END CATCH
CREATE_EXIT:
---------------------------------------------
-- THIS IS THE RESPONSE IF ALL WENT WELL ----
---------------------------------------------
DROP TABLE #advisoryWorkList
SELECT	1			         as TAG,
		NULL		         as Parent,
	@errorCode			     as [CVGui_GenericResp!1!errorCode],
	@errorString	         as [CVGui_GenericResp!1!errorMessage]
FOR XML EXPLICIT
EXEC sp_xml_removedocument @idoc
/* TEST CODE:
DECLARE @xml nvarchar(2048)
set @xml='<CVGui_AlertSRMAdvisoryTypeUpdateReq><srmAsdvisoryTypes advisoryId="9" advisoryType="10023" appTypeId="600" advisoryLevel="4" enabled="1" advisoryName="$Disk is not used$" /><srmAsdvisoryTypes advisoryId="7" advisoryType="10024" appTypeId="600" advisoryLevel="4" enabled="1" advisoryName="$Windows automatic updates are disabled$" /><srmAsdvisoryTypes advisoryId="13" advisoryType="10026" appTypeId="600" advisoryLevel="4" enabled="1" advisoryName="$Software Firewall might not be installed$" /></CVGui_AlertSRMAdvisoryTypeUpdateReq>'
exec br_NTAdvisoryTypeUpdate 1, 1, @xml
*/
SET NOCOUNT OFF
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  END
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
GO

IF EXISTS (select * from GxQscripts where name = 'br_NTAdvisoryTypeUpdate')
	delete from GxQscripts where name = 'br_NTAdvisoryTypeUpdate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_NTAdvisoryTypeUpdate')
	delete from GXDBVersions where aliasname = 'br_NTAdvisoryTypeUpdate'
GO

insert into GXDBVersions values(2, 'br_NTAdvisoryTypeUpdate',  '00010005006000010000', 'br_NTAdvisoryTypeUpdate', '00010005006000010000')
GO

