

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/br_NTAdvisoryTypeList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/br_NTAdvisoryTypeList.sp,v $ $Id: br_NTAdvisoryTypeList.sp,v 1.3.210.1 2018/03/27 08:03:08 jiechen Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   br_NTalertList   - Fetch the (short) list of currently defined alert
--                      notifications.
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: br_NTAdvisoryTypeList <<<'

IF EXISTS (select * from sysobjects where name='br_NTAdvisoryTypeList')
	drop procedure br_NTAdvisoryTypeList
IF EXISTS (select * from GxQscripts where name='br_NTAdvisoryTypeList')
	delete from GxQscripts where name = 'br_NTAdvisoryTypeList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_NTAdvisoryTypeList')
	delete from GXDBVersions where aliasname = 'br_NTAdvisoryTypeList'
GO
print '... Creating Procedure: br_NTAdvisoryTypeList'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure br_NTAdvisoryTypeList
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @localeId int,
  @appTypeId int,
  @enabledOnly int
AS
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  BEGIN
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
SET NOCOUNT ON
	SELECT	1			                as TAG,
		NuLL			                as Parent,
		NuLL			                as [CVGui_AlertSRMAdvisoryTypeListResp!1],
		NuLL							as [srmAsdvisoryTypes!2!advisoryId],
		NuLL							as [srmAsdvisoryTypes!2!advisoryType],
		NuLL							as [srmAsdvisoryTypes!2!appTypeId],
		NuLL							as [srmAsdvisoryTypes!2!advisoryLevel],
		NuLL							as [srmAsdvisoryTypes!2!enabled],
		NuLL							as [srmAsdvisoryTypes!2!advisoryName]
	UNION ALL
	----------------------------------
	---- ALERT INFO ----
	----------------------------------
	SELECT	2, 1, NuLL,
			AD.id, criteriaId, compType, level, flags,  dbo.fn_EvFormatEventMsgText(0 ,@localeId, CR.nameId, 0,2)
			FROM NTAdvisoryMsg AS AD, NTCriteria AS CR
			WHERE
				AD.criteriaId = CR.id
				AND AD.id > 0
				AND AD.msgType = 1
				AND AD.compType = @appTypeId
				AND @appTypeId <> 0
				AND (AD.flags <> 0 OR @enabledOnly = 0)
	UNION ALL
	SELECT	2, 1, NuLL,
			AD.id, criteriaId, compType, level, flags,  dbo.fn_EvFormatEventMsgText(0 ,@localeId, CR.nameId, 0,2)
			FROM NTAdvisoryMsg AS AD, NTCriteria AS CR
			WHERE
				AD.criteriaId = CR.id
				AND AD.id > 0
				AND AD.msgType = 1
				AND @appTypeId = 0
				AND (AD.flags <> 0 OR @enabledOnly = 0)
	ORDER BY [srmAsdvisoryTypes!2!appTypeId], [srmAsdvisoryTypes!2!advisoryType]
	FOR XML EXPLICIT
--		order by criteriaId, compType
SET NOCOUNT OFF
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  END
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
GO

IF EXISTS (select * from GxQscripts where name = 'br_NTAdvisoryTypeList')
	delete from GxQscripts where name = 'br_NTAdvisoryTypeList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_NTAdvisoryTypeList')
	delete from GXDBVersions where aliasname = 'br_NTAdvisoryTypeList'
GO

insert into GXDBVersions values(2, 'br_NTAdvisoryTypeList',  '00010003021000010000', 'br_NTAdvisoryTypeList', '00010003021000010000')
GO

