

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/br_NTAdvisorySyncSource.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/br_NTAdvisorySyncSource.sp,v $ $Id: br_NTAdvisorySyncSource.sp,v 1.5.60.1 2017/02/10 21:21:45 sjohnson Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   br_NTAdvisorySyncSource - Sync Advisories
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: br_NTAdvisorySyncSource <<<'

IF EXISTS (select * from sysobjects where name='br_NTAdvisorySyncSource')
	drop procedure br_NTAdvisorySyncSource
IF EXISTS (select * from GxQscripts where name='br_NTAdvisorySyncSource')
	delete from GxQscripts where name = 'br_NTAdvisorySyncSource'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_NTAdvisorySyncSource')
	delete from GXDBVersions where aliasname = 'br_NTAdvisorySyncSource'
GO
print '... Creating Procedure: br_NTAdvisorySyncSource'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure br_NTAdvisorySyncSource
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @ownerID int,
  @locale int,
  @xmlString varchar(MAX)
AS
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  BEGIN
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
SET NOCOUNT ON
DECLARE	@function				varchar(80)
SET		@function				= 'br_NTAdvisorySyncSource'
DECLARE @brAlertTrace           varchar(256)
SET		@brAlertTrace               =(select value from gxglobalParam Where name = 'bralertTrace')
DECLARE @iDoc     				int
DECLARE @errorCode				int
SET		@errorCode				=0
DECLARE	@errorString			varchar(512)
SET		@errorString			=''
--- EXTRACT FROM REQUEST XML INTO THESE ---
DECLARE @syncTime				integer
DECLARE @recursive				integer
DECLARE @sourceRDN				nvarchar(2048)
DECLARE @sourceRDNcompare		nvarchar(2048)
DECLARE	@nowDate				datetime
SET		@nowDate				=getDate()
----------------------------------------------------------
--	FETCH PARAMETERS FROM THE XML STRING PASSED IN	--
----------------------------------------------------------
if @brAlertTrace <> 0
	exec br_ntTrace '.. br_NTAdvisorySyncSource', 0, @nowDate, 0, 0, @xmlString
exec sp_xml_preparedocument @iDoc OUTPUT, @xmlString
BEGIN TRY
	if object_id('tempdb.dbo.#advisoryWorkList') is not null
		DROP TABLE #advisoryWorkList
	CREATE TABLE #advisoryWorkList
	(
		[advisoryId]       integer NOT NuLL,
		[advisoryType]  integer NOT NuLL
	)
	set @recursive = (select * from OPENXML(@iDoc, 'CVGui_SyncSRMSourceAdvisories', 0)
                 WITH (recursive integer '@recursive'))
	set @syncTime = (select * from OPENXML(@iDoc, 'CVGui_SyncSRMSourceAdvisories', 0)
                 WITH (syncTime integer '@syncTime'))
	set @sourceRDN = (select * from OPENXML(@iDoc, 'CVGui_SyncSRMSourceAdvisories', 0)
                 WITH (sourceRDN nvarchar(2048) '@sourceRDN'))
    IF @recursive <> 0
		SET @sourceRDNcompare = @sourceRDN+'%'
	ELSE
		SET @sourceRDNcompare = @sourceRDN
--	select step='debug', clientId=@clientId, syncTime=@synctime
	----------------------------------------------------
	--- Collect List of Advisories to Clear From XML ---
	----------------------------------------------------
	INSERT #advisoryWorkList
		SELECT AM.id, advisoryType
		FROM OPENXML(@iDoc, 'CVGui_SyncSRMSourceAdvisories/advisoryTypes', 0)
			WITH (	advisoryId			integer './@advisoryId',
					advisoryType	integer './@advisoryType') AS INLIST, NTadvisoryMsg As AM
			WHERE AM.criteriaId = INLIST.advisoryType
--	SELECT step='debug 01', * FROM #advisoryWorkList
	--------------------------------------------------------------------------------------
	---  GATHERED ENOUGH INFORMATION, TIME TO START CLEANING UP SOME TABLES!			--
	--------------------------------------------------------------------------------------
	DELETE  NTDetectedAlerts
	FROM NTDetectedAlerts AS NT, #advisoryWorkList as WL, NTDsrmAdvisory AS DS
	Where DS.NTAdvisoryMsgId = WL.AdvisoryId
	  AND DS.eventId = NT.eventId
--	  AND DS.initialOccurence <= @syncTime
	  AND DS.latestOccurence < @syncTime
	  AND DS.sourceRDN like @sourceRDNcompare
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode	 = 1
	SET @errorString = 'Problems Executing [' + @function +'] Error Message [' + ERROR_MESSAGE() + '].'
END CATCH
CREATE_EXIT:
---------------------------------------------
-- THIS IS THE RESPONSE IF ALL WENT WELL ----
---------------------------------------------
DROP TABLE #advisoryWorkList
SELECT	1			         as TAG,
		NULL		         as Parent,
	@errorCode			     as [CVGui_GenericResp!1!errorCode],
	@errorString	         as [CVGui_GenericResp!1!errorMessage]
FOR XML EXPLICIT
EXEC sp_xml_removedocument @idoc
/* TEST CODE:
declare @xml varchar(max)
set @xml= '<?xml version="1.0" encoding="UTF-8" standalone="no" ?><CVGui_SyncSRMSourceAdvisories clientId="0" recursive="1" sourceRDN="source RDN for Client[0], AppType [54760475]" syncTime="1207690111" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:noNamespaceSchemaLocation="CVGui_SyncSRMSourceAdvisoriesType.xsd"><advisoryTypes advisoryId="0" advisoryLevel="0" advisoryName="" advisoryType="10012" appTypeId="0" enabled="0"/><advisoryTypes advisoryId="0" advisoryLevel="0" advisoryName="" advisoryType="10015" appTypeId="0" enabled="0"/></CVGui_SyncSRMSourceAdvisories>'
exec br_NTAdvisorySyncSource -10, 0, @xml
*/
SET NOCOUNT OFF
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  END
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
GO

IF EXISTS (select * from GxQscripts where name = 'br_NTAdvisorySyncSource')
	delete from GxQscripts where name = 'br_NTAdvisorySyncSource'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_NTAdvisorySyncSource')
	delete from GXDBVersions where aliasname = 'br_NTAdvisorySyncSource'
GO

insert into GXDBVersions values(2, 'br_NTAdvisorySyncSource',  '00010005006000010000', 'br_NTAdvisorySyncSource', '00010005006000010000')
GO

