

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/br_NTAdvisorySyncClient.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/br_NTAdvisorySyncClient.sp,v $ $Id: br_NTAdvisorySyncClient.sp,v 1.6.60.1 2017/02/10 21:21:45 sjohnson Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   br_NTAdvisorySyncClient - Create the new alert definition
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: br_NTAdvisorySyncClient <<<'

IF EXISTS (select * from sysobjects where name='br_NTAdvisorySyncClient')
	drop procedure br_NTAdvisorySyncClient
IF EXISTS (select * from GxQscripts where name='br_NTAdvisorySyncClient')
	delete from GxQscripts where name = 'br_NTAdvisorySyncClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_NTAdvisorySyncClient')
	delete from GXDBVersions where aliasname = 'br_NTAdvisorySyncClient'
GO
print '... Creating Procedure: br_NTAdvisorySyncClient'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure br_NTAdvisorySyncClient
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @ownerID int,
  @locale int,
  @xmlString varchar(MAX)
AS
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  BEGIN
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
SET NOCOUNT ON
DECLARE	@function				varchar(80)
SET		@function				= 'br_NTAdvisorySyncClient'
DECLARE @brAlertTrace           varchar(256)
SET		@brAlertTrace               =(select value from gxglobalParam Where name = 'bralertTrace')
DECLARE @iDoc     				int
DECLARE @errorCode				int
SET		@errorCode				=0
DECLARE	@errorString			varchar(512)
SET		@errorString			=''
DECLARE @clientId				integer
DECLARE @syncTime				integer
DECLARE	@nowDate				datetime
SET		@nowDate				=getDate()
----------------------------------------------------------
--	FETCH PARAMETERS FROM THE XML STRING PASSED IN	--
----------------------------------------------------------
if @brAlertTrace <> 0
	exec br_ntTrace '.. br_NTAdvisorySyncClient', 0, @nowDate, 0, 0, @xmlString
exec sp_xml_preparedocument @iDoc OUTPUT, @xmlString
BEGIN TRY
	if object_id('tempdb.dbo.#advisoryWorkList') is not null
		DROP TABLE #advisoryWorkList
	CREATE TABLE #advisoryWorkList
	(
		[advisoryId]       integer NOT NuLL,
		[advisoryType]  integer NOT NuLL
	)
	set @clientId = (select * from OPENXML(@iDoc, 'CVGui_SyncSRMClientAdvisories', 0)
                 WITH (clientId integer '@clientId'))
	set @syncTime = (select * from OPENXML(@iDoc, 'CVGui_SyncSRMClientAdvisories', 0)
                 WITH (syncTime integer '@syncTime'))
--	select step='debug', clientId=@clientId, syncTime=@synctime
	----------------------------------------------------
	--- Collect List of Advisories to Clear From XML ---
	----------------------------------------------------
	INSERT #advisoryWorkList
		SELECT AM.id, advisoryType
		FROM OPENXML(@iDoc, 'CVGui_SyncSRMClientAdvisories/advisoryTypes', 0)
			WITH (	advisoryId			integer './@advisoryId',
					advisoryType	integer './@advisoryType') AS INLIST, NTadvisoryMsg As AM
			WHERE AM.criteriaId = INLIST.advisoryType
--	SELECT step='debug 01', * FROM #advisoryWorkList
	--------------------------------------------------------------------------------------
	---  GATHERED ENOUGH INFORMATION, TIME TO START CLEANING UP SOME TABLES!			--
	--------------------------------------------------------------------------------------
	DELETE  NTDetectedAlerts
	FROM NTDetectedAlerts AS NT, #advisoryWorkList as WL, NTDsrmAdvisory AS DS
	Where DS.NTAdvisoryMsgId	= WL.AdvisoryId
	  AND DS.eventId			= NT.eventId
--	  AND DS.initialOccurence <= @syncTime
	  AND DS.latestOccurence	< @syncTime
	  AND DS.clientId			= @clientId
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode	 = 1
	SET @errorString = 'Problems Executing [' + @function +'] Error Message [' + ERROR_MESSAGE() + '].'
END CATCH
CREATE_EXIT:
---------------------------------------------
-- THIS IS THE RESPONSE IF ALL WENT WELL ----
---------------------------------------------
DROP TABLE #advisoryWorkList
SELECT	1			         as TAG,
		NULL		         as Parent,
	@errorCode			     as [CVGui_GenericResp!1!errorCode],
	@errorString	         as [CVGui_GenericResp!1!errorMessage]
FOR XML EXPLICIT
EXEC sp_xml_removedocument @idoc
/* TEST CODE:
DECLARE @xmlString varchar(MAX)
Set @xmlString ='<?xml version="1.0" encoding="UTF-8" standalone="no" ?><CVGui_SyncSRMClientAdvisories clientId="2" syncTime="1207142712" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:noNamespaceSchemaLocation="CVGui_SyncSRMClientAdvisoriesType.xsd"><advisoryTypes advisoryId="0" advisoryLevel="0" advisoryName="" advisoryType="10012" appTypeId="0" enabled="0"/><advisoryTypes advisoryId="0" advisoryLevel="0" advisoryName="" advisoryType="10015" appTypeId="0" enabled="0"/></CVGui_SyncSRMClientAdvisories>'
exec br_NTAdvisorySyncClient -10, 0, @xmlString
*/
SET NOCOUNT OFF
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  END
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
GO

IF EXISTS (select * from GxQscripts where name = 'br_NTAdvisorySyncClient')
	delete from GxQscripts where name = 'br_NTAdvisorySyncClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_NTAdvisorySyncClient')
	delete from GXDBVersions where aliasname = 'br_NTAdvisorySyncClient'
GO

insert into GXDBVersions values(2, 'br_NTAdvisorySyncClient',  '00010006006000010000', 'br_NTAdvisorySyncClient', '00010006006000010000')
GO

